<?php
ob_start();

date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";
?>
<html>
    <head>
        <title> Relatório </title>
        <style>

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

            .page {
                width: 21cm;
                min-height: 29.7cm;
                padding: 2cm;
                margin: 1cm auto;
                border: 1px #D3D3D3 solid;
                border-radius: 5px;
                background: white;
                box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
            }
        </style>
        <?php

        function buscaGrupo($valor) {
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'estoqueprodutos');
            $sql = "SELECT * from grupos where sequencia = '$valor'";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, false);
            return $dados->descricao;
        }

        if ($_POST['gerar'] != 'PDF') :
            ?>
            <link href="../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
            <?php
        endif;
        ?>
    </head>
    <body>

        <div align="center">
            PRODUTOS MAIS VENDIDOS
            <Br/> 
            PERÍODO: <?= $_POST['datai'] ?> À <?= $_POST['dataf'] ?>
            <?php
            if (!empty($_POST['grupo'])) :
                ?>
                <br/>
                GRUPO : <?= $_POST['grupo'] ?> - <?= buscaGrupo($_POST['grupo']) ?>
                <?php
            endif;
            ?>
        </div>

        <?php require_once './cabecalho.php'; ?>

        <?php

        function CalculaP($valor, $total) {
            $valor1 = $valor / $total;
            $porcentagem = $valor1 * 100;

//    return number_format($porcentagem, 2, ',', '');
            return $porcentagem;
        }

        function CalculaPCusto($valor, $total) {
            $valor1 = $valor / $total;
            $porcentagem = $valor1 * 100;

//    return number_format($porcentagem, 2, ',', '');
            return $porcentagem * -1;
        }

        function Classificao($porc) {
            if ($porc < 80) :
                return 'A';
            elseif ($porc < 95) :
                return 'B';
            else :
                return 'C';
            endif;
        }

        function BuscaVariacaoDesccuva($prod, $variacao, $sigla, $nivel) {
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'estoqueprodutos');
            $sql = "SELECT produtos.variacao, produtos.codigo, 
                    variacao.variacaoid, variacao.var1, variacao.var2, 
                    variacao.var3 ,
                    itensvariacao.variacao, itensvariacao.sigla,
                    itensvariacao.descricao, itensvariacao.nivel
                    FROM produtos 
                    INNER JOIN variacao ON produtos.variacao = variacao.variacaoid 
                    INNER JOIN itensvariacao ON itensvariacao.variacao = variacao.variacaoid                   
                    WHERE codigo = '$prod' 
                    AND itensvariacao.nivel = '$nivel'
                    AND itensvariacao.sigla = '$sigla'";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

            return $dados->descricao;
        }

        $data_incio1 = mktime(0, 0, 0, date('m'), 1, date('Y'));
        $data_fim1 = mktime(23, 59, 59, date('m'), date("t"), date('Y'));
        $inicio1 = parseDate($_POST['datai'], "Y-m-d");
        $fim1 = parseDate($_POST['dataf'], "Y-m-d");

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'cliente');
        $data = date("d/m");
        $sql = 'select movimentacao.documento, movimentacao.data, movimentacao.tipo, 
            movimentacao.situacao, movimentacao.finalizado, 
    movimentacao.empresa, itmovimentacao.documento, itmovimentacao.preco,  itmovimentacao.cancelado,
    sum(itmovimentacao.quantidade) as qtd, 
    sum(itmovimentacao.quantidade) * itmovimentacao.preco as total,
    itmovimentacao.produto,';
        if (!empty($_POST['grupo'])) :
            $sql .= ' grupoprodutos.produto, grupoprodutos.grupo,';
        endif;
        $sql .= 'estoqueprodutos.produto as prod, estoqueprodutos.codproduto, 
    estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
    produtos.codigo, produtos.descricao, produtos.custo,  produtos.fornecedor,  produtos.marca,  produtos.categoria, produtos.ref from movimentacao 
    INNER JOIN itmovimentacao ON itmovimentacao.documento = movimentacao.documento 
    INNER JOIN estoqueprodutos ON estoqueprodutos.codproduto = itmovimentacao.produto 
    INNER JOIN produtos ON produtos.codigo = estoqueprodutos.produto';
        if (!empty($_POST['grupo'])) :
            $sql .= ' LEFT JOIN grupoprodutos ON produtos.codigo = grupoprodutos.produto';
        endif;
        $sql .= ' where 
    str_to_date(data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '" 
        and itmovimentacao.cancelado <> "S"
        and movimentacao.situacao <> "C"
        and movimentacao.tipo <> "D"
        ';

        if ($_POST['empresa'] != 'T') :
            $sql .= " AND empresa = '" . $_POST['empresa'] . "'";
        endif;

        if (!empty($_POST['marca'])) :
            $sql .= ' AND marca = "' . $_POST['marca'] . '" ';
        endif;

        if (!empty($_POST['fornecedor'])) :
            $sql .= ' AND fornecedor = "' . $_POST['fornecedor'] . '" ';
        endif;

        if (!empty($_POST['categoria'])) :
            $sql .= ' AND categoria = "' . $_POST['categoria'] . '" ';
        endif;

        if (!empty($_POST['grupo'])) :
            $grupo = str_replace('.00', '', $_POST['grupo']);
            $sql .= ' AND grupoprodutos.grupo like "' . $grupo . '%" ';
        endif;

        if ($_POST['agrupar'] == 'N') :
            $sql .= ' GROUP by itmovimentacao.produto ';

        else :
            $sql .= ' GROUP by produtos.' . $_POST['agrupar'] . '  ';
        endif;

        if ($_POST['ordenar'] === 'F') :
            $sql .= ' ORDER BY total DESC';
        else :
            $sql .= ' ORDER BY qtd DESC';
        endif;
//        echo $sql;
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

        $total = 0;
        foreach ($dados as $dadost) :
            $total = $total + $dadost->total;
        endforeach;
//print_r($dados);
        ?>

        <table class="table table-condensed text-center" style="font-size: 12px; width: 100%; text-align: left">
            <tr>
                <td><b>Código</b></td>
                <td><b>Ref</b></td>
                <td><b>Descrição</b></td>
                <?php
                if ($_POST['agrupar'] == 'N') :
                    if ($parametros->grade === 'S') :
                        ?>
                        <td><b>Var 1</b></td>
                        <td><b>Var 2</b></td>
                        <td><b>Var 3</b></td>
                        <?php
                    endif;
                endif;
                ?>
                <td><b>QTD Vendas</b></td>
                <td><b>Preço Médio Custo</b></td>
                <td><b>Preço Médio Venda</b></td>
                <td><b>Valor Total</b></td>
                <td><b>Custo Total</b></td>
                <td><b>% Lucro</b></td>
                <td><b>% Faturado</b></td>

            </tr>
            <?php
            $panterior = 0;
            $tqtd = 0;
            $ttotal = 0;
            $tcusto = 0;
            foreach ($dados as $dados) :
                $acumulada = CalculaP($dados->total, $total) + $panterior;
                $classificao = Classificao($acumulada);
                ?>
                <tr>
                    <?php
                    if ($_POST['agrupar'] == 'N') :
                        $produtoa = $dados->codproduto;
                    else :
                        $produtoa = $dados->codigo;
                    endif;
                    ?>
                    <td><?= $produtoa ?></td>
                    <td><?= $dados->ref ?></td>
                    <td> <?= $dados->descricao ?></td>
                    <?php
                    if ($_POST['agrupar'] == 'N') :
                        if ($parametros->grade === 'S') :
                            ?>
                            <td><?= $dados->var1 . ' - ' . BuscaVariacaoDesccuva($dados->prod, '1', $dados->var1, '1') ?></td>
                            <td><?= $dados->var2 . ' - ' . BuscaVariacaoDesccuva($dados->prod, '2', $dados->var2, '2') ?></td>
                            <td><?= $dados->var3 . ' - ' . BuscaVariacaoDesccuva($dados->prod, '3', $dados->var3, '3') ?></td>
                            <?php
                        endif;
                    endif;
                    ?>

                    <td><?php
                        $tqtd = $tqtd + $dados->qtd;
                        $ttotal = $ttotal + $dados->total;
                        $totalcusto = ($dados->custo * $dados->qtd) - $dados->total;
                        $tcusto = $tcusto + ($dados->custo * $dados->qtd);
                        if (floor($dados->qtd) != $dados->qtd) :
                            echo $dados->qtd;
                        else :
                            echo intval($dados->qtd);
                        endif;
                        ?></td>
                    <td>R$ <?= number_format($dados->custo, 2, ',', '') ?></td>
                    <td>R$ <?= number_format($dados->total / $dados->qtd, 2, ',', '') ?></td>
                    <td>R$ <?= number_format($dados->total, 2, ',', '') ?></td>
                    <td>R$ <?= number_format($dados->custo * $dados->qtd, 2, ',', '') ?></td>                   
                    <td><?= number_format(CalculaPCusto($totalcusto, $dados->total), 2, ',', '') ?> %</td>        
                    <td><?= number_format(CalculaP($dados->total, $total), 2, ',', '') ?> %</td>        
                </tr>
                <?php
                $panterior = CalculaP($dados->total, $total) + $panterior;
            endforeach;
            ?>


            <tr>
                <?php
                if ($_POST['agrupar'] == 'N') :
                    if ($parametros->grade === 'S') :
                        ?>
                        <td colspan="6"><hr/> TOTAIS</td>
                        <?php
                    else :
                        ?>
                        <td colspan="3"> <hr/>  TOTAIS</td>
                    <?php
                    endif;
                else :
                    ?>
                    <td colspan="3"> <hr/>  TOTAIS</td>
                <?php
                endif;
                ?>
                <td> <hr/> <?= number_format($tqtd, 2, ',', '') ?></td>
                <td> <hr/>  </td>             
                <td> <hr/>  R$ <?= number_format($ttotal, 2, ',', '') ?></td>
                <td> <hr/>  R$ <?= number_format($tcusto, 2, ',', '') ?></td>
                <td> <hr/> <?= number_format(CalculaPCusto($tcusto - $ttotal, $ttotal), 2, ',', '') ?> %</td>
                <td> <hr/>  <?= number_format($panterior, 2, ',', '') ?> %</td>
            </tr>

        </table>


    </body>
</html>
<?php
if ($_POST['gerar'] == 'PDF') :
    $file = 'relatorio.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
endif;
?>