<?php
ob_start();
date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";

function buscaGrupo($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from temp_maisvendidos where codigo = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, true);

    $total = count($dados);
    return $total;
}

function Grupo($produtoId) {
    static $cache = [];
    if (!isset($cache[$produtoId])) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT grupoprodutos.produto, grupoprodutos.grupo, grupos.sequencia, grupos.descricao FROM grupoprodutos
INNER JOIN grupos ON grupoprodutos.grupo = grupos.sequencia 
WHERE produto = '" . $produtoId . "' and grupoprodutos.grupo <> '' LIMIT 1";
        $arrayParam = '';
        $grupo = $crud->getSQLGeneric($sql, $arrayParam, false);
        $cache[$produtoId] = $grupo->sequencia;
    }
    return $cache[$produtoId];
}

function GrupoDesc($produtoId) {
    static $cache = [];
    if (!isset($cache[$produtoId])) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT * from grupos where sequencia = '$produtoId'";
        $arrayParam = '';
        $grupo = $crud->getSQLGeneric($sql, $arrayParam, false);
        $cache[$produtoId] = $grupo->descricao;
    }
    return $cache[$produtoId];
}

function Fornecedor($produtoId) {
    static $cache = [];
    if (!isset($cache[$produtoId])) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT * from fornecedor where fornecedorid = '$produtoId'";
        $arrayParam = '';
        $grupo = $crud->getSQLGeneric($sql, $arrayParam, false);
        $cache[$produtoId] = $grupo->xNome;
    }
    return $cache[$produtoId];
}

function BuscaEmpresa($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from emitente where emitenteid = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->xNome;
}

function VerificaItem($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from temp_maisvendidos where codproduto = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, true);
    return count($dados);
}

function VerificaGrupo($produto, $grupo) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from grupoprodutos where grupo like '" . $grupo . "%' AND produto = '$produto'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, true);
    $total = count($dados);
//    echo $sql;
    return $total;
}

function CalculaP($valor, $total) {
    $valor1 = $valor / $total;
    $porcentagem = $valor1 * 100;

//    return number_format($porcentagem, 2, ',', '');
    return $porcentagem;
}

function CalculaPCusto($valor, $total) {
    if ($valor < 0) :
        return '0,00';
    else :
        $valor1 = $valor / $total;
        $porcentagem = $valor1 * 100;

//    return number_format($porcentagem, 2, ',', '');
        return $porcentagem;
    endif;
}

function Classificao($porc) {
    if ($porc < 80) :
        return 'A';
    elseif ($porc < 95) :
        return 'B';
    else :
        return 'C';
    endif;
}

function BuscaVariacaoDesccuva($prod, $variacao, $sigla, $nivel) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT produtos.variacao, produtos.codigo, 
                    variacao.variacaoid, variacao.var1, variacao.var2, 
                    variacao.var3 ,
                    itensvariacao.variacao, itensvariacao.sigla,
                    itensvariacao.descricao, itensvariacao.nivel
                    FROM produtos 
                    INNER JOIN variacao ON produtos.variacao = variacao.variacaoid 
                    INNER JOIN itensvariacao ON itensvariacao.variacao = variacao.variacaoid                   
                    WHERE codigo = '$prod' 
                    AND itensvariacao.nivel = '$nivel'
                    AND itensvariacao.sigla = '$sigla'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->descricao;
}

//print_r($_POST['empresa']);
$empresabusca = '';

$empresa = $_POST['empresa'][0];
if (count($_POST['empresa']) > 1) :
    $empresa = 'T';
endif;

for ($index = 0; $index < count($_POST['empresa']); $index++) :
    $empresabusca .= $_POST['empresa'][$index];
    $empresabusca .= ',';
endfor;

$empresabusca = substr($empresabusca, 0, -1);

//echo $empresa;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');
$sql = "DELETE FROM temp_maisvendidos";
if ($empresa !== 'T') :
    $sql .= " where empresa = '" . $_POST['empresa'][0] . "'";
endif;
$deletetemp = $crud->Sql($sql);

$data_incio1 = mktime(0, 0, 0, date('m'), 1, date('Y'));
$data_fim1 = mktime(23, 59, 59, date('m'), date("t"), date('Y'));
$inicio1 = parseDate($_POST['datai'], "Y-m-d");
$fim1 = parseDate($_POST['dataf'], "Y-m-d");

//SAIDA
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');
$data = date("d/m");
$sql = 'select movimentacao.documento, movimentacao.data, movimentacao.tipo, movimentacao.vendedor,
            movimentacao.situacao, movimentacao.finalizado, movimentacao.operacao, 
    movimentacao.empresa, itmovimentacao.documento as docitmov, itmovimentacao.preco,  itmovimentacao.cancelado,
    sum(itmovimentacao.quantidade) as qtd, 
    sum(itmovimentacao.quantidade) * itmovimentacao.preco as total,
    sum(itmovimentacao.valorliquido) as totalvendas,
    sum(itmovimentacao.desc_rateio)  as totaldesconto,
    sum(itmovimentacao.acrescimo)  as totalacrescimo,
    itmovimentacao.produto,';
//        if (!empty($_POST['grupo'])) :
//            $sql .= ' grupoprodutos.produto, grupoprodutos.grupo,';
//        endif;
$sql .= 'estoqueprodutos.produto as prod, estoqueprodutos.codproduto, 
    estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
    produtos.codigo, produtos.descricao, produtos.custo,  produtos.fornecedor, 
    produtos.marca,  produtos.categoria, produtos.ref from movimentacao 
    INNER JOIN itmovimentacao ON itmovimentacao.documento = movimentacao.documento 
    INNER JOIN estoqueprodutos ON estoqueprodutos.codproduto = itmovimentacao.produto 
    INNER JOIN produtos ON produtos.codigo = estoqueprodutos.produto';
//        if (!empty($_POST['grupo'])) :
//            $sql .= ' INNER JOIN grupoprodutos ON produtos.codigo = grupoprodutos.produto';
//        endif;
$sql .= ' where 
    str_to_date(data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '" 
        and itmovimentacao.cancelado <> "S"
        and movimentacao.situacao = "F"
        and movimentacao.tipo <> "R"
        ';

$sql .= " AND movimentacao.empresa IN($empresabusca)";

if (!empty($_POST['marca'])) :
    $sql .= ' AND marca = "' . $_POST['marca'] . '" ';
endif;

if (!empty($_POST['fornecedor'])) :
    $sql .= ' AND fornecedor = "' . $_POST['fornecedor'] . '" ';
endif;

if (!empty($_POST['vendedor'])) :
    $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
endif;

if (!empty($_POST['categoria'])) :
    $sql .= ' AND categoria = "' . $_POST['categoria'] . '" ';
endif;

if (!empty($_POST['operacao'])) :
    if ($_POST['operacao'] != 'T') :
        $sql .= ' AND operacao = "' . $_POST['operacao'] . '" ';
    endif;
endif;

if (!empty($_POST['produtos'])) :
    $sql .= " AND codigo = '" . $_POST['produtos'] . "' ";
endif;

if ($_POST['agrupar'] == 'N') :
    $sql .= ' GROUP by itmovimentacao.produto ';

else :
    $sql .= ' GROUP by produtos.' . $_POST['agrupar'] . '  ';
endif;

if ($_POST['ordenar'] === 'F') :
    $sql .= ' ORDER BY total DESC';
else :
    $sql .= ' ORDER BY qtd DESC';
endif;
//echo $sql;
//echo '<br/>';
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$total = 0;
foreach ($dados as $dadost) :
    $total = $total + $dadost->total;
endforeach;

$panterior = 0;
$tqtd = 0;
$ttotal = 0;
$tcusto = 0;
$gera = 'S';
foreach ($dados as $dados) :
    $grupop = Grupo($dados->codigo);
    if (!empty($_POST['grupo'])) :
        $tgrupo = 0;
        $grupo = str_replace('.00', '', $_POST['grupo']);
        $tgrupo = VerificaGrupo($dados->codigo, $grupo);
        if ($tgrupo > 0) :
            $gera = 'S';
        else :
            $gera = 'N';
        endif;
    endif;

    if ($gera == 'S') :

        if ($_POST['agrupar'] == 'N') :
            $produtoa = $dados->codproduto;
            $sql = "INSERT INTO temp_maisvendidos(fornecedor, empresa, codigo, codproduto, ref, descricao,
                        var1, var2, var3, saida, devolucao, grupo, totalvendas, totaldesconto, totalacrescimo, totaldevolucoes, totalcusto)
                        VALUES('$dados->fornecedor', '$empresa', '$produtoa', '$produtoa', '$dados->ref', '$dados->descricao',
                          '$dados->var1', '$dados->var2', '$dados->var3', '$dados->qtd', '0', '$grupop',
                              '$dados->totalvendas', '$dados->totaldesconto', '$dados->totalacrescimo', '0', '$dados->custo')";
        else :
            $produtoa = $dados->codigo;
            $sql = "INSERT INTO temp_maisvendidos(fornecedor,empresa, codigo, codproduto, ref, descricao,
                        var1, var2, var3, saida, devolucao, grupo, totalvendas, totaldesconto, totalacrescimo, totaldevolucoes, totalcusto)
                        VALUES('$dados->fornecedor', '$empresa', '$produtoa', '$produtoa', '$dados->ref', '$dados->descricao',
                          '', '', '', '$dados->qtd', '0', '$grupop', '$dados->totalvendas', '$dados->totaldesconto', '$dados->totalacrescimo', '0', '$dados->custo')";
        endif;

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'precoprodutos');

        $endereco = $crud->Sql($sql);

    endif;
endforeach;

//TROCA
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');
$data = date("d/m");
$sql = 'select movimentacao_troca.documento, movimentacao_troca.data, movimentacao_troca.tipo, 
            movimentacao_troca.situacao, movimentacao_troca.finalizado, movimentacao_troca.vendedor,
    movimentacao_troca.empresa, itmovimentacao_troca.documento, itmovimentacao_troca.preco,  itmovimentacao_troca.cancelado,
    itmovimentacao_troca.operacao, itmovimentacao_troca.valorliquido,
    sum(itmovimentacao_troca.quantidade) as qtd, 
    sum(itmovimentacao_troca.quantidade) * itmovimentacao_troca.preco as total,
    sum(itmovimentacao_troca.valorliquido) as totalvendas,
    sum(itmovimentacao_troca.desc_rateio) as totaldesconto,
    sum(itmovimentacao_troca.acrescimo) as totalacrescimo,
    itmovimentacao_troca.produto,';
//        if (!empty($_POST['grupo'])) :
//            $sql .= ' grupoprodutos.produto, grupoprodutos.grupo,';
//        endif;
$sql .= 'estoqueprodutos.produto as prod, estoqueprodutos.codproduto, 
    estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
    produtos.codigo, produtos.descricao, produtos.custo,  produtos.fornecedor, 
    produtos.marca,  produtos.categoria, produtos.ref from movimentacao_troca 
    INNER JOIN itmovimentacao_troca ON itmovimentacao_troca.documento = movimentacao_troca.documento 
    INNER JOIN estoqueprodutos ON estoqueprodutos.codproduto = itmovimentacao_troca.produto 
    INNER JOIN produtos ON produtos.codigo = estoqueprodutos.produto';
//        if (!empty($_POST['grupo'])) :
//            $sql .= ' INNER JOIN grupoprodutos ON produtos.codigo = grupoprodutos.produto';
//        endif;
$sql .= ' where 
    str_to_date(data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '" 
        and itmovimentacao_troca.cancelado <> "S"
        and movimentacao_troca.situacao = "F"
        and movimentacao_troca.tipo <> "D"
        ';

$sql .= " AND movimentacao_troca.empresa IN($empresabusca)";

if (!empty($_POST['marca'])) :
    $sql .= ' AND marca = "' . $_POST['marca'] . '" ';
endif;

if (!empty($_POST['fornecedor'])) :
    $sql .= ' AND fornecedor = "' . $_POST['fornecedor'] . '" ';
endif;

if (!empty($_POST['vendedor'])) :
    $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
endif;

if (!empty($_POST['categoria'])) :
    $sql .= ' AND categoria = "' . $_POST['categoria'] . '" ';
endif;

if (!empty($_POST['produtos'])) :
    $sql .= " AND codigo = '" . $_POST['produtos'] . "' ";
endif;

if ($_POST['agrupar'] == 'N') :
    $sql .= ' GROUP by itmovimentacao_troca.produto ';

else :
    $sql .= ' GROUP by produtos.' . $_POST['agrupar'] . '  ';
endif;
$sql .= ' ,itmovimentacao_troca.operacao';

if ($_POST['ordenar'] === 'F') :
    $sql .= ' ORDER BY total DESC';
else :
    $sql .= ' ORDER BY qtd DESC';
endif;
//echo $sql;
//echo '<br/>';
$arrayParam = '';
$dadosg = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$total = 0;
foreach ($dadosg as $dadost) :
    $total = $total + $dadost->total;
endforeach;

$panterior = 0;
$tqtd = 0;
$ttotal = 0;
$tcusto = 0;
$gera = 'S';

$dados1 = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

foreach ($dados1 as $dados) :
    $sql = '';

    if (!empty($_POST['grupo'])) :
        $grupop = Grupo($dados->codigo);

        $tgrupo = 0;
        $grupo = str_replace('.00', '', $_POST['grupo']);
        $tgrupo = VerificaGrupo($dados->codigo, $grupo);
        if ($tgrupo > 0) :
            $gera = 'S';
        else :
            $gera = 'N';
        endif;
    endif;

    if ($gera == 'S') :
        if ($dados->operacao == 'E') :
            if ($_POST['abatetroca'] == 'S') :
                if ($_POST['agrupar'] == 'N') :
                    $produtoa = $dados->codproduto;

                    $verificaitem = VerificaItem($produtoa);

                    if ($verificaitem > 0) :
                        $sql = "UPDATE temp_maisvendidos set devolucao = devolucao + '$dados->qtd', 
                        totaldevolucoes = totaldevolucoes + '$dados->totalvendas' where codproduto = '$produtoa'
                and empresa = '" . $empresa . "'";
                    else :
                        $sql = "INSERT INTO temp_maisvendidos(fornecedor, empresa, codigo, codproduto, ref, descricao,
                        var1, var2, var3, saida, devolucao, grupo, totalvendas, totaldesconto, totalacrescimo, totaldevolucoes, totalcusto)
                        VALUES('$dados->fornecedor', '$empresa', '$produtoa', '$produtoa', '$dados->ref', '$dados->descricao',
                          '$dados->var1', '$dados->var2', '$dados->var3', '', '$dados->qtd', '$grupop',
                              '0', '$dados->totaldesconto', '$dados->totalacrescimo', '$dados->totalvendas', '$dados->custo')";
                    endif;

//                    echo $sql;
//                    echo '<br/>';

                else :

                    $produtoa = $dados->codigo;
                    $verificaitem = VerificaItem($produtoa);

                    if ($verificaitem > 0) :
                        $sql = "UPDATE temp_maisvendidos set devolucao = devolucao + '$dados->qtd', 
                        totaldevolucoes = totaldevolucoes + '$dados->totalvendas' where codproduto = '$produtoa'
                and empresa = '" . $empresa . "'";
                    else :
                        $sql = "INSERT INTO temp_maisvendidos(fornecedor, empresa, codigo, codproduto, ref, descricao,
                        var1, var2, var3, saida, devolucao, grupo, totalvendas, totaldesconto, totalacrescimo, totaldevolucoes, totalcusto)
                        VALUES('$dados->fornecedor', '$empresa', '$produtoa', '$produtoa', '$dados->ref', '$dados->descricao',
                          '$dados->var1', '$dados->var2', '$dados->var3', '0', '$dados->qtd', '$grupop',
                              '0', '$dados->totaldesconto', '$dados->totalacrescimo', '$dados->totalvendas', '$dados->custo')";
                    endif;

//                    echo $sql;
//                    echo '<br/>';

                endif;
            endif;

        else :
            if ($_POST['agrupar'] == 'N') :
                $produtoa = $dados->codproduto;
                $verificaitem = VerificaItem($produtoa);

                if ($verificaitem > 0) :
                    $sql = "UPDATE temp_maisvendidos set saida = saida + '$dados->qtd', 
                        totalvendas = totalvendas + '$dados->totalvendas' where codproduto = '$produtoa'
                and empresa = '" . $empresa . "'";
                else :
                    $sql = "INSERT INTO temp_maisvendidos(fornecedor, empresa, codigo, codproduto, ref, descricao,
                        var1, var2, var3, saida, devolucao, grupo, totalvendas, totaldesconto, totalacrescimo, totaldevolucoes, totalcusto)
                        VALUES('$dados->fornecedor', '$empresa', '$produtoa', '$produtoa', '$dados->ref', '$dados->descricao',
                          '$dados->var1', '$dados->var2', '$dados->var3', '$dados->qtd', '0', '$grupop',
                              '$dados->totalvendas', '$dados->totaldesconto', '$dados->totalacrescimo', '0', '$dados->custo')";
                endif;

            else :

                $produtoa = $dados->codigo;
                $verificaitem = VerificaItem($produtoa);

                if ($verificaitem > 0) :
                    $sql = "UPDATE temp_maisvendidos set saida = saida + '$dados->qtd', 
                        totalvendas = totalvendas + '$dados->totalvendas' where codproduto = '$produtoa'
                and empresa = '" . $empresa . "'";
                else :
                    $sql = "INSERT INTO temp_maisvendidos(fornecedor, empresa, codigo, codproduto, ref, descricao,
                        var1, var2, var3, saida, devolucao, grupo, totalvendas, totaldesconto, totalacrescimo, totaldevolucoes, totalcusto)
                        VALUES('$dados->fornecedor', '$empresa', '$produtoa', '$produtoa', '$dados->ref', '$dados->descricao',
                          '$dados->var1', '$dados->var2', '$dados->var3', '$dados->qtd', '0', '$grupop',
                              '$dados->totalvendas', '$dados->totaldesconto', '$dados->totalacrescimo', '0', '$dados->custo')";
                endif;
            endif;
        endif;

//        echo $sql;
//        echo '<br/>';

        $endereco = $crud->Sql($sql);

    endif;
endforeach;

//DEVOLUÇÃO
if ($_POST['apuradev'] == 'S') :
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'cliente');
    $data = date("d/m");
    $sql = 'select movimentacao_dev.documento, movimentacao_dev.data, movimentacao_dev.tipo, 
            movimentacao_dev.situacao, movimentacao_dev.finalizado, movimentacao_dev.vendedor,
    movimentacao_dev.empresa, itmovimentacao_dev.documento, itmovimentacao_dev.preco, itmovimentacao_dev.cancelado,
    sum(itmovimentacao_dev.quantidade) as qtd, 
    sum(itmovimentacao_dev.quantidade) * itmovimentacao_dev.preco as total,
    sum(itmovimentacao_dev.valorliquido) as totaldevolucoes,
    itmovimentacao_dev.produto,';
//        if (!empty($_POST['grupo'])) :
//            $sql .= ' grupoprodutos.produto, grupoprodutos.grupo,';
//        endif;
    $sql .= 'estoqueprodutos.produto as prod, estoqueprodutos.codproduto, 
    estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
    produtos.codigo, produtos.descricao, produtos.custo,  produtos.fornecedor,
    produtos.marca, produtos.categoria, produtos.ref from movimentacao_dev 
    INNER JOIN itmovimentacao_dev ON itmovimentacao_dev.documento = movimentacao_dev.documento 
    INNER JOIN estoqueprodutos ON estoqueprodutos.codproduto = itmovimentacao_dev.produto 
    INNER JOIN produtos ON produtos.codigo = estoqueprodutos.produto';
//        if (!empty($_POST['grupo'])) :
//            $sql .= ' INNER JOIN grupoprodutos ON produtos.codigo = grupoprodutos.produto';
//        endif;
    $sql .= ' where 
    str_to_date(data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '" 
        and itmovimentacao_dev.cancelado <> "S"
        and movimentacao_dev.situacao = "F"
        and movimentacao_dev.tipo <> "D"';

    $sql .= " AND movimentacao_dev.empresa IN($empresabusca)";

    if (!empty($_POST['marca'])) :
        $sql .= ' AND marca = "' . $_POST['marca'] . '" ';
    endif;

    if (!empty($_POST['fornecedor'])) :
        $sql .= ' AND fornecedor = "' . $_POST['fornecedor'] . '" ';
    endif;

    if (!empty($_POST['vendedor'])) :
        $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
    endif;

    if (!empty($_POST['categoria'])) :
        $sql .= ' AND categoria = "' . $_POST['categoria'] . '" ';
    endif;

    if (!empty($_POST['produtos'])) :
        $sql .= " AND codigo = '" . $_POST['produtos'] . "' ";
    endif;

    if ($_POST['agrupar'] == 'N') :
        $sql .= ' GROUP by itmovimentacao_dev.produto ';

    else :
        $sql .= ' GROUP by produtos.' . $_POST['agrupar'] . '  ';
    endif;

    if ($_POST['ordenar'] === 'F') :
        $sql .= ' ORDER BY total DESC';
    else :
        $sql .= ' ORDER BY qtd DESC';
    endif;
//        echo $sql;
//    echo $sql;
//    echo '<br/>';
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

    $total = 0;
    foreach ($dados as $dadost) :
        $total = $total + $dadost->total;
    endforeach;

    $panterior = 0;
    $tqtd = 0;
    $ttotal = 0;
    $tcusto = 0;
    $gera = 'S';
    foreach ($dados as $dados) :
        $grupop = Grupo($dados->codigo);

        if (!empty($_POST['grupo'])) :
            $tgrupo = 0;
            $grupo = str_replace('.00', '', $_POST['grupo']);
            $tgrupo = VerificaGrupo($dados->codigo, $grupo);
            if ($tgrupo > 0) :
                $gera = 'S';
            else :
                $gera = 'N';
            endif;
        endif;

        if ($gera == 'S') :

            if ($_POST['agrupar'] == 'N') :
                $produtoa = $dados->codproduto;
                $sql = "UPDATE temp_maisvendidos set devolucao = '$dados->qtd', totaldevolucoes = totaldevolucoes + '$dados->totaldevolucoes' where codproduto = '$produtoa'
                and empresa = '" . $empresa . "'";
            else :
                $produtoa = $dados->codigo;
                $sql = "UPDATE temp_maisvendidos set devolucao = '$dados->qtd', totaldevolucoes = totaldevolucoes + '$dados->totaldevolucoes' where codproduto = '$produtoa'
                and empresa = '" . $empresa . "'";
            endif;

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'precoprodutos');

            $endereco = $crud->Sql($sql);

        endif;
    endforeach;
endif;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'precoprodutos');
$sql = "update temp_maisvendidos set custototal = (saida - devolucao) * totalcusto";
$endereco = $crud->Sql($sql);
?>

<html>
    <head>
        <title> Relatório </title>
        <style>

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

            .page {
                width: 21cm;
                min-height: 29.7cm;
                padding: 2cm;
                margin: 1cm auto;
                border: 1px #D3D3D3 solid;
                border-radius: 5px;
                background: white;
                box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
            }
        </style>
    <body>
        <div align="center">
            PRODUTOS MAIS VENDIDOS
            <Br/> 
            PERÍODO: <?= $_POST['datai'] ?> À <?= $_POST['dataf'] ?>
            <?php
            if (!empty($_POST['grupo'])) :
                ?>
                <br/>
                GRUPO : <?= $_POST['grupo'] ?> - <?= buscaGrupo($_POST['grupo']) ?>
                <?php
            endif;
            ?>
            <?php
            if ($empresa !== 'T') :
                ?>
                <br/>
                FILIAL : <?= BuscaEmpresa($_POST['empresa'][0]) ?>
                <?php
            else :
                ?>
                <br/>
                FILIAL : SELECIONADAS
            <?php
            endif;
            ?>
        </div>

        <?php require_once './cabecalho.php'; ?>
        <table class="table table-condensed text-center" style="font-size: 10px; width: 100%; text-align: left">
            <tr>
                <?php
                if ($_POST['agrupamentototal'] !== 'N') :
                    if ($_POST['agrupamentototal'] === 'G') :
                        $tit = 'Grupo';
                    else :
                        $tit = 'Fornecedor';
                    endif;
                    ?>
                    <td colspan="6"><b><?= $tit ?></b></td>
                    <?php
                else :
                    ?>
                    <td><b>Código</b></td>
                    <td><b>Ref</b></td>
                    <td style="width: 20%;"><b>Descrição</b></td>
                    <?php
                    if ($_POST['agrupar'] == 'N') :
                        if ($parametros->grade === 'S') :
                            ?>
                            <td><b>Var 1</b></td>
                            <td><b>Var 2</b></td>
                            <td><b>Var 3</b></td>
                            <?php
                        endif;
                    endif;
                endif;
                ?>

                <td><b>Qtd</b></td>
                <td><b>Preço Médio</b></td>
                <td><b>Total Vendas</b></td>
                <td><b>Total Dev.</b></td>
                <td><b>Total Des.</b></td>
                <td><b>Total Acre.</b></td>
                <td><b>Total Geral </b></td>
                <td><b>Custo Total</b></td>
                <td><b>R$ Lucro</b></td>
                <td><b>% Lucro</b></td>
                <td><b>% Faturado</b></td>

            </tr>

            <?php
            if ($_POST['agrupamentototal'] !== 'N') :

                $pdo = Conexao::getInstance();
                $crud = Crud::getInstance($pdo, 'caixa');
                $sql = "SELECT fornecedor, empresa, codigo, codproduto,descricao, ref,var1,var2,var3,sum(saida) as saida,sum(devolucao) as devolucao,grupo,sum(totalvendas) as totalvendas,
                sum(totaldevolucoes) as totaldevolucoes,sum(totaldesconto) as totaldesconto, sum(totalacrescimo) as totalacrescimo, sum(custototal) as totalcusto, sum(totalvendas) - sum(totaldevolucoes) - sum(totaldesconto) as totalgeral,
                sum(saida) - sum(devolucao) as qtd from temp_maisvendidos WHERE 1=1";

                if ($empresa !== 'T') :
                    $sql .= " AND empresa = '" . $_POST['empresa'][0] . "'";
                endif;

                if ($_POST['agrupamentototal'] === 'G') :
                    $sql .= ' GROUP BY grupo';
                else :
                    $sql .= ' GROUP BY fornecedor';
                endif;

                if ($_POST['ordenar'] === 'F') :
                    $sql .= ' ORDER BY totalgeral DESC';
                else :
                    $sql .= ' ORDER BY qtd DESC';
                endif;

            else :
                $pdo = Conexao::getInstance();
                $crud = Crud::getInstance($pdo, 'caixa');
                $sql = "SELECT empresa, codigo, codproduto,descricao, ref,var1,var2,var3,saida,devolucao,grupo,totalvendas,
                totaldevolucoes,totaldesconto, totalacrescimo, totalcusto, totalvendas - totaldevolucoes - totaldesconto as totalgeral, saida - devolucao as qtd from temp_maisvendidos WHERE 1=1";

                if ($empresa !== 'T') :
                    $sql .= " AND empresa = '" . $_POST['empresa'][0] . "'";
                endif;

                if ($_POST['ordenar'] === 'F') :
                    $sql .= ' ORDER BY totalgeral DESC';
                else :
                    $sql .= ' ORDER BY qtd DESC';
                endif;
            endif;

            $arrayParam = '';
            $dadosrel = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

            $total = 0;
            foreach ($dadosrel as $dadost) :
                $total = $total + $dadost->totalgeral;
            endforeach;

            $panterior = 0;
            $tqtd = 0;
            $ttotal = 0;
            $tcusto = 0;
            $tdev = 0;
            $tdesc = 0;
            $tvenda = 0;
            foreach ($dadosrel as $dadosg) :
                if ($_POST['negativo'] == 'N' && $dadosg->qtd <= 0) :
                    echo '';
                else :
                    if ($_POST['agrupamentototal'] !== 'N') :
                        $totalcusto = $dadosg->totalcusto;
                        $tcusto = $tcusto + $dadosg->totalcusto;
                    else :
                        $totalcusto = $dadosg->totalcusto * $dadosg->qtd;
                        $tcusto = $tcusto + ($dadosg->totalcusto * $dadosg->qtd);
                    endif;
                    $acumulada = CalculaP($dadosg->totalgeral, $total) + $panterior;
                    $classificao = Classificao($acumulada);
                    $tqtd = $tqtd + $dadosg->qtd;

                    $ttotal = $ttotal + $dadosg->totalgeral;
                    $ttotallucro = $ttotallucro + ($dadosg->totalgeral - $totalcusto);
                    $tdev = $tdev + $dadosg->totaldevolucoes;
                    $tdesc = $tdesc + $dadosg->totaldesconto;
                    $tacres = $tacres + $dadosg->totalacrescimo;
                    $tvenda = $tvenda + $dadosg->totalvendas;
                    ?>
                    <tr>
                        <?php
                        if ($_POST['agrupamentototal'] !== 'N') :
                            if ($_POST['agrupamentototal'] == 'G') :
                                ?>
                                <td colspan="6"><?= $dadosg->grupo ?> - <?= GrupoDesc($dadosg->grupo) ?></td>
                                <?php
                            else :
                                ?>
                                <td colspan="6"><?= $dadosg->fornecedor ?> - <?= Fornecedor($dadosg->fornecedor) ?></td>
                            <?php
                            endif;
                            ?> 
                            <?php
                        else :
                            ?>
                            <td><?= $dadosg->codproduto ?></td>
                            <td><?= $dadosg->ref ?></td>
                            <td><?= $dadosg->descricao ?></td>

                            <?php
                            if ($_POST['agrupar'] == 'N') :
                                if ($parametros->grade === 'S') :
                                    ?>
                                    <td><?= $dadosg->var1 ?></td>
                                    <td><?= $dadosg->var2 ?></td>
                                    <td><?= $dadosg->var3 ?></td>

                                    <?php
                                endif;
                            endif;
                            ?>
                        <?php
                        endif;
                        ?>


                        <td><?php
                if (floor($dadosg->qtd) != $dadosg->qtd) :
                    echo $dadosg->qtd;
                else :
                    echo intval($dadosg->qtd);
                endif;
                        ?></td>
                        <td>R$ <?=
                    is_numeric($dadosg->totalgeral) && is_numeric($dadosg->qtd) && $dadosg->qtd != 0 ? number_format($dadosg->totalgeral / $dadosg->qtd, 2, ',', '') : '0,00'
                        ?>
                        </td>
                        <td>R$ <?= number_format($dadosg->totalvendas, 2, ',', '') ?></td>
                        <td>R$ <?= number_format($dadosg->totaldevolucoes, 2, ',', '') ?></td>
                        <td>R$ <?= number_format($dadosg->totaldesconto, 2, ',', '') ?></td>
                        <td>R$ <?= number_format($dadosg->totalacrescimo, 2, ',', '') ?></td>
                        <td>R$ <?= number_format($dadosg->totalgeral, 2, ',', '') ?></td>
                        <td>R$ <?= number_format($totalcusto, 2, ',', '') ?></td>
                        <td>R$ <?= number_format($dadosg->totalgeral - $totalcusto, 2, ',', '') ?></td>        
                        <td><?= number_format(CalculaPCusto($dadosg->totalgeral - $totalcusto, $dadosg->totalgeral), 2, ',', '') ?> %</td>        
                        <td><?= number_format(CalculaP($dadosg->totalgeral, $total), 2, ',', '') ?> %</td>        

                    </tr>
    <?php
    endif;
endforeach;
?>


            <tr>
<?php
if ($_POST['agrupar'] == 'N') :
    if ($parametros->grade === 'S') :
        ?>
                        <td colspan="6"><hr/> TOTAIS</td>
                        <?php
                    else :
                        ?>
                        <td colspan="3"> <hr/>  TOTAIS</td>
                    <?php
                    endif;
                else :
                    ?>
                    <td colspan="3"> <hr/>  TOTAIS</td>
                <?php
                endif;
                ?>
                <td> <hr/> <?= number_format($tqtd, 2, ',', '') ?></td>
                <td> <hr/>  </td>             
                <td> <hr/>  R$ <?= number_format($tvenda, 2, ',', '.') ?></td>
                <td> <hr/>  R$ <?= number_format($tdev, 2, ',', '.') ?></td>
                <td> <hr/>  R$ <?= number_format($tdesc, 2, ',', '.') ?></td>
                <td> <hr/>  R$ <?= number_format($tacres, 2, ',', '.') ?></td>
                <td> <hr/>  R$ <?= number_format($ttotal, 2, ',', '.') ?></td>
                <td> <hr/>  R$ <?= number_format($tcusto, 2, ',', '.') ?></td>
                <td> <hr/>  R$ <?= number_format($ttotallucro, 2, ',', '.') ?></td>
                <td> <hr/> <?= number_format(CalculaPCusto($ttotal - $tcusto, $ttotal), 2, ',', '') ?> %</td>
                <td> <hr/>  <?= number_format('100', 2, ',', '.') ?> %</td>
            </tr>
        </table>



    </body>
</html>
<?php
if ($_POST['gerar'] == 'PDF') :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4-L'
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
elseif ($_POST['gerar'] == 'EXCEL') :
    $file = 'MaisVendidos.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
else :
    echo '';
endif;
?>