<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>

    </head>
    <?php
    ob_start();

    date_default_timezone_set("Brazil/East");
    require_once("../../../functions.php");
//
    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/cobranca_class.php";
    require_once "../../../_backend/_class/parametros.php";



    if ($_GET['tipo'] == 'R') :
        $titulo = 'À RECEBER';
    else :
        $titulo = 'À PAGAR';
    endif;

    function Para($valor) {
        switch ($valor) :
            case 'C' :
                return 'Cliente';
                break;
            case 'F' :
                return 'Funcionário';
                break;
            case 'R' :
                return 'Representante';
        endswitch;
    }

    function TotalItens($doc) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'itmovimentacao');
        $sql = "select sum(quantidade) as total from itmovimentacao where documento = '$doc' and cancelado = 'N'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        return $dados->total;
    }

    function TotalItensNFe($doc) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'produtonfe');
        $sql = "select sum(qtd) as total from produtonfe where NFe = '$doc'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        return $dados->total;
    }

    function BuscaPara($valor, $id) {

        if ($valor == 'R') :
            $sql = "SELECT * from representante where representanteid = '$id' ";
        elseif ($valor == 'F') :
            $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
        elseif ($valor == 'FN') :
            $sql = "SELECT * from fornecedor where fornecedorid = '$id' ";
        elseif ($valor == 'TR') :
            $sql = "SELECT * from transportador where transportadorid = '$id' ";
        else :
            $sql = "SELECT * from cliente where clienteid = '$id' ";
        endif;

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabela');
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        return $dados;
    }

    $_GET['datai'] = parseDate($_GET['datai'], 'Y-m-d');
    $_GET['dataf'] = parseDate($_GET['dataf'], 'Y-m-d');

    $dataconsulta = date("Y-m-d");
    $data1 = parseDate($dataconsulta, 'd/m/Y');

    function Situacao($valor) {
        switch ($valor) :
            case 'A' :
                return 'Aberta';
                break;
            case 'BP' :
                return 'Parcial';
                break;
            case 'BC' :
                return 'Baixada';
                break;
        endswitch;
    }
    ?>
    <body>

        <div align="center">
            RELATORIO DE LANÇAMENTO
            <br/> <small> CONTAS <?= $titulo ?> <br/><?= parseDate($_GET['datai'], "d/m/Y"); ?> à <?= parseDate($_GET['dataf'], "d/m/Y"); ?></small>
        </div>


        <?php require_once './cabecalho.php'; ?>

        <table cellpadding="8" class="table table-striped table-bordered table-condensed full_table_list" style="font-size: 10px; padding: 10px">
            <tr> 
                <th style="width: 40%">Entidade</th>
                <th style="width: 8%">Titulo</th>
                <th style="width: 10%">Emissão</th>
                <th style="width: 12%">Vencimento</th>
                <th style="width: 10%">Valor</th>
                <th style="width: 10%">Situação</th>
                <th style="width: 18%">Cobrança</th>
                <?php
                if ($_GET['exibeqtd'] == 'S') :
                    ?>
                    <th style="width: 18%">Quant.</th>
                    <?php
                endif;
                ?>
                <th style="width: 10%">Plano de Contas</th>
            </tr>


            <?php
            $totalvenda = 0;
            $desciten = 0;
            $descdoc = 0;
            $totalbruto = 0;
            $totalliquido = 0;
            $totalprod = 0;

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'usuario');
            if ($_GET['tpdata'] == 'DV') :
                $sql = 'Select * FROM lancamento where str_to_date(datavencimento, "%d/%m/%Y") BETWEEN "' . $_GET['datai'] . '" AND "' . $_GET['dataf'] . '" AND tipoconta = "' . $_GET['tipo'] . '"';
            else :
                $sql = 'Select * FROM lancamento where str_to_date(dataemissao, "%d/%m/%Y") BETWEEN "' . $_GET['datai'] . '" AND "' . $_GET['dataf'] . '" AND tipoconta = "' . $_GET['tipo'] . '"';
            endif;

            if (!empty($_GET['cliente'])) :
                $sql .= ' AND cliente = "' . $_GET['cliente'] . '" ';
            endif;

            if (!empty($_GET['fornecedor'])) :
                $sql .= ' AND fornecedor = "' . $_GET['fornecedor'] . '" ';
            endif;

            if (!empty($_GET['transportador'])) :
                $sql .= ' AND transportador = "' . $_GET['transportador'] . '" ';
            endif;

            if (!empty($_GET['representante'])) :
                $sql .= ' AND representante = "' . $_GET['representante'] . '" ';
            endif;

            if (!empty($_GET['funcionario'])) :
                $sql .= ' AND funcionario = "' . $_GET['funcionario'] . '" ';
            endif;

            if (!empty($_GET['planodecontas'])) :
                $sql .= ' AND planodecontas = "' . $_GET['planodecontas'] . '" ';
            endif;

            if (!empty($_GET['situacao'])) :
                if ($_GET['situacao'] == 'A') :
                    $sql .= ' AND ((situacao = "' . $_GET['situacao'] . '") or (situacao = "BP")) ';
                else :
                    $sql .= ' AND situacao = "' . $_GET['situacao'] . '" ';
                endif;
            endif;

            if (!empty($_GET['tipocobranca'])) :
                $sql .= ' AND tipocobranca = "' . $_GET['tipocobranca'] . '" ';
            endif;

            $sql .= 'ORDER BY  str_to_date(datavencimento, "%d/%m/%Y") ';


//            echo $sql;
            $arrayParam = '';
            $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);
            $totalaberta = 0;
            $totalreceb = 0;
            $totalgeral = 0;

            foreach ($movimentacao as $movimentacao) :

                $id = '';

                if ($movimentacao->tipoconta == 'D') :
                    if ($movimentacao->para == 'T') :
                        $id = $movimentacao->transportador;
                        $dest = BuscaPara('TR', $movimentacao->transportador);
                    else :
                        $id = $movimentacao->fornecedor;
                        $dest = BuscaPara('FN', $movimentacao->fornecedor);
                    endif;

                else :
                    if ($movimentacao->para == 'R') :
                        $id = $movimentacao->representante;
                        $dest = BuscaPara('R', $movimentacao->representante);
                    elseif ($movimentacao->para == 'F') :
                        $id = $movimentacao->funcionario;
                        $dest = BuscaPara('F', $movimentacao->funcionario);
                    else :
                        $id = $movimentacao->cliente;
                        $dest = BuscaPara('C', $movimentacao->cliente);
                    endif;

                endif;


                if ($id == '') :
                    $dest = $movimentacao->historico;
                endif;

                if ($movimentacao->situacao == 'A') :
                    $totalaberta = $totalaberta + $movimentacao->valor;
                else :
                    $totalreceb = $totalreceb + $movimentacao->valor;
                endif;
                ?>
                <tr> 
                    <td><?= $id ?> - <?= $dest->xNome ?></td>
                    <td><?= $movimentacao->titulo ?>-<?= $movimentacao->parcela ?></td>
                    <td><?= $movimentacao->dataemissao ?></td>
                    <td><?= $movimentacao->datavencimento ?></td>
                    <td>R$ <?= number_format($movimentacao->valor, $parametros->casadecimal, ',', '.') ?></td>
                    <td><?= Situacao($movimentacao->situacao) ?></td>
                    <td><?= $cobranca[$movimentacao->tipocobranca] ?></td>
                    <?php
                    if ($_GET['exibeqtd'] == 'S') :
                        $totalitens = $totalitens + TotalItens($movimentacao->documento) + TotalItensNFe($movimentacao->NotaFiscal);
                        ?>
                        <td><?= number_format(TotalItens($movimentacao->documento) + TotalItensNFe($movimentacao->NotaFiscal), $parametros->casadecimal, ',', '.') ?></td>
                        <?php
                    endif;
                    ?>
                    <td><?= $movimentacao->planodecontas ?></td>
                </tr>

                <?php
            endforeach;
            ?>  
        </table>


        <hr/>
        <br/>
        <br/>
        <br/>
        <div align="center"> RESUMO </div>
        <table cellpadding="8" class="table table-striped table-bordered table-condensed full_table_list" style="font-size: 10px; padding: 10px">
            <tr>
                <td style="width: 16%"> TOTAL GERAL </td>
                <td style="width: 16%"> TOTAL BAIXADOS</td>
                <td style="width: 16%"> TOTAL ABERTO </td>
                <?php
                if ($_GET['exibeqtd'] == 'S') :
                    ?>
                    <td style="width: 16%"> TOTAL PRODUTOS </td>
                    <?php
                endif;
                ?>
            </tr>
            <tr>
                <td> R$ <?= number_format($totalaberta + $totalreceb, $parametros->casadecimal, ',', '.') ?> </td>
                <td> R$ <?= number_format($totalreceb, $parametros->casadecimal, ',', '.') ?> </td>
                <td> R$ <?= number_format($totalaberta, $parametros->casadecimal, ',', '.') ?> </td>
                <?php
                if ($_GET['exibeqtd'] == 'S') :
                    ?>
                    <td> <?= number_format($totalitens, $parametros->casadecimal, ',', '.') ?> </td>
                    <?php
                endif;
                ?>

            </tr>
        </table>
    </body>
</html>

<?php
$stylesheet = " 
             .table-bordered th,
    .table-bordered td {
        border: 1px solid #ddd !important; } 

    .full_table_list_titulo{border-collapse: collapse;}
    .full_table_list_titulo tr{border:1px black solid;}

    .full_table_list{border-collapse: collapse;}
    .full_table_list tr{border:1px black solid;}
    .full_table_list tr:nth-child(even) {background: #eee}
    .full_table_list tr:nth-child(odd) {background: #fff}  

    .tablecor {border:1px black solid; background: #eee}
    .titulotr {border:1px black solid; background: #F5F5F5}
            table {width: 100%; padding: 10px;}
            tr {border:1px black solid}
            .titulotr {border:1px black solid; background: #F5F5F5}";


require_once("../../_inc/mpdf/vendor/autoload.php");
ini_set("pcre.backtrack_limit", "500000000000000");


if ($_GET['exibeqtd'] == 'S') :
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4-L'
    ]);
else :
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12
    ]);
endif;



$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
    <tr>
        <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
    </tr>
</table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->SetTitle('Lancamentos');
$mpdf->WriteHTML($stylesheet, 1);
$mpdf->WriteHTML($html, 2);
$mpdf->Output();
// imprime

exit();
?>