<?php
ob_start();

date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";

// error_reporting(E_ALL);
// ini_set('display_errors', 'On');

function sortFunction($a, $b)
{
    return strtotime($a["data"]) - strtotime($b["data"]);
}


$inicio = parseDate($_POST['datai'], "Y-m-d");
$fim = parseDate($_POST['dataf'], "Y-m-d");
$empresa = $_POST['empresa'];


$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');
$data = date("d/m");

$sql = "SELECT 
            n.destUF AS estado,
            SUM(p.qtd) AS quantidade_itens_vendidos,
            (SELECT SUM(nfe.vNF) FROM nfe WHERE nfe.destUF = n.destUF 
                AND nfe.modelo = '55' 
                AND nfe.empresa = '8' 
                AND nfe.status = '100'
                AND STR_TO_DATE(nfe.dhEmi, '%d/%m/%Y') BETWEEN '$inicio' AND '$fim'
            ) AS valor_total
        FROM nfe n
        LEFT JOIN produtonfe p ON n.id = p.NFe
        WHERE n.modelo = '55'
        AND n.destUF IS NOT NULL
        AND n.destUF != ''
        AND n.empresa = '$empresa'
        AND n.status = '100'
    ";

if ($_POST['estado'] != 'T') {
    $sql .= " AND n.destUF = '" . $_POST['estado'] . "'";
}

$sql .= " AND STR_TO_DATE(n.dhEmi, '%d/%m/%Y') BETWEEN '$inicio' AND '$fim'
        GROUP BY n.destUF
        ORDER BY n.destUF;
    ";

$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
$totalsaida = count($dados);

$sql = 'SELECT emitente.xNome, emitente.xFant FROM emitente WHERE emitenteid = ' . $_POST['empresa'] . '';
$empresa = $crud->getSQLGeneric($sql, $arrayParam, false);

?>

<html>

<head>
    <title> Itens Vendidos por Estado </title>
    <style>
        table {
            border-collapse: collapse;
        }

        thead {
            vertical-align: bottom;
            text-align: center;
            font-weight: bold;
        }

        tfoot {
            text-align: center;
            font-weight: bold;
        }

        th {
            text-align: left;
            padding-left: 0.35em;
            padding-right: 0.35em;
            padding-top: 0.35em;
            padding-bottom: 0.35em;
            vertical-align: top;
        }

        td {
            padding-left: 0.35em;
            padding-right: 0.35em;
            padding-top: 0.35em;
            padding-bottom: 0.35em;
            vertical-align: top;
        }

        .page {
            width: 21cm;
            min-height: 29.7cm;
            padding: 2cm;
            margin: 1cm auto;
            border: 1px #D3D3D3 solid;
            border-radius: 5px;
            background: white;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
        }
    </style>
    <?php
    if ($_POST['gerar'] != 'PDF') :
    ?>
        <link href="../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <?php
    endif;
    ?>
</head>

<body>


    <div align="center">
        ITENS VENDIDOS POR ESTADO
        <Br />
        PERÍODO: <?= $_POST['datai'] ?> À <?= $_POST['dataf'] ?>
        <br />
        FILIAL:
        <?php if ($empresa->xNome) : ?>
            <td><?= $empresa->xNome ?></td>
        <?php else : ?>
            <td><?= $empresa->xFant ?></td>
        <?php endif; ?>
        <br><br>
    </div>

    <table class="table table-condensed text-center" style="font-size: 12px; width: 100%; text-align: left">

        <tr>
            <td><b>Estado</b></td>
            <td><b>Quantidade Itens</b></td>
            <!--<td><b>Valor</b></td>-->
        </tr>

        <?php
        $itensTotais = 0;
        $valorTotal = 0;
        foreach ($dados as $estado) :
        ?>

            <tr>
                <td><?= $estado->estado ?></td>

                <td><?= number_format($estado->quantidade_itens_vendidos, 0, ',', '.') ?></td>
                
                <!--<td><?= number_format($estado->valor_total, 2, ',', '.') ?></td>-->
            </tr>

        <?php
            $valorTotal += $estado->valor_total;
            $itensTotais += floatval($estado->quantidade_itens_vendidos);
        endforeach;
        ?>

        <tr>
            <td colspan="3">
                <hr />
            </td>
        </tr>
        <tr>
            <td> <b> TOTAL </b> </td>
            <td> <b> <?= number_format($itensTotais, 0, ',', '.') ?> </b> </td>
            <!--<td> <b> <?= number_format($valorTotal, 2, ',', '.') ?> </b> </td>-->
        </tr>

    </table>


</body>

</html>
<?php
if ($_POST['gerar'] == 'PDF') :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4'
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output("itens_por_estado.pdf", "I");

    exit();
elseif ($_POST['gerar'] == 'EXCEL') :
    $file = 'itens_por_estado.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
else :
    echo '';
endif;
?>