<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>
        <style>
            /*@import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";*/

            table {
                border-collapse: collapse;
            }
            tdead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            td {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

        </style>
    </head>
    <?php
    ob_start();
    date_default_timezone_set("Brazil/East");
    require_once("../../../functions.php");
//
    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/cobranca_class.php";
    require_once "../../../_backend/_class/parametros.php";

    function DadosChqueque($documento) {
        static $cache = [];
        if (!isset($cache[$documento])) {
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'usuario');
            $sql = "SELECT * FROM cheques where chequescmc7 = '$documento'";
            $arrayParam = '';
            $vendedor = $crud->getSQLGeneric($sql, $arrayParam, true);
            $cache[$documento] = $crud->getSQLGeneric($sql, $params, false);
        }
        return $cache[$documento];
    }

    function getBuscaPara($pdo, $tipo, $id) {
        static $cache = [];
        $cacheKey = $tipo . $id;
        if (!isset($cache[$cacheKey])) {
            $tableMap = [
                'R' => 'representante',
                'F' => 'funcionario',
                'C' => 'cliente'
            ];
            $table = $tableMap[$tipo] ?? 'cliente';
            $column = strtolower($table) . 'id';
            $crud = Crud::getInstance($pdo, 'tabela');
            $sql = "SELECT * FROM $table WHERE $column = $id";
            $arrayParam = '';
            $cache[$cacheKey] = $crud->getSQLGeneric($sql, $arrayParam, false);
        }
        return $cache[$cacheKey];
    }

    $_POST['datai'] = parseDate($_POST['datai'], 'Y-m-d');
    $_POST['dataf'] = parseDate($_POST['dataf'], 'Y-m-d');

    $dataitime = strtotime($_POST['datai']);
    $dataftime = strtotime($_POST['dataf']);
    ?>
    <body>

        <div align="center">
            MOVIMENTAÇÕES DE CHEQUES
            <br/> <small> 
                <?= parseDate($_POST['datai'], "d/m/Y"); ?> à <?= parseDate($_POST['dataf'], "d/m/Y"); ?>
            </small>

        </div>

        <table cellpadding="8" class="table table-striped table-bordered table-condensed" style="font-size: 10px; padding: 10px">
            <tr>
                <td>DATA</td>
                <td>HISTORICO</td>
                <td>CMC7</td>
                <td>NUMERO</td>
                <td>EMISSÃO</td>
                <td>VENCIMENTO</td>
                <td>EMISSOR</td>
                <td>CLIENTE</td>
                <td>VALOR</td>
                <td>SITUAÇÃO</td>
            </tr>

            <?php

            function Situacao($valor) {
                switch ($valor):
                    case 'RP':
                        return 'REPASSADO';
                        break;
                    case 'DP':
                        return 'Depositado';
                        break;
                    case 'DC':
                        return 'Descontado';
                        break;
                    case 'DV':
                        return 'Devolvido';
                        break;
                    case 'OT':
                        return 'Outros';
                        break;
                    case 'RB':
                        return 'Recebido';
                        break;
                endswitch;
            }

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'historicocheque');
            $sql = "SELECT * FROM historicocheque where ";
            $sql .= ' str_to_date(data, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '"';

            if (!empty($_POST['situacao'])) :
                $sql .= ' AND situacao = "' . $_POST['situacao'] . '" ';
            endif;

            $arrayParam = '';
            $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);
            foreach ($movimentacao as $dados) :
                $cheque = DadosChqueque($dados->cheque);
                $id = $dados->para == 'R' ? $cheque->representante : ($cheque->para == 'F' ? $cheque->funcionario : $cheque->cliente);
                $dest = getBuscaPara($pdo, $dados->para, $id);
                ?>
                <tr>
                    <td><?= $dados->data ?></td>
                    <td><?= $dados->historico ?></td>
                    <td><?= $dados->cheque ?></td>
                    <td><?= $cheque->chequesnumero ?></td>
                    <td><?= $cheque->chequesdataemissao ?></td>
                    <td><?= $cheque->chequesdatavencimento ?></td>
                    <td><?= $cheque->chequesemissor ?></td>
                    <td><?= $id ?> <?= $dest->xNome ?></td>
                    <td>R$ <?= number_format($cheque->chequesvalor, 2, ',', '.') ?></td>
                    <td><?=  Situacao($dados->situacao) ?></td>

                </tr>
                <?php
            endforeach;
            ?>
        </table>

    </body>

</html>

<?php
if ($_GET['gerar'] == 'excel') :
    $data = parseDate($_GET['data'], "dmY");
    $file = 'caixa' . $data . '.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
else :
    require_once("../../_inc/mpdf/vendor/autoload.php");
    ini_set("pcre.backtrack_limit", "500000000000000");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4-L'
    ]);
//$mpdf->SetWatermarkText('DRAFT');
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Movimentações');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
    exit();
endif;
?>