<?php
ob_start();
?>
<style>
    body {
        font-size: 12px;
    }

    h1, h2, h3, h4, h5, h6,
    .h1, .h2, .h3, .h4, .h5, .h6 {
        font-family: inherit;
        font-weight: 500;
        line-height: 1.1;
        color: inherit;
    }
    h1 small,
    h1 .small, h2 small,
    h2 .small, h3 small,
    h3 .small, h4 small,
    h4 .small, h5 small,
    h5 .small, h6 small,
    h6 .small,
    .h1 small,
    .h1 .small, .h2 small,
    .h2 .small, .h3 small,
    .h3 .small, .h4 small,
    .h4 .small, .h5 small,
    .h5 .small, .h6 small,
    .h6 .small {
        font-weight: normal;
        line-height: 1;
        color: #777777;
    }

    h1, .h1,
    h2, .h2,
    h3, .h3 {
        margin-top: 20px;
        margin-bottom: 10px;
    }
    h1 small,
    h1 .small, .h1 small,
    .h1 .small,
    h2 small,
    h2 .small, .h2 small,
    .h2 .small,
    h3 small,
    h3 .small, .h3 small,
    .h3 .small {
        font-size: 65%;
    }

    h4, .h4,
    h5, .h5,
    h6, .h6 {
        margin-top: 10px;
        margin-bottom: 10px;
    }
    h4 small,
    h4 .small, .h4 small,
    .h4 .small,
    h5 small,
    h5 .small, .h5 small,
    .h5 .small,
    h6 small,
    h6 .small, .h6 small,
    .h6 .small {
        font-size: 75%;
    }

    h1, .h1 {
        font-size: 36px;
    }

    h2, .h2 {
        font-size: 30px;
    }

    h3, .h3 {
        font-size: 24px;
    }

    h4, .h4 {
        font-size: 18px;
    }

    h5, .h5 {
        font-size: 14px;
    }

    h6, .h6 {
        font-size: 12px;
    }
    .text-center {
        text-align: center;
    }

    table {
        width: 100%;
        padding: 10px;
    }

    td {
        padding: 3px;
    }
    th {
        text-align: left;
    }
    /*.titulotr { border:  none};*/
    /*.titulotr { background: #000; border:1px black solid;};*/
    .table-bordered th,
    .table-bordered td {
        border: 1px solid #ddd !important;
    }

    .full_table_list_titulo{
        border-collapse: collapse;
    }
    .full_table_list_titulo tr{
        border:1px black solid;
    }

    .full_table_list{
        border-collapse: collapse;
    }
    .full_table_list tr{
        border:1px black solid;
    }
    .full_table_list tr:nth-child(even) {
        background: #fff
    }
    .full_table_list tr:nth-child(odd) {
        background: #fff
    }

    .tablecor {
        border:1px black solid;
        background: #eee
    }
    .titulotr {
        border:1px black solid;
        background: #F5F5F5
    }
</style>

<?php
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/cobranca_class.php";
require_once "../../../_backend/_class/parametros.php";
require_once "../../../_backend/_class/Emitente_class.php";

function BuscaPara($valor, $id) {
    $sql = "SELECT * from fornecedor where fornecedorid = '$id' ";

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

function BuscaDadosProd($produto) {
    $sql = "SELECT estoqueprodutos.codproduto, estoqueprodutos.produto,
        produtos.codigo, produtos.ref, produtos.descricao from produtos
        INNER JOIN estoqueprodutos ON estoqueprodutos.produto = produtos.codigo
        where estoqueprodutos.codproduto = '$produto'";
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'produtos');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

function BuscaValorFase($op, $fase) {
    $sql = "SELECT * from pcp_ordemprod where doc = '$op' ";
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
    $ficha = $dados->fichatecnica;

    $sql = "SELECT * from pcp_fichatecnica_processo where fichatecnica = '$ficha' and processo = '$fase'";
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

//    echo $sql;
    return $dados->valor;
}

$logo = '' . FRONTEND . '/img/logomarca/' . $emitente->CNPJ . '/' . $emitente->logo . '';

$documento = $_GET['documento'];
$fase = $_GET['fase'];
$fornecedor = $_GET['fornecedor'];

//$documento = '3';
//$fase = '26';
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'itmovimentacao');
$sql = "SELECT sum(pcp_itemprod.qtd) as quantidade, sum(pcp_itemprod.qtdbaixa) as qtdbaixa, pcp_itemprod.produto, pcp_itemprod.valorunitario as valor, 
     pcp_itemprod.retorno, pcp_itemprod.var1, pcp_itemprod.var2, pcp_itemprod.codproduto,
    pcp_itemprod.fornecedor, pcp_itemprod.doc, pcp_itemprod.setor,
    estoqueprodutos.codproduto, estoqueprodutos.var1, estoqueprodutos.ref,
    estoqueprodutos.var2,estoqueprodutos.ordem1, estoqueprodutos.ordem2
    from pcp_itemprod
    LEFT JOIN estoqueprodutos on pcp_itemprod.codproduto = estoqueprodutos.codproduto
    where doc= '$documento' and setor ='$fase' ";

if (!empty($fornecedor)) :
    $sql .= " and fornecedor = '$fornecedor'";
endif;

$sql .= "GROUP BY pcp_itemprod.codproduto
    ORDER BY estoqueprodutos.ref, estoqueprodutos.ordem1, estoqueprodutos.ordem2 ASC  
        ";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
$dest = BuscaPara('F', $fornecedor);


//echo $sql;
$titulo = 'TERCEIRIZAÇÃO PRODUÇÃO ';
?>


<table class="table full_table_list_titulo">
    <tr> 
        <td colspan="7" align="center"> <?= $titulo ?> <br/> ESTE DOCUMENTO NÃO É VÁLIDO COMO DOCUMENTO FISCAL </td>
    </tr>
    <tr>
        <td rowspan="6" width="15%"><img src="<?= $logo ?>" height="80px" style="max-width: 14%" alt=""/></td>
        <td width="10%"> <b> Controle </b></td>
        <td colspan="2"><?= $dados[0]->doc ?>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
          
        </td>
        <td width="10%"><b> Retorno</b></td>
        <td colspan="2"><?= $dados[0]->retorno ?></td>
    </tr>
    <tr>
        <td width="10%"><b> Fornecedor</b></td>
        <td colspan="2"><?= $dest->fornecedorid ?> - <?= $dest->xNome ?></td>
        <td width="10%"><b> CPF/CNPJ</b></td>
        <td colspan="2"><?= $dest->CNPJ ?></td>
    </tr>
    <tr>

        <td width="10%"><b> Telefone</b></td>
        <td colspan="2"><?= $dest->fone ?></td>
        <td width="10%"><b> CEP</b></td>
        <td colspan="2"><?= $dest->CEP ?></td>
    </tr>
    <tr>
        <td width="10%"> <b>Endereço</b></td>
        <td colspan="2"><?= $dest->xLgr ?>, <?= $dest->nro ?> - <?= $dest->xBairro ?></td>
        <td width="10%"><b> Cidade</b></td>
        <td colspan="1"><?= $dest->xMun ?> - <?= $dest->UF ?></td>

    </tr>
    <tr>


    </tr>
</table>
<hr/>

<?php
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'temp_fornecedor_pcp');
$sql = "DELETE FROM temp_fornecedor_pcp WHERE documento = '$documento'";
$retornodelete = $crud->Sql($sql);

foreach ($dados as $value) :
    //   if ($value->valor > 0) :
    //       $valorfase = $value->valor;
    //   else :
    //    $valorfase = BuscaValorFase($value->op, $value->fase);
//    endif;

    $valorfase = $value->valor;

    $vptotal = $value->quantidade * $valorfase;
    $dadosprod = BuscaDadosProd($value->codproduto);
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'temp_fornecedor_pcp');
    if ($value->var2 == '') :
        $sql = "SELECT * FROM temp_fornecedor_pcp WHERE produto = '$value->codproduto' and vunit = '$valorfase' and documento = '$documento'";
    else :
        $sql = "SELECT * FROM temp_fornecedor_pcp WHERE produto = '$value->codproduto' and var1 = '$value->var1' and vunit = '$valorfase' and documento = '$documento'";
    endif;
    $arrayParam = '';
    $dadosit = $crud->getSQLGeneric($sql, $arrayParam, true);

    $totalregistro = count($dadosit);
    
    $qtd = $value->quantidade - $value->qtdbaixa;
    if($qtd > 0) :
    if ($totalregistro > 0) :
        if ($value->var2 == '') :
            $variacoes = $dadosit[0]->variacoes . '|' . $value->var1 . ':' . $value->quantidade;
        else :
            $variacoes = $dadosit[0]->variacoes . '|' . $value->var2 . ':' . $value->quantidade;
        endif;
        $sql = "UPDATE temp_fornecedor_pcp SET variacoes = '$variacoes', total = total + '$vptotal' where id = '" . $dadosit[0]->id . "'";
        $insert = $crud->Sql($sql);
    else :
        if ($value->var2 == '') :
            $var = '';
            $variacoes = $value->var1 . ':' . $value->quantidade;
        else :
            $var = $value->var1;
            $variacoes = $value->var2 . ':' . $value->quantidade;
        endif;

        $sql = "INSERT INTO temp_fornecedor_pcp(produto, ref, descricao, var1, variacoes, vunit, total, documento)
                VALUES ('$value->codproduto', '$dadosprod->ref', '$dadosprod->descricao', '$var', '$variacoes',
                  '$valorfase', '$vptotal',  '$documento')
                ";
        $insert = $crud->Sql($sql);
    endif;
 endif;
endforeach;
?>

<table class="table table-striped table-condensed full_table_list">
    <tr class="titulotr">
        <td colspan="5"></td>
    </tr>
    <tr class="">
        <td><b>Produto</b></td>
        <td><b>Cor</b></td>
        <td><b>Ref.</b></td>
        <td width="30%"><b>Descrição</b></td>
        <td colspan="10"><b>Quantidade</b></td>
        <td><b>Valor Unit.</b></td>
        <td><b>Valor Total</b></td>
    </tr>
    <?php
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'temp_fornecedor_pcp');
    $sql = "SELECT * FROM temp_fornecedor_pcp WHERE documento = '$documento'";
    $arrayParam = '';
    $dadositens = $crud->getSQLGeneric($sql, $arrayParam, true);

    foreach ($dadositens as $value) :
        $total = $total + $value->total;
        ?>
        <tr>
            <td>
                <?= $value->produto ?>
            </td>
            <td>
                <?= $value->var1 ?>
            </td>
            <td>
                <?= $value->ref ?>
            </td>

            <td>
                <?= $value->descricao ?>
            </td>


            <?php
            $separa = explode("|", $value->variacoes);
            $grade = '';
            $i = 0;
            for ($index = 0; $index < count($separa); $index++) :
                echo '<td>';
                $grade = explode(":", $separa[$index]);
                echo $grade[0];
                echo '</td>';
                $i++;
            endfor;

            for ($iz = $i; $iz < 10; $iz++) :
                echo '<td>';
                echo '</td>';
            endfor;
            ?>


            <td>
                R$ <?= number_format($value->vunit, $parametros->casadecimal, ',', '.') ?>
            </td>

            <td>
                R$ <?= number_format($value->total, $parametros->casadecimal, ',', '.') ?>
            </td>
        </tr>

        <tr style="border-bottom: 1px solid #DCDCDC">
            <td colspan="4"></td>
            <?php
            $separa = explode("|", $value->variacoes);
            $grade = '';
            $i = 0;

            for ($index = 0; $index < count($separa); $index++) :
                echo '<td>';
                $grade = explode(":", $separa[$index]);
                $pecas = $pecas + $grade[1];
                echo number_format($grade[1], $parametros->casadecimal, ',', '.');
                echo '</td>';
                $i++;
            endfor;

            for ($iz = $i; $iz < 10; $iz++) :
                echo '<td>';
                echo '</td>';
            endfor;
            ?>

            <td colspan="2"></td>
        </tr>
        <?php
    endforeach;
    ?>
    <tr>
        <td colspan="5">
        </td>
    </tr>
</table>


<table class="table table-striped  table-condensed full_table_list">
    <tr>
        <td><b>Total Itens</b></td>
        <td><b><?= number_format($pecas, $parametros->casadecimal, ',', '.') ?></b></td>
    </tr>

    <tr>
        <td><b>Total</b></td>
        <td>R$ <?= number_format($total + $dados->frete - ($dados->desconto + $descontop), $parametros->casadecimal, ',', '.') ?></td>
        <td width="50%" style="border: none;"> </td>

    </tr>

</table>



<?php
require_once("../../_inc/mpdf/vendor/autoload.php");

// converte o conteudo para uft-8
$mpdf = new \Mpdf\Mpdf([
    'margin_top' => 5,
    'margin_left' => 5,
    'margin_right' => 5,
    'mirrorMargins' => true,
    'default_font_size' => 12,
        ]);
//$mpdf = new mPDF('','', 0, '', 15, 15, 16, 16, 9, 9, '');
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} / data impressão: " . date('d/m/Y H:i') . "</td>
                   </tr>
                 </table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->WriteHTML($html);
// escreve definitivamente o conteudo no PDF
$mpdf->Output("romaneio.pdf", 'I');
// imprime

exit();
?>