<?php
ob_start();
date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";

function buscaGrupo($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from temp_maisvendidos where codigo = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, true);

    $total = count($dados);
    return $total;
}

function BuscaEmpresa($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from emitente where emitenteid = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->xNome;
}

function VerificaItem($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from temp_maisvendidos where codproduto = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, true);
    return count($dados);
}

function VerificaGrupo($produto, $grupo) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from grupoprodutos where grupo like '" . $grupo . "%' AND produto = '$produto'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, true);
    $total = count($dados);
//    echo $sql;
    return $total;
}

function CalculaP($valor, $total) {
    $valor1 = $valor / $total;
    $porcentagem = $valor1 * 100;

//    return number_format($porcentagem, 2, ',', '');
    return $porcentagem;
}

function CalculaPCusto($valor, $total) {
    $valor1 = $valor / $total;
    $porcentagem = $valor1 * 100;

//    return number_format($porcentagem, 2, ',', '');
    return $porcentagem;
}

function Classificao($porc) {
    if ($porc < 80) :
        return 'A';
    elseif ($porc < 95) :
        return 'B';
    else :
        return 'C';
    endif;
}

function BuscaVariacaoDesccuva($prod, $variacao, $sigla, $nivel) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT produtos.variacao, produtos.codigo, 
                    variacao.variacaoid, variacao.var1, variacao.var2, 
                    variacao.var3 ,
                    itensvariacao.variacao, itensvariacao.sigla,
                    itensvariacao.descricao, itensvariacao.nivel
                    FROM produtos 
                    INNER JOIN variacao ON produtos.variacao = variacao.variacaoid 
                    INNER JOIN itensvariacao ON itensvariacao.variacao = variacao.variacaoid                   
                    WHERE codigo = '$prod' 
                    AND itensvariacao.nivel = '$nivel'
                    AND itensvariacao.sigla = '$sigla'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->descricao;
}
$_POST['agrupar'] = 'N';

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');
$sql = "DELETE FROM temp_maisvendidos";
if ($_POST['empresa'] !== 'T') :
    $empresa = $_POST['empresa'];
    $sql .= " where empresa = '" . $_POST['empresa'] . "'";
endif;
$deletetemp = $crud->Sql($sql);

$data_incio1 = mktime(0, 0, 0, date('m'), 1, date('Y'));
$data_fim1 = mktime(23, 59, 59, date('m'), date("t"), date('Y'));
$inicio1 = parseDate($_POST['datai'], "Y-m-d");
$fim1 = parseDate($_POST['dataf'], "Y-m-d");

//SAIDA
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');
$data = date("d/m");
$sql = 'select movimentacao.documento, movimentacao.data, movimentacao.tipo, 
            movimentacao.situacao, movimentacao.finalizado, movimentacao.operacao, 
    movimentacao.empresa, itmovimentacao.documento, itmovimentacao.preco,  itmovimentacao.cancelado,
    sum(itmovimentacao.quantidade) as qtd, 
    sum(itmovimentacao.quantidade) * itmovimentacao.preco as total,
    sum(itmovimentacao.valorliquido) as totalvendas,
    sum(itmovimentacao.desc_rateio)  as totaldesconto,
    itmovimentacao.produto,';
//        if (!empty($_POST['grupo'])) :
//            $sql .= ' grupoprodutos.produto, grupoprodutos.grupo,';
//        endif;
$sql .= 'estoqueprodutos.produto as prod, estoqueprodutos.codproduto, 
    estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
    produtos.codigo, produtos.descricao, produtos.custo,  produtos.fornecedor, 
    produtos.marca,  produtos.categoria, produtos.ref from movimentacao 
    INNER JOIN itmovimentacao ON itmovimentacao.documento = movimentacao.documento 
    INNER JOIN estoqueprodutos ON estoqueprodutos.codproduto = itmovimentacao.produto 
    INNER JOIN produtos ON produtos.codigo = estoqueprodutos.produto';
//        if (!empty($_POST['grupo'])) :
//            $sql .= ' INNER JOIN grupoprodutos ON produtos.codigo = grupoprodutos.produto';
//        endif;
$sql .= ' where 
    str_to_date(data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '" 
        and itmovimentacao.cancelado <> "S"
        and movimentacao.situacao = "F"
        and movimentacao.tipo <> "R"
        ';

if ($_POST['empresa'] !== 'T') :
    $empresa = $_POST['empresa'];
    $sql .= " AND movimentacao.empresa = '" . $_POST['empresa'] . "'";
endif;

if (!empty($_POST['marca'])) :
    $sql .= ' AND marca = "' . $_POST['marca'] . '" ';
endif;

if (!empty($_POST['fornecedor'])) :
    $sql .= ' AND fornecedor = "' . $_POST['fornecedor'] . '" ';
endif;

if (!empty($_POST['categoria'])) :
    $sql .= ' AND categoria = "' . $_POST['categoria'] . '" ';
endif;

if (!empty($_POST['operacao'])) :
    if ($_POST['operacao'] != 'T') :
        $sql .= ' AND operacao = "' . $_POST['operacao'] . '" ';
    endif;
endif;

if (!empty($_POST['produtos'])) :
    $sql .= " AND codigo = '" . $_POST['produtos'] . "' ";
endif;

$sql .= ' GROUP by itmovimentacao.produto ';
$sql .= ' ORDER BY total DESC';
//        echo $sql;
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$total = 0;
foreach ($dados as $dadost) :
    $total = $total + $dadost->total;
endforeach;

$panterior = 0;
$tqtd = 0;
$ttotal = 0;
$tcusto = 0;
$gera = 'S';
foreach ($dados as $dados) :

    if (!empty($_POST['grupo'])) :
        $tgrupo = 0;
        $grupo = str_replace('.00', '', $_POST['grupo']);
        $tgrupo = VerificaGrupo($dados->codigo, $grupo);
        if ($tgrupo > 0) :
            $gera = 'S';
        else :
            $gera = 'N';
        endif;
    endif;

    if ($gera == 'S') :

        if ($_POST['agrupar'] == 'N') :
            $produtoa = $dados->codproduto;
            $sql = "INSERT INTO temp_maisvendidos(empresa, codigo, codproduto, ref, descricao,
                        var1, var2, var3, saida, devolucao, grupo, totalvendas, totaldesconto, totaldevolucoes, totalcusto)
                        VALUES('$empresa', '$produtoa', '$produtoa', '$dados->ref', '$dados->descricao',
                          '$dados->var1', '$dados->var2', '$dados->var3', '$dados->qtd', '0', '',
                              '$dados->totalvendas', '$dados->totaldesconto', '0', '$dados->custo')";
        else :
            $produtoa = $dados->codigo;
            $sql = "INSERT INTO temp_maisvendidos(empresa, codigo, codproduto, ref, descricao,
                        var1, var2, var3, saida, devolucao, grupo, totalvendas, totaldesconto, totaldevolucoes, totalcusto)
                        VALUES('$empresa', '$produtoa', '$produtoa', '$dados->ref', '$dados->descricao',
                          '', '', '', '$dados->qtd', '0', '', '$dados->totalvendas', '$dados->totaldesconto', '0', '$dados->custo')";
        endif;

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'precoprodutos');

        $endereco = $crud->Sql($sql);

    endif;
endforeach;

//TROCA
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');
$data = date("d/m");
$sql = 'select movimentacao_troca.documento, movimentacao_troca.data, movimentacao_troca.tipo, 
            movimentacao_troca.situacao, movimentacao_troca.finalizado, 
    movimentacao_troca.empresa, itmovimentacao_troca.documento, itmovimentacao_troca.preco,  itmovimentacao_troca.cancelado,
    itmovimentacao_troca.operacao, itmovimentacao_troca.valorliquido,
    sum(itmovimentacao_troca.quantidade) as qtd, 
    sum(itmovimentacao_troca.quantidade) * itmovimentacao_troca.preco as total,
    sum(itmovimentacao_troca.valorliquido) as totalvendas,
    sum(itmovimentacao_troca.desc_rateio) as totaldesconto,
    itmovimentacao_troca.produto,';
//        if (!empty($_POST['grupo'])) :
//            $sql .= ' grupoprodutos.produto, grupoprodutos.grupo,';
//        endif;
$sql .= 'estoqueprodutos.produto as prod, estoqueprodutos.codproduto, 
    estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
    produtos.codigo, produtos.descricao, produtos.custo,  produtos.fornecedor, 
    produtos.marca,  produtos.categoria, produtos.ref from movimentacao_troca 
    INNER JOIN itmovimentacao_troca ON itmovimentacao_troca.documento = movimentacao_troca.documento 
    INNER JOIN estoqueprodutos ON estoqueprodutos.codproduto = itmovimentacao_troca.produto 
    INNER JOIN produtos ON produtos.codigo = estoqueprodutos.produto';
//        if (!empty($_POST['grupo'])) :
//            $sql .= ' INNER JOIN grupoprodutos ON produtos.codigo = grupoprodutos.produto';
//        endif;
$sql .= ' where 
    str_to_date(data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '" 
        and itmovimentacao_troca.cancelado <> "S"
        and movimentacao_troca.situacao = "F"
        and movimentacao_troca.tipo <> "D"
        ';

if ($_POST['empresa'] !== 'T') :
    $empresa = $_POST['empresa'];
    $sql .= " AND movimentacao_troca.empresa = '" . $_POST['empresa'] . "'";
endif;

if (!empty($_POST['marca'])) :
    $sql .= ' AND marca = "' . $_POST['marca'] . '" ';
endif;

if (!empty($_POST['fornecedor'])) :
    $sql .= ' AND fornecedor = "' . $_POST['fornecedor'] . '" ';
endif;

if (!empty($_POST['categoria'])) :
    $sql .= ' AND categoria = "' . $_POST['categoria'] . '" ';
endif;

if (!empty($_POST['produtos'])) :
    $sql .= " AND codigo = '" . $_POST['produtos'] . "' ";
endif;

$sql .= ' GROUP by itmovimentacao_troca.produto, itmovimentacao_troca.operacao ';
$sql .= ' ORDER BY total DESC';

//      echo $sql;
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$total = 0;
foreach ($dados as $dadost) :
    $total = $total + $dadost->total;
endforeach;

$panterior = 0;
$tqtd = 0;
$ttotal = 0;
$tcusto = 0;
$gera = 'S';
foreach ($dados as $dados) :

    if (!empty($_POST['grupo'])) :
        $tgrupo = 0;
        $grupo = str_replace('.00', '', $_POST['grupo']);
        $tgrupo = VerificaGrupo($dados->codigo, $grupo);
        if ($tgrupo > 0) :
            $gera = 'S';
        else :
            $gera = 'N';
        endif;
    endif;

    if ($gera == 'S') :

        if ($dados->operacao == 'E') :
            if ($_POST['agrupar'] == 'N') :
                $produtoa = $dados->codproduto;

                $verificaitem = VerificaItem($produtoa);

                if ($verificaitem > 0) :
                    $sql = "UPDATE temp_maisvendidos set devolucao = devolucao + '$dados->qtd', 
                        totaldevolucoes = totaldevolucoes + '$dados->totalvendas' where codproduto = '$produtoa'
                and empresa = '" . $_POST['empresa'] . "'";
                else :
                    $sql = "INSERT INTO temp_maisvendidos(empresa, codigo, codproduto, ref, descricao,
                        var1, var2, var3, saida, devolucao, grupo, totalvendas, totaldesconto, totaldevolucoes, totalcusto)
                        VALUES('$empresa', '$produtoa', '$produtoa', '$dados->ref', '$dados->descricao',
                          '$dados->var1', '$dados->var2', '$dados->var3', '', '$dados->qtd', '',
                              '0', '$dados->totaldesconto', '$dados->totalvendas', '$dados->custo')";
                endif;

            else :

                $produtoa = $dados->codigo;
                $verificaitem = VerificaItem($produtoa);

                if ($verificaitem > 0) :
                    $sql = "UPDATE temp_maisvendidos set devolucao = devolucao + '$dados->qtd', 
                        totaldevolucoes = totaldevolucoes + '$dados->totalvendas' where codproduto = '$produtoa'
                and empresa = '" . $_POST['empresa'] . "'";
                else :
                    $sql = "INSERT INTO temp_maisvendidos(empresa, codigo, codproduto, ref, descricao,
                        var1, var2, var3, saida, devolucao, grupo, totalvendas, totaldesconto, totaldevolucoes, totalcusto)
                        VALUES('$empresa', '$produtoa', '$produtoa', '$dados->ref', '$dados->descricao',
                          '$dados->var1', '$dados->var2', '$dados->var3', '0', '$dados->qtd', '',
                              '0', '$dados->totaldesconto', '$dados->totalvendas', '$dados->custo')";
                endif;
            endif;

        else :
            if ($_POST['agrupar'] == 'N') :
                $produtoa = $dados->codproduto;
                $verificaitem = VerificaItem($produtoa);

                if ($verificaitem > 0) :
                    $sql = "UPDATE temp_maisvendidos set saida = saida + '$dados->qtd', 
                        totalvendas = totalvendas + '$dados->totalvendas' where codproduto = '$produtoa'
                and empresa = '" . $_POST['empresa'] . "'";
                else :
                    $sql = "INSERT INTO temp_maisvendidos(empresa, codigo, codproduto, ref, descricao,
                        var1, var2, var3, saida, devolucao, grupo, totalvendas, totaldesconto, totaldevolucoes, totalcusto)
                        VALUES('$empresa', '$produtoa', '$produtoa', '$dados->ref', '$dados->descricao',
                          '$dados->var1', '$dados->var2', '$dados->var3', '$dados->qtd', '0', '',
                              '$dados->totalvendas', '$dados->totaldesconto', '0', '$dados->custo')";
                endif;

            else :

                $produtoa = $dados->codigo;
                $verificaitem = VerificaItem($produtoa);

                if ($verificaitem > 0) :
                    $sql = "UPDATE temp_maisvendidos set saida = saida + '$dados->qtd', 
                        totalvendas = totalvendas + '$dados->totalvendas' where codproduto = '$produtoa'
                and empresa = '" . $_POST['empresa'] . "'";
                else :
                    $sql = "INSERT INTO temp_maisvendidos(empresa, codigo, codproduto, ref, descricao,
                        var1, var2, var3, saida, devolucao, grupo, totalvendas, totaldesconto, totaldevolucoes, totalcusto)
                        VALUES('$empresa', '$produtoa', '$produtoa', '$dados->ref', '$dados->descricao',
                          '$dados->var1', '$dados->var2', '$dados->var3', '$dados->qtd', '0', '',
                              '$dados->totalvendas', '$dados->totaldesconto', '0', '$dados->custo')";
                endif;
            endif;
        endif;

        //echo $sql;

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'precoprodutos');

        $endereco = $crud->Sql($sql);

    endif;
endforeach;

//DEVOLUÇÃO
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');
$data = date("d/m");
$sql = 'select movimentacao_dev.documento, movimentacao_dev.data, movimentacao_dev.tipo, 
            movimentacao_dev.situacao, movimentacao_dev.finalizado, 
    movimentacao_dev.empresa, itmovimentacao_dev.documento, itmovimentacao_dev.preco, itmovimentacao_dev.cancelado,
    sum(itmovimentacao_dev.quantidade) as qtd, 
    sum(itmovimentacao_dev.quantidade) * itmovimentacao_dev.preco as total,
    sum(itmovimentacao_dev.valorliquido) as totaldevolucoes,
    itmovimentacao_dev.produto,';
//        if (!empty($_POST['grupo'])) :
//            $sql .= ' grupoprodutos.produto, grupoprodutos.grupo,';
//        endif;
$sql .= 'estoqueprodutos.produto as prod, estoqueprodutos.codproduto, 
    estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
    produtos.codigo, produtos.descricao, produtos.custo,  produtos.fornecedor,
    produtos.marca, produtos.categoria, produtos.ref from movimentacao_dev 
    INNER JOIN itmovimentacao_dev ON itmovimentacao_dev.documento = movimentacao_dev.documento 
    INNER JOIN estoqueprodutos ON estoqueprodutos.codproduto = itmovimentacao_dev.produto 
    INNER JOIN produtos ON produtos.codigo = estoqueprodutos.produto';
//        if (!empty($_POST['grupo'])) :
//            $sql .= ' INNER JOIN grupoprodutos ON produtos.codigo = grupoprodutos.produto';
//        endif;
$sql .= ' where 
    str_to_date(data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '" 
        and itmovimentacao_dev.cancelado <> "S"
        and movimentacao_dev.situacao = "F"
        and movimentacao_dev.tipo <> "D"';

if ($_POST['empresa'] !== 'T') :
    $empresa = $_POST['empresa'];
    $sql .= " AND movimentacao_dev.empresa = '" . $_POST['empresa'] . "'";
endif;

if (!empty($_POST['marca'])) :
    $sql .= ' AND marca = "' . $_POST['marca'] . '" ';
endif;

if (!empty($_POST['fornecedor'])) :
    $sql .= ' AND fornecedor = "' . $_POST['fornecedor'] . '" ';
endif;

if (!empty($_POST['categoria'])) :
    $sql .= ' AND categoria = "' . $_POST['categoria'] . '" ';
endif;

if (!empty($_POST['produtos'])) :
    $sql .= " AND codigo = '" . $_POST['produtos'] . "' ";
endif;

$sql .= ' GROUP by itmovimentacao_dev.produto ';
$sql .= ' ORDER BY total DESC';

//        echo $sql;
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$total = 0;
foreach ($dados as $dadost) :
    $total = $total + $dadost->total;
endforeach;

$panterior = 0;
$tqtd = 0;
$ttotal = 0;
$tcusto = 0;
$gera = 'S';
foreach ($dados as $dados) :

    if (!empty($_POST['grupo'])) :
        $tgrupo = 0;
        $grupo = str_replace('.00', '', $_POST['grupo']);
        $tgrupo = VerificaGrupo($dados->codigo, $grupo);
        if ($tgrupo > 0) :
            $gera = 'S';
        else :
            $gera = 'N';
        endif;
    endif;

    if ($gera == 'S') :

        if ($_POST['agrupar'] == 'N') :
            $produtoa = $dados->codproduto;
            $sql = "UPDATE temp_maisvendidos set devolucao = '$dados->qtd', totaldevolucoes = totaldevolucoes + '$dados->totaldevolucoes' where codproduto = '$produtoa'
                and empresa = '" . $_POST['empresa'] . "'";
        else :
            $produtoa = $dados->codigo;
            $sql = "UPDATE temp_maisvendidos set devolucao = '$dados->qtd', totaldevolucoes = totaldevolucoes + '$dados->totaldevolucoes' where codproduto = '$produtoa'
                and empresa = '" . $_POST['empresa'] . "'";
        endif;

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'precoprodutos');

        $endereco = $crud->Sql($sql);

    endif;
endforeach;
?>

<html>
    <head>
        <title> Relatório </title>
        <style>

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

            .page {
                width: 21cm;
                min-height: 29.7cm;
                padding: 2cm;
                margin: 1cm auto;
                border: 1px #D3D3D3 solid;
                border-radius: 5px;
                background: white;
                box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
            }
        </style>
    <body>
        <div align="center">
            EVOLUÇÃO DE VENDAS - AGRUPAMENTO MERCADORIAS
            <Br/> 
            PERÍODO: <?= $_POST['datai'] ?> À <?= $_POST['dataf'] ?>
            <?php
            if (!empty($_POST['grupo'])) :
                ?>
                <br/>
                GRUPO : <?= $_POST['grupo'] ?> - <?= buscaGrupo($_POST['grupo']) ?>
                <?php
            endif;
            ?>
            <?php
            if ($_POST['empresa'] !== 'T') :
                ?>
                <br/>
                FILIAL : <?= BuscaEmpresa($_POST['empresa']) ?>
                <?php
            else :
                ?>
                <br/>
                FILIAL : TODAS
            <?php
            endif;
            ?>
        </div>

        <?php require_once './cabecalho.php'; ?>
        <table class="table table-condensed text-center" style="font-size: 12px; width: 100%; text-align: left">
            <tr>
                <td><b>Código</b></td>
                <td><b>Ref</b></td>
                <td><b>Descrição</b></td>
                <?php
                if ($_POST['agrupar'] == 'N') :
                    if ($parametros->grade === 'S') :
                        ?>
                        <td><b>Var 1</b></td>
                        <td><b>Var 2</b></td>
                        <td><b>Var 3</b></td>
                        <?php
                    endif;
                endif;
                ?>
                <td><b>Qtd</b></td>
                <td><b>Preço Médio</b></td>
                <td><b>Total Vendas</b></td>
                <td><b>Total Dev.</b></td>
                <td><b>Total Des.</b></td>
                <td><b>Total Geral </b></td>
                <td><b>Custo Total</b></td>
                <td><b>% Lucro</b></td>
                <td><b>% Faturado</b></td>

            </tr>

            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'caixa');
            $sql = "SELECT empresa, codigo, codproduto,descricao, ref,var1,var2,var3,saida,devolucao,grupo,totalvendas,
                totaldevolucoes,totaldesconto, totalcusto, totalvendas - totaldevolucoes - totaldesconto as totalgeral, saida - devolucao as qtd from temp_maisvendidos WHERE 1=1";

            if ($_POST['empresa'] !== 'T') :
                $empresa = $_POST['empresa'];
                $sql .= " AND empresa = '" . $_POST['empresa'] . "'";
            endif;

            if ($_POST['ordenar'] === 'F') :
                $sql .= ' ORDER BY totalgeral DESC';
            else :
                $sql .= ' ORDER BY qtd DESC';
            endif;

            $arrayParam = '';
            $dadosrel = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

            $total = 0;
            foreach ($dadosrel as $dadost) :
                $total = $total + $dadost->totalgeral;
            endforeach;

            $panterior = 0;
            $tqtd = 0;
            $ttotal = 0;
            $tcusto = 0;
            $tdev = 0;
            $tdesc = 0;
            $tvenda = 0;
            foreach ($dadosrel as $dadosg) :
                if ($_POST['negativo'] == 'N' && $dadosg->qtd <= 0) :
                    echo '';
                else :
                    $totalcusto = $dadosg->totalcusto * $dadosg->qtd;
                    $acumulada = CalculaP($dadosg->totalgeral, $total) + $panterior;
                    $classificao = Classificao($acumulada);
                    $tqtd = $tqtd + $dadosg->qtd;
                    $tcusto = $tcusto + ($dadosg->totalcusto * $dadosg->qtd);
                    $ttotal = $ttotal + $dadosg->totalgeral;
                    $tdev = $tdev + $dadosg->totaldevolucoes;
                    $tdesc = $tdesc + $dadosg->totaldesconto;
                    $tvenda = $tvenda + $dadosg->totalvendas;
                    ?>
                    <tr>
                        <td><?= $dadosg->codproduto ?></td>
                        <td><?= $dadosg->ref ?></td>
                        <td><?= $dadosg->descricao ?></td>
                        <?php
                        if ($_POST['agrupar'] == 'N') :
                            if ($parametros->grade === 'S') :
                                ?>
                                <td><?= $dadosg->var1 ?></td>
                                <td><?= $dadosg->var2 ?></td>
                                <td><?= $dadosg->var3 ?></td>

                                <?php
                            endif;
                        endif;
                        ?>
                        <td><?php
                            if (floor($dadosg->qtd) != $dadosg->qtd) :
                                echo $dadosg->qtd;
                            else :
                                echo intval($dadosg->qtd);
                            endif;
                            ?></td>
                        <td>R$ <?= number_format($dadosg->totalgeral / $dadosg->qtd, 2, ',', '') ?></td>
                        <td>R$ <?= number_format($dadosg->totalvendas, 2, ',', '') ?></td>
                        <td>R$ <?= number_format($dadosg->totaldevolucoes, 2, ',', '') ?></td>
                        <td>R$ <?= number_format($dadosg->totaldesconto, 2, ',', '') ?></td>
                        <td>R$ <?= number_format($dadosg->totalgeral, 2, ',', '') ?></td>
                        <td>R$ <?= number_format($totalcusto, 2, ',', '') ?></td>
                        <td><?= number_format(CalculaPCusto($dadosg->totalgeral - $totalcusto, $dadosg->totalgeral), 2, ',', '') ?> %</td>        
                        <td><?= number_format(CalculaP($dadosg->totalgeral, $total), 2, ',', '') ?> %</td>        

                    </tr>
                <?php
                endif;
            endforeach;
            ?>


            <tr>
                <?php
                if ($_POST['agrupar'] == 'N') :
                    if ($parametros->grade === 'S') :
                        ?>
                        <td colspan="6"><hr/> TOTAIS</td>
                        <?php
                    else :
                        ?>
                        <td colspan="3"> <hr/>  TOTAIS</td>
                    <?php
                    endif;
                else :
                    ?>
                    <td colspan="3"> <hr/>  TOTAIS</td>
                <?php
                endif;
                ?>
                <td> <hr/> <?= number_format($tqtd, 2, ',', '') ?></td>
                <td> <hr/>  </td>             
                <td> <hr/>  R$ <?= number_format($tvenda, 2, ',', '.') ?></td>
                <td> <hr/>  R$ <?= number_format($tdev, 2, ',', '.') ?></td>
                <td> <hr/>  R$ <?= number_format($tdesc, 2, ',', '.') ?></td>
                <td> <hr/>  R$ <?= number_format($ttotal, 2, ',', '.') ?></td>
                <td> <hr/>  R$ <?= number_format($tcusto, 2, ',', '.') ?></td>
                <td> <hr/> <?= number_format(CalculaPCusto($ttotal - $tcusto, $ttotal), 2, ',', '') ?> %</td>
                <td> <hr/>  <?= number_format('0', 2, ',', '.') ?> %</td>
            </tr>
        </table>



    </body>
</html>
<?php
if ($_POST['gerar'] == 'PDF') :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4-L'
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
elseif ($_POST['gerar'] == 'EXCEL') :
    $file = 'MaisVendidos.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
else :
    echo '';
endif;
?>