<?php
ob_start();
date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";

function buscaGrupo($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from temp_maisvendidos where codigo = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, true);

    $total = count($dados);
    return $total;
}

function BuscaEmpresa($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from emitente where emitenteid = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->xNome;
}

function VerificaItem($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from temp_maisvendidos where codproduto = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, true);
    return count($dados);
}

function VerificaGrupo($produto, $grupo) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from grupoprodutos where grupo like '" . $grupo . "%' AND produto = '$produto'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, true);
    $total = count($dados);
//    echo $sql;
    return $total;
}

function CalculaP($valor, $total) {
    $valor1 = $valor / $total;
    $porcentagem = $valor1 * 100;

//    return number_format($porcentagem, 2, ',', '');
    return $porcentagem;
}

function CalculaPCusto($valor, $total) {
    $valor1 = $valor / $total;
    $porcentagem = $valor1 * 100;

//    return number_format($porcentagem, 2, ',', '');
    return $porcentagem;
}

function Classificao($porc) {
    if ($porc < 80) :
        return 'A';
    elseif ($porc < 95) :
        return 'B';
    else :
        return 'C';
    endif;
}

function BuscaVariacaoDesccuva($prod, $variacao, $sigla, $nivel) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT produtos.variacao, produtos.codigo, 
                    variacao.variacaoid, variacao.var1, variacao.var2, 
                    variacao.var3 ,
                    itensvariacao.variacao, itensvariacao.sigla,
                    itensvariacao.descricao, itensvariacao.nivel
                    FROM produtos 
                    INNER JOIN variacao ON produtos.variacao = variacao.variacaoid 
                    INNER JOIN itensvariacao ON itensvariacao.variacao = variacao.variacaoid                   
                    WHERE codigo = '$prod' 
                    AND itensvariacao.nivel = '$nivel'
                    AND itensvariacao.sigla = '$sigla'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->descricao;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');
$sql = "DELETE FROM temp_evolucaovendas_forn";
if ($_POST['empresa'] !== 'T') :
    $empresa = $_POST['empresa'];
    $sql .= " where empresa = '" . $_POST['empresa'] . "'";
endif;
$deletetemp = $crud->Sql($sql);

$data_incio1 = mktime(0, 0, 0, date('m'), 1, date('Y'));
$data_fim1 = mktime(23, 59, 59, date('m'), date("t"), date('Y'));
$inicio1 = parseDate($_POST['datai'], "Y-m-d");
$fim1 = parseDate($_POST['dataf'], "Y-m-d");
//SAIDA
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');
$data = date("d/m");
$sql = 'select movimentacao.documento, movimentacao.data, movimentacao.tipo, 
            movimentacao.situacao, movimentacao.finalizado, movimentacao.operacao, 
    movimentacao.empresa, itmovimentacao.documento, itmovimentacao.preco,  itmovimentacao.cancelado,
    sum(itmovimentacao.quantidade) as qtd, 
    sum(itmovimentacao.quantidade) * itmovimentacao.preco as total,
    sum(itmovimentacao.valorliquido) as totalvendas,
    sum(itmovimentacao.desc_rateio)  as totaldesconto,
    itmovimentacao.produto,
    estoqueprodutos.produto as prod, estoqueprodutos.codproduto, 
    estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
    produtos.custo,
    produtos.codigo, produtos.descricao,  produtos.fornecedor, 
    produtos.marca,  produtos.categoria, produtos.ref,
    fornecedor.xNome, fornecedor.fornecedorid, fornecedor.xFant from movimentacao 
    LEFT JOIN itmovimentacao ON itmovimentacao.documento = movimentacao.documento 
    LEFT JOIN estoqueprodutos ON estoqueprodutos.codproduto = itmovimentacao.produto 
    LEFT JOIN produtos ON produtos.codigo = estoqueprodutos.produto
    LEFT JOIN fornecedor ON fornecedor.fornecedorid = produtos.fornecedor
      ';

$sql .= ' where 
    str_to_date(data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '" 
        and itmovimentacao.cancelado <> "S"
        and movimentacao.situacao = "F"
        and movimentacao.tipo <> "R"
       
        ';

if ($_POST['empresa'] !== 'T') :
    $empresa = $_POST['empresa'];
    $sql .= " AND movimentacao.empresa = '" . $_POST['empresa'] . "'";
endif;

if (!empty($_POST['marca'])) :
    $sql .= ' AND marca = "' . $_POST['marca'] . '" ';
endif;

if (!empty($_POST['fornecedor'])) :
    $sql .= ' AND fornecedor = "' . $_POST['fornecedor'] . '" ';
endif;

if (!empty($_POST['categoria'])) :
    $sql .= ' AND categoria = "' . $_POST['categoria'] . '" ';
endif;

if (!empty($_POST['operacao'])) :
    if ($_POST['operacao'] != 'T') :
        $sql .= ' AND operacao = "' . $_POST['operacao'] . '" ';
    endif;
endif;

if (!empty($_POST['produtos'])) :
    $sql .= " AND codigo = '" . $_POST['produtos'] . "' ";
endif;

$sql .= ' GROUP BY itmovimentacao.produto, produtos.fornecedor';
$sql .= ' ORDER BY totalvendas DESC';

//        echo $sql;
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$total = 0;
foreach ($dados as $dadost) :
    $total = $total + $dadost->total;
endforeach;

$panterior = 0;
$tqtd = 0;
$ttotal = 0;
$tcusto = 0;
$gera = 'S';
foreach ($dados as $dados) :

    $totalcusto = $dados->qtd * $dados->custo;

    $sql = "INSERT INTO temp_evolucaovendas_forn(fornecedor, fornecedornome,
        totalvendas,totalcustovendas, empresa, operacao, totalitens, totalitensdev,
        totaldev,totalcustodev)
        VALUES('$dados->fornecedorid', '$dados->xFant', '$dados->totalvendas', 
            '$totalcusto', '$empresa', 'S', '$dados->qtd', '0', '0', '0')";

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'temp_evolucaovendas_forn');

    $endereco = $crud->Sql($sql);

endforeach;

//TROCA
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');
$data = date("d/m");
$sql = 'select movimentacao_troca.documento, movimentacao_troca.data, movimentacao_troca.tipo, 
            movimentacao_troca.situacao, movimentacao_troca.finalizado,
    movimentacao_troca.empresa, itmovimentacao_troca.documento, itmovimentacao_troca.preco,  itmovimentacao_troca.cancelado,
    sum(itmovimentacao_troca.quantidade) as qtd, 
    sum(itmovimentacao_troca.quantidade) * itmovimentacao_troca.preco as total,
    sum(itmovimentacao_troca.valorliquido) as totalvendas,
    sum(itmovimentacao_troca.desc_rateio)  as totaldesconto, itmovimentacao_troca.operacao,
    itmovimentacao_troca.produto,
    estoqueprodutos.produto as prod, estoqueprodutos.codproduto, 
    estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
    produtos.custo,
    produtos.codigo, produtos.descricao,  produtos.fornecedor, 
    produtos.marca,  produtos.categoria, produtos.ref,
    fornecedor.xNome, fornecedor.fornecedorid, fornecedor.xFant from movimentacao_troca 
    INNER JOIN itmovimentacao_troca ON itmovimentacao_troca.documento = movimentacao_troca.documento 
    INNER JOIN estoqueprodutos ON estoqueprodutos.codproduto = itmovimentacao_troca.produto 
    INNER JOIN produtos ON produtos.codigo = estoqueprodutos.produto
    LEFT JOIN fornecedor ON fornecedor.fornecedorid = produtos.fornecedor';
$sql .= ' where 
    str_to_date(data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '" 
        and itmovimentacao_troca.cancelado <> "S"
        and movimentacao_troca.situacao = "F"
        and movimentacao_troca.tipo <> "D"
        ';

if ($_POST['empresa'] !== 'T') :
    $empresa = $_POST['empresa'];
    $sql .= " AND movimentacao_troca.empresa = '" . $_POST['empresa'] . "'";
endif;

if (!empty($_POST['marca'])) :
    $sql .= ' AND marca = "' . $_POST['marca'] . '" ';
endif;

if (!empty($_POST['fornecedor'])) :
    $sql .= ' AND fornecedor = "' . $_POST['fornecedor'] . '" ';
endif;

if (!empty($_POST['categoria'])) :
    $sql .= ' AND categoria = "' . $_POST['categoria'] . '" ';
endif;

if (!empty($_POST['produtos'])) :
    $sql .= " AND codigo = '" . $_POST['produtos'] . "' ";
endif;

$sql .= ' GROUP BY itmovimentacao_troca.produto, itmovimentacao_troca.operacao, produtos.fornecedor';
$sql .= ' ORDER BY totalvendas DESC';
//      echo $sql;
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$total = 0;
foreach ($dados as $dadost) :
    $total = $total + $dadost->total;
endforeach;

$panterior = 0;
$tqtd = 0;
$ttotal = 0;
$tcusto = 0;
$gera = 'S';
foreach ($dados as $dados) :

    if ($dados->operacao == 'S') :
        $totalcusto = $dados->qtd * $dados->custo;

        $sql = "INSERT INTO temp_evolucaovendas_forn(fornecedor, fornecedornome,
        totalvendas,totalcustovendas, empresa, operacao, totalitens, totalitensdev,
        totaldev,totalcustodev)
        VALUES('$dados->fornecedorid', '$dados->xFant', '$dados->totalvendas', '$totalcusto',
            '$empresa', '$dados->operacao', '$dados->qtd' ,'0', '0', '0')";
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'temp_evolucaovendas_forn');
        $endereco = $crud->Sql($sql);
    else :
        $totalcusto = $dados->qtd * $dados->custo;

        $sql = "INSERT INTO temp_evolucaovendas_forn(fornecedor, fornecedornome,
        totaldev,totalcustodev, empresa, operacao, totalitensdev, totalvendas,totalcustovendas, totalitens)
        VALUES('$dados->fornecedorid', '$dados->xFant', '$dados->totalvendas', 
            '$totalcusto', '$empresa', 'E', '$dados->qtd', '0', '0', '0')";

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'temp_evolucaovendas_forn');

        $endereco = $crud->Sql($sql);
    endif;

endforeach;

//DEVOLUÇÃO
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');
$data = date("d/m");
$sql = 'select movimentacao_dev.documento, movimentacao_dev.data, movimentacao_dev.tipo, 
            movimentacao_dev.situacao, movimentacao_dev.finalizado,
    movimentacao_dev.empresa, itmovimentacao_dev.documento, itmovimentacao_dev.preco,  itmovimentacao_dev.cancelado,
    sum(itmovimentacao_dev.quantidade) as qtd, 
    sum(itmovimentacao_dev.quantidade) * itmovimentacao_dev.preco as total,
    sum(itmovimentacao_dev.valorliquido) as totalvendas,
    itmovimentacao_dev.produto,
    estoqueprodutos.produto as prod, estoqueprodutos.codproduto, 
    estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
    produtos.custo,
    produtos.codigo, produtos.descricao,  produtos.fornecedor, 
    produtos.marca,  produtos.categoria, produtos.ref,
    fornecedor.xNome, fornecedor.fornecedorid, fornecedor.xFant from movimentacao_dev 
    INNER JOIN itmovimentacao_dev ON itmovimentacao_dev.documento = movimentacao_dev.documento 
    INNER JOIN estoqueprodutos ON estoqueprodutos.codproduto = itmovimentacao_dev.produto 
    INNER JOIN produtos ON produtos.codigo = estoqueprodutos.produto
    LEFT JOIN fornecedor ON fornecedor.fornecedorid = produtos.fornecedor';
$sql .= ' where 
    str_to_date(data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '" 
        and itmovimentacao_dev.cancelado <> "S"
        and movimentacao_dev.situacao = "F"
        and movimentacao_dev.tipo <> "D"';

if ($_POST['empresa'] !== 'T') :
    $empresa = $_POST['empresa'];
    $sql .= " AND movimentacao_dev.empresa = '" . $_POST['empresa'] . "'";
endif;

if (!empty($_POST['marca'])) :
    $sql .= ' AND marca = "' . $_POST['marca'] . '" ';
endif;

if (!empty($_POST['fornecedor'])) :
    $sql .= ' AND fornecedor = "' . $_POST['fornecedor'] . '" ';
endif;

if (!empty($_POST['categoria'])) :
    $sql .= ' AND categoria = "' . $_POST['categoria'] . '" ';
endif;

if (!empty($_POST['produtos'])) :
    $sql .= " AND codigo = '" . $_POST['produtos'] . "' ";
endif;

$sql .= ' GROUP BY itmovimentacao_dev.codigo, produtos.fornecedor ';
$sql .= ' ORDER BY totalvendas DESC ';

//        echo $sql;
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$total = 0;
foreach ($dados as $dadost) :
    $total = $total + $dadost->total;
endforeach;

$panterior = 0;
$tqtd = 0;
$ttotal = 0;
$tcusto = 0;
$gera = 'S';
foreach ($dados as $dados) :

    $totalcusto = $dados->qtd * $dados->custo;

    $sql = "INSERT INTO temp_evolucaovendas_forn(fornecedor, fornecedornome,
        totaldev,totalcustodev, empresa, operacao, totalitensdev, totalvendas,totalcustovendas, totalitens)
        VALUES('$dados->fornecedorid', '$dados->xFant', '$dados->totalvendas', '$totalcusto', 
            '$empresa', 'E', '$dados->qtd', '0','0','0')";

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'temp_evolucaovendas_forn');

    $endereco = $crud->Sql($sql);
endforeach;
?>

<html>
    <head>
        <title> Relatório </title>
        <style>

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

            .page {
                width: 21cm;
                min-height: 29.7cm;
                padding: 2cm;
                margin: 1cm auto;
                border: 1px #D3D3D3 solid;
                border-radius: 5px;
                background: white;
                box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
            }
        </style>
    <body>
        <div align="center">
            EVOLUÇÃO DE VENDAS - AGRUPAMENTO FORNECEDORES
            <Br/> 
            PERÍODO: <?= $_POST['datai'] ?> À <?= $_POST['dataf'] ?>

            <?php
            if ($_POST['empresa'] !== 'T') :
                ?>
                <br/>
                FILIAL : <?= BuscaEmpresa($_POST['empresa']) ?>
                <?php
            else :
                ?>
                <br/>
                FILIAL : TODAS
            <?php
            endif;
            ?>
        </div>

        <?php require_once './cabecalho.php'; ?>
        <table class="table table-condensed text-center" style="font-size: 12px; width: 100%; text-align: left">
            <tr>
                <td><b>Fornecedor</b></td>
                <td><b>Total Vendas</b></td>
                <td><b>Total de Dev.</b></td>  
                <td><b>Itens Vendas</b></td>
                <td><b>Itens Dev.</b></td>
                <td><b>Geral</b></td>
                <td><b>Custo Total</b></td>
                <td><b>Total Itens</b></td>
                <td><b>% Lucro</b></td>
                <td><b>% Faturado</b></td>

            </tr>

            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'caixa');
            $sql = "SELECT temp_evolucaovendas_forn.fornecedor, temp_evolucaovendas_forn.fornecedornome, 
SUM(temp_evolucaovendas_forn.totalitens) AS totalitens,
SUM(temp_evolucaovendas_forn.totalitensdev) AS totalitensdev,
SUM(temp_evolucaovendas_forn.totalvendas) AS totalvendas,
SUM(temp_evolucaovendas_forn.totaldev) AS totaldev,
SUM(temp_evolucaovendas_forn.totalitens) - SUM(temp_evolucaovendas_forn.totalitensdev) AS qtd,
SUM(temp_evolucaovendas_forn.totalvendas) - SUM(temp_evolucaovendas_forn.totaldev) AS totalgeral,
SUM(temp_evolucaovendas_forn.totalcustovendas) AS custovendas,
SUM(temp_evolucaovendas_forn.totalcustodev) AS custodev,
SUM(temp_evolucaovendas_forn.totalcustovendas) - SUM(temp_evolucaovendas_forn.totalcustodev) AS custogeral
FROM temp_evolucaovendas_forn  
WHERE 1=1";

            if ($_POST['empresa'] !== 'T') :
                $empresa = $_POST['empresa'];
                $sql .= " AND empresa = '" . $_POST['empresa'] . "'";
            endif;

            $sql .= ' GROUP BY temp_evolucaovendas_forn.fornecedor ';
            $sql .= ' ORDER BY totalgeral DESC';

            $arrayParam = '';
            $dadosrel = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

            $total = 0;
            foreach ($dadosrel as $dadost) :
                $total = $total + $dadost->totalgeral;
            endforeach;

            $panterior = 0;
            $tqtd = 0;
            $ttotal = 0;
            $tcusto = 0;
            $tdev = 0;
            $tdesc = 0;
            $tvenda = 0;
            $titenv = 0;
            $titend = 0;
            foreach ($dadosrel as $dadosg) :

                $totalcusto = $dadosg->custogeral;
                $acumulada = CalculaP($dadosg->totalgeral, $total) + $panterior;
                $classificao = Classificao($acumulada);
                $tqtd = $tqtd + $dadosg->qtd;
                $titenv = $titenv + $dadosg->totalitens;
                $titend = $titend + $dadosg->totalitensdev;
                $tcusto = $tcusto + $dadosg->custogeral;
                $ttotal = $ttotal + $dadosg->totalgeral;
                $tdev = $tdev + $dadosg->totaldev;
                $tdesc = $tdesc + $dadosg->totaldesconto;
                $tvenda = $tvenda + $dadosg->totalvendas;

                if (empty($dadosg->fornecedor)) :
                    $dadosg->fornecedor = '0';
                    $dadosg->fornecedornome = 'SEM FORNECEDOR';
                endif;
                ?>
                <tr>
                    <td><?= $dadosg->fornecedor ?> - <?= $dadosg->fornecedornome ?></td>
                    <td>R$ <?= number_format($dadosg->totalvendas, 2, ',', '') ?></td>
                    <td>R$ <?= number_format($dadosg->totaldev, 2, ',', '') ?></td>
                    <td><?= intval($dadosg->totalitens) ?></td>
                    <td><?= intval($dadosg->totalitensdev) ?></td>
                    <td>R$ <?= number_format($dadosg->totalgeral, 2, ',', '') ?></td>
                    <td>R$ <?= number_format($totalcusto, 2, ',', '') ?></td>
                    <td><?= intval($dadosg->qtd) ?></td>
                    <td><?= number_format(CalculaPCusto($dadosg->totalgeral - $totalcusto, $dadosg->totalgeral), 2, ',', '') ?> %</td>        
                    <td><?= number_format(CalculaP($dadosg->totalgeral, $total), 2, ',', '') ?> %</td>        

                </tr>
                <?php
            endforeach;
            ?>


            <tr>
                <td><hr/> TOTAIS</td>
                <td> <hr/>  R$ <?= number_format($tvenda, 2, ',', '.') ?></td>
                <td> <hr/>  R$ <?= number_format($tdev, 2, ',', '.') ?></td>
                <td> <hr/> <?= number_format($titenv, 2, ',', '') ?></td>
                <td> <hr/> <?= number_format($titend, 2, ',', '') ?></td>
                <td> <hr/>  R$ <?= number_format($ttotal, 2, ',', '.') ?></td>
                <td> <hr/>  R$ <?= number_format($tcusto, 2, ',', '.') ?></td>
                <td> <hr/>  <?= intval($tqtd) ?></td>
                <td> <hr/> <?= number_format(CalculaPCusto($ttotal - $tcusto, $ttotal), 2, ',', '') ?> %</td>
                <td> <hr/>  <?= number_format('0', 2, ',', '.') ?> %</td>
            </tr>
        </table>



    </body>
</html>
<?php
if ($_POST['gerar'] == 'PDF') :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4-L'
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
elseif ($_POST['gerar'] == 'EXCEL') :
    $file = 'MaisVendidos.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
else :
    echo '';
endif;
?>