<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>
        <style>
            /*@import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";*/

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

        </style>
    </head>
    <?php
    date_default_timezone_set("Brazil/East");
    require_once("../../../functions.php");
//
    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/parametros.php";

    function BuscaEmpresa($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT * from emitente where emitenteid = '$valor'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

        return $dados->xNome;
    }
    ?>

    <body>
        <div align="center">
            ESTOQUE AGRUPADO POR GRUPOS
            <?php
            if ($_POST['empresa'] !== 'T') :
                ?>
                <br/>
                FILIAL : <?= BuscaEmpresa($_POST['empresa']) ?>
                <?php
            else :
                ?>
                <br/>
                FILIAL : TODAS
            <?php
            endif;
            ?>
        </div>

        <table class="table table-condensed text-center" style="font-size: 12px; width: 100%; text-align: left">
            <tr>
                <td><b>Grupo</b></td>
                <td><b>Quantidade</b></td>
                <td><b>Custo Total</b></td>
            </tr>

            <?php

            $formato = $_POST['formato'];
//            $formato = 'A';
            function BuscaEstoque($fornecedor, $empresa, $formato) {
                $estoque = 'qtd' . $empresa;
                $grupo = str_replace('.00', '', $fornecedor);
                $pdo = Conexao::getInstance();
                $crud = Crud::getInstance($pdo, 'estoqueprodutos');
                $sql = "SELECT produtos.codigo, produtos.custo, produtos.fornecedor,
estoqueprodutos.codproduto, estoqueprodutos.produto, sum(estoqueprodutos.$estoque) AS estoque,
sum(estoqueprodutos.$estoque) * produtos.custo AS custototal,
grupoprodutos.produto, grupoprodutos.grupo
from estoqueprodutos 
INNER JOIN produtos ON estoqueprodutos.produto = produtos.codigo
INNER JOIN grupoprodutos ON grupoprodutos.produto = produtos.codigo
WHERE estoqueprodutos.$estoque > 0";

                if ($formato == 'A') :
                    $sql .= " AND grupoprodutos.grupo LIKE '$grupo%'
GROUP BY estoqueprodutos.produto";
                else :
                    $sql .= " AND grupoprodutos.grupo = '$fornecedor'
GROUP BY estoqueprodutos.produto";
                endif;

                $arrayParam = '';
                $dados = $crud->getSQLGeneric($sql, $arrayParam, true);
               //echo $sql;

                $estoque = 0;
                $total = 0;
                foreach ($dados as $dados) :
                    $estoque = $estoque + $dados->estoque;
                    $total = $total + $dados->custototal;
                endforeach;

                $retorno = array("estoque" => $estoque, "total" => $total);
                return $retorno;
            }

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'fornecedor');
            $sql = "SELECT * FROM grupos WHERE 1=1";

            if ($formato == 'A') :
                $sql .= " AND nivel = '1'";
            endif;

            if (!empty($_POST['grupos'])) :
                $grupo = str_replace('.00', '', $_POST['grupos']);
                $sql .= " AND sequencia LIKE '" . $grupo . "%' ";
            endif;

            $sql .= " order by sequencia ASC";
            $arrayParam = '';
            $dadosf = $crud->getSQLGeneric($sql, $arrayParam, true);

//            echo $sql;
            foreach ($dadosf as $dados) :
                $dadosestoque = BuscaEstoque($dados->sequencia, $_POST['empresa'], $formato);
                if ($dadosestoque['estoque'] > 0) :
                    $totalestoque = $totalestoque + $dadosestoque['estoque'];
                    $custoestoque = $custoestoque + $dadosestoque['total'];
                    ?>
                    <tr>
                        <td style="width: 70%;"><?= $dados->sequencia . ' - ' . $dados->descricao ?></td>
                        <td><?= intval($dadosestoque['estoque']) ?></td>
                        <td>R$ <?= number_format($dadosestoque['total'], 2, ',', '') ?></td>
                    </tr>

                    <?php
                endif;
            endforeach;
            ?>

            <tr>
                <td><b>TOTAIS</b></td>
                <td><b> <?= intval($totalestoque) ?></b></td>
                <td><b>R$ <?= number_format($custoestoque, 2, ',', '.') ?></b></td>
            </tr>
        </table>

    </body>
</html>
<?php
//print_r($_POST);
if ($_POST['gerar'] == 'PDF') :

    require_once("../../_inc/mpdf/vendor/autoload.php");
    ini_set("pcre.backtrack_limit", "500000000000000");

    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
elseif ($_POST['gerar'] == 'EXCEL') :
//    error_reporting(E_ALL);
//ini_set('display_errors', 'On');
    $file = 'estoque.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");

else :

endif;
?>