<?php
ob_start();

date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";
?>
<html>
    <head>
        <title> Relatório </title>
        <style>

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

            .page {
                width: 21cm;
                min-height: 29.7cm;
                padding: 2cm;
                margin: 1cm auto;
                border: 1px #D3D3D3 solid;
                border-radius: 5px;
                background: white;
                box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
            }
        </style>
        <?php
        if ($_POST['gerar'] != 'PDF') :
            ?>
            <link href="../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
            <?php
        endif;

        $data_incio1 = mktime(0, 0, 0, date('m'), 1, date('Y'));
        $data_fim1 = mktime(23, 59, 59, date('m'), date("t"), date('Y'));
        $inicio1 = parseDate($_POST['datai'], "Y-m-d");
        $fim1 = parseDate($_POST['dataf'], "Y-m-d");
        $para = $_POST['para'];

        if ($para == 'R') :
            $agroup = 'representante';
            $tit = 'Representante';
        elseif ($para == 'F') :
            $agroup = 'funcionario';
            $tit = 'Funcionário';
        else :
            $agroup = 'cliente';
            $tit = 'Cliente';
        endif;
        ?>
    </head>
    <body>

        <div align="center">
            CURVA ABC <?= strtoupper($tit) ?>S
            <Br/> 
            PERÍODO: <?= $_POST['datai'] ?> À <?= $_POST['dataf'] ?>
        </div>

        <?php require_once './cabecalho.php'; ?>

        <?php

        function CalculaP($valor, $total) {
            $valor1 = $valor / $total;
            $porcentagem = $valor1 * 100;

//    return number_format($porcentagem, 2, ',', '');
            return $porcentagem;
        }

        function Classificao($porc, $a, $b) {
            if ($porc < $a) :
                return 'A';
            elseif ($porc < ($a + $b)) :
                return 'B';
            else :
                return 'C';
            endif;
        }

        function BuscaPara($valor, $id) {

            if ($valor == 'R') :
                $sql = "SELECT * from representante where representanteid = '$id' ";
            elseif ($valor == 'F') :
                $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
            else :
                $sql = "SELECT * from cliente where clienteid = '$id' ";
            endif;

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'tabela');
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

            return $dados;
        }

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'cliente');
        $data = date("d/m");
        $sql = 'select movimentacao.documento, movimentacao.data, movimentacao.finalizado, movimentacao.situacao,
    movimentacao.empresa, sum(movimentacao.valorpago) as total, movimentacao.para,
movimentacao.cliente, movimentacao.representante, movimentacao.funcionario
from movimentacao 
     where str_to_date(data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '" 
        AND movimentacao.situacao = "F"
        AND movimentacao.tipo <> "C"
        AND movimentacao.empresa = "' . $_SESSION['Empresa'] . '"
        AND movimentacao.para = "' . $para . '"';

        if ($_POST['consumidor'] == 'N') :
            $sql .= ' and cliente > "1"';
        endif;

        $sql .= 'GROUP by movimentacao.' . $agroup . '
    ORDER BY total DESC';
//echo $sql;
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

        $total = 0;

        foreach ($dados as $dadost) :
            $total = $total + $dadost->total;
        endforeach;

//print_r($dados);
        ?>

        <table class="table table-condensed text-center" style="font-size: 12px; width: 100%; text-align: left">
            <tr>
                <td><b><?= $tit ?></b></td>
                <td><b>Valor Total</b></td>
                <td><b>% Individual</b></td>
                <td><b>% Acumulada</b></td>
                <td><b>Classificação</b></td>
            </tr>
            <?php
            $panterior = 0;
            foreach ($dados as $dados) :
                $acumulada = CalculaP($dados->total, $total) + $panterior;
                $classificao = Classificao($acumulada, $_POST['curvaa'], $_POST['curvab']);

                if ($dados->para == 'R') :
                    $dest = BuscaPara('R', $dados->representante);
                    $id = $dest->representanteid;
                elseif ($dados->para == 'F') :
                    $dest = BuscaPara('F', $dados->funcionario);
                    $id = $dest->funcionarioid;
                else :
                    $dest = BuscaPara('C', $dados->cliente);
                    $id = $dest->clienteid;
                endif;
                ?>
                <tr>
                    <td><?= $id ?> - <?= $dest->xNome ?></td>
                    <td>R$ <?= number_format($dados->total, 2, ',', '.') ?></td>
                    <td><?= number_format(CalculaP($dados->total, $total), 2, ',', '') ?> %</td>
                    <td><?php
                        echo number_format($acumulada, 2, ',', '') . ' %';
                        ?></td>
                    <td><?= Classificao($acumulada, $_POST['curvaa'], $_POST['curvab']) ?></td>
                </tr>
                <?php
                $panterior = CalculaP($dados->total, $total) + $panterior;
            endforeach;
            ?>
        </table>

    </body>
</html>
<?php
if ($_POST['gerar'] == 'EXCEL') :
    //    $data = parseDate($_POST['data'], "dmY");
    $file = 'curvaAbcClientes.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
    echo "\xEF\xBB\xBF"; // Adiciona o BOM para UTF-8
elseif ($_POST['gerar'] == 'PDF') :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4-L'
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
endif;
?>