<?php
ob_start();

date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";
?>
<html>
    <head>
        <title> Relatório </title>
        <style>

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

            .page {
                width: 21cm;
                min-height: 29.7cm;
                padding: 2cm;
                margin: 1cm auto;
                border: 1px #D3D3D3 solid;
                border-radius: 5px;
                background: white;
                box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
            }
        </style>
        <?php
        if ($_POST['gerar'] != 'PDF') :
            ?>
            <link href="../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
            <?php
        endif;
        ?>
    </head>
    <body>

        <div align="center">
            CURVA ABC PRODUTOS
            <Br/> 
            PERÍODO: <?= $_POST['datai'] ?> À <?= $_POST['dataf'] ?>
        </div>

        <?php require_once './cabecalho.php'; ?>

        <?php

        function CalculaP($valor, $total) {
            $valor1 = $valor / $total;
            $porcentagem = $valor1 * 100;

//    return number_format($porcentagem, 2, ',', '');
            return $porcentagem;
        }

        function Classificao($porc, $a, $b) {
            if ($porc < $a) :
                return 'A';
            elseif ($porc < ($a + $b)) :
                return 'B';
            else :
                return 'C';
            endif;
        }

        function BuscaVariacaoDesccuva($prod, $variacao, $sigla, $nivel) {
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'estoqueprodutos');
            $sql = "SELECT produtos.variacao, produtos.codigo, 
                    variacao.variacaoid, variacao.var1, variacao.var2, 
                    variacao.var3 ,
                    itensvariacao.variacao, itensvariacao.sigla,
                    itensvariacao.descricao, itensvariacao.nivel
                    FROM produtos 
                    INNER JOIN variacao ON produtos.variacao = variacao.variacaoid 
                    INNER JOIN itensvariacao ON itensvariacao.variacao = variacao.variacaoid                   
                    WHERE codigo = '$prod' 
                    AND itensvariacao.nivel = '$nivel'
                    AND itensvariacao.sigla = '$sigla'";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

            return $dados->descricao;
        }

        $data_incio1 = mktime(0, 0, 0, date('m'), 1, date('Y'));
        $data_fim1 = mktime(23, 59, 59, date('m'), date("t"), date('Y'));
        $inicio1 = parseDate($_POST['datai'], "Y-m-d");
        $fim1 = parseDate($_POST['dataf'], "Y-m-d");

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'cliente');
        $data = date("d/m");
        $sql = 'select movimentacao.documento, movimentacao.data, movimentacao.finalizado, movimentacao.situacao,
    movimentacao.empresa, itmovimentacao.documento, itmovimentacao.preco, 
    sum(itmovimentacao.quantidade) as qtd, 
    sum(itmovimentacao.quantidade) * itmovimentacao.preco as total,
    itmovimentacao.produto, 
    estoqueprodutos.produto as prod, estoqueprodutos.codproduto, 
    estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
    produtos.codigo,  produtos.descricao from movimentacao 
    INNER JOIN itmovimentacao ON itmovimentacao.documento = movimentacao.documento 
    INNER JOIN estoqueprodutos ON estoqueprodutos.codproduto = itmovimentacao.produto 
    INNER JOIN produtos ON produtos.codigo = estoqueprodutos.produto 
    where str_to_date(data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '" 
        AND itmovimentacao.cancelado = "N"
        AND movimentacao.situacao <> "C"
    GROUP by itmovimentacao.produto 
    ORDER BY total DESC';
//echo $sql;
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

        $total = 0;
        foreach ($dados as $dadost) :
            $total = $total + $dadost->total;
        endforeach;
//print_r($dados);
        ?>

        <table class="table table-condensed text-center" style="font-size: 12px; width: 100%; text-align: left">
            <tr>
                <td><b>Produto</b></td>
                <?php
                if ($parametros->grade === 'S') :
                    ?>
                    <td><b>Var 1</b></td>
                    <td><b>Var 2</b></td>
                    <td><b>Var 3</b></td>
                    <?php
                endif;
                ?>
                <td><b>Qtd</b></td>
                <td><b>Preço</b></td>

                <td><b>Valor Total</b></td>
                <td><b>% Individual</b></td>
                <td><b>% Acumulada</b></td>
                <td><b>Classificação</b></td>
            </tr>
            <?php
            $panterior = 0;
            foreach ($dados as $dados) :
                $acumulada = CalculaP($dados->total, $total) + $panterior;
                $classificao = Classificao($acumulada, $_POST['curvaa'], $_POST['curvab']);
                ?>
                <tr>
                    <td><?= $dados->codproduto ?> - <?= $dados->descricao ?></td>
                    <?php
                    if ($parametros->grade === 'S') :
                        ?>
                        <td><?= $dados->var1 . ' - ' . BuscaVariacaoDesccuva($dados->prod, '1', $dados->var1, '1') ?></td>
                        <td><?= $dados->var2 . ' - ' . BuscaVariacaoDesccuva($dados->prod, '2', $dados->var2, '2') ?></td>
                        <td><?= $dados->var3 . ' - ' . BuscaVariacaoDesccuva($dados->prod, '3', $dados->var3, '3') ?></td>
                        <?php
                    endif;
                    ?>

                    <td><?php
                if (floor($dados->qtd) != $dados->qtd) :
                    echo $dados->qtd;
                else :
                    echo intval($dados->qtd);
                endif;
                    ?></td>
                    <td>R$ <?= number_format($dados->preco, 2, ',', '') ?></td>
                    <td>R$ <?= number_format($dados->total, 2, ',', '') ?></td>

                    <td><?= number_format(CalculaP($dados->total, $total), 2, ',', '') ?> %</td>
                    <td><?php
                    echo number_format($acumulada, 2, ',', '') . ' %';
                    ?></td>
                    <td><?= Classificao($acumulada, $_POST['curvaa'], $_POST['curvab']) ?></td>
                </tr>
                <?php
                $panterior = CalculaP($dados->total, $total) + $panterior;
            endforeach;
            ?>
        </table>

    </body>
</html>
<?php
if ($_POST['gerar'] == 'PDF') :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4-L'
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
endif;
?>