<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>
        <style>
            /*@import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";*/

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

        </style>

    </head>
    <?php
    $stylesheet = " 
             .table-bordered th,
    .table-bordered td {
        border: 1px solid #ddd !important; } 

    .full_table_list_titulo{border-collapse: collapse;}
    .full_table_list_titulo tr{border:1px black solid;}

    .full_table_list{border-collapse: collapse;}
    .full_table_list tr{border:1px black solid;}
    .full_table_list tr:nth-child(even) {background: #eee}
    .full_table_list tr:nth-child(odd) {background: #fff}  

    .tablecor {border:1px black solid; background: #eee}
    .titulotr {border:1px black solid; background: #F5F5F5}
            table {width: 100%; padding: 10px;}
            tr {border:1px black solid}
            .titulotr {border:1px black solid; background: #F5F5F5}";

    function Para($valor) {
        switch ($valor) :
            case 'C' :
                return 'Cliente';
                break;
            case 'F' :
                return 'Funcionário';
                break;
            case 'R' :
                return 'Representante';
        endswitch;
    }

    function BuscaPara($valor, $id) {

        if ($valor == 'R') :
            $sql = "SELECT * from representante where representanteid = '$id' ";
        elseif ($valor == 'F') :
            $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
        else :
            $sql = "SELECT * from cliente where clienteid = '$id' ";
        endif;

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabela');
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        return $dados;
    }

    function BuscaTabela($valor) {

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabelapreco');
        $sql = "Select * from tabelapreco where tabelaprecoid = '$valor'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        return $dados->descricao;
    }

    function BuscaNFe($valor) {

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabelapreco');
        $sql = "Select id, nNF from nfe where id = '$valor'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        return $dados->nNF;
    }

    function BuscaMeta($valor, $empresa) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT * from comissao";
        $sql .= " where valora <= '$valor' AND valorb >= '$valor' and empresa = '$empresa'";
        $arrayParam = '';
        $meta = $crud->getSQLGeneric($sql, $arrayParam, false);

        return $meta->comissao;
    }

    function BuscaProduto($codigo) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT produtos.codigo, produtos.descricao, produtos.comissao,
estoqueprodutos.produto, estoqueprodutos.codproduto
FROM produtos 
INNER JOIN estoqueprodutos ON estoqueprodutos.produto = produtos.codigo
WHERE estoqueprodutos.codproduto = '$codigo'
";
        $arrayParam = '';
        $dadosproduto = $crud->getSQLGeneric($sql, $arrayParam, false);

        return $dadosproduto;
    }

    function BuscaTabelaComissao($tabela, $vendedor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabelapreco');
        $sql = "SELECT * FROM comissaotbpreco where vendedor = '$vendedor' and tbpreco = '$tabela'";
        $arrayParam = '';
        $precoproduto = $crud->getSQLGeneric($sql, $arrayParam, false);
        if ($precoproduto->comissao > 0) :
            return $precoproduto->comissao;
        else :
            return '0.00';
        endif;
    }

    date_default_timezone_set("Brazil/East");
    require_once("../../../functions.php");
//
    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/parametros.php";

    $_POST['datai'] = parseDate($_POST['datai'], 'Y-m-d');
    $_POST['dataf'] = parseDate($_POST['dataf'], 'Y-m-d');

    $dataitime = strtotime($_POST['datai']);
    $dataftime = strtotime($_POST['dataf']);

    $dataconsulta = date("Y-m-d");
    $data1 = parseDate($dataconsulta, 'd/m/Y');

    function Situacao($valor) {
        switch ($valor) :
            case 'A' :
                return 'Aberta';
                break;
            case 'F' :
                return 'Fechada';
                break;
            case 'C' :
                return 'Cancelado';
                break;
        endswitch;
    }

    $titulo = 'GERAL';
    ?>
    <body>

        <div align="center">
            RELATÓRIO DE COMISSÕES
            <br/> <small> 
                <?php
                if ($_POST['tipocomissao'] == 'T') :
                    if ($_POST['tbpreco'] <> 'T') :
                        $titulo = 'TABELA DE PREÇO: ' . BuscaTabela($_POST['tbpreco']);
                    endif;
                endif;
                ?>
                <?= $titulo ?> <br/><?= parseDate($_POST['datai'], "d/m/Y"); ?> à <?= parseDate($_POST['dataf'], "d/m/Y"); ?></small>

        </div>


        <?php require_once './cabecalho.php'; ?> 
        <table class="table table-bordered" style="width: 100%; font-size: 12px;" >
            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'usuario');
            $sql = "SELECT * from vendedor";
            $sql .= ' WHERE vendedorid BETWEEN  "' . $_POST['vendedorini'] . '" AND "' . $_POST['vendedorfim'] . '" ';

            $arrayParam = '';
            $vendedor = $crud->getSQLGeneric($sql, $arrayParam, true);

            foreach ($vendedor as $vendedor) :
                ?>

                <tr style="background-color: #DCDCDC; padding: 5px;">
                    <th colspan="7"> <?= $vendedor->vendedorid ?> - <?= $vendedor->xNome ?> </th>

                    <?php
                    if ($_POST['tipocomissao'] == 'V') :
                        ?>
                        <th> Comissão</th>
                        <th> <?= number_format($vendedor->comissaoav, $parametros->casadecimal, ',', '.') ?> %</th>
                        <?php
                    elseif ($_POST['tipocomissao'] == 'I') :
                        ?>
                        <th> Comissão</th>
                        <th> <?= number_format($_POST['vcomissao'], $parametros->casadecimal, ',', '.') ?> %</th>
                        <?php
                    else :
                        ?>
                        <th colspan="2"> </th>

                    <?php
                    endif;
                    ?>

                </tr>
                <tr> 
                    <th style="width: 15%" class="text-left">Data | Data Pag.</th>
                    <th style="width: 8%" class="text-left">Doc</th>                    
                    <th style="width: 8%" class="text-left">Doc Fiscal</th>                    
                    <th style="width: 45%" class="text-left">Nome</th>
                    <th style="width: 15%" class="text-left">T. Preço</th>
                    <th style="width: 12%" class="text-left">Desc.</th>
                    <th style="width: 12%" class="text-left">Frete</th>
                    <th style="width: 12%" class="text-left">Vlr. Total</th>
                    <th style="width: 12%" class="text-left">Vlr. Liq</th>
                    <th style="width: 12%" class="text-left">Comissão</th>
                </tr>

                <?php
                $pdo = Conexao::getInstance();
                $crud = Crud::getInstance($pdo, 'usuario');
                $sql = 'Select * FROM movimentacao  where 
                    ((str_to_date(data, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '" ) 
                        OR                        
                       (str_to_date(datapagamento, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '") )';
                $sql .= ' AND empresa = "' . $_POST['empresa'] . '"';
                $sql .= ' AND situacao = "F"';
                $sql .= ' AND vendedor = "' . $vendedor->vendedorid . '"';

                if ($_POST['tipocomissao'] == 'T') :
                    if ($_POST['tbpreco'] <> 'T') :
                        $sql .= ' AND tbpreco = "' . $_POST['tbpreco'] . '"';
                    endif;
                endif;

                $sql .= '  ORDER BY  str_to_date(data, "%d/%m/%Y")';

//tbpreco
                $totalvenda = 0;
                $desciten = 0;
                $descdoc = 0;
                $totalbruto = 0;
                $totalliquido = 0;
                $totalprod = 0;
                $frete = 0;
                $comissaosoma = 0;

                $arrayParam = '';
                $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);
                if (count($movimentacao) > 0) :
                    ?>
                    <tr>
                        <th colspan="8"> Histórico de saídas</th>
                    </tr>
                    <?php
                endif;
                $roda = 'N';
                foreach ($movimentacao as $movimentacao) :

                    if ($movimentacao->tipo == 'C') :
                        if ($movimentacao->datapagamento != '') :
                            $datapag = parseDate($movimentacao->datapagamento, 'Y-m-d');
                            $datapag = strtotime($datapag);
                            if (($datapag >= $dataitime) && ($datapag <= $dataftime)) :
                                $roda = 'S';
                            else :
                                $roda = 'N';
                            endif;
                        endif;
                    else :
                        $roda = 'S';
                    endif;

                    if ($roda === 'S') :

                        if ($movimentacao->para == 'R') :
                            $id = $movimentacao->representante;
                            $dest = BuscaPara('R', $movimentacao->representante);
                        elseif ($movimentacao->para == 'F') :
                            $id = $movimentacao->funcionario;
                            $dest = BuscaPara('F', $movimentacao->funcionario);
                        else :
                            $id = $movimentacao->cliente;
                            $dest = BuscaPara('C', $movimentacao->cliente);
                        endif;

                        if ($_POST['tipocomissao'] == 'V') :
                            $valorcomissao = $vendedor->comissaoav;
                            $frete = $frete + $movimentacao->frete;
                            $totalbruto = $totalbruto + $movimentacao->valortotal + $movimentacao->desconto;
                            $totalliquido = $totalliquido + $movimentacao->valorpago - $movimentacao->troco;
                            $descdoc = $descdoc + $movimentacao->desconto;

                        elseif ($_POST['tipocomissao'] == 'I') :
                            $valorcomissao = $_POST['vcomissao'];
                            $frete = $frete + $movimentacao->frete;
                            $totalbruto = $totalbruto + $movimentacao->valortotal + $movimentacao->desconto;
                            $totalliquido = $totalliquido + $movimentacao->valorpago - $movimentacao->troco;
                            $descdoc = $descdoc + $movimentacao->desconto;
                        elseif ($_POST['tipocomissao'] == 'M') :
                            $valorcomissao = 0;
                            $frete = $frete + $movimentacao->frete;
                            $totalbruto = $totalbruto + $movimentacao->valortotal + $movimentacao->desconto;
                            $totalliquido = $totalliquido + $movimentacao->valorpago - $movimentacao->troco;
                            $descdoc = $descdoc + $movimentacao->desconto;
                        else :
                            $valorcomissao = BuscaTabelaComissao($movimentacao->tbpreco, $movimentacao->vendedor);
                            $frete = $frete + $movimentacao->frete;
                            $totalbruto = $totalbruto + $movimentacao->valortotal + $movimentacao->desconto;
                            $totalliquido = $totalliquido + $movimentacao->valorpago - $movimentacao->troco;
                            $descdoc = $descdoc + $movimentacao->desconto;
                        endif;
                        if ($_POST['tipocomissao'] !== 'P') :
                            $totalcomissao = (($movimentacao->valorpago - $movimentacao->troco) * $valorcomissao) / 100;
                            $comissaosoma = $comissaosoma + $totalcomissao;
                        else :
                            $totalcomissao = 0;
                        endif;
                        ?>

                        <tr> 
                            <td>
                                <?php
                                if ($movimentacao->data != $movimentacao->datapagamento) :
                                    echo $movimentacao->data;
                                    echo ' | ';
                                    echo $movimentacao->datapagamento;
                                else :
                                    echo $movimentacao->data;

                                endif;
                                ?> 
                            </td>
                            <td><?= $movimentacao->doc_empresa ?></td>
                            <td><?= BuscaNFe($movimentacao->DocFiscal) ?></td>

                            <td><?= $id ?> - <?= $dest->xNome ?></td>
                            <td><?= BuscaTabela($movimentacao->tbpreco) ?></td>
                            <td>R$ <?= number_format($movimentacao->desconto, $parametros->casadecimal, ',', '.') ?></td>
                            <td>R$ <?= number_format($movimentacao->frete, $parametros->casadecimal, ',', '.') ?></td>
                            <td>R$ <?= number_format($movimentacao->valortotal, $parametros->casadecimal, ',', '.') ?></td>
                            <td>R$ <?= number_format($movimentacao->valorpago - $movimentacao->troco, $parametros->casadecimal, ',', '.') ?></td>
                            <td>R$ <?= number_format($totalcomissao, $parametros->casadecimal, ',', '.') ?></td>
                        </tr>
                        <?php
                        if ($_POST['tipocomissao'] == 'P') :

                            $pdo = Conexao::getInstance();
                            $crud = Crud::getInstance($pdo, 'usuario');
                            $sql = "SELECT * from itmovimentacao where documento = '$movimentacao->documento' and cancelado = 'N'";
                            $arrayParam = '';
                            $dadosproduto = $crud->getSQLGeneric($sql, $arrayParam, true);
                            foreach ($dadosproduto as $dadosproduto) :
                                $prod = BuscaProduto($dadosproduto->produto);
                                $valorcomissao = $prod->comissao;

                                $totalcomissao = ($dadosproduto->valorliquido * $valorcomissao) / 100;
                                $comissaosoma = $comissaosoma + $totalcomissao;
                                ?>

                                <tr style="background-color: #ede9e9;"> 
                                    <td colspan="4">
                                        <?= $dadosproduto->produto ?> - 
                                        <?= $prod->descricao ?>
                                    </td>
                                    <td>R$ <?= number_format($dadosproduto->preco, $parametros->casadecimal, ',', '.') ?></td>
                                    <td>R$ <?= number_format($dadosproduto->desconto, $parametros->casadecimal, ',', '.') ?></td>
                                    <td>R$ <?= number_format($dadosproduto->acrescimo, $parametros->casadecimal, ',', '.') ?></td>
                                    <td>R$ <?= number_format($dadosproduto->quantidade, $parametros->casadecimal, ',', '.') ?></td>
                                    <td>R$ <?= number_format($dadosproduto->valorliquido, $parametros->casadecimal, ',', '.') ?></td>
                                    <td>R$ <?= number_format($totalcomissao, $parametros->casadecimal, ',', '.') ?></td>
                                </tr>


                                <?php
                            endforeach;
                        endif;

                    endif;
                endforeach;

                if (count($movimentacao) > 0) :

                    if ($_POST['tipocomissao'] == 'M') :
                        $valorcmeta = BuscaMeta($totalliquido, $_POST['empresa']);
                        $comissaosoma = $totalliquido * ($valorcmeta / 100);
                    endif;

//                    BuscaMeta($valor, $empresa)
                    ?>
                    <tr>
                        <th colspan="5">  <hr/> Sub-Total saídas</th>
                        <th><hr/>R$ <?= number_format($descdoc, 2, ',', '.') ?></th>
                        <th><hr/>R$ <?= number_format($frete, 2, ',', '.') ?></th>
                        <th><hr/>R$ <?= number_format($totalbruto, 2, ',', '.') ?></th>
                        <th><hr/>R$ <?= number_format($totalliquido, 2, ',', '.') ?></th>
                        <th><hr/>R$ <?= number_format($comissaosoma, 2, ',', '.') ?></th>

                    </tr>
                    <?php
                endif;
                ?>




                <?php
                $pdo = Conexao::getInstance();
                $crud = Crud::getInstance($pdo, 'usuario');
                $sql = 'Select * FROM movimentacao_troca where str_to_date(data, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '" ';
                $sql .= ' AND empresa = "' . $_POST['empresa'] . '"';
                $sql .= ' AND situacao = "F"';
                $sql .= ' AND vendedor = "' . $vendedor->vendedorid . '"';

                if ($_POST['tipocomissao'] == 'T') :
                    if ($_POST['tbpreco'] <> 'T') :
                        $sql .= ' AND tbpreco = "' . $_POST['tbpreco'] . '"';
                    endif;
                endif;

                $sql .= '  ORDER BY  str_to_date(data, "%d/%m/%Y")';

                $totalvendatroca = 0;
                $descitentroca = 0;
                $descdoctroca = 0;
                $totalbrutotroca = 0;
                $totalliquidotroca = 0;
                $totalprodtroca = 0;
                $fretetroca = 0;

                $arrayParam = '';
                $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);
                $comissaosomatroca = 0;

                if (count($movimentacao) > 0) :
                    ?>
                    <tr>
                        <th colspan="9"><hr/> Histórico de trocas</th>
                    </tr>
                    <?php
                endif;
                foreach ($movimentacao as $movimentacao) :

                    if ($movimentacao->para == 'R') :
                        $id = $movimentacao->representante;
                        $dest = BuscaPara('R', $movimentacao->representante);
                    elseif ($movimentacao->para == 'F') :
                        $id = $movimentacao->funcionario;
                        $dest = BuscaPara('F', $movimentacao->funcionario);
                    else :
                        $id = $movimentacao->cliente;
                        $dest = BuscaPara('C', $movimentacao->cliente);
                    endif;

                    if ($_POST['tipocomissao'] == 'V') :
                        $valorcomissao = $vendedor->comissaoav;
                        $fretetroca = $fretetroca + $movimentacao->frete;
                        $totalbrutotroca = $totalbrutotroca + $movimentacao->valortotal + $movimentacao->desconto;
                        $totalliquidotroca = $totalliquidotroca + $movimentacao->valorpago - $movimentacao->troco;
                        $descdoctroca = $descdoctroca + $movimentacao->desconto;
                    elseif ($_POST['tipocomissao'] == 'I') :
                        $valorcomissao = $_POST['vcomissao'];
                        $fretetroca = $fretetroca + $movimentacao->frete;
                        $totalbrutotroca = $totalbrutotroca + $movimentacao->valortotal + $movimentacao->desconto;
                        $totalliquidotroca = $totalliquidotroca + $movimentacao->valorpago - $movimentacao->troco;
                        $descdoctroca = $descdoctroca + $movimentacao->desconto;
                    else :
                        $valorcomissao = BuscaTabelaComissao($movimentacao->tbpreco, $movimentacao->vendedor);
                        $fretetroca = $fretetroca + $movimentacao->frete;
                        $totalbrutotroca = $totalbrutotroca + $movimentacao->valortotal + $movimentacao->desconto;
                        $totalliquidotroca = $totalliquidotroca + $movimentacao->valorpago - $movimentacao->troco;
                        $descdoctroca = $descdoctroca + $movimentacao->desconto;
                    endif;

                    if ($_POST['tipocomissao'] !== 'P') :
                        $totalcomissao = (($movimentacao->valorpago - $movimentacao->troco) * $valorcomissao) / 100;
                        $comissaosomatroca = $comissaosomatroca + $totalcomissao;
                    else :
                        $totalcomissao = 0;
                    endif;

//                    $totalcomissao = (($movimentacao->valorpago - $movimentacao->troco) * $valorcomissao) / 100;
//                    $comissaosomatroca = $comissaosomatroca + $totalcomissao;
                    ?>
                    <tr> 
                        <td><?= $movimentacao->data ?></td>
                        <td><?= $movimentacao->doc_empresa ?></td>
                        <td></td>
                        <td><?= $id ?> - <?= $dest->xNome ?></td>
                        <td><?= BuscaTabela($movimentacao->tbpreco) ?></td>
                        <td>R$ <?= number_format($movimentacao->desconto, $parametros->casadecimal, ',', '.') ?></td>
                        <td>R$ <?= number_format($movimentacao->frete, $parametros->casadecimal, ',', '.') ?></td>
                        <td>R$ <?= number_format($movimentacao->valortotal, $parametros->casadecimal, ',', '.') ?></td>
                        <td>R$ <?= number_format($movimentacao->valorpago - $movimentacao->troco, $parametros->casadecimal, ',', '.') ?></td>
                        <td>R$ <?= number_format($totalcomissao, $parametros->casadecimal, ',', '.') ?></td>

                    </tr>

                    <?php
                    if ($_POST['tipocomissao'] == 'P') :

                        $pdo = Conexao::getInstance();
                        $crud = Crud::getInstance($pdo, 'usuario');
                        $sql = "SELECT * from itmovimentacao_troca where documento = '$movimentacao->documento' and cancelado = 'N'";
                        $arrayParam = '';
                        $dadosproduto = $crud->getSQLGeneric($sql, $arrayParam, true);
                        foreach ($dadosproduto as $dadosproduto) :
                            $prod = BuscaProduto($dadosproduto->produto);
                            $valorcomissao = $prod->comissao;

                            if ($_POST['apura'] == 'S') :
                                if ($dadosproduto->operacao === 'E') :
                                    $totalcomissao = (($dadosproduto->valorliquido * $valorcomissao) / 100) * -1;
                                    $comissaosomatroca = $comissaosomatroca + $totalcomissao;
                                else :
                                    $totalcomissao = ($dadosproduto->valorliquido * $valorcomissao) / 100;
                                    $comissaosomatroca = $comissaosomatroca + $totalcomissao;
                                endif;

                            else :
                                if ($dadosproduto->operacao === 'E') :
                                    $totalcomissao = 0;
                                    $comissaosomatroca = $comissaosomatroca + $totalcomissao;
                                else :
                                    $totalcomissao = ($dadosproduto->valorliquido * $valorcomissao) / 100;
                                    $comissaosomatroca = $comissaosomatroca + $totalcomissao;
                                endif;

                            endif;
                            ?>

                            <tr style="background-color: #ede9e9;"> 
                                <td> <?= $dadosproduto->operacao ?> </td>
                                <td colspan="3">
                                    <?= $dadosproduto->produto ?> - 
                                    <?= $prod->descricao ?>
                                </td>
                                <td>R$ <?= number_format($dadosproduto->preco, $parametros->casadecimal, ',', '.') ?></td>
                                <td>R$ <?= number_format($dadosproduto->desconto, $parametros->casadecimal, ',', '.') ?></td>
                                <td>R$ <?= number_format($dadosproduto->acrescimo, $parametros->casadecimal, ',', '.') ?></td>
                                <td>R$ <?= number_format($dadosproduto->quantidade, $parametros->casadecimal, ',', '.') ?></td>
                                <td>R$ <?= number_format($dadosproduto->valorliquido, $parametros->casadecimal, ',', '.') ?></td>
                                <td>R$ <?= number_format($totalcomissao, $parametros->casadecimal, ',', '.') ?></td>
                            </tr>


                            <?php
                        endforeach;
                    endif;
                endforeach;

                if (count($movimentacao) > 0) :

                    if ($_POST['tipocomissao'] == 'M') :
                        $comissaosomatroca = $totalliquidotroca * ($valorcmeta / 100);
                    endif;
                    ?>

                    <tr>
                        <th colspan="5">  <hr/> Sub-Total troca</th>
                        <th><hr/>R$ <?= number_format($descdoctroca, 2, ',', '.') ?></th>
                        <th><hr/>R$ <?= number_format($fretetroca, 2, ',', '.') ?></th>
                        <th><hr/>R$ <?= number_format($totalbrutotroca, 2, ',', '.') ?></th>
                        <th><hr/>R$ <?= number_format($totalliquidotroca, 2, ',', '.') ?></th>
                        <th><hr/>R$ <?= number_format($comissaosomatroca, 2, ',', '.') ?></th>

                    </tr>

                    <?php
                endif;
                ?>

                <?php
                $pdo = Conexao::getInstance();
                $crud = Crud::getInstance($pdo, 'usuario');
                $sql = 'Select * FROM movimentacao_dev  where 
                    ((str_to_date(data, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '" ) 
                        OR                        
                       (str_to_date(datapagamento, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '") )';
                $sql .= ' AND empresa = "' . $_POST['empresa'] . '"';
                $sql .= ' AND situacao = "F"';
                $sql .= ' AND vendedor = "' . $vendedor->vendedorid . '"';
                $sql .= '  ORDER BY  str_to_date(data, "%d/%m/%Y")';

                $totalvendadevolucao = 0;
                $descitendevolucao = 0;
                $descdocdevolucao = 0;
                $totalbrutodevolucao = 0;
                $totalliquidodevolucao = 0;
                $totalproddevolucao = 0;
                $fretedevolucao = 0;
                $comissaosomadev = 0;

                $arrayParam = '';
                $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);
                if (count($movimentacao) > 0) :
                    ?>
                    <tr>
                        <th colspan="9"><hr/> Histórico de devoluções</th>
                    </tr>
                    <?php
                endif;

                $roda = 'N';
                foreach ($movimentacao as $movimentacao) :


                    if ($movimentacao->tipo == 'C') :
                        if ($movimentacao->datapagamento != '') :
                            $datapag = parseDate($movimentacao->datapagamento, 'Y-m-d');
                            $datapag = strtotime($datapag);
                            if (($datapag >= $dataitime) && ($datapag <= $dataftime)) :
                                $roda = 'S';
                            else :
                                $roda = 'N';
                            endif;
                        endif;
                    else :
                        $roda = 'S';
                    endif;

                    if ($roda === 'S') :

                        if ($movimentacao->para == 'R') :
                            $id = $movimentacao->representante;
                            $dest = BuscaPara('R', $movimentacao->representante);
                        elseif ($movimentacao->para == 'F') :
                            $id = $movimentacao->funcionario;
                            $dest = BuscaPara('F', $movimentacao->funcionario);
                        else :
                            $id = $movimentacao->cliente;
                            $dest = BuscaPara('C', $movimentacao->cliente);
                        endif;

                        if ($_POST['tipocomissao'] == 'V') :
                            $valorcomissao = $vendedor->comissaoav;
                            $totalbrutodevolucao = $totalbrutodevolucao + $movimentacao->valortotal + $movimentacao->desconto;
                            $totalliquidodevolucao = $totalliquidodevolucao + $movimentacao->valortotal - $movimentacao->troco;
                            $descdocdevolucao = $descdocdevolucao + $movimentacao->desconto;
                        elseif ($_POST['tipocomissao'] == 'I') :
                            $valorcomissao = $_POST['vcomissao'];
                            $totalbrutodevolucao = $totalbrutodevolucao + $movimentacao->valortotal + $movimentacao->desconto;
                            $totalliquidodevolucao = $totalliquidodevolucao + $movimentacao->valortotal - $movimentacao->troco;
                            $descdocdevolucao = $descdocdevolucao + $movimentacao->desconto;
                        else :
                            $valorcomissao = BuscaTabelaComissao($movimentacao->tbpreco, $movimentacao->vendedor);
                            $totalbrutodevolucao = $totalbrutodevolucao + $movimentacao->valortotal + $movimentacao->desconto;
                            $totalliquidodevolucao = $totalliquidodevolucao + $movimentacao->valortotal - $movimentacao->troco;
                            $descdocdevolucao = $descdocdevolucao + $movimentacao->desconto;
                        endif;

                        if ($_POST['tipocomissao'] !== 'P') :
                            $totalcomissao = (($movimentacao->valorpago - $movimentacao->troco) * $valorcomissao) / 100;
                            $comissaosomadev = $comissaosomatroca + $totalcomissao;
                        else :
                            $totalcomissao = 0;
                        endif;
//
//                    
//                        $totalcomissao = ($movimentacao->valortotal * $valorcomissao) / 100;
//                        $comissaosomadev = $comissaosomadev + $totalcomissao;
                        ?>
                        <tr> 
                            <td>
                                <?php
                                if ($movimentacao->data != $movimentacao->datapagamento) :
                                    echo $movimentacao->data;
                                    echo ' | ';
                                    echo $movimentacao->datapagamento;
                                else :
                                    echo $movimentacao->data;

                                endif;
                                ?> 
                            </td>

                            <td><?= $movimentacao->doc_empresa ?></td>
                            <td></td>
                            <td><?= $id ?> - <?= $dest->xNome ?></td>
                            <td><?= BuscaTabela($movimentacao->tbpreco) ?></td>
                            <td>R$ <?= number_format($movimentacao->desconto, $parametros->casadecimal, ',', '.') ?></td>
                            <td>R$ <?= number_format($frete, $parametros->casadecimal, ',', '.') ?></td>
                            <td>R$ <?= number_format($movimentacao->valortotal, $parametros->casadecimal, ',', '.') ?></td>
                            <td>R$ <?= number_format($movimentacao->valortotal, $parametros->casadecimal, ',', '.') ?></td>
                            <td>R$ -<?= number_format($totalcomissao, $parametros->casadecimal, ',', '.') ?></td>
                        </tr>

                        <?php
                        if ($_POST['tipocomissao'] == 'P') :

                            $pdo = Conexao::getInstance();
                            $crud = Crud::getInstance($pdo, 'usuario');
                            $sql = "SELECT * from itmovimentacao_dev where documento = '$movimentacao->documento' and cancelado = 'N'";
                            $arrayParam = '';
                            $dadosproduto = $crud->getSQLGeneric($sql, $arrayParam, true);
                            foreach ($dadosproduto as $dadosproduto) :
                                $prod = BuscaProduto($dadosproduto->produto);
                                $valorcomissao = $prod->comissao;

                                if ($_POST['apuradev'] == 'S') :
                                    $totalcomissao = ($dadosproduto->valorliquido * $valorcomissao) / 100;
                                    $comissaosomadev = $comissaosomadev + $totalcomissao;
                                else :
                                    $totalcomissao = 0;
                                    $comissaosomadev = $comissaosomadev + $totalcomissao;
                                endif;
                                ?>

                                <tr style="background-color: #ede9e9;"> 
                                    <td colspan="4">
                                        <?= $dadosproduto->produto ?> - 
                                        <?= $prod->descricao ?>
                                    </td>
                                    <td>R$ <?= number_format($dadosproduto->preco, $parametros->casadecimal, ',', '.') ?></td>
                                    <td>R$ <?= number_format($dadosproduto->desconto, $parametros->casadecimal, ',', '.') ?></td>
                                    <td>R$ <?= number_format($dadosproduto->acrescimo, $parametros->casadecimal, ',', '.') ?></td>
                                    <td>R$ <?= number_format($dadosproduto->quantidade, $parametros->casadecimal, ',', '.') ?></td>
                                    <td>R$ <?= number_format($dadosproduto->valorliquido, $parametros->casadecimal, ',', '.') ?></td>
                                    <td>R$ -<?= number_format($totalcomissao, $parametros->casadecimal, ',', '.') ?></td>
                                </tr>
                                <?php
                            endforeach;
                        endif;
                    endif;

                endforeach;
                if (count($movimentacao) > 0) :

                    if ($_POST['tipocomissao'] == 'M') :
                        $comissaosomadev = $totalbrutodevolucao * ($valorcmeta / 100);
                    endif;
                    ?>

                    <tr>
                        <th colspan="5">  <hr/> Sub-Total Devolução</th>
                        <th><hr/>R$ <?= number_format($descdocdevolucao, 2, ',', '.') ?></th>
                        <th><hr/>R$ <?= number_format($fretedevolucao, 2, ',', '.') ?></th>
                        <th><hr/>R$ <?= number_format($totalbrutodevolucao, 2, ',', '.') ?></th>
                        <th><hr/>R$ <?= number_format($totalliquidodevolucao, 2, ',', '.') ?></th>
                        <th><hr/>R$ <?= number_format($comissaosomadev, 2, ',', '.') ?></th>
                    </tr>
                    <?php
                endif;

                $totalsaidab = $totalsaidab + (($totalliquido + $totalliquidotroca) - $totalliquidodevolucao);
                ?>
                <tr>
                    <th colspan="7" align="right">  <hr/>Total base: </th>
                    <th><hr/>R$ <?= number_format(($totalliquido + $totalliquidotroca) - $totalliquidodevolucao, 2, ',', '.') ?></th>
                    <?php
                    if ($_POST['tipocomissao'] == 'M') :
                        ?>
                        <th colspan="2" align="right"><hr/> Comissão (<?= number_format($valorcmeta, 2, ',', '.') ?>)%: R$ <?= number_format($comissaosoma + $comissaosomatroca - $comissaosomadev, 2, ',', '.') ?></th>

                        <?php
                    else :
                        ?>
                        <th colspan="2" align="right"><hr/> Comissão: R$ <?= number_format($comissaosoma + $comissaosomatroca - $comissaosomadev, 2, ',', '.') ?></th>
                        s
                    <?php
                    endif;
                    ?>

                </tr>


                <tr>
                    <th colspan="9"><hr/><br/></th>
                </tr>
                <?php
            endforeach;
            ?>

            <tr>
                <td colspan="9">
                    <b>Total Geral</b>
                </td>
                <td>
                    R$ <?= number_format($totalsaidab, 2, ',', '.') ?>
                </td>
            </tr>
        </table>

    </body>
</html>
<?php
require_once("../../_inc/mpdf/vendor/autoload.php");
ini_set("pcre.backtrack_limit", "500000000000000");

$mpdf = new \Mpdf\Mpdf([
    'margin_top' => 5,
    'margin_left' => 5,
    'margin_right' => 5,
    'mirrorMargins' => true,
    'default_font_size' => 12,
    'default_font' => 'sans-serif',
    'format' => 'A4-L'
        ]);
//$mpdf->SetWatermarkText('DRAFT');
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->SetTitle('Movimentações');
$mpdf->WriteHTML($stylesheet, 1);
$mpdf->WriteHTML($html);
$mpdf->Output();
// imprime

exit();
?>