<?php
ob_start();

date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";
require_once "../../../_backend/_class/Emitente_class.php";
require_once "../../../_backend/_class/extenso_class.php";

//error_reporting(E_ALL);
//ini_set('display_errors', 'On');

$meses = array("JANEIRO", "FEVEREIRO", "MARÇO", "ABRIL", "MAIO", "JUNHO", "JULHO", "AGOSTO", "SETEMBRO", "OUTUBRO", "NOVEMBRO", "DEZEMBRO");

function BuscaPara($valor, $id) {

    if ($valor == 'R') :
        $sql = "SELECT * from representante where representanteid = '$id' ";
    elseif ($valor == 'F') :
        $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
    else :
        $sql = "SELECT * from cliente where clienteid = '$id' ";
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

function formatCnpjCpf($value) {
    $CPF_LENGTH = 11;
    $cnpj_cpf = preg_replace("/\D/", '', $value);

    if (strlen($cnpj_cpf) === $CPF_LENGTH) {
        return preg_replace("/(\d{3})(\d{3})(\d{3})(\d{2})/", "\$1.\$2.\$3-\$4", $cnpj_cpf);
    }

    return preg_replace("/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/", "\$1.\$2.\$3/\$4-\$5", $cnpj_cpf);
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'lancamento');
$sql = "SELECT * from lancamento WHERE lancamentoid IN(" . $_GET['lancamento'] . ")";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$totall = count($dados);
?>
<html>
    <head>
        <title> Relatório </title>
        <style>
            .carne1 {
                position: fixed;
                left: 1px;
                top: 0px;
                width: 270px;
                /*height: 3508px;*/
            }
            .carne2 {
                position: fixed;
                left: 277px;
                top: 0px;
                width: 270px;
                /*height: 300px;*/
            }
            .carne3 {
                position: fixed;
                left: 554px;
                top: 0px;
                width: 270px;
                /*height: 300px;*/
            }
            .carne4 {
                position: fixed;
                left: 832px;
                top: 0px;
                width: 270px;
                /*height: 300px;*/
            }


        </style>
<?php
if ($_POST['gerar'] != 'PDF') :
    ?>
            <link href="../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
            <?php
        endif;
        ?>
    </head>
    <body >

<?php
$logo = '' . FRONTEND . '/img/logomarca/' . $emitente->CNPJ . '/' . $emitente->logo . '';

$totalcarne = '1';
foreach ($dados as $dados) :
    if ($dados->para == 'R') :
        $dest = BuscaPara('R', $dados->representante);
    elseif ($dados->para == 'F') :
        $dest = BuscaPara('F', $dados->funcionario);
    else :
        $dest = BuscaPara('C', $dados->cliente);
    endif;

    if ($totalcarne == '5') :
        $totalcarne = 1;
        ?>
            <pagebreak />

        <?php
    endif;
    ?>



        <div class="carne<?= $totalcarne ?>">
            <table cellpadding="8" class="table table-striped table-condensed full_table_list"
                   style="font-size: 12px; padding: 10px; width: 100%;">
                <tr>
                    <td style="border: 1px solid #000; border-right: none; padding: 10px;"> 
                        <img src="<?= $logo ?>" width="60px" alt=""/>
                    </td>
                    <td style="border: 1px solid #000;  border-left: none; font-size: 10px; padding: 5px;"> 
    <?= $emitente->xNome ?> <br/>
                        <?= $emitente->xLgr ?>, <?= $emitente->nro ?> <?= $emitente->xBairro ?>  <br/>
                        CEP: <?= $emitente->CEP ?> <?= $emitente->xMun ?>-<?= $emitente->UF ?>  <br/>
                        CNPJ: <?= formatCnpjCpf($emitente->CNPJ) ?> <br/>
                        INSC. EST: <?= $emitente->IE ?> <br/>


                    </td>


                </tr>

                <tr>
                    <td style="border: 1px solid #000; width: 35%; font-size: 10px; padding: 5px;"> 
                        Data de Emissão<br/>
                        <p style="text-align: center; font-size: 12px;"><?= $dados->dataemissao ?></p>

                    </td>
                    <td style="border: 1px solid #000; width: 65%; font-size: 10px; padding: 5px;"> 
                        Nome<br/>
                        <p style="text-align: center; font-size: 8px;"><?= $dest->xNome ?></p>
                    </td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; width: 35%; font-size: 10px; padding: 5px;"> 
                        Número<br/>
                        <p style="text-align: center; font-size: 12px;"><?= $dados->titulo ?>/<?= $dados->parcela ?></p>

                    </td>
                    <td style="border: 1px solid #000; width: 65%; font-size: 10px; padding: 5px;"> 
                        Vencimento<br/>
                        <p style="text-align: center; font-size: 12px;"><?= $dados->datavencimento ?></p>
                    </td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; width: 35%; font-size: 10px; padding: 5px;"> 
                        Valor<br/>
                        <p style="text-align: center; font-size: 12px;">R$ <?= number_format($dados->valor, 2, ',', '') ?></p>

                    </td>
                    <td style="border: 1px solid #000; width: 65%; font-size: 10px; padding: 5px;"> 
                        Valor total pago<br/>
                        <p style="text-align: center; font-size: 12px;">R$ </p>
                    </td>
                </tr>
                <tr>
                    <td colspan="2" style="border: 1px solid #000; padding: 5px;"> 
                        <p style="font-size: 8px;">
                            RECONHEÇO A EXATIDÃO DESTA FATURA DE VENDA MERCANTIL COM PAGAMENTO PARCELADO NA 
                            IMPORTÂNCIA ACIMA QUE PAGAREI À <?= $emitente->xNome ?>, OU A SUA ORDEM NA PRAÇA E VENCIMENTOS
                            ACIMA INDICADOS.
                        </p>
                        <br/>
                    </td>
                </tr>
                <tr>
                    <td colspan="2" style="border: 1px solid #000;  border-left: none; border-right: none; border-bottom: none; width: 65%; font-size: 10px; padding: 5px;"> 
                <center><br/>____________________________________________________ <br/>
    <?= $dest->xNome ?>
                </center>
                </td>
                </tr>
                <tr>
                    <td colspan="2" style="border: 1px solid #000;  border-left: none; border-right: none; border-top: none; width: 65%; font-size: 10px; padding: 5px;"> 
                        <p>- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - </p>
                        <br/>
                    </td>
                </tr>

                <tr>
                    <td style="border: 1px solid #000; width: 35%; font-size: 10px; padding: 5px;"> 
                        Data de Emissão<br/>
                        <p style="text-align: center; font-size: 12px;"><?= $dados->dataemissao ?></p>

                    </td>
                    <td style="border: 1px solid #000; width: 65%; font-size: 10px; padding: 5px;"> 
                        Nome<br/>
                        <p style="text-align: center; font-size: 8px;"><?= $dest->xNome ?></p>
                    </td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; width: 35%; font-size: 10px; padding: 5px;"> 
                        Número<br/>
                        <p style="text-align: center; font-size: 12px;"><?= $dados->titulo ?>/<?= $dados->parcela ?></p>

                    </td>
                    <td style="border: 1px solid #000; width: 65%; font-size: 10px; padding: 5px;"> 
                        Vencimento<br/>
                        <p style="text-align: center; font-size: 12px;"><?= $dados->datavencimento ?></p>
                    </td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; width: 35%; font-size: 10px; padding: 5px;"> 
                        Valor<br/>
                        <p style="text-align: center; font-size: 12px;">R$ <?= number_format($dados->valor, 2, ',', '') ?></p>

                    </td>
                    <td style="border: 1px solid #000; width: 65%; font-size: 10px; padding: 5px;"> 
                        Valor total pago<br/>
                        <p style="text-align: center; font-size: 12px;">R$ </p>
                    </td>
                </tr>



                <!--VIA CLIENTE-->
                <tr>
                    <td colspan="2" style="border: 1px solid #000;  border-left: none; border-right: none; border-top: none; width: 65%; font-size: 10px; padding: 5px;"> 
                        <p>- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - </p>
                        <br/>
                    </td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; border-right: none; padding: 10px;"> 
                        <img src="<?= $logo ?>" width="60px" alt=""/>
                    </td>
                    <td style="border: 1px solid #000;  border-left: none; font-size: 10px; padding: 5px;"> 
    <?= $emitente->xNome ?> <br/>
                        <?= $emitente->xLgr ?>, <?= $emitente->nro ?> <?= $emitente->xBairro ?>  <br/>
                        CEP: <?= $emitente->CEP ?> <?= $emitente->xMun ?>-<?= $emitente->UF ?>  <br/>
                        CNPJ: <?= formatCnpjCpf($emitente->CNPJ) ?> <br/>
                        INSC. EST: <?= $emitente->IE ?> <br/>


                    </td>


                </tr>

                <tr>
                    <td style="border: 1px solid #000; width: 35%; font-size: 10px; padding: 5px;"> 
                        Data de Emissão<br/>
                        <p style="text-align: center; font-size: 12px;"><?= $dados->dataemissao ?></p>

                    </td>
                    <td style="border: 1px solid #000; width: 65%; font-size: 10px; padding: 5px;"> 
                        Nome<br/>
                        <p style="text-align: center; font-size: 8px;"><?= $dest->xNome ?></p>
                    </td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; width: 35%; font-size: 10px; padding: 5px;"> 
                        Número<br/>
                        <p style="text-align: center; font-size: 12px;"><?= $dados->titulo ?>/<?= $dados->parcela ?></p>

                    </td>
                    <td style="border: 1px solid #000; width: 65%; font-size: 10px; padding: 5px;"> 
                        Vencimento<br/>
                        <p style="text-align: center; font-size: 12px;"><?= $dados->datavencimento ?></p>
                    </td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; width: 35%; font-size: 10px; padding: 5px;"> 
                        Valor<br/>
                        <p style="text-align: center; font-size: 12px;">R$ <?= number_format($dados->valor, 2, ',', '') ?></p>

                    </td>
                    <td style="border: 1px solid #000; width: 65%; font-size: 10px; padding: 5px;"> 
                        Valor total pago<br/>
                        <p style="text-align: center; font-size: 12px;">R$ </p>
                    </td>
                </tr>
                <tr>
                    <td colspan="2" style="border: 1px solid #000; padding: 5px;"> 
                        <p style="font-size: 8px;">
                            RECONHEÇO A EXATIDÃO DESTA FATURA DE VENDA MERCANTIL COM PAGAMENTO PARCELADO NA 
                            IMPORTÂNCIA ACIMA QUE PAGAREI À <?= $emitente->xNome ?>, OU A SUA ORDEM NA PRAÇA E VENCIMENTOS
                            ACIMA INDICADOS.
                        </p>
                        <br/>
                    </td>
                </tr>
            </table>

        </div>

    <?php
    $totalcarne++;
endforeach;
?>
</body>
</html>

<?php
ini_set("pcre.backtrack_limit", "500000000000000");
require_once("../../_inc/mpdf/vendor/autoload.php");
$mpdf = new \Mpdf\Mpdf([
    'margin_top' => 5,
    'margin_left' => 3,
    'margin_right' => 1,
//    'mirrorMargins' => true,
    'default_font_size' => 12,
    'format' => 'A4-L'
        ]);
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->SetTitle('Estoque');
$mpdf->WriteHTML($html);
$mpdf->Output();
// imprime

exit();
?>