<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>

        <style>
            body {
                font-size: 12px;

            }


            h1, h2, h3, h4, h5, h6,
            .h1, .h2, .h3, .h4, .h5, .h6 {
                font-family: inherit;
                font-weight: 500;
                line-height: 1.1;
                color: inherit;
            }
            h1 small,
            h1 .small, h2 small,
            h2 .small, h3 small,
            h3 .small, h4 small,
            h4 .small, h5 small,
            h5 .small, h6 small,
            h6 .small,
            .h1 small,
            .h1 .small, .h2 small,
            .h2 .small, .h3 small,
            .h3 .small, .h4 small,
            .h4 .small, .h5 small,
            .h5 .small, .h6 small,
            .h6 .small {
                font-weight: normal;
                line-height: 1;
                color: #777777;
            }

            h1, .h1,
            h2, .h2,
            h3, .h3 {
                margin-top: 20px;
                margin-bottom: 10px;
            }
            h1 small,
            h1 .small, .h1 small,
            .h1 .small,
            h2 small,
            h2 .small, .h2 small,
            .h2 .small,
            h3 small,
            h3 .small, .h3 small,
            .h3 .small {
                font-size: 65%;
            }

            h4, .h4,
            h5, .h5,
            h6, .h6 {
                margin-top: 10px;
                margin-bottom: 10px;
            }
            h4 small,
            h4 .small, .h4 small,
            .h4 .small,
            h5 small,
            h5 .small, .h5 small,
            .h5 .small,
            h6 small,
            h6 .small, .h6 small,
            .h6 .small {
                font-size: 75%;
            }

            h1, .h1 {
                font-size: 36px;
            }

            h2, .h2 {
                font-size: 30px;
            }

            h3, .h3 {
                font-size: 24px;
            }

            h4, .h4 {
                font-size: 18px;
            }

            h5, .h5 {
                font-size: 14px;
            }

            h6, .h6 {
                font-size: 12px;
            }
            .text-center {
                text-align: center;
            }

            table {
                width: 100%;
                padding: 10px;
            }

            td {
                padding: 3px;
            }
            th {
                text-align: left;
            }
            /*.titulotr { border:  none};*/
            /*.titulotr { background: #000; border:1px black solid;};*/
            .table-bordered th,
            .table-bordered td {
                border: 1px solid #ddd !important;
            }

            .full_table_list_titulo{
                border-collapse: collapse;
            }
            .full_table_list_titulo tr{
                border:1px black solid;
            }

            .full_table_list{
                border-collapse: collapse;
            }
            .full_table_list tr{
                border:1px black solid;
            }
            .full_table_list tr:nth-child(even) {
                background: #fff
            }
            .full_table_list tr:nth-child(odd) {
                background: #fff
            }

            .tablecor {
                border:1px black solid;
                background: #eee
            }
            .titulotr {
                border:1px black solid;
                background: #F5F5F5
            }
        </style>
    </head>

    <?php
    date_default_timezone_set("Brazil/East");
    require_once("../../../functions.php");
//
    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/parametros.php";
    require_once "../../../_backend/_class/Emitente_class.php";
    require_once "../../../_backend/_class/extenso_class.php";
    require_once "../../../_backend/_class/cobranca_class.php";

//error_reporting(E_ALL);
//ini_set('display_errors', 'On');

    $meses = array("JANEIRO", "FEVEREIRO", "MARÇO", "ABRIL", "MAIO", "JUNHO", "JULHO", "AGOSTO", "SETEMBRO", "OUTUBRO", "NOVEMBRO", "DEZEMBRO");

    function Usuario($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT * from usuario where usuarioid = '" . $valor . "' ";
        $arrayParam = '';
        $vendedor = $crud->getSQLGeneric($sql, $arrayParam, false);
        return $vendedor->usuarionome;
    }

    function BuscaPlanoContas($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'lancamento');
        $sql = "SELECT * from planodecontas where planodecontassequencia = '$valor'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        if (empty($dados->planodecontasdescricao)) :
            return '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
        else :
            return $dados->planodecontasdescricao;

        endif;
    }

    function BuscaCentrodecusto($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'lancamento');
        $sql = "SELECT * from centrodecusto where id = '$valor'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        if (empty($dados->descricao)) :
            return '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
        else :
            return $dados->descricao;

        endif;
    }

    function BuscaPara($valor, $id) {

        if ($valor == 'R') :
            $sql = "SELECT * from representante where representanteid = '$id' ";
        elseif ($valor == 'F') :
            $sql = "SELECT * from fornecedor where fornecedorid = '$id' ";
        else :
            $sql = "SELECT * from cliente where clienteid = '$id' ";
        endif;

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabela');
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        return $dados;
    }

    function Situacao($valor) {
        switch ($valor) :
            case 'A' :
                return 'Aberta';
                break;
            case 'BP' :
                return 'Parcial';
                break;
            case 'BC' :
                return 'Baixada';
                break;
        endswitch;
    }

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'lancamento');
    $sql = "SELECT * from lancamento WHERE lancamentoid IN(" . $_GET['lancamento'] . ")";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
    ?>


    <?php
    foreach ($dados as $dados) :
        if ($dados->para == 'R') :
            $dest = BuscaPara('R', $dados->representante);
        elseif ($dados->para == 'F') :
            $dest = BuscaPara('F', $dados->fornecedor);
        else :
            $dest = BuscaPara('C', $dados->cliente);
        endif;
        ?>
        <body>

            <table cellpadding="8" class="table table-striped table-bordered table-condensed full_table_list"
                   style="font-size: 12px; padding: 10px; width: 100%">
                <tr> 
                    <td colspan="4" align="center"><b>AUTORIZAÇÃO DE PAGAMENTO</b> </td>

                </tr>

                <tr>
                    <td colspan="4">
                        <b>Credor: </b> <?= $dest->xNome ?> 
                    </td>
                </tr>
                <tr>
                    <td colspan="4">
                        <b>CPF/CNPJ: </b> <?= $dest->CNPJ ?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <b>IE: </b> <?= $dest->IE ?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <b>CHAVE PIX: </b> <?= $dest->chavepix ?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    </td>
                </tr>

                <tr>
                    <td colspan="4">
                        <b>Endereço: </b> <?= $dest->xLgr . ', nro ' . $dest->nro ?>&nbsp;&nbsp;&nbsp;
                        <b>Bairro: </b> <?= $dest->xBairro ?>&nbsp;&nbsp;&nbsp;
                        <b>Cidade: </b> <?= $dest->xMun . '/ ' . $dest->UF ?>&nbsp;&nbsp;&nbsp;
                        <b>CEP: </b> <?= $dest->CEP ?>&nbsp;&nbsp;&nbsp;
                    </td>
                </tr>
                <tr>
                    <td colspan="4">
                        <b>Título: </b> <?= $dados->titulo ?>/<?= $dados->parcela ?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <b>Plano de contas: </b> <?= BuscaPlanoContas($dados->planodecontas) ?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <b>Centro de custo: </b> <?= BuscaCentrodecusto($dados->centrodecusto) ?>&nbsp;&nbsp;&nbsp;

                    </td>
                </tr>

                <tr>

                    <td colspan="4">
                        <b>Tipo: </b> <?= $cobranca[$dados->tipocobranca] ?> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <b>Situação: </b> <?= Situacao($dados->situacao) ?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <b>Usuario: </b> <?= Usuario($dados->usuario) ?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <b>Emissão: </b> <?= $dados->dataemissao ?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <b>Vencimento: </b> <?= $dados->datavencimento ?>

                    </td>

                </tr>
                <tr>

                    <td colspan="4">
                        <b>Histórico: </b> <?= $dados->historico ?>                 
                    </td>

                </tr>


                <tr style="border: 1px solid #ddd;"> 
                    <td colspan="2">
                        <b>Valor: </b> R$ <?= number_format($dados->valor, '2', ',', '.') ?><br/>
                        <b>Valor Original: </b> R$ <?= number_format($dados->valorlancamento, '2', ',', '.') ?><br/>
                        <b>Juros: </b> R$ 0,00<br/>

                    </td>
                    <td colspan="2" style="border: 1px solid #ddd;">
                        <b>Autorizado:</b>
                        <?php
                        if($dados->aprovadopag == 'N') :
                            ?>
                         <br/>
                        <b style="color: red;">REJEITADO</b> <br/>
                        <?php
                        elseif($dados->aprovadopag == 'S') :
                            ?><br/>
                         <b style="color: green;">APROVADO</b> <br/>
                       <?php 
                        endif;
                        if (!empty($dados->usuarioaprova)) :
                            ?>
                        
                            <?= Usuario($dados->usuarioaprova) ?>  
                            &nbsp;&nbsp;&nbsp;&nbsp;
                            <?= $dados->dataaprova ?>
                            <?php
                        endif;
                        ?>
                    </td>

                </tr>
                <tr style="border: 1px solid #ddd;"> 
                    <td colspan="2"  style="border: none">
                        <b>Desconto: </b> R$ 0,00<br/>
                        <b>Valor Total: </b> R$ <?= number_format($dados->valor, '2', ',', '.') ?><br/>
                        <b>Valor Pago: </b> R$ <?= number_format($dados->valorpago, '2', ',', '.') ?><br/>

                    </td>
                    <td colspan="2" style="border: 1px solid #ddd;">
                        <b>Obs: </b>
                        <?= nl2br($dados->obs) ?>
                    </td>

                </tr>



                <tr> 
                    <td colspan="4"> <hr/> </td>
                </tr>

            </table>
            <?php
        endforeach;
        ?>
    </body>
</html>

<?php
require_once("../../_inc/mpdf/vendor/autoload.php");
ini_set("pcre.backtrack_limit", "500000000000000");

$mpdf = new \Mpdf\Mpdf([
    'margin_top' => 5,
    'margin_left' => 5,
    'margin_right' => 5,
    'mirrorMargins' => true,
    'default_font_size' => 12,
    'default_font' => 'sans-serif',
        ]);
//$mpdf->SetWatermarkText('DRAFT');
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->SetTitle('Movimentações');
$mpdf->WriteHTML($html);
$mpdf->Output();
// imprime

exit();
?>