<?php
ob_start();
date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";

//$tabela = $parametros->tbpadrao;

function Preco2($produto, $tabela) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'categorias');
    $sql = "SELECT * from precoprodutos where tabela = '$tabela' and produto = '$produto'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

//    echo $sql;
    return $dados->valor;
}

//$tabela = $parametros->tbpadrao;

function TabelaPreco($tabela) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'categorias');
    $sql = "SELECT * from tabelapreco where tabelaprecoid = '$tabela'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

//    echo $sql;
    return $dados->descricao;
}
?>

<html>
    <head>
        <title> Relatório </title>
        <style>
            body {
                font-size: 12px;
            }

            h1, h2, h3, h4, h5, h6,
            .h1, .h2, .h3, .h4, .h5, .h6 {
                font-family: inherit;
                font-weight: 500;
                line-height: 1.1;
                color: inherit;
            }
            h1 small,
            h1 .small, h2 small,
            h2 .small, h3 small,
            h3 .small, h4 small,
            h4 .small, h5 small,
            h5 .small, h6 small,
            h6 .small,
            .h1 small,
            .h1 .small, .h2 small,
            .h2 .small, .h3 small,
            .h3 .small, .h4 small,
            .h4 .small, .h5 small,
            .h5 .small, .h6 small,
            .h6 .small {
                font-weight: normal;
                line-height: 1;
                color: #777777;
            }

            h1, .h1,
            h2, .h2,
            h3, .h3 {
                margin-top: 20px;
                margin-bottom: 10px;
            }
            h1 small,
            h1 .small, .h1 small,
            .h1 .small,
            h2 small,
            h2 .small, .h2 small,
            .h2 .small,
            h3 small,
            h3 .small, .h3 small,
            .h3 .small {
                font-size: 65%;
            }

            h4, .h4,
            h5, .h5,
            h6, .h6 {
                margin-top: 10px;
                margin-bottom: 10px;
            }
            h4 small,
            h4 .small, .h4 small,
            .h4 .small,
            h5 small,
            h5 .small, .h5 small,
            .h5 .small,
            h6 small,
            h6 .small, .h6 small,
            .h6 .small {
                font-size: 75%;
            }

            h1, .h1 {
                font-size: 36px;
            }

            h2, .h2 {
                font-size: 30px;
            }

            h3, .h3 {
                font-size: 24px;
            }

            h4, .h4 {
                font-size: 18px;
            }

            h5, .h5 {
                font-size: 14px;
            }

            h6, .h6 {
                font-size: 12px;
            }
            .text-center {
                text-align: center;
            }

            table {
                width: 100%;
                padding: 10px;
            }

            td {
                padding: 3px;
            }
            th {
                text-align: left;
            }
            /*.titulotr { border:  none};*/
            /*.titulotr { background: #000; border:1px black solid;};*/
            .table-bordered th,
            .table-bordered td {
                border: 1px solid #ddd !important;
            }

            .full_table_list_titulo{
                border-collapse: collapse;
            }
            .full_table_list_titulo tr{
                border:1px black solid;
            }

            .full_table_list{
                border-collapse: collapse;
            }
            .full_table_list tr{
                border:1px black solid;
            }
            .full_table_list tr:nth-child(even) {
                background: #fff
            }
            .full_table_list tr:nth-child(odd) {
                background: #fff
            }

            .tablecor {
                border:1px black solid;
                background: #eee
            }
            .titulotr {
                border:1px black solid;
                background: #F5F5F5
            }
        </style>
    </head>

    <body>
        <div align="center">
            AUDITORIA DE ESTOQUE

        </div>
        <?php require_once './cabecalho.php'; ?>


        <table class="table full_table_list_titulo" style="font-size: 11px;">
            <thead>
                <tr>
                    <th width="15%">Código</th>
                    <th width="10%">Ref:</th>
                    <th width="35%">Descrição</th>   
                    <th width="10%">Auditado</th>   
                    <th width="10%"><?= TabelaPreco($tabela) ?></th>   
                    <th width="10%">Estoque</th>   
                    <th width="10%">Diferença</th>   
                </tr>
            </thead>

            <?php
            $totalauditado = 0;
            $valorauditad = 0;
            $diferenca = 0;
            $estoque = 0;
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'auditoria_new');

//             $sql = "SELECT sum(auditoria_new.qtd) as qtd, auditoria_new.id, auditoria_new.status, auditoria_new.produto, estoqueprodutos.produto as prodestq, estoqueprodutos.codproduto, 
// estoqueprodutos." . $_SESSION['Estoque'] . " as estoque, produtos.codigo, produtos.descricao, produtos.ref, produtos.custo, auditoria_new.empresa from auditoria_new
// LEFT JOIN estoqueprodutos on auditoria_new.produto = estoqueprodutos.codproduto
// LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
// ";

            $sql = "
            SELECT 
                SUM(an.qtd) AS qtd, 
                an.id, 
                an.status, 
                an.produto, 
                ep.produto AS prodestq, 
                ep.codproduto,
                ep." . $_SESSION['Estoque'] . " AS estoque, 
                p.codigo, 
                p.descricao, 
                p.ref, 
                p.custo, 
                an.empresa,
                COALESCE(pp.valor, 0.00) AS preco
            FROM auditoria_new an
            LEFT JOIN estoqueprodutos ep ON an.produto = ep.codproduto
            LEFT JOIN produtos p ON p.codigo = ep.produto
            LEFT JOIN precoprodutos pp ON pp.produto = ep.codproduto AND pp.tabela = '$tabela'
            WHERE an.status = 'A' AND an.empresa = '" . $_SESSION['Empresa'] . "'
            GROUP BY ep.codproduto, p.codigo, p.descricao, p.ref, p.custo, ep." . $_SESSION['Estoque'] . ", an.empresa, pp.valor
            ORDER BY ep.codproduto
            ";

            $arrayParam = '';
            // $sql .= " WHERE status = 'A' and auditoria_new.empresa = '" . $_SESSION['Empresa'] . "'";
            // $sql .= " GROUP BY estoqueprodutos.codproduto";
            // $sql .= " ORDER BY estoqueprodutos.codproduto";
            $dados = $crud->getSQLGeneric($sql, $arrayParam, true);

        //    echo $sql;
            foreach ($dados as $auditoria_new) :
                $valor = $auditoria_new->preco;
                $totalauditado = $totalauditado + $auditoria_new->qtd;
                if ($auditoria_new->qtd > 0) :
                    $valorauditad = $valorauditad + ($auditoria_new->qtd * $valor);
                endif;
                $estoque = $estoque + $auditoria_new->estoque;
        //    echo $valor;
                ?>

                <tr>
                    <td><?= $auditoria_new->codproduto ?></td>
                    <td><?= $auditoria_new->ref ?></td>
                    <td><?= $auditoria_new->descricao ?></td>
                    <td><?= number_format($auditoria_new->qtd, 2, ',', '') ?></td>
                    <td><?= number_format($auditoria_new->qtd * $valor, 2, ',', '') ?></td>
                    <td><?= number_format($auditoria_new->estoque, 2, ',', '') ?></td>
                    <td><?= number_format($auditoria_new->qtd - abs($auditoria_new->estoque), 2, ',', '') ?></td>
                </tr>

                <?php
            endforeach;
            ?>
            <tfoot>
                <tr>
                    <td colspan="7"><hr/></td>
                </tr>
                <tr>
                    <td colspan="3">TOTAIS</td>
                    <td><?= number_format($totalauditado, 2, ',', '') ?></td>
                    <td><?= number_format($valorauditad, 2, ',', '') ?></td>
                    <td><?= number_format($estoque, 2, ',', '') ?></td>
                    <td><?= number_format($totalauditado - $estoque, 2, ',', '') ?></td>
                </tr>
            <tfoot>

        </table>
    </body>

</html>

<?php
ini_set("pcre.backtrack_limit", "500000000000000");
require_once("../../_inc/mpdf/vendor/autoload.php");
$mpdf = new \Mpdf\Mpdf([
    'margin_top' => 5,
    'margin_left' => 5,
    'margin_right' => 5,
    'mirrorMargins' => true,
    'default_font_size' => 10,
    'format' => 'A4'
        ]);
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->SetTitle('Estoque');
$mpdf->WriteHTML($html);
$mpdf->Output();
// imprime

exit;
?>