<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>
        <style>
            @import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";

            table {
                /*border-collapse: collapse;*/
                border : 1px solid #000;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.50em;
                padding-right: 0.50em;
                padding-top: 0.50em;
                padding-bottom: 0.50em;
                line-height: 1.50em;
                vertical-align: top;
            }

        </style>
    </head>
    <body>
        <?php
        date_default_timezone_set("Brazil/East");
        require_once("../../../functions.php");
        require_once "../../../_backend/_class/Conexao_class.php";
        require_once "../../../_backend/_class/Crud_class.php";
        require_once "../../../_backend/_class/parametros.php";
        require_once "../../../_backend/_class/Emitente_class.php";

        function Especie($valor) {
            switch ($valor) :
                case '55' :
                    return 'NFe';
                    break;
                case '65' :
                    return 'NFCe';
                    break;
                case '57' :
                    return 'CTe';
                    break;
                case '06' :
                    return 'NF/CEE';
                    break;
                case '22' :
                    return 'NFST';
                    break;
                case '51' :
                    return 'NFS';
                    break;
                default :
                    return $valor;
                    break;
            endswitch;
        }

        function Aliq($icms, $total) {
            $aliq = ($icms * 100) / $total;
            if ($aliq > 0) :
                $aliq = intval($aliq);
            else :
                $aliq = 0;
            endif;
            return number_format($aliq, 2, ',', '.');
        }

        $datai = $_POST['datai'];
        $dataf = $_POST['dataf'];
        $_POST['datai'] = parseDate($_POST['datai'], 'Y-m-d');
        $_POST['dataf'] = parseDate($_POST['dataf'], 'Y-m-d');
        ?>

        <table class="table table-bordered" style="font-size: 10px; padding: 10px">
            <tr> 
                <th colspan="8">APURAÇÃO ICMS POR CFOP </th>
            </tr>
            <tr> 
                <td colspan="8">
                    FIRMA:  &nbsp;&nbsp;<?= $emitente->xNome ?>
                    <Br/>
                    INSC. EST.:  &nbsp;&nbsp;<?= $emitente->IE ?> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  
                    CNPJ (MF):  &nbsp;&nbsp;<?= $emitente->CNPJ ?><br/>
                    LIVRO:  &nbsp;&nbsp; <?= $_POST['livro'] ?> 
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
                    FOLHA:  &nbsp;&nbsp; <?= $_POST['folha'] ?>
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
                    MÊS OU PERÍODO/ANO: &nbsp;&nbsp;
                    <?= $datai ?>&nbsp;&nbsp; à &nbsp;&nbsp; <?= $dataf ?>
                </td>

            </tr>
            <tr>               
                <th colspan="2" class="text-center">CODIFICAÇÃO</th>
                <th></th>
                <th colspan="5" class="text-center">VALORES FISCAIS </th>
            </tr>
            <tr>
                <th colspan="2"></th>
                <th colspan="2"></th>
                <th colspan="2">OPERAÇÕES COM DÉBITO DO IMPOSTO</th>
                <th colspan="2">OPERAÇÕES S/DÉBITO DO IMPOSTO</th>
            </tr>

            <tr>  
                <th>CONTÁBIL</th>
                <th>FISCAL</th>
                <th>VALOR CONTÁBIL</th>
                <th>BASE DE CÁLCULO</th>
                <th>IMPOSTO DEBITADO</th>
                <th>ISENTAS OU NÃO TRIBUTADAS</th>
                <th>OUTRAS</th>
                <th>OBSERVAÇÕES</th>                
            </tr>
            <tr>
                <th colspan="8" class="text-center"> SAÍDAS </th>
            </tr>

            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'nfe');
            $sql = "SELECT nfe.id, nfe.dhEmi, nfe.tipo, nfe.tpNF, nfe.empresa, nfe.status, nfe.vDescnf as vDescnf, nfe.modelo, 
                produtonfe.CFOP, produtonfe.pICMS, produtonfe.pIPI, sum(produtonfe.valortotal) as valortotal,
                sum(produtonfe.vDesc) as vDesc, sum(produtonfe.vBC) as vBC, sum(produtonfe.vBCIPI) as vBCIPI,
                sum(produtonfe.vICMS) as vICMS, sum(produtonfe.vIPI) as vIPI 
                from nfe
                INNER JOIN produtonfe ON produtonfe.NFe = nfe.id
                ";
            $sql .= ' WHERE str_to_date(dhEmi, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '"  ';
            $sql .= " AND tipo = 'saida' AND tpNF  = '1'";
            $sql .= " AND empresa = '" . $_SESSION['Empresa'] . "'";
            $sql .= " AND ((status = '100') or (status = '999'))";
            $sql .= " AND produtonfe.CFOP < '5999'";
            if ($_POST['modelo'] != 'T') :
                $sql .= ' AND modelo = "' . $_POST['modelo'] . '" ';
            endif;
            $sql .= " GROUP BY CFOP";
//            $sql .= " order by STR_TO_DATE(dhEmi, '%d/%m/%Y'), nNF";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
            $total = 0;
            $totalBc = 0;
            $totalIcms = 0;
            $totalisentas = 0;
          

//                    echo $sql;
            foreach ($dados as $dados) :
               $total = $total + $dados->valortotal;
                $totalBc = $totalBc + $dados->vBC;
                $totalIcms = $totalIcms + $dados->vICMS;
                $totalisentas = $totalisentas + ($dados->valortotal - $dados->vDesc - $dados->vBC);
                ?>
                <tr>
                    <td></td>
                    <td> <?= $dados->CFOP ?></td>          
                    <td><?= number_format($dados->valortotal - $dados->vDesc, 2, ',', '.') ?></td>
                    <td><?= number_format($dados->vBC, 2, ',', '.') ?></td>
                    <td><?= number_format($dados->vICMS, 2, ',', '.') ?></td>
                    <td><?= number_format($dados->valortotal - $dados->vDesc - $dados->vBC, 2, ',', '.') ?></td>
                    <td>0,00</td>
                    <td>   
                        <?php
                        if ($prodnfe1->vIPI > 0) :
                            echo 'IPI :' . number_format($dados->vIPI, 2, ',', '.');
                            echo '<br/>';
                        else :
                            echo '<br/>';
                        endif;
                        ?>
                    </td>
                </tr>

                <?php
            endforeach;
            ?>

            <tr>
                <th colspan="2"></th>
                <th><?= number_format($total, 2, ',', '.') ?></th>
                <th><?= number_format($totalBc, 2, ',', '.') ?></th>
                <th><?= number_format($totalIcms, 2, ',', '.') ?></th>
                <th><?= number_format($totalisentas, 2, ',', '.') ?></th>                
                <th></th>     
                <th></th>
            </tr>


            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'nfe');
            $sql = "SELECT nfe.id, nfe.dhEmi, nfe.tipo, nfe.tpNF, nfe.empresa, nfe.status, nfe.modelo, 
                produtonfe.CFOP, produtonfe.pICMS, produtonfe.pIPI, sum(produtonfe.valortotal) as valortotal,
                sum(produtonfe.vDesc) as vDesc, sum(produtonfe.vBC) as vBC, sum(produtonfe.vBCIPI) as vBCIPI,
                sum(produtonfe.vICMS) as vICMS, sum(produtonfe.vIPI) as vIPI 
                from nfe
                INNER JOIN produtonfe ON produtonfe.NFe = nfe.id
                ";
            $sql .= ' WHERE str_to_date(dhEmi, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '"  ';
            $sql .= " AND tipo = 'saida' AND tpNF  = '1'";
            $sql .= " AND empresa = '" . $_SESSION['Empresa'] . "'";
            $sql .= " AND ((status = '100') or (status = '999'))";
            $sql .= " AND produtonfe.CFOP > '5999'";
            if ($_POST['modelo'] != 'T') :
                $sql .= ' AND modelo = "' . $_POST['modelo'] . '" ';
            endif;
            $sql .= " GROUP BY CFOP";
//            $sql .= " order by STR_TO_DATE(dhEmi, '%d/%m/%Y'), nNF";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
            $totala = 0;
            $totalBca = 0;
            $totalIcmsa = 0;
            $totalisentasa = 0;

//                    echo $sql;
            foreach ($dados as $dados) :
                $totala = $totala + $dados->valortotal - $dados->vDesc;
                $totalBca = $totalBca + $dados->vBC;
                $totalIcmsa = $totalIcmsa + $dados->vICMS;
                $totalisentasa = $totalisentasa + ($dados->valortotal - $dados->vDesc - $dados->vBC);
                ?>
                <tr>
                    <td></td>
                    <td> <?= $dados->CFOP ?></td>          
                    <td><?= number_format($dados->valortotal - $dados->vDesc, 2, ',', '.') ?></td>
                    <td><?= number_format($dados->vBC, 2, ',', '.') ?></td>
                    <td><?= number_format($dados->vICMS, 2, ',', '.') ?></td>
                    <td><?= number_format($dados->valortotal - $dados->vDesc - $dados->vBC, 2, ',', '.') ?></td>
                    <td>0,00</td>
                    <td>   
                        <?php
                        if ($prodnfe1->vIPI > 0) :
                            echo 'IPI :' . number_format($dados->vIPI, 2, ',', '.');
                            echo '<br/>';
                        else :
                            echo '<br/>';
                        endif;
                        ?>
                    </td>
                </tr>

                <?php
            endforeach;
            ?>

            <tr>
                <th colspan="2"></th>
                <th><?= number_format($totala, 2, ',', '.') ?></th>
                <th><?= number_format($totalBca, 2, ',', '.') ?></th>
                <th><?= number_format($totalIcmsa, 2, ',', '.') ?></th>
                <th><?= number_format($totalisentasa, 2, ',', '.') ?></th>                
                <th></th>     
                <th></th>
            </tr>
            <tr>
                <th colspan="2">TOTAIS</th>
                <th><?= number_format($total + $totala, 2, ',', '.') ?></th>
                <th><?= number_format($totalBc + $totalBca, 2, ',', '.') ?></th>
                <th><?= number_format($totalIcms + $totalIcmsa, 2, ',', '.') ?></th>
                <th><?= number_format($totalisentas + $totalisentasa, 2, ',', '.') ?></th>                
                <th></th>     
                <th></th>
            </tr>

            <tr>
                <td colspan="8"><br/></td>
            </tr>
             <tr>               
                <th colspan="2" class="text-center">CODIFICAÇÃO</th>
                <th></th>
                <th colspan="5" class="text-center">VALORES FISCAIS </th>
            </tr>
            <tr>
                <th colspan="2"></th>
                <th colspan="2"></th>
                <th colspan="2">OPERAÇÕES COM CRÉDITO DO IMPOSTO</th>
                <th colspan="2">OPERAÇÕES S/CRÉDITO DO IMPOSTO</th>
            </tr>

            <tr>  
                <th>CONTÁBIL</th>
                <th>FISCAL</th>
                <th>VALOR CONTÁBIL</th>
                <th>BASE DE CÁLCULO</th>
                <th>IMPOSTO CREDITADO</th>
                <th>ISENTAS OU NÃO TRIBUTADAS</th>
                <th>OUTRAS</th>
                <th>OBSERVAÇÕES</th>                
            </tr>
            <tr>
                <th colspan="8" class="text-center"> ENTRADAS </th>
            </tr>
            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'nfe');
            $sql = "SELECT nfe.id, nfe.dhEmi, nfe.tipo, nfe.tpNF, nfe.empresa, nfe.status, nfe.modelo, 
                produtonfe.CFOP, produtonfe.pICMS, produtonfe.pIPI, sum(produtonfe.valortotal) as valortotal,
                sum(produtonfe.vDesc) as vDesc, sum(produtonfe.vBC) as vBC, sum(produtonfe.vBCIPI) as vBCIPI,
                sum(produtonfe.vICMS) as vICMS, sum(produtonfe.vIPI) as vIPI 
                from nfe
                INNER JOIN produtonfe ON produtonfe.NFe = nfe.id
                ";
            $sql .= ' WHERE str_to_date(dhEmi, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '"  ';
            $sql .= "AND ((tipo = 'Entrada') or (tpNF = '0'))";
            $sql .= " AND empresa = '" . $_SESSION['Empresa'] . "'";
            $sql .= " AND ((status = '100') or (status = '999'))";
            $sql .= " AND produtonfe.CFOP < '1999'";
            if ($_POST['modelo'] != 'T') :
                $sql .= ' AND modelo = "' . $_POST['modelo'] . '" ';
            endif;
            $sql .= " GROUP BY CFOP";
//            $sql .= " order by STR_TO_DATE(dhEmi, '%d/%m/%Y'), nNF";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
            $total = 0;
            $totalBc = 0;
            $totalIcms = 0;
            $totalisentas = 0;

//                    echo $sql;
            foreach ($dados as $dados) :
                $total = $total + $dados->valortotal - $dados->vDesc;
                $totalBc = $totalBc + $dados->vBC;
                $totalIcms = $totalIcms + $dados->vICMS;
                $totalisentas = $totalisentas + ($dados->valortotal - $dados->vDesc - $dados->vBC);
                ?>
                <tr>
                    <td></td>
                    <td> <?= $dados->CFOP ?></td>          
                    <td><?= number_format($dados->valortotal - $dados->vDesc, 2, ',', '.') ?></td>
                    <td><?= number_format($dados->vBC, 2, ',', '.') ?></td>
                    <td><?= number_format($dados->vICMS, 2, ',', '.') ?></td>
                    <td><?= number_format($dados->valortotal - $dados->vDesc - $dados->vBC, 2, ',', '.') ?></td>
                    <td>0,00</td>
                    <td>   
                        <?php
                        if ($prodnfe1->vIPI > 0) :
                            echo 'IPI :' . number_format($dados->vIPI, 2, ',', '.');
                            echo '<br/>';
                        else :
                            echo '<br/>';
                        endif;
                        ?>
                    </td>
                </tr>

                <?php
            endforeach;
            ?>

            <tr>
                <th colspan="2"></th>
                <th><?= number_format($total, 2, ',', '.') ?></th>
                <th><?= number_format($totalBc, 2, ',', '.') ?></th>
                <th><?= number_format($totalIcms, 2, ',', '.') ?></th>
                <th><?= number_format($totalisentas, 2, ',', '.') ?></th>                
                <th></th>     
                <th></th>
            </tr>


            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'nfe');
            $sql = "SELECT nfe.id, nfe.dhEmi, nfe.tipo, nfe.tpNF, nfe.empresa, nfe.status, nfe.modelo, 
                produtonfe.CFOP, produtonfe.pICMS, produtonfe.pIPI, sum(produtonfe.valortotal) as valortotal,
                sum(produtonfe.vDesc) as vDesc, sum(produtonfe.vBC) as vBC, sum(produtonfe.vBCIPI) as vBCIPI,
                sum(produtonfe.vICMS) as vICMS, sum(produtonfe.vIPI) as vIPI 
                from nfe
                INNER JOIN produtonfe ON produtonfe.NFe = nfe.id
                ";
            $sql .= ' WHERE str_to_date(dhEmi, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '"  ';
            $sql .= "AND ((tipo = 'Entrada') or (tpNF = '0'))";
            $sql .= " AND empresa = '" . $_SESSION['Empresa'] . "'";
            $sql .= " AND ((status = '100') or (status = '999'))";
            $sql .= " AND produtonfe.CFOP > '1999'";
            if ($_POST['modelo'] != 'T') :
                $sql .= ' AND modelo = "' . $_POST['modelo'] . '" ';
            endif;
            $sql .= " GROUP BY CFOP";
//            $sql .= " order by STR_TO_DATE(dhEmi, '%d/%m/%Y'), nNF";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
            $totala = 0;
            $totalBca = 0;
            $totalIcmsa = 0;
            $totalisentasa = 0;

//                    echo $sql;
            foreach ($dados as $dados) :
                $totala = $totala + $dados->valortotal - $dados->vDesc;
                $totalBca = $totalBca + $dados->vBC;
                $totalIcmsa = $totalIcmsa + $dados->vICMS;
                $totalisentasa = $totalisentasa + ($dados->valortotal - $dados->vDesc - $dados->vBC);
                ?>
                <tr>
                    <td></td>
                    <td> <?= $dados->CFOP ?></td>          
                    <td><?= number_format($dados->valortotal - $dados->vDesc, 2, ',', '.') ?></td>
                    <td><?= number_format($dados->vBC, 2, ',', '.') ?></td>
                    <td><?= number_format($dados->vICMS, 2, ',', '.') ?></td>
                    <td><?= number_format($dados->valortotal - $dados->vDesc - $dados->vBC, 2, ',', '.') ?></td>
                    <td>0,00</td>
                    <td>   
                        <?php
                        if ($prodnfe1->vIPI > 0) :
                            echo 'IPI :' . number_format($dados->vIPI, 2, ',', '.');
                            echo '<br/>';
                        else :
                            echo '<br/>';
                        endif;
                        ?>
                    </td>
                </tr>

                <?php
            endforeach;
            ?>

            <tr>
                <th colspan="2"></th>
                <th><?= number_format($totala, 2, ',', '.') ?></th>
                <th><?= number_format($totalBca, 2, ',', '.') ?></th>
                <th><?= number_format($totalIcmsa, 2, ',', '.') ?></th>
                <th><?= number_format($totalisentasa, 2, ',', '.') ?></th>                
                <th></th>     
                <th></th>
            </tr>
            <tr>
                <th colspan="2">TOTAIS</th>
                <th><?= number_format($total + $totala, 2, ',', '.') ?></th>
                <th><?= number_format($totalBc + $totalBca, 2, ',', '.') ?></th>
                <th><?= number_format($totalIcms + $totalIcmsa, 2, ',', '.') ?></th>
                <th><?= number_format($totalisentas + $totalisentasa, 2, ',', '.') ?></th>                
                <th></th>     
                <th></th>
            </tr>
        </table>
    </body>
</html>



<?php
if ($_POST['arq'] == 'PDF') :
    require_once("../../_inc/mpdf/vendor/autoload.php");
    ini_set("pcre.backtrack_limit", "500000000000000");

    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 10,
        'format' => 'A4-L',
        'default_font' => 'sans-serif',
    ]);
//$mpdf->SetWatermarkText('DRAFT');
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} | <strong> Impresso: " . date('d/m/Y H:i') . " </strong></td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Movimentações');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime
    exit();

elseif ($_POST['arq'] == 'EXCEL') :
    $file = 'registro-p1a.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
endif;
?>
