<?php
require_once("../../_modal/_modal.php");
date_default_timezone_set("Brazil/East");
require_once "../../../../functions.php";
require_once "../../../_class/Conexao_class.php";
require_once "../../../_class/Crud_class.php";
?>

<script>

    function SomaCusto() {
        var totalmp = parseFloat($("#totalmp").val());
        var totalprocesso = parseFloat($("#totalprocesso").val());
        var totalvar = parseFloat($("#totalvar").val());
        var total = totalmp + totalprocesso + totalvar;
        $("#custoproduto").val(total.toFixed(2));
    }

    function DeletaVariavel(val) {
        bootbox.confirm({
            message: "Deseja Realmente Excluir?",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    $.ajax({
                        type: "GET",
                        url: "<?= BACKEND ?>/_view/_pcp/_controller/_delete/variaveis_fichatecninca_delete.php",
                        data: {
                            id: val
                        },
                        dataType: "json",
// função para de sucesso
                        success: function (data) {
//  alert();
//alert(data);
                            if (data.retorno == true) {
                                toastr.success('Composição excluída!');
                                CarregaVariavel();
                            } else {
                                toastr.warning('Tente novamente!');
                            }
                        }
                    }); //termina o jquery
                }
            }
        });

    }

    function DelImgPCP(valor) {
        bootbox.confirm({
            message: "Deseja Realmente Excluir?",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    $.ajax({
                        type: "GET",
                        url: "<?= BACKEND ?>/_view/_pcp/_controller/_delete/img_fichatecninca_delete.php",
                        data: {
                            id: valor
                        },
                        dataType: "json",
// função para de sucesso
                        success: function (data) {
//  alert();
//alert(data);
                            if (data.retorno == true) {
                                toastr.success('Imagem excluída!');
                                CarregaImg();
                            } else {
                                toastr.warning('Tente novamente!');
                            }
                        }
                    }); //termina o jquery
                }
            }
        });

    }


    function DeletaProcesso(val) {
        bootbox.confirm({
            message: "Deseja Realmente Excluir?",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    $.ajax({
                        type: "GET",
                        url: "<?= BACKEND ?>/_view/_pcp/_controller/_delete/processo_fichatecninca_delete.php",
                        data: {
                            id: val
                        },
                        dataType: "json",
// função para de sucesso
                        success: function (data) {
//  alert();
//alert(data);
                            if (data.retorno == true) {
                                toastr.success('Composição excluída!');
                                CarregaProcesso();
                            } else {
                                toastr.warning('Tente novamente!');
                            }
                        }
                    }); //termina o jquery
                }
            }
        });

    }

    function Fechar() {
        bootbox.confirm({
            message: "Deseja Atualizar o preço de custo do produto?",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    AtualizaCusto();
                } else {
                    Carrega('_pcp/_grid', 'processo_grid.php', 'Processo / Fases de produção');
                }
            }
        });
    }

    function DeletaComposicao(val) {
        bootbox.confirm({
            message: "Deseja Realmente Excluir?",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    $.ajax({
                        type: "GET",
                        url: "<?= BACKEND ?>/_view/_pcp/_controller/_delete/materiaprima_fichatecninca_delete.php",
                        data: {
                            id: val
                        },
                        dataType: "json",
// função para de sucesso
                        success: function (data) {
//  alert();
//alert(data);
                            if (data.retorno == true) {
                                toastr.success('Composição excluída!');
                                CarregaMP();
                            } else {
                                toastr.warning('Tente novamente!');
                            }
                        }
                    }); //termina o jquery
                }
            }
        });

    }

    function VerificaFichaTecnica() {
        var produto = $("#produtos").val();
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_view/_pcp/_controller/_select/_ajax/fichatecnica_select_ajax.php",
            data: {
                produto: produto
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
//alert(data);
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#idfichatecnica").val(data[0].id);
                    $("#fichatecnicaimg").val(data[0].id);
                    $("#fichatecnicaid").html(data[0].id);
                    $("#linhafichatecnica").css("display", "block");
                    CarregaMP();
                    CarregaProcesso();
                    CarregaVariavel();
                    CarregaImg();
                } else {
                    CriaFichaTecnica();
                }
            }
        }); //termina o jquery
    }

    function CriaFichaTecnica() {
        var produto = $("#produtos").val();
        $.ajax({
            type: "POST",
            url: "<?= BACKEND ?>/_view/_pcp/_controller/_insert/fichatecnica_insert.php",
            data: {
                produto: produto
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
//alert(data);
                if (data.retorno) {
//                    alert(data[0].xNome);
                    $("#idfichatecnica").val(data.id);
                    $("#fichatecnicaid").html(data.id);
                    $("#fichatecnicaimg").val(data[0].id);
                    $("#linhafichatecnica").css("display", "block");
                    CarregaMP();
                    CarregaProcesso();
                    CarregaVariavel();
                    CarregaImg();
                } else {
                    toastr.warning('Erro ao criar ficha tecnica!');
                }
            }
        }); //termina o jquery
    }

    function AtualizaCusto() {
        $.ajax({
            type: "POST",
            url: "<?= BACKEND ?>/_view/_pcp/_controller/_update/produto_custo_update.php",
            data: {
                produto: $("#produtos").val(),
                custo: $("#custoproduto").val()
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
//alert(data);
                if (data.retorno) {
//                    alert(data[0].xNome);
                    Carrega('_pcp/_grid', 'processo_grid.php', 'Processo / Fases de produção')
                } else {
                    toastr.warning('Tente Novamente');

                }
            }
        }); //termina o jquery

    }

    function AdicionaVariavel() {
        if ($("#idfichatecnica").val() === '') {
            toastr.warning('Sem ficha técnica escolhida!');
            return false;
        }
        if ($("#variavel").val() === '') {
            toastr.warning('Variável não selecionada!');
            return false;
        }

        $.ajax({
            type: "POST",
            url: "<?= BACKEND ?>/_view/_pcp/_controller/_insert/variaveis_fichatecnica_insert.php",
            data: {
                produtos: $("#produtos").val(),
                variavel: $("#variavel").val(),
                valor: $("#variavelvalor").val(),
                total: $("#variaveltotal").val(),
                tipo: $("#variaveltipo").val(),
                fichatecnica: $("#idfichatecnica").val()
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
//alert(data);
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#variavel").val('');
                    $("#variavelvalor").val('');
                    $("#variaveltotal").val('');
                    $("#variaveltipo").val('');
                    $("#variaveldescricao").val('');
                    CarregaVariavel();
                } else {
                    toastr.warning('Tente Novamente');

                }
            }
        }); //termina o jquery

    }

    function AdicionaComposicao() {
        if ($("#idfichatecnica").val() === '') {
            toastr.warning('Sem ficha técnica escolhida!');
            return false;
        }
        if ($("#materiaprima").val() === '') {
            toastr.warning('Matéria Prima não selecionada!');
            return false;
        }
        if ($("#processo").val() === '') {
            toastr.warning('Processo não selecionado!');
            return false;
        }
        $.ajax({
            type: "POST",
            url: "<?= BACKEND ?>/_view/_pcp/_controller/_insert/composicao_fichatecnica_insert.php",
            data: {
                produtos: $("#produtos").val(),
                insumo: $("#materiaprima").val(),
                custo: $("#customateriaprima").val(),
                quantidade: $("#qtdmateriaprima").val(),
                total: $("#totalmateriaprima").val(),
                processo: $("#processo").val(),
                fichatecnica: $("#idfichatecnica").val()
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
//alert(data);
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#materiaprima").val('');
                    $("#customateriaprima").val('');
                    $("#qtdmateriaprima").val('');
                    $("#totalmateriaprima").val('');
                    $("#processo").val('');
                    $("#materiaprimadescricao").val('');
                    $("#unmateriaprima").val('');
                    $("#processodescricao").val('');
                    CarregaMP();
                } else {
                    toastr.warning('Tente Novamente');

                }
            }
        }); //termina o jquery

    }

    function AdicionaProcesso() {
        if ($("#idfichatecnica").val() === '') {
            toastr.warning('Sem ficha técnica escolhida!');
            return false;
        }
        if ($("#fase").val() === '') {
            toastr.warning('Matéria Prima não selecionada!');
            return false;
        }
        $.ajax({
            type: "POST",
            url: "<?= BACKEND ?>/_view/_pcp/_controller/_insert/processo_fichatecnica_insert.php",
            data: {
                produtos: $("#produtos").val(),
                tempo: $("#fasetempo").val(),
                valor: $("#fasetotal").val(),
                situacao: $("#situacao").val(),
                processo: $("#fase").val(),
                fichatecnica: $("#idfichatecnica").val()
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
//alert(data);
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#fasetempo").val('');
                    $("#fasetotal").val('');
                    $("#situacao").val('');
                    $("#fase").val('');
                    $("#fasedescricao").val('');
                    CarregaProcesso();
                } else {
                    toastr.warning('Tente Novamente');

                }
            }
        }); //termina o jquery

    }

    function numeroParaMoeda(valor)
    {
        return isNaN(valor) == false ? parseFloat(valor) : parseFloat(valor.replace(".", ",").toFixed(2));

    }

    function moedaParaNumero(valor)
    {
        return isNaN(valor) == false ? parseFloat(valor) : parseFloat(valor.replace(".", "").replace(",", "."));
    }

    function SomaMP() {
        var qtd1 = $("#qtdmateriaprima").val();
        var custo2 = $("#customateriaprima").val();

        var qtd = qtd1.replace(",", ".");
        var custo = custo2.replace(",", ".");

        var total = Number(qtd) * Number(custo);
//        alert(total);
        $("#totalmateriaprima").val(total.toFixed(2));
    }

    function SomaVar() {
        if ($("#variaveltipo").val() === 'P') {
            SomaVariavelPorc();
        } else {
            SomaVariavel();
        }
    }

    function TotalVar() {
        var custototal = $("#custototal").val();
        var totalp = $("#variaveltotal").val();
        var totalv = parseFloat(custototal) + parseFloat(totalp);
        $("#custototal").val(totalv.toFixed(2));
    }

    function SomaVariavelPorc() {
        var custo = $("#custoproduto").val();
        var porc = $("#variavelvalor").val();
        var totalp = parseFloat(custo) * (parseFloat(porc) / 100);
        $("#variaveltotal").val(totalp.toFixed(2));

    }

    function SomaVariavel() {
        var valor = $("#variavelvalor").val();
        $("#variaveltotal").val(valor);

    }

    function SomaTempo() {
        if ($("#fasetipo").val() === 'U') {
            $("#fasetotal").val($("#fasevalor").val());
        } else {
            var tempo = $("#fasetempo").val();
            var tempoa = tempo.split(':');
            var hora = tempoa[0];
            var min = tempoa[1];
            var seg = tempoa[2];

            var vrhora = parseFloat($("#fasevalor").val());
            var vrmin = vrhora / 60;
            var vrseg = vrmin / 60;

            var totalHora = Number(hora) * vrhora;
            var totalMim = Number(min) * vrmin;
            var totalSeg = Number(seg) * vrseg;
//        var cmin = Number(chora) * 60 + Number(seg);

//        var vrmin = parseFloat($("#fasevalor").val()) / 60;
            var VrTotal = totalHora + totalMim + totalSeg;
            if (isNaN(VrTotal)) {
                $("#fasetotal").val('0.00');
            } else {
                $("#fasetotal").val(VrTotal.toFixed(2));
            }
//        alert(VrTotal);
//        alert(min);
//        alert(seg);
        }
    }

    $(document).ready(function () {
        $('.js-example-basic-single').select2({
            placeholder: 'Selecione o Plano de Conta',
            width: '100%'
        });
    });

    $(document).ready(function () {
        $('.time').mask('00:00:00');
    });


    function CarregaMP() {
//        alert(valor);
        var fichatecnica = $("#idfichatecnica").val();
        $("#recebemp").load('_backend/_view/_pcp/_grid/materiaprima_fichatecnica_grid.php?fichatecnica=' + fichatecnica, function () {
            $("#carregandobusca").css("display", "none");
            SomaCusto();
        });
        $("#carregandobusca").css("display", "none");
    }

    function CarregaProcesso() {
//        alert(valor);
        var fichatecnica = $("#idfichatecnica").val();
        $("#recebeprocesso").load('_backend/_view/_pcp/_grid/processo_fichatecnica_grid.php?fichatecnica=' + fichatecnica, function () {
            $("#carregandobusca").css("display", "none");
            SomaCusto();
        });
        $("#carregandobusca").css("display", "none");
    }

    function CarregaVariavel() {
//        alert(valor);
        var fichatecnica = $("#idfichatecnica").val();
        $("#recebevariavel").load('_backend/_view/_pcp/_grid/variaveis_fichatecnica_grid.php?fichatecnica=' + fichatecnica, function () {
            $("#carregandobusca").css("display", "none");
            SomaCusto();
        });
        $("#carregandobusca").css("display", "none");
    }

    function CarregaImg() {
//        alert(valor);
        var fichatecnica = $("#idfichatecnica").val();
        $("#recebeimg").load('_backend/_view/_pcp/_model/img_fichatecnica_grid.php?fichatecnica=' + fichatecnica, function () {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }

    function Busca(valor) {
//        alert(valor);
        $("#busca").modal('show');
        $("#buscatitle").html('BUSCA ' + valor.toUpperCase());
        $("#carregandobusca").css("display", "block");
        $("#recebegrid").load('_backend/_view/_grid/' + valor + '_grid.php?busca=S', function () {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }


    function BuscaPCP(valor) {
//        alert(valor);
        $("#busca").modal('show');
        $("#buscatitle").html('BUSCA ' + valor.toUpperCase());
        $("#carregandobusca").css("display", "block");
        $("#recebegrid").load('_backend/_view/_pcp/_grid/' + valor + '_grid.php?busca=S', function () {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }

    function Produto(valor) {
//        alert(valor);
        $("#produtos").val(valor);
        if (valor == '') {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/produtos_select_ajax_geral.php",
            data: {
                produtos: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
//alert(data);
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#produtos").val(data[0].codigo);
                    $("#produtosimg").val(data[0].codigo);
                    $("#produtodescricao").val(data[0].descricao);
                    $("#custocadastro").val(data[0].custo);
                    $("#custototal").val(data[0].custo);
                    VerificaFichaTecnica();
                } else {
                    toastr.warning('Produto Não Encontrado!');
                    $("#produtos").val('');
                    $("#produtodescricao").val('');
                    $("#custocadastro").val('');
                    $("#custototal").val('');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }

    function MateriaPrima(valor) {
//        alert(valor);
        $("#produto").val(valor);
        if (valor == '') {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/materiaprima_select_ajax_geral.php",
            data: {
                produtos: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
//alert(data);
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#materiaprima").val(data[0].codigo);
                    $("#materiaprimadescricao").val(data[0].descricao);
                    $("#customateriaprima").val(data[0].custo);
                    $("#unmateriaprima").val(data[0].unidade);
                } else {
                    toastr.warning('Produto Não Encontrado!');
                    $("#materiaprima").val('');
                    $("#materiaprimadescricao").val('');
                    $("#customateriaprima").val('');
                    $("#unmateriaprima").val('');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }

    function Processo(valor) {
//        alert(valor);
        $("#processo").val(valor);
        if (valor == '') {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_view/_pcp/_controller/_select/_ajax/processo_tipo_select_ajax.php",
            data: {
                processo: valor,
                tipo: 'P'
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
//alert(data);
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#processo").val(data[0].id);
                    $("#processodescricao").val(data[0].descricao);

                } else {
                    toastr.warning('Produto Não Encontrado!');
                    $("#processo").val('');
                    $("#processodescricao").val('');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }

    function Variaveis(valor) {
//        alert(valor);
        $("#variavel").val(valor);
        if (valor == '') {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_view/_pcp/_controller/_select/_ajax/variaveis_select_ajax.php",
            data: {
                variaveis: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
//alert(data);
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#variavel").val(data[0].id);
                    $("#variaveldescricao").val(data[0].variaveldesc);
                    $("#variavelvalor").val(data[0].variavelvalor);
                    $("#variaveltipo").val(data[0].variaveltipo);
                    if (data[0].variaveltipo === 'P') {
                        $("#tipovariavel").html('%');
                    } else {
                        $("#tipovariavel").html('R$');
                    }
                    SomaVar();
                } else {
                    toastr.warning('Produto Não Encontrado!');
                    $("#variavel").val('');
                    $("#variaveldescricao").val('');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }

    function Fase(valor) {
//        alert(valor);
        $("#fase").val(valor);
        if (valor == '') {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_view/_pcp/_controller/_select/_ajax/processo_tipo_select_ajax.php",
            data: {
                processo: valor,
                tipo: 'F'
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
//alert(data);
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#fase").val(data[0].id);
                    $("#fasedescricao").val(data[0].descricao);
                    if (data[0].geracusto === 'S') {
                        $("#fasevalor").val(data[0].valor);
                        if (data[0].tipovalor === 'T') {
                            $("#tempofase").css("display", "block");
                            $("#fasetipo").val('T');
                        } else {
                            $("#tempofase").css("display", "none");
                            $("#fasetipo").val('U');
                            $("#fasetotal").val(data[0].valor);
                        }
                    } else {
                        $("#fasevalor").val('0.00');
                        $("#fasetotal").val('0.00');
                    }

                } else {
                    toastr.warning('Fase Não Encontrado!');
                    $("#fase").val('');
                    $("#fasedescricao").val('');
                    $("#fasetempo").val('');
                    $("#fasetotal").val('');
                    $("#fasevalor").val('');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }
</script>
<style>
    label {
        font-size: 11px;
    }

    .accordion .panel .panel-title .accordion-toggle {
        display: block;
        padding: 20px 15px;
    }

    .table {
        font-size: 11px;
    }

    .table td, .table th {
        font-size: 12px;
    }
    .table thead tr th {
        font-size: 12px;
        font-weight: 600;
    }

    .select2-container--default .select2-selection--single .select2-selection__rendered {
        display: block;
        width: 100%;
        height: 34px;
        padding: 6px 12px;
        font-size: 14px;
        line-height: 1.42857143;
        color: #555;
        background-color: #fff;
        background-image: none;
        border: 1px solid #ccc;
        border-radius: 4px;
        -webkit-box-shadow: inset 0 1px 1px rgb(0 0 0 / 8%);
        box-shadow: inset 0 1px 1px rgb(0 0 0 / 8%);
        -webkit-transition: border-color ease-in-out .15s, -webkit-box-shadow ease-in-out .15s;
        -o-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
        transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
    }

    .select2-container--default .select2-selection--single {
        background-color: #fff;
        border: none;
        border-radius: 4px;
    }

    .select2-container {
        box-sizing: border-box;
        display: inline-block;
        margin: 0;
        position: relative;
        vertical-align: middle;
        width: 100%;
    }
</style>


<?php

function RetornaEspaco($nivel) {
    $espaco = '';
    if ($nivel > 1) :
        for ($i = 0; $i < $nivel; $i++) :
            $espaco .= '&emsp;';
        endfor;
    endif;

    return $espaco;
}

if (isset($_GET['editar'])) :

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'pcp_processos');
    $sql = "SELECT * from pcp_fichatecnica WHERE id ='" . $_GET['editar'] . "'";
//echo $sql;
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);
    ?>
    <script>
        Produto('<?= $dados->produto ?>');
    </script>
    <?php
endif;

$action = "" . BACKEND . "/_view/_pcp/_controller/_insert/ficha_tecnica_insert.php";
$actionimg = "" . BACKEND . "/_view/_pcp/_controller/_insert/ficha_tecnica_img_insert.php";
?>
<form id="ficha_tecnica" action="<?= $action ?>" method="POST">
    <?php
    if (isset($_GET['editar'])) :
        echo '<input type="hidden" name="id">';
    endif;
    ?>

    <div class="row" id="linhafichatecnica" style="display: none;">
        <input type="hidden" id="idfichatecnica">
        <div class="col-md-12 text-left"><b>Nº Ficha Técnica: <span id="fichatecnicaid" class="text-danger">50</span></b> </div>
    </div>
    <div class="row">
        <div class="col-md-2">
            <label>Produto </label>
            <input name="produto" id="produtos" onblur="Produto(this.value)" type="text" class="form-control" placeholder=""> 
            <i onclick="Busca('produtos')" style="position: absolute; right: 22px; top: 37px; z-index: 9999" class="fa fa-search"> </i>
        </div>

        <div class="col-md-6">
            <label>Produto Descrição </label>                         
            <input id="produtodescricao" disabled="" type="text" required="" class="form-control" placeholder="">                   
        </div>

        <div class="col-md-2">
            <label>Custo Produto</label>                         
            <input id="custocadastro" disabled="" type="text" required="" class="form-control" placeholder="">                   
        </div>

        <div class="col-md-2">
            <label>Custo F. Técnica</label>                         
            <input id="custoproduto" disabled="" type="text" required="" class="form-control" placeholder="">                   
        </div>

        <!--        <div class="col-md-2">
                    <label>Custo Total</label>                         
                    <input id="custototal" disabled="" type="text" required="" class="form-control" placeholder="">                   
                </div>-->

    </div>

    <hr/>
    <div class="row">
        <div class="col-md-12">
            <ul class="nav nav-tabs " role="tablist">
                <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab" data-toggle="tab">Composição</a></li>
                <li role="presentation"><a href="#processotab" aria-controls="processo" role="tab" data-toggle="tab">Processos de produção</a></li>
                <li role="presentation"><a href="#variaveistab" aria-controls="home" role="tab" data-toggle="tab">Variáveis de custos</a></li>
                <li role="presentation"><a href="#imagenstab" aria-controls="home" role="tab" data-toggle="tab">Imagens</a></li>
            </ul>
     <!--<section class="panel">-->
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="home">

                    <div class="portlet-body">
                        <div class="scroller" style="min-height:200px" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">


                            <div class="row"> 
                                <div class="col-md-2">
                                    <label>Matéria Prima </label>
                                    <input name="materiaprima" id="materiaprima" onblur="MateriaPrima(this.value)" type="text" class="form-control" placeholder=""> 
                                    <i onclick="Busca('materiaprima')" style="position: absolute; right: 22px; top: 37px; z-index: 9999" class="fa fa-search"> </i>
                                </div>

                                <div class="col-md-6">
                                    <label>Produto Descrição </label>                         
                                    <input id="materiaprimadescricao" disabled="" type="text" required="" class="form-control" placeholder="">                   
                                </div>

                                <div class="col-md-2">
                                    <label>Custo </label>                         
                                    <input id="customateriaprima" onkeyup="SomaMP()" type="text" required="" class="form-control" placeholder="">                   
                                </div>

                                <div class="col-md-2">
                                    <label>UN </label>                         
                                    <input id="unmateriaprima" readonly="" type="text" class="form-control" placeholder="">                   
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-2">
                                    <label>Quantidade </label>                         
                                    <input id="qtdmateriaprima" onkeyup="SomaMP()" type="text" required="" class="form-control" placeholder="">                   
                                </div>

                                <div class="col-md-2">
                                    <label>Total </label>                         
                                    <input id="totalmateriaprima" value="0,00" readonly="" type="text" class="form-control" placeholder="">                   
                                </div>    

                                <div class="col-md-2">
                                    <label>Processo(Setor) </label>
                                    <input name="processo" id="processo" onblur="Processo(this.value)" type="text" class="form-control" placeholder=""> 
                                    <i onclick="BuscaPCP('processo_tipo')" style="position: absolute; right: 22px; top: 37px; z-index: 9999" class="fa fa-search"> </i>
                                </div>

                                <div class="col-md-6">
                                    <label>Processo Descrição </label>                         
                                    <input id="processodescricao" disabled="" type="text" required="" class="form-control" placeholder="">                   
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 text-right">
                                    <br/>
                                    <button class="btn btn-primary" onclick="AdicionaComposicao()" type="button"> Adicionar </button>
                                    <hr/>
                                </div>
                            </div>

                            <div class="row" id="recebemp">

                            </div>

                        </div>
                    </div>
                </div>

                <!--PROCESSO DE PRODUÇÃO-->
                <div role="tabpanel" class="tab-pane" id="processotab">

                    <div class="portlet-body">
                        <div class="scroller" style="min-height:200px" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">
                            <div class="row">
                                <div class="col-md-2">
                                    <label>Fases </label>
                                    <input type="hidden" value="U" id="fasetipo">
                                    <input name="fase" id="fase" onblur="Fase(this.value)" type="text" class="form-control" placeholder=""> 
                                    <i onclick="BuscaPCP('fase_tipo')" style="position: absolute; right: 22px; top: 37px; z-index: 9999" class="fa fa-search"> </i>
                                </div>

                                <div class="col-md-4">
                                    <label>Processo Descrição </label>                         
                                    <input id="fasedescricao" disabled="" type="text" required="" class="form-control" placeholder="">                   
                                </div>


                                <div class="col-md-2" id="tempofase" style="display: none;">
                                    <label>Tempo (h:m:s)</label>
                                    <input type="text" onkeyup="SomaTempo()" class="form-control time" id="fasetempo" name="fasetempo" onkeypress="mascara(this, mtime);" maxlength="8"  pattern=".{8,8}" placeholder="00:00:00" />
                                </div>

                                <div class="col-md-2">
                                    <label>Valor</label>
                                    <input type="text" onkeyup="SomaTempo()" class="form-control" id="fasevalor" name="fasevalor" onkeypress="mascara(this, mvalor);"  />
                                </div>
                                <div class="col-md-2">
                                    <label>Total</label>
                                    <input type="text" readonly="" class="form-control" id="fasetotal" name="fasetotal" onkeypress="mascara(this, mvalor);"  />
                                </div>
                                <div class="col-md-2">
                                    <label>Movimento O.P</label>
                                    <select id="situacao" class="form-control">
                                        <option></option>
                                        <option value="P">Primeira Fase</option>
                                        <option value="U">Última Fase</option>
                                        <option value="PU">Primeira E última Fase</option>
                                    </select>
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-md-12 text-right">
                                    <br/>
                                    <button onclick="AdicionaProcesso()" class="btn btn-primary" type="button"> Adicionar </button>
                                    <hr/>
                                </div>
                            </div>

                            <div class="row" id="recebeprocesso">

                            </div>

                            <!--recebemp-->
                        </div>
                    </div>

                </div>


                <!--VARIAVEIS DE PRODUÇÃO-->
                <div role="tabpanel" class="tab-pane" id="variaveistab">

                    <div class="portlet-body">
                        <div class="scroller" style="min-height:200px" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">             
                            <div class="row">
                                <div class="col-md-2">
                                    <label>Variável </label>
                                    <input name="variavel" id="variavel" onblur="Variaveis(this.value)" type="text" class="form-control" placeholder=""> 
                                    <i onclick="BuscaPCP('variaveis')" style="position: absolute; right: 22px; top: 37px; z-index: 9999" class="fa fa-search"> </i>
                                </div>

                                <div class="col-md-5">
                                    <label>Variável Descrição </label>                         
                                    <input id="variaveldescricao" disabled="" type="text" required="" class="form-control" placeholder="">                   
                                </div>

                                <div class="col-md-2">
                                    <label>Valor &nbsp;&nbsp;<span id="tipovariavel" class="label label-primary">  </span> </label>   
                                    <input id="variaveltipo" type="hidden">
                                    <input id="variavelvalor" disabled="" type="text" required="" class="form-control" placeholder="">                   
                                </div>
                                <div class="col-md-2">
                                    <label>Total </label>                         
                                    <input id="variaveltotal" disabled="" type="text" required="" class="form-control" placeholder="">                   
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 text-right">
                                    <br/>
                                    <button onclick="AdicionaVariavel()()" class="btn btn-primary" type="button"> Adicionar </button>
                                    <hr/>
                                </div>
                            </div>

                            <div class="row" id="recebevariavel">

                            </div>
                        </div>
                    </div>

                </div>
                </form>


                <!--IMAGENS DE PRODUÇÃO-->
                <div role="tabpanel" class="tab-pane" id="imagenstab">
                    <form id="ficha_tecnica_imagem" action="<?= $actionimg ?>" method="POST">
                        <input type="hidden" name="produto" id="produtosimg">
                        <input type="hidden" name="fichatecnica" id="fichatecnicaimg">
                        <div class="portlet-body">
                            <div class="scroller" style="min-height:200px" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">
                                <div class="row">
                                    <div class="col-md-4"> 
                                        <input type="file" name="foto" id="foto" requerid="" clas="form-control">
                                    </div>
                                    <div class="col-md-4"> 
                                        <button class="btn btn-info" type="submit">Enviar Imagem</button>
                                    </div>
                                </div>
                                <br/>
                                <div class="row" id="recebeimg"></div>
                            </div>
                        </div>
                    </form>

                </div>

                <div class="row">
                    <div class="col-md-12 text-center">
                        <a href="#" class="btn btn-warning" onclick="Fechar()"> <i class="fa fa-close"></i> Fechar </a>
                    </div>
                </div>

            </div>
        </div>

    </div>



    <script>
        $(document).ready(function () {
            // bind form using ajaxForm          
            $('#ficha_tecnica').ajaxForm({
                // dataType identifies the expected content type of the server response 
                dataType: 'json',
                // success identifies the function to invoke when the server response              // has been received 
                success: processJson
            });
            $('#ficha_tecnica_imagem').ajaxForm({
                // dataType identifies the expected content type of the server response 
                dataType: 'json',
                // success identifies the function to invoke when the server response              // has been received 
                success: processJsonImg
            });
        }
        );

        function processJson(data) {
            if (data.retorno == true) {
                Carrega('_pcp/_grid', 'fichatecnica_grid.php', 'Ficha Técnica');
                document.getElementById("alerterro").style.display = "none";
                document.getElementById("alertsucesso").style.display = "block";
                $("#sucesso").html(data.mensagem);
                setTimeout(function () {
                    $("#alertsucesso").css("display", "none");
                }, 7000);
            } else {
                document.getElementById("alertsucesso").style.display = "none";
                document.getElementById("alerterro").style.display = "block";
                $("#erro").html(data.mensagem);
                setTimeout(function () {
                    $("#alerterro").css("display", "none");
                }, 7000);
            }
        }
        function processJsonImg(data) {
            if (data.retorno == true) {
                CarregaImg();
                document.getElementById("alerterro").style.display = "none";
                document.getElementById("alertsucesso").style.display = "block";
                $("#sucesso").html(data.mensagem);
                setTimeout(function () {
                    $("#alertsucesso").css("display", "none");
                }, 7000);
            } else {
                document.getElementById("alertsucesso").style.display = "none";
                document.getElementById("alerterro").style.display = "block";
                $("#erro").html(data.mensagem);
                setTimeout(function () {
                    $("#alerterro").css("display", "none");
                }, 7000);
            }
        }
    </script>