<?php
require_once("../../../../functions.php");
require_once("../../_modal/_modal.php");
require_once "../../../../_backend/_class/Conexao_class.php";
require_once "../../../../_backend/_class/Crud_class.php";
require_once "../../../../_backend/_class/nivel_acesso.php";
?>
<style>
    .tab-content {
        border-radius: 0 0 0px 0px;
        box-shadow: 0 0px 0px 0 rgba(0, 0, 0, 0.04);
        background-color: white;
        border: 0px solid #eeeeee;
        border-top: 0;
        padding: 15px;
    }

    .input-group-addon {
        padding: 6px 12px;
        font-size: 14px;
        font-weight: normal;
        line-height: 1;
        color: #555555;
        text-align: center;
        background-color: #fff;
        border: 0px solid #cccccc;
        border-radius: 0px;
    }

    label {
        font-size: 12px;
    }

    .select2-container .select2-selection--single .select2-selection__rendered {
        padding-left: 8px;
        padding-right: 20px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
        display: block;
        width: 100%;
        height: 34px;
        padding: 6px 12px;
        font-size: 14px;
        background-image: none;
        border: 1px solid #ccc;
        border-radius: 4px;
        -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
        box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
        -webkit-transition: border-color ease-in-out .15s, -webkit-box-shadow ease-in-out .15s;
        -o-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
        transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
    }

    .select2-container--default .select2-selection--single {
        background-color: #fff;
        border: 1px solid #fff;
        border-radius: 4px;
    }

    .select2-container {
        box-sizing: border-box;
        display: block;
        margin: 0;
        position: relative;
        /* vertical-align: middle; */
        /* width: 100%; */
    }
</style>

<script>

    $(document).ready(function () {
        $('.cidades').select2();
    });

    document.querySelector('select[name="infPag_tpPag"]').addEventListener('change', function () {
        const isPIX = this.value === '15';
        const bancFields = document.querySelectorAll('[name^="infBanc_"]');

        bancFields.forEach(el => {
            el.required = isPIX;
            el.closest('.col-md-3, .col-md-4').style.display = isPIX ? 'block' : 'none';
        });
    });

    document.querySelector('select[name="Comp_tpComp"]').addEventListener('change', function () {
        const xCompInput = document.querySelector('input[name="Comp_xComp"]');
        switch (this.value) {
            case '01':
                xCompInput.value = 'Valor do Frete';
                break;
            case '02':
                xCompInput.value = 'Pedágio';
                break;
            case '03':
                xCompInput.value = 'Despesas';
                break;
            case '99':
                xCompInput.value = '';
                break;
            default:
                xCompInput.value = '';
        }
    });


    function NFe(valor) {

        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/nfechave_select_ajax.php",
            data: {
                chavenfe: valor
            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //                alert(data[0]);
                if (typeof data[0] === "undefined") {
                    return false;
                } else {
                    LocalDescarregamentoNFeAdd(data[0].destxMun, data[0].destcMun, valor, data[0].destUF);
                    var vCarga = $("#vCarga").val();
                    var total = parseFloat(vCarga) + parseFloat(data[0].vNF);
                    $("#vCarga").val(total.toFixed(2));
                    var qCarga = $("#qCarga").val();
                    var totalqCarga = parseFloat(qCarga) + parseFloat(data[0].pesoL);
                    $("#qCarga").val(totalqCarga.toFixed(2));

                }
            }
        }); //termina o jquery

        $("#busca").modal('hide');
    }

    function Transportador(valor) {

        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/transportador_select_ajax.php",
            data: {
                transportador: valor
            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                // alert(data[0].rntrc);
                if (typeof data[0] === "undefined") {
                    return false;
                } else {
                    $("#transportador").val(data[0].transportadorid);
                    $("#placa").val(data[0].placa);
                    $("#RNTRC").val(data[0].rntrc);
                    $("#tpcar").val(data[0].tpcar);
                    $("#tprod").val(data[0].tprod);
                    $("#tara").val(data[0].tara);
                    MotoristaTransp(data[0].xNome, data[0].CNPJ);
                }
            }
        }); //termina o jquery

        $("#busca").modal('hide');
    }

    function MunCarregamentoAdd() {
        var valor = $("#localemi").val();
        var retorno = valor.split(";");
        var option = '';
        option += '<div class="row" id="localemi' + retorno[0] + '"> <br/>' +
                ' <div class="col-md-7"> <input type="text" class="form-control" readonly="" name="localemi[]" value="' + retorno[1] + '"> </div>'
                + ' <div class="col-md-2"> <input type="text" class="form-control" readonly="" name="localemiuf[]" value="' + retorno[2] + '"> </div>'
                + ' <div class="col-md-2"> <input type="text" class="form-control" readonly="" name="localemicodmun[]" value="' + retorno[0] + '"> </div>'
                + ' <div class="col-md-1"> <button class="btn btn-danger" type="button" onclick="Remove(' + retorno[0] + ')"> <i class="fa fa-trash"></i> </button> </div>'
                + ' </div>';

        //        alert(option);
        $("#recebelocalemi").append(option);
        $("#localemi").val('');
    }

    function LocalDescarregamentoAdd() {
        var valor = $("#mundescarregamento").val();
        var chave = $("#chavenfe").val();
        var retorno = valor.split(";");
        var option = '';
        option += ' <div class="row" id="mundescarregamento' + retorno[0] + '"> <br/>' +
                ' <div class="col-md-5"> <input type="text" class="form-control" readonly="" name="chavedesc[]" value="' + chave + '"> </div>'
                + ' <div class="col-md-3"> <input type="text" class="form-control" readonly="" name="mundescarregamento[]" value="' + retorno[1] + '"> </div>'
                + ' <div class="col-md-2"> <input type="text" class="form-control" readonly="" name="mundescarregamentouf[]" value="' + retorno[2] + '"> </div>'
                + ' <div class="col-md-1"> <input type="text" class="form-control" readonly="" name="mundescarregamentocodmun[]" value="' + retorno[0] + '"> </div>'
                + ' <div class="col-md-1"> <button class="btn btn-danger" type="button" onclick="RemoveMunDesc(' + retorno[0] + ')"> <i class="fa fa-trash"></i> </button> </div>'
                + ' </div>';

        //        alert(option);
        $("#recebemundescarregamento").append(option);
        $("#chavenfe").val('');
    }

    function LocalDescarregamentoNFeAdd(xMun, cMun, chave, uf) {
        var option = '';
        option += ' <div class="row" id="mundescarregamento' + cMun + '"> <br/>' +
                ' <div class="col-md-5"> <input type="text" class="form-control" readonly="" name="chavedesc[]" value="' + chave + '"> </div>'
                + ' <div class="col-md-3"> <input type="text" class="form-control" readonly="" name="mundescarregamento[]" value="' + xMun + '"> </div>'
                + ' <div class="col-md-2"> <input type="text" class="form-control" readonly="" name="mundescarregamentocodmun[]" value="' + cMun + '"> </div>'
                + ' <div class="col-md-1"> <input type="text" class="form-control" readonly="" name="mundescarregamentouf[]" value="' + uf + '"> </div>'
                + ' <div class="col-md-1"> <button class="btn btn-danger" type="button" onclick="RemoveMunDesc(' + cMun + ')"> <i class="fa fa-trash"></i> </button> </div>'
                + ' </div>';

        //        alert(option);
        $("#recebemundescarregamento").append(option);
        $("#chavenfe").val('');
    }

    function PercursoAdd() {
        var valor = $("#percurso").val();
        var id = Math.floor(Math.random() * 1000) + 1;
        var option = '';
        option += ' <div class="col-md-3" id="percurso' + id + '"> <br/>' +
                ' <div class="col-md-10"> <input type="text" class="form-control" readonly="" name="percusoestado[]" value="' + valor + '"> </div>'
                + ' <div class="col-md-2"> <button class="btn btn-danger" type="button" onclick="RemovePercurso(' + id + ')"> <i class="fa fa-trash"></i> </button> </div>'
                + ' </div>';

        //        alert(option);
        $("#recebepercurso").append(option);
        $("#percurso").val('');
    }

    function Remove(id) {
        $("#localemi" + id + "").remove();
    }

    function RemovePercurso(id) {
        $("#percurso" + id + "").remove();
    }

    function RemoveMunDesc(id) {
        $("#mundescarregamento" + id + "").remove();
    }

    function Cidades() {
        $.ajax({
            type: "GET",
            url: "https://servicodados.ibge.gov.br/api/v1/localidades/municipios",
            dataType: "json",
            success: function (data) {
                var option = '<option value="">Selecione</option>';
                $.each(data, function (i, obj) {
                    var nome = obj.nome || '';
                    var uf = (obj.microrregiao && obj.microrregiao.mesorregiao && obj.microrregiao.mesorregiao.UF && obj.microrregiao.mesorregiao.UF.sigla) || '';
                    if (nome && uf) {
                        option += '<option value="' + obj.id + ';' + nome + ';' + uf + '">' + nome + ' - ' + uf + '</option>';
                    }
                });

                $('#localemi').html(option).show();
                $('#ufdescarrega').html(option).show();
                $('#mundescarregamento').html(option).show();
            },
            error: function (xhr, status, error) {
                console.error("Erro ao carregar municípios:", error);
            }
        });
    }


    function CidadesDescarrega(valor) {
        $.ajax({
            type: "GET",
            url: "https://servicodados.ibge.gov.br/api/v1/localidades/estados/" + valor + "/distritos",
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                var option = '<option></option>';
                $.each(data, function (i, obj) {
                    option += '<option value="' + obj.id + ';' + obj.nome + ';' + obj.microrregiao.mesorregiao.UF.sigla + '"> ' + obj.nome + ' </option>';
                })

                $('#mundescarregamento').html(option).show();
            }
        }); //termina o jquery
    }

    $(document).ready(function () {
        Cidades();
    });





    function TipoEmit(valor) {
        if (valor === '2') {
            $("#tipemittipo").text('NF-e');
            $("#dadoscte").hide();
            $("#tabpag").hide();

        } else {
            $("#tipemittipo").text('CT-e');
            $("#dadoscte").show();
            $("#tabpag").show();
        }
    }


    function Busca(valor) {
        $("#busca").modal('show');
        $("#buscatitle").html('BUSCA ' + valor.toUpperCase());
        $("#carregandobusca").css("display", "block");
        $("#recebegrid").load('_backend/_view/_grid/' + valor + '_grid.php?busca=S', function () {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }


    function Motorista() {

        var total = $("#vlrmotorista").val();
        if (total == '') {
            id = 1;
        } else {
            var id = total + 1;
        }

        var conteudo = "<div id='lc" + id + "'>" +
                "<div class='col-md-6'>" +
                "<label><span> Nome</span> </label>" +
                "<input type='text' name='motnome[]' class='form-control'>" +
                "</div>" +
                "<div class='col-md-5'>" +
                "<label><span> CPF</span> </label>" +
                "<input type='text' name='motcpf[]' class='form-control'>" +
                "</div>" +
                "<div class='col-md-1'> <br/>" +
                " <a href='javascript::' class='btn btn-danger btn-sm' type='button' onclick='ExcluirMotorista(" + id + ")'> <i class ='fa fa-trash'></i> </a>  <br> <br>" +
                "</div>" +
                "<br/>" +
                "</div>";
        $("#motoristadoc").append(conteudo);
        $("#vlrmotorista").val(id);
    }

    function MotoristaTransp(nome, cpf) {

        var total = $("#vlrmotorista").val();
        if (total == '') {
            id = 1;
        } else {
            var id = total + 1;
        }

        var conteudo = "<div id='lc" + id + "'>" +
                "<div class='col-md-6'>" +
                "<label><span> Nome</span> </label>" +
                "<input type='text' name='motnome[]' value='" + nome + "' class='form-control'>" +
                "</div>" +
                "<div class='col-md-5'>" +
                "<label><span> CPF</span> </label>" +
                "<input type='text' name='motcpf[]' value='" + cpf + "' class='form-control'>" +
                "</div>" +
                "<div class='col-md-1'> <br/>" +
                " <a href='javascript::' class='btn btn-danger btn-sm' type='button' onclick='ExcluirMotorista(" + id + ")'> <i class ='fa fa-trash'></i> </a>  <br> <br>" +
                "</div>" +
                "<br/>" +
                "</div>";
        $("#motoristadoc").append(conteudo);
        $("#vlrmotorista").val(id);
    }

    function ExcluirMotorista(valor) {
        $("#lc" + valor + "").remove();
    }
</script>
<?php
if (isset($_GET['editar'])):
    $action = "" . BACKEND . "/_view/_mdfe/_controller/_update/mdfe_update.php";
    ?>
    <script>
        $(document).ready(function () {

            //        alert(valor);
            $.ajax({
                type: "GET",
                url: "<?= BACKEND ?>/_view/_mdfe/_controller/_select/_ajax/mdfe_select_ajax.php",
                data: {
                    nMDF: <?= $_GET['editar'] ?>
                },
                dataType: "json",
                // função para de sucesso
                success: function (data) {
                    //  alert();
                    if (data != null) {

                        $.each(data, function () {
                            $.each(this, function (k, v) {
                                $("input[name='" + k + "']").val(v);
                                $("select[name='" + k + "']").val(v);
                                $("textarea[name='" + k + "']").val(data[0].infCpl);
                            });
                        });
                    }
                }
            }); //termina o jquery

        });

    </script>
    <?php
else:

    $action = "" . BACKEND . "/_view/_mdfe/_controller/_insert/mdfe_insert.php";

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'nfe');
    $sql = "SELECT nMDF FROM mdfe where empresa = '" . $_SESSION['Empresa'] . "' ORDER BY nMDF Desc LIMIT 1";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    $nmdfe = $dados->nMDF + 1;
endif;
?>
<form id="mdfeform" action="<?= $action ?>" method="POST">
    <?php
    if (isset($_GET['editar'])):

        echo '<input type="hidden" name="id">';

    endif;
    ?>
    <div class="row">
        <div class="col-md-12">
            <ul class="nav nav-tabs " role="tablist">
                <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab"
                                                          data-toggle="tab">Dados Gerais</a></li>
                <li role="presentation"><a href="#carregamento" aria-controls="carregamento" role="tab"
                                           data-toggle="tab">Carregamento</a></li>
                <li role="presentation"><a href="#docs" aria-controls="settings" role="tab"
                                           data-toggle="tab">Documentos</a></li>
                <li role="presentation"><a href="#rodoviario" aria-controls="rodoviario" role="tab"
                                           data-toggle="tab">Modal Rodoviário</a></li>
                <li role="presentation" id="tabpag" style="display: none;"><a href="#pagamentos" aria-controls="pagamentos" role="tab"
                                                                              data-toggle="tab">Pagamentos</a></li>
                <li role="presentation"><a href="#totalizadores" aria-controls="totalizadores" role="tab"
                                           data-toggle="tab">Totalizadores</a></li>
            </ul>
            <!--<section class="panel">-->
            <div class="tab-content">

                <div role="tabpanel" class="tab-pane active" id="home">
                    <div class="row">
                        <div class="col-md-5">
                            <label>Tipo do transportador <span class="text-danger">*</span></label>
                            <select name="tptransp" class="form-control">
                                <option value="1">ETC - Empresa de transporde Rod. de Carga</option>
                                <option value="2">TAC - Transportador Autônomo de Carga</option>
                                <option value="3">CTC - Cooperativa de transporte de Carga</option>
                            </select>
                        </div>

                        <div class="col-md-1">
                            <label>Série <span class="text-danger">*</span></label>
                            <input name="serie" type="text" required="" class="form-control" value="1" placeholder="">
                        </div>

                        <div class="col-md-2">
                            <label>Nº <span class="text-danger">*</span></label>
                            <input name="nMDF" id="nMDF" type="text" maxlength="9" required="" class="form-control"
                                   value="<?= $nmdfe ?>" placeholder="">
                        </div>

                        <div class="col-md-2">
                            <label>Data Emissão<span class="text-danger">*</span></label>
                            <input name="dhEmi" type="text" required="" onkeypress="mascara(this, mdata);"
                                   maxlength="10" value="<?= date("d/m/Y") ?>" class="date form-control">
                        </div>

                        <div class="col-md-2">
                            <label>Hora Emissão<span class="text-danger">*</span></label>
                            <input name="hEmi" type="text" required="" onkeypress="mascara(this, mtime);" maxlength="5"
                                   value="<?= date("H:i") ?>" class="form-control">
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <label>UF do carregamento<span class="text-danger">*</span></label>
                            <select name="UFIni" class="form-control">
                                <option value="AC">Acre</option>
                                <option value="AL">Alagoas</option>
                                <option value="AP">Amapá</option>
                                <option value="AM">Amazonas</option>
                                <option value="BA">Bahia</option>
                                <option value="CE">Ceará</option>
                                <option value="DF">Distrito Federal</option>
                                <option value="ES">Espírito Santo</option>
                                <option value="GO">Goiás</option>
                                <option value="MA">Maranhão</option>
                                <option value="MT">Mato Grosso</option>
                                <option value="MS">Mato Grosso do Sul</option>
                                <option value="MG">Minas Gerais</option>
                                <option value="PA">Pará</option>
                                <option value="PB">Paraíba</option>
                                <option value="PR">Paraná</option>
                                <option value="PE">Pernambuco</option>
                                <option value="PI">Piauí</option>
                                <option value="RJ">Rio de Janeiro</option>
                                <option value="RN">Rio Grande do Norte</option>
                                <option value="RS">Rio Grande do Sul</option>
                                <option value="RO">Rondônia</option>
                                <option value="RR">Roraima</option>
                                <option value="SC">Santa Catarina</option>
                                <option value="SP">São Paulo</option>
                                <option value="SE">Sergipe</option>
                                <option value="TO">Tocantins</option>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label>UF do descarregamento<span class="text-danger">*</span></label>
                            <select name="UFFim" class="form-control">
                                <option value="AC">Acre</option>
                                <option value="AL">Alagoas</option>
                                <option value="AP">Amapá</option>
                                <option value="AM">Amazonas</option>
                                <option value="BA">Bahia</option>
                                <option value="CE">Ceará</option>
                                <option value="DF">Distrito Federal</option>
                                <option value="ES">Espírito Santo</option>
                                <option value="GO">Goiás</option>
                                <option value="MA">Maranhão</option>
                                <option value="MT">Mato Grosso</option>
                                <option value="MS">Mato Grosso do Sul</option>
                                <option value="MG">Minas Gerais</option>
                                <option value="PA">Pará</option>
                                <option value="PB">Paraíba</option>
                                <option value="PR">Paraná</option>
                                <option value="PE">Pernambuco</option>
                                <option value="PI">Piauí</option>
                                <option value="RJ">Rio de Janeiro</option>
                                <option value="RN">Rio Grande do Norte</option>
                                <option value="RS">Rio Grande do Sul</option>
                                <option value="RO">Rondônia</option>
                                <option value="RR">Roraima</option>
                                <option value="SC">Santa Catarina</option>
                                <option value="SP">São Paulo</option>
                                <option value="SE">Sergipe</option>
                                <option value="TO">Tocantins</option>
                            </select>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <label>Info Adicionais:</label>
                            <textarea name="infCpl" rows="6" class="form-control"></textarea>
                        </div>
                    </div>
                </div>

                <div role="tabpanel" class="tab-pane" id="carregamento">
                    <div class="row">
                        <div class="col-md-10">
                            <label>Municipio de carregamento<span class="text-danger">*</span></label>
                            <select id="localemi" class="cidades" style="width: 100%; min-width: 400px;">
                            </select>
                        </div>

                        <div class="col-md-2">
                            <button class="btn btn-primary btn-sm form-control" type="button"
                                    onclick="MunCarregamentoAdd()" style="margin-top: 26px">Adicionar</button>
                        </div>
                    </div>
                    <!--<hr/>-->

                    <?php
                    if (isset($_GET['editar'])):


                        $pdo = Conexao::getInstance();
                        $crud = Crud::getInstance($pdo, 'nfe');
                        $sql = "SELECT * from muncarregamdfe WHERE nMDFE = " . $_GET['editar'] . "";
                        $arrayParam = '';
                        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

                        foreach ($dados as $muncarrega):
                            ?>
                            <div class="row" id="localemi9<?= $muncarrega->muncarregamdf ?>"> <br />
                                <div class="col-md-7"> <input type="text" class="form-control" readonly="" name="localemi[]"
                                                              value="<?= $muncarrega->xMunCarrega ?>"> </div>
                                <div class="col-md-2"> <input type="text" class="form-control" readonly="" name="localemiuf[]"
                                                              value="<?= $muncarrega->UFCarrega ?>"> </div>
                                <div class="col-md-2"> <input type="text" class="form-control" readonly=""
                                                              name="localemicodmun[]" value="<?= $muncarrega->cMunCarrega ?>"> </div>
                                <div class="col-md-1"> <button class="btn btn-danger" type="button"
                                                               onclick="Remove('9<?= $muncarrega->muncarregamdf ?>')"> <i class="fa fa-trash"></i>
                                    </button> </div>
                            </div>
                            <?php
                        endforeach;
                    endif;
                    ?>
                    <div id="recebelocalemi">

                    </div>

                    <div class="row">
                        <hr />
                        <div class="col-md-12">
                            Percurso
                        </div>
                        <div class="col-md-12 alert alert-warning">
                            <b> Atenção! </b> Não é necessário repetir as UFs de carregamento e descarregamento!
                            <br />
                            Se há mais de um estado neste trajeto, então deverá ser informado exatamente na ordem em que
                            o veículo seguirá.
                            <br /> Exemplo: Origem RS e Destino RJ, logo, as UFs de percurso deverão ser SC, PR, SP.
                            Exatamente nesta ordem.
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-10">

                            <select id="percurso" class="form-control">
                                <option></option>
                                <option value="AC">Acre</option>
                                <option value="AL">Alagoas</option>
                                <option value="AP">Amapá</option>
                                <option value="AM">Amazonas</option>
                                <option value="BA">Bahia</option>
                                <option value="CE">Ceará</option>
                                <option value="DF">Distrito Federal</option>
                                <option value="ES">Espírito Santo</option>
                                <option value="GO">Goiás</option>
                                <option value="MA">Maranhão</option>
                                <option value="MT">Mato Grosso</option>
                                <option value="MS">Mato Grosso do Sul</option>
                                <option value="MG">Minas Gerais</option>
                                <option value="PA">Pará</option>
                                <option value="PB">Paraíba</option>
                                <option value="PR">Paraná</option>
                                <option value="PE">Pernambuco</option>
                                <option value="PI">Piauí</option>
                                <option value="RJ">Rio de Janeiro</option>
                                <option value="RN">Rio Grande do Norte</option>
                                <option value="RS">Rio Grande do Sul</option>
                                <option value="RO">Rondônia</option>
                                <option value="RR">Roraima</option>
                                <option value="SC">Santa Catarina</option>
                                <option value="SP">São Paulo</option>
                                <option value="SE">Sergipe</option>
                                <option value="TO">Tocantins</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-primary btn-sm form-control" onclick="PercursoAdd()"
                                    type="button">Adicionar</button>
                        </div>
                    </div>


                    <?php
                    if (isset($_GET['editar'])):


                        $pdo = Conexao::getInstance();
                        $crud = Crud::getInstance($pdo, 'nfe');
                        $sql = "SELECT * from percursomdfe WHERE nMDFE = " . $_GET['editar'] . "";
                        $arrayParam = '';
                        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

                        foreach ($dados as $percursomdfe):
                            ?>
                            <div class="col-md-3" id="percurso9<?= $percursomdfe->id ?>"> <br />
                                <div class="col-md-10"> <input type="text" class="form-control" readonly=""
                                                               name="percusoestado[]" value="<?= $percursomdfe->UFPer ?>"> </div>
                                <div class="col-md-2"> <button class="btn btn-danger" type="button"
                                                               onclick="RemovePercurso('9<?= $percursomdfe->id ?>')"> <i class="fa fa-trash"></i>
                                    </button> </div>
                            </div>
                            <?php
                        endforeach;
                    endif;
                    ?>

                    <div id="recebepercurso">

                    </div>
                </div>

                <div role="tabpanel" class="tab-pane" id="docs">
                    <div class="row">
                        <div class="col-md-6">
                            <label>Tipo do Emitente<span class="text-danger">*</span></label>
                            <select id="tipoemitente" name="tpEmit" class="form-control"
                                    onchange="TipoEmit(this.value)">
                                <option value="2"> 2 - Transportador de carga própria</option>
                                <option value="1"> 1 - Prestador de serviço de transporte</option>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <div class="alert alert-info" style="margin-top: 10px;">
                                <i class="fa fa-info-circle"></i> Para o tipo de emitente informado, insira apenas
                                <b><span id="tipemittipo"> NF-e </span></b>
                            </div>
                        </div>
                    </div>


                    <div class="row" id="dadoscte" style="display: none;">
                        <div class="col-md-3">
                            <label>Tipo de Carga</label>
                            <select id="tpCarga" name="tpCarga" class="form-control">
                                <option value="01"> 01-Granel sólido</option>
                                <option value="02"> 02-Granel líquido</option>
                                <option value="03"> 03-Frigorificada</option>
                                <option value="04"> 04-Conteinerizada</option>
                                <option value="05"> 05-Carga Geral</option>
                                <option value="06"> 06-Neogranel</option>
                                <option value="07"> 07-Perigosa (granel sólido)</option>
                                <option value="08"> 08-Perigosa (granel líquido)</option>
                                <option value="09"> 09-Perigosa (carga frigorificada)</option>
                                <option value="10"> 10-Perigosa (conteinerizada)</option>
                                <option value="11"> 11-Perigosa (carga geral)</option>
                            </select>
                        </div>

                        <div class="col-md-5">
                            <label>Descrição do produto </label>
                            <input id="xProd" name="xProd" type="text" class="form-control" maxlength="120"
                                   placeholder="">
                        </div>

                        <div class="col-md-2">
                            <label>CEP Carregamento </label>
                            <input id="cepinicio" name="cepinicio" type="text" class="form-control" maxlength="8"
                                   placeholder="">
                        </div>

                        <div class="col-md-2">
                            <label>CEP Descarregamento </label>
                            <input id="cepfim" name="cepfim" type="text" class="form-control" maxlength="8"
                                   placeholder="">
                        </div>
                    </div>

                    <div class="row">

                        <div class="col-md-5">
                            <label>Chave</label>
                            <input id="chavenfe" type="text" class="form-control" maxlength="44" placeholder="">
                            <i style="position: absolute; right: 22px; top: 34px; cursor: pointer;"
                               onclick="Busca('nfe_aprovada')" class="fa fa-search"> </i>

                        </div>

                        <div class="col-md-5">
                            <label>Municipio de Descarregamento</label>
                            <select id="mundescarregamento" class="cidades">
                                <option></option>
                            </select>
                        </div>

                        <div class="col-md-2">
                            <button class="btn btn-primary btn-sm form-control" onclick="LocalDescarregamentoAdd()"
                                    type="button" style="margin-top: 26px">Adicionar</button>
                        </div>
                    </div>


                    <?php
                    if (isset($_GET['editar'])):


                        $pdo = Conexao::getInstance();
                        $crud = Crud::getInstance($pdo, 'nfe');
                        $sql = "SELECT * from mundescargamdfe WHERE nMDFE = " . $_GET['editar'] . "";
                        $arrayParam = '';
                        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

                        foreach ($dados as $mundescargamdfe):
                            ?>
                            <div class="row" id="mundescarregamento9<?= $mundescargamdfe->mundescargamdfeid ?>"> <br />
                                <div class="col-md-5"> <input type="text" class="form-control" readonly="" name="chavedesc[]"
                                                              value="<?= $mundescargamdfe->chave ?>"> </div>
                                <div class="col-md-3"> <input type="text" class="form-control" readonly=""
                                                              name="mundescarregamento[]" value="<?= $mundescargamdfe->xMunDescarga ?>"> </div>
                                <div class="col-md-2"> <input type="text" class="form-control" readonly=""
                                                              name="mundescarregamentouf[]" value="<?= $mundescargamdfe->UFDescarga ?>"> </div>
                                <div class="col-md-1"> <input type="text" class="form-control" readonly=""
                                                              name="mundescarregamentocodmun[]" value="<?= $mundescargamdfe->cMunDescarga ?>"> </div>
                                <div class="col-md-1"> <button class="btn btn-danger" type="button"
                                                               onclick="RemoveMunDesc('9<?= $mundescargamdfe->mundescargamdfeid ?>')"> <i
                                            class="fa fa-trash"></i> </button> </div>
                            </div>
                            <?php
                        endforeach;
                    endif;
                    ?>


                    <div id="recebemundescarregamento">

                    </div>

                </div>

                <div role="tabpanel" class="tab-pane" id="rodoviario">
                    <div class="row">
                        <div class="col-md-2">
                            <label class="control-label">Transportador </label>
                            <input type="text" maxlength="10" class="form-control" readonly="" id="transportador"
                                   name="transportador" />
                        </div>

                        <div class="col-md-2">
                            <label class="control-label">Placa <span class="text-danger">*</span></label>
                            <input type="text" maxlength="10" class="form-control" id="placa" name="placa"
                                   placeholder="XXX9999" />
                            <i style="position: absolute; right: 22px; top: 34px; cursor: pointer;"
                               onclick="Busca('transportador')" class="fa fa-search"> </i>
                        </div>

                        <div class="col-md-2">
                            <label>RNTRC <span class="text-danger">*</span></label>
                            <input name="RNTRC" type="text" maxlength="8" id="RNTRC" required="" class="form-control"
                                   placeholder="">
                        </div>

                        <div class="col-md-2">
                            <label class="control-label">Tipo de Carroceria <span class="text-danger">*</span></label>
                            <select name="tpcar" id="tpcar" class="form-control">
                                <option value="00">00- Não Aplicável</option>
                                <option value="01">01- Aberta</option>
                                <option value="02">02- Fechada/Baú</option>
                                <option value="03">03- Granelera</option>
                                <option value="04">04- Porta Container</option>
                                <option value="05">05- Sider</option>
                            </select>

                        </div>

                        <div class="col-md-2">
                            <label class="control-label">Tipo de Rodado <span class="text-danger">*</span></label>
                            <select name="tprod" id="tprod" class="form-control">
                                <option value="01">01- Truck</option>
                                <option value="02">02- Toco</option>
                                <option value="03">03- Cavalo Mecânico</option>
                                <option value="04">04- Van</option>
                                <option value="05">05- Utilitário</option>
                                <option value="06">06- Outros</option>
                            </select>
                        </div>



                        <div class="col-md-2">
                            <label class="control-label">Tara(Kg) <span class="text-danger">*</span></label>
                            <input type="text" name="tara" id="tara" value="0" class="form-control" placeholder="" />
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <hr />
                            <a href="javascript:;" onclick="Motorista()" class="btn btn-circle btn-default">
                                <i class="fa fa-plus"></i> Incluir Motorista
                            </a>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <input type="hidden" id="vlrmotorista">

                            <?php
                            if (isset($_GET['editar'])):

                                $pdo = Conexao::getInstance();
                                $crud = Crud::getInstance($pdo, 'nfe');
                                $sql = "SELECT * from motoristamdfe WHERE nMDFE = " . $_GET['editar'] . "";
                                $arrayParam = '';
                                $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

                                foreach ($dados as $motoristamdfe):
                                    ?>
                                    <div id='lc9<?= $motoristamdfe->motoristamdfeid ?>'>
                                        <div class='col-md-6'>
                                            <label><span> Nome</span> </label>
                                            <input type='text' name='motnome[]' class='form-control'
                                                   value="<?= $motoristamdfe->motnome ?>" readonly="">
                                        </div>
                                        <div class='col-md-5'>
                                            <label><span> CPF</span> </label>
                                            <input type='text' name='motcpf[]' class='form-control'
                                                   value="<?= $motoristamdfe->motcpf ?>" readonly="">
                                        </div>
                                        <div class='col-md-1'> <br />
                                            <a href='javascript::' class='btn btn-danger btn-sm' type='button'
                                               onclick='ExcluirMotorista("9<?= $motoristamdfe->motoristamdfeid ?>")'> <i
                                                    class='fa fa-trash'></i> </a> <br> <br>
                                        </div>
                                        <br />
                                    </div>
                                    <?php
                                endforeach;
                            endif;
                            ?>

                            <div id="motoristadoc">

                            </div>
                        </div>
                    </div>
                </div>

                <div role="tabpanel" class="tab-pane" id="pagamentos">
                    <div class="row">
                        <div class="col-md-3">
                            <label>CPF/CNPJ</label>
                            <input name="infPag_CNPJ" id="infPag_CNPJ" type="text"  class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-5">
                            <label>Nome Resposável Pagamento</label>
                            <input name="infPag_xNome" id="infPag_xNome" type="text"  class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-2">
                            <label>Valor do Contrato</label>
                            <input type="text" name="infPag_vContrato" class="form-control" onkeypress="mascara(this, mvalor);" value="0.00">
                        </div>

                        <div class="col-md-2">
                            <label>Forma de Pagamento</label>
                            <select name="infPag_indPag" class="form-control">
                                <option value="0">À vista</option>
                                <option value="1" selected>A prazo</option>
                                <option value="2">Outros</option>
                            </select>
                        </div>                                              

                    </div>


                    <div class="row">
                        <div class="col-md-5">
                            <label>Comp. Pagamento</label>
                            <select name="Comp_tpComp" class="form-control">
                                <option>Selecione...</option>
                                <option value="01">01 - Valor do Frete</option>
                                <option value="02">02 - Pedágio</option>
                                <option value="03">03 - Despesas</option>
                                <option value="99">99 - Outros</option>
                            </select>
                        </div>

                        <div class="col-md-2">
                            <label>Valor Comp.</label>
                            <input type="text" name="Comp_vComp" class="form-control" onkeypress="mascara(this, mvalor);" value="0.00">
                        </div>

                        <!-- Descrição Componente -->
                        <div class="col-md-5">
                            <label>Descrição Comp.</label>
                            <input type="text" name="Comp_xComp" class="form-control" placeholder="">
                        </div>
                    </div>

                    <div class="row">
                        <!-- Data Vencimento -->
                        <div class="col-md-3">
                            <label>Data de Vencimento</label>
                            <input type="text" name="infPrazo_dVenc" class="form-control" maxlength="10"
                                   onkeypress="mascara(this, mdata);"  value="<?= date("d/m/Y") ?>">
                        </div>

                        <!-- Valor Parcela -->
                        <div class="col-md-3">
                            <label>Valor da Parcela</label>
                            <input type="text" name="infPrazo_vParcela" class="form-control" onkeypress="mascara(this, mvalor);" value="0.00">
                        </div>                       

                        <!-- Código do Banco -->
                        <div class="col-md-3">
                            <label>Código do Banco </label>
                            <input type="text" name="infBanc_codBanco" class="form-control" maxlength="4"
                                   placeholder="Ex: 341">
                        </div>

                        <!-- Código da Agência -->
                        <div class="col-md-3">
                            <label>Código da Agência </label>
                            <input type="text" name="infBanc_codAgencia" class="form-control" maxlength="10"
                                   placeholder="Ex: 1234">
                        </div>

                        <!-- CNPJ da Instituição (CNPJIPEF) -->
                        <div class="col-md-4">
                            <label>CNPJ da Instituição de Pagamento (CNPJIPEF) </label>
                            <input type="text" name="infBanc_CNPJIPEF" class="form-control" maxlength="14"
                                   onkeypress="mascara(this, mcnpj);" placeholder="Somente números">
                        </div>

                        <!-- Tipo de Pagamento -->
                        <div class="col-md-2">
                            <label>Forma de Pagamento</label>
                            <select name="infPag_tpPag" class="form-control">
                                <option value="">Selecione...</option>
                                <option value="01">01 - Dinheiro</option>
                                <option value="02">02 - Cheque</option>
                                <option value="03">03 - Cartão de Crédito</option>
                                <option value="04">04 - Cartão de Débito</option>
                                <option value="05">05 - Crédito Loja</option>
                                <option value="10">10 - Vale Alimentação</option>
                                <option value="11">11 - Vale Refeição</option>
                                <option value="12">12 - Vale Presente</option>
                                <option value="13">13 - Vale Combustível</option>
                                <option value="15">15 - PIX</option>
                                <option value="90">90 - Sem Pagamento</option>
                                <option value="99">99 - Outros</option>
                            </select>
                        </div>
                    </div>


                </div>


                <div role="tabpanel" class="tab-pane" id="totalizadores">
                    <div class="row">
                        <div class="col-md-12">
                            <label> Valor Total Merc./Carga <span class="text-danger">*</span> </label>
                            <input type="text" name="vCarga" value="0" id="vCarga" onkeypress="mascara(this, mvalor);"
                                   class="form-control">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <label> Un. Medida <span class="text-danger">*</span> </label>
                            <select name="cUnid" class="form-control">
                                <option value="01">KG</option>
                                <option value="02">TON</option>
                            </select>
                        </div>

                        <div class="col-md-8">
                            <label> Peso Bruto Merc./Carga <span class="text-danger">*</span> </label>
                            <input type="text" name="qCarga" value="0" id="qCarga" onkeypress="mascara(this, mvalor);"
                                   class="form-control">
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="row">
        <div class="col-md-12 text-right">
            <button type="submit" class="btn btn-success" id="submitButtonNFe"> <i class="fa fa-save"></i> Salvar
            </button>
        </div>
    </div>

</form>

<script>
    $(document).ready(function () {
        // bind form using ajaxForm 
        $('#mdfeform').ajaxForm({
            // dataType identifies the expected content type of the server response 
            dataType: 'json',
            // success identifies the function to invoke when the server response 
            // has been received 
            success: processJson
        });
    });
    function processJson(data) {
        if (data.retorno == true) {
            Carrega('_mdfe/_grid', 'mdfe_grid.php', 'MDFe');
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html(data.mensagem);
            setTimeout(function () {
                $("#alertsucesso").css("display", "none");
            }, 3000);
        } else {
            document.getElementById("alertsucesso").style.display = "none";
            document.getElementById("alerterro").style.display = "block";
            $("#erro").html(data.mensagem);
            toastr.warning(data.mensagem);
            setTimeout(function () {
                $("#alerterro").css("display", "none");
            }, 10000);
        }
    }

</script>