<?php
require_once("../../../functions.php");
require_once("../_modal/_modal.php");
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/nivel_acesso.php";
require_once "../../../_backend/_class/Emitente_class.php";
?>
<style>
    label {
        font-size: 12px;
    }

    .fileUpload {
        position: relative;
        overflow: hidden;
        margin: 0px;
    }

    .fileUpload input.upload {
        position: absolute;
        top: 0;
        right: 0;
        margin: 0;
        padding: 0;
        font-size: 20px;
        cursor: pointer;
        opacity: 0;
        filter: alpha(opacity=0);
    }

    .dt-buttons {
        display: none;
    }
</style>
<script>
    $('#bulkDelete').click(function() {
        var c = $("#bulkDelete");
        if (c.is(":checked")) {
            $('.DeleteRow').prop('checked', true);
        } else {
            $('.DeleteRow').prop('checked', false);
        }

    });
    $('#excel').on('click', function() {
        $('.buttons-Excel').click()
    });
    $('#pdf').on('click', function() {
        $('.buttons-Pdf').click()
    });
    $('#copy').on('click', function() {
        $('.buttons-Copy').click()
    });
    $('#print').on('click', function() {
        $('.buttons-Print').click()
    });
</script>
<?php
require_once('../../../functions.php');

if (!isset($_GET['busca'])) :
?>

    <button class="btn btn-primary" onclick="Carrega('_form', 'produtos_form.php', 'Novo Produto')" title="Inserir Produto"> <i class="fa fa-plus"></i> Novo </button>
    <button class="btn btn-primary" id="editar" title="Editar Produto"> <i class="fa fa-edit"></i> Editar</button>
    <a href="etiqueta.php" class="btn btn-primary" title="Gerar Etiquetas"> <i class="fa fa-barcode"></i> Gerar Etiqueta</a>
    <button class="btn btn-primary" id="info" title="Informações Produto"> <i class="fa fa-info"></i> Informações</button>
    <button class="btn btn-primary" id="precos" title="Tabela de preços"> <i class="fa fa-money"></i> Tabela de Preços</button>
    <button class="btn btn-danger" id="delete" title="Deletar Produto"> <i class="fa fa-trash"></i> Excluir</button>

    <div class="btn-group">
        <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            Mais Ações<span class="caret"></span>
        </button>
        <ul class="dropdown-menu">
            <li><a href="javascript::" id="grupos"><b><i class="fa fa-star-o"> </i> Adicionar Grupos</b></a></li>
            <li role="separator" class="divider"></li>

            <li><a href="javascript::" id="fornecedorgeral"><b><i class="fa fa-star-o"> </i> Adicionar Fornecedor</b></a></li>
            <li role="separator" class="divider"></li>

            <li><a href="javascript::" id="categoriageral"><b><i class="fa fa-star-o"> </i> Adicionar Categoria</b></a></li>
            <li role="separator" class="divider"></li>

            <li><a href="javascript::" onclick="Carrega('_view', 'alteracao_preco_lista.php', 'Alteração de preço')"><b><i class="fa fa-money"> </i> Alteração de preço</b></a></li>
            <li role="separator" class="divider"></li>

            <li><a href="javascript::" onclick="Carrega('_view', 'alteracao_tributacao_lista.php', 'Alteração de tributação')"><b><i class="fa fa-money"> </i> Alteração de tributação</b></a></li>
            <li role="separator" class="divider"></li>

            <li><a href="javascript::" onclick="Carrega('_view', 'gera_preco_lista.php', 'Impressão de preços')"><b><i class="fa fa-money"> </i> Impressão preços</b></a></li>
            <li role="separator" class="divider"></li>

            <li><a href="javascript::" id="ordenargrade"><b><i class="fa fa-list-alt"> </i> Ordenar Grade</b></a></li>
            <li role="separator" class="divider"></li>

            <li><a href="carga_balanca.php" target="_blank"><b><i class="fa fa-list-alt"> </i> Carga Balança</b></a></li>
            <li role="separator" class="divider"></li>

            <li><a href="carga_balanca_2.php" target="_blank"><b><i class="fa fa-list-alt"> </i> Carga Balança 2</b></a></li>
            <li role="separator" class="divider"></li>


            <li><a href="javascript::" id="excel"><b><i class="fa fa-file-excel-o"> </i> Exportar para excel</b></a></li>
            <li role="separator" class="divider"></li>

            <li><a href="javascript::" id="pdf"><b><i class="fa fa-file-pdf-o"> </i> Exportar para pdf</b></a></li>
            <li role="separator" class="divider"></li>

            <li><a href="javascript::" id="copy"><b><i class="fa fa-copy"> </i> Copiar</b></a></li>
            <li role="separator" class="divider"></li>

            <li><a href="javascript::" id="print"><b><i class="fa fa-print"> </i> Imprimir</b></a></li>
            <li role="separator" class="divider"></li>


        </ul>
    </div>

    <?php
    if ($nivelacesso->produtoecommerce == 'S') :
        if ($emitente->plataforma == 'lojaintegrada') :
    ?>
            <div class="btn-group">
                <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    E-Commerce<span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    <li><a href="javascript::" id="sincronizarecommercelt"><b><i class="fa fa-refresh"> </i> Sincronizar</b></a></li>
                    <li role="separator" class="divider"></li>

                    <li><a href="javascript::" onclick="Carrega('_form', 'importa_lojaintegrada_form.php', 'Tabela Loja Integrada')"><b><i class="fa fa-arrow-up"> </i> Importar Excell</b></a></li>
                    <li role="separator" class="divider"></li>

                    <li><a href="javascript::" id="estoqueecoomercelt"><b><i class="fa fa-refresh"> </i> Atualizar Estoque</b></a></li>
                    <li role="separator" class="divider"></li>

                </ul>
            </div>
        <?php
        elseif ($emitente->plataforma == 'shoppub'):
        ?>
            <div class="btn-group">
                <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    E-Commerce<span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    <li><a href="javascript::" id="sincronizarecommercesp"><b><i class="fa fa-refresh"> </i> Sincronizar</b></a></li>
                    <li role="separator" class="divider"></li>

                    <li><a href="javascript::" id="sincronizarfotoecommercesp"><b><i class="fa fa-refresh"> </i> Atualizar Fotos Grade</b></a></li>
                    <li role="separator" class="divider"></li>

                    <li><a href="javascript::" id="estoqueecoomercesp"><b><i class="fa fa-refresh"> </i> Atualizar Estoque</b></a></li>
                    <li role="separator" class="divider"></li>

                </ul>
            </div>

        <?php
        else :
        ?>
            <div class="btn-group">
                <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    E-Commerce<span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    <li><a href="javascript::" id="sincronizarecommerce"><b><i class="fa fa-refresh"> </i> Sincronizar Novo Produto</b></a></li>
                    <li role="separator" class="divider"></li>

                    <li><a href="javascript::" id="sincronizarecommercevar"><b><i class="fa fa-refresh"> </i> Sincronizar Novas Variações</b></a></li>
                    <li role="separator" class="divider"></li>

                    <li><a href="javascript::" id="sincronizarfotoecommerce"><b><i class="fa fa-refresh"> </i> Atualizar Fotos Grade</b></a></li>
                    <li role="separator" class="divider"></li>

                    <li><a href="javascript::" id="estoqueecoomerce"><b><i class="fa fa-refresh"> </i> Atualizar Estoque</b></a></li>
                    <li role="separator" class="divider"></li>

                    <li><a href="javascript::" id="sku"><b><i class="fa fa-refresh"> </i> Atualizar Código por SKU</b></a></li>
                    <li role="separator" class="divider"></li>
                </ul>
            </div>
        <?php
        endif;
        ?>


    <?php
    endif;
    ?>
    <hr />
<?php
endif;
?>
<div class="row">
    <div class="col-md-12" style='background-color: #fff;'>
        <div class="table-responsive">
            <table id="employee-grid-produtos" style="width: 100%" cellpadding="0" cellspacing="0" border="0" class="table table-bordered table-hover table-condensed table-striped width-full">
                <thead>

                    <tr>
                        <th><input type="checkbox" id="bulkDelete" /></th>
                        <th><input type="text" id="1" style="width: 100%" class="form-control employee-search-produtos-input"></th>
                        <th><input type="text" id="2" style="width: 100%" class="form-control employee-search-produtos-input"></th>
                        <th><input type="text" id="3" style="width: 100%" class="form-control employee-search-produtos-input"></th>
                        <th><input type="text" id="4" style="width: 100%" class="form-control employee-search-produtos-input"></th>
                        <th><input type="text" id="5" style="width: 100%" class="form-control employee-search-produtos-input"></th>
                        <th></th>
                        <th><input type="text" id="7" style="width: 100%" class="form-control employee-search-produtos-input"></th>
                        <!--<th><input type="text" id="4" style="width: 100%" class="form-control employee-search-produtos-input"></th>-->
                        <!--<th><input type="text" id="4" style="width: 100%" class="form-control employee-search-produtos-input"></th>-->
                    </tr>

                    <tr class="alert alert-default">

                        <th width="1%"></th>
                        <th width="15%">CÓDIGO</th>
                        <th width="10%">REF.</th>
                        <th>DESCRIÇÃO</th>
                        <th width="10%">CUSTO</th>
                        <th width="10%">VENDA</th>
                        <th width="5%">ESTOQUE</th>
                        <th>FORNECEDOR</th>
                    </tr>

                </thead>
            </table>
            <div class="row" style="margin-top: -38px;">
                <div class="col-md-2 col-md-offset-5">
                    <div class="input-group">
                        <input type="number" id="gotoPageInput" class="form-control" placeholder="Ir para página" min="1">
                        <span class="input-group-btn">
                            <button class="btn btn-primary" type="button" id="gotoPageBtn" style="width: 70px;">
                                <i class="fa fa-arrow-right"></i> Ir
                            </button>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript" language="javascript">

    
    
    $(document).ready(function() {

        var dataTable = $('#employee-grid-produtos').DataTable({
            processing: true,
            "language": {
                "processing": "Aguarde...",
                "info": "_PAGE_ DE _PAGES_",
                "lengthMenu": "_MENU_",
                "infoFiltered": "(Filtrando _MAX_)",
                "emptyTable": "<b>Nenhum Registro Encontrado</b>",
                "paginate": {
                    "previous": "Anterior",
                    "next": "Próximo"
                }

            },
            "columnDefs": [{
                    "targets": [0],
                    //                    "visible": false,
                    "searchable": false,
                    "orderable": false
                },
                <?php
                if ($nivelacesso->produtopc == 'N') :
                ?> {
                        "targets": [4],
                        "visible": false,
                        "searchable": false,
                        "orderable": false
                    }


                <?php
                endif;
                ?>
            ],
            dom: 'Bflrtip',
            buttons: [
                'copy', 'csv',
                {
                    extend: 'excel',
                    title: '<?= $_SESSION['EmpresaNome'] ?> \n LISTAGEM DE PRODUTOS \n <?= date("d/h/Y H:i") ?>',
                    exportOptions: { // quali colonne vengono mandate in stampa (indice posizionale)
                        columns: [1, 2, 3, 4, 5, 6]
                    }
                },
                {
                    extend: 'pdfHtml5',
                    title: '<?= $_SESSION['EmpresaNome'] ?> \n LISTAGEM DE PRODUTOS \n <?= date("d/h/Y H:i") ?>',
                    download: 'open',
                    exportOptions: { // quali colonne vengono mandate in stampa (indice posizionale)
                        columns: [1, 2, 3, 4, 5, 6]
                    },
                    customize: function(doc) {
                        doc.styles.tableHeader.alignment = 'left'; //giustifica a sinistra titoli colonne
                        doc.content[1].table.widths = [50, 60, 180, 90, 90, 90];
                        doc.pageMargins = [8, 8, 8, 8];
                        doc.defaultStyle.fontSize = 8;
                        doc.styles.tableBodyOdd.margin =
                            doc.styles.tableBodyEven.margin = [5, 5, 5, 5]; //<-- set fontsize to 16 instead of 10                         
                    }
                },
                'print'
            ],
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            serverSide: true,
            ajax: "_backend/_controller/_select/_grid/produtos_select_grid.php", // json datasource

        });

        // Also allow pressing Enter key in the input field to trigger the go to page action
        $('#gotoPageInput').on('keypress', function(e) {
            if (e.which === 13) { // Enter key
                $('#gotoPageBtn').click();
                e.preventDefault();
            }
        });

        // Ir para uma página específica
        $('#gotoPageBtn').on('click', function() {
            var pageNum = parseInt($('#gotoPageInput').val());
            if (!isNaN(pageNum) && pageNum > 0) {
                var totalPages = dataTable.page.info().pages;

                if (pageNum <= totalPages) {
                    // Com "page" no método draw mantém os filtros ao ir para a página
                    dataTable.page(pageNum - 1).draw('page');
                    $('#gotoPageInput').val('');
                } else {
                    toastr.error('Página ' + pageNum + ' não existe. Total de páginas: ' + totalPages);
                }
            } else {
                toastr.warning('Por favor, insira um número de página válido.');
            }
        });

        $("#employee-grid-produtos_filter").css("display", "none"); // hiding global search box

        $('.employee-search-produtos-input').on('keyup click', function(event) {
            var i = $(this).attr('id'); // getting column index
            var v = $(this).val(); // getting search input value
            if (event.keyCode !== 13)
                return false;
            dataTable.columns(i).search(v).draw();
        });
        $(document).ready(function() {
            $('#selecionaprodutos').click(function() {
                var val = new Array();
                $('.DeleteRow:checked').each(function() {
                    val.push($(this).val());
                });
                if (val == '') {
                    toastr.warning('Nenhum Registo Selecionado!');
                } else {
                    var cod = $(val).get(0);
                    //                    alert(cod);
                    Produto(cod);
                }

            });
        });
        //        
        $('#delete').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val.length > 1) {
                toastr.warning('Selecione apenas um registro!');
            } else {
                if (val == '') {
                    toastr.warning('Nenhum Registo Selecionado!');
                } else {

                    var decisao = confirm("Deseja Realmente Excluir?");
                    if (decisao) {
                        Deletar($(val).get(0));
                    }
                }
            }

        });
        $('#sincronizarecommerce').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                bootbox.confirm({
                    message: "Deseja sincronizar produto selecionado com o E-commerce?",
                    buttons: {
                        confirm: {
                            label: 'Sim',
                            className: 'btn-success'
                        },
                        cancel: {
                            label: 'Não',
                            className: 'btn-danger'
                        }
                    },
                    callback: function(result) {
                        if (result) {
                            Sincronizar($(val).get(0));
                        }
                    }
                });
            }

        });
        $('#sincronizarecommercevar').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                bootbox.confirm({
                    message: "Deseja sincronizar as novas variações do produto selecionado com o E-commerce?",
                    buttons: {
                        confirm: {
                            label: 'Sim',
                            className: 'btn-success'
                        },
                        cancel: {
                            label: 'Não',
                            className: 'btn-danger'
                        }
                    },
                    callback: function(result) {
                        if (result) {
                            Sincronizarvar($(val).get(0));
                        }
                    }
                });
            }

        });
        $('#sincronizarecommercesp').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                bootbox.confirm({
                    message: "Deseja sincronizar produto selecionado com o E-commerce?",
                    buttons: {
                        confirm: {
                            label: 'Sim',
                            className: 'btn-success'
                        },
                        cancel: {
                            label: 'Não',
                            className: 'btn-danger'
                        }
                    },
                    callback: function(result) {
                        if (result) {
                            Sincronizarsp($(val).get(0));
                        }
                    }
                });
            }

        });
        $('#sincronizarecommercelt').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                bootbox.confirm({
                    message: "Deseja sincronizar produto selecionado com o E-commerce?",
                    buttons: {
                        confirm: {
                            label: 'Sim',
                            className: 'btn-success'
                        },
                        cancel: {
                            label: 'Não',
                            className: 'btn-danger'
                        }
                    },
                    callback: function(result) {
                        if (result) {
                            Sincronizarlt($(val).get(0));
                        }
                    }
                });
            }

        });
        $('#sincronizarfotoecommerce').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                bootbox.confirm({
                    message: "Deseja sincronizar Fotos variações do produto selecionado com o E-commerce?",
                    buttons: {
                        confirm: {
                            label: 'Sim',
                            className: 'btn-success'
                        },
                        cancel: {
                            label: 'Não',
                            className: 'btn-danger'
                        }
                    },
                    callback: function(result) {
                        if (result) {
                            SincronizarFoto($(val).get(0));
                        }
                    }
                });
            }

        });
        $('#sincronizarfotoecommercesp').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                bootbox.confirm({
                    message: "Deseja sincronizar Fotos variações do produto selecionado com o E-commerce?",
                    buttons: {
                        confirm: {
                            label: 'Sim',
                            className: 'btn-success'
                        },
                        cancel: {
                            label: 'Não',
                            className: 'btn-danger'
                        }
                    },
                    callback: function(result) {
                        if (result) {
                            SincronizarFotosp($(val).get(0));
                        }
                    }
                });
            }

        });
        $('#estoqueecoomerce').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                SincronizarEstoque($(val).get(0));
            }

        });
        $('#estoqueecoomercelt').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                SincronizarEstoquelt($(val).get(0));
            }

        });
        $('#sku').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {
                    BuscaSKU($(val).get(0));
                }
            }

        });

        function Deletar(valor) {

            $.ajax({
                type: "GET",
                url: "_backend/_controller/_delete/produtos_delete.php",
                data: {
                    produtos: valor
                },
                dataType: "json",
                success: function(data) {
                    if (data.retorno == true) {
                        Carrega('_grid', 'produtos_grid.php', 'Produto');
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html(data.mensagem);
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 4000);
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html(data.mensagem);
                        setTimeout(function() {
                            $("#alerterro").css("display", "none");
                        }, 6000);
                    }
                }
            });
        }


        function SincronizarFoto(valor) {
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html('<i class="fa fa-spinner fa-pulse fa-fw"></i> Sincronizando Fotos...');
            $.ajax({
                type: "GET",
                url: "_backend/NuvemShop/AtualizaFotoGrade.php",
                data: {
                    produto: valor
                },
                dataType: "json",
                success: function(data) {
                    if (data.retorno == true) {
                        AtualizandoFoto(valor);
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html('Houve um erro ao sincronizar o produto, tente novamente!');
                        setTimeout(function() {
                            $("#alerterro").css("display", "none");
                        }, 3000);
                    }
                }
            });
        }

        function SincronizarFotosp(valor) {
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html('<i class="fa fa-spinner fa-pulse fa-fw"></i> Sincronizando Fotos...');
            $.ajax({
                type: "GET",
                url: "_backend/shoppub/foto.php",
                data: {
                    codigo: valor
                },
                dataType: "json",
                success: function(data) {
                    if (data.retorno == true) {
                        Carrega('_grid', 'produtos_grid.php', 'Produto');
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html('Produto Sincronizado!');
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 3000);
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html('Houve um erro ao sincronizar o produto, tente novamente!');
                        setTimeout(function() {
                            $("#alerterro").css("display", "none");
                        }, 3000);
                    }
                }
            });
        }


        function AtualizandoFoto(valor) {
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html('<i class="fa fa-spinner fa-pulse fa-fw"></i> Atualizando Fotos...');
            $.ajax({
                type: "GET",
                url: "_backend/NuvemShop/InsereFotoID.php",
                data: {
                    produto: valor
                },
                dataType: "json",
                success: function(data) {
                    if (data.retorno == true) {
                        Carrega('_grid', 'produtos_grid.php', 'Produto');
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html('Produto Sincronizado!');
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 3000);
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html('Houve um erro ao sincronizar o produto, tente novamente!');
                        setTimeout(function() {
                            $("#alerterro").css("display", "none");
                        }, 3000);
                    }
                }
            });
        }


        function Sincronizar(valor) {
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html('<i class="fa fa-spinner fa-pulse fa-fw"></i> Aguarde...');
            $.ajax({
                type: "GET",
                url: "_backend/NuvemShop/AddProdutos_grade.php",
                data: {
                    codigo: valor
                },
                dataType: "json",
                success: function(data) {
                    if (data.retorno == true) {
                        Carrega('_grid', 'produtos_grid.php', 'Produto');
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html('Produto Sincronizado!');
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 3000);
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html('Houve um erro ao sincronizar o produto, tente novamente!');
                        setTimeout(function() {
                            $("#alerterro").css("display", "none");
                        }, 3000);
                    }
                }
            });
        }

        function Sincronizarvar(valor) {
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html('<i class="fa fa-spinner fa-pulse fa-fw"></i> Aguarde...');
            $.ajax({
                type: "GET",
                url: "_integracoes/NuvemShop/add_variacao.php",
                data: {
                    codigo: valor
                },
                dataType: "json",
                success: function(data) {
                    if (data.retorno == true) {
                        Carrega('_grid', 'produtos_grid.php', 'Produto');
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html('Produto Sincronizado!');
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 3000);
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html(data.erro);
                        setTimeout(function() {
                            $("#alerterro").css("display", "none");
                        }, 7000);
                    }
                }
            });
        }


        function Sincronizarlt(valor) {
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html('<i class="fa fa-spinner fa-pulse fa-fw"></i> Aguarde...');
            $.ajax({
                type: "GET",
                url: "_backend/LojaIntegrada/AddProduto.php",
                data: {
                    codigo: valor
                },
                dataType: "json",
                success: function(data) {
                    if (data.retorno == true) {
                        Carrega('_grid', 'produtos_grid.php', 'Produto');
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html('Produto Sincronizado!');
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 3000);
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html('Houve um erro ao sincronizar o produto, tente novamente!');
                        setTimeout(function() {
                            $("#alerterro").css("display", "none");
                        }, 3000);
                    }
                }
            });
        }

        function Sincronizarsp(valor) {
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html('<i class="fa fa-spinner fa-pulse fa-fw"></i> Aguarde...');
            $.ajax({
                type: "GET",
                url: "_backend/shoppub/produto.php",
                data: {
                    codigo: valor
                },
                dataType: "json",
                success: function(data) {
                    if (data.retorno == true) {
                        Carrega('_grid', 'produtos_grid.php', 'Produto');
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html('Produto Sincronizado!');
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 3000);
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html('Houve um erro ao sincronizar o produto, tente novamente!');
                        setTimeout(function() {
                            $("#alerterro").css("display", "none");
                        }, 3000);
                    }
                }
            });
        }



        function SincronizarEstoque(valor) {
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html('<i class="fa fa-spinner fa-pulse fa-fw"></i> Aguarde...');
            $.ajax({
                type: "POST",
                url: "_backend/NuvemShop/AtualizaEstoque.php",
                data: {
                    produto: valor
                },
                dataType: "json",
                success: function(data) {
                    if (data.retorno == true) {
                        Carrega('_grid', 'produtos_grid.php', 'Produto');
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html('Produto Sincronizado!');
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 3000);
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html('Houve um erro ao sincronizar o produto, tente novamente!');
                        setTimeout(function() {
                            $("#alerterro").css("display", "none");
                        }, 3000);
                    }
                }
            });
        }

        function SincronizarEstoquelt(valor) {
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html('<i class="fa fa-spinner fa-pulse fa-fw"></i> Aguarde...');
            $.ajax({
                type: "POST",
                url: "_backend/LojaIntegrada/AtualizaEstoque.php",
                data: {
                    produto: valor
                },
                dataType: "json",
                success: function(data) {
                    if (data.retorno == true) {
                        Carrega('_grid', 'produtos_grid.php', 'Produto');
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html('Produto Sincronizado!');
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 3000);
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html('Houve um erro ao sincronizar o produto, tente novamente!');
                        setTimeout(function() {
                            $("#alerterro").css("display", "none");
                        }, 3000);
                    }
                }
            });
        }

        function BuscaSKU(valor) {
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html('<i class="fa fa-spinner fa-pulse fa-fw"></i> Aguarde...');
            $.ajax({
                type: "POST",
                url: "_backend/NuvemShop/BuscaProdutoSKU.php",
                data: {
                    produto: valor
                },
                dataType: "json",
                success: function(data) {
                    if (data.retorno == true) {
                        Carrega('_grid', 'produtos_grid.php', 'Produto');
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html('Produto Sincronizado, é necessario realizar o sincronismo do estoque!');
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 3000);
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html('Houve um erro ao sincronizar o produto, tente novamente!');
                        setTimeout(function() {
                            $("#alerterro").css("display", "none");
                        }, 3000);
                    }
                }
            });
        }

        $('#employee-grid-produtos tbody').on('dblclick', 'tr', function() {
            var data = dataTable.row(this).data();
            <?php
            if (isset($_GET['busca'])) :
            ?>
                Produto(data[1]);
            <?php
            else:
            ?>
                Carrega('_form', 'produtos_form.php?editar=' + data[1] + '', 'Editar Produto');
            <?php
            endif;
            ?>
        });
        
        // Mudar para a página escolhida quando apertar Enter
        const input = document.getElementById("gotoPageInput");
        const button = document.getElementById("gotoPageBtn");
        if (input && button) { // Verifica se os elementos existem
            input.addEventListener("keyup", function(event) {
                event.preventDefault(); // Evita comportamento padrão do formulário
                if (event.keyCode === 13) {
                    button.click();
                }
            });
        } else {
            console.error("Elemento não encontrado: Verifique os IDs no HTML.");
        }
    });
    
    $('#editar').click(function() {
        var val = new Array();
        $('.DeleteRow:checked').each(function() {
            val.push($(this).val());
        });
        if (val.length > 1) {
            toastr.warning('Selecione apenas um registro!');
        } else {
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                Carrega('_form', 'produtos_form.php?editar=' + $(val).get(0) + '', 'Editar Produto')
            }
        }

    });

    $('#ordenargrade').click(function() {
        var val = new Array();
        $('.DeleteRow:checked').each(function() {
            val.push($(this).val());
        });
        if (val.length > 1) {
            toastr.warning('Selecione apenas um registro!');
        } else {
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                // alert($(val).get(0));
                OrdenarGrade($(val).get(0));
            }
        }

    });

    $('#info').click(function() {
        var val = new Array();
        $('.DeleteRow:checked').each(function() {
            val.push($(this).val());
        });
        if (val == '') {
            toastr.warning('Nenhum Registo Selecionado!');
        } else {
            $("#busca").modal('show');
            $("#buscatitle").html('PRODUTO ' + $(val).get(0) + '');
            $("#carregandobusca").css("display", "block");
            $("#recebegrid").load('_backend/_view/_view/produtos_grades_view.php?produto=' + $(val).get(0), function() {
                $("#carregandobusca").css("display", "none");
            });
            $("#carregandobusca").css("display", "none");
        }

    });
    $('#precos').click(function() {
        var val = new Array();
        $('.DeleteRow:checked').each(function() {
            val.push($(this).val());
        });
        if (val == '') {
            toastr.warning('Nenhum Registo Selecionado!');
        } else {
            $("#busca").modal('show');
            $("#buscatitle").html('PRODUTO ' + $(val).get(0) + '');
            $("#carregandobusca").css("display", "block");
            $("#recebegrid").load('_backend/_view/_view/tabelapreco_view.php?produto=' + $(val).get(0), function() {
                $("#carregandobusca").css("display", "none");
            });
            $("#carregandobusca").css("display", "none");
        }

    });

    $('#grupos').click(function() {
        var val = new Array();
        $('.DeleteRow:checked').each(function() {
            val.push($(this).val());
        });
        if (val == '') {
            toastr.warning('Nenhum Registo Selecionado!');
        } else {
            $("#addgrupo").modal('show');
            $("#grupoprodutos").val(val);
        }


    });


    $('#fornecedorgeral').click(function() {
        var val = new Array();
        $('.DeleteRow:checked').each(function() {
            val.push($(this).val());
        });
        if (val == '') {
            toastr.warning('Nenhum Registo Selecionado!');
        } else {
            $("#addfornecedor").modal('show');
            $("#forncedorgrupo").val(val);
        }
    });



    $('#categoriageral').click(function() {
        var val = new Array();
        $('.DeleteRow:checked').each(function() {
            val.push($(this).val());
        });
        if (val == '') {
            toastr.warning('Nenhum Registo Selecionado!');
        } else {
            $("#addcategoria").modal('show');
            $("#categoriagrupo").val(val);
        }
    });


    $('#precosprodutos').click(function() {
        var val = new Array();
        $('.DeleteRow:checked').each(function() {
            val.push($(this).val());
        });
        if (val == '') {
            toastr.warning('Nenhum Registo Selecionado!');
        } else {
            $("#addprecos").modal('show');
            $("#precosprod").val(val);
        }

    });

    function Buscagrade(empresa, produto, var1, var2) {
        $("#busca").modal('show');
        $("#buscatitle").html('PRODUTO ' + produto + '');
        $("#carregandobusca").css("display", "block");
        $('#recebegrid').animate({
            height: "slow"
        }, 500, function() {
            $("#recebegrid").load('_backend/_view/_view/produtos_grades_view.php?var1=' + var1 + '&var2=' + var2 + '&empresa=' + empresa + '&produto=' + produto, function() {
                $('#recebegrid').fadeIn('slow');
                $("#carregandobusca").css("display", "none");
            });
        });
        $("#carregandobusca").css("display", "none");
    }


    function BuscagradeCor(empresa, produto, var1, var2) {
        $("#busca").modal('show');
        $("#buscatitle").html('PRODUTO ' + produto + '');
        $("#carregandobusca").css("display", "block");
        //    $('#recebegrid').fadeOut('slow', function () {
        $("#recebegrid").load('_backend/_view/_view/produtos_grades_view.php?var1=' + var1 + '&var2=' + var2 + '&empresa=' + empresa + '&produto=' + produto, function() {
            $('#recebegrid').fadeIn('slow');
            $("#carregandobusca").css("display", "none");
        });
        //    });
        $("#carregandobusca").css("display", "none");
    }

    function Grupos(valor) {
        //        alert(valor);
        $("#grupo").val(valor);
        if (valor == '') {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/grupo_select_ajax.php",
            data: {
                grupos: valor
            },
            dataType: "json",
            // função para de sucesso
            success: function(data) {
                //  alert();
                if (data != '') {
                    //                    alert(data[0].xNome);
                    $("#grupo").val(data[0].sequencia);
                    $("#grupodescricao").val(data[0].descricao);
                } else {
                    toastr.warning('Grupo Não Encontrado!');
                    $("#grupo").val('');
                    $("#grupodescricao").val('');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }



    function AddGrupo() {

        if ($("#grupo").val() == '') {
            return false;
        }
        var idgrupo = $("#idgrupo").val();
        if (idgrupo == '') {
            var id = '1';
        } else {
            var id = Number(idgrupo) + 1;
        }
        var sequencia = $("#grupo").val();
        var desc = $("#grupodescricao").val();
        var opcoes = ' <div id="gp' + id + '" class="row" style="margin-top: 5px;">' +
            '<div class="col-md-3">' +
            '<input name="grupo[]" value="' + sequencia + '" readonly="" maxlength="8"  type="text" class="form-control" placeholder=""> ' +
            '</div>' +
            '<div class="col-md-7">' +
            '<input type="text" value="' + desc + '" readonly="" class="form-control" placeholder="">' +
            '</div>' +
            '<div class="col-md-2">' +
            '<a href="javascript::" onclick="DeleteGrupo(' + id + ')" class="btn btn-danger"> <i class="fa fa-trash"></i></a>' +
            '</div>' +
            '</div>';
        $("#idgrupo").val(id);
        $("#recebegrupo").append(opcoes);
        $("#grupo").val('');
        $("#grupodescricao").val('');
    }

    function DeleteGrupo(valor) {
        $("#gp" + valor + "").remove();
    }

    function Busca(valor) {
        //        alert(valor);
        $("#busca").modal('show');
        $("#buscatitle").html('BUSCA ' + valor.toUpperCase());
        $("#carregandobusca").css("display", "block");
        $("#recebegrid").load('_backend/_view/_grid/' + valor + '_grid.php?busca=S', function() {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }




    function Fornecedor(valor) {
        $.ajax({
            url: "<?= BACKEND ?>/_controller/_select/_ajax/fornecedor_select_ajax.php?fornecedor=" + valor,
            dataType: "json",
            // função para de sucesso
            success: function(data) {
                //  alert();
                if (data[0] != undefined) {
                    $("#fornecedorid").val(data[0].fornecedorid);
                    $("#fornecedornome").val(data[0].xNome);
                } else {
                    toastr.warning('Nenhum Registo Encontrado!');
                    $("#fornecedorid").val('');
                    $("#fornecedornome").val('');
                }
            }
        }); //termina o jquery

        $("#busca").modal('hide');


    }


    function Categoria(valor) {
        //        alert(valor);
        $("#categoria").val(valor);
        if (valor === '') {
            $("#categoria").val('');
            $("#categoriadescricao").val('');
            return false;
        }
        if (valor <= 0) {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/categoria_select_ajax.php",
            data: {
                categorias: valor
            },
            dataType: "json",
            // função para de sucesso
            success: function(data) {
                //  alert();
                if (data != '') {
                    //                    alert(data[0].xNome);
                    $("#categoria").val(data[0].sigla);
                    $("#categoriadescricao").val(data[0].descricao);
                } else {
                    toastr.warning('Categoria Não Encontrado!');
                    $("#categoria").val('');
                    $("#categoriadescricao").val('');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }

    function OrdenarGrade(valor) {
        $.ajax({
            type: "GET",
            url: "update_ordem.php",
            data: {
                produto: valor
            },
            dataType: "json",
            success: function(data) {

                Carrega('_grid', 'produtos_grid.php', 'Produto');
                document.getElementById("alerterro").style.display = "none";
                document.getElementById("alertsucesso").style.display = "block";
                $("#sucesso").html('Grades atualizadas!');
                setTimeout(function() {
                    $("#alertsucesso").css("display", "none");
                }, 4000);
            },
            error: function(data) {
                Carrega('_grid', 'produtos_grid.php', 'Produto');
                document.getElementById("alerterro").style.display = "none";
                document.getElementById("alertsucesso").style.display = "block";
                $("#sucesso").html('Grades atualizadas!');
                setTimeout(function() {
                    $("#alertsucesso").css("display", "none");
                }, 4000);
            }
        });
    }
</script>


<div class="modal fade bd-example-modal-lg" id="addgrupo" tabindex="-1" role="dialog" aria-labelledby="addgrupo" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Adicionar Grupos</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="adgrupos" method="post" action="<?= BACKEND ?>/_controller/_insert/produtos_grupo_insert.php">

                <div class="modal-body">
                    <input type="hidden" name="produto" id="grupoprodutos">
                    <input type="hidden" id="idgrupo">
                    <div class="row">
                        <div class="col-md-3">
                            <label>Grupo </label>
                            <input name="grupo" id="grupo" onblur="Grupos(this.value)" maxlength="8" onkeypress="mascara(this, mgrupo);" type="text" class="form-control" placeholder="">
                            <i onclick="Busca('grupos')" style="position: absolute; right: 22px; top: 37px; z-index: 999" class="fa fa-search"> </i>
                        </div>

                        <div class="col-md-7">
                            <label>Grupo Descrição </label>
                            <input id="grupodescricao" type="text" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-2">
                            <a href="javascript::" onclick="AddGrupo()" class="btn btn-info" style="margin-top: 27px"> <i class="fa fa-check"></i> Add </a>
                        </div>

                    </div>


                    <div id="recebegrupo">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Adicionar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade bd-example-modal-lg" id="addfornecedor" tabindex="-1" role="dialog" aria-labelledby="addgrupo" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Adicionar Fornecedor</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="adforn" method="post" action="<?= BACKEND ?>/_controller/_insert/produtos_fornecedor_insert.php">

                <div class="modal-body">
                    <input type="hidden" name="produto1" id="forncedorgrupo">
                    <div class="row">
                        <div class="col-md-3">
                            <label>Fornecedor </label>
                            <input name="fornecedor" id="fornecedorid" onblur="Fornecedor(this.value)" maxlength="8" type="text" class="form-control" placeholder="">
                            <i onclick="Busca('fornecedor')" style="position: absolute; right: 22px; top: 37px; z-index: 999" class="fa fa-search"> </i>
                        </div>

                        <div class="col-md-7">
                            <label>Fornecedor Nome </label>
                            <input id="fornecedornome" type="text" class="form-control" placeholder="">
                        </div>
                    </div>


                    <div id="recebegrupo">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade bd-example-modal-lg" id="addcategoria" tabindex="-1" role="dialog" aria-labelledby="addcategoria" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Adicionar Categoria</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="adcat" method="post" action="<?= BACKEND ?>/_controller/_insert/produtos_categoria_insert.php">

                <div class="modal-body">
                    <input type="hidden" name="produto2" id="categoriagrupo">
                    <div class="row">
                        <div class="col-md-3">
                            <label>Categoria </label>
                            <input name="categoria" id="categoria" onblur="Categoria(this.value)" type="text" class="form-control" placeholder="">
                            <i onclick="Busca('categorias')" style="position: absolute; right: 22px; top: 37px; z-index: 9999" class="fa fa-search"> </i>
                        </div>

                        <div class="col-md-9">
                            <label>Categoria Descrição </label>
                            <input id="categoriadescricao" disabled="" type="text" required="" class="form-control" placeholder="">
                        </div>

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>



<div class="modal fade bd-example-modal-lg" id="addprecos" tabindex="-1" role="dialog" aria-labelledby="addprecos" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Adicionar Grupos</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="alteraprecos" method="post" action="<?= BACKEND ?>/_controller/_insert/alteraprecos_produtos_insert.php">

                <div class="modal-body">
                    <input type="hidden" name="produto" id="precosprod">
                    <?php
                    $pdo = Conexao::getInstance();
                    $crud = Crud::getInstance($pdo, 'tabelapreco');
                    $sql = "SELECT * from tabelapreco";
                    $arrayParam = '';
                    $precoproduto = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

                    foreach ($precoproduto as $pp) :
                    ?>
                        <div class="row">
                            <hr />
                            <input type="hidden" name="tp[]" value="<?= $pp->tabelaprecoid ?>" class="form-control" placeholder="">
                            <div class="col-md-8">
                                <input type="text" value="<?= $pp->descricao ?>" readonly="" class="form-control" placeholder="">
                            </div>
                            <div class="col-md-2">
                                <input type="text" value="<?= $pp->porcentagem ?> %" readonly="" class="form-control" placeholder="">
                            </div>
                            <div class="col-md-2">
                                <input type="text" name="tpvalor[]" onkeypress="mascara(this, mvalor);" class="form-control" placeholder="">
                            </div>
                        </div>
                    <?php
                    endforeach;
                    ?>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Adicionar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        // bind form using ajaxForm 
        $('#adgrupos').ajaxForm({
            // dataType identifies the expected content type of the server response 
            dataType: 'json',
            // success identifies the function to invoke when the server response 
            // has been received 
            success: processJson
        });
    });

    function processJson(data) {
        if (data.retorno == true) {
            Carrega('_grid', 'produtos_grid.php', 'Produto');
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html(data.mensagem);
            setTimeout(function() {
                $("#alertsucesso").css("display", "none");
            }, 7000);
        } else {
            document.getElementById("alertsucesso").style.display = "none";
            document.getElementById("alerterro").style.display = "block";
            $("#erro").html(data.mensagem);
            setTimeout(function() {
                $("#alerterro").css("display", "none");
            }, 7000);
        }
    }
</script>

<script>
    $(document).ready(function() {
        // bind form using ajaxForm 
        $('#adforn').ajaxForm({
            // dataType identifies the expected content type of the server response 
            dataType: 'json',
            // success identifies the function to invoke when the server response 
            // has been received 
            success: processJson
        });
    });

    function processJson(data) {
        if (data.retorno == true) {
            Carrega('_grid', 'produtos_grid.php', 'Produto');
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html(data.mensagem);
            setTimeout(function() {
                $("#alertsucesso").css("display", "none");
            }, 7000);
        } else {
            document.getElementById("alertsucesso").style.display = "none";
            document.getElementById("alerterro").style.display = "block";
            $("#erro").html(data.mensagem);
            setTimeout(function() {
                $("#alerterro").css("display", "none");
            }, 7000);
        }
    }

    $(document).ready(function() {
        // bind form using ajaxForm 
        $('#adcat').ajaxForm({
            // dataType identifies the expected content type of the server response 
            dataType: 'json',
            // success identifies the function to invoke when the server response 
            // has been received 
            success: processJsonc
        });
    });

    function processJsonc(data) {
        if (data.retorno == true) {
            Carrega('_grid', 'produtos_grid.php', 'Produto');
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html(data.mensagem);
            setTimeout(function() {
                $("#alertsucesso").css("display", "none");
            }, 7000);
        } else {
            document.getElementById("alertsucesso").style.display = "none";
            document.getElementById("alerterro").style.display = "block";
            $("#erro").html(data.mensagem);
            setTimeout(function() {
                $("#alerterro").css("display", "none");
            }, 7000);
        }
    }
</script>
<script>
    $(document).ready(function() {
        // bind form using ajaxForm 
        $('#alteraprecos').ajaxForm({
            // dataType identifies the expected content type of the server response 
            dataType: 'json',
            // success identifies the function to invoke when the server response 
            // has been received 
            success: processJson
        });
    });

    function processJson(data) {
        if (data.retorno == true) {
            Carrega('_grid', 'produtos_grid.php', 'Produto');
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html(data.mensagem);
            setTimeout(function() {
                $("#alertsucesso").css("display", "none");
            }, 7000);
        } else {
            document.getElementById("alertsucesso").style.display = "none";
            document.getElementById("alerterro").style.display = "block";
            $("#erro").html(data.mensagem);
            setTimeout(function() {
                $("#alerterro").css("display", "none");
            }, 7000);
        }
    }
</script>

<?php
if (isset($_GET['busca'])) :
?>
    <div class="modal-footer">
        <button type="button" class="btn dark btn-outline" data-dismiss="modal">Fechar</button>
        <button type="button" id="selecionaprodutos" class="btn green">Selecionar</button>
    </div>
<?php
endif;
?>