<?php
session_start();
require_once('../../../functions.php');
require_once("../_modal/_modal.php");
require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";
?>

<style>
    label {
        font-size: 12px;
    }

    .fileUpload {
        position: relative;
        overflow: hidden;
        margin: 0px;
    }

    .fileUpload input.upload {
        position: absolute;
        top: 0;
        right: 0;
        margin: 0;
        padding: 0;
        font-size: 20px;
        cursor: pointer;
        opacity: 0;
        filter: alpha(opacity=0);
    }
</style>

<!-- Grid de pedidos pendentes -->
<div class="row">
    <div class="col-md-7" style='background-color: #fff;'>
        <div class="table-responsive">
            <table id="employee-grid-pedidosPendentes" cellpadding="0" cellspacing="0" border="0" class="table table-bordered table-hover table-condensed table-striped width-full">
                <thead>

                    <tr class="alert alert-default">
                        <th></th>
                        <!--<th></th>-->
                        <th style="width: 10%">Nº</th>
                        <th style="width: 40%">Cliente</th>
                        <th style="width: 20%">Valor</th>
                        <th style="width: 20%">Situação</th>
                        <th style="width: 10%">Tipo</th>
                        <th style="width: 10%">Ação</th>
                    </tr>
                    <tr>
                        <th><input type="checkbox" id="bulkDelete" /></th>
                        <!--<th></th>-->
                        <th><input type="text" id="1" style="width: 100%" class="form-control employee-search-pedido_online-input"></th>
                        <th><input type="text" id="2" style="width: 100%" class="form-control employee-search-pedido_online-input"></th>
                        <th><input type="text" id="3" style="width: 100%" class="form-control employee-search-pedido_online-input"></th>
                        <th><input type="hidden" id="4" style="width: 100%" class="form-control employee-search-pedido_online-input"></th>
                        <th>
                            <select id="5" style="width: 100%" class="form-control employee-search-pedido_online-input">
                                <option value="">Todos</option>
                                <option value="E">Entrega</option>
                                <option value="R">Retirada</option>
                            </select>
                        </th>
                        <th><input type="hidden" id="6" style="width: 100%" class="form-control employee-search-pedido_online-input"></th>

                    </tr>
                </thead>
                <tfoot>
                    <tr class="alert alert-default">
                        <td colspan="3"><b>TOTAL</b></td>
                        <td><strong><span class="text-black-50" id="valorpendentes"></span></strong></td>
                        <td colspan="3"></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>


    <!-- Grid de pedidos confirmados -->

    <div class="col-md-5" style='background-color: #fff;'>
        <div class="table-responsive">
            <table id="employee-grid-pedidosConfirmados" cellpadding="0" cellspacing="0" border="0" class="table table-bordered table-hover table-condensed table-striped width-full">
                <thead>

                    <tr class="alert alert-default">
                        <th style="width: 5%;"></th>
                        <!--<th></th>-->
                        <th style="width: 5%">Nº</th>
                        <th style="width: 40%">Cliente</th>
                        <th style="width: 20%">Valor</th>
                        <th style="width: 20%">Situação</th>
                        <th style="width: 10%">Tipo</th>
                        <th style="width: 10%">Venda</th>
                    </tr>
                    <tr>
                        <th><input type="checkbox" id="bulkDelete" /></th>
                        <!--<th></th>-->
                        <th><input type="text" id="1" style="width: 100%" class="form-control employee-search-pedido_onlinec-input"></th>
                        <th><input type="text" id="2" style="width: 100%" class="form-control employee-search-pedido_onlinec-input"></th>
                        <th><input type="text" id="3" style="width: 100%" class="form-control employee-search-pedido_onlinec-input"></th>
                        <th>
                            <select id="4" style="width: 100%" class="form-control employee-search-pedido_onlinec-input">
                                <option value="">Todos</option>
                                <option value="E">Em preparo</option>
                                <option value="S">Rota de entrega</option>
                                <option value="F">Finalizado</option>
                            </select>
                            <input type="hidden" id="4" style="width: 100%" class="form-control employee-search-pedido_onlinec-input">
                        </th>
                        <th>
                            <select id="5" style="width: 100%" class="form-control employee-search-pedido_online-input">
                                <option value="">Todos</option>
                                <option value="E">Entrega</option>
                                <option value="R">Retirada</option>
                            </select>
                        </th>

                        <th><input type="text" id="6" style="width: 100%" class="form-control employee-search-pedido_onlinec-input"></th>

                    </tr>
                </thead>
                <tfoot>
                    <tr class="alert alert-default">
                        <td colspan="4"><b></b></td>
                        <td><strong><span class="text-black-50" id="valorlancdc"></span></strong></td>
                        <td></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>


<!-- Modal Detalhes do Pedido -->
<div class="modal fade" id="modalDetalhesPedido" tabindex="-1" role="dialog" aria-labelledby="modalDetalhesPedidoLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="modalDetalhesPedidoLabel">Detalhes do Pedido</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <h5><strong>Dados do Cliente</strong></h5>
                        <div id="dadosCliente"></div>
                    </div>
                    <div class="col-md-6">
                        <h5><strong>Dados da Entrega</strong></h5>
                        <div id="dadosEntrega"></div>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-md-12">
                        <h5><strong>Itens do Pedido</strong></h5>
                        <div id="itensPedido"></div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {

        var dataTable = $('#employee-grid-pedidosPendentes').DataTable({
            processing: true,
            "language": {
                "processing": "Aguarde...",
                "info": "_PAGE_ DE _PAGES_",
                "lengthMenu": "_MENU_",
                "infoFiltered": "(Filtrando _MAX_)",
                "emptyTable": "<b>Nenhum Registro Encontrado</b>",
                "paginate": {
                    "previous": "Anterior",
                    "next": "Próximo"
                }

            },
            "columnDefs": [{
                    "targets": [0],
                    // "visible": false,
                    "searchable": false,
                    "orderable": false
                },
                {
                    "targets": [1],
                    // "visible": false,
                    "orderable": false
                },
                {
                    "targets": [2],
                    // "visible": false,
                    "orderable": false
                },
                {
                    "targets": [3],
                    // "visible": false,
                    "orderable": false
                },
                {
                    "targets": [4],
                    // "visible": false,
                    "orderable": false
                },
            ],
            drawCallback: function (settings) {
                $("#valorpendentes").html(settings.json.total);
            },
            "lengthMenu": [10, 50, 100, 500],
            serverSide: true,
            ajax: "_backend/_controller/_select/_grid/pedidos_delivery_pendentes_select_grid.php", // json datasource

        });
        $("#employee-grid-pedidosPendentes_filter").css("display", "none"); // hiding global search box

        $('.employee-search-pedido_online-input').on('keyup click', function (event) {
            var i = $(this).attr('id'); // getting column index
            var v = $(this).val(); // getting search input value
            dataTable.columns(i).search(v).draw();
        });

        // Grid de pedidos confirmados
        var dataTable2 = $('#employee-grid-pedidosConfirmados').DataTable({
            processing: true,
            "language": {
                "processing": "Aguarde...",
                "info": "_PAGE_ DE _PAGES_",
                "lengthMenu": "_MENU_",
                "infoFiltered": "(Filtrando _MAX_)",
                "emptyTable": "<b>Nenhum Registro Encontrado</b>",
                "paginate": {
                    "previous": "Anterior",
                    "next": "Próximo"
                }

            },
            "columnDefs": [{
                    "targets": [0],
                    // "visible": false,
                    "searchable": false,
                    "orderable": false
                },
                {
                    "targets": [1],
                    // "visible": false,
                    "orderable": false
                },
                {
                    "targets": [2],
                    // "visible": false,
                    "orderable": false
                },
                {
                    "targets": [3],
                    "visible": false,
                    "orderable": false
                },
                {
                    "targets": [4],
                    // "visible": false,
                    "orderable": false
                },
                {
                    "targets": [5],
                    "visible": false,
                    "orderable": false
                },
            ],
            drawCallback: function (settings) {
                $("#valorlancd").html(settings.json.total);
            },
            "lengthMenu": [10, 50, 100, 500],
            serverSide: true,
            ajax: "_backend/_controller/_select/_grid/pedidos_delivery_confirmados_select_grid.php", // json datasource

        });
        $("#employee-grid-pedidosConfirmados_filter").css("display", "none"); // hiding global search box

        $('.employee-search-pedido_onlinec-input').on('keyup click', function (event) {
            var i = $(this).attr('id'); // getting column index
            var v = $(this).val(); // getting search input value
            dataTable2.columns(i).search(v).draw();
        });

        // Recarrega a tabela a cada 1 minuto (60000 milisegundos)
        setInterval(function () {
            $('.employee-search-pedido_online-input').val('');
            $('.employee-search-pedido_onlinec-input').val('');
            dataTable.columns().search('');
            dataTable.ajax.reload(null, false);
            dataTable2.columns().search('');
            dataTable2.ajax.reload(null, false);
            toastr.success('Pedidos atualizados');

            var valor = $("#valorpendentes").text();
            var numero = parseFloat(valor.replace("R$", "").replace(",", ".").trim()); // Converte para float

            if (numero > 0) {
                var audio = new Audio('notificacao.mp3');
                var playCount = 0;  // Contador para rastrear quantas vezes o áudio foi tocado

                audio.load();

// Função para tocar o áudio
                function playAudio() {
                    audio.play().then(() => {
//                        console.log("Áudio tocando...");
                    }).catch(function (error) {
                        console.log('Erro ao tentar tocar o áudio:', error);
                    });
                }

// Tocar o áudio pela primeira vez
                playAudio();

// Quando o áudio terminar de tocar, tocar novamente se for a primeira vez
                audio.addEventListener('ended', function () {
                    playCount++;
                    if (playCount < 2) {
                        // Tocar o áudio pela segunda vez
                        playAudio();
                    } else {
//                        console.log("Áudio tocou duas vezes. Parando.");
                        // Após tocar duas vezes, podemos parar o áudio se necessário
                        audio.pause();
                        audio.currentTime = 0;  // Reseta a posição do áudio para o início
                    }
                });

            }
        }, 15000);

        $('#detalhesPedido').click(function () {
            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {
                    exibirDetalhesPedido($(val).get(0));
                }
            }
        });

        $('#confirmarPedido').click(function () {
            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {
                    // Add verification before confirmation
                    $.ajax({
                        type: "POST",
                        url: "<?= BACKEND ?>/_controller/_select/_ajax/verificar_situacao_pedido.php",
                        data: {
                            documento: $(val).get(0)
                        },
                        dataType: "json",
                        success: function (response) {
                            if (response.situacao === 'P') {
                                bootbox.confirm({
                                    message: "Deseja realmente confirmar este pedido?",
                                    buttons: {
                                        confirm: {
                                            label: 'Sim',
                                            className: 'btn-success'
                                        },
                                        cancel: {
                                            label: 'Não',
                                            className: 'btn-danger'
                                        }
                                    },
                                    callback: function (result) {
                                        if (result) {
                                            confirmarPedido($(val).get(0));
                                        }
                                    }
                                });
                            } else {
                                toastr.error('Este pedido não está mais pendente!');
                                $('.employee-search-pedido_online-input').val('');
                                dataTable.columns().search('');
                                dataTable.ajax.reload(null, false);
                            }
                        },
                        error: function () {
                            toastr.error('Erro ao verificar situação do pedido');
                        }
                    });
                }
            }
        });

        $('#atualizarPedidos').click(function () {
            $('.employee-search-pedido_online-input').val('');
            $('.employee-search-pedido_onlinec-input').val('');
            dataTable.columns().search('');
            dataTable.ajax.reload(null, false);
            dataTable2.columns().search('');
            dataTable2.ajax.reload(null, false);
            toastr.success('Pedidos atualizados');
        })

        function confirmarPedido(pedidoId) {
            $.ajax({
                type: "POST",
                url: "<?= BACKEND ?>/_controller/_insert/saida_online_insert.php",
                data: {
                    documento: pedidoId
                },
                dataType: "json",
                success: function (data) {
                    if (data.retorno > 0) {
                        $('.employee-search-pedido_online-input').val('');
                        dataTable.columns().search('');
                        dataTable.ajax.reload(null, false);
                        $('.employee-search-pedido_onlinec-input').val('');
                        dataTable2.columns().search('');
                        dataTable2.ajax.reload(null, false);
                        toastr.success('Pedido confirmado com sucesso!');
                    } else {
                        toastr.error(data.mensagem);
                    }
                }
            });
        }


        $('#alterarSituacao').click(function () {
            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {
                    alterarSituacao($(val).get(0));
                }
            }
        });

        function alterarSituacao(pedidoId) {
            // First verify current status
            $.ajax({
                type: "POST",
                url: "<?= BACKEND ?>/_controller/_select/_ajax/verificar_situacao_pedido.php",
                data: {
                    documento: pedidoId
                },
                dataType: "json",
                success: function (response) {
                    if (response.situacao === 'P') {
                        toastr.warning('Este pedido está pendente. É necessário confirmá-lo primeiro.');
                    } else {
                        bootbox.dialog({
                            title: 'Alterar situação do pedido',
                            message: 'Selecione a nova situação:',
                            buttons: {
                                entrega: {
                                    label: 'Saiu para entrega',
                                    className: 'btn-info',
                                    callback: function () {
                                        atualizarSituacaoPedido(pedidoId, 'S');
                                    }
                                },
                                finalizado: {
                                    label: 'Finalizado',
                                    className: 'btn-success',
                                    callback: function () {
                                        atualizarSituacaoPedido(pedidoId, 'F');
                                    }
                                },
                                cancel: {
                                    label: 'Cancelar',
                                    className: 'btn-secondary'
                                }
                            }
                        });
                    }
                },
                error: function () {
                    toastr.error('Erro ao verificar situação do pedido');
                }
            });
        }

        function atualizarSituacaoPedido(pedidoId, novaSituacao) {
            $.ajax({
                type: "POST",
                url: "<?= BACKEND ?>/_controller/_update/atualizar_situacao_pedido.php",
                data: {
                    documento: pedidoId,
                    situacao: novaSituacao
                },
                dataType: "json",
                success: function (response) {
                    if (response.status === 'success') {
                        toastr.success('Situação do pedido atualizada com sucesso!');
                        $('.employee-search-pedido_online-input').val('');
                        $('.employee-search-pedido_onlinec-input').val('');
                        dataTable.columns().search('');
                        dataTable.ajax.reload(null, false);
                        dataTable2.columns().search('');
                        dataTable2.ajax.reload(null, false);
                    } else {
                        toastr.error(response.message || 'Erro ao atualizar situação do pedido');
                    }
                },
                error: function () {
                    toastr.error('Erro ao atualizar situação do pedido');
                }
            });
        }

    });


    function imprimirPedido(valor) {
        window.open('_mobile/_chef/_print/pedido_online.php?documento=' + valor, '',
                'height=800,width=700,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
    }

    function exibirDetalhesPedido(pedidoId) {
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/pedido_detalhes_select_ajax.php",
            data: {
                documento: pedidoId
            },
            dataType: "json",
            success: function (data) {
                if (data.status == 'OK') {
                    // Preenche dados do cliente
                    let clienteHtml = `
                        <p><strong>Nome:</strong> ${data.cliente.nome}</p>
                        <p><strong>Telefone:</strong> ${data.cliente.telefone}</p>
                    `;
                    $('#dadosCliente').html(clienteHtml);

                    let entregaHtml = '';
                    // Preenche dados da entrega
                    if (data.tipo_entrega === 'E' || data.tipo_entrega === 'e') {
                        entregaHtml = `
                            <p><strong>Endereço:</strong> ${data.entrega.endereco}</p>
                            <p><strong>Número:</strong> ${data.entrega.numero}</p>
                            <p><strong>Bairro:</strong> ${data.entrega.bairro}</p>
                            <p><strong>Complemento:</strong> ${data.entrega.observacoes}</p>
                        `;
                    } else {
                        entregaHtml = `
                        <p>Pedido para retirada</p>
                        `;
                    }
                    $('#dadosEntrega').html(entregaHtml);

                    // Preenche itens do pedido
                    let itensHtml = `
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Item</th>
                                    <th>Quantidade</th>
                                    <th>Valor Unit.</th>
                                    <th>Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                    `;

                    data.itens.forEach(item => {
                        itensHtml += `
                            <tr>
                                <td>${item.descricao}</td>
                                <td>${item.quantidade}</td>
                                <td>R$ ${item.valor_unitario}</td>
                                <td>R$ ${item.subtotal}</td>
                            </tr>
                        `;
                    });

                    itensHtml += `
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="3" class="text-right"><strong>Total:</strong></td>
                                    <td>R$ ${data.total}</td>
                                </tr>
                            </tfoot>
                        </table>
                    `;

                    $('#itensPedido').html(itensHtml);
                    // Adiciona observações do pedido, se houver
                    if (data.obs) {
                        let obsHtml = `
                            <div class="mt-3">
                                <h5><b>Observações</b></h5>
                                <p>${data.obs}</p>
                            </div>
                        `;
                        $('#itensPedido').append(obsHtml);
                    }

                    // Exibe o modal
                    $('#modalDetalhesPedido').modal('show');
                } else {
                    toastr.error(data.msg);
                }
            },
            error: function () {
                toastr.error('Erro ao carregar detalhes do pedido');
            }
        });
    }

    //     
</script>