<?php
session_start();
require_once('../../../functions.php');
require_once("../_modal/_modal.php");
require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";
require_once "../../_class/Emitente_class.php";

$emitente->certificado = 'A1';

if ($nivelusuario->emitenfe == 'N') :
    ?>
    <div class="note note-info">
        <div class="alert bg-red bg-font-red alert-dismissible" role="alert">
            <strong>AUTORIZAÇÃO DE ACESSO NEGADA.</strong>
        </div>
    </div>
    <?php
    exit;
endif;
?>
<script>

    $('#bulkDelete').click(function () {
        var c = $("#bulkDelete");
        if (c.is(":checked")) {
            $('.DeleteRow').prop('checked', true);
        } else {
            $('.DeleteRow').prop('checked', false);
        }

    });

    timer.stop();

    function DescontoAlteraNFe(valor) {
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_update/update_desconto_itens.php",
            data: {
                documento: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//                alert(data[0]);
                if (data.retorno) {
                    Transmite(valor);
                }
            }
        }); //termina o jquery
    }

    function ServicosCorreios(valor) {
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/servico_correios_select_ajax.php",
            data: {
                correios: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
                var option = '<option></option>';
                $.each(data, function (i, obj) {
                    option += '<option value="' + obj.codigo + '"> ' + obj.codigo + ' - ' + obj.descricao + ' </option>';
                });

                $('#servico').html(option);
                BuscaPadrao(valor);
            }
        }); //termina o jquery
    }


    function BuscaPadrao(valor) {
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/correios_select_ajax.php",
            data: {
                correios: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
                $.each(data, function () {
                    $.each(this, function (k, v) {
                        $("#" + k + "").val(v);
                    });
                });
            }
        }); //termina o jquery
    }


    $(document).ready(function () {
        $('#btnEnviarXML').click(function () {
            $('#formUpload').ajaxForm({
                uploadProgress: function (event, position, total, percentComplete) {
                    $('progress').attr('value', percentComplete);
                    $('#porcentagem').html(percentComplete + '%');
                },
                success: function (data) {
                    $('progress').attr('value', '100');
                    $('#porcentagem').html('100%');
                    if (data.sucesso == true) {
                        XMLDI(data.arquivo);

                    } else {
                        data.msg;
                    }
                    ImportarFechar();
                },
                error: function () {
                    $('#resposta').html('Erro ao enviar requisição!!!');
                },
                dataType: 'json',
                url: '<?= BACKEND ?>/_controller/_import/enviar_arquivo.php',
//                            resetForm: true
            }).submit();
        });
    });


    function GeraRotulosCorreios() {

        bootbox.confirm({
            message: "Deseja realmente imprimir o rótulo da nf-e selecionada?",
            closeButton: false,
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    $("#btnRotuloCorreios").html('<i class="fa fa-spinner fa-pulse fa-fw"></i>  Aguarde ...');
                    var nfe = $("#idnfecorreios").val();
                    var layoutImpressao = $("#layoutImpressao").val();
                    var tipoRotulo = $("#tipoRotulo").val();
                    var url = "<?= LINK ?>/_integracoes/correios/GeraRotulo.php?" +
                            "layoutImpressao=" + encodeURIComponent(layoutImpressao) +
                            "&nfe=" + encodeURIComponent(nfe) +
                            "&tipoRotulo=" + encodeURIComponent(tipoRotulo);

                    // Exibindo o link (pode ser adaptado para redirecionar ou copiar)

                    $.ajax({
                        type: "GET",
                        url: url,
                        dataType: "json",
                        success: function (data)
                        {
//                            alert(data.status);
                            if (data.status) {
//                                alert(data.msg);

                                ImprimeRotulo(nfe);
                            } else {
                                $("#msg_Rotulos_correios").show();
                                $("#msg_Rotulos_correios").addClass("alert-danger");
                                $("#MsgRotolusCorreios").html(data.msg);

                            }
                            $("#btnRotuloCorreios").html('<i class="fa fa-tag"> </i> Gerar');
                        }
                    });
                }
            }
        });
    }


    function ImprimeRotulo(nfe) {
        $("#msg_Rotulos_correios").show();
        $("#msg_Rotulos_correios").removeClass("alert-danger");
        $("#msg_Rotulos_correios").addClass("alert-primary");
        $("#MsgRotolusCorreios").html("Aguarde, gerando a etiqueta!");
        var url = "<?= LINK ?>/_integracoes/correios/ImprimeRotulo.php?" +
                "nfe=" + encodeURIComponent(nfe);
        $.ajax({
            type: "GET",
            url: url,
            dataType: "json",
            success: function (data)
            {
//                            alert(data.status);
                if (data.status) {
//                                alert(data.msg);
                    $("#msg_Rotulos_correios").show();
                    $("#msg_Rotulos_correios").removeClass("alert-primary");
                    $("#msg_Rotulos_correios").addClass("alert-success");
                    $("#MsgRotolusCorreios").html('Rotulo Gerado!');
                    var download = "<?= LINK ?>/_integracoes/correios/rotulos/" + data.aquivo + "";
                    window.open(download, '_blank', 'toolbar=no,location=no,status=no,menubar=no,scrollbars=no,resizable=no');

                } else {
                    $("#msg_Rotulos_correios").show();
                    $("#msg_Rotulos_correios").removeClass("alert-primary");
                    $("#msg_Rotulos_correios").addClass("alert-danger");
                    if (data.msg === 'null') {
                        $("#MsgRotolusCorreios").html('Não foi possivél gerar o rotulo, tente novamente!');

                    } else {
                        $("#MsgRotolusCorreios").html(data.msg);

                    }



                }
            }
        });

    }

    function GeraEtiquetaCorreios() {

        bootbox.confirm({
            message: "Deseja realmente gerar etiqueta da nf-e selecionada?",
            closeButton: false,
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    $("#btnEtqCorreios").html('<i class="fa fa-spinner fa-pulse fa-fw"></i>  Aguarde ...');
                    var nfe = $("#idnfecorreios").val();
                    var correios = $("#correios").val();
                    var servico = $("#servico").val();
                    var codObj = $("#codObj").val();
                    var altura = $("#altura").val();
                    var largura = $("#largura").val();
                    var comprimento = $("#comprimento").val();
                    var diametro = $("#diametro").val();
                    var coleta = $("#coleta").val();
                    var dataPostagem = $("#dataPostagem").val();
                    var loogisticaReversa = $("#loogisticaReversa").val();
                    var dataloogisticaReversa = $("#dataloogisticaReversa").val();
                    var conteudo = $("#conteudo").val();
                    var pesoInformado = $("#pesoInformado").val();
                    var quantidade = $("#quantidade").val();
                    var vProdCorreios = $("#vProdCorreios").val();
                    var url = "<?= LINK ?>/_integracoes/correios/GerarEtiqueta.php?" +
                            "correios=" + encodeURIComponent(correios) +
                            "&nfe=" + encodeURIComponent(nfe) +
                            "&servico=" + encodeURIComponent(servico) +
                            "&codObj=" + encodeURIComponent(codObj) +
                            "&altura=" + encodeURIComponent(altura) +
                            "&largura=" + encodeURIComponent(largura) +
                            "&comprimento=" + encodeURIComponent(comprimento) +
                            "&diametro=" + encodeURIComponent(diametro) +
                            "&coleta=" + encodeURIComponent(coleta) +
                            "&dataPostagem=" + encodeURIComponent(dataPostagem) +
                            "&dataloogisticaReversa=" + encodeURIComponent(dataloogisticaReversa) +
                            "&conteudo=" + encodeURIComponent(conteudo) +
                            "&quantidade=" + encodeURIComponent(quantidade) +
                            "&pesoInformado=" + encodeURIComponent(pesoInformado) +
                            "&vProdCorreios=" + encodeURIComponent(vProdCorreios) +
                            "&logisticaReversa=" + encodeURIComponent(loogisticaReversa);

                    // Exibindo o link (pode ser adaptado para redirecionar ou copiar)

                    $.ajax({
                        type: "GET",
                        url: url,
                        dataType: "json",
                        success: function (data)
                        {
//                            alert(data.status);
                            if (data.status) {
//                                alert(data.msg);
                                $("#msg_correios").show();
                                $("#msg_correios").addClass("alert-success");
                                $("#MsgCorreios").html(data.msg);
                            } else {
                                $("#msg_correios").show();
                                $("#msg_correios").addClass("alert-danger");
                                $("#MsgCorreios").html(data.msg);

                            }
                            $("#btnEtqCorreios").html('<i class="fa fa-tag"> </i> Gerar');
                        }
                    });
                }
            }
        });
    }





    function GeraEtiqueta(arquivo) {

        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_gera/etiqueta_nfe.php",
            data: {
                nfe: arquivo
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data.retorno == true) {
                    toastr.success(data.mensagem);
                    $("#abreetiq").modal('hide');
                } else {
                    toastr.warning(data.mensagem);
                }
            }
        }); //termina o jquery

    }

    function Cliente(valor) {

        $.ajax({
            url: "<?= BACKEND ?>/_controller/_select/_ajax/cliente_select_ajax.php?cliente=" + valor,
            dataType: "json",
            // função para de sucesso
            success: function (data) {
//                  alert(data[0]);
                if (data[0] != undefined) {
                    $("#clienteCNPJ").val(data[0].clienteid);
                    $("#clientexNome").val(data[0].xNome);
                } else {
                    toastr.warning('Nenhum Registo Encontrado!');
                    $("#clienteCNPJ").val('');
                    $("#clientexNome").val('');
                }
            }
        }); //termina o jquery

        $("#busca").modal('hide');


    }

    function Fornecedor(valor) {

        $.ajax({
            url: "<?= BACKEND ?>/_controller/_select/_ajax/fornecedor_select_ajax.php?fornecedor=" + valor,
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
                if (data[0] != undefined) {
                    $("#fornecedorCNPJ").val(data[0].fornecedorid);
                    $("#fornecedorxNome").val(data[0].xNome);
                } else {
                    toastr.warning('Nenhum Registo Encontrado!');
                    $("#fornecedorCNPJ").val('');
                    $("#fornecedorxNome").val('');
                }
            }
        }); //termina o jquery

        $("#busca").modal('hide');


    }

    function Busca(valor) {
        $("#busca").modal('show');
        $("#buscatitle").html('BUSCA ' + valor.toUpperCase());
        $("#carregandobusca").css("display", "block");
        $("#recebegrid").load('_backend/_view/_grid/' + valor + '_grid.php?busca=S', function () {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }

    function BuscaPara(valor) {
        if (valor === 'F') {
            $("#cliente").css("display", "block");
            $("#fornecedor").css("display", "none");
            $("#clienteCNPJ").va('');
            $("#clientexNome").val('');
        } else {
            $("#fornecedor").css("display", "block");
            $("#cliente").css("display", "none");
            $("#fornecedorCNPJ").val('');
            $("#fornecedorxNome").val('');
        }
    }


</script>
<script>
    var myDropzone = new Dropzone("div#drop", {url: "<?= LINK ?>/_fiscal/_nfe/geracao/ImpXMLSaida_aprovada_lote.php"});
</script>

<script>
    $('#excel').on('click', function () {
        $('.buttons-Excel').click()
    });
    $('#pdf').on('click', function () {
        $('.buttons-Pdf').click()
    });
    $('#copy').on('click', function () {
        $('.buttons-Copy').click()
    });
    $('#print').on('click', function () {
        $('.buttons-Print').click()
    });
</script>
<style>
    label {
        font-size: 12px;
    }
    .fileUpload {
        position: relative;
        overflow: hidden;
        margin: 0px;
    }
    .fileUpload input.upload {
        position: absolute;
        top: 0;
        right: 0;
        margin: 0;
        padding: 0;
        font-size: 20px;
        cursor: pointer;
        opacity: 0;
        filter: alpha(opacity=0);
    }
    button {
        margin-top: 3px;
    }

    .dt-buttons {
        display : none;
    }
    input[type=radio], input[type=checkbox]  {
        width: 18px;
        height: 18px;
    }
    td {
        vertical-align: middle;
    }
</style>

<div class="row">
    <div class="col-md-12">
        <button class="btn btn-primary " onclick="Carrega('_form', 'nfe_form.php', 'Emissão de NF-e')" title="Emitir NF-e"> <i class="fa fa-plus"></i> Nova</button>
        <button class="btn btn-primary " id="editar" title="Editar NF-e"> <i class="fa fa-edit"></i> Editar</button>
        <button class="btn btn-danger " id="delete" title="Deletar NF-e"> <i class="fa fa-trash"></i> Excluir</button> 
        <button class="btn btn-primary" id="transmite" title="Transmitir NF-e"> <i class="fa fa-exchange"></i> Aprovar NFe</button>
        <button class="btn btn-primary " id="imprimirdanfe" title="Imprimir NF-e"> <i class="fa fa-print"></i> Imprimir NFe</button>
        <button class="btn btn-danger " id="cancelar" title="Cancelar NF-e"> <i class="fa fa-close"></i> Cancelar NF-E</button>




        <div class="btn-group">
            <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                Mais Ações<span class="caret"></span>
            </button>
            <ul class="dropdown-menu" style="max-height: 500px; overflow-y: scroll ">

                <?php
                if ($emitente->contigenciaNFe == 'N') :
                    ?>
                    <li><a href="javascript::" id="AtivaContigencia" onclick="AtivaContigencia()"><b><i class="fa fa-file">  </i> Ativar Contigência NF-e</b></a></li>
                    <li role="separator" class="divider"></li>
                    <?php
                else :
                    ?>
                    <li><a href="javascript::" id="DesativaContigencia" onclick="DesativaContigencia()"><b><i class="fa fa-file">  </i> Desativar Contigência NF-e</b></a></li>
                    <li role="separator" class="divider"></li>
                <?php
                endif;
                ?>

                <li><a href="javascript::" id="duplicar"><b><i class="fa fa-copy">  </i> Duplicar NF-e</b></a></li>
                <li role="separator" class="divider"></li>
                <li><a href="javascript::" id="conchave"><b><i class="fa fa-copy">  </i> Consultar Chave NFC-e</b></a></li>
                <li role="separator" class="divider"></li>                
                <li><a href="javascript::" id="retorno"><b><i class="fa fa-copy">  </i> Retorno NF-e</b></a></li>
                <li role="separator" class="divider"></li>
                <li><a href="javascript::" id="devolucao"><b><i class="fa fa-copy">  </i>Devolução NF-e</b></a></li>
                <li role="separator" class="divider"></li>
                <li><a href="javascript::" id="doc"><b><i class="fa fa-copy">  </i> Buscar Documento</b></a></li>
                <li role="separator" class="divider"></li>
                <li><a href="javascript::" id="importar" onclick="ImportarLote()"><b> <i class="fa fa-upload"></i> Importar LOTE XML</b></a></li>
                <li role="separator" class="divider"></li>
                <li><a href="javascript::" id="email"><b> <i class="fa fa-send-o"> </i> Enviar NF-e por email</b></a></li>
                <li role="separator" class="divider"></li>
                <li><a href="javascript::" id="inutilizanfe"> <b> <i class="fa fa-ban"> </i> Inutilizar NF-e </b></a></li>
                <li role="separator" class="divider"></li>
                <li><a href="javascript::" id="cce"><b> <i class="fa fa-edit"> </i> Carta Correção NF-e </b> </a></li>
                <li role="separator" class="divider"></li>
                <li><a href="javascript::" id="imprimircce"> <b> <i class="fa fa-print"> </i> Imprimir Carta Correção NF-e </b></a></li>
                <li role="separator" class="divider"></li>
                <li><a href="javascript::" id="exportar"><b> <i class="fa fa-file-zip-o"> </i> Exportar XML </b></a></li>
                <li role="separator" class="divider"></li>
                <li><a href="javascript::" id="etiqueta"><b> <i class="fa fa-file"> </i> Gerar Etiqueta </b></a></li>
                <li role="separator" class="divider"></li>
                <li><a href="javascript::" id="imprimirsimplificado"><b> <i class="fa fa-print"> </i> Danfe Simplificado </b></a></li>
                <li role="separator" class="divider"></li>
                <li><a href="javascript::" id="imprimiretiqueta"><b> <i class="fa fa-print"> </i> Danfe Etiqueta</b></a></li>
                <li role="separator" class="divider"></li>
                <li><a href="javascript::" id="excel"><b><i class="fa fa-file-excel-o">  </i> Exportar para excel</b></a></li>
                <li role="separator" class="divider"></li>

                <li><a href="javascript::" id="pdf"><b><i class="fa fa-file-pdf-o">  </i> Exportar para pdf</b></a></li>
                <li role="separator" class="divider"></li>

                <li><a href="javascript::" id="copy"><b><i class="fa fa-copy">  </i> Copiar</b></a></li>
                <li role="separator" class="divider"></li>

                <li><a href="javascript::" id="print"><b><i class="fa fa-print">  </i> Imprimir</b></a></li>
                <li role="separator" class="divider"></li>

            </ul>
        </div>


        <?php
        if ($emitente->emiteboleto == 'S') :
            ?>
            <div class="btn-group">
                <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    Boleto<span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    <li><a href="javascript::" id="boleto"><b><i class="fa fa-file-pdf-o">  </i> Imprimir Boleto</b></a></li>
                    <li role="separator" class="divider"></li>

                    <li><a href="javascript::" id="remessa"><b><i class="fa fa-file-pdf-o">  </i> Gerar Remessa</b></a></li>
                    <li role="separator" class="divider"></li>

                    <li><a href="javascript::" id="boletoemail"><b><i class="fa fa-mail">  </i> Enviar por Email</b></a></li>
                    <li role="separator" class="divider"></li>
                </ul>
            </div>
            <?php
        endif;
        ?>


        <?php
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'integracao');
        $sql = "SELECT * from integracao where id='2'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);
        if ($dados->ativo == 'S') :
            ?>
            <div class="btn-group">
                <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    Correios<span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="javascript::" id="integracaocorreios"><b><i class="fa fa-file">  </i> Gerar Etiquetas Correios</b></a></li>
                    <li role="separator" class="divider"></li>
                    <li><a class="dropdown-item" href="javascript::" id="integracaocorreiosrotulos"><b><i class="fa fa-print">  </i> Imprimir Rótulos</b></a></li>
                    <li role="separator" class="divider"></li>

                </ul>
            </div>
            <?php
        endif
        ?>

<!--<button class="btn btn-warning " id="email" title="Enviar E-mail"> <i class="fa fa-envelope"></i> E-mail</button>-->
<!--        <button class="btn btn-warning " id="inutilizanfe" title="Inutilizar NF-e"> <i class="fa fa-ban"></i> Inutilizar</button>
<button class="btn btn-warning " id="cce" title="Carta Correção NF-e"> <i class="fa fa-file-text"></i> CCe</button>
<button class="btn btn-warning " id="imprimircce" title="Imprimir CCe"> <i class="fa fa-file-pdf-o"></i> Imprimir CCe</button>
<button class="btn btn-warning " id="exportar" title="Exportar XML"> <i class="fa fa-file-zip-o"></i> XML</button>-->
    </div>
</div>
<hr/>
<div class="row">
    <div class="col-md-12" style='background-color: #fff;'>
        <div class="table-responsive">
            <table id="employee-grid-nfe" cellpadding="0" cellspacing="0" border="0" class="table table-responsive table-bordered table-hover table-condensed table-striped width-full">
                <thead>

                    <tr class="alert alert-default">
                        <th></th>
                        <th style="width: 15%">Nº</th>
                        <th style="width: 16%">Modelo</th>    
                        <th style="width: 1%">Serie</th>    
                        <th style="width: 18%">Data Emissão</th>    
                        <th style="width: 30%">Cliente</th>    
                        <th style="width: 10%">Valor</th>    
                        <th style="width: 10%">Chave</th>    
                        <th style="width: 14%">Situação</th>    
                        <th style="width: 10%">Ambiente</th>    
                    </tr>
                    <tr>
                        <th><input type="checkbox"  id="bulkDelete"  /></th>
                        <!--<th></th>-->
                        <th><input type="text" id="1" style="width: 100%;  font-size: 10px;" class="form-control employee-search-nfe-input"></th>
                        <th>
                            <select id="2" style="width: 100%; font-size: 10px;" class="form-control employee-search-nfe-input">                            
                                <option value="55"> NF-e </option>
                                <option value="01"> NF </option>
                                <option value="65" <?php
                                if ($_GET['nfce'] == 'S') : echo 'selected=""';
                                endif;
                                ?>> NFC-e</option>
                                <option value="T"> Todos </option>


                            </select>
                        </th>
                        <th><input type="text" id="3" style="width: 100%" class="form-control employee-search-nfe-input"></th>
                        <th><input type="text" id="4" onkeypress="mascara(this, mdata);" style="width: 100%;  font-size: 10px;" class="form-control employee-search-nfe-input"></th>
                        <th><input type="text" id="5" style="width: 100%;  font-size: 10px;" class="form-control employee-search-nfe-input"></th>
                        <th><input type="text" id="6" onkeypress="mascara(this, mvalor);" style="width: 100%;  font-size: 10px;" class="form-control employee-search-nfe-input"></th>
                        <th><input type="text" id="8"  style="width: 100%;  font-size: 10px;" class="form-control employee-search-nfe-input"></th>
                        <th>
                            <select id="8" style="width: 100%" class="form-control employee-search-nfe-input situacao_select">
                                <option value=""> </option>
                                <option value="P" <?php
                                if ($_GET['status'] == 'P') : echo 'selected=""';
                                endif;
                                ?>> Pendente </option>
                                <option value="100"> Aprovado </option>
                                <option value="101"> Cancelado </option>
                            </select>
                        </th>
                        <th>
                            <select id="9" style="width: 100%" class="form-control employee-search-nfe-input">
                                <option value="">  </option>
                                <option value="1"> Produção </option>
                                <option value="2"> Homologação </option>
                            </select>
                        </th>
                    </tr>
                </thead>

                <tfoot>
                    <tr class="alert alert-default">
                        <td colspan="8"><b>TOTAL</b></td>
                        <td><strong><span class="text-black-50" id="valorlancd"></span></strong></td>    
                    </tr>   
                </tfoot>
            </table>
        </div>
    </div>
</div>
<script type="text/javascript" language="javascript" >


    $(document).ready(function () {
        $('#btnEnviarXML').click(function () {
            $('#formUpload').ajaxForm({
                uploadProgress: function (event, position, total, percentComplete) {
                    $('progress').attr('value', percentComplete);
                    $('#porcentagem').html(percentComplete + '%');
                },
                success: function (data) {
                    $('progress').attr('value', '100');
                    $('#porcentagem').html('100%');
                    if (data.sucesso == true) {
                        //                        alert(data.arquivo);
                        ImportarXML(data.arquivo);
                    } else {
                        data.msg;
                    }
                },

                error: function () {
                    $('#resposta').html('Erro ao enviar requisição!!!');
                },
                dataType: 'json',
                url: '<?= BACKEND ?>/_controller/_import/enviar_arquivo_xml.php',
                resetForm: true
            }).submit();
        })
    })


    function ImportarTXT(valor) {

        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/ConvertNFE.php",
            //                data: {
            //                    nfe: valor
            //                },
            dataType: "json",
            success: function (data)
            {
                if (data.status == 'ok') {
                    Carrega('_grid', 'nfe_grid.php', 'NF-E');
                    document.getElementById("alerterro").style.display = "none";
                    document.getElementById("alertsucesso").style.display = "block";
                    $("#sucesso").html(data.msg);
                    setTimeout(function () {
                        $("#alertsucesso").css("display", "none");
                    }, 3000);
                } else {
                    document.getElementById("alertsucesso").style.display = "none";
                    document.getElementById("alerterro").style.display = "block";
                    $("#erro").html(data.msg);
                    setTimeout(function () {
                        $("#alerterro").css("display", "none");
                    }, 3000);
                }

            }
        });
    }


    function ImportarXML(valor) {

        $.ajax({
            type: "GET",
//            url: "<?= LINK ?>/_fiscal/_nfe/geracao/ImpXMLSaida.php",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/ImpXMLSaida_aprovada.php",
            data: {
                xml: valor
            },
            dataType: "json",
            success: function (data)
            {
                if (data.status == 'ok') {
                    Carrega('_grid', 'nfe_grid.php', 'NF-E');
                    alert(data.msg);
                    document.getElementById("alerterro").style.display = "none";
                    document.getElementById("alertsucesso").style.display = "block";
                    $(".modal-backdrop").css("display", "none");
                    $("#sucesso").html(data.msg);
                    setTimeout(function () {
                        $("#alertsucesso").css("display", "none");
                    }, 3000);
                } else {
                    document.getElementById("alertsucesso").style.display = "none";
                    document.getElementById("alerterro").style.display = "block";
                    $("#erro").html(data.msg);
                    $(".modal-backdrop").css("display", "none");
                    setTimeout(function () {
                        $("#alerterro").css("display", "none");
                    }, 3000);
                }

            }
        });
    }

    function Importar() {
        $("#Import").modal('show');
        $("#tituloGrid").html('IMPORTAR XML');
    }

    function ImportarLote() {
        $("#lotexml").modal('show');
//        $("#tituloGrid").html('IMPORTAR XML');
    }


    function Arquivo(valor) {
        if (verificaExtensaoArquivo(valor)) {
            $("#uploadFile").val(valor);
        } else {
            $("#uploadFile").val('');
            $("#arquivo").val('');
        }


    }

    function verificaExtensaoArquivo(arquivo) {
        extensoes_permitidas = new Array(".xml");
        extensao = (arquivo.substring(arquivo.lastIndexOf("."))).toLowerCase();
        permite = false;
        $(extensoes_permitidas).each(function (i) {
            if (extensoes_permitidas[i] == extensao) {
                permite = true;
                return false;
            }

        });
        if (!permite) {
            alert("SOMENTE É ACEITO ARQUIVO DE TEXTO. (.xml)");
            return false;
        }
        return true;
    }

    $(document).ready(function () {

        var dataTable = $('#employee-grid-nfe').DataTable({
            processing: true,
            "language": {
                "processing": "Aguarde...",
                "info": "_PAGE_ DE _PAGES_",
                "lengthMenu": "_MENU_",
                "infoFiltered": "(Filtrando _MAX_)",
                "emptyTable": "<b>Nenhum Registro Encontrado</b>",
                "paginate": {
                    "previous": "Anterior",
                    "next": "Próximo"
                },
                "buttons": {
                    copyTitle: 'Adicionado à área de transferência',
                    copySuccess: {
                        _: '%d linhas copiadas',
                        1: '1 linha copiada'
                    }
                }
            },
            "columnDefs": [
                {
                    "targets": [0],
//                    "visible": false,
                    "searchable": false,
                    "orderable": false
                },
                {
                    "targets": [2],
//                    "visible": false,
                    "searchable": false,
                    "orderable": false
                },
                {
                    "targets": [8],
//                    "visible": false,
                    "searchable": false,
                    "orderable": false
                },
                {
                    "targets": [9],
                    "visible": false,
                    "searchable": false,
                    "orderable": false
                }
            ],
            drawCallback: function (settings) {
                $("#valorlancd").html(settings.json.total);
            },
            "lengthMenu": [10, 50, 100, 500],
            dom: 'Bflrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            serverSide: true,
            ajax: "_backend/_controller/_select/_grid/nfe_select_grid.php", // json datasource

        });
        $("#employee-grid-nfe_filter").css("display", "none"); // hiding global search box

        $('.employee-search-nfe-input').on('keyup click', function (event) {
            var i = $(this).attr('id'); // getting column index
            var v = $(this).val(); // getting search input value           
            dataTable.columns(i).search(v).draw();
        });
        $(document).ready(function () {
            $('#selecionanfe').click(function () {
                var val = new Array();
                $('.DeleteRow:checked').each(function () {
                    val.push($(this).val());
                });
                if (val == '') {
                    toastr.warning('Nenhum Registo Selecionado!');
                } else {
                    var cod = $(val).get(0);
                    //                    alert(cod);
                    Cliente(cod);
                }

            });
        });
        //   


        $('#delete').click(function () {
            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {

                    bootbox.confirm({
                        message: "Deseja realmente excluir a NF selecionada?",
                        buttons: {
                            confirm: {
                                label: 'Sim',
                                className: 'btn-success'
                            },
                            cancel: {
                                label: 'Não',
                                className: 'btn-danger'
                            }
                        },
                        callback: function (result) {
                            if (result) {

                                $.ajax({
                                    type: "GET",
                                    url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                                    data: {
                                        nfe: $(val).get(0)
                                    },
                                    dataType: "json",
                                    success: function (data)
                                    {
                                        if (data[0].status == '100') {
                                            document.getElementById("alerterro").style.display = "block";
                                            document.getElementById("alertsucesso").style.display = "none";
                                            $("#erro").html('<i class="fa fa-exclamation-circle"></i> Não é possível DELETAR Nota Fiscal Aprovada.!');
                                            setTimeout(function () {
                                                $("#alerterro").css("display", "none");
                                            }, 3000);
                                        } else {
                                            Deletar(val, data[0].documento);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });


//        $('#delete').click(function () {
//            var val = new Array();
//            $('.DeleteRow:checked').each(function () {
//                val.push($(this).val());
//            });
//            if (val == '') {
//                toastr.warning('Nenhum Registo Selecionado!');
//            } else {
//
//                var decisao = confirm("Deseja Realmente Excluir?");
//                if (decisao) {
//                    $.ajax({
//                        type: "GET",
//                        url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
//                        data: {
//                            nfe: $(val).get(0)
//                        },
//                        dataType: "json",
//                        success: function (data)
//                        {
//                            Deletar(val, data[0].documento);
//                        }
//                    });
//                }
//            }
//        });


        $('#inutilizanfe').click(function () {
            $("#inutilizacao").modal('show');
        });

        $('#doc').click(function () {
            $("#conveterDoc").modal('show');
        });



//Boleto Remessa
        $('#remessa').click(function () {
            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                window.open('<?= LINK ?>/boleto/remessa/geracao/<?= $emitente->banco ?>_nf.php?lancamento=' + val + '', '',
                        'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
            }

        });

        $('#boletoemail').click(function () {
            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                EnviaBoleto($(val).get(0));
            }

        });

        $('#boleto').click(function () {
            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {
                    window.open('boleto/geracao/<?= $emitente->banco ?>_nf.php?lancamento=' + $(val).get(0) + '', '',
                            'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
                }
            }

        });


        $('#cancelar').click(function () {
            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                var total = val.length;
                if (total > 1) {
                    alert('Só é possível selecionar uma nota fiscal por vez.');
                    return false;
                }

                var decisao = confirm("Deseja Realmente Cancelar NF-e?");
                if (decisao) {
                    $.ajax({
                        type: "GET",
                        url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                        data: {
                            nfe: $(val).get(0)
                        },
                        dataType: "json",
                        success: function (data)
                        {
                            if (data[0].status !== '100') {
                                document.getElementById("alerterro").style.display = "block";
                                document.getElementById("alertsucesso").style.display = "none";
                                $("#erro").html('<i class="fa fa-exclamation-circle"></i> Só é possível CANCELAR Nota Fiscal Aprovada.!');
                                setTimeout(function () {
                                    $("#alerterro").css("display", "none");
                                }, 3000);
                            } else {
                                $("#nNFCancela").val($(val).get(0));
                                $("#modelo").val(data[0].modelo);
                                $("#documento").val(data[0].documento);
                                if (data[0].modelo === '65') {
                                    $("#titlecancela").html('NFC-e');
                                } else {
                                    $("#titlecancela").html('NF-e');
                                }

                                $("#cancelamento").modal('show');
                            }
                        }
                    });
                }
            }
        });


        $('#cce').click(function () {
            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                $.ajax({
                    type: "GET",
                    url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                    data: {
                        nfe: $(val).get(0)
                    },
                    dataType: "json",
                    success: function (data)
                    {
                        if (data[0].status != '100') {
                            document.getElementById("alerterro").style.display = "block";
                            document.getElementById("alertsucesso").style.display = "none";
                            $("#erro").html('<i class="fa fa-exclamation-circle"></i> Só é possível Fazer Carta de Correção em Nota Fiscal Aprovada.!');
                            setTimeout(function () {
                                $("#alerterro").css("display", "none");
                            }, 3000);
                        } else {
                            $("#nNFCce").val($(val).get(0));
                            $("#cartacorrecao").modal('show');
                        }
                    }
                });
            }
        });



        $('#integracaocorreios').click(function () {

            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
                return false;
            }
            var total = val.length;
            if (total > 1) {
                alert('Selecione apenas um registro.');
                return false;
            }


            $.ajax({
                type: "GET",
                url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                data: {
                    nfe: $(val).get(0)
                },
                dataType: "json",
                success: function (data)
                {
                    if (data[0].status == '100') {
                        $("#Etiquetacorreios").modal("show");
                        $("#idnfecorreios").val($(val).get(0));
                        $("#conteudo").val(data[0].esp);
                        $("#pesoInformado").val(data[0].pesoL);
                        $("#quantidade").val(data[0].qVol);
                        $("#vProdCorreios").val(data[0].vProdnf);
                    } else {
                        document.getElementById("alerterro").style.display = "block";
                        document.getElementById("alertsucesso").style.display = "none";
                        $("#erro").html('<i class="fa fa-exclamation-circle"></i> Só é possivel criar etiquetas de uma NF-e Aprovada.!');
                        setTimeout(function () {
                            $("#alerterro").css("display", "none");
                        }, 3000);
                    }
                }
            });
        });




//                Transmite();



        $('#integracaocorreiosrotulos').click(function () {

            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
                return false;
            }
            var total = val.length;
            if (total > 1) {
                alert('Selecione apenas um registro.');
                return false;
            }


            $.ajax({
                type: "GET",
                url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                data: {
                    nfe: $(val).get(0)
                },
                dataType: "json",
                success: function (data)
                {
                    if (data[0].status == '100') {
                        $("#Rotuloscorreios").modal("show");
                        $("#idnfecorreios").val($(val).get(0));
                    } else {
                        document.getElementById("alerterro").style.display = "block";
                        document.getElementById("alertsucesso").style.display = "none";
                        $("#erro").html('<i class="fa fa-exclamation-circle"></i> Só é possivel criar etiquetas de uma NF-e Aprovada.!');
                        setTimeout(function () {
                            $("#alerterro").css("display", "none");
                        }, 3000);
                    }
                }
            });
        });



        $('#transmite').click(function () {

            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
                return false;
            }
            var total = val.length;
            if (total > 10) {
                alert('Selecione no máximo 10 registros.');
                return false;
            }

            if (total === 1) {
                $("#envioLote").modal("show");
                $("#recebelote").html('');
                Transmite($(val).get(0));
            } else {
                $("#envioLote").modal("show");
                $("#recebelote").html('');
                for (var i = 0; i < total; i++) {
                    Transmite($(val).get(i));
                }
//                Transmite($(val).get(0));
            }

//            $("#nfcertificado").val($(val).get(0));
//            $("#certificado").modal('show');

        });


        $('#conchave').click(function () {

            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
                return false;
            }
            var total = val.length;
            if (total > 1) {
                alert('Selecione apenas 1 Registro.');
                return false;
            }
//conchave
            $("#envioLote").modal("show");
            $("#recebelote").html('');
            ConsultaChaveTrnasmite($(val).get(0));

//            $("#nfcertificado").val($(val).get(0));
//            $("#certificado").modal('show');

        });


        $('#editar').click(function () {
            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {
                    $.ajax({
                        type: "GET",
                        url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                        data: {
                            nfe: $(val).get(0)
                        },
                        dataType: "json",
                        success: function (data)
                        {
                            if (data[0].status == '100') {
                                document.getElementById("alerterro").style.display = "block";
                                document.getElementById("alertsucesso").style.display = "none";
                                $("#erro").html('<i class="fa fa-exclamation-circle"></i> Não é possível EDITAR Nota Fiscal Aprovada.!');
                                setTimeout(function () {
                                    $("#alerterro").css("display", "none");
                                }, 3000);
                            } else if (data[0].status == '101') {
                                document.getElementById("alerterro").style.display = "block";
                                document.getElementById("alertsucesso").style.display = "none";
                                $("#erro").html('<i class="fa fa-exclamation-circle"></i> Não é possível EDITAR Nota Fiscal Cancelada.!');
                                setTimeout(function () {
                                    $("#alerterro").css("display", "none");
                                }, 3000);
                            } else {
                                Carrega('_form', 'nfe_form.php?editar=' + $(val).get(0) + '', 'Emissão de NF-e')
                            }
                        }
                    });
                }
            }

        });


        $('#imprimirdanfe').click(function () {
            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {
//                alert("OK");
                    $.ajax({
                        type: "GET",
                        url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                        data: {
                            nfe: $(val).get(0)
                        },
                        dataType: "json",
                        success: function (data)
                        {
                            if (data[0].status != '100') {

                                if (data[0].modelo == '55') {
                                    GeraNFeView($(val).get(0));
                                } else {
                                    GeraNFceOFF($(val).get(0));
                                }

                            } else {

                                if (data[0].modelo == '65') {
                                    window.open('<?= LINK ?>/_fiscal/_prints/geracao/danfce.php?nNFbd=' + $(val).get(0) + '', '',
                                            'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');

                                } else {
                                    window.open('<?= LINK ?>/_fiscal/_prints/geracao/danfe.php?nNFbd=' + $(val).get(0) + '', '',
                                            'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');

                                }



                            }
                        }
                    });
                }
            }
        });

        $('#imprimirsimplificado').click(function () {
            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {
//                alert("OK");
                    $.ajax({
                        type: "GET",
                        url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                        data: {
                            nfe: $(val).get(0)
                        },
                        dataType: "json",
                        success: function (data)
                        {
                            if (data[0].status != '100') {
                                toastr.warning('Nota Fiscal não aprovada!');
                            } else {
                                if (data[0].modelo == '55') {
                                    window.open('<?= LINK ?>/_fiscal/_prints/geracao/danfe_simples.php?nNFbd=' + $(val).get(0) + '', '',
                                            'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
                                } else {
                                    toastr.warning('Só é possivel para Nota Fiscal Eletrônica!');
                                }

                            }
                        }
                    });
                }
            }
        });

        $('#imprimiretiqueta').click(function () {
            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {
//                alert("OK");
                    $.ajax({
                        type: "GET",
                        url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                        data: {
                            nfe: $(val).get(0)
                        },
                        dataType: "json",
                        success: function (data)
                        {
                            if (data[0].status != '100') {
                                toastr.warning('Nota Fiscal não aprovada!');
                            } else {
                                if (data[0].modelo == '55') {
                                    window.open('<?= LINK ?>/_fiscal/_prints/geracao/danfe_etiqueta.php?nNFbd=' + $(val).get(0) + '', '',
                                            'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
                                } else {
                                    toastr.warning('Só é possivel para Nota Fiscal Eletrônica!');
                                }

                            }
                        }
                    });
                }
            }
        });

        $('#imprimircce').click(function () {
            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {
                    $.ajax({
                        type: "GET",
                        url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                        data: {
                            nfe: $(val).get(0)
                        },
                        dataType: "json",
                        success: function (data)
                        {
                            if (data[0].status != '100') {
                                document.getElementById("alerterro").style.display = "block";
                                document.getElementById("alertsucesso").style.display = "none";
                                $("#erro").html('Nota Fiscal Não Autorizada a impressão!');
                                setTimeout(function () {
                                    $("#alerterro").css("display", "none");
                                }, 3000);
                            } else {
                                $.ajax({
                                    type: "GET",
                                    url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                                    data: {
                                        nfe: $(val).get(0)
                                    },
                                    dataType: "json",
                                    success: function (data)
                                    {
                                        if (data[0].status != '100') {
                                            document.getElementById("alerterro").style.display = "block";
                                            document.getElementById("alertsucesso").style.display = "none";
                                            $("#erro").html('Status de Nota Fsical difrente de APROVADO!');
                                            setTimeout(function () {
                                                $("#alerterro").css("display", "none");
                                            }, 3000);
                                        } else {
                                            window.open('<?= LINK ?>/_fiscal/_prints/geracao/dacce.php?nNFbd=' + $(val).get(0) + '', '',
                                                    'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }

        });



        $('#email').click(function () {
//            document.getElementById('alertsucesso').style.display = 'Block';
//            document.getElementById('sucesso').innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Enviando Email';

            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {
                    $.ajax({
                        type: "GET",
                        url: "_backend/_controller/_select/_ajax/nfe_select_ajax.php",
                        data: {
                            nfe: $(val).get(0)
                        },
                        dataType: "json",
                        success: function (data)
                        {
                            if (data[0].destEmail !== '') {
                                $("#emailnfe").val(data[0].destEmail);
                            }
                        }
                    });



                    $("#memail").modal('show');
                    $("#nnfemail").val($(val).get(0));
//                EnviaEmail($(val).get(0));
                }
            }
        });

        $('#duplicar').click(function () {
//            document.getElementById('alertsucesso').style.display = 'Block';
//            document.getElementById('sucesso').innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Enviando Email';

            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {
                    $("#duplicanfe").modal('show');
                    $("#NFnro").val($(val).get(0));
//                Duplicar($(val).get(0));
                }
            }
        });

        $('#etiqueta').click(function () {
            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                GeraEtiqueta($(val).get(0));
//                Duplicar($(val).get(0));
            }
        });
        
        
     $('#devolucao').click(function() {

            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {
                    Carrega('_view', 'cria_devolucao_produtos.php?nfe=' + $(val).get(0), 'Produtos para devolver');
                }
            }
        });
        
        

        $('#retorno').click(function () {
//            document.getElementById('alertsucesso').style.display = 'Block';
//            document.getElementById('sucesso').innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Enviando Email';

            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {
                    Retorno($(val).get(0));
                }
            }
        });


        $('#btnemail').click(function () {
            document.getElementById('alertsucesso').style.display = 'Block';
            document.getElementById('sucesso').innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Enviando Email';
            setTimeout(function () {
                $("#alertsucesso").css("display", "none");
            }, 4000);
            var nct = $("#nnfemail").val();
            var email = $("#emailnfe").val();
            EnviaEmail(nct, email);
            $("#memail").modal('hide');
        });


        function EnviaEmail(nct, valor) {
            $.ajax({
                type: "GET",
                url: "<?= LINK ?>/_fiscal/_mail/geracao/envia_nfe.php",
                data: {
                    arquivo: nct,
                    email: valor
                },
                dataType: "json",
                success: function (data)
                {
                    if (data.status == 'OK') {
                        toastr.success(data.msg);
                    } else {
                        toastr.warning(data.msg);
                    }
                }
            });
        }





        function Retorno(valor) {
            $.ajax({
                type: "GET",
                url: "<?= BACKEND ?>/_controller/_select/_ajax/duplica_retorno_select_ajax.php",
                data: {
                    nfe: valor
                },
                dataType: "json",
                success: function (data)
                {
                    if (data.status == 'OK') {
                        Carrega('_grid', 'nfe_grid.php', 'NF-E');
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html(data.msg);
                        setTimeout(function () {
                            $("#alertsucesso").css("display", "none");
                        }, 3000);
                    } else {
                        toastr.warning(data.msg);
                    }
                }
            });
        }


        $('#exportar').click(function () {
            var val = new Array();
            $('.DeleteRow:checked').each(function () {
                val.push($(this).val());
            });
            if (val == '') {
                $("#download").modal('show');
            } else {

                $.ajax({
                    type: "GET",
                    url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                    data: {
                        nfe: $(val).get(0)
                    },
                    dataType: "json",
                    success: function (data)
                    {
                        if (data[0].status == '') {
                            document.getElementById("alerterro").style.display = "block";
                            document.getElementById("alertsucesso").style.display = "none";
                            $("#erro").html('Nota Fiscal Não Autorizada a exportar XML!');
                            setTimeout(function () {
                                $("#alerterro").css("display", "none");
                            }, 3000);
                        } else {
                            window.open('<?= LINK ?>/_fiscal/_nfe/geracao/xml_download.php?arquivo=' + $(val).get(0) + '', '',
                                    'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
                        }
                    }
                });
            }

        });
        function Deletar(valor, doc) {

            $.ajax({
                type: "GET",
                url: "_backend/_controller/_delete/nfe_delete.php",
                data: {
                    nNF: valor
                },
                dataType: "json",
                success: function (data)
                {
                    if (data.retorno == true) {
                        Carrega('_grid', 'nfe_grid.php', 'Nota Fiscal');
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html(data.mensagem);
                        setTimeout(function () {
                            $("#alertsucesso").css("display", "none");
                        }, 3000);

                        ExcluiDoc(doc);

                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html(data.mensagem);
                        setTimeout(function () {
                            $("#alerterro").css("display", "none");
                        }, 3000);
                    }
                }
            });
        }

        //        $('#employee-grid-nfe tbody').on('dblclick', 'tr', function () {
        //            var data = dataTable.row(this).data();
        //            //            alert(data[1] + ' ' + data[4] + ' ' + data[6] + ' ' + data[10]);
        //            location.assign('/operacao.php?fm=' + data[10] + '&nfe=' + data[4] + '&ct=' + data[6] + '&operacaoid=' + data[1]);
        ////            AbreModal(data[1], data[4], data[6], data[10]);
        //        });
    });



    function GeraNFeView(valor) {
        //            alert(valor);
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/gera_nfe.php?nNF=" + valor,
            //                data: {
            //                    nfe: valor
            //                },
            dataType: "xml",
            success: function (retorno)
            {
                // alert(status);
                var status = $(retorno).find("status").text();
                // alert(status);

                if (status == 'ok') {
                    window.open('<?= LINK ?>/_fiscal/_prints/geracao/danfe.php?nNFbd=' + valor + '', '',
                                'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
                } else {
                    
                    // Obtenha o motivo e a correção do XML
                    var campoErro = $(retorno).find("campo").text();
                    var motivo = $(retorno).find("motivo").text();
                    var correcao = $(retorno).find("correcao").text();
                    var numItem = $(retorno).find("numItem").text();

                    var itemInfo = "";
                    if(numItem != 0) {
                        itemInfo = `<p>Nº do item com problemas: <strong>Item:${numItem}</strong></p>`;
                    }

                    var campoInfo = "";
                    if(campoErro) {
                        campoInfo = `<p>Erro: ${campoErro}</p>`;
                    }

                    // Formate o conteúdo com classes CSS
                    var htmlContent = `
                        <div class="alert alert-danger">
                            <p class="text-danger"><strong>Não foi possível imprimir</strong></p>
                            <p class="text-danger"><strong>${motivo}</strong></p>
                            ${campoInfo}
                            ${itemInfo}
                            <p><strong>Correção:</strong> ${correcao}</p>
                        </div>
                    `;

                    bootbox.alert(htmlContent);
                }
            }
        });
    }


    function GeraNFceOFF(valor) {
        //            alert(valor);
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/gera_nfce_offline.php?nNF=" + valor,
            //                data: {
            //                    nfe: valor
            //                },
            dataType: "xml",
            success: function (retorno)
            {
                var status = $(retorno).find("status").text();
                if (status == 'erro') {
                    $("#lote" + valor + "").toggleClass('text-danger');
                    document.getElementById("lote" + valor + "").innerHTML = $(retorno).find("erro").text();
                } else {
//                alert(status);
                    AssinaNFCECont(valor);
                }
            }
        });
    }


    function GeraNFe(valor) {
        //            alert(valor);
        document.getElementById("lote" + valor + "").innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Aguarde Gerando XML';
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/gera_nfe.php?nNF=" + valor,
            dataType: "xml",
            success: function (retorno)
            {

//                alert(status);
                var status = $(retorno).find("status").text();
//                alert(status);

                if (status == 'ok') {
                    AssinaNFE(valor);
                } else {

                    // Obtenha o motivo e a correção do XML
                    var campoErro = $(retorno).find("campo").text();
                    var motivo = $(retorno).find("motivo").text();
                    var correcao = $(retorno).find("correcao").text();
                    var numItem = $(retorno).find("numItem").text();

                    var itemInfo = "";
                    if(numItem != 0) {
                        itemInfo = `<p>Nº do item com problemas: <strong>Item:${numItem}</strong></p>`;
                    }

                    var campoInfo = "";
                    if(campoErro) {
                        campoInfo = `<p>Erro: ${campoErro}</p>`;
                    }

                    // Formate o conteúdo com classes CSS
                    var htmlContent = `
                        <div class="alert alert-danger">
                            <p class="text-danger"><strong>${motivo}</strong></p>
                            ${campoInfo}
                            ${itemInfo}
                            <p><strong>Correção:</strong> ${correcao}</p>
                        </div>
                    `;

                    // Insira o conteúdo formatado no elemento
                    $("#lote" + valor).html(htmlContent);
                }
            }
        });
    }

    function GeraNFce(valor) {
        var url = "<?= LINK ?>/_fiscal/_nfe/geracao/gera_nfce.php?nNF=" + valor;

        //            alert(valor);
        document.getElementById("lote" + valor + "").innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Aguarde Gerando XML';
        $.ajax({
            type: "GET",
            url: url,
            dataType: "xml",
            success: function (retorno)
            {
//                alert(status);
                var status = $(retorno).find("status").text();
                //alert(status);
                if (status == 'ok') {
                    AssinaNFcE(valor);
                } else {
                    // Obtenha o motivo e a correção do XML
                    var campoErro = $(retorno).find("campo").text();
                    var motivo = $(retorno).find("motivo").text();
                    var correcao = $(retorno).find("correcao").text();
                    var numItem = $(retorno).find("numItem").text();

                    var itemInfo = "";
                    if(numItem != 0) {
                        itemInfo = `<p>Nº do item com problemas: <strong>Item:${numItem}</strong></p>`;
                    }

                    var campoInfo = "";
                    if(campoErro) {
                        campoInfo = `<p>Erro: ${campoErro}</p>`;
                    }

                    // Formate o conteúdo com classes CSS
                    var htmlContent = `
                        <div class="alert alert-danger">
                            <p class="text-danger"><strong>${motivo}</strong></p>
                            ${campoInfo}
                            ${itemInfo}
                            <p><strong>Correção:</strong> ${correcao}</p>
                        </div>
                    `;

                    // Insira o conteúdo formatado no elemento
                    $("#lote" + valor).html(htmlContent);
                }
            }
        });
    }

    function SituacaoNFeA3() {
        // alert("OK");
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_backend/_controller/_select/a3/nfe_select_situacao.php",
            dataType: "json",
            success: function (data)
            {
                if (data.situacao == 'S') {
                    document.getElementById('alertsucesso').style.display = 'None';
                    Carrega('_grid', 'nfe_grid.php', 'NF-e');
                } else {
                    setTimeout(function () {
                        SituacaoNFeA3();
                    }, 3000);
                }
            }
        });
    }

    function AssinaNFE(valor) {
        //            alert(valor);
        document.getElementById("lote" + valor + "").innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Assinando XML';
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/assina_nfe.php",
            data: {
                arquivo: valor
            },
            dataType: "xml",
            success: function (retorno)
            {
                var status = $(retorno).find("status").text();
                if (status == 'OK') {
                    TransmiteNFE(valor);
                } else {
                    // Obtenha o motivo e a correção do XML
                    var codigoErro = $(retorno).find("cod").text();
                    var motivo = $(retorno).find("motivo").text();
                    var correcao = $(retorno).find("correcao").text();
                    var numItem = $(retorno).find("numItem").text();

                    var itemInfo = numItem ? `<p>Nº do item com problemas: <strong>Item:${numItem}</strong></p>` : "";

                    // Formate o conteúdo com classes CSS
                    var htmlContent = `
                        <div class="alert alert-danger">
                            <p class="text-danger"><strong>${motivo}.</strong></p>
                            ${itemInfo}
                            <p><strong>Correção:</strong> ${correcao}</p>
                        </div>
                    `;

                    // Insira o conteúdo formatado no elemento
                    $("#lote" + valor).html(htmlContent);
                }
            }
        });
    }

    function AssinaNFCECont(valor) {
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/assina_nfce.php",
            data: {
                arquivo: valor
            },
            dataType: "xml",
            success: function (retorno)
            {
                var status = $(retorno).find("status").text();
                if (status == 'OK') {
                    window.open('<?= LINK ?>/_fiscal/_prints/geracao/danfce.php?nNFbd=' + valor + '', '',
                            'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');

                } else {
                    // Obtenha o motivo e a correção do XML
                    var motivo = $(retorno).find("motivo").text();
                    var correcao = $(retorno).find("correcao").text();
                    var numItem = $(retorno).find("numItem").text();

                    var itemInfo = numItem ? `<p>Nº do item com problemas: <strong>Item:${numItem}</strong></p>` : "";

                    // Formate o conteúdo com classes CSS
                    var htmlContent = `
                        <div class="alert alert-danger">
                            <p class="text-danger"><strong>${motivo}.</strong></p>
                            ${itemInfo}
                            <p><strong>Correção:</strong> ${correcao}</p>
                        </div>
                    `;

                    // Insira o conteúdo formatado no elemento
                    $("#lote" + valor).html(htmlContent);
                }
            }
        });
    }

    function AssinaNFcE(valor) {
        //            alert(valor);
        document.getElementById("lote" + valor + "").innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Assinando XML';
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/assina_nfce.php",
            data: {
                arquivo: valor
            },
            dataType: "xml",
            success: function (retorno)
            {
                var status = $(retorno).find("status").text();
                if (status == 'OK') {
                    TransmiteNFcE(valor);
                } else {
                    // Obtenha o motivo e a correção do XML
                    var codigoErro = $(retorno).find("cod").text();
                    var motivo = $(retorno).find("motivo").text();
                    var correcao = $(retorno).find("correcao").text();
                    var numItem = $(retorno).find("numItem").text();

                    var itemInfo = numItem ? `<p>Nº do item com problemas: <strong>Item:${numItem}</strong></p>` : "";

                    // Formate o conteúdo com classes CSS
                    var htmlContent = `
                        <div class="alert alert-danger">
                            <h4>Erro</h4>
                            <p class="text-danger"><strong>${motivo}.</strong></p>
                            ${itemInfo}
                            <p><strong>Correção:</strong> ${correcao}</p>
                        </div>
                    `;

                    // Insira o conteúdo formatado no elemento
                    $("#lote" + valor).html(htmlContent);
                }
            }
        });
    }

    function Transmitebkp(val) {

        $.ajax({
            type: "GET",
            url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
            data: {
                nfe: val
            },
            dataType: "json",
            success: function (data)
            {
                if (data[0].status === '100') {
                    document.getElementById("alerterro").style.display = "none";
                    document.getElementById("alertsucesso").style.display = "block";
                    $("#sucesso").html('<i class="fa fa-exclamation-circle"></i> Nota Fiscal Já APROVADA!');
                    setTimeout(function () {
                        $("#alertsucesso").css("display", "none");
                    }, 3000);
                } else if (data[0].status === '999') {
                    document.getElementById("alerterro").style.display = "block";
                    document.getElementById("alertsucesso").style.display = "none";
                    $("#erro").html('<i class="fa fa-exclamation-circle"></i> Esta Nota Fiscal não pode ser enviada ao sefaz!');
                    setTimeout(function () {
                        $("#alertsucesso").css("display", "none");
                    }, 3000);
                } else {
                    if (data[0].modelo == '55') {
                        GeraNFe(val);
                    } else {
                        GeraNFce(val);
                    }
                }
            }
        });

    }

    function Transmite(val) {
        var opcoes = '<div class="col-md-12">'
                + '<div class="panel panel-default">'
                + '<div class="panel-heading" id="titlelote' + val + '"></div>'
                + '<div class="panel-body">'
                + '<div class="row">'
                + '<div class="col-md-12" id="lote' + val + '">'
                + '</div>'
                + '</div>'
                + '</div>'
                + '</div>'
                + '</div>';

        $("#recebelote").append(opcoes);

        $.ajax({
            type: "GET",
            url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
            data: {
                nfe: val
            },
            dataType: "json",
            success: function (data)
            {

                $("#titlelote" + val + "").html('Número ' + data[0].nNF + ' - ' + data[0].destxNome + '');
                if (data[0].status === '100') {
                    $("#lote" + val + "").html('<i class="fa fa-exclamation-circle"></i> Nota Fiscal Já APROVADA!');
                } else if (data[0].status === '999') {
                    $("#lote" + val + "").html('<i class="fa fa-exclamation-circle"></i> Esta Nota Fiscal não pode ser enviada ao sefaz!');
                } else {
                    if (data[0].modelo === '55') {
                        ConsultaChaveGeraNFe(val);
                    } else {
                        ConsultaChaveGera(val);
//                        GeraNFce(val);
                    }
                }
            }
        });

    }

    function ConsultaChaveGeraNFe(val) {
        var opcoes = '<div class="col-md-12">'
                + '<div class="panel panel-default">'
                + '<div class="panel-heading" id="titlelote' + val + '"></div>'
                + '<div class="panel-body">'
                + '<div class="row">'
                + '<div class="col-md-12" id="lote' + val + '">'
                + '</div>'
                + '</div>'
                + '</div>'
                + '</div>'
                + '</div>';

        $("#recebelote").append(opcoes);

        $.ajax({
            type: "GET",
            url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
            data: {
                nfe: val
            },
            dataType: "json",
            success: function (data)
            {

                $("#titlelote" + val + "").html('Número ' + data[0].nNF + ' - ' + data[0].destxNome + '');
                if (data[0].status === '100') {
                    $("#lote" + val + "").html('<i class="fa fa-exclamation-circle"></i> Nota Fiscal Já APROVADA!');
                } else if (data[0].status === '999') {
                    $("#lote" + val + "").html('<i class="fa fa-exclamation-circle"></i> Esta Nota Fiscal não pode ser enviada ao sefaz!');
                } else if (data[0].chavenfe === '') {
                    GeraNFe(val);
                } else {
                    ConsultaChaveNFe(val);
                }
            }
        });

    }


    function ConsultaChaveGera(val) {
        var opcoes = '<div class="col-md-12">'
                + '<div class="panel panel-default">'
                + '<div class="panel-heading" id="titlelote' + val + '"></div>'
                + '<div class="panel-body">'
                + '<div class="row">'
                + '<div class="col-md-12" id="lote' + val + '">'
                + '</div>'
                + '</div>'
                + '</div>'
                + '</div>'
                + '</div>';

        $("#recebelote").append(opcoes);

        $.ajax({
            type: "GET",
            url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
            data: {
                nfe: val
            },
            dataType: "json",
            success: function (data)
            {

                $("#titlelote" + val + "").html('Número ' + data[0].nNF + ' - ' + data[0].destxNome + '');
                if (data[0].status === '100') {
                    $("#lote" + val + "").html('<i class="fa fa-exclamation-circle"></i> Nota Fiscal Já APROVADA!');
                } else if (data[0].status === '999') {
                    $("#lote" + val + "").html('<i class="fa fa-exclamation-circle"></i> Esta Nota Fiscal não pode ser enviada ao sefaz!');
                } else if (data[0].chavenfe === '') {
                    GeraNFce(val);
                } else {
                    ConsultaChave(val);
                }
            }
        });

    }

    function ConsultaChaveTrnasmite(val) {
        var opcoes = '<div class="col-md-12">'
                + '<div class="panel panel-default">'
                + '<div class="panel-heading" id="titlelote' + val + '"></div>'
                + '<div class="panel-body">'
                + '<div class="row">'
                + '<div class="col-md-12" id="lote' + val + '">'
                + '</div>'
                + '</div>'
                + '</div>'
                + '</div>'
                + '</div>';

        $("#recebelote").append(opcoes);

        $.ajax({
            type: "GET",
            url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
            data: {
                nfe: val
            },
            dataType: "json",
            success: function (data)
            {

                $("#titlelote" + val + "").html('Número ' + data[0].nNF + ' - ' + data[0].destxNome + '');
                if (data[0].status === '100') {
                    $("#lote" + val + "").html('<i class="fa fa-exclamation-circle"></i> Nota Fiscal Já APROVADA!');
                } else if (data[0].status === '999') {
                    $("#lote" + val + "").html('<i class="fa fa-exclamation-circle"></i> Esta Nota Fiscal não pode ser enviada ao sefaz!');
                } else {
                    ConsultaChave(val);
                }
            }
        });

    }

    function TransmiteNFE(valor) {
        //            alert(valor);
<?php
if ($emitente->contigenciaNFe == 'N') :
    $url = 'envia_nfe';
else :
    $url = 'envia_nfe_contigencia';
endif;
?>


        document.getElementById("lote" + valor + "").innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Enviando XML ao Sefaz';
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/<?= $url ?>.php?arquivo=" + valor,
            dataType: "xml",
            success: function (retorno)
            {
                var status = $(retorno).find("status").text();
                if (status == 'OK') {
                    RetornoNFE($(retorno).find("recibo").text(), valor);
                } else {
                    document.getElementById("lote" + valor + "").innerHTML = $(retorno).find("motivo").text();
                }
            }
        });
    }

    function TransmiteNFcE(valor) {
        //            alert(valor);
        var uf = "<?= $emitente->UF ?>";
        if (uf === 'PR') {
            var url = "<?= LINK ?>/_fiscal/_nfe/geracao_pa/envia_nfce.php?arquivo=" + valor;
        } else {
            var url = "<?= LINK ?>/_fiscal/_nfe/geracao/envia_nfce.php?arquivo=" + valor;
        }

        document.getElementById("lote" + valor + "").innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Enviando XML ao Sefaz';
        $.ajax({
            type: "GET",
//            url: "<?= LINK ?>/_fiscal/_nfe/geracao/envia_nfce.php?arquivo=" + valor,
            url: url,
            dataType: "xml",
            success: function (retorno)
            {
                var status = $(retorno).find("status").text();
                if (status == 'OK') {
                    RetornoNFcE($(retorno).find("recibo").text(), valor);
                } else {
                    // Obtenha o motivo e a correção do XML
                    var codigoErro = $(retorno).find("cod").text();
                    var motivo = $(retorno).find("motivo").text();
                    var correcao = $(retorno).find("correcao").text();
                    var numItem = $(retorno).find("numItem").text();

                    if (codigoErro === '483' || codigoErro === '537') {
                        DescontoAlteraNFe(valor);
                        return false;
                    }

                    var itemInfo = numItem ? `<p>Nº do item com problemas: <strong>Item: ${numItem}</strong></p>` : "";

                    // Formate o conteúdo com classes CSS
                    var htmlContent = `
                        <div class="alert alert-danger">
                            <p class="text-danger"><strong>${motivo}.</strong> Erro: ${codigoErro}</p>
                            ${itemInfo}
                            <p><strong>Correção:</strong> ${correcao}</p>
                        </div>
                    `;

                    // Insira o conteúdo formatado no elemento
                    $("#lote" + valor).html(htmlContent);

                    // $('#employee-grid-nfe').DataTable().ajax.reload();
                }
            }
        });
    }


    function addProt(valor, recibo) {
        //            alert(valor);
        document.getElementById('alertsucesso').style.display = 'Block';
        document.getElementById('sucesso').innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Adicionando Protocolo';
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/add_protocolo.php?arquivo=" + valor + "&recibo=" + recibo,
            //                data: {
            //                    nfe: valor
            //                },
            dataType: "json",
            success: function (data)
            {
                if (data.Status == 'Ok') {
//                    EnviaEmail(valor);
                    document.getElementById('alertsucesso').style.display = 'None';
                    Carrega('_grid', 'nfe_grid.php', 'NF-e');
                    window.open('<?= LINK ?>/_fiscal/_nfe/geracao/danfe.php?arquivo=' + valor + '', '',
                            'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
                    //                location.reload();
                } else {
                    toastr.warning('Erro ao Adicionar Protocolo.');
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                if (jqXHR.responseText) {

                    var str = jqXHR.responseText;
                    var retorno = jQuery.parseJSON(str.substr(3));

                    if (retorno.Status == 'Ok') {
                        document.getElementById('alertsucesso').style.display = 'None';
                        Carrega('_grid', 'nfe_grid.php', 'NF-e');
                        window.open('<?= LINK ?>/_fiscal/_nfe/geracao/Danfe.php?arquivo=' + valor + '', '',
                                'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');

                    } else {
                        toastr.warning('Erro ao Adicionar Protocolo.');
                    }

                }

            }
        });
    }

    function addCanc(valor) {
        //            alert(valor);
        document.getElementById('alertsucesso').style.display = 'Block';
        document.getElementById('sucesso').innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Adicionando Cancelamento ao XML';
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/addCanc.php?arquivo=" + valor,
            //                data: {
            //                    nfe: valor
            //                },
            dataType: "json",
            success: function (data)
            {
                if (data.Status == 'Ok') {
                    document.getElementById('alertsucesso').style.display = 'None';
                    Carrega('_grid', 'nfe_grid.php', 'NF-e');
                    //                location.reload();
                } else {
                    toastr.warning('Erro ao Adicionar Protocolo.');
                }
            }
        });
    }


    function RetornoNFE(valor, nct) {
        //            alert(valor);
        document.getElementById("lote" + nct + "").innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Retornando Dados do Sefaz';
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/consulta_recibo.php?arquivo=" + nct,
            dataType: "xml",
            success: function (retorno)
            {
                var status = $(retorno).find("status").text();
                if (status === 'OK') {
//                    Carrega('_grid', 'nfe_grid.php', 'NF-e');
                    window.open('<?= LINK ?>/_fiscal/_prints/geracao/danfe.php?nNFbd=' + nct + '', '',
                            'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
                    $('#employee-grid-nfe').DataTable().ajax.reload();
                    $("#lote" + nct + "").toggleClass('text-success');
                    document.getElementById("lote" + nct + "").innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i> Aprovada, Enviando E-mail.';
                    EnviaEmailAuto(nct);
                } else {

                    // Obtenha o motivo e a correção do XML
                    var codigoErro = $(retorno).find("cod").text();
                    var motivo = $(retorno).find("motivo").text();
                    var correcao = $(retorno).find("correcao").text();
                    var numItem = $(retorno).find("numItem").text();

                    var itemInfo = "";
                    if(numItem != 0) {
                        itemInfo = `<p>Nº do item com problemas: <strong>Item:${numItem}</strong></p>`;
                    }

                    // Formate o conteúdo com classes CSS
                    var htmlContent = `
                        <div class="alert alert-danger">
                            <p class="text-danger"><strong>${motivo}.</strong><br>Erro: ${codigoErro}</p>
                            ${itemInfo}
                            <p><strong>Correção:</strong> ${correcao}</p>
                        </div>
                    `;

                    // Insira o conteúdo formatado no elemento
                    $("#lote" + nct).html(htmlContent);

                    // $('#employee-grid-nfe').DataTable().ajax.reload();

                }
            }
        });
    }


    function ConsultaChaveNFe(nct) {
        //            alert(valor);
        document.getElementById("lote" + nct + "").innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Consultando informações...';
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/consulta_chave_nfe.php?arquivo=" + nct,
            dataType: "xml",
            success: function (retorno)
            {
                var status = $(retorno).find("status").text();
                if (status === 'OK') {
//                    Carrega('_grid', 'nfe_grid.php', 'NF-e');
                    window.open('<?= LINK ?>/_fiscal/_prints/geracao/danfe.php?nNFbd=' + nct + '', '',
                            'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
                    $('#employee-grid-nfe').DataTable().ajax.reload();
                    $("#lote" + nct + "").toggleClass('text-success');
                    document.getElementById("lote" + nct + "").innerHTML = 'Aprovada!';

                } else {

                    GeraNFe(nct);
//                    $("#lote" + nct + "").toggleClass('text-danger');
//                    document.getElementById("lote" + nct + "").innerHTML = $(retorno).find("motivo").text();
//                    $('#employee-grid-nfe').DataTable().ajax.reload();

                }
            }
        });
    }

    function ConsultaChave(nct) {
        //            alert(valor);
        document.getElementById("lote" + nct + "").innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Consultando informações...';
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/consulta_chave_nfce.php?arquivo=" + nct,
            dataType: "xml",
            success: function (retorno)
            {
                var status = $(retorno).find("status").text();
                if (status === 'OK') {
//                    Carrega('_grid', 'nfe_grid.php', 'NF-e');
                    window.open('<?= LINK ?>/_fiscal/_prints/geracao/danfce.php?nNFbd=' + nct + '', '',
                            'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
                    $('#employee-grid-nfe').DataTable().ajax.reload();
                    $("#lote" + nct + "").toggleClass('text-success');
                    document.getElementById("lote" + nct + "").innerHTML = 'Aprovada!';

                } else {

                    GeraNFce(nct);
//                    $("#lote" + nct + "").toggleClass('text-danger');
//                    document.getElementById("lote" + nct + "").innerHTML = $(retorno).find("motivo").text();
//                    $('#employee-grid-nfe').DataTable().ajax.reload();

                }
            }
        });
    }
    function RetornoNFcE(valor, nct) {
        //            alert(valor);
        var uf = "<?= $emitente->UF ?>";
        if (uf === 'PR') {
            var url = "<?= LINK ?>/_fiscal/_nfe/geracao_pa/consulta_recibo_nfce.php?arquivo=" + nct;
        } else {
            var url = "<?= LINK ?>/_fiscal/_nfe/geracao/consulta_recibo_nfce.php?arquivo=" + nct;
        }

        document.getElementById("lote" + nct + "").innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Retornando Dados do Sefaz';
        $.ajax({
            type: "GET",
//            url: "<?= LINK ?>/_fiscal/_nfe/geracao/consulta_recibo_nfce.php?arquivo=" + nct,
            url: url,
            dataType: "xml",
            success: function (retorno)
            {
                var status = $(retorno).find("status").text();
                if (status === 'OK') {
                    window.open('<?= LINK ?>/_fiscal/_prints/geracao/danfce.php?nNFbd=' + nct + '', '',
                            'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
                    $('#employee-grid-nfe').DataTable().ajax.reload();
                    $("#lote" + nct + "").toggleClass('text-success');
                    document.getElementById("lote" + nct + "").innerHTML = 'Aprovada!';
                } else {
                    // Obtenha o motivo e a correção do XML
                    var codigoErro = $(retorno).find("cod").text();
                    var motivo = $(retorno).find("motivo").text();
                    var correcao = $(retorno).find("correcao").text();
                    var numItem = $(retorno).find("numItem").text();

                    var itemInfo = numItem ? `<p>Nº do item com problemas: <strong>Item:${numItem}</strong></p>` : "";

                    // Formate o conteúdo com classes CSS
                    var htmlContent = `
                        <div class="alert alert-danger">
                            <p class="text-danger"><strong>${motivo}.</strong> Erro: ${codigoErro}</p>
                            ${itemInfo}
                            <p><strong>Correção:</strong> ${correcao}</p>
                        </div>
                    `;

                    // Insira o conteúdo formatado no elemento
                    $("#lote" + nct).html(htmlContent);

                    // $('#employee-grid-nfe').DataTable().ajax.reload();
                }
            }
        });
    }

    function ExportaPeriodo() {
        $.ajax({
            type: "POST",
            url: "_fiscal/_nfe/geracao/exporta_xml.php",
            data: {
                datai: $("#datai").val(),
                dataf: $("#dataf").val(),
                modelo: $("#modeloexporta").val(),
                finalidade: $('#finNFe').val(),
                status: $('#status').val()
            },
            dataType: "json",
            success: function (data)
            {
                if (data.retorno === true) {

//                    bootbox.alert("Arquivos exportados!!", function () {
//                        console.log('This was logged in the callback!');
//                    });

                    window.open('<?= LINK ?>/_temp/' + data.arquivo + '.zip', '', '_blank');
                    $("#download").modal('hide');

                } else {
                    bootbox.alert(data.mensagem);
                }
            }
        });
    }


    function AtivaContigencia() {
        $.ajax({
            type: "GET",
            url: "_backend/_controller/_update/ativa_contigencia_update.php",
            dataType: "json",
            success: function (data)
            {
                if (data.retorno === true) {
                    bootbox.confirm({
                        message: data.mensagem, buttons: {
                            confirm: {
                                label: 'Ok',
                                className: 'btn-success'
                            },
                            cancel: {
                                label: 'Fechar',
                                className: 'btn-default'
                            }
                        },
                        callback: function (result) {
                            Carrega('_grid', 'nfe_grid.php', 'Nota Fiscal');
                        }
                    });
                } else {
                    bootbox.alert(data.mensagem);
                }
            }
        });
    }

    function DesativaContigencia() {
        $.ajax({
            type: "GET",
            url: "_backend/_controller/_update/desativa_contigencia_update.php",
            dataType: "json",
            success: function (data)
            {
                if (data.retorno === true) {
                    bootbox.confirm({
                        message: data.mensagem, buttons: {
                            confirm: {
                                label: 'Ok',
                                className: 'btn-success'
                            },
                            cancel: {
                                label: 'Fechar',
                                className: 'btn-default'
                            }
                        },
                        callback: function (result) {
                            Carrega('_grid', 'nfe_grid.php', 'Nota Fiscal');
                        }
                    });
                } else {
                    bootbox.alert(data.mensagem);
                }
            }
        });
    }

    function CancelaDoc(doc) {
        if (doc > 0) {
            $.ajax({
                type: "GET",
                url: "_backend/_controller/_delete/movimentacao_delete.php",
                data: {
                    documento: doc,
                    motivo: 'Nota fiscal Cancelada!'
                },
                dataType: "json",
                success: function (data)
                {
                    if (data.retorno === true) {
                        bootbox.confirm({
                            message: data.mensagem, buttons: {
                                confirm: {
                                    label: 'Ok',
                                    className: 'btn-success'
                                },
                                cancel: {
                                    label: 'Fechar',
                                    className: 'btn-default'
                                }
                            },
                            callback: function (result) {
                                Carrega('_grid', 'nfe_grid.php', 'Nota Fiscal');
                            }
                        });
                    } else {
                        bootbox.alert(data.mensagem)
                    }
                }
            });
        }
    }

    function ExcluiDoc(doc) {
        if (doc > 0) {
            bootbox.confirm({
                message: "Deseja cancelar documento vinculado a nota fiscal?",
                buttons: {
                    confirm: {
                        label: 'Sim',
                        className: 'btn-success'
                    },
                    cancel: {
                        label: 'Não',
                        className: 'btn-danger'
                    }
                },
                callback: function (result) {
                    if (result) {
                        $.ajax({
                            type: "GET",
                            url: "_backend/_controller/_delete/movimentacao_delete.php",
                            data: {
                                documento: doc,
                                motivo: 'Nota fiscal excluida!'
                            },
                            dataType: "json",
                            success: function (data)
                            {
                                if (data.retorno === true) {
                                    bootbox.confirm({
                                        message: data.mensagem, buttons: {
                                            confirm: {
                                                label: 'Ok',
                                                className: 'btn-success'
                                            },
                                            cancel: {
                                                label: 'Fechar',
                                                className: 'btn-default'
                                            }
                                        },
                                        callback: function (result) {
                                            Carrega('_grid', 'nfe_grid.php', 'Nota Fiscal');
                                        }
                                    });
                                } else {
                                    bootbox.alert(data.mensagem)
                                }
                            }
                        });
                    }
                }
            });

        }
    }


    function EnviaEmailAuto(nct) {
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_mail/geracao/envia_nfe_automatico.php",
            data: {
                arquivo: nct
            },
            dataType: "xml",
            success: function (retorno)
            {
                var status = $(retorno).find("status").text();
                if (status === 'Erro') {
                    $("#lote" + nct + "").toggleClass('text-success');
                    document.getElementById("lote" + nct + "").innerHTML = $(retorno).find("motivo").text();
                } else {
                    document.getElementById("lote" + nct + "").innerHTML = $(retorno).find("motivo").text();
                }
            }
        });
    }


    function EnviaBoleto(nct) {
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/email/conteudo/boleto.php",
            data: {
                arquivo: nct
            },
            dataType: "json",
            success: function (data)
            {
                if (data.status == 'OK') {
                    toastr.success(data.msg);
                } else {
                    toastr.warning(data.msg);
                }
            }
        });
    }

</script>


<div class="modal fade" id="envioLote" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title"> Envio de NF-e/NFC-e em lote </h4>
            </div>

            <div class="modal-body" > 
                <div class="row" id="recebelote">

                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
            </div>
        </div>

        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<div class="modal fade" id="download" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title"> EXPORTAR XML </h4>
            </div>
            <?php
            $P_Dia_Mes_Anterior = date("01/m/Y", strtotime("-1 month"));
            $U_Dia_Mes_Anterior = date("t/m/Y", strtotime("-1 month"));
            ?>
            <div class="modal-body" > 
                <div class="row">
                    <div class="col-md-4">
                        <label id="tdn">Início</label>
                        <input name="datai" id="datai" type="text" value="<?= $P_Dia_Mes_Anterior ?>" required="" onkeypress="mascara(this, mdata);" maxlength="10" class="form-control" placeholder=""> 
                    </div>
                    <div class="col-md-4">
                        <label id="tdn">Fim</label>
                        <input name="dataf" id="dataf" type="text" required="" value="<?= $U_Dia_Mes_Anterior ?>" onkeypress="mascara(this, mdata);" maxlength="10" class="form-control" placeholder=""> 
                    </div>

                    <div class="col-md-4">
                        <label>Modelo </label>
                        <select name="modelo" id="modeloexporta" class="form-control">
                            <option value="55">NF-e</option>
                            <option value="65">NFC-e</option>
                        </select>
                    </div>


                </div>

                <div class="row">

                    <div class="col-md-6">
                        <label>Status</label>
                        <select name="status" class="form-control" required="" id="status">
                            <option value="T"> Todas</option>
                            <option value="100"> Aprovadas</option>
                            <option value="101"> Canceladas</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label>Finalidade</label>
                        <select name="finNFe" class="form-control" required="" id="finNFe">
                            <option value="T"> Todas</option>
                            <option value="1"> Normal</option>
                            <option value="2"> Complementar</option>
                            <option value="3"> Ajuste</option>
                            <option value="4"> Devolução de Merc.</option>

                        </select>
                    </div>

                </div>

            </div>

            <div class="modal-footer">
                <button onclick="ExportaPeriodo()" class="btn green">Exportar</button>
            </div>
        </div>

        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<div class="modal fade" id="cancelamento" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-full">
        <?php
        if ($emitente->certificado == 'A3') :
            ?>
            <form id="formcancelamentoa3"  method="GET">

                <?php
            else :
                ?>
                <form id="formcancelamento"  method="GET">

                <?php
                endif;
                ?>

                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                        <h4 class="modal-title"> Cancelar <span id="titlecancela"> NF-E </span> </h4>
                    </div>

                    <div class="modal-body" > 
                        <input type="hidden" name="nNF" id="nNFCancela">
                        <input type="hidden" name="modelo" id="modelo">
                        <input type="hidden" name="documento" id="documento">

                        <div class="row">
                            <div class="col-md-12">
                                <textarea required="" placeholder="Justificativa" name="justificativa" class="form-control" minlength="15" maxlength="250"></textarea>
                            </div>
                        </div>


                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="btncancelar" class="btn green"><i id="aguardecanc" style="display: none;" class="fa fa-spinner fa-spin fa-1x fa-fw"></i>Cancelar NF-e</button>
                    </div>
                </div>
            </form>

            <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>


<div class="modal fade" id="certificado" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-full">
        <form id="formcertificado"  method="GET">

            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h4 class="modal-title"> Senha do Certificado Digital </h4>
                </div>

                <div class="modal-body" > 
                    <div class="row">
                        <input type="hidden" id="nfcertificado" name="nfe">
                        <div class="col-md-12">
                            <input type="password" name="senha" class="form-control"> 
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" id="btncancelar" class="btn green">Transmitir NF-e</button>
                </div>
            </div>
        </form>

        <!-- /.modal-content -->
    </div>
</div>
<!-- /.modal-dialog -->


<div class="modal fade" id="cartacorrecao" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-full">
        <form id="formcce" action="" method="GET">

            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h4 class="modal-title"> Carta de Correção NF-E </h4>
                </div>

                <div class="modal-body" > 
                    <input type="hidden" name="nNF" id="nNFCce">


                    <div class="row">
                        <div class="col-md-4">
                            <label>Nº Da CCe</label>
                            <select name="evento" id="eventoccs" class="form-control">
                                <option value="1">1ª</option>
                                <option value="2">2ª</option>
                                <option value="3">3ª</option>
                            </select>
                        </div>
                    </div>




                    <div class="row">
                        <div class="col-md-12">
                            <Br/>
                            <textarea required="" placeholder="Correção" name="correcao" class="form-control" minlength="15" maxlength="350"></textarea>
                        </div>
                    </div>




                </div>
                <div class="modal-footer">
                    <button type="submit" id="btncce" class="btn green"><i id="aguardecce" style="display: none;" class="fa fa-spinner fa-spin fa-1x fa-fw"></i> Corrigir NF-e</button>
                </div>
            </div>
        </form>

        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<!--inutilização-->
<?php
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'emitente');
$sql = 'SELECT ativaserie, seriepadrao from emitente WHERE emitenteid = ' . $_SESSION['Empresa'];
$arrayParam = '';
$dadosSerieNf = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
?>
<div class="modal fade" id="inutilizacao" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <form id="forminutiliza" action="" method="GET">

            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h4 class="modal-title"> Inutilização de Numeração NF-E </h4>
                </div>

                <div class="modal-body" > 
                    <div class="row">
                    <?php
                        // Se usa mais de uma série, mostra opção de digitar a série para inutilizar
                        if ($dadosSerieNf->ativaserie == 'S') :
                        ?>
                        <div class="col-md-6">
                            <label>Modelo <span class="text-danger">*</span></label>
                            <select name="modelo" class="form-control">
                                <option value="55">55 NF-e ( NOTA FISCAL ELETRÔNICA )</option>
                                <option value="65">65 NFC-e ( NOTA FISCAL DO CONSUMIDOR )</option>
                            </select>
                        </div>

                        <div class="col-md-2">
                            <label>Série <span class="text-danger">*</span></label>
                            <input name="nSerie" maxlength="9" type="text" required="" class="form-control"
                                placeholder="">
                        </div>

                        <div class="col-md-2">
                            <label>Número Inicial <span class="text-danger">*</span></label>
                            <input name="nIni" maxlength="9" type="text" required="" class="form-control"
                                placeholder="">
                        </div>

                        <div class="col-md-2">
                            <label>Número Final <span class="text-danger">*</span></label>
                            <input name="nFin" maxlength="9" type="text" required="" class="form-control"
                                placeholder="">
                        </div>

                        <?php
                        // Se não usar mais de uma série, usa a série padrão
                        else:
                        ?>

                        <div class="col-md-4">
                            <label>Modelo <span class="text-danger">*</span></label>
                            <select name="modelo" class="form-control">
                                <option value="55">55 NF-e ( NOTA FISCAL ELETRÔNICA )</option>
                                <option value="65">65 NFC-e ( NOTA FISCAL DO CONSUMIDOR )</option>
                            </select>
                        </div>
                        
                       


 <div class="col-md-2">
                            <label>Série <span class="text-danger">*</span></label>
                            <input name="nSerie" maxlength="9" type="text" required="" value="<?= $dadosSerieNf->seriepadrao?>" class="form-control"
                                placeholder="">
                        </div>
                        
                        <div class="col-md-3">
                            <label>Número Inicial <span class="text-danger">*</span></label>
                            <input name="nIni" maxlength="9" type="text" required="" class="form-control"
                                placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>Número Final <span class="text-danger">*</span></label>
                            <input name="nFin" maxlength="9" type="text" required="" class="form-control"
                                placeholder="">
                        </div>
                        <?php
                        endif;
                        ?>

                    </div>
                    <hr/>
                    <div class="row">
                        <div class="col-md-12">
                            <textarea required="" placeholder="Justificativa" name="xJust" class="form-control" minlength="15" maxlength="350"></textarea>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="submit" id="btninutiliza" class="btn green"><i id="aguardeinutiliza" style="display: none;" class="fa fa-spinner fa-spin fa-1x fa-fw"></i> Inutilizar </button>
                </div>
            </div>
        </form>

        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>


<script>

    $(document).ready(function () {
        $('#forminutiliza').submit(function () {
            $('#aguardeinutiliza').show();
            $("#btninutiliza").prop("disabled", true);
            var dados = $(this).serialize();
            $.ajax({
                type: "GET",
                url: "<?= LINK ?>/_fiscal/_nfe/geracao/inutiliza_nfe.php",
                data: dados,
                dataType: "xml",
                success: function (retorno)
                {

                    var status = $(retorno).find("status").text();
                    if (status === 'OK') {
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html($(retorno).find("motivo").text());
                        $("#inutilizacao").modal('hide');
                        $(".modal-backdrop").css("display", "none");
                        document.getElementById("forminutiliza").reset();
                        setTimeout(function () {
                            $("#alertsucesso").css("display", "none");
                        }, 6000);
                        $('#aguardeinutiliza').hide();
                        $("#btninutiliza").prop("disabled", false);
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html($(retorno).find("motivo").text());
                        $("#inutilizacao").modal('hide');
                        $(".modal-backdrop").css("display", "none");
                        $('#aguardeinutiliza').hide();
                        $("#btninutiliza").prop("disabled", false);
                        setTimeout(function () {
                            $("#alerterro").css("display", "none");
                        }, 6000);
                    }

                }
            });
            return false;
        });


        $('#formcertificado').submit(function () {
            var dados = $(this).serialize();
            $.ajax({
                type: "GET",
                url: "_backend/_controller/_select/_ajax/verifica_senha_select_ajax.php",
                data: dados,
                dataType: "json",
                success: function (data)
                {
                    if (data.retorno == true) {
                        Transmite(data.nfe);
                        $("#certificado").modal('hide');
                    } else {
                        alert("Senha do Certificado Invalida");
                    }
                }
            });
            return false;
        });

        $('#formcancelamentoa3').submit(function () {
            $('#aguardecanc').show();
            $("#btncancelar").prop("disabled", true);
            var dados = $(this).serialize();
            $.ajax({
                type: "GET",
                url: "<?= LINK ?>/_fiscal/_nfe/geracao/cancela_a3_nfe.php",
                data: dados,
                dataType: "xml",
                success: function (retorno)
                {

                    var status = $(retorno).find("status").text();
                    if (status == 'OK') {
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html($(retorno).find("motivo").text());
                        $("#cancelamento").modal('hide');
                        $(".modal-backdrop").css("display", "none");
                        document.getElementById("formcancelamentoa3").reset();
                        setTimeout(function () {
                            $("#alertsucesso").css("display", "none");
                        }, 4000);
                        $('#aguardecanc').hide();
                        $("#btncancelar").prop("disabled", false);
                        //                        Carrega('_grid', 'nfe_grid.php', 'NF-e');
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html($(retorno).find("motivo").text());
                        $("#cancelamento").modal('hide');
                        $("#cartacorrecao").modal('hide');
                        $(".modal-backdrop").css("display", "none");
                        $('#aguardecanc').hide();
                        $("#btncancelar").prop("disabled", false);
                        setTimeout(function () {
                            $("#alerterro").css("display", "none");
                        }, 4000);
                    }
                }
            });
            SituacaoNFeA3();
            return false;
        });

        $('#formcancelamento').submit(function () {
            $('#aguardecanc').show();
            $("#btncancelar").prop("disabled", true);
            var dados = $(this).serialize();
            $.ajax({
                type: "GET",
                url: "<?= LINK ?>/_fiscal/_nfe/geracao/cancela_nfe.php",
                data: dados,
                dataType: "xml",
                success: function (retorno)
                {

                    var status = $(retorno).find("status").text();
                    if (status == 'OK') {
                        var doc = $("#documento").val();
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html($(retorno).find("motivo").text());
                        $("#cancelamento").modal('hide');
                        $(".modal-backdrop").css("display", "none");
                        document.getElementById("formcancelamento").reset();
                        setTimeout(function () {
                            $("#alertsucesso").css("display", "none");
                        }, 4000);
                        $('#aguardecanc').hide();
                        $("#btncancelar").prop("disabled", false);
                        CancelaDoc(doc);
                        Carrega('_grid', 'nfe_grid.php', 'Nota Fiscal');
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html($(retorno).find("motivo").text());
                        $("#cancelamento").modal('hide');
                        $("#cartacorrecao").modal('hide');
                        $(".modal-backdrop").css("display", "none");
                        $('#aguardecanc').hide();
                        $("#btncancelar").prop("disabled", false);
                        setTimeout(function () {
                            $("#alerterro").css("display", "none");
                        }, 4000);
                    }
                }
            });
            return false;
        });

        $('#formcce').submit(function () {
            $('#aguardecce').show();
            $("#btncce").prop("disabled", true);
            var dados = $(this).serialize();
            $.ajax({
                type: "GET",
                url: "<?= LINK ?>/_fiscal/_nfe/geracao/cce_nfe.php",
                data: dados,
                dataType: "xml",
                success: function (retorno)
                {
                    var status = $(retorno).find("status").text();
                    if (status == 'OK') {
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html($(retorno).find("motivo").text());
                        $("#cartacorrecao").modal('hide');
                        document.getElementById("formcce").reset();
                        $(".modal-backdrop").css("display", "none");
                        setTimeout(function () {
                            $("#alertsucesso").css("display", "none");
                        }, 6000);
                        Carrega("_grid", "nfe_grid.php", "NF-e");
                    } else {
                        $('#aguardecce').hide();
                        $("#btncce").prop("disabled", false);
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html($(retorno).find("motivo").text());
                        $("#cartacorrecao").modal('hide');
                        $(".modal-backdrop").css("display", "none");
                        setTimeout(function () {
                            $("#alerterro").css("display", "none");
                        }, 6000);
                    }
                }
            });
            return false;
        });
        
        <?php if($_GET['nfce'] == 'S') :?>
            setTimeout(function() {
                $('.situacao_select').click();
                $('#2').click();
                $('#1').click();
                $('#1').click();
            }, 500);
        <?php endif;?>
    }


    );



    function GeraNFeDoc() {
        var valor = $("#docnfe").val();

        if (valor === '') {
            return false;
        }

        var tipo = $("#tipoem").val();

        if (tipo === 'PEdc') {
            $("#conveterDoc").modal('hide');
            $("#FaturamentoPed").modal('show');
            PreencheFaturamento();
            return false;
        }

        if (tipo === 'PEd') {
            var url = "_backend/_controller/_insert/converte_ped_nfe.php";
            tipo === 'NFe';
        } else if (tipo === 'PEdT') {
            var url = "_backend/_controller/_insert/converte_ped_total_nfe.php";
            tipo === 'NFe';
        } else if (tipo === 'DEv') {
            var url = "_backend/_controller/_insert/converte_docdev_nfe.php";
        } else if (tipo === 'NFCe') {
            var url = "_backend/_controller/_insert/converte_doc_nfce.php";
        } else {
            var url = "_backend/_controller/_insert/converte_doc_nfe.php";
        }

        $("#btndoc").html('<i id="aguardecanc" class="fa fa-spinner fa-spin fa-1x fa-fw"></i> Aguarde');
        $("#btndoc").attr("disabled", true);
        $.ajax({
            type: "GET",
            url: url,
            data: {
                documento: valor,
                tipoem: tipo,
                modelo: 65
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data.nfe > 0) {//                    
                    bootbox.alert({
                        message: data.mensagem,
                        callback: function () {
                            Carrega('_grid', 'nfe_grid.php', 'NF-e');
                            $("#conveterDoc").modal('hide');

                        }
                    })
                } else {
                    bootbox.alert({
                        message: data.mensagem,
                        callback: function () {
                            Carrega('_grid', 'nfe_grid.php', 'NF-e');
                            $("#conveterDoc").modal('hide');

                        }
                    })
                }
            }
        }); //termina o jquery
    }


    function GerrPedFaturamento() {
        var valor = $("#docnfe").val();

        if (valor === '') {
            return false;
        }

        var tipo = $("#tipoem").val();

        $("#btndocfat").html('<i id="aguardecanc" class="fa fa-spinner fa-spin fa-1x fa-fw"></i> Aguarde');
        $("#btndocfat").attr("disabled", true);
        $.ajax({
            type: "GET",
            url: "_backend/_controller/_insert/converte_ped_conf_nfe.php",
            data: {
                documento: valor,
                faturamento: $("#pedidofatu").val(),
                tipoem: tipo,
                modelo: 65
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data.nfe > 0) {//                    
                    bootbox.alert({
                        message: data.mensagem,
                        callback: function () {
                            Carrega('_grid', 'nfe_grid.php', 'NF-e');
                            $("#FaturamentoPed").modal('hide');

                        }
                    })
                } else {
                    bootbox.alert({
                        message: data.mensagem,
                        callback: function () {
                            Carrega('_grid', 'nfe_grid.php', 'NF-e');
                            $("#FaturamentoPed").modal('hide');

                        }
                    })
                }
            }
        }); //termina o jquery
    }


    function PreencheFaturamento() {
        $.ajax({
            type: "GET",
            url: "_backend/_controller/_select/_ajax/busca_faturamentos_ped.php",
            data: {
                documento: $("#docnfe").val()
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
                var option = '<option></option>';
                $.each(data, function (i, obj) {
                    option += '<option value="' + obj.id + '"> ' + obj.data + ' - R$' + obj.valor + ' </option>';
                });

                $('#pedidofatu').html(option).show();
            }
        }); //termina o jquery
    }


    function Duplicar() {
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/duplica_nfe_select_ajax.php",
            data: {
                nfe: $("#NFnro").val(),
                para: $("#para").val(),
                cliente: $("#clienteCNPJ").val(),
                fornecedor: $("#fornecedorCNPJ").val()
            },
            dataType: "json",
            success: function (data)
            {
                if (data.status == 'OK') {
                    Carrega('_grid', 'nfe_grid.php', 'NF-E');
                    document.getElementById("alerterro").style.display = "none";
                    document.getElementById("alertsucesso").style.display = "block";
                    $("#sucesso").html(data.msg);
                    setTimeout(function () {
                        $("#alertsucesso").css("display", "none");
                    }, 3000);
                } else {
                    toastr.warning(data.msg);
                }
            }
        });
    }
</script>
<!--Modal Import-->
<div class="modal fade modal-info" id="Import" aria-hidden="true" aria-labelledby="Import" role="dialog" tabindex="-1">
    <div class="modal-dialog  modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
                <h4 class="modal-title text-uppercase">Importar Nota Fiscal (xml)</h4>
            </div>
            <div class="modal-body" style="max-height: 700px; overflow-y: scroll;">
                <form name="formUpload" id="formUpload" method="post">

                    <div class="row">
                        <div class="col-md-8">
                            <input id="uploadFile" class="form-control" placeholder="" disabled="disabled" />
                        </div>

                        <div class="col-md-1 form-group">
                            <div class="fileUpload btn btn-primary form-control">
                                <span><i class="fa fa-arrow-left"></i> </span>
                                <input type="file" name="arquivo" id="arquivo" onchange="Arquivo(this.value);" class="upload form-control" />
                            </div>
                        </div>


                        <div class="col-md-2">
                            <input type="button" class="btn btn-info" id="btnEnviarXML" value="Importar" />
                        </div>
                    </div>
                    <div id="resposta">

                    </div>
                    <!--                    <div class="col-md-12">
                                            <progress value="0" max="100"></progress><span id="porcentagem">0%</span>
                                        </div>-->

                </form>
            </div>  


        </div>
    </div>
</div>
<!--Fim Modal Imoort-->


<div class="modal fade" id="memail" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-full">

        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title"> Envio de Email NF-e </h4>
            </div>

            <div class="modal-body" > 
                <div class="row">
                    <input type="hidden" name="nct" id="nnfemail">


                    <div class="col-md-6">
                        <label>E-mail</label>
                        <input name="emailnfe" id="emailnfe" type="text" class="form-control" placeholder=""> 
                    </div>
                </div>


            </div>
            <div class="modal-footer">
                <button type="submit" id="btnemail" class="btn green"><i id="aguardecanc" style="display: none;" class="fa fa-spinner fa-spin fa-1x fa-fw"></i>Enviar</button>
            </div>
        </div>

        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<div class="modal fade" id="FaturamentoPed" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-full">

        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title"> Escolher Faturamento </h4>
            </div>

            <div class="modal-body" > 
                <div class="row">
                    <div class="col-md-12">
                        <label>Faturamento</label>
                        <select name="pedidofatu" id="pedidofatu" class="form-control">

                        </select>
                    </div>

                </div>


            </div>
            <div class="modal-footer">
                <button type="submit" id="btndocfat" onclick="GerrPedFaturamento()" class="btn green">Gerar NF-e</button>
            </div>
        </div>

        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>


<div class="modal fade" id="conveterDoc" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-full">

        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title"> Buscar DOC </h4>
            </div>

            <div class="modal-body" > 
                <div class="row">
                    <input type="hidden" name="nct" id="nnfemail">


                    <div class="col-md-4">
                        <label>Tipo</label>
                        <select name="tipoem" id="tipoem" class="form-control">
                            <option value="NFe"> NF-e Normal</option>
                            <option value="NFCe"> NFC-e</option>
                            <option value="MAn"> NF-e Manifesto</option>
                            <option value="DEv"> NF-e Devolução</option>
                            <option value="PEd"> Pedido</option>
                            <option value="PEdT"> Pedido Total</option>
                            <option value="PEdc"> Pedido Confirmação</option>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label>Documento</label>
                        <input name="docnfe" id="docnfe" autocomplete="off" type="text" class="form-control" placeholder=""> 
                    </div>
                </div>


            </div>
            <div class="modal-footer">
                <button type="submit" id="btndoc" onclick="GeraNFeDoc()" class="btn green">Buscar</button>
            </div>
        </div>

        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>



<div class="modal fade" id="lotexml" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-full" style="width: 80%">

        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title">Importação em LOTE XML </h4>
            </div>

            <div class="modal-body" > 
                <div class="row">
                    <div class="col-md-12">
                        <div id="drop" class="dropzone">
                        </div>
                    </div>
                </div>

            </div>

            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
</div>

<div class="modal fade" id="duplicanfe" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-full">

        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title">Duplicar Nota fiscal </h4>
            </div>

            <div class="modal-body" > 
                <div class="row">
                    <input type="hidden" id="NFnro">
                    <div class="col-md-4">
                        <select name="para" onchange="BuscaPara(this.value)" class="form-control" id="para">
                            <option value="C"> Cliente </option>
                            <option value="F"> Fornecedor </option>
                        </select>
                    </div>
                </div>
                <div class="row" id="cliente" >
                    <div class="col-md-4">
                        <label class="control-label">Cliente <span class="text-danger">*</span></label>
                        <input type="text" name="cliente" onchange="Cliente(this.value)" id="clienteCNPJ" class="form-control">
                        <i style="position: absolute; right: 22px; top: 34px; cursor: pointer;" onclick="Busca('cliente')" class="fa fa-search"> </i>

                    </div>

                    <div class="col-md-8">
                        <label class="control-label">Cliente Razão Social/Nome</label>
                        <input type="text" disabled="" id="clientexNome" class="form-control">
                    </div>
                </div>

                <div class="row" id="fornecedor" style="display: none">
                    <div class="col-md-2">
                        <label class="control-label">Fornecedor  <span class="text-danger">*</span></label>
                        <input type="text" name="fornecedor" onchange="Fornecedor(this.value)" id="fornecedorCNPJ" class="form-control">
                        <i style="position: absolute; right: 22px; top: 34px; cursor: pointer;" onclick="Busca('fornecedor')" class="fa fa-search"> </i>

                    </div>

                    <div class="col-md-6">
                        <label class="control-label">Fornecedor Razão Social/Nome</label>
                        <input type="text" disabled="" id="fornecedorxNome" class="form-control">
                    </div>
                </div>
            </div>

            <div class="modal-footer">
                <button type="button" onclick="Duplicar()" class="btn btn-info">Duplicar</button>
            </div>

            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
</div>


<div class="modal fade" id="Etiquetacorreios" tabindex="-1" aria-labelledby="Modallotexml" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="Modallotexmll">Gerar Etiqueta Correios</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" > 
                <input type="hidden" id="idnfecorreios">

                <div class="row alert" id="msg_correios" style="display: none;">
                    <div class="col-md-12">
                        <span id="MsgCorreios"></span>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-8">
                        <label>Escolha o cartão de postagem</label>
                        <select id="correios" onchange="ServicosCorreios(this.value)" class="form-control">
                            <option></option>
                            <?php
                            $pdo = Conexao::getInstance();
                            $crud = Crud::getInstance($pdo, 'cfop');
                            $sql = "SELECT * from correios";
                            $arrayParam = '';
                            $correios = $crud->getSQLGeneric($sql, $arrayParam, true);
                            foreach ($correios as $dados) :
                                ?>
                                <option value="<?= $dados->id ?>"><?= $dados->descricao ?> | <?= $dados->cartaopostagem ?></option>
                                <?php
                            endforeach;
                            ?>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label>Serviço</label>
                        <select id="servico" class="form-control">
                        </select>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <label>Formato Obj</label>
                        <select id="codObj" class="form-control">
                            <option value="1">Envelope</option>
                            <option value="2">Caixa/Pacote</option>
                            <option value="3">Cilindro/rolo</option>
                        </select>
                    </div>

                    <div class="col-md-2">
                        <label>Altura(cm)</label>
                        <input type="number" class="form-control" id="altura">
                    </div>
                    <div class="col-md-2">
                        <label>Largura(cm)</label>
                        <input type="number" class="form-control" id="largura">
                    </div>
                    <div class="col-md-2">
                        <label>Comprimento(cm)</label>
                        <input type="number" class="form-control" id="comprimento">
                    </div>
                    <div class="col-md-2">
                        <label>Diametro(cm)</label>
                        <input type="number" class="form-control" id="diametro">
                    </div>


                </div>


                <div class="row">

                    <div class="col-md-6">
                        <label>Conteúdo</label>
                        <input type="text" maxlength="60" class="form-control" id="conteudo">
                    </div>
                    <div class="col-md-2">
                        <label>Peso(Gramas)</label>
                        <input type="number" class="form-control" id="pesoInformado">
                    </div>
                    <div class="col-md-2">
                        <label>Quantidade</label>
                        <input type="number" class="form-control" id="quantidade">
                    </div>
                    <div class="col-md-2">
                        <label>Valor</label>
                        <input type="text" onkeypress="mascara(this, mvalor);" class="form-control" id="vProdCorreios">
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-2">
                        <label>Solicita Coleta</label>
                        <select id="coleta" class="form-control">
                            <option value="N">NÃO</option>
                            <option value="S">SIM</option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label>Previsão postagem</label>
                        <input type="text" onkeypress="mascara(this, mdata);" maxlength="10" value="<?= date("d/m/Y") ?>" class="form-control" id="dataPostagem">
                    </div>

                    <div class="col-md-2">
                        <label>Logistica reversa</label>
                        <select id="loogisticaReversa" class="form-control">
                            <option value="N">NÃO</option>
                            <option value="S">SIM</option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label>Data Logistica reversa</label>
                        <input type="text" onkeypress="mascara(this, mdata);" maxlength="10" value="<?= date("d/m/Y") ?>" class="form-control" id="dataloogisticaReversa">
                    </div>
                </div>

            </div>

            <div class="modal-footer">
                <div class="row">
                    <div class="col-md-12">
                        <button class="btn btn-success" id="btnEtqCorreios" type="button" onclick="GeraEtiquetaCorreios()"> <i class="fa fa-tag"> </i> Gerar</button>
                    </div>
                </div>
            </div>


            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
</div>

<div class="modal fade" id="Rotuloscorreios" tabindex="-1" aria-labelledby="Modallotexml" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="Modallotexmll">Imprimir Rótulos</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" > 

                <div class="row alert" id="msg_Rotulos_correios" style="display: none;">
                    <div class="col-md-12">
                        <span id="MsgRotolusCorreios"></span>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <label>Tipo</label>
                        <select id="tipoRotulo" class="form-control">
                            <option value="P">Padrão</option>
                            <option value="R">Reduzido</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label>Layout</label>
                        <select id="layoutImpressao" class="form-control">
                            <option value="PADRAO">Padrão</option>
                            <option value="LINEAR_A4">A4</option>
                            <option value="LINEAR_A">Envelope</option>
                            <option value="LINEAR_100_150">Linear 100/150</option>
                            <option value="LINEAR_100_80">Linear 100/80</option>

                        </select>
                    </div>

                </div>


            </div>

            <div class="modal-footer">
                <div class="row">
                    <div class="col-md-12">
                        <button class="btn btn-success" id="btnRotuloCorreios" type="button" onclick="GeraRotulosCorreios()"> <i class="fa fa-tag"> </i> Gerar</button>
                    </div>
                </div>
            </div>


            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
</div>

<?php
if (isset($_GET['busca'])) :
    ?>
    <div class="modal-footer">
        <button type="button" class="btn dark btn-outline" data-dismiss="modal">Fechar</button>
        <button type="button" id="selecionanfe" class="btn green">Selecionar</button>
    </div>
    <?php
endif;
?>