<?php
session_start();
require_once('../../../functions.php');
require_once("../_modal/_modal.php");
require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";



if ($nivelusuario->emitenfe == 'N') :
?>
    <div class="note note-info">
        <div class="alert bg-red bg-font-red alert-dismissible" role="alert">
            <strong>AUTORIZAÇÃO DE ACESSO NEGADA.</strong>
        </div>
    </div>
<?php
    exit;
endif;
?>

<script>
    var myDropzone = new Dropzone("div#drop", {
        url: "<?= LINK ?>/_fiscal/_nfe/geracao/ImpXMLCTe_entrada_lote.php"
    });
</script>
<style>
    label {
        font-size: 12px;
    }

    .fileUpload {
        position: relative;
        overflow: hidden;
        margin: 0px;
    }

    .fileUpload input.upload {
        position: absolute;
        top: 0;
        right: 0;
        margin: 0;
        padding: 0;
        font-size: 20px;
        cursor: pointer;
        opacity: 0;
        filter: alpha(opacity=0);
    }
</style>

<div class="row">
    <div class="col-md-12">
        <button class="btn btn-primary " onclick="Carrega('_form', 'entrada_merc_form.php', 'Emissão de NF-e')" title="Emitir NF-e"> <i class="fa fa-plus"></i> Criar</button>
        <button class="btn btn-primary " id="editar" title="Editar NF-e"> <i class="fa fa-edit"></i> Editar</button>
        <button class="btn btn-danger " id="delete" title="Deletar NF-e"> <i class="fa fa-trash"></i> Excluir</button>
        <button class="btn btn-primary " id="retorno" title="Criar Devolução"> <i class="fa fa-arrow-up"></i> Criar Devolução</button>
     
            <button class="btn btn-primary " id="impLoteCTe" title="Importar Lote CT-e" onclick="ImportarLote()"> <i class="fa fa-arrow-down"></i> Importar Lote XML CT-e</button>
 
    </div>
</div>
<hr />
<div class="row">
    <div class="col-md-12" style='background-color: #fff;'>
        <div class="table-responsive">
            <table id="employee-grid-nfe" cellpadding="0" cellspacing="0" border="0" class="table table-bordered table-hover table-condensed table-striped width-full">
                <thead>

                    <tr class="alert alert-default">
                        <th></th>
                        <!--<th></th>-->
                        <th style="width: 10%">Nº</th>
                        <th style="width: 1%">Modelo</th>
                        <th style="width: 1%">Serie</th>
                        <th style="width: 18%">Data Emisão</th>
                        <th style="width: 70%">Fornecedor</th>
                        <th style="width: 15%">Valor</th>
                        <th style="width: 15%">Chave</th>
                    </tr>
                    <tr>
                        <th><input type="checkbox" id="bulkDelete" /></th>
                        <!--<th></th>-->
                        <th><input type="text" id="1" style="width: 100%" class="form-control employee-search-nfe-input"></th>
                        <th><input type="text" id="2" style="width: 100%" class="form-control employee-search-nfe-input"></th>
                        <th><input type="text" id="3" style="width: 100%" class="form-control employee-search-nfe-input"></th>
                        <th><input type="text" id="4" onkeypress="mascara(this, mdata);" style="width: 100%" class="form-control employee-search-nfe-input"></th>
                        <th><input type="text" id="5" style="width: 100%" class="form-control employee-search-nfe-input"></th>
                        <th><input type="text" id="6" onkeypress="mascara(this, mvalor);" style="width: 100%" class="form-control employee-search-nfe-input"></th>
                        <th><input type="text" id="8" style="width: 100%" class="form-control employee-search-nfe-input"></th>

                    </tr>
                </thead>
                <tfoot>
                    <tr class="alert alert-default">
                        <td colspan="6"><b>TOTAL</b></td>
                        <td><strong><span class="text-black-50" id="valorlancd"></span></strong></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
<script type="text/javascript" language="javascript">
    $(document).ready(function() {
        $('#btnEnviarXML').click(function() {
            $('#formUpload').ajaxForm({
                uploadProgress: function(event, position, total, percentComplete) {
                    $('progress').attr('value', percentComplete);
                    $('#porcentagem').html(percentComplete + '%');
                },
                success: function(data) {
                    $('progress').attr('value', '100');
                    $('#porcentagem').html('100%');
                    if (data.sucesso == true) {
                        //                        alert(data.arquivo);
                        ImportarXML(data.arquivo);
                    } else {
                        data.msg;
                    }
                },
                error: function() {
                    $('#resposta').html('Erro ao enviar requisição!!!');
                },
                dataType: 'json',
                url: '<?= BACKEND ?>/_controller/_import/enviar_arquivo_xml.php',
                resetForm: true
            }).submit();
        })
    })

    function ImportarLote() {
        bootbox.confirm({
            message: "Importar em lote usa informações padrão vindas do XML.<br>Se precisar editar alguam informação antes de salvar recomendamos a entrada manual. <br> Deseja continuar?",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function(result) {
                if (result) {
                    $("#lotexml").modal('show');
                }
            }
        });

        // $("#tituloGrid").html('IMPORTAR XML');
    }


    function ImportarTXT(valor) {

        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/ConvertNFE.php",
            //                data: {
            //                    nfe: valor
            //                },
            dataType: "json",
            success: function(data) {
                if (data.status == 'ok') {
                    Carrega('_grid', 'nfe_grid.php', 'NF-E');
                    document.getElementById("alerterro").style.display = "none";
                    document.getElementById("alertsucesso").style.display = "block";
                    $("#sucesso").html(data.msg);
                    setTimeout(function() {
                        $("#alertsucesso").css("display", "none");
                    }, 3000);
                } else {
                    document.getElementById("alertsucesso").style.display = "none";
                    document.getElementById("alerterro").style.display = "block";
                    $("#erro").html(data.msg);
                    setTimeout(function() {
                        $("#alerterro").css("display", "none");
                    }, 3000);
                }

            }
        });
    }


    function ImportarXML(valor) {

        $.ajax({
            type: "GET",
            //            url: "<?= LINK ?>/_fiscal/_nfe/geracao/ImpXMLSaida.php",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/ImpXMLSaida_aprovada.php",
            data: {
                xml: valor
            },
            dataType: "json",
            success: function(data) {
                if (data.status == 'ok') {
                    Carrega('_grid', 'nfe_grid.php', 'NF-E');
                    alert(data.msg);
                    document.getElementById("alerterro").style.display = "none";
                    document.getElementById("alertsucesso").style.display = "block";
                    $(".modal-backdrop").css("display", "none");
                    $("#sucesso").html(data.msg);
                    setTimeout(function() {
                        $("#alertsucesso").css("display", "none");
                    }, 3000);
                } else {
                    document.getElementById("alertsucesso").style.display = "none";
                    document.getElementById("alerterro").style.display = "block";
                    $("#erro").html(data.msg);
                    $(".modal-backdrop").css("display", "none");
                    setTimeout(function() {
                        $("#alerterro").css("display", "none");
                    }, 3000);
                }

            }
        });
    }

    function Importar() {
        $("#Import").modal('show');
        $("#tituloGrid").html('IMPORTAR XML');
    }


    function Arquivo(valor) {
        if (verificaExtensaoArquivo(valor)) {
            $("#uploadFile").val(valor);
        } else {
            $("#uploadFile").val('');
            $("#arquivo").val('');
        }


    }

    function verificaExtensaoArquivo(arquivo) {
        extensoes_permitidas = new Array(".xml");
        extensao = (arquivo.substring(arquivo.lastIndexOf("."))).toLowerCase();
        permite = false;
        $(extensoes_permitidas).each(function(i) {
            if (extensoes_permitidas[i] == extensao) {
                permite = true;
                return false;
            }

        });
        if (!permite) {
            alert("SOMENTE É ACEITO ARQUIVO DE TEXTO. (.xml)");
            return false;
        }
        return true;
    }

    $(document).ready(function() {

        var dataTable = $('#employee-grid-nfe').DataTable({
            processing: true,
            "language": {
                "processing": "Aguarde...",
                "info": "_PAGE_ DE _PAGES_",
                "lengthMenu": "_MENU_",
                "infoFiltered": "(Filtrando _MAX_)",
                "emptyTable": "<b>Nenhum Registro Encontrado</b>",
                "paginate": {
                    "previous": "Anterior",
                    "next": "Próximo"
                }

            },
            "columnDefs": [{
                    "targets": [0],
                    //                    "visible": false,
                    "searchable": false,
                    "orderable": false
                },
                {
                    "targets": [2],
                    //                    "visible": false,
                    "searchable": false,
                    "orderable": false
                },
            ],
            drawCallback: function(settings) {
                $("#valorlancd").html(settings.json.total);
            },
            "lengthMenu": [10, 50, 100, 500],
            serverSide: true,
            ajax: "_backend/_controller/_select/_grid/nfe_ent_select_grid.php", // json datasource

        });
        $("#employee-grid-nfe_filter").css("display", "none"); // hiding global search box

        $('.employee-search-nfe-input').on('keyup click', function(event) {
            var i = $(this).attr('id'); // getting column index
            var v = $(this).val(); // getting search input value
            if (event.keyCode !== 13)
                return false;
            dataTable.columns(i).search(v).draw();
        });
        $(document).ready(function() {
            $('#selecionanfe').click(function() {
                var val = new Array();
                $('.DeleteRow:checked').each(function() {
                    val.push($(this).val());
                });
                if (val == '') {
                    toastr.warning('Nenhum Registo Selecionado!');
                } else {
                    var cod = $(val).get(0);
                    //                    alert(cod);
                    Cliente(cod);
                }

            });
        });
        //       


        $('#delete').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {

                    bootbox.confirm({
                        message: "Deseja realmente excluir a NF selecionada?",
                        buttons: {
                            confirm: {
                                label: 'Sim',
                                className: 'btn-success'
                            },
                            cancel: {
                                label: 'Não',
                                className: 'btn-danger'
                            }
                        },
                        callback: function(result) {
                            if (result) {
                                Deletar(val);
                            }
                        }
                    });
                }
            }
        });


        //        $('#delete').click(function () {
        //            var val = new Array();
        //            $('.DeleteRow:checked').each(function () {
        //                val.push($(this).val());
        //            });
        //            if (val == '') {
        //                toastr.warning('Nenhum Registo Selecionado!');
        //            } else {
        //
        //                var decisao = confirm("Deseja Realmente Excluir?");
        //                if (decisao) {
        //                    Deletar(val);
        //
        //                }
        //            }
        //        });


        $('#inutilizanfe').click(function() {
            $("#inutilizacao").modal('show');
        });


        $('#cancelar').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                var total = val.length;
                if (total > 1) {
                    alert('Só é possível selecionar uma nota fiscal por vez.');
                    return false;
                }

                var decisao = confirm("Deseja Realmente Cancelar NF-e?");
                if (decisao) {
                    $.ajax({
                        type: "GET",
                        url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                        data: {
                            nfe: $(val).get(0)
                        },
                        dataType: "json",
                        success: function(data) {
                            if (data[0].status != '100') {
                                document.getElementById("alerterro").style.display = "block";
                                document.getElementById("alertsucesso").style.display = "none";
                                $("#erro").html('<i class="fa fa-exclamation-circle"></i> Só é possível CANCELAR Nota Fiscal Aprovada.!');
                                setTimeout(function() {
                                    $("#alerterro").css("display", "none");
                                }, 3000);
                            } else {
                                $("#nNFCancela").val($(val).get(0));
                                $("#cancelamento").modal('show');
                            }
                        }
                    });
                }
            }
        });


        $('#cce').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                $.ajax({
                    type: "GET",
                    url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                    data: {
                        nfe: $(val).get(0)
                    },
                    dataType: "json",
                    success: function(data) {
                        if (data[0].status != '100') {
                            document.getElementById("alerterro").style.display = "block";
                            document.getElementById("alertsucesso").style.display = "none";
                            $("#erro").html('<i class="fa fa-exclamation-circle"></i> Só é possível Fazer Carta de Correção em Nota Fiscal Aprovada.!');
                            setTimeout(function() {
                                $("#alerterro").css("display", "none");
                            }, 3000);
                        } else {
                            $("#nNFCce").val($(val).get(0));
                            $("#cartacorrecao").modal('show');
                        }
                    }
                });
            }
        });





        $('#transmite').click(function() {

            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
                return false;
            }
            var total = val.length;
            if (total > 1) {
                alert('Só é possível selecionar uma nota fiscal por vez.');
                return false;
            }
            Transmite($(val).get(0));
            //            $("#nfcertificado").val($(val).get(0));
            //            $("#certificado").modal('show');

        });


        $('#editar').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                Carrega('_form', 'entrada_merc_form.php?editar=' + $(val).get(0) + '', 'Entrada de NF-e')
            }

        });
        $('#imprimirdanfe').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {

                //                alert("OK");
                $.ajax({
                    type: "GET",
                    url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                    data: {
                        nfe: $(val).get(0)
                    },
                    dataType: "json",
                    success: function(data) {
                        if (data[0].status != '100') {

                            GeraNFeView($(val).get(0));
                            window.open('<?= LINK ?>/_fiscal/_prints/geracao/danfe.php?nNFbd=' + $(val).get(0) + '', '',
                                'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');

                        } else {
                            window.open('<?= LINK ?>/_fiscal/_prints/geracao/danfe.php?nNFbd=' + $(val).get(0) + '', '',
                                'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');


                        }
                    }
                });
            }


        });
        $('#imprimircce').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {

                $.ajax({
                    type: "GET",
                    url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                    data: {
                        nfe: $(val).get(0)
                    },
                    dataType: "json",
                    success: function(data) {
                        if (data[0].status != '100') {
                            document.getElementById("alerterro").style.display = "block";
                            document.getElementById("alertsucesso").style.display = "none";
                            $("#erro").html('Nota Fiscal Não Autorizada a impressão!');
                            setTimeout(function() {
                                $("#alerterro").css("display", "none");
                            }, 3000);
                        } else {
                            $.ajax({
                                type: "GET",
                                url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                                data: {
                                    nfe: $(val).get(0)
                                },
                                dataType: "json",
                                success: function(data) {
                                    if (data[0].status != '100') {
                                        document.getElementById("alerterro").style.display = "block";
                                        document.getElementById("alertsucesso").style.display = "none";
                                        $("#erro").html('Status de Nota Fsical difrente de APROVADO!');
                                        setTimeout(function() {
                                            $("#alerterro").css("display", "none");
                                        }, 3000);
                                    } else {
                                        window.open('<?= LINK ?>/_fiscal/_prints/geracao/dacce.php?nNFbd=' + $(val).get(0) + '', '',
                                            'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
                                    }
                                }
                            });
                        }
                    }
                });
            }

        });



        $('#email').click(function() {
            //            document.getElementById('alertsucesso').style.display = 'Block';
            //            document.getElementById('sucesso').innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Enviando Email';

            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {

                $("#memail").modal('show');
                $("#nnfemail").val($(val).get(0));
                //                EnviaEmail($(val).get(0));
            }
        });

        $('#duplicar').click(function() {
            //            document.getElementById('alertsucesso').style.display = 'Block';
            //            document.getElementById('sucesso').innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Enviando Email';

            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                Duplicar($(val).get(0));
            }
        });


        $('#btnemail').click(function() {
            document.getElementById('alertsucesso').style.display = 'Block';
            document.getElementById('sucesso').innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Enviando Email';
            setTimeout(function() {
                $("#alertsucesso").css("display", "none");
            }, 4000);
            var nct = $("#nnfemail").val();
            var email = $("#emailnfe").val();
            EnviaEmail(nct, email);
            $("#memail").modal('hide');
        });


        function EnviaEmail(nct, valor) {
            $.ajax({
                type: "GET",
                url: "<?= LINK ?>/sped-mail-master/geracao/enviaemail_nfe.php",
                data: {
                    arquivo: nct,
                    email: valor
                },
                dataType: "json",
                success: function(data) {
                    if (data.status == 'OK') {
                        toastr.success(data.msg);
                    } else {
                        toastr.warning(data.msg);
                    }
                }
            });
        }

        function Duplicar(valor) {
            $.ajax({
                type: "GET",
                url: "<?= BACKEND ?>/_controller/_select/_ajax/duplica_nfe_select_ajax.php",
                data: {
                    nfe: valor
                },
                dataType: "json",
                success: function(data) {
                    if (data.status == 'OK') {
                        Carrega('_grid', 'nfe_grid.php', 'NF-E');
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html(data.msg);
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 3000);
                    } else {
                        toastr.warning(data.msg);
                    }
                }
            });
        }

        $('#retorno').click(function() {

            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                toastr.warning('Nenhum Registo Selecionado!');
            } else {
                if (val.length > 1) {
                    toastr.warning('Selecione apenas um registro!');
                } else {
                    Carrega('_view', 'cria_devolucao_produtos.php?nfe=' + $(val).get(0), 'Produtos para devolver');
                }
            }
        });

        $('#exportar').click(function() {
            var val = new Array();
            $('.DeleteRow:checked').each(function() {
                val.push($(this).val());
            });
            if (val == '') {
                $("#download").modal('show');
            } else {

                $.ajax({
                    type: "GET",
                    url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
                    data: {
                        nfe: $(val).get(0)
                    },
                    dataType: "json",
                    success: function(data) {
                        if (data[0].status == '') {
                            document.getElementById("alerterro").style.display = "block";
                            document.getElementById("alertsucesso").style.display = "none";
                            $("#erro").html('Nota Fiscal Não Autorizada a exportar XML!');
                            setTimeout(function() {
                                $("#alerterro").css("display", "none");
                            }, 3000);
                        } else {
                            window.open('<?= LINK ?>/_fiscal/_nfe/geracao/xml_download.php?arquivo=' + $(val).get(0) + '', '',
                                'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
                        }
                    }
                });
            }

        });


        function Deletar(valor) {

            $.ajax({
                type: "GET",
                url: "_backend/_controller/_delete/entnfe_delete.php",
                data: {
                    nNF: valor
                },
                dataType: "json",
                success: function(data) {
                    if (data.retorno == true) {
                        Carrega('_grid', 'nfe_entrada_grid.php', 'Nota Fiscal Entrada');
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html(data.mensagem);
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 3000);
                        if (data.entrada > 0) {
                            CancelaDoc(data.entrada);
                        }
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html(data.mensagem);
                        setTimeout(function() {
                            $("#alerterro").css("display", "none");
                        }, 3000);
                    }
                }
            });
        }



        //        $('#employee-grid-nfe tbody').on('dblclick', 'tr', function () {
        //            var data = dataTable.row(this).data();
        //            //            alert(data[1] + ' ' + data[4] + ' ' + data[6] + ' ' + data[10]);
        //            location.assign('/operacao.php?fm=' + data[10] + '&nfe=' + data[4] + '&ct=' + data[6] + '&operacaoid=' + data[1]);
        ////            AbreModal(data[1], data[4], data[6], data[10]);
        //        });
    });



    function GeraNFeView(valor) {
        //            alert(valor);
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/gera_nfe.php?nNF=" + valor,
            //                data: {
            //                    nfe: valor
            //                },
            dataType: "xml",
            success: function(retorno) {

            }
        });
    }


    function GeraNFe(valor) {
        //            alert(valor);
        document.getElementById('alertsucesso').style.display = 'Block';
        document.getElementById('sucesso').innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Aguarde Gerando XML';
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/gera_nfe.php?nNF=" + valor,
            dataType: "xml",
            success: function(retorno) {

                //                alert(status);
                var status = $(retorno).find("status").text();
                //                alert(status);

                if (status == 'ok') {


                    <?php
                    if ($emitente->certificado == 'A3') :
                    ?>

                        SituacaoNFeA3();
                        toastr.success('Aguarde, Enviando Nota Fiscal.');
                    <?php
                    else :
                    ?>
                        AssinaNFE(valor);
                    <?php
                    endif;
                    ?>
                } else {
                    toastr.warning('Erro ao Exportar Arquivo.');
                }
            }
        });
    }

    function SituacaoNFeA3() {
        // alert("OK");
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_backend/_controller/_select/a3/nfe_select_situacao.php",
            dataType: "json",
            success: function(data) {
                if (data.situacao == 'S') {
                    document.getElementById('alertsucesso').style.display = 'None';
                    Carrega('_grid', 'nfe_grid.php', 'NF-e');
                } else {
                    setTimeout(function() {
                        SituacaoNFeA3();
                    }, 3000);
                }
            }
        });
    }

    function AssinaNFE(valor) {
        //            alert(valor);
        document.getElementById('alertsucesso').style.display = 'Block';
        document.getElementById('sucesso').innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Assinando XML';
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/assina_nfe.php",
            data: {
                arquivo: valor
            },
            dataType: "xml",
            success: function(retorno) {
                var status = $(retorno).find("status").text();
                if (status == 'OK') {
                    TransmiteNFE(valor);
                } else {
                    document.getElementById('sucesso').innerHTML = $(retorno).find("motivo").text();
                }
            }
        });
    }

    function Transmite(val) {

        $.ajax({
            type: "GET",
            url: "_backend/_controller/_select/_ajax/nfe_status_select_ajax.php",
            data: {
                nfe: val
            },
            dataType: "json",
            success: function(data) {
                if (data[0].status == '100') {
                    document.getElementById("alerterro").style.display = "none";
                    document.getElementById("alertsucesso").style.display = "block";
                    $("#sucesso").html('<i class="fa fa-exclamation-circle"></i> Nota Fiscal Já APROVADA!');
                    setTimeout(function() {
                        $("#alertsucesso").css("display", "none");
                    }, 3000);
                } else {
                    GeraNFe(val);
                }
            }
        });

    }

    function TransmiteNFE(valor) {
        //            alert(valor);
        document.getElementById('alertsucesso').style.display = 'Block';
        document.getElementById('sucesso').innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Enviando XML ao Sefaz';
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/envia_nfe.php?arquivo=" + valor,
            dataType: "xml",
            success: function(retorno) {
                var status = $(retorno).find("status").text();
                if (status == 'OK') {
                    RetornoNFE($(retorno).find("recibo").text(), valor);
                } else {
                    document.getElementById('alertsucesso').style.display = 'Block';
                    document.getElementById('sucesso').innerHTML = $(retorno).find("motivo").text();
                }
            }
        });
    }


    function addProt(valor, recibo) {
        //            alert(valor);
        document.getElementById('alertsucesso').style.display = 'Block';
        document.getElementById('sucesso').innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Adicionando Protocolo';
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/add_protocolo.php?arquivo=" + valor + "&recibo=" + recibo,
            //                data: {
            //                    nfe: valor
            //                },
            dataType: "json",
            success: function(data) {
                if (data.Status == 'Ok') {
                    //                    EnviaEmail(valor);
                    document.getElementById('alertsucesso').style.display = 'None';
                    Carrega('_grid', 'nfe_grid.php', 'NF-e');
                    window.open('<?= LINK ?>/_fiscal/_nfe/geracao/danfe.php?arquivo=' + valor + '', '',
                        'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
                    //                location.reload();
                } else {
                    toastr.warning('Erro ao Adicionar Protocolo.');
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                if (jqXHR.responseText) {

                    var str = jqXHR.responseText;
                    var retorno = jQuery.parseJSON(str.substr(3));

                    if (retorno.Status == 'Ok') {
                        document.getElementById('alertsucesso').style.display = 'None';
                        Carrega('_grid', 'nfe_grid.php', 'NF-e');
                        window.open('<?= LINK ?>/_fiscal/_nfe/geracao/Danfe.php?arquivo=' + valor + '', '',
                            'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');

                    } else {
                        toastr.warning('Erro ao Adicionar Protocolo.');
                    }

                }

            }
        });
    }

    function addCanc(valor) {
        //            alert(valor);
        document.getElementById('alertsucesso').style.display = 'Block';
        document.getElementById('sucesso').innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Adicionando Cancelamento ao XML';
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/addCanc.php?arquivo=" + valor,
            //                data: {
            //                    nfe: valor
            //                },
            dataType: "json",
            success: function(data) {
                if (data.Status == 'Ok') {
                    document.getElementById('alertsucesso').style.display = 'None';
                    Carrega('_grid', 'nfe_grid.php', 'NF-e');
                    //                location.reload();
                } else {
                    toastr.warning('Erro ao Adicionar Protocolo.');
                }
            }
        });
    }


    function RetornoNFE(valor, nct) {
        //            alert(valor);
        document.getElementById('alertsucesso').style.display = 'Block';
        document.getElementById('sucesso').innerHTML = '<i class="fa fa-spinner fa-pulse fa-fw"></i>  Retornando Dados do Sefaz';
        $.ajax({
            type: "GET",
            url: "<?= LINK ?>/_fiscal/_nfe/geracao/consulta_recibo.php?arquivo=" + nct,
            dataType: "xml",
            success: function(retorno) {
                var status = $(retorno).find("status").text();
                if (status == 'OK') {
                    document.getElementById('alertsucesso').style.display = 'None';
                    Carrega('_grid', 'nfe_grid.php', 'NF-e');

                    window.open('<?= LINK ?>/_fiscal/_prints/geracao/danfe.php?nNFbd=' + nct + '', '',
                        'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');

                } else {
                    document.getElementById('alertsucesso').style.display = 'Block';
                    document.getElementById('sucesso').innerHTML = $(retorno).find("motivo").text();
                }
            }
        });
    }

    function ExportaPeriodo() {
        window.open('<?= LINK ?>/_fiscal/_nfe/geracao/xml_download.php?periodo=' + $("#periodo").val() + '', '',
            'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
    }
</script>


<div class="modal fade" id="download" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title"> EXPORTAR XML </h4>
            </div>

            <div class="modal-body">
                <input type="text" name="periodo" maxlength="6" placeholder="Ano e Mês: EX 201601" id="periodo" class="form-control">

            </div>
            <div class="modal-footer">
                <button onclick="ExportaPeriodo()" class="btn green">Exportar</button>
            </div>
        </div>

        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<div class="modal fade" id="cancelamento" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-full">
        <?php
        if ($emitente->certificado == 'A3') :
        ?>
            <form id="formcancelamentoa3" method="GET">

            <?php
        else :
            ?>
                <form id="formcancelamento" method="GET">

                <?php
            endif;
                ?>

                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                        <h4 class="modal-title"> Cancelar NF-E </h4>
                    </div>

                    <div class="modal-body">
                        <input type="hidden" name="nNF" id="nNFCancela">

                        <div class="row">
                            <div class="col-md-12">
                                <textarea required="" placeholder="Justificativa" name="justificativa" class="form-control" minlength="15" maxlength="250"></textarea>
                            </div>
                        </div>


                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="btncancelar" class="btn green"><i id="aguardecanc" style="display: none;" class="fa fa-spinner fa-spin fa-1x fa-fw"></i>Cancelar NF-e</button>
                    </div>
                </div>
                </form>

                <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>


<div class="modal fade" id="certificado" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-full">
        <form id="formcertificado" method="GET">

            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h4 class="modal-title"> Senha do Certificado Digital </h4>
                </div>

                <div class="modal-body">
                    <div class="row">
                        <input type="hidden" id="nfcertificado" name="nfe">
                        <div class="col-md-12">
                            <input type="password" name="senha" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" id="btncancelar" class="btn green">Transmitir NF-e</button>
                </div>
            </div>
        </form>

        <!-- /.modal-content -->
    </div>
</div>
<!-- /.modal-dialog -->


<div class="modal fade" id="cartacorrecao" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-full">
        <form id="formcce" action="" method="GET">

            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h4 class="modal-title"> Carta de Correção NF-E </h4>
                </div>

                <div class="modal-body">
                    <input type="hidden" name="nNF" id="nNFCce">

                    <div class="row">
                        <div class="col-md-12">
                            <textarea required="" placeholder="Correção" name="correcao" class="form-control" minlength="15" maxlength="350"></textarea>
                        </div>
                    </div>


                </div>
                <div class="modal-footer">
                    <button type="submit" id="btncce" class="btn green"><i id="aguardecce" style="display: none;" class="fa fa-spinner fa-spin fa-1x fa-fw"></i> Corrigir NF-e</button>
                </div>
            </div>
        </form>

        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<!--inutilização-->
<div class="modal fade" id="inutilizacao" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <form id="forminutiliza" action="" method="GET">

            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h4 class="modal-title"> Inutilização de Numeração NF-E </h4>
                </div>

                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4">
                            <label>Nº Inicial <span class="text-danger">*</span></label>
                            <input name="nIni" maxlength="9" type="text" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-4">
                            <label>Nº Final <span class="text-danger">*</span></label>
                            <input name="nFin" maxlength="9" type="text" required="" class="form-control" placeholder="">
                        </div>

                    </div>
                    <hr />
                    <div class="row">
                        <div class="col-md-12">
                            <textarea required="" placeholder="Justificativa" name="xJust" class="form-control" minlength="15" maxlength="350"></textarea>
                        </div>
                    </div>
                    <br />
                    <div class="row">
                        <h4> Historico de Inutilização </h4>
                        <table class="table table-striped table-condensed">
                            <tr>
                                <td>Data</td>
                                <td>Nº Inicial</td>
                                <td>Nº Final</td>
                                <td>Justificativa</td>
                            </tr>

                            <?php
                            if (isset($_SESSION['BD'])) :

                                $pdo = Conexao::getInstance();
                                $crud = Crud::getInstance($pdo, 'inutilizados');
                                $sql = "SELECT * from inutilizados WHERE emitente ='$emitenteid' and tipo = 'nfe'";
                                $arrayParam = '';
                                $row = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

                                foreach ($row as $dados) :
                            ?>
                                    <tr>
                                        <td><?= $dados->data ?></td>
                                        <td><?= $dados->inicial ?></td>
                                        <td><?= $dados->final ?></td>
                                        <td><?= $dados->justificativa ?></td>
                                    </tr>
                            <?php
                                endforeach;
                            endif;
                            ?>
                        </table>

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" id="btninutiliza" class="btn green"><i id="aguardeinutiliza" style="display: none;" class="fa fa-spinner fa-spin fa-1x fa-fw"></i> Inutilizar </button>
                </div>
            </div>
        </form>

        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>


<script>
    $(document).ready(function() {
        $('#forminutiliza').submit(function() {
            $('#aguardeinutiliza').show();
            $("#btninutiliza").prop("disabled", true);
            var dados = $(this).serialize();
            $.ajax({
                type: "GET",
                url: "<?= LINK ?>/_fiscal/_nfe/geracao/inutiliza_nfe.php",
                data: dados,
                dataType: "xml",
                success: function(retorno) {

                    var status = $(retorno).find("status").text();
                    if (status == 'OK') {
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html($(retorno).find("motivo").text());
                        $("#inutilizacao").modal('hide');
                        $(".modal-backdrop").css("display", "none");
                        document.getElementById("forminutiliza").reset();
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 6000);
                        $('#aguardeinutiliza').hide();
                        $("#btninutiliza").prop("disabled", false);
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html($(retorno).find("motivo").text());
                        $("#inutilizacao").modal('hide');
                        $(".modal-backdrop").css("display", "none");
                        $('#aguardeinutiliza').hide();
                        $("#btninutiliza").prop("disabled", false);
                        setTimeout(function() {
                            $("#alerterro").css("display", "none");
                        }, 6000);
                    }

                }
            });
            return false;
        });


        $('#formcertificado').submit(function() {
            var dados = $(this).serialize();
            $.ajax({
                type: "GET",
                url: "_backend/_controller/_select/_ajax/verifica_senha_select_ajax.php",
                data: dados,
                dataType: "json",
                success: function(data) {
                    if (data.retorno == true) {
                        Transmite(data.nfe);
                        $("#certificado").modal('hide');
                    } else {
                        alert("Senha do Certificado Invalida");
                    }
                }
            });
            return false;
        });

        $('#formcancelamentoa3').submit(function() {
            $('#aguardecanc').show();
            $("#btncancelar").prop("disabled", true);
            var dados = $(this).serialize();
            $.ajax({
                type: "GET",
                url: "<?= LINK ?>/_fiscal/_nfe/geracao/cancela_a3_nfe.php",
                data: dados,
                dataType: "xml",
                success: function(retorno) {

                    var status = $(retorno).find("status").text();
                    if (status == 'OK') {
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html($(retorno).find("motivo").text());
                        $("#cancelamento").modal('hide');
                        $(".modal-backdrop").css("display", "none");
                        document.getElementById("formcancelamentoa3").reset();
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 4000);
                        $('#aguardecanc').hide();
                        $("#btncancelar").prop("disabled", false);
                        //                        Carrega('_grid', 'nfe_grid.php', 'NF-e');
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html($(retorno).find("motivo").text());
                        $("#cancelamento").modal('hide');
                        $("#cartacorrecao").modal('hide');
                        $(".modal-backdrop").css("display", "none");
                        $('#aguardecanc').hide();
                        $("#btncancelar").prop("disabled", false);
                        setTimeout(function() {
                            $("#alerterro").css("display", "none");
                        }, 4000);
                    }
                }
            });
            SituacaoNFeA3();
            return false;
        });

        $('#formcancelamento').submit(function() {
            $('#aguardecanc').show();
            $("#btncancelar").prop("disabled", true);
            var dados = $(this).serialize();
            $.ajax({
                type: "GET",
                url: "<?= LINK ?>/_fiscal/_nfe/geracao/cancela_nfe.php",
                data: dados,
                dataType: "xml",
                success: function(retorno) {

                    var status = $(retorno).find("status").text();
                    if (status == 'OK') {
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html($(retorno).find("motivo").text());
                        $("#cancelamento").modal('hide');
                        $(".modal-backdrop").css("display", "none");
                        document.getElementById("formcancelamento").reset();
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 4000);
                        $('#aguardecanc').hide();
                        $("#btncancelar").prop("disabled", false);
                        Carrega('_grid', 'nfe_grid.php', 'NF-e');
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html($(retorno).find("motivo").text());
                        $("#cancelamento").modal('hide');
                        $("#cartacorrecao").modal('hide');
                        $(".modal-backdrop").css("display", "none");
                        $('#aguardecanc').hide();
                        $("#btncancelar").prop("disabled", false);
                        setTimeout(function() {
                            $("#alerterro").css("display", "none");
                        }, 4000);
                    }
                }
            });

            return false;
        });

        $('#formcce').submit(function() {
            $('#aguardecce').show();
            $("#btncce").prop("disabled", true);
            var dados = $(this).serialize();
            $.ajax({
                type: "GET",
                url: "<?= LINK ?>/_fiscal/_nfe/geracao/cce_nfe.php",
                data: dados,
                dataType: "xml",
                success: function(retorno) {
                    var status = $(retorno).find("status").text();
                    if (status == 'OK') {
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html($(retorno).find("motivo").text());
                        $("#cartacorrecao").modal('hide');
                        document.getElementById("formcce").reset();
                        $(".modal-backdrop").css("display", "none");
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 6000);
                        Carrega("_grid", "nfe_grid.php", "NF-e");
                    } else {
                        $('#aguardecce').hide();
                        $("#btncce").prop("disabled", false);
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html($(retorno).find("motivo").text());
                        $("#cartacorrecao").modal('hide');
                        $(".modal-backdrop").css("display", "none");
                        setTimeout(function() {
                            $("#alerterro").css("display", "none");
                        }, 6000);
                    }
                }
            });
            return false;
        });
    });



    function CancelaDoc(doc) {
        bootbox.confirm({
            message: "Deseja cancelar o documento vinculado a nota fiscal?",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function(result) {
                if (result) {
                    $.ajax({
                        type: "GET",
                        url: "_backend/_controller/_delete/movimentacao_ent_delete.php",
                        data: {
                            documento: doc,
                            motivo: 'Nota fiscal excluída!'
                        },
                        dataType: "json",
                        success: function(data) {
                            if (data.retorno === true) {
                                bootbox.alert('Documento cancelado com sucesso!');
                                Carrega('_grid', 'nfe_entrada_grid.php', 'Nota Fiscal Entrada');
                            } else {
                                bootbox.alert(data.mensagem)
                            }
                        }
                    });
                }
            }
        });
    }
</script>
<!--Modal Import-->
<div class="modal fade modal-info" id="Import" aria-hidden="true" aria-labelledby="Import" role="dialog" tabindex="-1">
    <div class="modal-dialog  modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
                <h4 class="modal-title text-uppercase">Importar Nota Fiscal (xml)</h4>
            </div>
            <div class="modal-body" style="max-height: 700px; overflow-y: scroll;">
                <form name="formUpload" id="formUpload" method="post">

                    <div class="row">
                        <div class="col-md-8">
                            <input id="uploadFile" class="form-control" placeholder="" disabled="disabled" />
                        </div>

                        <div class="col-md-1 form-group">
                            <div class="fileUpload btn btn-primary form-control">
                                <span><i class="fa fa-arrow-left"></i> </span>
                                <input type="file" name="arquivo" id="arquivo" onchange="Arquivo(this.value);" class="upload form-control" />
                            </div>
                        </div>


                        <div class="col-md-2">
                            <input type="button" class="btn btn-info" id="btnEnviarXML" value="Importar" />
                        </div>
                    </div>
                    <div id="resposta">

                    </div>
                    <!--                    <div class="col-md-12">
                                            <progress value="0" max="100"></progress><span id="porcentagem">0%</span>
                                        </div>-->

                </form>
            </div>


        </div>
    </div>
</div>
<!--Fim Modal Imoort-->


<div class="modal fade" id="memail" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-full">

        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title"> Envio de Email NF-e </h4>
            </div>

            <div class="modal-body">
                <div class="row">
                    <input type="hidden" name="nct" id="nnfemail">


                    <div class="col-md-6">
                        <label>E-mail</label>
                        <input name="emailnfe" id="emailnfe" type="text" class="form-control" placeholder="">
                    </div>
                </div>


            </div>
            <div class="modal-footer">
                <button type="submit" id="btnemail" class="btn green"><i id="aguardecanc" style="display: none;" class="fa fa-spinner fa-spin fa-1x fa-fw"></i>Enviar</button>
            </div>
        </div>

        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>



<div class="modal fade" id="lotexml" tabindex="-1" role="dialog" aria-hidden="true" style="overflow-y: auto;">
    <div class="modal-dialog modal-full" style="width: 80%">

        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title">Importação em LOTE XML </h4>
            </div>

            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div id="drop" class="dropzone">
                        </div>
                    </div>
                </div>

            </div>

            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
</div>


<?php
if (isset($_GET['busca'])) :
?>
    <div class="modal-footer">
        <button type="button" class="btn dark btn-outline" data-dismiss="modal">Fechar</button>
        <button type="button" id="selecionanfe" class="btn green">Selecionar</button>
    </div>
<?php
endif;
?>