<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>
        <link href="../../../_frontend/_layout/assets/stylesheets/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <style>

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

            .page {
                width: 21cm;
                min-height: 29.7cm;
                padding: 2cm;
                margin: 1cm auto;
                border: 1px #D3D3D3 solid;
                border-radius: 5px;
                background: white;
                box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
            }

            @media print {
                .page {
                    border: none;
                    border-radius: 0px;
                    box-shadow: 0 0 0px rgba(0, 0, 0, 0.1);
                    margin: 0px;
                    padding: 0px;
                }
            }

        </style>
        <?php
        if ($_POST['gerar'] != 'PDF') :
            ?>
            <link href="../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
            <?php
        endif;
        ?>
    </head>

    <body class="container">

        <?php
        date_default_timezone_set("Brazil/East");
        require_once("../../../functions.php");

        require_once "../../../_backend/_class/Conexao_class.php";
        require_once "../../../_backend/_class/Crud_class.php";
        require_once "../../../_backend/_class/parametros.php";
        ?>
        <?php require_once './cabecalho.php'; ?>

        <?php
//        error_reporting(E_ALL);
//        ini_set('display_errors', 'On');

        if ($_POST['empresa'] == 'T') :
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'estoqueprodutos');
            $sql = "SELECT from emitente";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, true);
            $sum = 'sum (';
            foreach ($dados as $qtdemitente) :
                $sum .= 'estoqueprodutos.qtd' . $qtdemitente->emitenteid . ',';
            endforeach;

            $sum = substr($sum, 0, -1);
            $sum .= ')';
            $_POST['empresa'] = $sum;
        else :
            $_POST['empresa'] = 'estoqueprodutos.qtd' . $_POST['empresa'] . '';
        endif;

//        error_reporting(E_ALL);
//        ini_set('display_errors', 'On');

        function BuscaVariacaoDesc($prod, $variacao, $sigla, $nivel) {
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'estoqueprodutos');
            $sql = "SELECT produtos.variacao, produtos.codigo, 
                    variacao.variacaoid, variacao.var1, variacao.var2, 
                    variacao.var3 ,
                    itensvariacao.variacao, itensvariacao.sigla,
                    itensvariacao.descricao, itensvariacao.nivel
                    FROM produtos 
                    INNER JOIN variacao ON produtos.variacao = variacao.variacaoid 
                    INNER JOIN itensvariacao ON itensvariacao.variacao = variacao.variacaoid                   
                    WHERE codigo = '$prod' 
                    AND variacao.variacaoid = '$variacao'
                    AND itensvariacao.nivel = '$nivel'
                    AND itensvariacao.sigla = '$sigla'";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

//                echo $sql;
            return $dados->descricao;
        }

        function BuscaGradeProduto($prod, $var) {
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'estoqueprodutos');
            $sql = "SELECT produtos.variacao, produtos.codigo, 
                    variacao.variacaoid, variacao.var1, variacao.var2, 
                    variacao.var3 ,
                    itensvariacao.variacao, itensvariacao.sigla,
                    itensvariacao.descricao, itensvariacao.nivel
                    FROM produtos 
                    INNER JOIN variacao ON produtos.variacao = variacao.variacaoid 
                    INNER JOIN itensvariacao ON itensvariacao.variacao = variacao.variacaoid                   
                    WHERE codigo = '$prod' 
                    AND variacaoid = '$var'
                    AND itensvariacao.nivel = '2'";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, true);
//
//            echo $sql;
            return $dados;
        }

        function BuscaEstoque($estoque, $produto) {
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'estoqueprodutos');
            $sql = "SELECT $estoque as estoque, estoqueprodutos.codproduto from estoqueprodutos where codproduto = '$produto'";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

//        echo $sql;
            return $dados->estoque;
        }

        function BuscaProduto($produto) {
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'estoqueprodutos');
            $sql = "SELECT * from produtos where codigo = '$produto'";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

//        echo $sql;
            return $dados;
        }

        function BuscaCategoria($grupo) {
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'estoqueprodutos');
            $sql = "SELECT * from categorias where sigla = '$grupo'";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, false);
            echo $sql;

            return $dados->descricao;
        }

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');

        if (!empty($_POST['grupos'])) :
            $sql = 'Select estoqueprodutos.produto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3, 
            estoqueprodutos.codproduto, ' . $_POST['empresa'] . ' as estoque, 
            produtos.codigo, produtos.categoria,  produtos.fornecedor, grupoprodutos.produto, grupoprodutos.grupo
            FROM estoqueprodutos
           inner join produtos ON produtos.codigo = estoqueprodutos.produto
           inner JOIN grupoprodutos ON produtos.codigo = grupoprodutos.produto

WHERE 1=1';

        else :
            $sql = 'Select estoqueprodutos.produto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3, 
            estoqueprodutos.codproduto, ' . $_POST['empresa'] . ' as estoque, 
            produtos.codigo, produtos.categoria,  produtos.fornecedor
            FROM estoqueprodutos
           inner join produtos ON produtos.codigo = estoqueprodutos.produto

WHERE 1=1';
        endif;

        if ($_POST['estoque'] != 'Geral') :
            if ($_POST['estoque'] === 'Negativo') :
                $sql .= ' AND estoqueprodutos.qtd' . $_POST['empresa'] . ' < 0';
            elseif ($_POST['estoque'] === 'Zero') :
                $sql .= ' AND estoqueprodutos.qtd' . $_POST['empresa'] . ' = 0';
            else :
                $sql .= ' AND estoqueprodutos.qtd' . $_POST['empresa'] . ' > 0';
            endif;
        endif;

        if (!empty($_POST['categoria'])) :
            $sql .= " AND categoria = '" . $_POST['categoria'] . "' ";
        endif;

        if (!empty($_POST['produto'])) :
            $sql .= " AND produto = '" . $_POST['produto'] . "' ";
        endif;

        if (!empty($_POST['fornecedor'])) :
            $sql .= " AND fornecedor = '" . $_POST['fornecedor'] . "' ";
        endif;

        if (!empty($_POST['grupos'])) :
            $grupos = explode('.', $_POST['grupos']);
            $grupobusca = '';
            if ($grupos[0] > 0) :
                $grupobusca = $grupos[0];
            endif;
            if ($grupos[1] > 0) :
                $grupobusca = $grupos[0] . '.' . $grupos[1];
            endif;
            if ($grupos[2] > 0) :
                $grupobusca = $grupos[0] . '.' . $grupos[1] . '.' . $grupos[2];
            endif;
            $sql .= " AND grupoprodutos.grupo like '" . $grupobusca . "%' ";
        endif;
        echo $sql;
        $arrayParam = '';
        $estoqueprodutos = $crud->getSQLGeneric($sql, $arrayParam, true);

        $prod[] = '';
        ?>




        <table class="table" style="font-size: 12px; width: 100%; text-align: left">
            <tr> 
                <td colspan="2" style="width: 60%"><b>Codigo</b></td>
                <td style="width: 15%"><b>COR</b></td>
                <td style="width: 10%"><b>Categoria</b></td>
                <td style="width: 10%"><b>Custo</b></td>
            </tr>
            <?php
            $totalestoque = 0;
            foreach ($estoqueprodutos as $dados) :
//                echo $dados->produto . $dados->var1;
                if (!in_array($dados->produto . $dados->var1, $prod)) :
                    $prod[] = $dados->produto . $dados->var1;
                    $produto = BuscaProduto($dados->produto);
                    $variacao = BuscaGradeProduto($dados->produto, $produto->variacao);
                    ?>

                    <tr> 
                        <td colspan="2" style="width: 60%"><b><?= $dados->produto ?> - <?= $produto->descricao; ?></b></td>
                        <td style="width: 15%"><b><?= $dados->var1 ?> - <?= BuscaVariacaoDesc($dados->produto, $produto->variacao, $dados->var1, '1') ?>
                            </b></td>
                        <td style="width: 10%"><b><?= $produto->categoria ?></b></td>
                        <td style="width: 10%"><b>R$ <?= number_format($produto->custo, $parametros->casadecimal, ',', '.') ?></b></td>
                    </tr>

                    <tr> 
                        <td colspan="5">
                            <table class="table-bordered table" style="font-size: 12px;">

                                <?php
                                for ($i = 0; $i < count($variacao); $i++) {
                                    ?>
                                    <td style="width: 5%">

                                        <b> <?= BuscaVariacaoDesc($dados->produto, $produto->variacao, $variacao[$i]->sigla, '2') ?></b>
                                        <br/>
                                        <?php
                                        if (floor(BuscaEstoque($_POST['empresa'], $dados->produto . $dados->var1 . $variacao[$i]->sigla)) == BuscaEstoque($_POST['empresa'], $dados->produto . $dados->var1 . $variacao[$i]->sigla)) :
                                            echo intval(BuscaEstoque($_POST['empresa'], $dados->produto . $dados->var1 . $variacao[$i]->sigla));
                                        else :
                                            echo BuscaEstoque($_POST['empresa'], $dados->produto . $dados->var1 . $variacao[$i]->sigla);
                                        endif;
                                        $totalestoque = $totalestoque + BuscaEstoque($_POST['empresa'], $dados->produto . $dados->var1 . $variacao[$i]->sigla);
                                        ?>
                                    </td>
                                    <?php
                                }
                                ?>
                            </table>
                        </td>
                    </tr>


                    <?php
                endif;

            endforeach;
            ?>
            <tr>
                <td colspan="4">
                    TOTAL
                </td>
                <td>
                    <?= $totalestoque ?>
                </td>
            </tr>
        </table>
    </body>
</html>
