<?php
require_once("../../../functions.php");
require_once("../_modal/_modal.php");
require_once "../../../_backend/_class/nivel_acesso.php";
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/cobranca_class.php";
?>


<script>

    CarregaReceb();
    $("#addcomanda").focus();

    function Divisao() {
        var pessoa = $("#qtdpessoa").val();
        var total = $("#subtotal").val();
        var divisao = total / pessoa;
//        alert(divisao);
        $("#totalpessoa").html(divisao.toFixed(2));
    }

    function AbrePag(valor, titulo) {
        TotalFalta();
        if (valor == 'O') {
            $("#exibeformapag").css("display", "block");
        } else {
            $("#exibeformapag").css("display", "none");
        }
        $("#formapag").val(valor);
        $("#titulopag").html(titulo);
        $("#pagamentomdl").modal('show');
    }

    function AbreCover() {
        $("#coverart").modal('show');
    }

    function Somapag(valor) {
        var total = parseFloat($('#vrpagar').val()) + parseFloat(valor);
        $('#vrpagar').val(total.toFixed(2));
    }

    function TotalFalta() {

        var texto = 'R$ ' + $("#vrfalta").html() + ' (Faltando)';
        $("#vrfaltando").html(texto);
    }

    function LancaPagamento() {
        var vrpagar = parseFloat($("#vrpagar").val());
        var vrfalta = parseFloat($("#vrfalta").html());
        var troco = 0;
        if ($("#formapag").val() !== 'D') {
            if (vrfalta < vrpagar) {
                bootbox.alert("Valor do pagamento é maior do que o restante que falta!");
                return false;
            }
        } else {
            if (vrpagar > vrfalta) {
                troco = vrpagar - $("#vrfalta").html();
            }
        }

        $("#btnsalvar").attr("disabled", true);
        $("#btnsalvar").html("Aguarde...");

        var comandas = $("#comandas").val();
        const array = comandas.split(",");

        $.ajax({
            type: "POST",
            url: "_backend/_controller/_insert/recebimento_conta_insert.php",
            data: {
                vrpagar: $("#vrpagar").val(),
                troco: troco,
                conta: array[0],
                forma: $("#formapag").val()
            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
                $("#btnsalvar").attr("disabled", false);
                $("#btnsalvar").html("Salvar");
                CarregaReceb();
                $("#pagamentomdl").modal('hide');

            }
        }); //termina o jquery
    }


    function DelPagamento(valor) {
        bootbox.confirm({
            message: "Deseja excluir o lançamento?",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    $.ajax({
                        type: "POST",
                        url: "_backend/_controller/_delete/recebimento_cheff_delete.php",
                        data: {
                            recebimento: valor
                        },
                        cache: false,
                        dataType: "json",
                        success: function (data)
                        {
                            //                    alert(data[0].situacao)
                            if (data.retorno == true) {
                                toastr.success(data.mensagem);
                                CarregaReceb();
                            } else {
                                toastr.warning(data.mensagem);
                            }
                        }
                    });
                }
            }
        });

    }

    function EncerraConta(valor) {

        var vrfalta = parseFloat($("#vrfalta").html());
        if (vrfalta > 0) {
            bootbox.alert("Existe um valor de R$ " + vrfalta + ", restante para pagamento!");
            return false;
        }


        bootbox.confirm({
            message: "Deseja encerrar a conta?",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    $.ajax({
                        type: "POST",
                        url: "_backend/_controller/_update/encerra_conta_cheff.php",
                        data: {
                            comanda: valor,
                            desconto: $("#desconto").val()
                        },
                        cache: false,
                        dataType: "json",
                        success: function (data)
                        {
                            //                    alert(data[0].situacao)
                            if (data.retorno == true) {
                                toastr.success(data.mensagem);
                                Carrega('_form', 'contas_aberta.php', 'Contas em Abertas');
                            } else {
                                toastr.warning(data.mensagem);
                            }
                        }
                    });
                }
            }
        });

    }

    function EncerraContaImp(valor) {

        var vrfalta = parseFloat($("#vrfalta").html());
        if (vrfalta > 0) {
            bootbox.alert("<h3> Existe um valor de R$ " + vrfalta + ", restante para pagamento! </h3>");
            return false;
        }


        bootbox.confirm({
            message: "Deseja encerrar a conta?",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    $.ajax({
                        type: "POST",
                        url: "_backend/_controller/_update/encerra_conta_cheff.php",
                        data: {
                            comanda: valor,
                            desconto: $("#desconto").val()
                        },
                        cache: false,
                        dataType: "json",
                        success: function (data)
                        {
                            //                    alert(data[0].situacao)
                            if (data.retorno == true) {
                                toastr.success(data.mensagem);
                                ReImprimirConta(valor);
                                Carrega('_form', 'contas_aberta.php', 'Contas em Abertas');
                            } else {
                                toastr.warning(data.mensagem);
                            }
                        }
                    });
                }
            }
        });

    }

    function EncerraContaNFce(valor) {

        var vrfalta = parseFloat($("#vrfalta").html());
        if (vrfalta > 0) {
            bootbox.alert("<h3> Existe um valor de R$ " + vrfalta + ", restante para pagamento! </h3>");
            return false;
        }


        bootbox.confirm({
            message: "Deseja encerrar a conta?",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    $.ajax({
                        type: "POST",
                        url: "_backend/_controller/_update/encerra_conta_cheff.php",
                        data: {
                            comanda: valor,
                            desconto: $("#desconto").val()
                        },
                        cache: false,
                        dataType: "json",
                        success: function (data)
                        {
                            //                    alert(data[0].situacao)
                            if (data.retorno == true) {
                                toastr.success(data.mensagem);
                                GeraNFe(valor);
//                                Carrega('_form', 'contas_aberta.php', 'Contas em Abertas');
                            } else {
                                toastr.warning(data.mensagem);
                            }
                        }
                    });
                }
            }
        });

    }

    function CarregaReceb() {
        var conta = $("#conta").val();

        $("#recebeconta").load('_backend/_model/recebimento_chef.php?conta=' + conta + '', function () {

        });
//    $("#tudoinicio").show();
    }

    function DelItem(documento, item) {
        $.ajax({
            type: "POST",
            url: "_backend/_controller/_delete/itmovimentacao_cheff_delete.php",
            data: {
                documento: documento,
                itmovimentacao: item
            },
            cache: false,
            dataType: "json",
            success: function (data)
            {
                //                    alert(data[0].situacao)
                if (data.retorno == true) {
                    $("#nitem").val('');
                    toastr.success(data.mensagem);
                    $("#delitem").hide();
                    $("#cancelaitem").css("display", "none");
                    Carrega('_form', 'pagamento_cheff.php?comanda=<?= $_GET['comanda'] ?>', 'Pagamento de Conta');
                } else {
                    toastr.warning(data.mensagem);
                }
            }
        });
    }



    function ReImprimirConta(valor) {
        $.ajax({
            type: "GET",
            url: "_mobile/_chef/_print/ReImprimi_conta.php",
            data: {
                comanda: valor

            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
//            FechaPedido();
            }
        }); //termina o jquery
    }


    function SomaCover() {
        var qtd = $("#qtdcover").val();
        var valor = $("#vrcover").val();

        var total = qtd * valor;

        $("#totalcover").val(total.toFixed(2));
    }

    $("#inpcouvert").keydown(function (e) {
        if (e.which == 13) {
            var qtd = $("#inpcouvert").val();
            var valor = '8.00';
            var total = qtd * valor;

            var comandas = $("#comandas").val();
            const array = comandas.split(",");

            $.ajax({
                type: "POST",
                url: "_backend/_controller/_insert/cover_insert.php",
                data: {
                    qtd: qtd,
                    valor: valor,
                    total: total,
                    conta: array[0]
                },
                dataType: "json",
                // função para de sucesso
                success: function (data) {
                    //  alert();
//            FechaPedido();
                    if (data.retorno == true) {
                        toastr.success(data.mensagem);
                        Carrega('_form', 'pagamento_cheff.php?comanda=<?= $_GET['comanda'] ?>', 'Pagamento de Conta');

                    } else {
                        toastr.warning(data.mensagem);
                    }
                }
            }); //termina o jquery
        }
    });


    function AdicionaCover() {
        var qtd = $("#qtdcover").val();
        var valor = $("#vrcover").val();
        var total = $("#totalcover").val();

        var comandas = $("#comandas").val();
        const array = comandas.split(",");

        $.ajax({
            type: "POST",
            url: "_backend/_controller/_insert/cover_insert.php",
            data: {
                qtd: qtd,
                valor: valor,
                total: total,
                conta: array[0]
            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
//            FechaPedido();
                if (data.retorno == true) {
                    toastr.success(data.mensagem);
                    Carrega('_form', 'pagamento_cheff.php?comanda=<?= $_GET['comanda'] ?>', 'Pagamento de Conta');

                } else {
                    toastr.warning(data.mensagem);
                }
            }
        }); //termina o jquery
    }

    function ImprimirConta(valor) {
        $.ajax({
            type: "GET",
            url: "_mobile/_chef/_print/conta.php",
            data: {
                comanda: valor

            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
//            FechaPedido();
            }
        }); //termina o jquery
    }



    function Porcentagem() {
        var subtotal = $("#subtotal").text();
        var valor = moedaParaNumero(subtotal);
        var porc = moedaParaNumero($("#descpt").val());
        var calc = (Number(porc) / 100) * Number(valor);
        if (calc > 0) {
            $("#descrs").val(calc.toFixed(2));
            var total = Number(valor) - calc.toFixed(2);
            $("#desctotalsubtotal").html(total.toFixed(2));
            $("#desctotaldesconto").html(calc.toFixed(2));

        } else {
            $("#descrs").val('0,00');
        }
    }

    function PorcentagemVlr() {
        var subtotal = $("#subtotal").text();
        var valortotal = moedaParaNumero(subtotal);
        var valor = moedaParaNumero($("#descrs").val());
        var calc = (Number(valor * 100)) / Number(valortotal);
        if (calc > 0) {
            $("#descpt").val(calc.toFixed(2));
            var total = Number(valortotal) - valor.toFixed(2);
            $("#desctotalsubtotal").html(total.toFixed(2));
            $("#desctotaldesconto").html(valor.toFixed(2));
        } else {
            $("#descpt").val('0,00');
        }
//    $("#descpt").val(calc.toFixed(2));
    }


    function AdicionaComanda(valor) {
        $.ajax({
            type: "GET",
            url: "_backend/_controller/_select/_ajax/verifica_conta_cheff.php",
            data: {
                comanda: valor
            },
            cache: false,
            dataType: "json",
            success: function (data)
            {
                //                    alert(data[0].situacao
                //        
//                alert(data[0].id);
                if (data.id > 0) {
                    var comandas = $("#comandas").val();
                    if (comandas !== '') {
                        const array = comandas.split(",");
                        for (let i = 0; i < array.length; i = i + 1) {
                            if (array[i] === data.id) {
                                toastr.success('Comanda já incluída!');
                                $("#addcomanda").val('');
                                $("#addcomanda").focus();
                                return false;
                            }
                        }
                        var comanda = comandas + "," + data.id;
                    } else {
                        var comanda = data.id;
                    }
                    $("#comandas").val(comanda);
                    $("#addcomanda").val('');
                    Carrega('_form', 'pagamento_cheff.php?comanda=' + comanda + '', 'Pagamento de Conta');
                    $("#addcomanda").focus(); 
                } else {
                    toastr.success('Comanda não utilizada!');
                    $("#addcomanda").val('');
                }
            }
        });
    }

    $("#addcomanda").keydown(function (e) {
        bloquearCtrlJ();
        if (e.which === 13) {
            AdicionaComanda($("#addcomanda").val());
        }
    });

    function bloquearCtrlJ() { // Verificação das Teclas
        var tecla = window.event.keyCode; //Para controle da tecla pressionada
        var ctrl = window.event.ctrlKey; //Para controle da Tecla CTRL

        if (ctrl && tecla == 74) {    //Evita teclar ctrl + j
            event.keyCode = 0;
            event.returnValue = false;
        }
    }


    function numeroParaMoeda(valor)
    {
        return isNaN(valor) == false ? parseFloat(valor) : parseFloat(valor.replace(".", ",").toFixed(2));

    }

    function moedaParaNumero(valor)
    {
        return isNaN(valor) == false ? parseFloat(valor) : parseFloat(valor.replace(".", "").replace(",", "."));
    }


    function GeraNFe(valor) {
        $.ajax({
            type: "GET",
            url: "_backend/_controller/_insert/converte_saida_cheff.php",
            data: {
                comanda: valor,
                controle: '',
                modelo: '65'
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data.nfe > 0) {//                    
                    GeraNFce(data.id);
                } else {
                    bootbox.alert({
                        message: data.mensagem,
                        callback: function () {
                            $(location).attr('href', '');
                        }
                    })
                }
            }
        }); //termina o jquery
        $("#busca").modal('hide');
    }

//GERAÇÃO NFCE
    function GeraNFce(valor) {
//            alert(valor);

        $("#faturamento").hide();
        var dialog = bootbox.dialog({
            message: '<p class="text-center mb-0"><i class="fa fa-spinner fa-pulse fa-fw"></i>  Aguarde Gerando XML...</p>',
            closeButton: false
        });
        $.ajax({
            type: "GET",
            url: "_fiscal/_nfe/geracao/gera_nfce.php?nNF=" + valor,
            dataType: "xml",
            success: function (retorno)
            {

//                alert(status);
                var status = $(retorno).find("status").text();
//                alert(status);

                if (status == 'ok') {
                    dialog.modal('hide');
                    AssinaNFcE(valor);
                } else {
                    toastr.warning('Erro ao Exportar Arquivo.');
                }
            }
        });
    }


    function AssinaNFcE(valor) {
//            alert(valor);

        var dialog = bootbox.dialog({
            message: '<p class="text-center mb-0"><i class="fa fa-spinner fa-pulse fa-fw"></i>  Assinando XML...</p>',
            closeButton: false
        });
//    document.getElementById('alertsucesso').style.display = 'Block';
//    document.getElementById('sucesso').innerHTML = '';
        $.ajax({
            type: "GET",
            url: "_fiscal/_nfe/geracao/assina_nfce.php",
            data: {
                arquivo: valor
            },
            dataType: "xml",
            success: function (retorno)
            {
                var status = $(retorno).find("status").text();
                if (status == 'OK') {
                    dialog.modal('hide');
                    TransmiteNFcE(valor);
                } else {
                    bootbox.alert($(retorno).find("motivo").text(), function () {
                        $(location).attr('href', 'cheff_balcao.php');
                    });
                }
            }
        });
    }


    function TransmiteNFcE(valor) {
//            alert(valor);
        var dialog = bootbox.dialog({
            message: '<p class="text-center mb-0"><i class="fa fa-spinner fa-pulse fa-fw"></i>  Enviando XML ao Sefaz...</p>',
            closeButton: false
        });
        $.ajax({
            type: "GET",
            url: "_fiscal/_nfe/geracao/envia_nfce.php?arquivo=" + valor,
            dataType: "xml",
            success: function (retorno)
            {
                var status = $(retorno).find("status").text();
                if (status == 'OK') {
                    dialog.modal('hide');
                    RetornoNFcE($(retorno).find("recibo").text(), valor);
                } else {

                    bootbox.alert($(retorno).find("motivo").text(), function () {
                        $(location).attr('href', 'cheff_balcao.php');
                    });
                }
            }
        });
    }


    function RetornoNFcE(valor, nct) {
//            alert(valor);
        var dialog = bootbox.dialog({
            message: '<p class="text-center mb-0"><i class="fa fa-spinner fa-pulse fa-fw"></i>  Retornando Dados do Sefaz...</p>',
            closeButton: false
        });
        $.ajax({
            type: "GET",
            url: "_fiscal/_nfe/geracao/consulta_recibo_nfce.php?arquivo=" + nct,
            dataType: "xml",
            success: function (retorno)
            {
                var status = $(retorno).find("status").text();
                if (status == 'OK') {
                    window.open('_fiscal/_prints/geracao/danfce.php?nNFbd=' + nct + '', '',
                            'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
                    Carrega('_form', 'contas_aberta.php', 'Contas em Abertas');
                } else {
                    bootbox.alert($(retorno).find("motivo").text(), function () {
                        Carrega('_form', 'contas_aberta.php', 'Contas em Abertas');
                    });
                }
            }
        });
    }

</script>
<div class="row">
    <div class="col-md-12">
        <input type="text" class="form-control" id="addcomanda" style="height: 40px" placeholder="Nº Comanda">
        <hr/>
    </div>
</div>

<?php
if (!isset($_GET['comanda'])) :
    ?>
    <input type="hidden" id="comandas">
    <?php
    exit;
endif;
?>

<input type="hidden" id="comandas" value="<?= $_GET['comanda'] ?>">


<div class="row">
    <div class="col-md-6" style="max-height: 400px; overflow-y: scroll">
        <table class="table table-hover table-striped" >
            <tr>
                <!--onclick="Carrega('_form', 'pagamento_cheff.php?comanda=<?= $conta->id ?>', 'Pagamento de Conta')"-->
                <th>
                    <?php
                    if (isset($_GET['del'])) :
                        ?>
                        <button class="btn btn-info btn-sm" type="button" onclick="Carrega('_form', 'pagamento_cheff.php?comanda=<?= $_GET['comanda'] ?>', 'Pagamento de Conta')"> <i class="fa fa-list"></i></button>
                        <?php
                    else :
                        ?>
                        <button class="btn btn-danger btn-sm" type="button" onclick="Carrega('_form', 'pagamento_cheff.php?del=S&comanda=<?= $_GET['comanda'] ?>', 'Pagamento de Conta')"> <i class="fa fa-trash"></i></button>
                    <?php
                    endif;
                    ?>
                </th>
                <th>Produto</th>
                <th>Quantidade</th>
                <th>V. Unit</th>
                <th>Total</th>
            </tr>


            <tr>
                <?php
                $pdo = Conexao::getInstance();
                $crud = Crud::getInstance($pdo, 'emitente');
                $sql = "SELECT * from checkin where conta = " . $_GET['comanda'] . " ";
                $arrayParam = '';
                $checkin = $crud->getSQLGeneric($sql, $arrayParam, false);
                ?>
                <td></td>
                <!--<td>ACOMODAÇÃO</td>-->
                <td><?= $checkin->hospede ?></td>
                <td></td>
                <td><?= $checkin->valortotal ?></td>
            </tr>
            <?php

//            $checkin = 0;

            function BuscaDesc($produto) {
                $pdo = Conexao::getInstance();
                $crud = Crud::getInstance($pdo, 'estoqueprodutos');
                $sql = "SELECT produtos.codigo, produtos.descricao, estoqueprodutos.produto, estoqueprodutos.codproduto
                        from estoqueprodutos INNER JOIN produtos on produtos.codigo = estoqueprodutos.produto 
                        where codproduto = '$produto' ";
                $arrayParam = '';
                $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

                return $dados->descricao;
            }

            function BuscaUsuario($documento) {
                $pdo = Conexao::getInstance();
                $crud = Crud::getInstance($pdo, 'estoqueprodutos');
                $sql = "SELECT movimentacao.documento, movimentacao.conta, movimentacao.usuario,
                    usuario.usuarioid, usuario.usuarionome from movimentacao
                    INNER JOIN usuario on usuario.usuarioid = movimentacao.usuario
                    where documento = '$documento'";
                $arrayParam = '';
                $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

//                echo $sql;
                return $dados->usuarionome;
            }

            function BuscaHora($doc) {
                $pdo = Conexao::getInstance();
                $crud = Crud::getInstance($pdo, 'emitente');
                $sql = "SELECT documento, hora from movimentacao where documento = '$doc'";
                $arrayParam = '';
                $documento = $crud->getSQLGeneric($sql, $arrayParam, false);

                return $documento->hora;
            }

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'emitente');
            $sql = "SELECT documento, conta, usuario from movimentacao where conta in(" . $_GET['comanda'] . ")";
            $arrayParam = '';
            $documento = $crud->getSQLGeneric($sql, $arrayParam, true);
//            SELECT documento, conta from movimentacao where conta in('2,3,5')
//            echo $sql;
            $doc = '';
            foreach ($documento as $documento) :
                $doc .= $documento->documento;
                $doc .= ',';
            endforeach;

            $doc = substr($doc, 0, -1);

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'emitente');
            if (isset($_GET['del'])) :
                $sql = "SELECT documento, item, produto, preco, valorbruto as valorbruto,
    valorliquido as valorliquido, quantidade as quantidade from itmovimentacao 
    where documento IN (" . $doc . ") and cancelado = 'N'";
            else :
                $sql = "SELECT documento, produto, preco, Sum(valorbruto) as valorbruto,
    Sum(valorliquido) as valorliquido, Sum(quantidade) as quantidade from itmovimentacao where documento IN (" . $doc . ") and cancelado = 'N'
        GROUP by produto, preco";
            endif;

            $arrayParam = '';
            $itens = $crud->getSQLGeneric($sql, $arrayParam, true);
//            echo $sql;
            $total = 0;
            foreach ($itens as $itens) :
                $total = $total + $itens->valorliquido;
                if (floor($itens->quantidade) != $itens->quantidade) :
                    $qtd = rtrim($itens->quantidade, "0");
                else :
                    $qtd = intval($itens->quantidade);
                endif;
//         
                ?>

                <tr>
                    <td>
                        <?php
                        if (isset($_GET['del'])) :
                            ?>
                            <button class="btn btn-danger btn-sm" onclick="DelItem('<?= $itens->documento ?>', '<?= $itens->item ?>')" type="button"> <i class="fa fa-trash"></i></button>
                            <?php
                        endif;
                        ?>
                    </td>
                    <td>
                        <?= BuscaDesc($itens->produto) ?>

                        <?php
                        if (isset($_GET['del'])) :
                            ?>
                            <br/>   <?= BuscaUsuario($itens->documento) ?> (<?= BuscaHora($itens->documento) ?>)
                            <?php
                        endif;
                        ?>
                    </td>
                    <td><?= $qtd ?></td>
                    <td><?= number_format($itens->preco, 2, ',', '') ?></td>
                    <td><?= number_format($itens->valorliquido, 2, ',', '') ?></td>
                </tr>


                <?php
            endforeach;
            ?>
        </table>
        <div class="row">
            <div class="col-md-6 text-right">SUBTOTAL</div>
            <div class="col-md-6 text-right">R$ <?= number_format($total + $checkin->valortotal, 2, ',', '') ?></div>
        </div>
        <div class="row">
            <div class="col-md-6 text-right">SINAL</div>
            <div class="col-md-6 text-right">R$ <?= number_format($checkin->valor, 2, ',', '') ?></div>
        </div>
        <div class="row">
            <div class="col-md-6 text-right">SERVIÇO</div>
            <?php
//            $porc = (10 / 100) * $total;
            $porc = 0;
            ?>
            <div class="col-md-6 text-right">R$ <?= number_format($porc, 2, ',', '') ?></div>
        </div>



        <?php
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'emitente');
        $sql = "SELECT * from inclui_conta where conta in(" . $_GET['comanda'] . ")";
        $arrayParam = '';
        $cover = $crud->getSQLGeneric($sql, $arrayParam, true);

        $vrcover = 0;
        $totalcv = count($cover);
        if ($totalcv > 0) :
            foreach ($cover as $dadoscover) :
                $vrcover = $vrcover + ($dadoscover->qtd * $dadoscover->valor);
                ?>
                <div class="row">
                    <div class="col-md-6 text-right"><?= $dadoscover->descricao ?> (<?= $dadoscover->qtd ?>)</div>
                    <div class="col-md-6 text-right">R$ <?= number_format($dadoscover->qtd * $dadoscover->valor, 2, ',', '') ?></div>
                </div>
                <?php
            endforeach;

        endif;
        ?>



        <div class="row">
            <div class="col-md-6 text-right">TOTAL A PAGAR</div>
            <div class="col-md-6 text-right">R$ <?= number_format($total + $vrcover + $checkin->valortotal + $porc - $checkin->valor, 2, ',', '') ?></div>
        </div>

        <input type="hidden" id="subtotal" value="<?= $total + $vrcover + $checkin->valortotal + $porc - $checkin->valor ?>">

    </div>

    <div class="col-md-6">
        <div class="row">
            <div class="col-md-3"> 
                <input type="number" min="1" max="99" value="1" onkeyup="Divisao()" onclick="Divisao()" id="qtdpessoa" class="form-control">
            </div>
            <div class="col-md-3 text-left">Pessoas</div>
            <div class="col-md-6 text-right">Total por pessoa: R$ <span id="totalpessoa"><?= number_format($total + $checkin->valortotal + $porc - $checkin->valor, 2, ',', '') ?> </span></div>
        </div>
        <Br/>
        <div class="row">
            <div class="col-md-4">
                <button class="btn btn-success form-control" onclick="AbrePag('D', 'DINHEIRO')"> <i class="fa fa-money"></i> Dinheiro</button>
            </div>

            <div class="col-md-4">
                <button class="btn btn-success form-control" onclick="AbrePag('CD', 'C. DÉBITO')"> <i class="fa fa-credit-card-alt"></i> Débito</button>
            </div>

            <div class="col-md-4">
                <button class="btn btn-success form-control" onclick="AbrePag('CC', 'C. CRÉDITO')"> <i class="fa fa-credit-card"></i> Crédito</button>
            </div>
        </div>

        <br/>
        <div class="row">
            <div class="col-md-4">
                <button class="btn btn-success form-control" onclick="AbrePag('PX', 'PIX')"> <i class="fa fa-money"></i> Pix</button>
            </div>


            <div class="col-md-4">
                <button class="btn btn-success form-control" onclick="AbrePag('VR', 'V. REFEIÇÃO')"> <i class="fa fa-list-ol"></i> V. Refeição</button>
            </div>


            <div class="col-md-4">
                <button class="btn btn-success form-control" onclick="AbrePag('O', 'OUTROS')"> <i class="fa fa-list"></i> Outros</button>
            </div>
        </div>
        <div class="row">
            <br/>
            <div class="col-md-12" id="recebeconta" style="max-height: 250px; overflow-y: scroll">

            </div>
        </div>

        <div class="row"> 

            <hr/>
            <div class="col-md-5"></div>
            <div class="col-md-3 label-default text-bold">
                <h4>
                    DESCONTO:
                </h4>
            </div>
            <div class="col-md-3 label-success text-bold text-right">
                <h4>
                    <input id="desconto" onblur="CarregaReceb()" onkeypress="mascara(this, mvalor);" value="0.00" type="text" class="form-control">
                </h4>
            </div>
            <div class="col-md-1"></div>

        </div>

        <div class="row"> 

            <div class="col-md-5">
                <div class="col-md-7">
                    <button class="btn btn-info" onclick="AbreCover()"> Couvert </button> 
                </div>
                <div class="col-md-7">
                    <input type="text" class="form-control" id="inpcouvert">
                </div>
            </div>
            <div class="col-md-3 label-default text-bold">
                <h4>
                    PAGO:
                </h4>
            </div>
            <div class="col-md-3 label-success text-bold text-right">
                <h4>
                    R$ <span id="vrpago">0.00</span>
                </h4>
            </div>
            <div class="col-md-1"></div>

        </div>

        <div class="row">
            <div class="col-md-5"></div>

            <div class="col-md-3 label-default text-bold">
                <h4>
                    FALTA: 
                </h4>
            </div>
            <div class="col-md-3 label-warning text-bold text-right">
                <h4>
                    R$ <span id="vrfalta"><?= number_format($total + $porc, 2, '.', '') ?></span>
                </h4>
            </div>
            <div class="col-md-1"></div>

        </div>

        <div class="row">
            <div class="col-md-5"></div>
            <div class="col-md-3 label-default text-bold">
                <h4>
                    TROCO:
                </h4>
            </div>
            <div class="col-md-3 label-success text-bold text-right">
                <h4>
                    R$ <span id="vrtroco">0.00</span>
                </h4>
            </div>
            <div class="col-md-1"></div>

        </div>

        <div class="row">

            <hr/>
            <div class="col-md-12">
                <?php

                function ComandaConta($valor) {
                    $pdo = Conexao::getInstance();
                    $crud = Crud::getInstance($pdo, 'emitente');
                    $sql = "SELECT * from abre_conta where id = '" . $valor . "'";
                    $arrayParam = '';
                    $conta = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

                    return $conta->comanda;
                }
                ?>
                <h5> COMANDAS: <b> <?php
                        $comandas = $_GET['comanda'];
                        $comandas = explode(",", $comandas);

$totalcomanda  = count($comandas);
                        $totalcom = count($comandas);
                        for ($index = 0; $index < count($comandas); $index++) :
                            echo ComandaConta($comandas[$index]);
                            if ($totalcom == $index + 1) :
                                echo '';
                            else:
                                echo ' , ';
                            endif;
                        endfor;
                        ?> </b>
                        <br/>
                        TOTAL DE COMANDAS: <b></b><?= $totalcomanda ?></b>
                </h5>
                <br/>
            </div>
            <div class="col-md-3"> <button style="height: 60px;" class="btn btn-primary form-control" onclick="ImprimirConta('<?= $_GET['comanda'] ?>')">Imprimir </button> </div>
            <div class="col-md-3"> <button style="height: 60px;" class="btn btn-primary form-control" onclick="EncerraConta('<?= $_GET['comanda'] ?>')">Encerrar</button> </div>
            <div class="col-md-3"> <button style="height: 60px;" class="btn btn-primary form-control" onclick="EncerraContaImp('<?= $_GET['comanda'] ?>')">Encerrar e imprimir</button> </div>
            <div class="col-md-3"> <button style="height: 60px;" class="btn btn-warning form-control" onclick="EncerraContaNFce('<?= $_GET['comanda'] ?>')">Encerrar e Gerar NFce</button> </div>
        </div>
    </div>   
</div>



<div class="modal fade" id="pagamentomdl" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-full">

        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title">LANÇAR PAGAMENTO - <span id="titulopag"> </span></h4>
            </div>

            <div class="modal-body" > 
                <div class="row">
                    <div class="col-md-12">
                        <label>Valor pago (R$)</label>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">                          
                        <input type="hidden" id="conta" value="<?= $_GET['comanda'] ?>">
                        <input type="text" name="vrpagar" value="0.00" id="vrpagar" class="form-control" onkeypress="mascara(this, mvalor);">
                        <input type="hidden" id="vrtroco" value="0.00">
                    </div>
                    <div class="col-md-4">
                        <button class="btn btn-info form-control" id="vrfaltando" onclick="$('#vrpagar').val($('#vrfalta').html())">R$ 0.00 (Faltando)</button>
                    </div>
                    <div class="col-md-4">
                        <button class="btn btn-warning form-control" onclick="$('#vrpagar').val('0.00')">LIMPAR</button>
                    </div>
                </div>
                <div class="row" id="exibeformapag" style="display: none;">
                    <hr/>
                    <div class="col-md-6">
                        <label>Forma de Pagamento</label>
                        <select name="forma" id="formapag" class="form-control">
                            <?php
                            foreach ($cobrancas as $tcobrancas) :
                                ?>
                                <option value="<?= $tcobrancas->sigla ?>"> <?= $tcobrancas->descricao ?> </option>
                                <?php
                            endforeach;
                            ?>
                        </select>
                    </div>

                </div>

                <div class="row">
                    <hr/>
                    <div class="col-md-2">
                        <button class="btn btn-success form-control" onclick="Somapag('2')">2,00</button>
                    </div>
                    <div class="col-md-2">
                        <button class="btn btn-success form-control" onclick="Somapag('5')">5,00</button>
                    </div>
                    <div class="col-md-2">
                        <button class="btn btn-success form-control" onclick="Somapag('10')">10,00</button>
                    </div>
                    <div class="col-md-2">
                        <button class="btn btn-success form-control" onclick="Somapag('20')">20,00</button>
                    </div>
                    <div class="col-md-2">
                        <button class="btn btn-success form-control" onclick="Somapag('50')">50,00</button>
                    </div>
                    <div class="col-md-2">
                        <button class="btn btn-success form-control" onclick="Somapag('100')">100,00</button>
                    </div>
                </div>

            </div>

            <div class="modal-footer">
                <button type="button" id="btnsalvar" onclick="LancaPagamento()" class="btn btn-info">Salvar</button>
            </div>

            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
</div>


<div class="modal fade" id="coverart" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-full">

        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title">LANÇAR COUVERT</h4>
            </div>

            <div class="modal-body" > 
                <div class="row">
                    <div class="col-md-4">
                        <label>Quantidade</label>
                        <input type="number" name="qtdcover" onkeyup="SomaCover()" id="qtdcover" class="form-control">
                    </div>
                    <div class="col-md-4">
                        <label>Valor</label>
                        <input type="text" onkeyup="SomaCover()" name="vrcover" value="0.00" id="vrcover" class="form-control" onkeypress="mascara(this, mvalor);">
                    </div>
                    <div class="col-md-4">
                        <label>Total</label>
                        <input type="text" name="totalcover" value="0.00" id="totalcover" class="form-control" readonly="">
                    </div>
                </div>

            </div>

            <div class="modal-footer">
                <button type="button" id="btnsalvar" onclick="AdicionaCover()" class="btn btn-info">Salvar</button>
            </div>

            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
</div>



