<?php
date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
require_once("../../_class/Conexao_class.php");
require_once("../../_class/Crud_class.php");
require_once("../../_class/Emitente_class.php");
require_once "../../_class/cobranca_class.php";
require_once "../../_class/parametros.php";
?>
<link href="<?= FRONTEND ?>/_layout/assets/javascripts/easyautocomplete/easy-autocomplete.min.css" rel="stylesheet" type="text/css"/>
<script src="<?= FRONTEND ?>/_layout/assets/javascripts/easyautocomplete/jquery.easy-autocomplete.min.js" type="text/javascript"></script>

<?php
if (isset($_GET['editar'])) :
    $editar = $_GET['editar'];
    ?>
    <script>
        $(document).ready(function () {
            $("#loading").text("Salvar O.S");
            //        alert(valor);
            $.ajax({
                type: "GET",
                url: "<?= BACKEND ?>/_controller/_select/_ajax/os_select_ajax.php?documento=<?= $editar ?>",
                            dataType: "json",
                            // função para de sucesso
                            success: function (data) {
                                //  alert();
                                if (data != null) {

                                    $.each(data, function () {
                                        $.each(this, function (k, v) {
                                            $("input[name='" + k + "']").val(v);
                                            $("select[name='" + k + "']").val(v);
                                            $("textarea[name='" + k + "']").val(v);
                                            if (k == 'doc_empresa') {
                                                $("#numeroos").html(v);
                                            }
                                            if (k == 'cliente') {
                                                ClienteEdit(v);
                                            }
                                            if (k == 'desconto') {
                                                $("#ivalordesc").val(v);
                                                $("#valordesconto").html(v);
                                            }
                                            //                                            console.log(k + "=>" + v);
                                        });
                                    });
                                    setTimeout(function () {
                                        CarregaProd();
                                        CarregaServicos();
                                        $("#navprod").css("display", 'inline-block');
                                        $("#navservicos").css("display", 'inline-block');
                                        $("#navpagamento").css("display", 'inline-block');
                                        $("#veiculocliente").val(data[0].veiculo);

                                    }, 3000);
                                }
                            }
                        }); //termina o jquery

                    });
    </script>
    <?php
else :
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'usuario');
    $sql = "SELECT usuario.usuarioid, 
    vendedor.vendedorid, vendedor.usuario from usuario inner join vendedor ON vendedor.usuario = usuario.usuarioid WHERE usuarioid = " . $_SESSION['UsuarioID'] . " and excluido = 'N'";
    $arrayParam = '';
    $dadosve = $crud->getSQLGeneric($sql, $arrayParam, false);
endif
?>


<script>
    var vendedorid = '<?= $dadosve->vendedorid ?>';
    if (vendedorid > 0) {
        $("#vendedor").val(vendedorid);
    }
    Usuario('<?= $_SESSION['UsuarioID'] ?>');

    function CalculaDiferenca(parcela, valor) {
        var valordife = 0;
        var valorparcela = 0;
        var pparcela = 0;
        var totalparcela = $("#parceladif").val();
        var totalparcelar = 0;
        var vtotal = $("#ivaloros").val();
        var valorparcelca = moedaParaNumero(valor);
        var total = 0;
        var totalsomap = 0;
        var totaldiferenca = 0;
        if (valorparcelca > 0) {
            var z;
            for (z = 1; z <= parcela; z++) {
//            pparcela = z + 1;
                total = moedaParaNumero(total) + moedaParaNumero($("#pvalor" + z + "").val());
//            console.log($("#pvalor" + z + "").val());

            }

//        console.log(moedaParaNumero(vtotal));
//        console.log(moedaParaNumero(total));
            valordife = moedaParaNumero(vtotal) - moedaParaNumero(total);
//        console.log(moedaParaNumero(valordife));
            totalparcelar = totalparcela - parcela;
            console.log('Parcela ' + parcela);
            console.log('Total Parcela ' + totalparcelar);
            valorparcela = moedaParaNumero(valordife) / moedaParaNumero(totalparcelar);
//        alert(valorparcela);

            var i;
            pparcela = moedaParaNumero(parcela) + 1;
            for (i = pparcela; i <= totalparcela; i++) {
//            console.log(valorparcela.toFixed(2));
//            console.log(totalsomap.toFixed(2));

//            console.log(i);
//            console.log('Total pp ' + totalparcela);
                if (moedaParaNumero(i) === moedaParaNumero(totalparcela)) {
//                alert(i);
                    totaldiferenca = moedaParaNumero(valordife) - moedaParaNumero(totalsomap);
//                console.log('Total Diferenca ' + totaldiferenca.toFixed(2));
                    $("#pvalor" + i + "").val(totaldiferenca.toFixed(2));
                } else {
                    totalsomap = moedaParaNumero(totalsomap) + moedaParaNumero(valorparcela.toFixed(2));
//                console.log('Não entrou');
                    $("#pvalor" + i + "").val(valorparcela.toFixed(2));
                }

            }
        }

        CalculaTroco();
    }


    function numeroParaMoeda(valor)
    {
        return isNaN(valor) == false ? parseFloat(valor) : parseFloat(valor.replace(".", ",").toFixed(2));
    }

    function moedaParaNumero(valor)
    {
        return isNaN(valor) == false ? parseFloat(valor) : parseFloat(valor.replace(".", "").replace(",", "."));
    }

    function MudaFormaPag(parcela, forma) {
        var pparcela = 0;
        var totalparcela = $("#parceladif").val();
        var i;
        for (i = parcela; i <= totalparcela; i++) {
            pparcela = moedaParaNumero(i) + 1;
            $("#tipop" + pparcela + "").val(forma);
        }

//tipop
    }

    function GeraCondPag(valor) {
        if (valor == '') {
            return false;
        }
//        alert($("#vrtotalf").text());
        $.ajax({
            type: "GET",
            url: "_backend/_controller/_select/_ajax/gera_parcela_select_ajax_.php",
            data: {
                condpagamento: valor,
                valor: $("#ivaloros").val()
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                $("#recebepag").html('');
                var opcoes = '';
                $.each(data, function (i, item) {
//                                    alert(item.parcela);
                    $("#parceladif").val(item.parcela);
                    opcoes += '<div class="row">' +
                            '<div class="col-md-3">' +
                            '<input type="text" name="datap[]" id="dfoco' + item.parcela + '" onkeypress="mascaraData(this)" maxlength="10" class="form-control" value="' + item.data + '">' +
                            '</div>' +
                            '<div class="col-md-4">' +
                            ' <select name="tipop[]" id="tipop' + item.parcela + '" onchange="MudaFormaPag(\'' + item.parcela + '\', this.value)" class="form-control">' +
<?php
foreach ($cobrancas as $tcobrancas) :
    ?>
                        '<option value="<?= $tcobrancas->sigla ?>"> <?= $tcobrancas->descricao ?> </option>' +
    <?php
endforeach;
?>
                    '</select>' +
                            '</div>' +
                            '<div class="col-md-3">' +
                            '<input type="text" name="valorp[]" id="pvalor' + item.parcela + '" onblur="CalculaDiferenca(\'' + item.parcela + '\', this.value)" class="form-control vtotalpagamentodt" value="' + item.valor + '">' +
                            '</div>' +
                            '</div>';
//                    alert(opcoes);


                });
                $("#recebepag").html(opcoes);
                $("#dfoco1").focus();
                $("#dfoco1").select();
//                                CalculaDiferenca();
            }

        }); //termina o jquery


    }


</script>

<script>

    Cliente("1");
    $(document).on("keydown", "#nomecliente", function () {
        var caracteresDigitados = parseInt($(this).val().length);
        if (caracteresDigitados > 4) {
            LimpaId();
        }
    });
    var options = {

        url: function (phrase) {
            return "_backend/_controller/_select/_ajax/cliente_auto_select_ajax.php";
        },
        getValue: function (element) {
            return element.xNome;
        },
        template: {
            type: "description",
            fields: {
                description: "whatsapp"
            }
        },
        ajaxSettings: {
            dataType: "json",
            method: "POST",
            data: {
                dataType: "json"
            }
        },
        list: {
            onClickEvent: function () {
                var selectedItemValue = $("#nomecliente").getSelectedItemData().value;
                Cliente(selectedItemValue);
            },
            onKeyEnterEvent: function () {
                var selectedItemValue = $("#nomecliente").getSelectedItemData().value;
                Cliente(selectedItemValue);
            },
        },
        preparePostData: function (data) {
            data.phrase = $("#nomecliente").val();
            return data;
        },
        requestDelay: 400
    };
    $('#nomecliente').easyAutocomplete(options);
    var optionspd = {

        url: function (phrase) {
            return "_backend/_controller/_select/_ajax/produtos_select_ajax_autocomplete.php";
        },
        getValue: function (element) {
            return element.codigo + ' | ' + element.descricao + ' | ' + element.estoque + ' ' + element.unidade;
        },
        ajaxSettings: {
            dataType: "json",
            method: "POST",
            data: {
                dataType: "json"
            }
        },
        list: {
            onClickEvent: function () {
                $("#codigo").val($("#descproduto").getSelectedItemData().codigo);
                BuscaProdOS();
            },
            onSelectItemEvent: function () {
                $("#codigo").val($("#descproduto").val());
            },
            onKeyEnterEvent: function () {
                $("#codigo").val($("#descproduto").getSelectedItemData().codigo);
                //                BuscaProd();
            },
            maxNumberOfElements: 20

        },
        preparePostData: function (data) {
            data.term = $("#codigo").val();
            return data;
        },
        requestDelay: 400
    };
    $("#descproduto").easyAutocomplete(optionspd);


    function ClienteEdit(valor) {
        if (valor == '') {
            return false;
        }
        //        alert(valor);
        $.ajax({
            type: "GET",
            url: "_backend/_controller/_select/_ajax/cliente_veic_select_ajax.php",
            data: {
                cliente: valor
            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
                if (data != '') {
                    //                    alert(data[0].xNome);
                    $("#nomecliente").val(data[0].xNome);
                    $("#clientewpp").val(data[0].whatsapp);
                    $("#cliente").val(data[0].clienteid);
                    PreencheVeiculo(data[0].clienteid);


                } else {
                    $("#cliente").val('');
                    $("#nomecliente").val('');
                    toastr.warning('Cliente Não Encontrado');
                }
            }
        }); //termina o jquery


        $("#buscaostabs").modal('hide');
    }

    function Cliente(valor) {
        if (valor == '') {
            return false;
        }
        //        alert(valor);
        $.ajax({
            type: "GET",
            url: "_backend/_controller/_select/_ajax/cliente_veic_select_ajax.php",
            data: {
                cliente: valor
            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
                if (data != '') {
                    //                    alert(data[0].xNome);
                    $("#nomecliente").val(data[0].xNome);
                    $("#clientewpp").val(data[0].whatsapp);
                    $("#cliente").val(data[0].clienteid);
                    PreencheVeiculo(data[0].clienteid);

                    setTimeout(function () {
                        SelecionaVeic(data[0].veiculoid);
                    }, 1000);

                } else {
                    $("#cliente").val('');
                    $("#nomecliente").val('');
                    toastr.warning('Cliente Não Encontrado');
                }
            }
        }); //termina o jquery


        $("#buscaostabs").modal('hide');
    }

    function SelecionaVeic(valor) {
//        alert(valor);
        $("#veiculocliente").val(valor);
    }


    function Servicos(valor) {
        if (valor == '') {
            return false;
        }
        //        alert(valor);
        $.ajax({
            type: "GET",
            url: "_backend/_controller/_select/_ajax/servicos_select_ajax.php",
            data: {
                servicos: valor
            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
                if (data != '') {
                    //                    alert(data[0].xNome);
                    $("#servicosid").val(data[0].servicosid);
                    $("#servicosdescricao").val(data[0].descricao);
                    $("#servicosvalor").val(data[0].valor);
                    $("#servicosquantidade").val('1');
                    SomaServico();
                } else {
                    $("#servicos").val('');
                    $("#servicosdescricao").val('');
                    $("#servicosvalor").val('');
                    toastr.warning('Serviço Não Encontrado');
                }
            }
        }); //termina o jquery


        $("#buscaostabs").modal('hide');
    }

    function BuscaOS(valor) {
        $("#buscaostabs").modal('show');
        $("#buscatitle").html('BUSCA ' + valor.toUpperCase());
        $("#carregandobusca").css("display", "block");
        $("#recebegrid").load('_backend/_view/_grid/' + valor + '_grid.php?busca=S', function () {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }

    function PreencheVeiculo(cliente) {
        $.ajax({
            type: "GET",
            url: "_backend/_controller/_select/_ajax/cliente_veiculos_ajax.php",
            data: {
                cliente: cliente
            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                var option = '';
                $.each(data, function (i, obj) {
                    option += '<option value="' + obj.veiculoid + '"> ' + obj.placa + ' - ' + obj.modelo + ' </option>';
                });
                $('#veiculocliente').html(option).show();
            }
        }); //termina o jquery
    }

    function Produto(valor) {
        $("#buscaostabs").modal('hide');
        $("#tudo").hide();
        $("#codigo").val(valor);
        BuscaProdOS();
    }

    function BuscaProdOS() {
        if ($("#codigo").val() === '') {
            Busca('grade_produtos');
            return false;
        }
        //                        alert("buscaproduto");
        $.ajax({type: "GET",
            url: "_backend/_controller/_select/_ajax/frentecaixa/produtos_mov_select_ajax.php", data: {
                produto: $("#codigo").val(),
                tbpreco: $("#tbpreco").val(),
                qtd: '1',
                tipo: 'Saida'
            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                if (data.retorno == true) {
                    //                    alert(data[0].xNome);
                    var preco = data.preco.replace(",", ".");
                    var total = parseFloat(data.qtd) * parseFloat(preco);
                    //                    alert(total);
                    $("#codigo").val(data.produto);
                    $("#quantidade").val(data.qtd);
                    $("#valor").val(data.preco);
                    $("#descproduto").val(data.descricao);
                    $("#total").val(total.toFixed(2));
                    $("#quantidade").focus();
                    $("#quantidade").select();
                } else {
                    $("#codigo").focus();
                }
            }
        }); //termina o jquery
    }


    function SomaProduto() {
        var qtd = $("#quantidade").val();
        var valor = $("#valor").val();
        var total = parseFloat(qtd) * parseFloat(valor);
        $("#total").val(total.toFixed(2));
    }

    function SomaServico() {
        var qtd = $("#servicosquantidade").val();
        var valor = $("#servicosvalor").val();
        var total = parseFloat(qtd) * parseFloat(valor);
        $("#servicostotal").val(total.toFixed(2));
    }

    function onlynumber(evt) {
        var theEvent = evt || window.event;
        var key = theEvent.keyCode || theEvent.which;
        key = String.fromCharCode(key);
        //var regex = /^[0-9.,]+$/;
        var regex = /^[0-9.]+$/;
        if (!regex.test(key)) {
            theEvent.returnValue = false;
            if (theEvent.preventDefault)
                theEvent.preventDefault();
        }
    }

    function ADDitenOS() {
        if ($("#codigo").val() == '') {
            $("#codigo").focus();
            return false;
        } else {
            var codigo = $("#codigo").val();
            $("#codigo").val('');
        }

        $.ajax({type: "GET",
            url: "_backend/_controller/_insert/itos_insert.php", data: {
                produto: codigo,
                documento: $("#documento").val(),
                quantidade: $("#quantidade").val(),
                valor: $("#valor").val(),
                tbpreco: $("#tbpreco").val()

            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
                if (data.retorno == true) {
                    toastr.options = {
                        "closeButton": false,
                        "debug": false,
                        "newestOnTop": false,
                        "progressBar": true,
                        "positionClass": "toast-top-right",
                        "preventDuplicates": false,
                        "onclick": null,
                        "showDuration": "1000",
                        "hideDuration": "1000",
                        "timeOut": "1000",
                        "extendedTimeOut": "1000",
                        "showEasing": "swing",
                        "hideEasing": "linear",
                        "showMethod": "fadeIn",
                        "hideMethod": "fadeOut"
                    };
                    toastr.success(data.mensagem);
                    CarregaProd();
                    $("#codigo").val('');
                    $("#quantidade").val('');
                    $("#valor").val('');
                    $("#descproduto").val('');
                    $("#codigo").focus();

                } else {
                    toastr.warning(data.mensagem);
                }
            }
        }); //termina o jquery

    }

    function ADDServicoOS() {
        if ($("#servicosid").val() === '') {
            $("#servicosid").focus();
            return false;
        } else {
            var codigo = $("#servicosid").val();
            $("#servicosid").val('');
        }

        $.ajax({type: "GET",
            url: "_backend/_controller/_insert/servicosos_insert.php", data: {
                produto: codigo,
                documento: $("#documento").val(),
                quantidade: $("#servicosquantidade").val(),
                valor: $("#servicosvalor").val()

            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
                if (data.retorno == true) {
                    toastr.options = {
                        "closeButton": false,
                        "debug": false,
                        "newestOnTop": false,
                        "progressBar": true,
                        "positionClass": "toast-top-right",
                        "preventDuplicates": false,
                        "onclick": null,
                        "showDuration": "1000",
                        "hideDuration": "1000",
                        "timeOut": "1000",
                        "extendedTimeOut": "1000",
                        "showEasing": "swing",
                        "hideEasing": "linear",
                        "showMethod": "fadeIn",
                        "hideMethod": "fadeOut"
                    };
                    toastr.success(data.mensagem);
                    CarregaServicos();
                    $("#servicosid").val('');
                    $("#servicosquantidade").val('');
                    $("#servicosvalor").val('');
                    $("#servicosdescricao").val('');
                    $("#codiservicosidgo").focus();
                } else {
                    toastr.warning(data.mensagem);
                }
            }
        }); //termina o jquery

    }

    function CarregaProd() {
        var doc = $("#documento").val();
        //        alert(doc);
        $("#recebeitensprod").load('_backend/_controller/_select/_ajax/frentecaixa/iten_os_select_ajax.php?documento=' + doc + '', function () {
        });
        $(".modal-backdrop").hide();
    }

    function CarregaServicos() {
        var doc = $("#documento").val();
        //        alert(doc);
        $("#recebeitensservicos").load('_backend/_controller/_select/_ajax/frentecaixa/servicos_os_select_ajax.php?documento=' + doc + '', function () {
        });
        $(".modal-backdrop").hide();
    }

</script>

<ul class="nav nav-tabs " role="tablist">
    <li role="presentation" class="active"><a href="#geral" aria-controls="geral" role="tab" data-toggle="tab">O.S</a></li>
    <li role="presentation" id="navprod" style="display: none;"><a href="#produtos" aria-controls="produtos" role="tab" data-toggle="tab">Produtos</a></li>
    <li role="presentation" id="navservicos" style="display: none;"><a href="#servicos" aria-controls="servicos" role="tab" data-toggle="tab">Serviços</a></li>  
    <li role="presentation" id="navpagamento" style="display: none;"><a href="#pagamento" aria-controls="pagamento" role="tab" data-toggle="tab">Pagamento</a></li>  
</ul>
<form id="criaros" action="<?= BACKEND ?>/_controller/_insert/os_insert.php" method="post">

    <div class="tab-content">


        <!--Geral-->
        <div role="tabpanel" class="tab-pane active" id="geral">
            <div class="row">
                <div class="col-md-12">
                    <div class="portlet box blue-madison">

                        <!--            <div class="row">
                                        <div class="col-md-12">
                                            <span class="badge badge-info" style="cursor: pointer; padding: 5px; background-color: #4ea4e0;" onclick="AbreCadCliente()"><i class="fa fa-plus"></i> Novo Cliente</span>
                                            <span class="badge badge-info" style="cursor: pointer; padding: 5px; background-color: #4ea4e0;" onclick="AbreEditCliente()"><i class="fa fa-edit"></i> Editar Cliente</span>
                                        </div>
                                    </div>-->


                        <div class="row">
                            <div class="col-md-2">
                                <label> O.S</label> 
                                <input type="text" name="documento" readonly=""  class="form-control" id="documento">
                            </div>
                            <div class="col-md-2">
                                <label> Emissão</label> 
                                <input type="text" id="dataemissao" readonly="" name="dataemissao" onkeypress="mascara(this, mdata);" maxlength="10"  class="form-control" value="<?= date("d/m/Y") ?>">
                            </div>

                            <div class="col-md-2">
                                <label> Previsão</label> 
                                <input type="text" id="dataprevisao" name="dataprevisao" onkeypress="mascara(this, mdata);" maxlength="10"  class="form-control" value="<?= date("d/m/Y") ?>">
                            </div>

                            <div class="col-md-2">
                                <label> Hora Previsão</label> 
                                <input type="text" id="horaprevisao" name="horaprevisao" onkeypress="mascara(this, mtime);" maxlength="5" class="form-control" >
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-2">
                                <label> Cliente</label> 
                                <input id="cliente" name="cliente" autocomplete="off" onblur="Cliente(this.value)" type="text" required="" class="form-control" placeholder="Código"> 
                                <i onclick="BuscaOS('cliente_veic')"  style="position: absolute; right: 27px; top: 37px; z-index: 999" class="fa fa-search"> </i>
                            </div>

                            <div class="col-md-5">
                                <label>Nome Cliente</label> 
                                <input id="nomecliente" name="nomecliente" type="text" class="form-control" autocomplete="off" placeholder="Nome Cliente"> 
                            </div>

                            <div class="col-md-2">
                                <label> Telefone</label> 
                                <input id="clientewpp" name="clientewpp" type="text" onblur="ClienteWpp(this.value)" autocomplete="off" class="form-control phone" placeholder="(99)99999-9999"> 
                            </div>

                            <?php
                            if ($parametros->formatoos === 'P') :
                                ?>
                                <div class="col-md-1 text-right"><br/>
                                    <button class="btn btn-info" type="button" onclick="$('#abreveic').modal('show')"><i class="fa fa-plus"></i></button>
                                </div>

                                <div class="col-md-2">
                                    <label> Veículo</label> 
                                    <select id="veiculocliente" name="veiculo" class="form-control">

                                    </select>
                                </div>
                                <?php
                            endif;
                            ?>
                        </div>


                        <div class="row">
                            <div class="col-md-3">
                                <?php
                                $pdo = Conexao::getInstance();
                                $crud = Crud::getInstance($pdo, 'tabelapreco');
                                $sql = "SELECT * from funcionario order by xNome ASC";
                                $arrayParam = '';
                                $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
                                ?>
                                <label>Responsável</label>
                                <select id="responsavel" required="" name="responsavel" class="form-control">
                                    <?php
                                    foreach ($dados as $value):
                                        ?>
                                        <option value="<?= $value->funcionarioid ?>"> <?= $value->xNome ?></option>';
                                        <?php
                                    endforeach;
                                    ?>
                                </select>
                            </div>

                            <div class="col-md-3">
                                <?php
                                $pdo = Conexao::getInstance();
                                $crud = Crud::getInstance($pdo, 'tabelapreco');
                                $sql = "SELECT * from vendedor order by xNome ASC";
                                $arrayParam = '';
                                $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
                                ?>
                                <label>Vendedor(a)</label>
                                <select id="vendedor" required="" name="vendedor" class="form-control">
                                    <?php
                                    foreach ($dados as $value):
                                        ?>
                                        <option value="<?= $value->vendedorid ?>"> <?= $value->xNome ?></option>';
                                        <?php
                                    endforeach;
                                    ?>
                                </select>
                            </div>

                            <div class="col-md-2">
                                <label>Garantia</label> 
                                <input id="garantia" name="garantia" type="text" class="form-control" autocomplete="off" placeholder=""> 
                            </div>

                            <div class="col-md-2">
                                <label> Status</label> 
                                <select id="status" name="status" class="form-control">
                                    <option value="A">Aberto</option>
                                    <option value="EA">Em Andamento</option>
                                    <option value="F">Finalizado</option>
                                    <option value="AP">Aguardando Peça</option>
                                    <option value="AD">Aprovado</option>
                                    <option value="C">Cancelado</option>
                                </select>
                            </div>

                            <div class="col-md-2">
                                <?php
                                $pdo = Conexao::getInstance();
                                $crud = Crud::getInstance($pdo, 'tabelapreco');
                                $sql = "SELECT * from tabelapreco";
                                $arrayParam = '';
                                $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
                                ?>
                                <label>Tabela Preço</label>
                                <select id="tbpreco" required="" name="tbpreco" class="form-control">
                                    <?php
                                    foreach ($dados as $value):

                                        if ($parametros->tbpadrao == $value->tabelaprecoid) :
                                            echo '<option selected="" value="' . $value->tabelaprecoid . '"> ' . $value->descricao . ' </option>';
                                        else :
                                            echo '<option value="' . $value->tabelaprecoid . '"> ' . $value->descricao . ' </option>';

                                        endif;

                                    endforeach;
                                    ?>
                                </select>
                            </div>


                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <label> Obs</label> 
                                <textarea name="obs" id="obs" rows="5" class="form-control" ></textarea>
                            </div>
                            <div class="col-md-4">
                                <label> Defeito</label> 
                                <textarea name="defeito" id="defeito" rows="5" class="form-control" ></textarea>
                            </div>
                            <div class="col-md-4">
                                <label> Laudo</label> 
                                <textarea name="laudo" id="laudo" rows="5" class="form-control" ></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>

        <!--Produtos-->
        <div role="tabpanel" class="tab-pane" id="produtos">
            <div class="row">
                <div class="col-md-2">
                    <label> Produto</label> 
                    <input id="codigo" name="codigo" autocomplete="off" onblur="Produto(this.value)" type="text"  class="form-control" placeholder="Código"> 
                    <i onclick="BuscaOS('grade_produtos')"  style="position: absolute; right: 27px; top: 37px; z-index: 999" class="fa fa-search"> </i>
                </div>

                <div class="col-md-3">
                    <label>Descrição</label> 
                    <input id="descproduto" type="text" style="width: 280px" class="form-control" autocomplete="off" placeholder=""> 
                </div>

                <div class="col-md-2">
                    <label> Quantidade</label> 
                    <input id="quantidade" name="qtd" type="text" onkeypress="return onlynumber();" autocomplete="off" onkeyup="SomaProduto()"  class="form-control phone" placeholder=""> 
                </div>

                <div class="col-md-2">
                    <label>Valor </label>
                    <input name="valor" id="valor" onkeypress="mascara(this, mvalor);" onkeyup="SomaProduto()"  type="text" value="0.00" class="form-control" placeholder=""> 
                </div>
                <div class="col-md-2">
                    <label>Total </label>
                    <input name="total" id="total" readonly="" onkeypress="mascara(this, mvalor);" type="text" value="0.00" class="form-control" placeholder=""> 
                </div>
                <div class="col-md-1">
                    <label>Adicionar </label> <br/>
                    <button class="btn btn-success btn-sm" type="button" onclick="ADDitenOS()"><i class="fa fa-plus"></i> </button>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12" id="recebeitensprod">
                </div>
            </div>
        </div>

        <!--Serviços-->
        <div role="tabpanel" class="tab-pane" id="servicos">
            <div class="row">
                <div class="col-md-2">
                    <label> Serviço</label> 
                    <input id="servicosid" name="servicos" autocomplete="off" onblur="Servicos(this.value)" type="text"  class="form-control" placeholder="Código"> 
                    <i onclick="BuscaOS('servicos')"  style="position: absolute; right: 27px; top: 37px; z-index: 999" class="fa fa-search"> </i>
                </div>

                <div class="col-md-3">
                    <label>Descrição</label> 
                    <input id="servicosdescricao" type="text" style="width: 280px" class="form-control" autocomplete="off" placeholder=""> 
                </div>

                <div class="col-md-2">
                    <label> Quantidade</label> 
                    <input id="servicosquantidade" name="servicosqtd" type="text" onkeypress="return onlynumber();" autocomplete="off" onkeyup="SomaServico()"  class="form-control phone" placeholder=""> 
                </div>

                <div class="col-md-2">
                    <label>Valor </label>
                    <input name="servicosvalor" id="servicosvalor" onkeypress="mascara(this, mvalor);" onkeyup="SomaServico()"  type="text" value="0.00" class="form-control" placeholder=""> 
                </div>
                <div class="col-md-2">
                    <label>Total </label>
                    <input name="servicostotal" id="servicostotal" readonly="" onkeypress="mascara(this, mvalor);" type="text" value="0.00" class="form-control" placeholder=""> 
                </div>
                <div class="col-md-1">
                    <label>Adicionar </label> <br/>
                    <button class="btn btn-success btn-sm" onclick="ADDServicoOS()" type="button"><i class="fa fa-plus"></i> </button>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12" id="recebeitensservicos">
                </div>
            </div>
        </div>

        <!--Pagamentos-->
        <div role="tabpanel" class="tab-pane" id="pagamento">
            <div class="row">
                <div class="col-md-2">
                    <label>  </label> <br/>
                    <button class="btn btn-info" type="button" onclick="$('#descontoabre').modal('show')" style="margin-top: 18px;">Desconto</button>
                </div>
                <div class="col-md-4">
                    <?php
                    $pdo = Conexao::getInstance();
                    $crud = Crud::getInstance($pdo, 'tabelapreco');
                    $sql = "SELECT * from condpagamento";
                    $arrayParam = '';
                    $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
                    ?>
                    <label>Condição de Pagamento</label>
                    <select id="condicaopagamento" onchange="GeraCondPag(this.value)" name="condicaopagamento" class="form-control">
                        <option></option>
                        <?php
                        foreach ($dados as $value):
                            ?>
                            <option value="<?= $value->id ?>"> <?= $value->descricao ?></option>';
                            <?php
                        endforeach;
                        ?>
                    </select>
                    <br/>

                </div>
            </div>

            <div class="row">
                <div class="col-md-12" id="recebepag">
                    <?php
                    if (isset($_GET['editar'])) :
                        $pdo = Conexao::getInstance();
                        $crud = Crud::getInstance($pdo, 'tabelapreco');
                        $sql = "SELECT * from recebimentoos where documento = '" . $_GET['editar'] . "'";
                        $arrayParam = '';
                        $dadospag = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
                        foreach ($dadospag as $dadospag) :
                            ?>
                            <div class="row"> 
                                <div class="col-md-3"> 
                                    <input type="text" name="datap[]" id="dfoco<?= $dadospag->id ?>" onkeypress="mascaraData(this)" maxlength="10" class="form-control" value="<?= $dadospag->dataven ?>"> 
                                </div> 
                                <div class="col-md-4"> 
                                    <select name="tipop[]" id="tipop<?= $dadospag->id ?>" onchange="MudaFormaPag('<?= $dadospag->id ?>', this.value)" class="form-control"> 
                                        <?php
                                        foreach ($cobrancas as $tcobrancas) :
                                            ?>
                                            <option 
                                            <?php
                                            if ($dadospag->tiporeceb == $tcobrancas->sigla) :
                                                echo 'selected=""';
                                            endif;
                                            ?>  
                                                value="<?= $tcobrancas->sigla ?>"> <?= $tcobrancas->descricao ?> </option> 
                                                <?php
                                            endforeach;
                                            ?>
                                    </select> 
                                </div> 
                                <div class="col-md-3"> 
                                    <input type="text" name="valorp[]" id="pvalor<?= $dadospag->id ?>" onblur="CalculaDiferenca('<?= $dadospag->id ?>', this.value)" class="form-control vtotalpagamentodt" value="<?= $dadospag->valor ?>"> 
                                </div> 
                            </div>
                            <?php
                        endforeach;
                    endif;
                    ?>
                </div>
            </div>
        </div>
    </div>

    <hr/>

    <div class="row">
        <div class="col-md-6">
            <h5> NÚMERO DA O.S  <b id="numeroos"></b> </h5>
        </div>
        <div class="col-md-2 text-right">
            <input type="hidden" id="parceladif">
            <input type="hidden" name="ivalorprod" id="ivalorprod" value="0">
            <input type="hidden" name="ivalorserv" id="ivalorserv" value="0">
            <input type="hidden" name="isubtotalos" id="isubtotalos" value="0">
            <input type="hidden" name="ivaloros" id="ivaloros" value="0">
            <input type="hidden" name="ivalordesc" id="ivalordesc" value="0">
            <h5> SUBTOTAL  R$ <b id="subtotalos">0,00</b></h5>
        </div>
        <div class="col-md-2 text-right">
            <h5> DESCONTO <b id="valordesconto">0,00</b></h5>
        </div>
        <div class="col-md-2 text-right">
            <h5> TOTAL DA O.S  R$ <b id="valoros">0,00</b></h5>
        </div>
    </div>

    <div class="row" id="osbutton">
        <div class="col-md-12 text-right"><br/>
            <button type="submit" id="loading" class="btn btn-success">Criar O.S</button>
        </div>
    </div>
</form>


<script>
    $('#criaros').submit(function () {
        var doc = $("#documento").val();
        if (doc !== '') {
            var url = "_backend/_controller/_update/os_update.php";
        } else {
            var url = "_backend/_controller/_insert/os_insert.php";
        }
        var form = jQuery(this);
        var dados = $(this).serialize();
        var btnsubmit = form.find('button[type=submit]');
        var loader = jQuery('#loading');
        $.ajax({
            type: "POST",
            url: url,
            data: dados,
            cache: false,
            beforeSend: function () {
                //Aqui está o que você quer
                // bloqueia o botão submit
                //                btnsubmit.prop('disabled', true);
                //btnsubmit.css({backgroundColor: '#e2e2e2'});
                loader.html("<i class='fa fa-spinner fa-spin fa-1x fa-fw'></i> Processando...");
                btnsubmit.addClass("loading");
            },
            dataType: "json",
            success: function (data)
            {
                //                    alert(data[0].situacao)
                if (data.retorno == true) {
                    if (data.tipo === 'AT') {
                        Carrega('_grid', 'os_grid.php', 'Ordem de Serviço');
                        window.open('<?= BACKEND ?>/_view/_view/os.php?documento=' + doc, '',
                                'height=800,width=700,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
                    }
                    $("#loading").css("display", 'block');
                    $("#navprod").css("display", 'inline-block');
                    $("#navservicos").css("display", 'inline-block');
                    $("#navpagamento").css("display", 'inline-block');
                    loader.html("Salvar O.S");
                    btnsubmit.addClass("text-right");
                    toastr.success(data.mensagem);
                    $("#documento").val(data.id);
                    $("#numeroos").html(data.doc);
                } else {
                    bootbox.alert(data.mensagem);
                    $("#loading").prop('disabled', false);
                }
            }
        });
        return false;
    });
</script>

<div class="modal fade bs-modal-lg bd-example-modal-xl" id="buscaostabs" style="z-index: 99999" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-lg modal-xl" style="width: 95%;">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="buscatitle"></h4>
            </div>
            <div id="carregandobusca" style="z-index: 9999999; position: absolute; left: 50%; top: 50%; margin-left: -50px; margin-top: -50px;">
                <img src="<?= LINK ?>/_frontend/img/loading.gif" style="max-height: 40px" alt=""/>
            </div>
            <div class="modal-body" id="recebegrid"> 

            </div>

        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<div class="modal fade bs-modal-lg bd-example-modal-xl" id="descontoabre" style="z-index: 99999" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-lg modal-xl" style="width: 50%;">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"> Desconto</h4>
            </div>

            <div class="modal-body"> 


                <div class="row">
                    <div class="col-md-6">
                        <label>Desc. (R$)</label>
                        <input type="text" id="descrs" onkeyup="PorcentagemVlr()"  class="form-control" name="desconto">
                    </div>

                    <div class="col-md-6">
                        <label>Desc. (%)</label>
                        <input type="text" id="descpt" onkeyup="Porcentagem()"  class="form-control">
                    </div>
                </div>
            </div>

            <div class="modal-footer"> 
                <a href="javascript::" onclick="AplicaDesc()"  class="btn btn-success"> <i class="fa fa-check"></i> Aplicar Desconto </a>
            </div>
        </div>
    </div>
</div>

<div class="modal fade bs-modal-lg bd-example-modal-xl" id="abreveic" style="z-index: 99999" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-lg modal-xl" style="width: 90%;">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"> Cadastrar Veículo</h4>
            </div>

            <div class="modal-body"> 


                <div class="row" id="veic1">
                    <div class="col-md-2">
                        <label class="control-label">Placa </label>
                        <input type="text" class="form-control" id="placaveic" placeholder="">
                    </div>
                    <div class="col-md-2">
                        <label class="control-label">Marca </label>
                        <input type="text" class="form-control" id="marcaveic" placeholder="">
                    </div>
                    <div class="col-md-2">
                        <label class="control-label">Modelo </label>
                        <input type="text" class="form-control" id="modeloveic" placeholder="">
                    </div>
                    <div class="col-md-2">
                        <label class="control-label">Ano</label>
                        <input type="text" class="form-control" id="anoveic" placeholder="">
                    </div>
                    <div class="col-md-2">
                        <label class="control-label">Km Atual</label>
                        <input type="text" class="form-control" id="kmatualveic" placeholder="">
                    </div>
                </div>
            </div>
            <div class="modal-footer"> 
                <a href="javascript::" onclick="CriarVeiculo()"  class="btn btn-success"> <i class="fa fa-check"></i> Cadastrar Veiculo </a>
            </div>
        </div>
    </div>
</div>

<script>


    function CriarVeiculo() {
        $("#submitButton").prop('disabled', true);
        $.ajax({
            type: "POST",
            url: "<?= BACKEND ?>/_controller/_insert/cliente_veic_insert.php",
            data: {
                cliente: $("#cliente").val(),
                placa: $("#placaveic").val(),
                marca: $("#marcaveic").val(),
                modelo: $("#modeloveic").val(),
                ano: $("#anoveic").val(),
                kmatual: $("#kmatualveic").val()
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//                alert(data);
                if (data.retorno === true) {
                    Cliente($("#placaveic").val());
                    $("#abreveic").modal("hide");
                }

                $("#submitButton").prop('disabled', false);

            }
        }); //termina o jquery
    }

    function DeletaItemOS(item) {

        bootbox.confirm({
            message: "Deseja realmente excluir o item selecionado?",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    $.ajax({
                        type: "POST",
                        url: "<?= BACKEND ?>/_controller/_delete/itos_delete.php",
                        data: {
                            documento: $("#documento").val(),
                            itmovimentacao: item
                        },
                        dataType: "json",
// função para de sucesso
                        success: function (data) {
//                alert(data);
                            if (data.retorno === true) {
                                CarregaProd();
                            }
                        }
                    }); //termina o jquery
                }
            }
        });


    }

    function DeletaServicoOS(item) {

        bootbox.confirm({
            message: "Deseja realmente excluir o serviço selecionado?",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    $.ajax({
                        type: "POST",
                        url: "<?= BACKEND ?>/_controller/_delete/servicoos_delete.php",
                        data: {
                            documento: $("#documento").val(),
                            itmovimentacao: item
                        },
                        dataType: "json",
// função para de sucesso
                        success: function (data) {
//                alert(data);
                            if (data.retorno === true) {
                                CarregaServicos();
                            }
                        }
                    }); //termina o jquery
                }
            }
        });


    }

    function numeroParaMoeda(valor)
    {
        return isNaN(valor) == false ? parseFloat(valor) : parseFloat(valor.replace(".", ",").toFixed(2));
    }

    function moedaParaNumero(valor)
    {
        return isNaN(valor) == false ? parseFloat(valor) : parseFloat(valor.replace(".", "").replace(",", "."));
    }

    function PorcentagemVlr() {
        var subtotal = $("#isubtotalos").val();
        var valortotal = moedaParaNumero(subtotal);
        var valor = moedaParaNumero($("#descrs").val());
        var calc = (Number(valor * 100)) / Number(valortotal);
        if (calc > 0) {
            $("#descpt").val(calc.toFixed(2));
            var total = Number(valortotal) - valor.toFixed(2);
            $("#valordesconto").html(valor.toFixed(2));
            $("#ivalordesc").val(valor.toFixed(2));
        } else {
            $("#descpt").val('0,00');
            $("#valordesconto").html('0,00');
            $("#ivalordesc").val('0,00');
        }
//    $("#descpt").val(calc.toFixed(2));
    }

    function Porcentagem() {
        var subtotal = $("#isubtotalos").val();
        var valor = moedaParaNumero(subtotal);
        var porc = moedaParaNumero($("#descpt").val());
        var calc = (Number(porc) / 100) * Number(valor);
        if (calc > 0) {
            $("#descrs").val(calc.toFixed(2));
            var total = Number(valor) - calc.toFixed(2);
            $("#valordesconto").html(calc.toFixed(2));
            $("#ivalordesc").val(calc.toFixed(2));
        } else {
            $("#descrs").val('0,00');
            $("#valordesconto").html('0,00');
            $("#ivalordesc").val('0,00');
        }
    }


    function AplicaDesc() {
        var descontors = $("#ivalordesc").val();
        var subtotal = $("#isubtotalos").val();

        var total = parseFloat(subtotal) - parseFloat(descontors);

        $("#ivaloros").val(total.toFixed(2));
        $("#valoros").html(total.toFixed(2));

        $("#descontoabre").modal('hide');
        $("#recebepag").html('');
    }


    function SomaTotalOS() {
        var totalprod = 0;
        var totalos = 0;
        $('.valorprodtotal').each(function () {
            var valor = Number($(this).val());
            if (!isNaN(valor))
                totalprod += valor;
        });

        $('.valorservicototal').each(function () {
            var valor = Number($(this).val());
            if (!isNaN(valor))
                totalos += valor;
        });

        var totalgeral = totalprod + totalos;
        var totaldesc = $("#ivalordesc").val();
        var totalcomdesc = totalgeral - Number(totaldesc);

        $("#valoros").html(totalcomdesc.toFixed(2));
        $("#subtotalos").html(totalgeral.toFixed(2));

        $("#ivaloros").val(totalcomdesc.toFixed(2));
        $("#isubtotalos").val(totalgeral.toFixed(2));

        $("#ivalorprod").val(totalprod.toFixed(2));
        $("#ivalorserv").val(totalos.toFixed(2));


    }


</script>