<?php
require_once("../../../functions.php");
require_once("../../_class/cobranca_class.php");
?>
<script>
    $("#dias").click(function() {
        var dias = $("#intervalo").val();
        var parcela = $("#parcela").val();
        var qtddias = 0;
        var total = dias;
        var opcoes = '<table class="table table-striped table-bordered">' +
            '<thead>' +
            '<th>Parcela</th>' +
            '<th>Vencimento</th>' +
            '<th>Valor (R$)</th>' +
            '<th>Forma (R$)</th>' +
            '</thead><tbody>';

        var vlrtotal = parseFloat(moedaParaNumero($("#valortotalnf").val()));
        var duplicata = $("#duplicata").val();
        var vlrparcelaBase = Math.floor((vlrtotal / parcela) * 100) / 100; // Valor base de cada parcela arredondado para 2 casas decimais.
        var somaParcelas = vlrparcelaBase * parcela;
        var diferenca = vlrtotal - somaParcelas; // Diferença para ajustar na última parcela.

        for (var i = 0; i < parcela; i++) {
            qtddias = parseInt(total) + parseInt(qtddias);
            var novaData = adicionarDiasData(qtddias);
            var valorParcela = vlrparcelaBase;

            // Ajusta a última parcela com a diferença calculada.
            if (i === parcela - 1) {
                valorParcela += diferenca;
            }

            opcoes += '<tr>' +
                '<td>' + (i + 1) + '<input type="hidden" name="parcela[]" value="' + (i + 1) + '"></td>' +
                '<td><input type="text" id="data" name="vencimento[]" class="form-control" onkeypress="mascara(this, mdata);" value="' + novaData + '"></td>' +
                '<td><input type="text" name="valor[]" onkeypress="mascara(this, mvalor);" class="form-control vlrtotalparcela" value="' + numeroParaMoeda(valorParcela) + '"></td>' +
                '<td><select name="forma[]" required="" class="form-control">' +
                '<option></option>' +
                <?php foreach ($cobrancas as $tcobrancas) : ?> '<option value="<?= $tcobrancas->sigla ?>"><?= $tcobrancas->descricao ?></option>' +
                <?php endforeach; ?> '</select></td>' +
                '</tr>';
        }

        opcoes += '</tbody></table>';
        $("#fordata").html(opcoes);
    });

    function adicionarDiasData(dias) {
        var hoje = new Date();
        var dataVenc = new Date(hoje.getTime() + (dias * 24 * 60 * 60 * 1000));

        var tempoMonth = (dataVenc.getMonth() + 1);
        if (tempoMonth < 10)
            tempoMonth = '0' + tempoMonth;

        var tempoDay = dataVenc.getDate();
        if (tempoDay < 10)
            tempoDay = '0' + tempoDay;

        return tempoDay + '/' + tempoMonth + '/' + dataVenc.getFullYear();
    }

    function numeroParaMoeda(n, c, d, t) {
        c = isNaN(c = Math.abs(c)) ? 2 : c, d = d == undefined ? "." : d, t = t == undefined ? "" : t, s = n < 0 ? "-" : "", i = parseInt(n = Math.abs(+n || 0).toFixed(c)) + "", j = (j = i.length) > 3 ? j % 3 : 0;
        return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
    }

    function moedaParaNumero(valor) {
        return isNaN(valor) == false ? parseFloat(valor) : parseFloat(valor.replace(".", "").replace(",", "."));
    }
</script>

<form id="duplicataform" action="<?= BACKEND ?>/_controller/_insert/duplicata_insert.php" method="POST">

    <div class="row">
        <input type="hidden" name="destCNPJ" value="<?= $_GET['destCNPJ'] ?>">

        <input type="hidden" name="nNF" value="<?= $_GET['nNF'] ?>">
        <div class="col-md-2">
            <label>Qtd. Parcelas</label>
            <input type="number" id="parcela" value="1" class="form-control" name="pgtoparcelas">
        </div>

        <div class="col-md-3">
            <label>Intervalo de Dias</label>
            <input type="number" id="intervalo" value="0" class="form-control" name="pgtodias">
        </div>

        <div class="col-md-3" style="display: none;">
            <label>Nº Duplicata</label>
            <input type="text" id="duplicata" class="form-control" name="pgtodias">
        </div>


        <div class="col-md-3">
            <br />
            <a href="javascript::" class="btn btn-info" id="dias"> Gerar Pagamentos </a>
        </div>
    </div>

    <br />

    <div class="row" style="max-height: 250px; overflow-y: scroll;">

        <div class="col-md-12" id="fordata">

        </div>

    </div>

    <div class="row">
        <div class="col-md-12 text-right">
            <button type="submit" id="submitButtonDP" class="btn btn-success"> <i class="fa fa-save"></i> Salvar </button>
        </div>
    </div>

</form>
<script>
    $(document).ready(function() {
        // bind form using ajaxForm 
        $('#duplicataform').ajaxForm({
            // dataType identifies the expected content type of the server response 
            dataType: 'json',

            beforeSubmit: function() {
                //Aqui está o que você quer
                // bloqueia o botão submit
                $("#submitButtonDP").prop('disabled', true);
                //btnsubmit.css({backgroundColor: '#e2e2e2'});
                $("#submitButtonDP").html("<i class='fa fa-spinner fa-spin fa-1x fa-fw'></i> Processando...");
                $("#submitButtonDP").addClass("loading");
            },

            // success identifies the function to invoke when the server response 
            // has been received 
            success: processJson
        });

    });

    function processJson(data) {
        if (data.retorno == true) {
            //            Carrega('_grid', 'nfe_grid.php', 'NF-e');
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html(data.mensagem);
            setTimeout(function() {
                $("#alertsucesso").css("display", "none");
            }, 2000);
            CarregaDuplicata();
            $("#produto").modal('hide');

        } else {
            document.getElementById("alertsucesso").style.display = "none";
            document.getElementById("alerterro").style.display = "block";
            $("#erro").html(data.mensagem);
            $("#submitButtonDP").prop('disabled', false);
            $("#submitButtonDP").html("<i class='fa fa-save'></i> Salvar");
            setTimeout(function() {
                $("#alerterro").css("display", "none");
            }, 2000);
            $("#produto").modal('hide');

        }
    }
</script>