<?php
require_once("../../../functions.php");
require_once("../_modal/_modal.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";
?>
<script>

    $("#codigoproduto").keydown(function (e) {
        if (e.which === 13) {
            BuscaProdEtq();
        }
    });
    $("#qtd").keydown(function (e) {
        if (e.which === 13) {
            if ($("#qtd").val() !== '') {
                if ($("#codigoproduto").val() !== '') {
                    AddProduto();
                }
            }
        }
    });

    function Busca(valor) {
//        alert(valor);
        $("#busca").modal('show');
        $("#buscatitle").html('BUSCA ' + valor.toUpperCase());
        $("#carregandobusca").css("display", "block");
        $("#recebegrid").load('_backend/_view/_grid/' + valor + '_grid.php?busca=S', function () {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }

    function CarregaEtq() {
        $("#carregando").css("display", "block");
//        $("#title").html(titulo);
//        $("#pagina").html(titulo);
        $("#etiq").load('_backend/_view/_grid/gera_etiqueta_grid.php', function () {
            $("#carregando").css("display", "none");
        });
    }

    CarregaEtq();

    function Produto(valor) {
        $("#codigoproduto").val(valor);
        $("#busca").modal('hide');
    }

    function BuscaProdEtq() {
        if ($("#codigoproduto").val() == '') {
            Busca('grade_produtos');
            return false;
        }

        //                        alert("buscaproduto");
        $.ajax({
            type: "GET",
            url: "_backend/_controller/_select/_ajax/produtos_busca_etiquetas.php",
            data: {
                produto: $("#codigoproduto").val(),
            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                if (data.retorno == true) {

                    if (data.totalprod > 1) {
                        $("#busca").modal('show');
                        $("#buscatitle").html('BUSCA ' + data.codigoprod, +'');
                        $("#carregandobusca").css("display", "block");
                        $("#recebegrid").load('_backend/_view/_form/produtos_grades_form.php?produto=' + data.codigoprod, function () {
                            $("#carregandobusca").css("display", "none");
                        });
                        $("#carregandobusca").css("display", "none");
                    } else {
                        //                    alert(data[0].xNome);
                        $("#codigoproduto").val(data.produto);
                        $("#descproduto").html(data.descricao);
                        $("#qtd").select();
                    }
                } else {
                    toastr.warning(data.mensagem);
                    $("#codigoproduto").focus();
                    //                $("#descricao").html('');
                }
            }
        }); //termina o jquery
    }


    function AddProduto() {
//        alert(valor);
//        $("#codigo").val();
//        $("#qtd").val();
        if ($("#codigoproduto").val() == '') {
            return false;
        }
        if ($("#qtd").val() == '') {
            return false;
        }

        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_insert/gera_etiqueta_insert.php",
            data: {
                produto: $("#codigoproduto").val(),
                qtd: $("#qtd").val()
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data.retorno == true) {
                    toastr.success(data.mensagem);
                    CarregaEtq();
                    $("#codigoproduto").val('');
                    $("#descproduto").val('');
                    $("#qtd").val('');
                } else {
                    toastr.warning(data.mensagem);
                }
            }
        }); //termina o jquery

    }


    function CoverteDoc() {
        if ($("#documento").val() == '') {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_update/convert_doc_etiqueta.php",
            data: {
                documento: $("#documento").val()
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data.retorno == true) {
                    toastr.success('Documento Gerado');
                    CarregaEtq();
                } else {
                    toastr.warning('Tente novamente!');
                }
            }
        }); //termina o jquery
    }


    function CoverteDocTrans() {
        if ($("#documentotransf").val() == '') {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_update/convert_transf_etiqueta.php",
            data: {
                documento: $("#documentotransf").val()
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data.retorno == true) {
                    toastr.success('Documento Gerado');
                    CarregaEtq();
                } else {
                    toastr.warning('Tente novamente!');
                }
            }
        }); //termina o jquery
    }

    function CoverteDocOP() {
        if ($("#op").val() == '') {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_update/convert_op_etiqueta.php",
            data: {
                documento: $("#op").val()
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data.retorno == true) {
                    toastr.success('Documento Gerado');
                    CarregaEtq();
                } else {
                    toastr.warning('Tente novamente!');
                }
            }
        }); //termina o jquery
    }


    function AbreEtie() {
        $("#abreetiq").modal('show');
    }

    function SelecionaEtiq() {
        var mod = $("#modetiquetas").val();
        var lote = $("#lote").val();
        var res = mod.split("|");

        if (res[1] === 'S') {
            GeraEtiqueta(res[0]);
        } else {
            var param = '&1=1';
            var bateria = $("#bateria").val();
            var imei = $("#imei").val();
            var imei2 = $("#imei2").val();
            var serie = $("#serie").val();
            
            if(bateria !== '') {
                param += '&bateria='+bateria+'';
            }
            
            if(imei !== '') {
                param += '&imei='+imei+'';
            }
            
            if(imei2 !== '') {
                param += '&imei2='+imei2+'';
            }
            
            if(serie !== '') {
                param += '&serie='+serie+'';
            }
            
            
            
            window.open('<?= BACKEND ?>/etiquetas/' + res[0] + '.php?lote=' + lote +' '+ param +'');
            $("#abreetiq").modal('hide');

        }
    }

    function GeraEtiqueta(arquivo) {

        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_gera/" + arquivo + ".php",
            data: {
                produto: $("#codigoproduto").val(),
                qtd: $("#qtd").val(),
                lote: $("#lote").val()

            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data.retorno == true) {
                    toastr.success(data.mensagem);
                    $("#abreetiq").modal('hide');
                } else {
                    toastr.warning(data.mensagem);
                }
            }
        }); //termina o jquery

    }


    function Limpa() {
        var decisao = confirm("Deseja Realmente Limpar Etiquetas?");
        if (!decisao) {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_delete/limpa_etiqueta_delete.php",
            data: {
                produto: $("#codigoproduto").val(),
                qtd: $("#qtd").val()
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data.retorno == true) {
                    toastr.success(data.mensagem);
                    CarregaEtq();

                } else {
                    toastr.warning(data.mensagem);
                }
            }
        }); //termina o jquery

    }

    var options = {

        url: function (phrase) {
            return "_backend/_controller/_select/_ajax/produtos_select_ajax_autocomplete.php";
        },
        getValue: function (element) {
            return element.codigo + ' | ' + element.descricao + ' | ' + element.estoque + ' ' + element.unidade;
        },
        ajaxSettings: {
            dataType: "json",
            method: "POST",
            data: {
                dataType: "json"
            }
        },
        list: {
            onClickEvent: function () {
                $("#codigoproduto").val($("#codigoproduto").getSelectedItemData().codigo);
                BuscaProdEtq();
            },
            onSelectItemEvent: function () {
                $("#codigoproduto").val($("#codigoproduto").getSelectedItemData().codigo);
            },
            onKeyEnterEvent: function () {
                $("#codigoproduto").val($("#codigoproduto").getSelectedItemData().codigo);
//                BuscaProdEtq();
            },

            maxNumberOfElements: 20

        },

        preparePostData: function (data) {
            data.term = $("#codigoproduto").val();
            return data;
        },
        requestDelay: 400
    };
    $("#codigoproduto").easyAutocomplete(options);

</script>
<style>
    .tab-content {
        border-radius: 0 0 0px 0px;
        box-shadow: 0 0px 0px 0 rgba(0, 0, 0, 0.04);
        background-color: white;
        border: 0px solid #eeeeee;
        border-top: 0;
        padding: 15px;
    }
    .input-group-addon {
        padding: 6px 12px;
        font-size: 14px;
        font-weight: normal;
        line-height: 1;
        color: #555555;
        text-align: center;
        background-color: #fff;
        border: 0px solid #cccccc;
        border-radius: 0px;
    }
</style>

<style>
    label {
        font-size: 12px;
    }
</style>



<div class="row">
    <div class="col-md-12">
        <ul class="nav nav-tabs " role="tablist">
            <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab" data-toggle="tab">Geração  Etiquetas</a></li>
        </ul>
       <!--<section class="panel">-->
        <div class="tab-content">
            <div role="tabpanel" class="tab-pane active" id="home">


                <ul class="nav nav-tabs " role="tablist">
                    <li role="presentation" class="active"><a href="#prod" aria-controls="prod" role="tab" data-toggle="tab">Produto</a></li>
                    <li role="presentation"><a href="#doc" aria-controls="doc" role="tab" data-toggle="tab">Documento de entrada</a></li>
                    <li role="presentation"><a href="#doctransferencia" aria-controls="doctransferencia" role="tab" data-toggle="tab">Documento de transferência</a></li>
                    <li role="presentation"><a href="#docop" aria-controls="docop" role="tab" data-toggle="tab">Ordem de Produção</a></li>
                </ul>


                <div class="tab-content">
                    <div role="tabpanel" class="tab-pane active" id="prod">
                        <div class="row">

                            <div class="col-md-8">
                                <label>Código </label>
                                <input id="codigoproduto" required="" type="text"  class="form-control" placeholder=""> 
                                <i onclick="Busca('grade_produtos')"  style="position: absolute; right: 22px; top: 37px; z-index: 9999" class="fa fa-search"> </i>

                            </div>
                            <div class="col-md-2">
                                <label>QTD </label>
                                <input id="qtd" required="" type="text"  class="form-control" placeholder=""> 
                            </div>
                            <div class="col-md-2">
                                <a href="javascript::" onclick="AddProduto()" class="btn btn-info" style="margin-top: 27px"> <i class="fa fa-check"></i> OK </a> 
                            </div>

                        </div>

                        <div class="row">

                            <div class="col-md-12">
                                <h4 id="descproduto"></h4>
                            </div>
                        </div>
                    </div>

                    <div role="tabpanel" class="tab-pane" id="doc">
                        <div class="row">
                            <div class="col-md-4">
                                <label>Documento </label>
                                <input id="documento" required="" type="text"  class="form-control" placeholder="">                          
                            </div>
                            <div class="col-md-2">
                                <a href="javascript::" onclick="CoverteDoc()" class="btn btn-info" style="margin-top: 27px"> <i class="fa fa-check"></i> OK </a> 
                            </div>
                        </div>
                    </div>

                    <div role="tabpanel" class="tab-pane" id="doctransferencia">
                        <div class="row">
                            <div class="col-md-4">
                                <label>Documento </label>
                                <input id="documentotransf" required="" type="text"  class="form-control" placeholder="">                          
                            </div>
                            <div class="col-md-2">
                                <a href="javascript::" onclick="CoverteDocTrans()" class="btn btn-info" style="margin-top: 27px"> <i class="fa fa-check"></i> OK </a> 
                            </div>
                        </div>
                    </div>

                    <div role="tabpanel" class="tab-pane" id="docop">
                        <div class="row">
                            <div class="col-md-4">
                                <label>O.P </label>
                                <input id="op" required="" type="text"  class="form-control" placeholder="">                          
                            </div>
                            <div class="col-md-2">
                                <a href="javascript::" onclick="CoverteDocOP()" class="btn btn-info" style="margin-top: 27px"> <i class="fa fa-check"></i> OK </a> 
                            </div>
                        </div>
                    </div>
                </div>





                <hr/>

                <div id="etiq">

                </div>

            </div>

            <div class="panel-footer">
                <div class="row">
                    <div class="col-md-6 text-left">
                        <!--TOTAL ETIQUETAS:--> 
                        <?php
                        $pdo = Conexao::getInstance();
                        $crud = Crud::getInstance($pdo, 'geraetiq');
                        $sql = "select sum(qtd) as valor from geraetiq";
                        $arrayParam = '';
                        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
                        ?>
                        <!--<b> <?= $dados->valor ?> </b>-->
                    </div>
                    <div class="col-md-6 text-right">
                        <button type="submit" class="btn btn-success" onclick="AbreEtie()"> <i class="fa fa-print"></i> Gerar Etiquetas </button>
<!--<a href="<?= LINK ?>/_backend/etiquetas/etiquetas.php" target="_blank" class="btn btn-success"> <i class="fa fa-print"></i> Gerar  Etiquetas</a>-->
                        <!--<a href="<?= LINK ?>/_backend/etiquetas/etiquetas_2.php" target="_blank" class="btn btn-success"> <i class="fa fa-print"></i> Gerar Etiquetas ( 2 Colunas ) </a>-->
                        <!--<button type="submit" class="btn btn-success" onclick="GeraEtiqueta()"> <i class="fa fa-print"></i> Gerar Etiquetas </button>-->
                        <a href="javascript::" class="btn btn-warning" onclick="Limpa()"> <i class="fa fa-close"></i> Limpar </a>
                    </div>
                </div>

            </div>

        </div>
    </div>

</div>



<div class="modal fade bd-example-modal-lg" id="abreetiq" tabindex="-1" role="dialog" aria-labelledby="addprecos" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Selecionar modelo</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                <div class="row">
                    <div class="col-md-6">
                        <select name="etiquetas" id="modetiquetas" class="form-control">
                            <option></option>
                            <?php
                            $pdo = Conexao::getInstance();

                            $crud = Crud::getInstance($pdo, 'caixa');

                            $sql = "SELECT * from etiquetas";
                            $arrayParam = '';
                            $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

                            foreach ($dados as $dados) :
                                ?>
                                <option value="<?= $dados->arquivo ?>|<?= $dados->termica ?>"><?= $dados->descricao ?></option>
                                <?php
                            endforeach;
                            ?>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <input type="text" class="form-control" id="lote" placeholder="Lote" name="lote">
                    </div>
                </div>

                <?php
                if ($parametros->dados_cel == 'S') :
                    ?>
                    <div class="row">
                        <div class="col-md-2">
                            <label>Saúde Bateria</label>
                            <input type="text" class="form-control" id="bateria">
                        </div>
                        <div class="col-md-4">
                            <label>Nº Série</label>
                            <input type="text" class="form-control" id="serie">
                        </div>
                        <div class="col-md-3">
                            <label>Imei 1</label>
                            <input type="text" class="form-control" id="imei">
                        </div>
                        <div class="col-md-3">
                            <label>Imei 2</label>
                            <input type="text" class="form-control" id="imei2">
                        </div>
                    </div>
                    <?php
                endif;
                ?>

            </div>


            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-primary" onclick="SelecionaEtiq()">Gerar</button>
            </div>
        </div>
    </div>
</div>

