<?php
session_start();
date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
require_once("../_modal/_modal.php");

require_once("../../_class/Conexao_class.php");
require_once("../../_class/Crud_class.php");
require_once("../../_class/cobranca_class.php");
require_once("../../_class/parametros.php");

//print_r($parametros);
if (isset($_GET['editar'])) :
?>
    <script>
        $(document).ready(function() {

            //        alert(valor);
            $.ajax({
                type: "GET",
                url: "<?= BACKEND ?>/_controller/_select/_ajax/entnfe_select_ajax.php",
                data: {
                    nNF: <?= $_GET['editar'] ?>
                },
                dataType: "json",
                // função para de sucesso
                success: function(data) {
                    //  alert();
                    if (data != null) {

                        $.each(data, function() {
                            $.each(this, function(k, v) {
                                $("input[name='" + k + "']").val(v);
                                $("select[name='" + k + "']").val(v);
                                // console.log(k + "=>" + v);
                            });
                        });
                        if (data[0].CFOP > 0) {
                            CFOP(data[0].CFOP);
                        }
                        $("input[name='entnfeid']").val(data[0].id);
                        $("select[name='indPag']").val(data[0].indPag);
                        $("select[name='tpEmis']").val(data[0].tpEmis);
                        $("select[name='finNFe']").val(data[0].finNFe);
                        $("select[name='indPres']").val(data[0].indPres);
                        $("select[name='modFrete']").val(data[0].modFrete);
                        $("input[name='modelo']").val(data[0].modelo);
                        $("input[name='serie']").val(data[0].serie);
                        $("textarea[name='infCpl']").val(data[0].infCpl);
                        $('#cadnf').val('S');
       
                        if (data[0].modelo !== '55') {
                            $("#navprodutos").css("display", "none");
                            $("#exibecst").css("display", "block");

                            // $("#navfatura").css("display", "none");
                        } else {
                            $("#navprodutos").css("display", "inline-block");
                            $("#navfatura").css("display", "inline-block");
                            $("#exibecst").css("display", "none");

                            CarregaProdNFe();
                            CarregaDuplicata();
                            SomaAliqNF($('#entnfeid').val());
                        }
                    }
                }
            }); //termina o jquery
        });
    </script>
<?php
endif;
?>

<style>
    label {
        font-size: 11px;
    }

    .accordion .panel .panel-title .accordion-toggle {
        display: block;
        padding: 20px 15px;
    }

    .table {
        font-size: 11px;
    }

    .table td,
    .table th {
        font-size: 12px;
    }

    .table thead tr th {
        font-size: 12px;
        font-weight: 600;
    }
</style>

<script>
    $('#submitButtonEntrada').click(function() {
        //        $("#carregando").css("display", "block");
        //        $("#cgrid").val('sair');
        $(':required:invalid', '#nfeform').each(function() {
            var id = $('.tab-pane').find(':required:invalid').closest('.tab-pane').attr('id');

            $('.nav a[href="#' + id + '"]').tab('show');
        });
    });

    function DelProd(valor) {
        var decisao = confirm("Deseja Realmente Excluir?");
        if (decisao) {
            $.ajax({
                type: "GET",
                url: "<?= BACKEND ?>/_controller/_delete/produtoentnfe_delete.php",
                data: {
                    idProd: valor
                },
                dataType: "json",
                // função para de sucesso
                success: function(data) {
                    //  alert();
                    if (data.retorno == true) {
                        SomaAliqNF($('#entnfeid').val());
                        CarregaProdNFe()
                    }
                }
            }); //termina o jquery
        }
    }

    function ValidaDoc() {
        var tipo = $("#cnpj").val();
        //        alert(tipo);
        if (tipo.length < '12') {
            if ($("#cnpj").val() !== '') {
                if (!validarCPF($("#cnpj").val())) {
                    bootbox.alert("CPF Inválido!");
                    $("#cnpj").val('');
                    //                    $("#CNPJ").select();
                } else {
                    if ($("#modelo").val() === '57') {
                        Transportador(tipo);
                    } else {
                        Fornecedor(tipo);
                    }
                }
            }
        } else {
            if ($("#cnpj").val() !== '') {
                if (!validarCNPJ($("#cnpj").val())) {
                    bootbox.alert("CNPJ Inválido!");
                    $("#cnpj").val('');
                    //                    $("#CNPJ").select();
                } else {
                    if ($("#modelo").val() === '57') {
                        Transportador(tipo);
                    } else {
                        Fornecedor(tipo);
                    }
                }
            }
        }
    }

    function validarCNPJ(cnpj) {

        cnpj = cnpj.replace(/[^\d]+/g, '');

        if (cnpj == '')
            return false;

        if (cnpj.length != 14)
            return false;

        // Elimina CNPJs invalidos conhecidos
        if (cnpj == "00000000000000" ||
            cnpj == "11111111111111" ||
            cnpj == "22222222222222" ||
            cnpj == "33333333333333" ||
            cnpj == "44444444444444" ||
            cnpj == "55555555555555" ||
            cnpj == "66666666666666" ||
            cnpj == "77777777777777" ||
            cnpj == "88888888888888" ||
            cnpj == "99999999999999")
            return false;

        // Valida DVs
        tamanho = cnpj.length - 2
        numeros = cnpj.substring(0, tamanho);
        digitos = cnpj.substring(tamanho);
        soma = 0;
        pos = tamanho - 7;
        for (i = tamanho; i >= 1; i--) {
            soma += numeros.charAt(tamanho - i) * pos--;
            if (pos < 2)
                pos = 9;
        }
        resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
        if (resultado != digitos.charAt(0))
            return false;

        tamanho = tamanho + 1;
        numeros = cnpj.substring(0, tamanho);
        soma = 0;
        pos = tamanho - 7;
        for (i = tamanho; i >= 1; i--) {
            soma += numeros.charAt(tamanho - i) * pos--;
            if (pos < 2)
                pos = 9;
        }
        resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
        if (resultado != digitos.charAt(1))
            return false;

        return true;
    }

    function validarCPF(cpf) {
        cpf = cpf.replace(/[^\d]+/g, '');
        if (cpf == '')
            return false;
        // Elimina CPFs invalidos conhecidos	
        if (cpf.length != 11 ||
            cpf == "00000000000" ||
            cpf == "11111111111" ||
            cpf == "22222222222" ||
            cpf == "33333333333" ||
            cpf == "44444444444" ||
            cpf == "55555555555" ||
            cpf == "66666666666" ||
            cpf == "77777777777" ||
            cpf == "88888888888" ||
            cpf == "99999999999")
            return false;
        // Valida 1o digito	
        add = 0;
        for (i = 0; i < 9; i++)
            add += parseInt(cpf.charAt(i)) * (10 - i);
        rev = 11 - (add % 11);
        if (rev == 10 || rev == 11)
            rev = 0;
        if (rev != parseInt(cpf.charAt(9)))
            return false;
        // Valida 2o digito	
        add = 0;
        for (i = 0; i < 10; i++)
            add += parseInt(cpf.charAt(i)) * (11 - i);
        rev = 11 - (add % 11);
        if (rev == 10 || rev == 11)
            rev = 0;
        if (rev != parseInt(cpf.charAt(10)))
            return false;
        return true;
    }

    function CarregaProdNFe() {
        $("#carregando").css("display", "block");
        $("#recebeprodutoNFe").load('_backend/_model/produtoentnfe_model.php?fornecedor=' + $('#cnpj').val() + '&entnfe=' + $('#entnfeid').val(), function() {
            $("#carregando").css("display", "none");
        });
        $("#carregando").css("display", "none");
    }

    function CarregaProdNFeImp(valor) {
        $("#carregando").css("display", "block");
        $("#recebeprodutoNFe").load('_backend/_model/produtoentnfe_model.php?fornecedor=' + $('#cnpj').val() + '&entnfe=' + valor, function() {
            $("#carregando").css("display", "none");
        });
        $("#carregando").css("display", "none");
    }

    function CarregaDuplicata() {
        $("#carregando").css("display", "block");
        $("#recebeduplicata").load('_backend/_model/duplicataentnfe_model.php?nNF=' + $('#entnfeid').val(), function() {
            $("#carregando").css("display", "none");
        });
        $("#carregando").css("display", "none");
    }

    function Fornecedor(valor) {
        //        alert(valor);
        $("#cnpj").val(valor);
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/fornecedor_select_ajax.php",
            data: {
                fornecedor: valor
            },
            dataType: "json",
            // função para de sucesso
            success: function(data) {
                //  alert();
                if (data != null) {
                    //                    alert(data[0].xNome);
                    $("input[name='destxNome']").val(data[0].xNome);
                    $("input[name='destCNPJ']").val(data[0].CNPJ);
                    $("input[name='destIE']").val(data[0].IE);
                    $("input[name='destISUF']").val(data[0].ISUF);
                    $("input[name='destCEP']").val(data[0].CEP);
                    $("input[name='destxLgr']").val(data[0].xLgr);
                    $("input[name='destnro']").val(data[0].nro);
                    $("input[name='destxCpl']").val(data[0].xCpl);
                    $("input[name='destxBairro']").val(data[0].xBairro);
                    $("input[name='destxMun']").val(data[0].xMun);
                    $("input[name='destcMun']").val(data[0].cMun);
                    $("input[name='destUF']").val(data[0].UF);
                    $("input[name='destfone']").val(data[0].fone);
                    $("input[name='destemail']").val(data[0].email);
                }
            }
        });
    } //termina o jquery

    function Transportador(valor) {
        //        alert(valor);
        $("#cnpj").val(valor);
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/transportador_select_ajax.php",
            data: {
                transportador: valor
            },
            dataType: "json",
            // função para de sucesso
            success: function(data) {
                //  alert();
                if (data != null) {
                    //                    alert(data[0].xNome);
                    $("input[name='destxNome']").val(data[0].xNome);
                    $("input[name='destCNPJ']").val(data[0].CNPJ);
                    $("input[name='destIE']").val(data[0].IE);
                    $("input[name='destISUF']").val(data[0].ISUF);
                    $("input[name='destCEP']").val(data[0].CEP);
                    $("input[name='destxLgr']").val(data[0].xLgr);
                    $("input[name='destnro']").val(data[0].nro);
                    $("input[name='destxCpl']").val(data[0].xCpl);
                    $("input[name='destxBairro']").val(data[0].xBairro);
                    $("input[name='destxMun']").val(data[0].xMun);
                    $("input[name='destcMun']").val(data[0].cMun);
                    $("input[name='destUF']").val(data[0].UF);
                    $("input[name='destfone']").val(data[0].fone);
                    $("input[name='destemail']").val(data[0].email);
                }
            }
        }); //termina o jquery

        $("#busca").modal('hide');
    }

    $(document).ready(function() {
        $("#cfop").blur(function() {
            CFOP($("#cfop").val());
        });

        $("#modelo").blur(function() {
            //            alert($("#modelo").val());
            if ($("#modelo").val() !== '55') {
                $("#navprodutos").css("display", "none");
                $("#exibecst").css("display", "block");
                //                $("#navfatura").css("display", "none");
            } else {
                $("#navprodutos").css("display", "inline-block");
                $("#navfatura").css("display", "inline-block");
                $("#exibecst").css("display", "none");
            }
        });

        $("#modelo").blur(function() {
            if ($("#modelo").val() === '57') {
                $("#buscaFornecedor").attr("onclick", "BuscaEnt('transportador')");
            } else {
                $("#buscaFornecedor").attr("onclick", "BuscaEnt('fornecedor')");
            }
        });
    });

    function CFOP(valor) {
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/cfop_select_ajax.php",
            data: {
                cfop: valor
            },
            dataType: "json",
            // função para de sucesso
            success: function(data) {
                //                alert(data[0]);
                if (data[0] != undefined) {
                    //                    alert(data[0].xNome);
                    $("input[name='CFOP']").val(data[0].CFOP);
                    $("#descricaocfop").val(data[0].descricao);
                } else {
                    bootbox.alert("CFOP Não encontrado");
                    $("#descricaocfop").val('');
                }
            }
        }); //termina o jquery

        $("#busca").modal('hide');
    }

    function BuscaEnt(valor) {
        //        alert('busca');
        $("#busca").modal('show');
        $("#buscatitle").html('BUSCA ' + valor.toUpperCase());
        $("#carregandobusca").css("display", "block");
        $("#recebegrid").load('_backend/_view/_grid/' + valor + '_grid.php?busca=S', function() {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }

    function Editar(valor) {
        $("#produto").modal('show');
        $("#carregandoproduto").css("display", "block");
        $("#recebeproduto").load('_backend/_view/_form/produto_form_ent_nfe.php?entrada=S&editarpnfe=' + valor, function() {
            $("#carregandoproduto").css("display", "none");
        });
        $("#carregandoproduto").css("display", "none");
    }



    function AddProdutoNeg() {
        var vNF = $("#valortotalnf").val();
        if (vNF <= 0) {
            alert("Valor da NFe esta zerado!");
            return false;
        }
        if ($("#cadnf").val() === '') {
            $.ajax({
                type: 'POST',
                url: '<?= BACKEND ?>/_controller/_insert/entnfe_insert.php',
                data: {
                    nNF: $('#nNF').val()
                },
                dataType: "json",
                // função para de sucesso
                success: function(data) {

                    if (data.retorno == true) {
                        $('#cadnf').val('S');
                        $('#entnfeid').val(data.entnfeid);
                    } else {
                        alert("Preencha o Numero da NF para prosseguir.");
                    }
                }

            });
        }

        bootbox.confirm({
            message: "Deseja incluir os produtos negativos no estoque?",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function(result) {
                if (result) {

                    $.ajax({
                        type: 'GET',
                        url: '<?= BACKEND ?>/_controller/_select/_ajax/produtos_negativos_entrada.php',
                        data: {
                            nNF: $('#entnfeid').val(),
                            total: vNF
                        },
                        dataType: "json",
                        // função para de sucesso
                        success: function(data) {

                            if (data.retorno == true) {
                                CarregaProdNFe();
                            } else {
                                alert("Preencha o Numero da NF para prosseguir.");
                            }
                        }

                    });
                }

            }
        });
    }

    function AddProduto() {

        if ($("#cadnf").val() == '') {
            $.ajax({
                type: 'POST',
                url: '<?= BACKEND ?>/_controller/_insert/entnfe_insert.php',
                data: {
                    nNF: $('#nNF').val()
                },
                dataType: "json",
                // função para de sucesso
                success: function(data) {

                    if (data.retorno == true) {
                        $('#cadnf').val('S');
                        $('#entnfeid').val(data.entnfeid);
                        $("#produto").modal('show');
                        $("#carregandoproduto").css("display", "block");
                        $("#recebeproduto").load('_backend/_view/_form/produto_form_ent_nfe.php?entnfe=' + data.entnfeid, function() {
                            $("#carregandoproduto").css("display", "none");
                        });
                        $("#carregandoproduto").css("display", "none");
                    } else {
                        alert("Preencha o Numero da NF para prosseguir.")
                    }
                }

            });
        } else {
            $("#produto").modal('show');
            $("#carregandoproduto").css("display", "block");
            $("#recebeproduto").load('_backend/_view/_form/produto_form_ent_nfe.php?entnfe=' + $('#entnfeid').val(), function() {
                $("#carregandoproduto").css("display", "none");
            });
            $("#carregandoproduto").css("display", "none");
        }
    }

    function addDuplicata() {
        $("#produto").modal('show');
        $("#carregandoproduto").css("display", "block");
        $("#recebeproduto").load('_backend/_view/_form/geraduplicataent_form.php?nNF=' + $('#entnfeid').val(), function() {
            $("#carregandoproduto").css("display", "none");
        });
        $("#carregandoproduto").css("display", "none");
    }

    function SomaAliqNF(valor) {
        //        alert($("#modelo").val());
        if ($("#modelo").val() === '55') {
            $.ajax({
                type: "GET",
                url: "<?= BACKEND ?>/_controller/_select/_ajax/produto_entnfe_select_ajax.php",
                data: {
                    nNF: valor
                },
                dataType: "json",
                // função para de sucesso
                success: function(data) {
                    //  alert();
                    var vBC = 0;
                    var vBCST = 0;
                    var vICMS = 0;
                    var vICMSST = 0;
                    var vIPI = 0;
                    var vPIS = 0;
                    var vCOFINS = 0;
                    if (data != "undefined") {
                        //                    alert(data[0].xProd);

                        $.each(data, function(index) {
                            //                        alert(data[index].cProd);
                            vBC += parseFloat(data[index].vBC);
                            vICMS += parseFloat(data[index].vICMS);
                            vBCST += parseFloat(data[index].vBCST);
                            vICMSST += parseFloat(data[index].vICMSST);
                            vIPI += parseFloat(data[index].vIPI);
                            vPIS += parseFloat(data[index].vPIS);
                            vCOFINS += parseFloat(data[index].vCOFINS);
                        });
                        $("#vBCnf").val(vBC.toFixed(2));
                        $("#vICMSnf").val(vICMS.toFixed(2));
                        $("#vBCSTnf").val(vBCST.toFixed(2));
                        $("#vICMSSTnf").val(vICMSST.toFixed(2));
                        $("#vIPInf").val(vIPI.toFixed(2));
                        $("#vPISnf").val(vPIS.toFixed(2));
                        $("#vCOFINSnf").val(vCOFINS.toFixed(2));
                    }
                }
            }); //termina o jquery

        } else {
            return false;
        }
    }

    function DeletarDuplicata(valor) {
        var decisao = confirm("Deseja Realmente Excluir?");
        if (decisao) {
            $.ajax({
                type: 'POST',
                url: '<?= BACKEND ?>/_controller/_delete/duplicataentnfe_delete.php',
                data: {
                    nNF: $('#entnfeid').val()
                },
                dataType: "json",
                // função para de sucesso
                success: function(data) {

                    if (data.retorno == true) {
                        $("#recebeduplicata").html('');
                    }
                }

            });
        }
    }

    function Cobranca() {
        $("#nFatcob").val($("#nNF").val());
        $("#vOrigcob").val($("#valortotalprod").val());
        $("#vDesccob").val($("#vDescnf").val());
        var TotalLiqCob = parseFloat($("#valortotalprod").val()) - parseFloat($("#vDescnf").val());
        $("#vLiqcob").val(TotalLiqCob.toFixed(2));
    }

    //    window.setInterval(function () {
    //        SomaAliqNF($('#entnfeid').val());
    //    }, 4000);


    function SomaAliqBCINT(valor) {
        var ValorBc = $("#vBCInterno").val();
        var total = valor / 100 * ValorBc;
        //  var total = moedaParaNumero() * valorAliq;
        //        alert(total);
        $("#vICMSInterno").val(total.toFixed(2));
    }

    function ZeraBaseint() {
        if ($("#pICMSInterno").val() <= 0) {
            $("#vBCInterno").val('0.00');
            $("#vICMSInterno").val('0.00');
        }
    }

    function rateioValorItens(valor, campo) {
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_update/update_valor_itens.php",
            data: {
                documento: $("#entnfeid").val(),
                valor: valor,
                campo: campo
            },
            dataType: "json",
            // função para de sucesso
            success: function(data) {
                if (data.retorno) {
                    CarregaProdNFe();
                }
            }
        }); //termina o jquery
    }
</script>

<form id="nfeform" action="<?= BACKEND ?>/_controller/_update/entnfe_update.php" method="POST">

    <input readonly="" type="hidden" id="cadnf">
    <input readonly="" name="entnfeid" type="hidden" id="entnfeid">
    <input name="rascunho" value="N" type="hidden">

    <div class="row">
        <div class="col-md-12">
            <ul class="nav nav-tabs " role="tablist">
                <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab" data-toggle="tab">Dados Gerais</a></li>
                <li role="presentation"><a href="#profile" aria-controls="profile" role="tab" data-toggle="tab">Fornecedor</a></li>
                <li role="presentation" id="navprodutos"><a href="#messages" aria-controls="messages" role="tab" data-toggle="tab">Produtos</a></li>
                <li role="presentation"><a href="#settings" aria-controls="settings" role="tab" data-toggle="tab">Totais</a></li>
                <li role="presentation" id="navfatura"><a href="#fatura" aria-controls="fatura" role="tab" data-toggle="tab">Fatura</a></li>
                <li role="presentation" id="navobs"><a href="#obs" aria-controls="obs" role="tab" data-toggle="tab">Obs</a></li>
            </ul>
            <!--<section class="panel">-->
            <div class="tab-content">

                <div role="tabpanel" class="tab-pane active" id="home">
                    <!--Geral-->

                    <div class="row">
                        <div class="col-md-2">
                            <label>Modelo</label>
                            <input name="modelo" id="modelo" type="text" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-2">
                            <label>Série <span class="text-danger">*</span></label>
                            <input name="serie" type="text" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-2">
                            <label>Nº <span class="text-danger">*</span></label>
                            <input name="nNF" id="nNF" type="text" maxlength="9" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>Data Emissão<span class="text-danger">*</span></label>
                            <input name="dhEmi" type="text" required="" onkeypress="mascara(this, mdata);" maxlength="10" value="<?= date("d/m/Y") ?>" class="date form-control">
                        </div>

                        <div class="col-md-3">
                            <label>Data Chegada <span class="text-danger">*</span></label>
                            <input name="dhSaiEnt" type="text" required="" onkeypress="mascara(this, mdata);" maxlength="10" value="<?= date("d/m/Y") ?>" class="date form-control">
                        </div>
                    </div>

                    <div class="row">

                        <div class="col-md-2">
                            <label>CFOP</label>
                            <input name="CFOP" id="cfop" maxlength="4" type="text" class="form-control">
                            <i style="position: absolute; right: 22px; top: 34px; cursor: pointer;" onclick="BuscaEnt('CFOP')" class="fa fa-search"> </i>
                        </div>
                        <div class="col-md-10">
                            <label>Descrição</label>
                            <input id="descricaocfop" maxlength="8" type="text" class="form-control">
                        </div>

                    </div>

                    <div class="row" id="exibecst" style="display: none;">
                        <div class="col-md-12">
                            <label>CST/CSOSN</label>
                            <select id="cst" name="cst" class="form-control">
                                <optgroup label="CST">
                                    <option value="00">00 – Tributado integralmente</option>
                                    <option value="10">10 – Tributado com cobrança de ICMS por substituição tributária</option>
                                    <option value="20">20 – Com redução de base de cálculo</option>
                                    <option value="30">30 – Isenta ou não tributada e com cobrança de ICMS por substituição tributária</option>
                                    <option value="40">40 – Isenta</option>
                                    <option value="41">41 – Não tributada</option>
                                    <option value="50">50 – Com suspensão de ICMS</option>
                                    <option value="51">51 – Com diferimento do ICMS</option>
                                    <option value="60">60 – ICMS cobrado anteriormente por substituição tributária</option>
                                    <option value="70">70 – Com redução de base de cálculo e cobrança de ICMS por substituição tributária</option>
                                    <option value="90">90 – Outros</option>
                                </optgroup>
                                <optgroup label="CSOSN">
                                    <option value="101">101 – Tributada pelo Simples Nacional com permissão de crédito</option>
                                    <option value="102">102 – Tributada pelo Simples Nacional sem permissão de crédito</option>
                                    <option value="201">201 – Tributada pelo Simples Nacional com permissão de crédito e com cobrança de ICMS por substituição tributária</option>
                                    <option value="202">202 – Tributada pelo Simples Nacional sem permissão de crédito e com cobrança de ICMS por substituição tributária</option>
                                    <option value="300">300 – Imune</option>
                                    <option value="400">400 – Não tributada pelo Simples Nacional</option>
                                    <option value="500">500 – ICMS cobrado anteriormente por substituição tributária ou por antecipação</option>
                                </optgroup>
                            </select>
                        </div>
                    </div>
                    <div class="row">

                        <div class="col-md-12">
                            <label>Chave</label>
                            <input name="chavenfe" maxlength="44" type="text" class="form-control" placeholder="Chave da NFe ou busque o XML para importação">
                            <i style="position: absolute; right: 22px; top: 34px; cursor: pointer;" onclick="Import()" class="fa fa-search"> </i>
                        </div>

                    </div>

                </div>


                <!--Geral-->

                <!--CLIENTE-->
                <div role="tabpanel" class="tab-pane" id="profile">

                    <div class="row">
                        <div class="col-md-5">
                            <label>CPF/CNPJ <span class="text-danger">*</span></label>
                            <input name="destCNPJ" id="cnpj" type="text" required="" onblur="ValidaDoc()" class="form-control" maxlength="14" placeholder="">
                            <i id="buscaFornecedor" style="position: absolute; right: 22px; top: 34px; cursor: pointer;" onclick="BuscaEnt('fornecedor')" class="fa fa-search"> </i>
                        </div>

                        <div class="col-md-4">
                            <label>Insc. Estadual</label>
                            <input name="destIE" type="text" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>Insc. SUFRAMA </label>
                            <input name="destISUF" type="text" class="form-control" placeholder="">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <label>Nome/Razao Social <span class="text-danger">*</span></label>
                            <input name="destxNome" type="text" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-6">
                            <label>E-mail</label>
                            <input name="destemail" type="email" class="form-control" placeholder="">
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <label>CEP <span class="text-danger">*</span></label>
                            <input name="destCEP" id="destCEP" onchange="BuscaCep(this.value, 'dest')" type="text" maxlength="8" required="" class="form-control" placeholder="">
                            <a href="http://www.buscacep.correios.com.br/sistemas/buscacep/BuscaCepEndereco.cfm" target="_blank"><i style="position: absolute; right: 22px; top: 34px; cursor: pointer;" class="fa fa-search"> </i> </a>

                        </div>

                        <div class="col-md-5">
                            <label>Logradouro <span class="text-danger">*</span></label>
                            <input name="destxLgr" id="destxLgr" type="text" minlength="2" maxlength="60" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-2">
                            <label>Nº <span class="text-danger">*</span></label>
                            <input name="destnro" id="destnro" type="text" maxlength="60" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-2">
                            <label>Com.</label>
                            <input name="destxCpl" id="destxCpl" type="text" maxlength="60" class="form-control" placeholder="">
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <label>Bairro <span class="text-danger">*</span></label>
                            <input name="destxBairro" id="destxBairro" type="text" maxlength="60" minlength="2" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>Município <span class="text-danger">*</span></label>
                            <input name="destxMun" id="destxMun" readonly="" type="text" minlength="2" maxlength="60" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-2">
                            <label>IBGE<span class="text-danger">*</span></label>
                            <input name="destcMun" id="destcMun" type="text" maxlength="7" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-2">
                            <label>UF <span class="text-danger">*</span></label>
                            <input name="destUF" id="destUF" readonly="" type="text" maxlength="2" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-2">
                            <label>Fone</label>
                            <input name="destfone" maxlength="15" onkeypress='mascaraTelefone(this, cpfCnpj)' type="text" minlength="6" class="form-control" placeholder="">

                        </div>

                    </div>
                </div>

                <!--PRODUTO-->
                <div role="tabpanel" class="tab-pane" id="messages">
                    <a href="javascript:;" onclick="AddProduto()" class="btn btn-circle btn-default">
                        <i class="fa fa-plus"></i> Incluir Produto </a>
                    <?php
                    //                    echo $paramneg;
                    if ($parametros->prodnegentrada === 'S') :
                    ?>
                        <a href="javascript:;" onclick="AddProdutoNeg()" class="btn btn-circle btn-default">
                            <i class="fa fa-plus"></i> Adicionar Produtos Negativos </a>
                    <?php
                    endif;
                    ?>

                    <hr />

                    <div id="recebeprodutoNFe">

                    </div>

                </div>
                <!--FIM PRODUTOS-->

                <!--TOTAIS-->
                <div role="tabpanel" class="tab-pane" id="settings">

                    <div class="row">
                        <div class="col-md-3">
                            <label>Base de Cálc.</label>
                            <input name="vBCnf" id="vBCnf" type="text" value="0.00" onkeypress="mascara(this, mvalor);" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>Total ICMS </label>
                            <input name="vICMSnf" id="vICMSnf" type="text" value="0.00" onkeypress="mascara(this, mvalor);" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>Base ICMS ST </label>
                            <input name="vBCSTnf" id="vBCSTnf" type="text" value="0.00" onkeypress="mascara(this, mvalor);" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>Total ICMS ST</label>
                            <input name="vSTnf" id="vICMSSTnf" type="text" value="0.00" onkeypress="mascara(this, mvalor);" required="" class="form-control" placeholder="">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <label>Total Produtos </label>
                            <input name="vProdnf" id="valortotalprod" onkeypress="mascara(this, mvalor);" type="text" required="" value="0.00" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>Total Frete </label>
                            <input name="vFretenf" id="vFretenf" type="text" onkeypress="mascara(this, mvalor);" onblur="rateioValorItens(this.value, 'vFrete')" value="0.00" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>Total Trib.</label>
                            <input name="vTotTribnf" id="vTotTrib" onkeypress="mascara(this, mvalor);" type="text" value="0.00" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>Outras</label>
                            <input name="vOutronf" id="vOutronf" onkeypress="mascara(this, mvalor);" onblur="rateioValorItens(this.value, 'vOutro')" type="text" value="0.00" required="" class="form-control" placeholder="">
                        </div>
                    </div>


                    <div class="row">

                        <div class="col-md-3">
                            <label>Total FCP retido por ST </label>
                            <input name="vFCPST" id="vFCPST" onkeypress="mascara(this, mvalor);" type="text" value="0.00" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>Total IPI</label>
                            <input name="vIPInf" id="vIPInf" onkeypress="mascara(this, mvalor);" type="text" value="0.00" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>PIS</label>
                            <input name="vPISnf" id="vPISnf" onkeypress="mascara(this, mvalor);" type="text" value="0.00" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>COFINS </label>
                            <input name="vCOFINSnf" id="vCOFINSnf" onkeypress="mascara(this, mvalor);" type="text" value="0.00" required="" class="form-control" placeholder="">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <label>Total Seguro</label>
                            <input name="vSegnf" id="vSegnf" onkeypress="mascara(this, mvalor);" type="text" value="0.00" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>Total Desconto</label>
                            <input name="vDescnf" id="vDescnf" onkeypress="mascara(this, mvalor);" type="text" value="0.00" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label title="Total ICMS Desonerado">ICMS Deson.</label>
                            <input name="vICMSDesonnf" onkeypress="mascara(this, mvalor);" type="text" value="0.00" required="" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>Total da Nota</label>
                            <input name="vNF" id="valortotalnf" type="text" value="0.00" required="" onkeypress="mascara(this, mvalor);" class="form-control" placeholder="">
                        </div>
                    </div>

                </div>
                <!--FIM TOTAIS-->


                <!--COBRANÇA-->
                <div role="tabpanel" class="tab-pane" id="fatura">

                    <div class="row">
                        <div class="col-md-12">
                            <a href="javascript::" onclick="addDuplicata()" class="btn btn-info form-control">Gerar Pagamentos</a>
                        </div>
                    </div>

                    <div class="row">
                        <div id="recebeduplicata"></div>
                    </div>
                </div>

                <!--COBRANÇA-->

                <!--OBS-->
                <div role="tabpanel" class="tab-pane" id="obs">
                    <div class="row">
                        <div class="col-md-12">
                            <label>ICMS ST INTERNO</label>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <label>Cód. do ajuste</label>
                            <input type="text" class="form-control" name="codajust">
                        </div>
                    </div>

                    <div class="row">

                        <div class="col-md-3">
                            <label>Base Cal</label>
                            <input name="vBCInterno" id="vBCInterno" onkeyup="SomaAliqBCINT(document.getElementById('pICMSInterno').value)" onkeypress="mascara(this, mvalor);" value="0.00" type="text" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>Aliq</label>
                            <input name="pICMSInterno" id="pICMSInterno" value="0.00" onkeyup="SomaAliqBCINT(this.value)" onblur="ZeraBaseINT()" onkeypress="mascara(this, mvalor);" type="text" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>Valor</label>
                            <input name="vICMSInterno" id="vICMSInterno" value="0.00" onkeypress="mascara(this, mvalor);" type="text" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label>Outros </label>
                            <input name="vOutrosInterno" id="vOutrosInterno" value="0.00" onkeypress="mascara(this, mvalor);" type="text" class="form-control" placeholder="">
                        </div>

                    </div>
                </div>
                <!--OBS-->

            </div>
            <div class="row">
                <div class="col-md-12 text-right">
                    <button type="submit" class="btn btn-success" id="submitButtonEntrada"> <i class="fa fa-save"></i> Salvar </button>
                </div>
            </div>

        </div>
    </div>
</form>


<!--Modal Import-->
<div class="modal fade modal-info" id="Import" aria-hidden="true" aria-labelledby="Import" role="dialog" tabindex="-1">
    <div class="modal-dialog  modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
                <h4 class="modal-title text-uppercase">Importar XML</h4>
            </div>
            <div class="modal-body" style="max-height: 700px; overflow-y: scroll;">
                <form name="formUpload" id="formUpload" method="post">

                    <div class="row">
                        <div class="col-md-2">
                            <select id="tipoimport" class="form-control">
                                <option value="NFE"> NFe </option>
                                <option value="CTE"> CTe </option>
                            </select>
                        </div>
                        <div class="col-md-7">
                            <input id="uploadFile" class="form-control" placeholder="" disabled="disabled" />
                        </div>

                        <div class="col-md-1 form-group">
                            <div class="fileUpload btn btn-primary form-control">
                                <span><i class="fa fa-arrow-left"></i> </span>
                                <input type="file" name="arquivo" id="arquivo" onchange="Arquivo(this.value);" class="upload form-control" />
                            </div>
                        </div>

                        <div class="col-md-2">
                            <input type="button" class="btn btn-info" id="btnEnviarXML" value="Importar" />
                        </div>
                    </div>
                    <div id="resposta">

                    </div>
                        <!-- <div class="col-md-12">
                            <progress value="0" max="100"></progress><span id="porcentagem">0%</span>
                        </div> -->

                </form>
            </div>


        </div>
    </div>
</div>
<!--Fim Modal Imoort-->

<style>
    .fileUpload {
        position: relative;
        overflow: hidden;
        margin: 0px;
    }

    .fileUpload input.upload {
        position: absolute;
        top: 0;
        right: 0;
        margin: 0;
        padding: 0;
        font-size: 20px;
        cursor: pointer;
        opacity: 0;
        filter: alpha(opacity=0);
    }
</style>

<script>
    function Arquivo(valor) {
        $("#uploadFile").val(valor);
    }

    $(document).ready(function() {

        $('#btnEnviarXML').click(function() {
            $('#formUpload').ajaxForm({
                uploadProgress: function(event, position, total, percentComplete) {
                    $('progress').attr('value', percentComplete);
                    $('#porcentagem').html(percentComplete + '%');
                },
                success: function(data) {
                    $('progress').attr('value', '100');
                    $('#porcentagem').html('100%');
                    if (data.sucesso == true) {
                        //                                    alert($("#tipoimport").val());
                        if ($("#tipoimport").val() === 'NFE') {
                            XML(data.arquivo);
                        } else {
                            XMLCTE(data.arquivo);
                        }
                    } else {
                        data.msg;
                    }
                },
                error: function() {
                    $('#resposta').html('Erro ao enviar requisição!!!');
                },
                dataType: 'json',
                url: '<?= BACKEND ?>/_controller/_import/enviar_arquivo.php',
                //                            resetForm: true
            }).submit();
        })
    })

    function dataAtualFormatada(valor) {
        var string = valor;
        var res = string.substr(8, 2);
        res += '/';
        res += string.substr(5, 2);
        res += '/';
        res += string.substr(0, 4);
        return res;
    }

    function XMLCTE(valor) {
        //                    alert('Entrou');
        var entnfeidn;
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_import/nfe_import.php",
            data: {
                arquivo: valor
            },
            dataType: "json",
            success: function(data) {

                $.ajax({
                    type: 'POST',
                    url: '<?= BACKEND ?>/_controller/_insert/entnfe_insert.php',
                    data: {
                        nNF: data.cteProc.CTe.infCte.ide.nCT
                    },
                    dataType: "json",
                    // função para de sucesso
                    success: function(data) {

                        if (data.retorno == true) {
                            $("#entnfeid").val(data.entnfeid);
                            entnfeidn = data.entnfeid;
                            //                                        ImportXML(valor, entnfeidn);
                            ImportXMLCTe(valor, entnfeidn);
                        } else {
                            alert("Preencha o Numero da NF para prosseguir.");
                            return false;
                        }
                    }
                });
            }
        });
    }

    function XML(valor) {
        var entnfeidn;
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_import/nfe_import.php",
            data: {
                arquivo: valor
            },
            dataType: "json",
            success: function(data) {
                $.ajax({
                    type: 'POST',
                    url: '<?= BACKEND ?>/_controller/_select/_ajax/verifica_nfe_entrada_existente.php',
                    data: {
                        nNF: data.nfeProc.NFe.infNFe.ide.nNF,
                        CNPJ: data.nfeProc.NFe.infNFe.emit.CNPJ,
                        serie: data.nfeProc.NFe.infNFe.ide.serie
                    },
                    dataType: "json",
                    success: function(response) {
                        if (response.retorno == true) {
                            bootbox.confirm({
                                message: "Nota Fiscal já existe no sistema. Deseja continuar?",
                                buttons: {
                                    confirm: {
                                        label: 'Continuar',
                                        className: 'btn-success'
                                    },
                                    cancel: {
                                        label: 'Sair',
                                        className: 'btn-danger'
                                    }
                                },
                                callback: function(result) {
                                    if (result) {
                                        // Continue the normal flow
                                        insertNFe(data, valor);
                                    } else {
                                        // Carrega('_grid', 'nfe_entrada_grid.php', 'Nota Fiscal Entrada');
                                        bootbox.hideAll();
                                        return false;
                                    }
                                }
                            });
                        } else {
                            // Continue the normal flow
                            insertNFe(data, valor);
                        }
                    }
                });
            }
        });
    }

    function insertNFe(data, valor) {
        $.ajax({
            type: 'POST',
            url: '<?= BACKEND ?>/_controller/_insert/entnfe_insert.php',
            data: {
                nNF: data.nfeProc.NFe.infNFe.ide.nNF
            },
            dataType: "json",
            success: function(data) {
                if (data.retorno == true) {
                    $("#entnfeid").val(data.entnfeid);
                    var entnfeidn = data.entnfeid;
                    ImportXML(valor, entnfeidn);
                } else {
                    alert("Preencha o Numero da NF para prosseguir.");
                    return false;
                }
            }
        });
    }

    function formataNumeroTelefone(numero) {
        var length = numero.length;
        var telefoneFormatado = numero;
        if (length == 11) {
            telefoneFormatado = '(' + numero.substring(0, 3) + ') ' + numero.substring(3, 7) + '-' + numero.substring(7, 11);
        } else if (length === 12) {
            telefoneFormatado = '(' + numero.substring(1, 3) + ') ' + numero.substring(3, 8) + '-' + numero.substring(8, 12);
        } else if (length === 10) {
            telefoneFormatado = '(' + numero.substring(0, 2) + ') ' + numero.substring(2, 6) + '-' + numero.substring(6, 10);
        }
        return telefoneFormatado;
    }

    function ImportXMLCTe(valor, entnfeidn) {
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_import/nfe_import.php",
            data: {
                arquivo: valor
            },
            dataType: "json",
            success: function(data) {
                // alert('ok');
                // console.log(data);

                $("#navprodutos").css("display", "none");
                $("#exibecst").css("display", "block");

                // $("#navfatura").css("display", "none");

                $("input[name='chavenfe']").val(data.cteProc.protCTe.infProt.chCTe);
                $("input[name='nNF']").val(data.cteProc.CTe.infCte.ide.nCT);
                $("input[name='serie']").val(data.cteProc.CTe.infCte.ide.serie);
                $("input[name='modelo']").val(data.cteProc.CTe.infCte.ide.mod);
                $("input[name='dhEmi']").val(dataAtualFormatada(data.cteProc.CTe.infCte.ide.dhEmi));
                $("input[name='dhSaiEnt']").val(dataAtualFormatada(data.cteProc.CTe.infCte.ide.dhEmi));
                //BUSCA CFOP                    
                var CFOPS = data.cteProc.CTe.infCte.ide.CFOP;
                var ICFOP = CFOPS.substr(0, 1);
                ICFOP = ICFOP.replace("5", "1");
                ICFOP = ICFOP.replace("6", "2");
                CFOPS = ICFOP + '' + CFOPS.substr(1, 3);
                $("input[name='CFOP']").val(CFOPS);
                CFOP(CFOPS);

                //dados do emitente
                if (typeof data.cteProc.CTe.infCte.emit.CNPJ === "undefined") {
                    $("input[name='destCNPJ']").val(data.cteProc.CTe.infCte.avulsa.CNPJ);
                } else {
                    $("input[name='destCNPJ']").val(data.cteProc.CTe.infCte.emit.CNPJ);
                }

                if (typeof data.cteProc.CTe.infCte.emit.enderEmit.fone !== "undefined") {
                    $("input[name='destfone']").val(formataNumeroTelefone(data.cteProc.CTe.infCte.emit.enderEmit.fone));
                }

                if (typeof data.cteProc.CTe.infCte.emit.email !== "undefined") {
                    $("input[name='destemail']").val(data.cteProc.CTe.infCte.emit.email);
                }

                $("input[name='destxNome']").val(data.cteProc.CTe.infCte.emit.xNome);
                $("input[name='destIE']").val(data.cteProc.CTe.infCte.emit.IE);
                $("input[name='destCEP']").val(data.cteProc.CTe.infCte.emit.enderEmit.CEP);
                $("input[name='destxLgr']").val(data.cteProc.CTe.infCte.emit.enderEmit.xLgr);
                $("input[name='destnro']").val(data.cteProc.CTe.infCte.emit.enderEmit.nro);
                $("input[name='destxBairro']").val(data.cteProc.CTe.infCte.emit.enderEmit.xBairro);
                $("input[name='destxMun']").val(data.cteProc.CTe.infCte.emit.enderEmit.xMun);
                $("input[name='destcMun']").val(data.cteProc.CTe.infCte.emit.enderEmit.cMun);
                $("input[name='destUF']").val(data.cteProc.CTe.infCte.emit.enderEmit.UF);

                $("input[name='vFretenf']").val(data.cteProc.CTe.infCte.vPrest.vTPrest);
                $("input[name='vNF']").val(data.cteProc.CTe.infCte.vPrest.vTPrest);
                $("input[name='vTotTribnf']").val('0.00');
            }
        });
        $("#Import").modal('hide');
    }


    function ImportXML(valor, entnfeidn) {
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_import/nfe_import.php",
            data: {
                arquivo: valor
            },
            dataType: "json",
            success: function(data) {

                var dataemissao = dataAtualFormatada(data.nfeProc.NFe.infNFe.ide.dhEmi);
                $("input[name='chavenfe']").val(data.nfeProc.protNFe.infProt.chNFe);
                $("input[name='nNF']").val(data.nfeProc.NFe.infNFe.ide.nNF);
                $("input[name='serie']").val(data.nfeProc.NFe.infNFe.ide.serie);
                $("input[name='modelo']").val(data.nfeProc.NFe.infNFe.ide.mod);
                $("input[name='dhEmi']").val(dataAtualFormatada(data.nfeProc.NFe.infNFe.ide.dhEmi));
                if (data.nfeProc.NFe.infNFe.ide.dhSaiEnt == undefined) {
                    $("input[name='dhSaiEnt']").val(dataAtualFormatada(data.nfeProc.NFe.infNFe.ide.dhEmi));
                } else {
                    $("input[name='dhSaiEnt']").val(dataAtualFormatada(data.nfeProc.NFe.infNFe.ide.dhSaiEnt));
                }
                if (typeof data.nfeProc.NFe.infNFe.emit.CNPJ === "undefined") {
                    $("input[name='destCNPJ']").val(data.nfeProc.NFe.infNFe.avulsa.CNPJ);
                    var Fornecedor = data.nfeProc.NFe.infNFe.avulsa.CNPJ;
                } else {
                    $("input[name='destCNPJ']").val(data.nfeProc.NFe.infNFe.emit.CNPJ);
                    var Fornecedor = data.nfeProc.NFe.infNFe.emit.CNPJ;
                }

                if (typeof data.nfeProc.NFe.infNFe.emit.enderEmit.fone !== "undefined") {
                    var destfone = formataNumeroTelefone(data.nfeProc.NFe.infNFe.emit.enderEmit.fone);
                    $("input[name='destfone']").val(formataNumeroTelefone(data.nfeProc.NFe.infNFe.emit.enderEmit.fone));
                }

                if (typeof data.nfeProc.NFe.infNFe.emit.email !== "undefined") {
                    var destemail = data.nfeProc.NFe.infNFe.emit.email;
                    $("input[name='destemail']").val(data.nfeProc.NFe.infNFe.emit.email);
                }

                var destxNome = data.nfeProc.NFe.infNFe.emit.xNome;
                var destIE = data.nfeProc.NFe.infNFe.emit.IE;
                var destCEP = data.nfeProc.NFe.infNFe.emit.enderEmit.CEP;
                var destxLgr = data.nfeProc.NFe.infNFe.emit.enderEmit.xLgr;
                var destnro = data.nfeProc.NFe.infNFe.emit.enderEmit.nro;
                var destxBairro = data.nfeProc.NFe.infNFe.emit.enderEmit.xBairro;
                var destxMun = data.nfeProc.NFe.infNFe.emit.enderEmit.xMun;
                var destcMun = data.nfeProc.NFe.infNFe.emit.enderEmit.cMun;
                var destUF = data.nfeProc.NFe.infNFe.emit.enderEmit.UF;
                $("input[name='destxNome']").val(data.nfeProc.NFe.infNFe.emit.xNome);
                $("input[name='destIE']").val(data.nfeProc.NFe.infNFe.emit.IE);
                $("input[name='destCEP']").val(data.nfeProc.NFe.infNFe.emit.enderEmit.CEP);
                $("input[name='destxLgr']").val(data.nfeProc.NFe.infNFe.emit.enderEmit.xLgr);
                $("input[name='destnro']").val(data.nfeProc.NFe.infNFe.emit.enderEmit.nro);
                $("input[name='destxBairro']").val(data.nfeProc.NFe.infNFe.emit.enderEmit.xBairro);
                $("input[name='destxMun']").val(data.nfeProc.NFe.infNFe.emit.enderEmit.xMun);
                $("input[name='destcMun']").val(data.nfeProc.NFe.infNFe.emit.enderEmit.cMun);
                $("input[name='destUF']").val(data.nfeProc.NFe.infNFe.emit.enderEmit.UF);
                //               totais
                //                            alert(data.nfeProc.NFe.infNFe.total.ICMSTot.vFCPST);
                if (typeof data.nfeProc.NFe.infNFe.total.ICMSTot.vFCPST !== "undefined") {
                    $("input[name='vFCPST']").val(data.nfeProc.NFe.infNFe.total.ICMSTot.vFCPST);
                }
                $("input[name='vBCnf']").val(data.nfeProc.NFe.infNFe.total.ICMSTot.vBC);
                $("input[name='vICMSnf']").val(data.nfeProc.NFe.infNFe.total.ICMSTot.vICMS);
                $("input[name='vICMSDesonnf']").val(data.nfeProc.NFe.infNFe.total.ICMSTot.vICMSDeson);
                $("input[name='vBCSTnf']").val(data.nfeProc.NFe.infNFe.total.ICMSTot.vBCST);
                $("input[name='vSTnf']").val(data.nfeProc.NFe.infNFe.total.ICMSTot.vST);
                $("input[name='vProdnf']").val(data.nfeProc.NFe.infNFe.total.ICMSTot.vProd);
                $("input[name='vFretenf']").val(data.nfeProc.NFe.infNFe.total.ICMSTot.vFrete);
                $("input[name='vSegnf']").val(data.nfeProc.NFe.infNFe.total.ICMSTot.vSeg);
                $("input[name='vDescnf']").val(data.nfeProc.NFe.infNFe.total.ICMSTot.vDesc);
                $("input[name='vIInf']").val(data.nfeProc.NFe.infNFe.total.ICMSTot.vII);
                $("input[name='vIPInf']").val(data.nfeProc.NFe.infNFe.total.ICMSTot.vIPI);
                $("input[name='vPISnf']").val(data.nfeProc.NFe.infNFe.total.ICMSTot.vPIS);
                $("input[name='vCOFINSnf']").val(data.nfeProc.NFe.infNFe.total.ICMSTot.vCOFINS);
                $("input[name='vOutronf']").val(data.nfeProc.NFe.infNFe.total.ICMSTot.vOutro);
                $("input[name='vNF']").val(data.nfeProc.NFe.infNFe.total.ICMSTot.vNF);
                $("input[name='vTotTribnf']").val('0.00');

                $.each(data.nfeProc.NFe.infNFe.det, function(i, item) {
                    if (i == '@nItem') {
                        var cProd = data.nfeProc.NFe.infNFe.det.prod.cProd;
                        var NCM = data.nfeProc.NFe.infNFe.det.prod.NCM;
                        var xProd = data.nfeProc.NFe.infNFe.det.prod.xProd;
                        var uCom = data.nfeProc.NFe.infNFe.det.prod.uCom;
                        var qtd = data.nfeProc.NFe.infNFe.det.prod.qCom;
                        var vProd = data.nfeProc.NFe.infNFe.det.prod.vUnCom;
                        var valortotal = data.nfeProc.NFe.infNFe.det.prod.vProd;
                        var CFOP = data.nfeProc.NFe.infNFe.det.prod.CFOP;
                        //                        alert(CFOP);
                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS00 !== undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS00.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS00.CST;
                            var modBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS00.modBC;
                            var vBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS00.vBC;
                            var pICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS00.pICMS;
                            var vICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS00.vICMS;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS10 !== undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS10.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS10.CST;
                            var modBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS10.modBC;
                            var vBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS10.vBC;
                            var pICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS10.pICMS;
                            var vICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS10.vICMS;
                            var modBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS10.modBCST;
                            var pMVAST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS10.pMVAST;
                            var pRedBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS10.pRedBCST;
                            var vBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS10.vBCST;
                            var pICMSST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS10.pICMSST;
                            var vICMSST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS10.vICMSST;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS20 !== undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS20.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS20.CST;
                            var modBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS20.modBC;
                            var vBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS20.vBC;
                            var pICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS20.pICMS;
                            var vICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS20.vICMS;
                            var vICMSDeson = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS20.vICMSDeson;
                            var motDesICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS20.motDesICMS;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS30 !== undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS30.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS30.CST;
                            var modBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS30.modBCST;
                            var pMVAST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS30.pMVAST;
                            var pRedBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS30.pRedBCST;
                            var vBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS30.vBCST;
                            var pICMSST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS30.pICMSST;
                            var vICMSST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS30.vICMSST;
                            var vICMSDeson = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS30.vICMSDeson;
                            var motDesICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS30.motDesICMS;
                        }


                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS40 !== undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS40.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS40.CST;
                            //var vICMSDeson = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS40.vICMSDeson;
                            //var motDesICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS40.motDesICMS;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS41 !== undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS41.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSS41.CST;
                            // var vICMSDeson = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS41.vICMSDeson;
                            //var motDesICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS41.motDesICMS;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS50 !== undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICM50.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS50.CST;
                            //var vICMSDeson = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS50.vICMSDeson;
                            //var motDesICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS50.motDesICMS;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS51 !== undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS51.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS51.CST;
                            var modBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS51.modBC;
                            var pRedBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS51.pRedBC;
                            var vBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS51.vBC;
                            var pICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS51.pICMS;
                            var vICMSOp = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS51.vICMSOp;
                            var pDif = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS51.pDif;
                            var vICMSDif = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS51.vICMSDif;
                            var vICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS51.vICMS;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS60 !== undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS60.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS60.CST;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS70 !== undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS70.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS70.CST;
                            var modBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS70.modBC;
                            var pRedBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS70.pRedBC;
                            var vBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS70.vBC;
                            var pICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS70.pICMS;
                            var vICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS70.vICMS;
                            var modBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS70.modBCST;
                            var pMVAST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS70.pMVAST;
                            var pRedBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS70.pRedBCST;
                            var vBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS70.vBCST;
                            var pICMSST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS70.pICMSST;
                            var vICMSST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS70.vICMSST;
                            var vICMSDeson = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS70.vICMSDeson;
                            var motDesICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS70.motDesICMS;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS90 !== undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS90.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS90.CST;
                            var modBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS90.modBC;
                            var vBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS90.vBC;
                            var pICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMS90.pICMS;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN101 !== undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN101.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN101.CSOSN;
                            var pCredSN = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN101.pCredSN;
                            var vCredICMSSN = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN101.vCredICMSSN;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN102 !== undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN102.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN102.CSOSN;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN201 !== undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN201.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN201.CSOSN;
                            var modBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN201.modBCST;
                            var pMVAST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN201.pMVAST;
                            var pRedBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN201.pRedBCST;
                            var vBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN201.vBCST;
                            var pICMSST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN201.pICMSST;
                            var vICMSST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN201.vICMSST;
                            var pCredSN = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN201.pCredSN;
                            var vCredICMSSN = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN201.vCredICMSSN;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN202 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN202.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN202.CSOSN;
                            var modBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN202.modBCST;
                            var pMVAST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN202.pMVAST;
                            var pRedBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN202.pRedBCST;
                            var vBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN202.vBCST;
                            var pICMSST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN202.pICMSST;
                            var vICMSST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN202.vICMSST;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN500 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN500.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN500.CSOSN;
                            var vBCSTRet = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN500.vBCSTRet;
                            var vICMSSTRet = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN500.vICMSSTRet;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN900 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN900.orig;
                            var CST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN900.CSOSN;
                            var modBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN900.modBC;
                            var vBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN900.vBC;
                            var pRedBC = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN900.pRedBC;
                            var pICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN900.pICMS;
                            var vICMS = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN900.vICMS;
                            var modBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN900.modBCST;
                            var pMVAST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN900.pMVAST;
                            var pRedBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN900.pRedBCST;
                            var vBCST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN900.vBCST;
                            var pICMSST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN900.pICMSST;
                            var vICMSST = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN900.vICMSST;
                            var vBCSTRet = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN900.vBCSTRet;
                            var vICMSSTRet = data.nfeProc.NFe.infNFe.det.imposto.ICMS.ICMSSN900.vICMSSTRet;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.IPI != undefined) {
                            var clEnq = data.nfeProc.NFe.infNFe.det.imposto.IPI.clEnq;
                            var CNPJProd = data.nfeProc.NFe.infNFe.det.imposto.IPI.CNPJProd;
                            var cSelo = data.nfeProc.NFe.infNFe.det.imposto.IPI.cSelo;
                            var qSelo = data.nfeProc.NFe.infNFe.det.imposto.IPI.qSelo;
                            var cEnq = data.nfeProc.NFe.infNFe.det.imposto.IPI.cEnq;
                            if (data.nfeProc.NFe.infNFe.det.imposto.IPI.IPITrib != undefined) {
                                var CSTIPI = data.nfeProc.NFe.infNFe.det.imposto.IPI.IPITrib.CST;
                                var vBCIPI = data.nfeProc.NFe.infNFe.det.imposto.IPI.IPITrib.vBC;
                                var pIPI = data.nfeProc.NFe.infNFe.det.imposto.IPI.IPITrib.pIPI;
                                var qUnidIPI = data.nfeProc.NFe.infNFe.det.imposto.IPI.IPITrib.qUnid;
                                var vUnidIPI = data.nfeProc.NFe.infNFe.det.imposto.IPI.IPITrib.vUnid;
                                var vIPI = data.nfeProc.NFe.infNFe.det.imposto.IPI.IPITrib.vIPI;
                            }

                            if (data.nfeProc.NFe.infNFe.det.imposto.IPI.IPINT != undefined) {
                                var CSTIPI = data.nfeProc.NFe.infNFe.det.imposto.IPI.IPINT.CST;
                            }
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.PIS.PISAliq !== undefined) {
                            var CSTPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISAliq.CST;
                            var vBCPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISAliq.vBC;
                            var pPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISAliq.pPIS;
                            var vPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISAliq.vPIS;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.PIS.PISQtde !== undefined) {
                            var CSTPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISQtde.CST;
                            var qBCProdPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISQtde.qBCProd;
                            var AliqProdPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISQtde.AliqProd;
                            var vPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISQtde.vPIS;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.PIS.PISNT !== undefined) {

                            var CSTPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISNT.CST;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.PIS.PISOutr !== undefined) {
                            var CSTPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISOutr.CST;
                            var vPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISOutr.vPIS;
                            var qBCProdPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISOutr.qBCProd;
                            var vAliqProdPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISOutr.vAliqProd;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.PIS.PISST !== undefined) {

                            var vBCPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISST.vBC;
                            var pPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISST.pPIS;
                            var qBCProdPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISST.qBCProd;
                            var AliqProdPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISST.AliqProd;
                            var vPIS = data.nfeProc.NFe.infNFe.det.imposto.PIS.PISST.vPIS;
                        }


                        if (data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSAliq !== undefined) {
                            var CSTCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSAliq.CST;
                            var vBCCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSAliq.vBC;
                            var pCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSAliq.pCOFINS;
                            var vCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSAliq.vCOFINS;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSQtde !== undefined) {
                            var CSTCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSQtde.CST;
                            var qBCProdCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSQtde.qBCProd;
                            var AliqProdCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSQtde.AliqProd;
                            var vCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSQtde.vCOFINS;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSNT !== undefined) {
                            var CSTCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSNT.CST;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSOutr !== undefined) {
                            var CSTCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSOutr.CST;
                            var vCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSOutr.vCOFINS;
                            var qBCProdCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSOutr.qBCProd;
                            var vAliqProdCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSOutr.vAliqProd;
                        }

                        if (data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSST !== undefined) {
                            var vBCCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSST.vBC;
                            var pCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSST.pCOFINS;
                            var qBCProdCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSST.qBCProd;
                            var AliqProdCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSST.AliqProd;
                            var vCOFINS = data.nfeProc.NFe.infNFe.det.imposto.COFINS.COFINSST.vCOFINS;
                        }
                        $("#Import").modal('hide');
                    } else {
                        //                        alert('Entrou')
                        var cProd = data.nfeProc.NFe.infNFe.det[i].prod.cProd;
                        var NCM = data.nfeProc.NFe.infNFe.det[i].prod.NCM;
                        var xProd = data.nfeProc.NFe.infNFe.det[i].prod.xProd;
                        var uCom = data.nfeProc.NFe.infNFe.det[i].prod.uCom;
                        var qtd = data.nfeProc.NFe.infNFe.det[i].prod.qCom;
                        var vProd = data.nfeProc.NFe.infNFe.det[i].prod.vUnCom;
                        var valortotal = data.nfeProc.NFe.infNFe.det[i].prod.vProd;
                        var CFOP = data.nfeProc.NFe.infNFe.det[i].prod.CFOP;
                        //                        alert(CFOP);
                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS00 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS00.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS00.CST;
                            var modBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS00.modBC;
                            var vBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS00.vBC;
                            var pICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS00.pICMS;
                            var vICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS00.vICMS;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS10 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS10.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS10.CST;
                            var modBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS10.modBC;
                            var vBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS10.vBC;
                            var pICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS10.pICMS;
                            var vICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS10.vICMS;
                            var modBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS10.modBCST;
                            var pMVAST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS10.pMVAST;
                            var pRedBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS10.pRedBCST;
                            var vBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS10.vBCST;
                            var pICMSST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS10.pICMSST;
                            var vICMSST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS10.vICMSST;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS20 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS20.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS20.CST;
                            var modBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS20.modBC;
                            var vBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS20.vBC;
                            var pICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS20.pICMS;
                            var vICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS20.vICMS;
                            var vICMSDeson = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS20.vICMSDeson;
                            var motDesICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS20.motDesICMS;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS30 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS30.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS30.CST;
                            var modBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS30.modBCST;
                            var pMVAST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS30.pMVAST;
                            var pRedBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS30.pRedBCST;
                            var vBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS30.vBCST;
                            var pICMSST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS30.pICMSST;
                            var vICMSST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS30.vICMSST;
                            var vICMSDeson = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS30.vICMSDeson;
                            var motDesICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS30.motDesICMS;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS40 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS40.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS40.CST;
                            //var vICMSDeson = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS40.vICMSDeson;
                            //var motDesICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS40.motDesICMS;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS41 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS41.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSS41.CST;
                            //  var vICMSDeson = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS41.vICMSDeson;
                            // var motDesICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS41.motDesICMS;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS50 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS50.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS50.CST;
                            //  var vICMSDeson = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS50.vICMSDeson;
                            //  var motDesICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS50.motDesICMS;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS51 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS51.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS51.CST;
                            var modBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS51.modBC;
                            var pRedBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS51.pRedBC;
                            var vBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS51.vBC;
                            var pICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS51.pICMS;
                            var vICMSOp = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS51.vICMSOp;
                            var pDif = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS51.pDif;
                            var vICMSDif = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS51.vICMSDif;
                            var vICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS51.vICMS;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS60 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS60.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS60.CST;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS70 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS70.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS70.CST;
                            var modBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS70.modBC;
                            var pRedBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS70.pRedBC;
                            var vBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS70.vBC;
                            var pICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS70.pICMS;
                            var vICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS70.vICMS;
                            var modBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS70.modBCST;
                            var pMVAST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS70.pMVAST;
                            var pRedBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS70.pRedBCST;
                            var vBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS70.vBCST;
                            var pICMSST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS70.pICMSST;
                            var vICMSST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS70.vICMSST;
                            var vICMSDeson = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS70.vICMSDeson;
                            var motDesICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS70.motDesICMS;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS90 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS90.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS90.CST;
                            var modBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS90.modBC;
                            var vBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS90.vBC;
                            var pICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS90.pICMS;
                            var vICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMS90.vICMS;

                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN101 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN101.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN101.CSOSN;
                            var pCredSN = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN101.pCredSN;
                            var vCredICMSSN = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN101.vCredICMSSN;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN102 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN102.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN102.CSOSN;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN201 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN201.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN201.CSOSN;
                            var modBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN201.modBCST;
                            var pMVAST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN201.pMVAST;
                            var pRedBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN201.pRedBCST;
                            var vBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN201.vBCST;
                            var pICMSST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN201.pICMSST;
                            var vICMSST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN201.vICMSST;
                            var pCredSN = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN201.pCredSN;
                            var vCredICMSSN = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN201.vCredICMSSN;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN202 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN202.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN202.CSOSN;
                            var modBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN202.modBCST;
                            var pMVAST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN202.pMVAST;
                            var pRedBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN202.pRedBCST;
                            var vBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN202.vBCST;
                            var pICMSST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN202.pICMSST;
                            var vICMSST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN202.vICMSST;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN500 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN500.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN500.CSOSN;
                            var vBCSTRet = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN500.vBCSTRet;
                            var vICMSSTRet = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN500.vICMSSTRet;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN900 != undefined) {
                            var orig = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN900.orig;
                            var CST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN900.CSOSN;
                            var modBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN900.modBC;
                            var vBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN900.vBC;
                            var pRedBC = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN900.pRedBC;
                            var pICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN900.pICMS;
                            var vICMS = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN900.vICMS;
                            var modBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN900.modBCST;
                            var pMVAST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN900.pMVAST;
                            var pRedBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN900.pRedBCST;
                            var vBCST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN900.vBCST;
                            var pICMSST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN900.pICMSST;
                            var vICMSST = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN900.vICMSST;
                            var vBCSTRet = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN900.vBCSTRet;
                            var vICMSSTRet = data.nfeProc.NFe.infNFe.det[i].imposto.ICMS.ICMSSN900.vICMSSTRet;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.IPI != undefined) {
                            var clEnq = data.nfeProc.NFe.infNFe.det[i].imposto.IPI.clEnq;
                            var CNPJProd = data.nfeProc.NFe.infNFe.det[i].imposto.IPI.CNPJProd;
                            var cSelo = data.nfeProc.NFe.infNFe.det[i].imposto.IPI.cSelo;
                            var qSelo = data.nfeProc.NFe.infNFe.det[i].imposto.IPI.qSelo;
                            var cEnq = data.nfeProc.NFe.infNFe.det[i].imposto.IPI.cEnq;
                            if (data.nfeProc.NFe.infNFe.det[i].imposto.IPI.IPITrib != undefined) {
                                var CSTIPI = data.nfeProc.NFe.infNFe.det[i].imposto.IPI.IPITrib.CST;
                                var vBCIPI = data.nfeProc.NFe.infNFe.det[i].imposto.IPI.IPITrib.vBC;
                                var pIPI = data.nfeProc.NFe.infNFe.det[i].imposto.IPI.IPITrib.pIPI;
                                var qUnidIPI = data.nfeProc.NFe.infNFe.det[i].imposto.IPI.IPITrib.qUnid;
                                var vUnidIPI = data.nfeProc.NFe.infNFe.det[i].imposto.IPI.IPITrib.vUnid;
                                var vIPI = data.nfeProc.NFe.infNFe.det[i].imposto.IPI.IPITrib.vIPI;
                            }

                            if (data.nfeProc.NFe.infNFe.det[i].imposto.IPI.IPINT != undefined) {
                                var CSTIPI = data.nfeProc.NFe.infNFe.det[i].imposto.IPI.IPINT.CST;
                            }

                        }


                        if (data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISAliq != undefined) {
                            var CSTPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISAliq.CST;
                            var vBCPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISAliq.vBC;
                            var pPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISAliq.pPIS;
                            var vPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISAliq.vPIS;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISQtde != undefined) {
                            var CSTPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISQtde.CST;
                            var qBCProdPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISQtde.qBCProd;
                            var AliqProdPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISQtde.AliqProd;
                            var vPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISQtde.vPIS;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISNT != undefined) {
                            var CSTPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISNT.CST;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISOutr != undefined) {
                            var CSTPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISOutr.CST;
                            var vPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISOutr.vPIS;
                            var qBCProdPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISOutr.qBCProd;
                            var vAliqProdPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISOutr.vAliqProd;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISST != undefined) {
                            var vBCPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISST.vBC;
                            var pPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISST.pPIS;
                            var qBCProdPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISST.qBCProd;
                            var AliqProdPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISST.AliqProd;
                            var vPIS = data.nfeProc.NFe.infNFe.det[i].imposto.PIS.PISST.vPIS;
                        }


                        if (data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSAliq != undefined) {
                            var CSTCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSAliq.CST;
                            var vBCCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSAliq.vBC;
                            var pCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSAliq.pCOFINS;
                            var vCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSAliq.vCOFINS;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSQtde != undefined) {
                            var CSTCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSQtde.CST;
                            var qBCProdCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSQtde.qBCProd;
                            var AliqProdCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSQtde.AliqProd;
                            var vCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSQtde.vCOFINS;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSNT != undefined) {
                            var CSTCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSNT.CST;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSOutr != undefined) {
                            var CSTCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSOutr.CST;
                            var vCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSOutr.vCOFINS;
                            var qBCProdCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSOutr.qBCProd;
                            var vAliqProdCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSOutr.vAliqProd;
                        }

                        if (data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSST != undefined) {
                            var vBCCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSST.vBC;
                            var pCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSST.pCOFINS;
                            var qBCProdCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSST.qBCProd;
                            var AliqProdCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSST.AliqProd;
                            var vCOFINS = data.nfeProc.NFe.infNFe.det[i].imposto.COFINS.COFINSST.vCOFINS;
                        }
                    }

                    // console.log(entnfeidn);
                    // alert(entnfeid);
                    $.ajax({
                        type: "POST",
                        url: "<?= BACKEND ?>/_controller/_insert/importa_prod_entnfe_insert.php",
                        data: {
                            entnfe: entnfeidn,
                            CFOP: CFOP,
                            cProd: cProd,
                            NCM: NCM,
                            xProd: xProd.replace(/[^a-z0-9\s]/gi, '').replace(/[_\s]/g, ' '),
                            uCom: uCom,
                            qtd: qtd,
                            vProd: vProd,
                            valortotal: valortotal,
                            orig: orig,
                            CST: CST,
                            modBC: modBC,
                            vBC: vBC,
                            pICMS: pICMS,
                            vICMS: vICMS,
                            modBCST: modBCST,
                            pMVAST: pMVAST,
                            pRedBCST: pRedBCST,
                            vBCST: vBCST,
                            pICMSST: pICMSST,
                            vICMSST: vICMSST,
                            vICMSDeson: vICMSDeson,
                            motDesICMS: motDesICMS,
                            vICMSOp: vICMSOp,
                            pDif: pDif,
                            vICMSDif: vICMSDif,
                            pCredSN: pCredSN,
                            vCredICMSSN: vCredICMSSN,
                            vBCSTRet: vBCSTRet,
                            vICMSSTRet: vICMSSTRet,
                            clEnq: clEnq,
                            CNPJProd: CNPJProd,
                            cSelo: cSelo,
                            qSelo: qSelo,
                            cEnq: cEnq,
                            CSTIPI: CSTIPI,
                            vBCIPI: vBCIPI,
                            pIPI: pIPI,
                            qUnidIPI: qUnidIPI,
                            vUnidIPI: vUnidIPI,
                            vIPI: vIPI,
                            CSTPIS: CSTPIS,
                            vBCPIS: vBCPIS,
                            pPIS: pPIS,
                            vPIS: vPIS,
                            qBCProdPIS: qBCProdPIS,
                            AliqProdPIS: AliqProdPIS,
                            CSTCOFINS: CSTCOFINS,
                            vBCCOFINS: vBCCOFINS,
                            pCOFINS: pCOFINS,
                            vCOFINS: vCOFINS,
                            qBCProdCOFINS: qBCProdCOFINS,
                            AliqProdCOFINS: AliqProdCOFINS,
                            fornecedor: Fornecedor,
                            destxNome: destxNome,
                            destfone: destfone,
                            destemail: destemail,
                            destIE: destIE,
                            destCEP: destCEP,
                            destxLgr: destxLgr,
                            destnro: destnro,
                            destxBairro: destxBairro,
                            destxMun: destxMun,
                            destcMun: destcMun,
                            destUF: destUF

                        },
                        cache: false,
                        success: function() {
                            CarregaProdNFeImp(entnfeidn);
                        }
                    });
                    // var imposto = JSON.stringify(data.nfeProc.NFe.infNFe.det[i].imposto.ICMS);
                    // console.log(imposto);
                    // impostos
                });

                $.each(data.nfeProc.NFe.infNFe.cobr.dup, function(i, dup) {

                    var nFat = data.nfeProc.NFe.infNFe.cobr.fat.nFat;

                    if (data.nfeProc.NFe.infNFe.cobr.dup.nDup != undefined) {
                        var nDup = data.nfeProc.NFe.infNFe.cobr.dup.nDup;
                        var dVenc = data.nfeProc.NFe.infNFe.cobr.dup.dVenc;
                        var vDup = data.nfeProc.NFe.infNFe.cobr.dup.vDup;
                        $.ajax({
                            type: "POST",
                            url: "<?= BACKEND ?>/_controller/_insert/duplicata_importacao_insert.php",
                            data: {
                                nfe: entnfeidn,
                                parcela: nDup,
                                vencimento: dVenc,
                                dataemissao: dataemissao,
                                valor: vDup,
                                duplicata: nFat,
                                destCNPJ: Fornecedor

                            },
                            cache: false,
                            success: function() {
                                CarregaDuplicata();
                            }
                        });
                    } else {
                        var nDup = data.nfeProc.NFe.infNFe.cobr.dup[i].nDup;
                        var dVenc = data.nfeProc.NFe.infNFe.cobr.dup[i].dVenc;
                        var vDup = data.nfeProc.NFe.infNFe.cobr.dup[i].vDup;

                        $.ajax({
                            type: "POST",
                            url: "<?= BACKEND ?>/_controller/_insert/duplicata_importacao_insert.php",
                            data: {
                                nfe: entnfeidn,
                                parcela: nDup,
                                vencimento: dVenc,
                                dataemissao: dataemissao,
                                valor: vDup,
                                duplicata: nFat,
                                destCNPJ: Fornecedor

                            },
                            cache: false,
                            success: function() {
                                CarregaDuplicata();
                            }
                        });
                    }

                });


                $("#Import").modal('hide');
                // alert("importado!");
            }
        });
    }

    function Import() {
        $("#Import").modal('show');
        $("#tituloGrid").html('IMPORTAR XML');
    }
</script>

<script>
    $(document).ready(function() {
        // bind form using ajaxForm 
        $('#nfeform').ajaxForm({
            // dataType identifies the expected content type of the server response 
            dataType: 'json',
            // success identifies the function to invoke when the server response 
            // has been received 
            success: processJson
        });
    });

    function processJson(data) {
        if (data.retorno == true) {
            Carrega('_grid', 'nfe_entrada_grid.php', 'Nota Fiscal Entrada');
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html(data.mensagem);
            setTimeout(function() {
                $("#alertsucesso").css("display", "none");
            }, 2000);
        } else {
            document.getElementById("alertsucesso").style.display = "none";
            document.getElementById("alerterro").style.display = "block";
            $("#erro").html(data.mensagem);
            setTimeout(function() {
                $("#alerterro").css("display", "none");
            }, 2000);
        }
    }
</script>