<?php
require_once("../../../functions.php");
require_once("../_modal/_modal.php");
require_once("../../_class/Conexao_class.php");
require_once("../../_class/Crud_class.php");
?>
<style>
    label {
        font-size: 12px;
    }
    .fileUpload {
        position: relative;
        overflow: hidden;
        margin: 0px;
    }
    .fileUpload input.upload {
        position: absolute;
        top: 0;
        right: 0;
        margin: 0;
        padding: 0;
        font-size: 20px;
        cursor: pointer;
        opacity: 0;
        filter: alpha(opacity=0);
    }
</style>
<script>

    $("#arquivo").on('change', function () {

        if (typeof (FileReader) != "undefined") {

            var image_holder = $("#image-holder");
            image_holder.empty();

            var reader = new FileReader();
            reader.onload = function (e) {
                $("<img />", {
                    "src": e.target.result,
                    "class": "thumb-image",
                    "width": '100%'
                }).appendTo(image_holder);
            }
            image_holder.show();
            reader.readAsDataURL($(this)[0].files[0]);
        } else {
            alert("Este navegador nao suporta FileReader.");
        }
    });

    function Arquivo(valor) {
        if (verificaExtensaoArquivoJPG(valor)) {
//            $("#uploadFile").html(valor);
        } else {
            $("#uploadFile").html('');
            $("#arquivo").val('');
        }
    }



    function Arquivocert(valor) {
        if (verificaExtensaoArquivo(valor)) {
            $("#certificado").html(valor);
        } else {
            $("#arquivocert").val('');
            $("#certificado").html('Buscar Certificado');

        }
    }


    function ArquivocertPrivate(valor) {
        if (verificaExtensaoArquivoPem(valor)) {
            $("#certificadoprivate").html(valor);
        } else {
            $("#arquivocertprivate").val('');
            $("#certificadoprivate").html('Certificado Privado');

        }
    }


    function ArquivocertPublic(valor) {
        if (verificaExtensaoArquivoPem(valor)) {
            $("#certificadopublic").html(valor);
        } else {
            $("#arquivocertpublic").val('');
            $("#certificadopublic").html('Certificado Publico');

        }
    }



    function BuscaCNPJ(CNPJ) {
//        alert(CNPJ);
        $.ajax({
            type: "GET",
            url: "https://www.receitaws.com.br/v1/cnpj/" + CNPJ,
            dataType: "jsonp",
            // função para de sucesso
            success: function (data) {
                //  alert();
                if (data != null) {
                    $("input[name='xNome']").val(data.nome);
                    if (data.fantasia == '') {
                        $("input[name='xFant']").val(data.nome);
                    } else {
                        $("input[name='xFant']").val(data.fantasia);
                    }
                    var cep = data.cep.replace(/[^\d]+/g, '');
                    $("input[name='CEP']").val(cep);
                    BuscaCep(cep, '');
                    $("input[name='nro']").val(data.numero);
                    $("input[name='xCpl']").val(data.complemento);
                    var cnae = data.atividade_principal[0].code.replace(/[^\d]+/g, '');
                    $("input[name='CNAE']").val(cnae);

//                    alert(data.atividade_principal[0].code);
                }
            }
        }); //termina o jquery

    }



    function verificaExtensaoArquivo(arquivo) {
        extensoes_permitidas = new Array(".pfx");
        extensao = (arquivo.substring(arquivo.lastIndexOf("."))).toLowerCase();
        permite = false;
        $(extensoes_permitidas).each(function (i) {
            if (extensoes_permitidas[i] == extensao) {
                permite = true;
                return false;
            }

        });
        if (!permite) {
            alert("SOMENTE É ACEITO CERTIFICADO A1 (*.PFX)!");
            return false;
        }
        return true;
    }

    function verificaExtensaoArquivoPem(arquivo) {
        extensoes_permitidas = new Array(".pem");
        extensao = (arquivo.substring(arquivo.lastIndexOf("."))).toLowerCase();
        permite = false;
        $(extensoes_permitidas).each(function (i) {
            if (extensoes_permitidas[i] == extensao) {
                permite = true;
                return false;
            }

        });
        if (!permite) {
            alert("SOMENTE É ACEITO CERTIFICADO (*.PEM)!");
            return false;
        }
        return true;
    }

    function verificaExtensaoArquivoJPG(arquivo) {
        extensoes_permitidas = new Array(".jpg");
        extensao = (arquivo.substring(arquivo.lastIndexOf("."))).toLowerCase();
        permite = false;
        $(extensoes_permitidas).each(function (i) {
            if (extensoes_permitidas[i] == extensao) {
                permite = true;
                return false;
            }

        });
        if (!permite) {
            alert("SOMENTE É ACEITO IMAGEM, (.jpg)");
            return false;
        }
        return true;
    }

    function Busca(valor) {
        $("#busca").modal('show');
        $("#buscatitle").html('BUSCA ' + valor.toUpperCase());
        $("#carregandobusca").css("display", "block");
        $("#recebegrid").load('_backend/_view/_grid/' + valor + '_grid.php?busca=S', function () {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }

    function CFOP(valor) {
//        alert(valor);
        $("#cfop").val(valor);
        $("#busca").modal('hide');
    }

</script>

<?php
if (isset($_GET['editar'])) :
    $editar = $_GET['editar'];

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'emitente');
    $sql = "SELECT * from emitente WHERE emitenteid = $editar";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    $cerprivate = $dados->certprivate;
    $cerpublic = $dados->certpublic;
//    print_r($dados);

    $action = "" . BACKEND . "/_controller/_update/emitente_update.php";
    ?>
    <script>
        $(document).ready(function () {

            //        alert(valor);
            $.ajax({
                type: "GET",
                url: "<?= BACKEND ?>/_controller/_select/_ajax/emitente_select_ajax.php?emitente=<?= $editar ?>",
                            dataType: "json",
                            // função para de sucesso
                            success: function (data) {
                                //  alert();
                                if (data != null) {

                                    $.each(data, function () {
                                        $.each(this, function (k, v) {
                                            $("input[name='" + k + "']").val(v);
                                            $("select[name='" + k + "']").val(v);
                                            $("textarea[name='" + k + "']").val(v);
                                            console.log(k + "=>" + v);
                                        });
                                    });

                                }
                            }
                        }); //termina o jquery

                    });

    </script>

    <?php
else :
    $action = "" . BACKEND . "/_controller/_insert/emitente_insert.php";
endif;
?>
<form id="emitente" enctype="multipart/form-data" action="<?= $action ?>" method="POST">

    <div class="row">
        <div class="col-md-12">
            <ul class="nav nav-tabs " role="tablist">
                <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab" data-toggle="tab">Dados Gerais</a></li>
                <li role="presentation"><a href="#tributacao" aria-controls="tributacao" role="tab" data-toggle="tab">Tributação</a></li>
                <li role="presentation"><a href="#logomarca" aria-controls="logomarca" role="tab" data-toggle="tab">Logomarca</a></li>
                <li role="presentation"><a href="#certificadoa" aria-controls="certificadoa" role="tab" data-toggle="tab">Certificado</a></li>
                <li role="presentation"><a href="#boleto" aria-controls="boleto" role="tab" data-toggle="tab">Boleto</a></li>
                <li role="presentation"><a href="#ecommerce" aria-controls="ecommerce" role="tab" data-toggle="tab">E-commerce</a></li>
                <li role="presentation"><a href="#outros" aria-controls="outros" role="tab" data-toggle="tab">Outros</a></li>
                <li role="presentation"><a href="#pix" aria-controls="pix" role="tab" data-toggle="tab">Pix</a></li>
                <li role="presentation"><a href="#contabilidade" aria-controls="contabilidade" role="tab" data-toggle="tab">Contabilidade</a></li>
                <li role="presentation"><a href="#financeiro" aria-controls="financeiro" role="tab" data-toggle="tab">Financeiro</a></li>
            </ul>
     <!--<section class="panel">-->
            <div class="tab-content">
                <input type="hidden" name="emitenteid">

                <div role="tabpanel" class="tab-pane active" id="home">
                    <div class="row">
                        <div class="col-md-4">
                            <label>CNPJ <span class="text-danger">*</span></label>
                            <input name="CNPJ" 
                                   onblur="BuscaCNPJ(this.value);"  maxlength="14" type="text" required="" class="form-control" placeholder=""> 

                        </div>

                        <div class="col-md-4">
                            <label>Insc. Estadual</label>
                            <input name="IE" type="text" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-4">
                            <label>Insc. ST </label>
                            <input name="IEST" type="text" class="form-control" placeholder=""> 
                        </div>
                    </div>

                    <div class="row">

                        <div class="col-md-4">
                            <label>Insc. Mun. </label>
                            <input name="IEMN" type="text" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-8">
                            <label>Razao Social <span class="text-danger">*</span></label>
                            <input name="xNome" type="text" maxlength="60" required=""  class="form-control" placeholder=""> 
                        </div>

                    </div>

                    <div class="row">

                        <div class="col-md-8">
                            <label>Nome Fantasia <span class="text-danger">*</span></label>
                            <input name="xFant" type="text" maxlength="60" required="" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-4">
                            <label>CNAE </label>
                            <input name="CNAE" type="text" class="form-control" placeholder=""> 
                        </div>

                    </div>


                    <div class="row">
                        <div class="col-md-3">
                            <label>CEP <span class="text-danger">*</span></label>
                            <input name="CEP" id="CEP" onchange="BuscaCep(this.value, '')" type="text" maxlength="8" required="" class="form-control" placeholder=""> 
                            <i style="position: absolute; right: 22px; top: 34px;" class="fa fa-search"> </i>
                        </div>

                        <div class="col-md-5">
                            <label>Logradouro <span class="text-danger">*</span></label>
                            <input name="xLgr" id="xLgr" type="text" minlength="2" maxlength="60" required="" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-2">
                            <label>Nº <span class="text-danger">*</span></label>
                            <input name="nro" id="nro" type="text" maxlength="60" required="" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-2">
                            <label>Com.</label>
                            <input name="xCpl" id="xCpl" type="text" maxlength="60"  class="form-control" placeholder=""> 
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <label>Bairro <span class="text-danger">*</span></label>
                            <input name="xBairro" id="xBairro" type="text" maxlength="60" minlength="2" required="" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-6">
                            <label>Município <span class="text-danger">*</span></label>
                            <input name="xMun" id="xMun" readonly="" type="text" minlength="2" maxlength="60" required="" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-2">
                            <label>UF <span class="text-danger">*</span></label>
                            <input name="UF" id="UF" readonly="" type="text" maxlength="2" required="" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-2">
                            <input name="cMun" id="cMun" readonly="" type="hidden" maxlength="7" required="" class="form-control" placeholder=""> 
                        </div>



                    </div>

                    <div class="row">

                        <div class="col-md-4">
                            <label>Fone</label>
                            <input name="fone" type="text" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-8">
                            <label>E-mail</label>
                            <input name="email" type="email" class="form-control" placeholder=""> 
                        </div>
                    </div>
                </div>

                <div role="tabpanel" class="tab-pane" id="tributacao">
                    <div class="row">

                        <div class="col-md-4">
                            <label>Regime Tributário </label>
                            <select name="regimetributario" class="form-control">
                                <option value="1">Simples Nacional </option>
                                <option value="2">Simples Nacional - Excesso Sublimite de Receita Bruta </option>
                                <option value="3">Regime Normal </option>
                                 <option value="4">Microempreendedor Individual (MEI) </option>
                            </select> 
                        </div>

                        <div class="col-md-6">
                            <label>CSC (NFC-e) <i class="fa fa-question-circle" title="CSC - Código de Segurança do Contribuinte, é obrigatório informar para quem deseja emitir NFC-e, é fornecido pela SEFAZ"> </i></label>
                            <input name="csc" value="<?= $dados->csc ?>" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-2">
                            <label>ID CSC</label>
                            <input name="idcsc" value="<?= $dados->idcsc ?>" type="text" class="form-control" placeholder=""> 
                        </div>
                    </div>

                    <div class="row">

                        <div class="col-md-3">
                            <label>Calculo IBPT </label>
                            <select name="ibpt" class="form-control">
                                <option value="1">Token </option>
                                <option value="2">Tabela IBPT </option>
                            </select> 
                        </div>

                        <div class="col-md-5">
                            <label>Token IBPT <a href="https://deolhonoimposto.ibpt.org.br" target="_blank"> <i class="fa fa-question-circle" title="https://deolhonoimposto.ibpt.org.br"> </i> </a></label>
                            <input name="tokenibpt" value="<?= $dados->tokenibpt ?>" type="text" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-2">
                            <label>Ambiente </label>
                            <select name="tpAmb" class="form-control">
                                <option value="2">Homologação </option>
                                <option value="1">Produção </option>
                            </select> 
                        </div> 

                        <div class="col-md-2">
                            <label>Emite NF-e Mov. </label>
                            <select name="emitenfe" class="form-control">
                                <option value="N">NÃO </option>
                                <option value="S">SIM </option>
                            </select> 
                        </div> 

                    </div>
                    <div class="row">


                        <div class="col-md-2">
                            <label>CFOP Saída</label>
                            <input name="cfop" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-2">
                            <label>CFOP Saída Fora</label>
                            <input name="cfopuf" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-2">
                            <label>CFOP Retorno</label>
                            <input name="cfopretorno" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-2">
                            <label>CFOP Retorno Fora</label>
                            <input name="cfopretornouf" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-2">
                            <label>CFOP Devolução</label>
                            <input name="cfopdevolucao" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-2">
                            <label>CFOP Devolução Fora</label>
                            <input name="cfopdevolucaouf" type="text" class="form-control" placeholder=""> 
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-2">
                            <label>CFOP Devolução</label>
                            <input name="cfopmanifesto" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-2">
                            <label>CFOP Devolução Fora</label>
                            <input name="cfopmanifestouf" type="text" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-2">
                            <label>Utilza mais Serie</label>
                            <select name="ativaserie" class="form-control">
                                <option value="S">Sim</option>
                                <option value="N">Não</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label>Serie Padrão</label>
                            <input name="seriepadrao" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-2">
                            <label>Serie Padrão NFce</label>
                            <input name="seriepadraonfce" type="text" class="form-control" placeholder=""> 
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-2">
                            <label> <i class="fa fa-info-circle" title="Nomenclatura Comum do Mercosul"></i>
                                NCM </label>
                            <input name="ncm" maxlength="8" type="text" value="" id="ncm" class="form-control" placeholder=""> 
                            <!--<i style="position: absolute; right: 22px; top: 34px; cursor: pointer;" onclick="Busca('ncm')" class="fa fa-search"> </i>-->

                        </div>

                        <div class="col-md-8">
                            <label> <i class="fa fa-info-circle" title="Código de Situação Tributária / Código de Situação da Operação no Simples Nacional"></i>
                                CST/CSOSN </label>
                            <?php
                            $pdo = Conexao::getInstance();

                            $crud = Crud::getInstance($pdo, 'icms');
                            $sql = "SELECT * FROM icms order by desc_icms DESC";
                            $arrayParam = '';
                            $dadosicms = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
                            ?>

                            <select required="" name="cst" class="form-control">
                                <?php
                                foreach ($dadosicms as $resultado) {
                                    echo '<option value="' . $resultado->codigo_icms . '"> ' . $resultado->desc_icms . ' </option>';
                                }
                                ?>
                            </select> 
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <label> Empresa Fiscal </label>
                            <?php
                            $pdo = Conexao::getInstance();

                            $crud = Crud::getInstance($pdo, 'icms');
                            $sql = "SELECT * FROM emitente";
                            $arrayParam = '';
                            $dadosicms = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
                            ?>

                            <select name="empresafiscal" class="form-control">
                                <?php
                                foreach ($dadosicms as $resultado) {
                                    echo '<option value="' . $resultado->emitenteid . '"> ' . $resultado->emitenteid . ' - ' . $resultado->xNome . ' - ' . $resultado->CNPJ . ' </option>';
                                }
                                ?>
                            </select> 
                        </div>
                    </div>
                </div>

                <div role="tabpanel" class="tab-pane" id="logomarca">
                    <div class="scroller" style="min-height:57px" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">
                        <div class="tab-content">

                            <div class="row">
                                <div class="col-md-2 tex-right" id="image-holder">
                                    <?php
                                    $logomarca = '' . DIR . '/_frontend/img/logomarca/' . $dados->CNPJ . '/' . $dados->logo;

                                    if (file_exists($logomarca)) :
                                        $logo = '' . FRONTEND . '/img/logomarca/' . $dados->CNPJ . '/' . $dados->logo;

                                    else :
                                        $logo = '' . FRONTEND . '/_layout/assets/images/logo.png';
                                    endif;
                                    ?>
                                    <img width="100%" src="<?= $logo ?>" alt=""/>
                                </div>

                                <div class="col-md-4">
                                    <b> Sugerido: 400x400px -  </b>
                                    <b class="text-danger"> Tamanho Máximo: 1MB</b>
                                    <div class="fileUpload btn btn-primary form-control">
                                        <span><i class="fa fa-upload"></i> Buscar Imagem</span>
                                        <input type="file" name="logo" id="arquivo" onchange="Arquivo(this.value);" class="upload form-control" />
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <div role="tabpanel" class="tab-pane" id="certificadoa">

                    <div class="row">
                        <div class="col-md-3">
                            <img src="<?= FRONTEND ?>/img/certificado.png" style="max-height: 120px;" alt=""/>
                        </div>
                        <div class="col-md-5">
                            <?php
                            if ($dados->cert != '') :
error_reporting(E_ALL);
ini_set('display_errors', 'On');
                                $file = '' . DIR . '/_fiscal/_nfe/console/' . $dados->CNPJ . '/' . $dados->cert . '';
                                $dow = ''.LINK.'/_fiscal/_nfe/console/' . $dados->CNPJ . '/' . $dados->cert . '';
                                //echo $file;
                                $certs = array();
                                $pkcs12 = file_get_contents($file);
                                

                                if (openssl_pkcs12_read($pkcs12, $certs, trim($dados->certsenha))) :
                                    $certificado = array();
                                    $certificado = openssl_x509_parse(openssl_x509_read($certs['cert']));
                                    echo '<br/>';
                                    echo '<b>Emitido Para </b><br/>' . $certificado['subject']['CN'] . '<br>'; //Razão Social e CNPJ / CPF
                                    echo '<b>Validade </b><br/>' . date('d/m/Y', $certificado['validTo_time_t']) . '<br>'; //Validade	
//                                            echo $dados['extensions']['subjectAltName'] . '<br>'; //Emails Cadastrados separado por ,
                                
                                else :
                                  $error = error_get_last();
    echo "Erro ao processar o PFX: " . $error['message'] . "\n";

    // Exibe todos os erros capturados pelo OpenSSL
    while ($e = openssl_error_string()) {
        echo "Erro OpenSSL: " . $e . "\n";
    }
                                
                                endif;
                            else :
                                echo '<h4> Sem Certificado. </h4>';
                            endif;
                            ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <div class="fileUpload btn btn-primary form-control">
                                
                                <span><i class="fa fa-upload"></i> <span id="certificado">Buscar Certificado</span></span>
                                <input type="file" name="cert" id="arquivocert" onchange="Arquivocert(this.value);" class="upload form-control" />
                               
                            </div><br/><br/>
                             <a href="<?= $dow ?>" class="btn btn-success form-control"><i class="fa fa-save"> </i> Baixar Certificado</a>
                        </div>

                        <div class="col-md-5">
                            <input name="certsenha" value="" autocomplete="off" type="text" class="form-control" placeholder="Senha"> 
                        </div>

                    </div>
                </div>


                <div role="tabpanel" class="tab-pane" id="ecommerce">
                    <div class="row">
                        <div class="col-md-3">
                            <label>Ativa E-commerce </label>
                            <select name="ativaecommerce" class="form-control">
                                <option value="N">NÃO </option>
                                <option value="S">SIM </option>
                            </select> 
                        </div> 

                        <div class="col-md-3">
                            <label>Sincronização Automática</label>
                            <select name="sinauto" class="form-control">
                                <option value="N">NÃO </option>
                                <option value="S">SIM </option>
                            </select> 
                        </div> 

                        <div class="col-md-3">
                            <label>Plataforma </label>
                            <select name="plataforma" class="form-control">
                                <option value="nuvemshop">Nuvem Shop </option>
                                <option value="lojaintegrada">Loja Integrada </option>
                                <option value="shoppub">ShopPub </option>
                            </select> 
                        </div> 

                        <div class="col-md-3">
                            <label>Tabela Preço </label>
                            <select name="tbecommerce" class="form-control">
                                <?php
                                $pdo = Conexao::getInstance();
                                $crud = Crud::getInstance($pdo, 'tabelapreco');
                                $sql = "SELECT * from tabelapreco";
                                $arrayParam = '';
                                $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
                                foreach ($dados as $dados) :
                                    ?>
                                    <option value="<?= $dados->tabelaprecoid ?>"><?= $dados->descricao ?></option>
                                    <?php
                                endforeach;
                                ?>
                            </select>

                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <label>Access Token </label>
                            <input type="text" class="form-control" name="access_token">
                        </div>

                        <div class="col-md-3">
                            <label>User ID </label>
                            <input type="text" class="form-control" name="user_id">
                        </div>

                        <div class="col-md-3">
                            <label>Vendedor Padrão </label>
                            <select name="vendedointegracao" class="form-control">
                                <?php
                                $pdo = Conexao::getInstance();
                                $crud = Crud::getInstance($pdo, 'vendedor');
                                $sql = "SELECT * from vendedor";
                                $arrayParam = '';
                                $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
                                foreach ($dados as $dados) :
                                    ?>
                                    <option value="<?= $dados->vendedorid ?>"><?= $dados->vendedorid ?> - <?= $dados->xNome ?></option>
                                    <?php
                                endforeach;
                                ?>
                            </select>

                        </div>

                    </div>

                </div>

                <div role="tabpanel" class="tab-pane" id="boleto">
                    <div class="row">
                        <div class="col-md-3">
                            <label>Emite Boleto </label>
                            <select name="emiteboleto" class="form-control">
                                <option value="N">NÃO </option>
                                <option value="S">SIM </option>
                            </select> 
                        </div> 

                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <label>Banco <span class="text-danger">*</span></label>
                            <select name="banco" class="form-control">
                                <option value="itau">Itaú</option>
                                <option value="sicoob">Sicoob</option>
                                <option value="bb">Banco do Brasil</option>
                                <option value="santander">Santander</option>
                            </select>

                        </div>

                        <div class="col-md-3">
                            <label>Cód. cliente</label>
                            <input name="codigocliente" type="text" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-3">
                            <label>Nosso Numero </label>
                            <input name="numerodocumento" type="text" class="form-control" placeholder=""> 
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <label>Agência  <span class="text-danger">*</span></label>
                            <input name="agencia" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-1">
                            <label>Dv Agên.  <span class="text-danger">*</span></label>
                            <input name="digagencia" type="text" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-3">
                            <label>Conta  <span class="text-danger">*</span></label>
                            <input name="conta" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-1">
                            <label>Dv Conta  <span class="text-danger">*</span></label>
                            <input name="digconta" type="text" class="form-control" placeholder=""> 
                        </div>




                        <div class="col-md-2">
                            <label>Carteira <span class="text-danger">*</span></label>
                            <input name="carteira" type="text" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-2">
                            <label>Convênio </label>
                            <input name="convenio" type="text" class="form-control" placeholder=""> 
                        </div>

                    </div>


                    <div class="row">

                        <div class="col-md-6">
                            <label>Instrução</label>
                            <input name="instrucoes1" type="text" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-6">
                            <label>Instrução</label>
                            <input name="instrucoes2" type="text" class="form-control" placeholder=""> 
                        </div>
                    </div>
                    <div class="row">

                        <div class="col-md-6">
                            <label>Instrução</label>
                            <input name="instrucoes3" type="text" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-6">
                            <label>Instrução</label>
                            <input name="instrucoes4" type="text" class="form-control" placeholder=""> 
                        </div>
                    </div>

                </div>


                <div role="tabpanel" class="tab-pane" id="outros">
                    <div class="row">
                        <div class="col-md-12">
                            <label>Mensagem aniversário</label>
                            <textarea name="msganiversario" class="form-control"></textarea>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <label>Mensagem pós venda</label>
                            <textarea name="msgposvenda" class="form-control"></textarea>
                        </div>
                    </div>
                </div>

                <div role="tabpanel" class="tab-pane" id="pix">
                    <div class="row">
                        <div class="col-md-2">
                            <label>Ativo</label>
                            <select name="ativapix" class="form-control"> 
                                <option value="N">Não</option>
                                <option value="S">Sim</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label>Banco</label>
                            <select name="bancopix" class="form-control"> 
                                <option value="mp">Mercado Pago</option>
                                <option value="sb">Sicoob</option>
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label>Token</label>
                            <input name="tokenpix" type="text" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-4">
                            <label>Cliente Key</label>
                            <input name="keypix" type="text" class="form-control" placeholder=""> 
                        </div>
                    </div>     

                    <div class="row">

                        <div class="col-md-4">
                            <label>Chave PIX</label>
                            <input name="chave_pix" type="text" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-4">
                            <label>Titular</label>
                            <input name="titular_pix" type="text" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-4">
                            <label>Localidade</label>
                            <input name="loctitular_pix" type="text" class="form-control" placeholder=""> 
                        </div>
                    </div>     

                    <br/>
                    <div class="row">
                        <div class="col-md-3">
                            <label>
                                <?php
                                if ($cerprivate != '') :
                                    echo $cerprivate;
                                endif;
                                ?>
                            </label>
                            <div class="fileUpload btn btn-primary form-control">
                                <span><i class="fa fa-upload"></i> <span id="certificadoprivate">Certificado Privado</span></span>
                                <input type="file" name="certprivate" onchange="ArquivocertPrivate(this.value);" id="arquivocertprivate" class="upload form-control" />
                            </div>
                        </div>
                        <div class="col-md-3">
                            <label>
                                <?php
                                if ($cerpublic != '') :
                                    echo $cerpublic;
                                endif;
                                ?>
                            </label>
                            <div class="fileUpload btn btn-primary form-control">
                                <span><i class="fa fa-upload"></i> <span id="certificadopublic">Certificado Publico</span></span>
                                <input type="file" name="certpublic" onchange="ArquivocertPublic(this.value);" id="arquivocertpublic" class="upload form-control" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <label>Senha</label>
                            <input name="senhacertprivate" type="password" class="form-control" placeholder=""> 
                        </div>
                    </div>

                </div>

                <div role="tabpanel" class="tab-pane" id="contabilidade">
                    <div class="row">

                        <div class="col-md-7">
                            <label>Nome </label>
                            <input name="contabilidade_xNome" type="text" maxlength="60"  class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-3">
                            <label>CPF/CNPJ</label>
                            <input name="contabilidade_CNPJ"  maxlength="14" type="text" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-2">
                            <label>CRC</label>
                            <input name="contabilidade_CRC" type="text" maxlength="60" class="form-control" placeholder=""> 
                        </div>

                    </div>


                    <div class="row">
                        <div class="col-md-3">
                            <label>CEP </label>
                            <input name="contabilidade_CEP" id="contabilidade_CEP" onchange="BuscaCep(this.value, 'contabilidade_')" type="text" maxlength="8" class="form-control" placeholder=""> 
                            <i style="position: absolute; right: 22px; top: 34px;" class="fa fa-search"> </i>
                        </div>

                        <div class="col-md-5">
                            <label>Logradouro </label>
                            <input name="contabilidade_xLgr" id="contabilidade_xLgr" type="text" minlength="2" maxlength="60"  class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-2">
                            <label>Nº </label>
                            <input name="contabilidade_num" id="contabilidade_nro" type="text" maxlength="60" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-2">
                            <label>Com.</label>
                            <input name="contabilidade_xCpl" id="contabilidade_xCpl" type="text" maxlength="60"  class="form-control" placeholder=""> 
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <label>Bairro </label>
                            <input name="contabilidade_xBairro" id="contabilidade_xBairro" type="text" maxlength="60" minlength="2"  class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-2">
                            <label>Cód. Mun </label>
                            <input name="contabilidade_cMun" id="contabilidade_cMun" type="text" maxlength="7" class="form-control" placeholder=""> 
                        </div>

                    </div>

                    <div class="row">

                        <div class="col-md-4">
                            <label>Fone</label>
                            <input name="contabilidade_Fone" type="text" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-8">
                            <label>E-mail</label>
                            <input name="contabilidade_email" type="email" class="form-control" placeholder=""> 
                        </div>
                    </div>

                </div>

                <div role="tabpanel" class="tab-pane" id="financeiro">
                    <div class="row">

                        <div class="col-md-3">
                            <label>Juros </label>
                            <input name="juros" type="text" maxlength="60" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-3">
                            <label>Carência (dias)</label>
                            <input name="carencia" type="text" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-3">
                            <label>Multa</label>
                            <input name="multa" type="text" maxlength="60" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-3">
                            <label>Carência (dias)</label>
                            <input name="carenciamulta" type="text" class="form-control" placeholder=""> 
                        </div>


                    </div>
                </div>
            </div>
            <div class="panel-footer">
                <div class="row">
                    <div class="col-md-12 text-right">
                        <a href="#" onclick="Carrega('_grid', 'cliente_grid.php', 'CLIENTES')" class="btn btn-warning"> <i class="fa fa-close"></i> Cancelar </a>
                        <button type="submit" class="btn btn-success"> <i class="fa fa-save"></i> Salvar </button>
                    </div>
                </div>

            </div>
        </div>
    </div>
</form>

<script>
    $(document).ready(function () {
        // bind form using ajaxForm 
        $('#emitente').ajaxForm({
            // dataType identifies the expected content type of the server response 
            dataType: 'json',
            // success identifies the function to invoke when the server response 
            // has been received 
            success: processJson,
            error: function (jqXHR, textStatus, errorThrown) {
                //                alert('erro');
                if (jqXHR.responseText) {

                    var str = jqXHR.responseText;
                    var retorno = jQuery.parseJSON(str.substr(3));

                    if (retorno.retorno == true) {
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html(retorno.mensagem);
                        Carrega('_grid', 'emitente_grid.php', 'Emitente');
                        setTimeout(function () {
                            $("#alertsucesso").css("display", "none");
                        }, 4000);
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html(retorno.mensagem);
                        setTimeout(function () {
                            $("#alerterro").css("display", "none");
                        }, 4000);

                    }

                }

            }
        });
    });

    function processJson(data) {
        if (data.retorno == true) {
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html(data.mensagem);
            $('#iemitente').modal('hide');
            Carrega('_grid', 'emitente_grid.php', 'Emitente');
            setTimeout(function () {
                $("#alertsucesso").css("display", "none");
            }, 4000);
        } else {
            alert(data.mensagem);
            document.getElementById("alertsucesso").style.display = "none";
            document.getElementById("alerterro").style.display = "block";
            $("#erro").html(data.mensagem);
            setTimeout(function () {
                $("#alerterro").css("display", "none");
            }, 4000);
        }
    }
</script>