<?php
date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
require_once("../../_class/Conexao_class.php");
require_once("../../_class/Crud_class.php");
require_once("../../_class/Emitente_class.php");
require_once "../../_class/cobranca_class.php";
require_once "../../_class/parametros.php";
?>

<script>

    function CriaCotacao() {
        $.ajax({
            type: "POST",
            url: "_backend/_controller/_insert/cotacao_insert.php",
            data: {
                produto: $("#data").val(),
                descricao: $("#descricao").val(),
            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
                if (data.retorno == true) {
                    toastr.success(data.mensagem);
                    $("#id").val(data.id);
                } else {
                    toastr.warning(data.mensagem);
                }
            }
        });
    }//termina o jquery

    function BuscaProdCotacao() {
        if ($("#codigo").val() === '') {
            Busca('grade_produtos');
            return false;
        }
        //                        alert("buscaproduto");
        $.ajax({
            type: "GET",
            url: "_backend/_controller/_select/_ajax/frentecaixa/produtos_mov_select_ajax.php", data: {
                produto: $("#codigo").val(),
                tbpreco: $("#tbpreco").val(),
                qtd: '1',
                tipo: 'Entrada'
            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                if (data.retorno == true) {
                    //                    alert(data[0].xNome);
                    $("#codigo").val(data.produto);
                    $("#descproduto").val(data.descricao);
                } else {
                    $("#codigo").focus();
                }
            }
        }); //termina o jquery
    }

    function Fornecedor(valor) {
        if (valor === '') {
            return false;
        }

        $.ajax({
            url: "<?= BACKEND ?>/_controller/_select/_ajax/fornecedor_select_ajax.php?fornecedor=" + valor,
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
                if (data[0] != undefined) {
                    $("#fornecedorid").val(data[0].fornecedorid);
                    $("#nomefornecedor").val(data[0].xNome);
//                    $("#chequesemissor").val(data[0].xNome);
//                    $("#chequesdoc").val(data[0].CNPJ);
                } else {
                    toastr.warning('Nenhum Registo Encontrado!');
                    $("#fornecedorid").val('');
                    $("#nomefornecedor").val('');
//                    $("#chequesemissor").val('');
//                    $("#chequesdoc").val('');
                }
            }
        }); //termina o jquery

        $("#buscaostabs").modal('hide');
        $("#tudo").hide();
    }


    function ADDitenCotacao() {
        if ($("#id").val() === '') {
            bootbox.alert('É necessário criar a cotação!');
            return false;

        }
        if ($("#codigo").val() === '') {
            $("#codigo").focus();
            return false;
        } else {
            var codigo = $("#codigo").val();
            $("#codigo").val('');
        }

        $.ajax({type: "GET",
            url: "_backend/_controller/_insert/prodcotacao_insert.php", data: {
                produto: codigo,
                documento: $("#id").val()

            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
                if (data.retorno == true) {
                    toastr.options = {
                        "closeButton": false,
                        "debug": false,
                        "newestOnTop": false,
                        "progressBar": true,
                        "positionClass": "toast-top-right",
                        "preventDuplicates": false,
                        "onclick": null,
                        "showDuration": "1000",
                        "hideDuration": "1000",
                        "timeOut": "1000",
                        "extendedTimeOut": "1000",
                        "showEasing": "swing",
                        "hideEasing": "linear",
                        "showMethod": "fadeIn",
                        "hideMethod": "fadeOut"
                    };
                    toastr.success(data.mensagem);
                    CarregaProd();
                    $("#codigo").val('');
                    $("#descproduto").val('');
                    $("#codigo").focus();
                } else {
                    toastr.warning(data.mensagem);
                }
            }
        }); //termina o jquery

    }

    function ADDFornecedorCotacao() {
        if ($("#id").val() === '') {
            bootbox.alert('É necessário criar a cotação!');
            return false;
        }

        if ($("#fornecedorid").val() === '') {
            $("#fornecedorid").focus();
            return false;
        } else {
            var codigo = $("#fornecedorid").val();
            $("#fornecedorid").val('');
        }

        $.ajax({type: "GET",
            url: "_backend/_controller/_insert/cotacaofornecedor_insert.php", data: {
                fornecedor: codigo,
                documento: $("#id").val()

            },
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
                if (data.retorno == true) {
                    toastr.options = {
                        "closeButton": false,
                        "debug": false,
                        "newestOnTop": false,
                        "progressBar": true,
                        "positionClass": "toast-top-right",
                        "preventDuplicates": false,
                        "onclick": null,
                        "showDuration": "1000",
                        "hideDuration": "1000",
                        "timeOut": "1000",
                        "extendedTimeOut": "1000",
                        "showEasing": "swing",
                        "hideEasing": "linear",
                        "showMethod": "fadeIn",
                        "hideMethod": "fadeOut"
                    };
                    toastr.success(data.mensagem);
                    CarregaProd();
                    $("#fornecedorid").val('');
                    $("#nomefornecedor").val('');
                    $("#fornecedorid").focus();
                } else {
                    toastr.warning(data.mensagem);
                }
            }
        }); //termina o jquery

    }

    function CarregaProd() {
        var doc = $("#id").val();
        //        alert(doc);
        $("#recebeitensprod").load('_backend/_controller/_select/_ajax/frentecaixa/iten_cotacao_select_ajax.php?documento=' + doc + '', function () {
        });
        $(".modal-backdrop").hide();
    }

    function BuscaCotacao(valor) {
        $("#buscaostabs").modal('show');
        $("#buscatitle").html('BUSCA ' + valor.toUpperCase());
        $("#carregandobusca").css("display", "block");
        $("#recebegrid").load('_backend/_view/_grid/' + valor + '_grid.php?busca=S', function () {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }

    function Produto(valor) {
        $("#buscaostabs").modal('hide');
        $("#tudo").hide();
        $("#codigo").val(valor);
        BuscaProdCotacao();
    }

</script>

<button onclick="CarregaProd()">Carregar</button>
<div class="row"> 
    <div class="col-md-2">
        <label> Nº Cotação</label> 
        <input type="text" id="id" readonly="" name="id" maxlength="10"  class="form-control" value="">
    </div>
    <div class="col-md-2">
        <label> Data</label> 
        <input type="text" id="data" readonly="" name="data" onkeypress="mascara(this, mdata);" maxlength="10"  class="form-control" value="<?= date("d/m/Y") ?>">
    </div>
    <div class="col-md-6">
        <label> Descrição</label> 
        <input type="text" id="descricao" name="descricao"  class="form-control" value="">
    </div>
    <div class="col-md-2">
        <button class="btn btn-info" type="button" onclick="CriaCotacao()" style="margin-top: 26px;"> Criar Cotação</button>
    </div>
</div>


<div class="row">
    <div class="col-md-2">
        <label> Produto</label> 
        <input id="codigo" name="codigo" autocomplete="off" onblur="Produto(this.value)" type="text"  class="form-control" placeholder="Código"> 
        <i onclick="BuscaCotacao('grade_produtos')"  style="position: absolute; right: 27px; top: 37px; z-index: 999" class="fa fa-search"> </i>
    </div>

    <div class="col-md-8">
        <label>Descrição</label> 
        <input id="descproduto" type="text" readonly="" class="form-control" autocomplete="off" placeholder=""> 
    </div>

    <div class="col-md-1">
        <label>Adicionar </label> <br/>
        <button class="btn btn-success btn-sm" type="button" onclick="ADDitenCotacao()"><i class="fa fa-plus"></i> </button>
    </div>
</div>

<div class="row">
    <div class="col-md-2">
        <label> Fornecedor</label> 
        <input id="fornecedorid" name="fornecedor" autocomplete="off" onblur="Fornecedor(this.value)" type="text"  class="form-control" placeholder="Código"> 
        <i onclick="BuscaCotacao('fornecedor')"  style="position: absolute; right: 27px; top: 37px; z-index: 999" class="fa fa-search"> </i>
    </div>

    <div class="col-md-8">
        <label>Descrição</label> 
        <input id="nomefornecedor" type="text" readonly="" class="form-control" autocomplete="off" placeholder=""> 
    </div>

    <div class="col-md-1">
        <label>Adicionar </label> <br/>
        <button class="btn btn-success btn-sm" type="button" onclick="ADDFornecedorCotacao()"><i class="fa fa-plus"></i> </button>
    </div>
</div>

<div class="row">
    <div class="col-md-12" id="recebeitensprod">
    </div>
</div>




<div class="modal fade bs-modal-lg bd-example-modal-xl" id="buscaostabs" style="z-index: 99999" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-lg modal-xl" style="width: 95%;">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="buscatitle"></h4>
            </div>
            <div id="carregandobusca" style="z-index: 9999999; position: absolute; left: 50%; top: 50%; margin-left: -50px; margin-top: -50px;">
                <img src="<?= LINK ?>/_frontend/img/loading.gif" style="max-height: 40px" alt=""/>
            </div>
            <div class="modal-body" id="recebegrid"> 

            </div>

        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>