<?php
require_once("../../../functions.php");
require_once("../_modal/_modal.php");
require_once("../../_class/Conexao_class.php");
require_once("../../_class/Crud_class.php");
?>
<style>
    label {
        font-size: 12px;
    }
    .fileUpload {
        position: relative;
        overflow: hidden;
        margin: 0px;
    }
    .fileUpload input.upload {
        position: absolute;
        top: 0;
        right: 0;
        margin: 0;
        padding: 0;
        font-size: 20px;
        cursor: pointer;
        opacity: 0;
        filter: alpha(opacity=0);
    }
</style>
<script>


    function Arquivo(valor) {
        if (verificaExtensaoArquivoJPG(valor)) {
            $("#uploadFile").html(valor);
        } else {
            $("#uploadFile").html('');
            $("#arquivo").val('');
        }


    }
    function Arquivocert(valor) {
        if (verificaExtensaoArquivo(valor)) {
            $("#certificado").html(valor);
        } else {
            $("#arquivocert").val('');
            $("#certificado").html('Buscar Certificado');

        }


    }
    function BuscaCNPJ(CNPJ) {
//        alert(CNPJ);
        $.ajax({
            type: "GET",
            url: "https://www.receitaws.com.br/v1/cnpj/" + CNPJ,
            dataType: "jsonp",
            // função para de sucesso
            success: function (data) {
                //  alert();
                if (data != null) {
                    $("input[name='xNome']").val(data.nome);
                    if (data.fantasia == '') {
                        $("input[name='xFant']").val(data.nome);
                    } else {
                        $("input[name='xFant']").val(data.fantasia);
                    }
                    var cep = data.cep.replace(/[^\d]+/g, '');
                    $("input[name='CEP']").val(cep);
                    BuscaCep(cep, '');
                    $("input[name='nro']").val(data.numero);
                    $("input[name='xCpl']").val(data.complemento);
                    var cnae = data.atividade_principal[0].code.replace(/[^\d]+/g, '');
                    $("input[name='CNAE']").val(cnae);

//                    alert(data.atividade_principal[0].code);
                }
            }
        }); //termina o jquery

    }

    $(document).ready(function () {

        //        alert(valor);
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/emitente_select_ajax.php?emitente=1",
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
                if (data != null) {

                    $.each(data, function () {
                        $.each(this, function (k, v) {
                            $("input[name='" + k + "']").val(v);
                            console.log(k + "=>" + v);
                        });
                        $("select[name='regimetributario']").val(data[0].regimetributario);
                        $("select[name='tpAmb']").val(data[0].tpAmb);
                        $("select[name='certificado']").val(data[0].certificado);
                        $("select[name='romaneio']").val(data[0].romaneio);
                        $("select[name='caixa']").val(data[0].caixa);
//                        $("input[name='csc']").val(data.csc);

                    });

                }
            }
        }); //termina o jquery

    });


    function verificaExtensaoArquivo(arquivo) {
        extensoes_permitidas = new Array(".pfx");
        extensao = (arquivo.substring(arquivo.lastIndexOf("."))).toLowerCase();
        permite = false;
        $(extensoes_permitidas).each(function (i) {
            if (extensoes_permitidas[i] == extensao) {
                permite = true;
                return false;
            }

        });
        if (!permite) {
            alert("SOMENTE É ACEITO CERTIFICADO A1 (*.PFX)!");
            return false;
        }
        return true;
    }

    function verificaExtensaoArquivoJPG(arquivo) {
        extensoes_permitidas = new Array(".jpg");
        extensao = (arquivo.substring(arquivo.lastIndexOf("."))).toLowerCase();
        permite = false;
        $(extensoes_permitidas).each(function (i) {
            if (extensoes_permitidas[i] == extensao) {
                permite = true;
                return false;
            }

        });
        if (!permite) {
            alert("SOMENTE É ACEITO IMAGEM, (.jpg)");
            return false;
        }
        return true;
    }

</script>

<?php
$pdo = Conexao::getInstance();

$crud = Crud::getInstance($pdo, 'emitente');

$sql = "SELECT * from emitente WHERE emitenteid = 1";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
?>

<form id="emitente" enctype="multipart/form-data" action="<?= BACKEND ?>/_controller/_update/emitente_update.php" method="POST">
    <input type="hidden" name="emitenteid">

    <div class="row">
        <div class="col-md-7">
            <div class="portlet box blue-madison">
                <div class="portlet-title">
                    <div class="caption">
                        Emitente
                    </div>
                    <div class="tools">
                        <a href="javascript:;" class="collapse"> </a>
                        <a href="" class="fullscreen"> </a>
                    </div>

                </div>
                <div class="portlet-body">
                    <div class="scroller" style="min-height:200px" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">

                        <div class="row">
                            <div class="col-md-4">
                                <label>CNPJ <span class="text-danger">*</span></label>
                                <input name="CNPJ" readonly="" onblur="BuscaCNPJ(this.value);" maxlength="14" type="text" required="" class="form-control" placeholder=""> 

                            </div>

                            <div class="col-md-4">
                                <label>Insc. Estadual</label>
                                <input name="IE" type="text" class="form-control" placeholder=""> 
                            </div>

                            <div class="col-md-4">
                                <label>Insc. ST </label>
                                <input name="IEST" type="text" class="form-control" placeholder=""> 
                            </div>
                        </div>

                        <div class="row">

                            <div class="col-md-4">
                                <label>Insc. Mun. </label>
                                <input name="IEMN" type="text" class="form-control" placeholder=""> 
                            </div>

                            <div class="col-md-8">
                                <label>Razao Social <span class="text-danger">*</span></label>
                                <input name="xNome" type="text" required="" class="form-control" placeholder=""> 
                            </div>

                        </div>

                        <div class="row">

                            <div class="col-md-8">
                                <label>Nome Fantasia <span class="text-danger">*</span></label>
                                <input name="xFant" type="text" required="" class="form-control" placeholder=""> 
                            </div>

                            <div class="col-md-4">
                                <label>CNAE </label>
                                <input name="CNAE" type="text" class="form-control" placeholder=""> 
                            </div>

                        </div>


                        <div class="row">
                            <div class="col-md-3">
                                <label>CEP <span class="text-danger">*</span></label>
                                <input name="CEP" id="CEP" onchange="BuscaCep(this.value, '')" type="text" maxlength="8" required="" class="form-control" placeholder=""> 
                                <i style="position: absolute; right: 22px; top: 34px;" class="fa fa-search"> </i>
                            </div>

                            <div class="col-md-5">
                                <label>Logradouro <span class="text-danger">*</span></label>
                                <input name="xLgr" id="xLgr" type="text" minlength="2" maxlength="60" required="" class="form-control" placeholder=""> 
                            </div>

                            <div class="col-md-2">
                                <label>Nº <span class="text-danger">*</span></label>
                                <input name="nro" id="nro" type="text" maxlength="60" required="" class="form-control" placeholder=""> 
                            </div>

                            <div class="col-md-2">
                                <label>Com.</label>
                                <input name="xCpl" id="xCpl" type="text" maxlength="60"  class="form-control" placeholder=""> 
                            </div>

                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <label>Bairro <span class="text-danger">*</span></label>
                                <input name="xBairro" id="xBairro" type="text" maxlength="60" minlength="2" required="" class="form-control" placeholder=""> 
                            </div>

                            <div class="col-md-6">
                                <label>Município <span class="text-danger">*</span></label>
                                <input name="xMun" id="xMun" readonly="" type="text" minlength="2" maxlength="60" required="" class="form-control" placeholder=""> 
                            </div>

                            <div class="col-md-2">
                                <label>UF <span class="text-danger">*</span></label>
                                <input name="UF" id="UF" readonly="" type="text" maxlength="2" required="" class="form-control" placeholder=""> 
                            </div>

                            <div class="col-md-2">
                                <input name="cMun" id="cMun" readonly="" type="hidden" maxlength="7" required="" class="form-control" placeholder=""> 
                            </div>



                        </div>

                        <div class="row">

                            <div class="col-md-4">
                                <label>Fone</label>
                                <input name="fone" type="text" class="form-control" placeholder=""> 
                            </div>

                            <div class="col-md-8">
                                <label>E-mail</label>
                                <input name="email" type="email" class="form-control" placeholder=""> 
                            </div>
                        </div>


                        <div class="row">

                            <div class="col-md-5">
                                <label>Regime Tributário </label>
                                <select name="regimetributario" class="form-control">
                                    <option value="1">Simples Nacional </option>
                                    <option value="2">Simples Nacional - Excesso Sublimite de Receita Bruta </option>
                                    <option value="3">Regime Normal </option>
                                </select> 
                            </div>

                            <div class="col-md-5">
                                <label>CSC (NFC-e) <i class="fa fa-question-circle" title="CSC - Código de Segurança do Contribuinte, é obrigatório informar para quem deseja emitir NFC-e, é fornecido pelas SEFAZ"> </i></label>
                                <input name="csc" value="<?= $dados->csc ?>" type="text" class="form-control" placeholder=""> 
                            </div>
                            <div class="col-md-2">
                                <label>ID CSC</label>
                                <input name="idcsc" value="<?= $dados->idcsc ?>" type="text" class="form-control" placeholder=""> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>  


        <div class="col-md-5">
            <div class="portlet box blue-madison">
                <div class="portlet-title">
                    <div class="caption">
                        Logo
                        <span id="uploadFile"></span>
                    </div>
                    <div class="tools">
                        <a href="javascript:;" class="collapse"> </a>
                        <a href="" class="fullscreen"> </a>
                    </div>

                </div>
                <div class="portlet-body">
                    <div class="scroller" style="min-height:57px" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">
                        <div class="tab-content">


                            <div class="col-md-2">
                                <div class="fileUpload btn btn-primary form-control">
                                    <span><i class="fa fa-upload"></i> </span>
                                    <input type="file" name="logo" id="arquivo" onchange="Arquivo(this.value);" class="upload form-control" />
                                </div>
                            </div>

                            <div class="col-md-10 tex-right">
                                <img style="max-height: 57px; float: right;" src="<?= FRONTEND ?>/img/<?= $_SESSION['BD'] ?>/<?= $dados->logo ?>" alt=""/>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="portlet box blue-madison">
                <div class="portlet-title">
                    <div class="caption">
                        Certificado

                    </div>
                    <div class="tools">
                        <a href="javascript:;" class="collapse"> </a>
                        <a href="" class="fullscreen"> </a>
                    </div>

                </div>
                <div class="portlet-body">
                    <div class="scroller" style="min-height:40px" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">
                        <div class="tab-content">

                            <div class="row">
                                <div class="col-md-5">
                                    <img src="<?= FRONTEND ?>/img/certificado.png" style="max-height: 180px;" alt=""/>
                                </div>
                                <div class="col-md-7">
                                    <?php
                                    if ($dados->cert != '') :

                                        $file = '' . DIR . '/nfephp-master/certs/' . $_SESSION['BD'] . '/' . $dados->cert . '';

                                        $certs = array();
                                        $pkcs12 = file_get_contents($file);
                                        if (openssl_pkcs12_read($pkcs12, $certs, $dados->certsenha)) :



                                            $dados = array();
                                            $dados = openssl_x509_parse(openssl_x509_read($certs['cert']));

                                            echo '<br/>';
                                            //print_r( $dados );
                                            //Dados mais importantes
//                                            echo $dados['subject']['C'] . '<br>'; //País
//                                            echo $dados['subject']['ST'] . '<br>'; //Estado
//                                            echo $dados['subject']['L'] . '<br>'; //Município
                                            echo '<b>Emitido Para </b><br/>' . $dados['subject']['CN'] . '<br>'; //Razão Social e CNPJ / CPF
                                            echo '<b>Validade </b><br/>' . date('d/m/Y', $dados['validTo_time_t']) . '<br>'; //Validade	
//                                            echo $dados['extensions']['subjectAltName'] . '<br>'; //Emails Cadastrados separado por ,
                                        endif;
                                    else :
                                        echo '<h4> Sem Certificado. </h4>';
                                    endif;
                                    ?>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-5">
                                    <div class="fileUpload btn btn-primary form-control">
                                        <span><i class="fa fa-upload"></i> <span id="certificado">Buscar Certificado</span></span>
                                        <input type="file" name="cert" id="arquivocert" onchange="Arquivocert(this.value);" class="upload form-control" />
                                    </div>
                                </div>

                                <div class="col-md-5">
                                    <input name="certsenha" value="" autocomplete="off" type="password" class="form-control" placeholder="Senha"> 
                                </div>


                            </div>

                        </div>
                    </div>
                </div>
            </div>

        </div>


        <div class="col-md-12">
            <div class="portlet box blue-madison">
                <div class="portlet-title">
                    <div class="caption">
                        Configurações
                        <span id="uploadFile"></span>
                    </div>
                    <div class="tools">
                        <a href="javascript:;" class="collapse"> </a>
                        <a href="" class="fullscreen"> </a>
                    </div>

                </div>
                <div class="portlet-body">
                    <div class="scroller" style="min-height:57px" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">
                        <div class="tab-content">
                            <div class="row">

                                <div class="col-md-3">
                                    <label>Ambiente </label>
                                    <select name="tpAmb" class="form-control">
                                        <option value="2">Homologação </option>
                                        <option value="1">Produção </option>
                                    </select> 
                                </div>

                                <div class="col-md-3">
                                    <label>Certificado </label>
                                    <select name="certificado" class="form-control">
                                        <option value="A1">A1 </option>
                                        <option value="A3">A3 </option>
                                    </select> 
                                </div>

                                <div class="col-md-3">
                                    <label>Romaneio </label>
                                    <select name="romaneio" class="form-control">
                                        <option value="01"> NFC-e + Romaneio </option>
                                        <option value="02">NFC-e </option>
                                        <option value="03">Romaneio </option>
                                    </select> 
                                </div>

                                <div class="col-md-3">
                                    <label>Abertura/Fechamento Caixa </label>
                                    <select name="caixa" class="form-control">
                                        <option value="S">Habilitado </option>
                                        <option value="N">Desabilitado </option>
                                    </select> 
                                </div>
                            </div> 

                        </div>
                    </div>
                </div>
            </div>
        </div>  




        <div class="row">
            <div class="col-md-12 text-right">
                <a href="#" onclick="Carrega('_grid', 'emitente_grid.php', 'Cliente')" class="btn btn-warning"> <i class="fa fa-close"></i> Cancelar </a>
                <button type="submit" class="btn btn-success"> <i class="fa fa-save"></i> Salvar </button>
            </div>
        </div>
</form>

<script>
    $(document).ready(function () {
        // bind form using ajaxForm 
        $('#emitente').ajaxForm({
            // dataType identifies the expected content type of the server response 
            dataType: 'json',
            // success identifies the function to invoke when the server response 
            // has been received 
            success: processJson,
            error: function (jqXHR, textStatus, errorThrown) {
                if (jqXHR.responseText) {

                    var str = jqXHR.responseText;
                    var retorno = jQuery.parseJSON(str.substr(3));

                    if (retorno.retorno == true) {
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html(retorno.mensagem);
                        Carrega('_form', 'configuracoes_form.php', 'Configuração');
                        setTimeout(function () {
                            $("#alertsucesso").css("display", "none");
                        }, 4000);
                    } else {
                        document.getElementById("alertsucesso").style.display = "none";
                        document.getElementById("alerterro").style.display = "block";
                        $("#erro").html(retorno.mensagem);
                        setTimeout(function () {
                            $("#alerterro").css("display", "none");
                        }, 4000);

                    }

                }

            }
        });
    });

    function processJson(data) {
        if (data.retorno == true) {
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html(data.mensagem);
            Carrega('_form', 'configuracoes_form.php', 'Configuração');
            setTimeout(function () {
                $("#alertsucesso").css("display", "none");
            }, 4000);
        } else {
            document.getElementById("alertsucesso").style.display = "none";
            document.getElementById("alerterro").style.display = "block";
            $("#erro").html(data.mensagem);
            setTimeout(function () {
                $("#alerterro").css("display", "none");
            }, 4000);
        }
    }
</script>