<?php
require_once("../../../functions.php");
require_once("../_modal/_modal.php");
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/nivel_acesso.php";
require_once "../../../_backend/_class/parametros.php";

if (isset($_GET['editar'])) :
    if ($nivelacesso->clienteedt !== 'S') :
        require_once '../../../_backend/_view/_form/permissao.html';
        exit;
    endif;
else :
    if ($nivelacesso->clienteadd !== 'S') :
        require_once '../../../_backend/_view/_form/permissao.html';
        exit;
    endif;
endif;
?>
<style>
    .tab-content {
        border-radius: 0 0 0px 0px;
        box-shadow: 0 0px 0px 0 rgba(0, 0, 0, 0.04);
        background-color: white;
        border: 0px solid #eeeeee;
        border-top: 0;
        padding: 15px;
    }
    .input-group-addon {
        padding: 6px 12px;
        font-size: 14px;
        font-weight: normal;
        line-height: 1;
        color: #555555;
        text-align: center;
        background-color: #fff;
        border: 0px solid #cccccc;
        border-radius: 0px;
    }
</style>
<script>

    function RemoveVeic(val) {
        $("#veic" + val + "").remove();
    }

    function AddVeiculo() {
        var id = Number($("#idveic").val()) + 1;
        var options = '<div class="row" id="veic' + id + '">' +
                '<div class="col-md-2">' +
                '<label class="control-label">Placa </label>' +
                '<input type="text" class="form-control" name="placa[]" placeholder="" />' +
                '</div>' +
                '<div class="col-md-2">' +
                '<label class="control-label">Marca </label>' +
                '<input type="text" class="form-control" name="marca[]" placeholder="" />' +
                '</div>' +
                '<div class="col-md-2">' +
                '<label class="control-label">Modelo </label>' +
                '<input type="text" class="form-control" name="modelo[]" placeholder="" />' +
                '</div>' +
                '<div class="col-md-2">' +
                '<label class="control-label">Ano</label>' +
                '<input type="text" class="form-control" name="ano[]" placeholder="" />' +
                '</div>' +
                '<div class="col-md-2">' +
                '<label class="control-label">Km Atual</label>' +
                '<input type="text" class="form-control" name="kmatual[]" placeholder="" />' +
                '</div>' +
                '<div class="col-md-2">' +
                '<label class="control-label">Remover</label> <br/>' +
                '<button type="button" class="btn btn-danger btn-sm" onclick="RemoveVeic(' + id + ')"> <i class="fa fa-trash"></i> </button>' +
                '</div>' +
                '</div>';

        $("#recebeveic").append(options);
        $("#idveic").val(id);
    }

    function VerificaCliente() {
        if ($("#CNPJ").val() !== '') {
            var valor = $("#CNPJ").val();
            $.ajax({
                type: "GET",
                url: "<?= BACKEND ?>/_controller/_select/_ajax/cliente_doc_select_ajax.php",
                data: {
                    cnpj: valor
                },
                dataType: "json",
// função para de sucesso
                success: function (data) {
//                alert(data);
                    if (data[0].CNPJ !== '') {
                        bootbox.alert("Já existe um cliente com o mesmo CPF/CNPJ . <br/> <b>" + data[0].clienteid + " - " + data[0].xNome + "</b>");
                       // $("#CNPJ").val('');
                    //    $("#CNPJ").focus();
                    }
                }
            }); //termina o jquery
        }
    }

    function VerificaNomeCliente() {
        if ($("#xNome").val() !== '') {
            var valor = $("#xNome").val();
            $.ajax({
                type: "GET",
                url: "<?= BACKEND ?>/_controller/_select/_ajax/cliente_xnome_select_ajax.php",
                data: {
                    nome: valor
                },
                dataType: "json",
// função para de sucesso
                success: function (data) {
//                alert(data);
                    if (data[0].CNPJ !== '') {
                        bootbox.alert("Já existe um cliente com o mesmo Nome/Razão social . <br/> <b>" + data[0].clienteid + " - " + data[0].xNome + "</b>");
//                        $("#CNPJ").val('');
//                        $("#CNPJ").focus();
                    }
                }
            }); //termina o jquery
        }
    }

    function RemoveTrTable(id) {
        $("#e" + id + "").remove();
    }

    function RemoveTrTableVeic(id) {
        $("#eveic" + id + "").remove();
    }


    function ValidaDoc() {
        VerificaCliente();

        var tipo = $("#tipo").val();
//        alert(tipo);
        if (tipo === 'F') {
            if ($("#CNPJ").val() !== '') {
                if (!validarCPF($("#CNPJ").val())) {
                    bootbox.alert("CPF Inválido!");
                    $("#CNPJ").val('');
//                    $("#CNPJ").select();
                }
            }
        } else {
            if ($("#CNPJ").val() !== '') {
                if (!validarCNPJ($("#CNPJ").val())) {
                    bootbox.alert("CNPJ Inválido!");
                    $("#CNPJ").val('');
//                    $("#CNPJ").select();
                }
            }
        }
    }


    function validarCNPJ(cnpj) {

        cnpj = cnpj.replace(/[^\d]+/g, '');

        if (cnpj == '')
            return false;

        if (cnpj.length != 14)
            return false;

        // Elimina CNPJs invalidos conhecidos
        if (cnpj == "00000000000000" ||
                cnpj == "11111111111111" ||
                cnpj == "22222222222222" ||
                cnpj == "33333333333333" ||
                cnpj == "44444444444444" ||
                cnpj == "55555555555555" ||
                cnpj == "66666666666666" ||
                cnpj == "77777777777777" ||
                cnpj == "88888888888888" ||
                cnpj == "99999999999999")
            return false;

        // Valida DVs
        tamanho = cnpj.length - 2
        numeros = cnpj.substring(0, tamanho);
        digitos = cnpj.substring(tamanho);
        soma = 0;
        pos = tamanho - 7;
        for (i = tamanho; i >= 1; i--) {
            soma += numeros.charAt(tamanho - i) * pos--;
            if (pos < 2)
                pos = 9;
        }
        resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
        if (resultado != digitos.charAt(0))
            return false;

        tamanho = tamanho + 1;
        numeros = cnpj.substring(0, tamanho);
        soma = 0;
        pos = tamanho - 7;
        for (i = tamanho; i >= 1; i--) {
            soma += numeros.charAt(tamanho - i) * pos--;
            if (pos < 2)
                pos = 9;
        }
        resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
        if (resultado != digitos.charAt(1))
            return false;

        return true;

    }


    function validarCPF(cpf) {
        cpf = cpf.replace(/[^\d]+/g, '');
        if (cpf == '')
            return false;
        // Elimina CPFs invalidos conhecidos	
        if (cpf.length != 11 ||
                cpf == "00000000000" ||
                cpf == "11111111111" ||
                cpf == "22222222222" ||
                cpf == "33333333333" ||
                cpf == "44444444444" ||
                cpf == "55555555555" ||
                cpf == "66666666666" ||
                cpf == "77777777777" ||
                cpf == "88888888888" ||
                cpf == "99999999999")
            return false;
        // Valida 1o digito	
        add = 0;
        for (i = 0; i < 9; i ++)
            add += parseInt(cpf.charAt(i)) * (10 - i);
        rev = 11 - (add % 11);
        if (rev == 10 || rev == 11)
            rev = 0;
        if (rev != parseInt(cpf.charAt(9)))
            return false;
        // Valida 2o digito	
        add = 0;
        for (i = 0; i < 10; i ++)
            add += parseInt(cpf.charAt(i)) * (11 - i);
        rev = 11 - (add % 11);
        if (rev == 10 || rev == 11)
            rev = 0;
        if (rev != parseInt(cpf.charAt(10)))
            return false;
        return true;
    }



    (function ($) {
        RemoveTableRow = function (handler) {
            var tr = $(handler).closest('tr');

            tr.fadeOut(400, function () {
                tr.remove();
            });

            return false;
        };

        addCheque = function () {

            var CEP = $("#CEP").val();
            var xLgr = $("#xLgr").val();
            var nro = $("#nro").val();
            var xCpl = $("#xCpl").val();
            var xBairro = $("#xBairro").val();
            var xMun = $("#xMun").val();
            var UF = $("#UF").val();
            var cMun = $("#cMun").val();
            var obs = $("#obsendereco").val();

            var newRow = $("<tr>");

            var opcoes = '<td>' +
                    '<input type="hidden" readonly="" name="CEP[]" value="' + CEP + '" title="' + CEP + '" placeholder="CEP" class="form-control" style="background-color: #fff; border: none;"> ' +
                    ' ' + CEP + ' ' +
                    '</td>' +
                    '<td >' +
                    '<input type="hidden" readonly="" name="xLgr[]" value="' + xLgr + '" placeholder="xLgr" class="form-control" style="background-color: #fff; border: none;">' +
                    ' ' + xLgr + ' ' +
                    '</td>' +
                    '<td>' +
                    '<input type="hidden" readonly="" name="nro[]" value="' + nro + '" placeholder="Nº" class="form-control" style="background-color: #fff; border: none;">' +
                    ' ' + nro + ' ' +
                    '</td>' +
                    '<td >' +
                    '<input type="hidden" readonly="" name="xCpl[]" value="' + xCpl + '" placeholder="Comp." class="form-control" style="background-color: #fff; border: none;">' +
                    ' ' + xCpl + ' ' +
                    '</td>' +
                    '<td>' +
                    '<input type="hidden" readonly="" name="xBairro[]" value="' + xBairro + '" placeholder="Bairro" class="form-control" style="background-color: #fff; border: none;">' +
                    ' ' + xBairro + ' ' +
                    '</td>' +
                    '<td>' +
                    '<input type="hidden" readonly="" name="xMun[]" placeholder="Cidade." value="' + xMun + '" class="form-control" style="background-color: #fff; border: none;">' +
                    ' ' + xMun + ' ' +
                    '</td>' +
                    '<td>' +
                    '<input type="hidden" readonly="" name="UF[]" placeholder="UF" value="' + UF + '" class="form-control" style="background-color: #fff; border: none;">' +
                    ' ' + UF + ' ' +
                    '<input type="hidden" readonly="" name="cMun[]" placeholder="IBGE" value="' + cMun + '" class="form-control">' +
                    '<input type="hidden" readonly="" name="obsendereco[]" placeholder="obs" value="' + obs + '" class="form-control">' +
                    '</td>' +
                    '<td>' +
                    '<kbd title="' + obs + '" style="padding: 7px;"> <i class="fa fa-info"  > </i> </kbd>' +
                    '</td>' +
                    '<td>' +
                    '   <a href="javascript::" onclick="RemoveTableRow(this)" class="btn btn-danger"><i class="fa fa-trash"></i></a>' +
                    '</td>';

            newRow.append(opcoes);
            $("#tabelaendereco").append(newRow);

            toastr.info('Endereço adicionado!');

            var CEP = $("#CEP").val('');
            var xLgr = $("#xLgr").val('');
            var nro = $("#nro").val('');
            var xCpl = $("#xCpl").val('');
            var xBairro = $("#xBairro").val('');
            var xMun = $("#xMun").val('');
            var UF = $("#UF").val('');
            var cMun = $("#cMun").val('');
            var obs = $("#obsendereco").val('');

            return false;
        };
    })(jQuery);

    function PlanodeContas(valor) {

        $.ajax({
            url: "<?= BACKEND ?>/_view/_financeiro/_controller/_select/_ajax/planodeconta_select_ajax.php?conta=" + valor,
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
                if (data[0].planodecontassequencia != '') {
                    $("#planodeconta").val(data[0].planodecontassequencia);
                    $("#planodecontadesc").val(data[0].planodecontasdescricao);
                }
            }
        }); //termina o jquery

        $("#busca").modal('hide');
    }


    function Busca(valor) {
        $("#busca").modal('show');
        $("#buscatitle").html('BUSCA ' + valor.toUpperCase());
        $("#carregandobusca").css("display", "block");
        $("#recebegrid").load('_backend/_view/_grid/' + valor + '_grid.php?busca=S', function () {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }

    function BuscaPlanodeConta() {

        $("#busca").modal('show');
        $("#buscatitle").html('BUSCA PLANO DE CONTAS');
        $("#carregandobusca").css("display", "block");
//        $("#recebegrid").load('_backend/_view/_grid/' + valor + '_grid.php?busca=S', function () {
        $("#recebegrid").load('_backend/_view/_financeiro/_grid/planoconta_grid.php?busca=S', function () {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }


    function BuscaEc(valor) {
        if (valor == 'C') {
            $("#ec").css("display", "block");
        } else {
            $("#conjuge").val('');
            $("#ec").css("display", "none");
        }
    }

    $('#xNome').keyup(function () {
//        alert(this.value);
        $("#xFant").val(this.value);
    });
    function Tipo(valor) {
        if (valor == 'F') {
            $("#tcpfcnpj").html('CPF');
            $("#tdn").html('Data Nascimento');
            $("#trg").html('RG.');
            $("#buscacnpj").css("display", "none");
            $("#reftab").show();

        } else {
            $("#tcpfcnpj").html('CNPJ');
            $("#tdn").html('Data Fund.');
            $("#trg").html('Ins. Estadual');
            $("#buscacnpj").css("display", "block");
            $("#reftab").hide();
        }
    }


    function EnderecoDel(valor) {
        if (valor == '') {
            return false;
        }

        bootbox.confirm({
            title: "Atenção!",
            message: "Deseja deletar o endereço selecionado?",
            buttons: {
                cancel: {
                    label: '<i class="fa fa-times"></i> Não'
                },
                confirm: {
                    label: '<i class="fa fa-check"></i> Sim'
                }
            },
            callback: function (result) {
                if (result) {
                    $.ajax({
                        type: "GET",
                        url: "<?= BACKEND ?>/_controller/_delete/endereco_delete.php",
                        data: {
                            cliente: valor
                        },
                        dataType: "json",
// função para de sucesso
                        success: function (data) {
//                alert(data);
                            if (data.retorno) {
                                toastr.success('Endereço deletado');
                                RemoveTrTable(valor)
                            } else {
                                toastr.success('Tente novamente!');
                            }
                        }
                    }); //termina o jquery
                }
            }
        });
//        alert(valor);

    }

    function VeiculoDel(valor) {
        if (valor == '') {
            return false;
        }

        bootbox.confirm({
            title: "Atenção!",
            message: "Deseja deletar o veículo selecionado?",
            buttons: {
                cancel: {
                    label: '<i class="fa fa-times"></i> Não'
                },
                confirm: {
                    label: '<i class="fa fa-check"></i> Sim'
                }
            },
            callback: function (result) {
                if (result) {
                    $.ajax({
                        type: "GET",
                        url: "<?= BACKEND ?>/_controller/_delete/veiculo_cliente_delete.php",
                        data: {
                            veiculo: valor
                        },
                        dataType: "json",
// função para de sucesso
                        success: function (data) {
//                alert(data);
                            if (data.retorno) {
                                toastr.success('Veículo deletado');
                                RemoveTrTableVeic(valor);
                            } else {
                                toastr.success('Tente novamente!');
                            }
                        }
                    }); //termina o jquery
                }
            }
        });
//        alert(valor);

    }

    function Representante(valor) {
        if (valor == '') {
            return false;
        }
//        alert(valor);
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/representante_select_ajax.php",
            data: {
                representante: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//                alert(data);
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#nomerepresentante").val(data[0].xNome);
                    $("#representante").val(data[0].representanteid);
                } else {
                    $("#representante").val('');
                    $("#nomerepresentante").val('');
                    toastr.warning('Representante Não Encontrado');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }



    $("#fone").keyup(function (e) {
        $("#whatsapp").val($("#fone").val());
    });

    function Corretor(valor) {
        if (valor == '') {
            return false;
        }
//        alert(valor);
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/corretor_select_ajax.php",
            data: {
                corretor: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#nomecorretor").val(data[0].xNome);
                    $("#corretor").val(data[0].corretorid);
                } else {
                    $("#corretor").val('');
                    $("#nomecorretor").val('');
                    toastr.warning('Corretor Não Encontrado');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }

    function Vendedor(valor) {
        if (valor == '') {
            return false;
        }
//        alert(valor);
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/vendedor_select_ajax.php",
            data: {
                vendedor: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#nomevendedor").val(data[0].xNome);
                    $("#vendedor").val(data[0].vendedorid);
                } else {
                    $("#vendedor").val('');
                    $("#nomevendedor").val('');
                    toastr.warning('Vendedor Não Encontrado');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }


    function BuscaCNPJ() {
//        document.getElementById("carregando").style.display = "block";
//        alert('OK');
        var CNPJ = $("#CNPJ").val();
//        alert(CNPJ);
        if (CNPJ == '') {
            return false;
        }

        $.ajax({
            type: "GET",
            url: "https://www.receitaws.com.br/v1/cnpj/" + CNPJ,
            dataType: "jsonp",
            // função para de sucesso
            success: function (data) {
                //  alert();
                if (data != null) {
                    $("input[name='xNome']").val(data.nome);
                    if (data.fantasia == '') {
                        $("input[name='xFant']").val(data.nome);
                    } else {
                        $("input[name='xFant']").val(data.fantasia);
                    }
                    var cep = data.cep.replace(/[^\d]+/g, '');
                    $("input[name='CEP']").val(cep);
                    BuscaCep(cep, '');
                    $("input[name='nro']").val(data.numero);
                    $("input[name='xCpl']").val(data.complemento);
                    var cnae = data.atividade_principal[0].code.replace(/[^\d]+/g, '');
                    $("input[name='CNAE']").val(cnae);
//                    alert(data.atividade_principal[0].code);
                }
            }
        }); //termina o jquery
//        document.getElementById("carregando").style.display = "none";

    }

</script>

<style>
    label {
        font-size: 12px;
    }
</style>
<?php
if (isset($_GET['editar'])) :
    $editar = $_GET['editar'];
//    echo $editar;

    $action = "" . BACKEND . "/_controller/_update/cliente_update.php";
    ?>
    <script>
        $(document).ready(function () {

            //        alert(valor);
            $.ajax({
                type: "GET",
                url: "<?= BACKEND ?>/_controller/_select/_ajax/cliente_select_ajax.php?cliente=<?= $editar ?>",
                            dataType: "json",
                            // função para de sucesso
                            success: function (data) {
                                //  alert();
                                if (data != null) {

                                    $.each(data, function () {
                                        $.each(this, function (k, v) {
                                            $("input[name='" + k + "']").val(v);
                                            $("select[name='" + k + "']").val(v);
                                            $("textarea[name='" + k + "']").val(v);
                                            if (k == 'tipo') {
                                                Tipo(v);
                                            }


                                            //                                            console.log(k + "=>" + v);
                                        });
                                    });
                                    if (data[0].planodecontas != '') {
                                        PlanodeContas(data[0].planodecontas);
                                    }

                                    if (data[0].vendedor > 0) {
                                        Vendedor(data[0].vendedor);
                                    } else {
                                        $("#vendedor").val('');
                                    }


                                    if (data[0].representante > 0) {
                                        Representante(data[0].representante);
                                    } else {
                                        $("#representante").val('');
                                    }


                                    if (data[0].corretor > 0) {
                                        Corretor(data[0].corretor);
                                    } else {
                                        $("#corretor").val('');
                                    }
                                }
                            }
                        }); //termina o jquery

                    });
    </script>

    <?php
else :
    $action = "" . BACKEND . "/_controller/_insert/cliente_insert.php";
endif;
?>
<form id="cliente" action="<?= $action ?>" method="POST">
    <?php
    if (isset($_GET['editar'])):

        echo '<input type="hidden" name="clienteid">';

    endif;
    ?>
    <div class="row">
        <div class="col-md-12">
            <ul class="nav nav-tabs " role="tablist">
                <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab" data-toggle="tab">Dados Gerais</a></li>
                <li role="presentation"><a href="#profile" aria-controls="profile" role="tab" data-toggle="tab">Endereços</a></li>
                <li role="presentation" id="reftab"><a href="#messages" aria-controls="messages" role="tab" data-toggle="tab">Referências</a></li>
                <?php
                if ($parametros->otica == 'S') :
                    ?>
                    <li role="presentation"><a href="#otica" aria-controls="otica" role="tab" data-toggle="tab">Receituário</a></li>
                    <?php
                endif;
                ?>
                <li role="presentation"><a href="#settings" aria-controls="settings" role="tab" data-toggle="tab">Redes Sociais</a></li>
                <li role="presentation"><a href="#obs" aria-controls="obs" role="tab" data-toggle="tab">Obs</a></li>
                <?php
                if ($parametros->os == 'S') :
                    ?>
                    <li role="presentation"><a href="#veiculo" aria-controls="veiculos" role="tab" data-toggle="tab">Veículos</a></li>
                    <?php
                endif;
                ?>
            </ul>
                <!--<section class="panel">-->
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="home">
                    <div class="row">
                        <div class="col-md-3">
                            <label>Tipo</label>
                            <select name="tipo" onchange="Tipo(this.value)" id="tipo" class="form-control">
                                <option value="F">Física</option>
                                <option value="J">Jurídica</option>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label id="tcpfcnpj">CPF</label>
                            <div class="input-group input-group-icon">
                                <input name="CNPJ" id="CNPJ" onkeypress="return SomenteNumero(event)"
                                <?php
                                if ($parametros->validadoc == 'S') :
                                    ?>
                                           onblur="ValidaDoc()" onpaste="limparNaoNumericos(event)"
                                           <?php
                                       else :
                                           ?>
                                           onblur="VerificaCliente()"

                                       <?php
                                       endif;
                                       ?>
                                       maxlength="14" type="text" class="form-control" placeholder="">                   
                            </div>

                            <span class="input-group-addon" id="buscacnpj" onclick="BuscaCNPJ()" style="display: none; cursor: pointer">
                                <span class="icon icon-lg">
                                    <i style="position: absolute; right: 22px; top: 37px; z-index: 9999;" class="fa fa-search"> </i>

                                </span>
                            </span>

                        </div>

                        <div class="col-md-3">
                            <label id="trg">RG</label>
                            <input name="IE" type="text" class="form-control" placeholder="" onkeypress="return SomenteNumero(event)" onpaste="limparNaoNumericos(event)"> 
                        </div>

                        <div class="col-md-3">
                            <label id="tdn">Data Nascimento</label>
                            <input name="DataNasc" type="text" onkeypress="mascara(this, mdata);" maxlength="10" class="form-control" placeholder=""> 
                        </div>
                    </div>

                    <div class="row">

                        <div class="col-md-6">
                            <label>Nome/Razao Social <span class="text-danger">*</span></label>
                            <input name="xNome" id="xNome" onblur="VerificaNomeCliente()" required="" type="text"  class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-6">
                            <label>Nome Fantasia <span class="text-danger">*</span></label>
                            <input name="xFant" id="xFant" required="" type="text"  class="form-control" placeholder=""> 
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <label>Telefone</label>
                            <input name="fone" maxlength="15" id="fone" onkeypress='mascaraTelefone(this, cpfCnpj)' type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-3">
                            <label>Telefone</label>
                            <input name="fone1" maxlength="15" id="fone1" onkeypress='mascaraTelefone(this, cpfCnpj)' type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-3">
                            <label>Celular</label>
                            <input name="celular" maxlength="15" id="celular" onkeypress='mascaraTelefone(this, cpfCnpj)' type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-3">
                            <label>Whatsapp</label>
                            <div class="input-group input-group-icon">
                                <input name="whatsapp" maxlength="15" id="whatsapp" onkeypress='mascaraTelefone(this, cpfCnpj)' type="text" class="form-control" placeholder=""> 
                                <span class="input-group-addon">
                                    <span class="icon icon-lg">
                                        <i class="fa fa-whatsapp"></i>
                                    </span>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="row">

                        <div class="col-md-6">
                            <label>E-mail</label>
                            <input name="email" type="email" class="form-control" placeholder=""> 
                        </div>

                        <div class="col-md-6">
                            <label>Contato</label>
                            <input name="contato" type="text" class="form-control" placeholder=""> 
                        </div>

                    </div>

                </div>

                <div role="tabpanel" class="tab-pane" id="profile">

                    <!--ENDEREÇO-->

                    <?php
                    if ($parametros->cheff == 'S') :
                        ?>
                        <div id="endereco">
                            <div class="row">
                                <div class="col-md-3">
                                    <label>CEP </label>
                                    <input id="CEP" onchange="BuscaCep(this.value, '')" type="text" maxlength="8"  class="form-control" placeholder=""> 
                                    <i style="position: absolute; right: 22px; top: 37px; z-index: 9999" class="fa fa-search"> </i>
                                </div>

                                <div class="col-md-5">
                                    <label>Logradouro </label>
                                    <input id="xLgr" type="text" minlength="2" maxlength="60"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-2">
                                    <label>Nº </label>
                                    <input id="nro" type="text" maxlength="60"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-2">
                                    <label>Com.</label>
                                    <input id="xCpl" type="text" maxlength="60"  class="form-control" placeholder=""> 
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-md-4">
                                    <label>Bairro </label>
                                    <input id="xBairro" type="text" maxlength="60" minlength="2"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-4">
                                    <label>Município </label>
                                    <input id="xMun"  type="text" minlength="2" maxlength="60"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-2">
                                    <label>UF </label>
                                    <input id="UF"  type="text" maxlength="2"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-2">
                                    <label>IBGE</label>
                                    <input id="cMun" type="text" type="hidden" maxlength="7"  class="form-control" placeholder=""> 
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-md-10">
                                    <label>Obs</label>
                                    <input id="obsendereco" type="text" maxlength="120"  class="form-control" placeholder=""> 
                                </div>   

                                <div class="col-md-2">
                                    <br/>
                                    <button class="btn btn-info" type="button" onclick="addCheque()"> Adicionar endereço </button>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div  class="col-md-12">
                                <hr/>
                                <table id="tabelaendereco" class="table table-condensed table-hover table-striped table-responsive">

                                </table>


                                <?php
                                if (isset($_GET['editar'])) :
                                    ?>
                                    <table class="table table-condensed table-hover table-striped table-responsive">

                                        <?php
                                        $pdo = Conexao::getInstance();
                                        $crud = Crud::getInstance($pdo, 'endereco');
                                        $sql = "SELECT * from endereco where cliente = '" . $_GET['editar'] . "' ";
                                        $arrayParam = '';
                                        $dadoscli = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

                                        foreach ($dadoscli as $dadoscli) :
                                            ?>
                                            <tr id="e<?= $dadoscli->id ?>">
                                                <td> <?= $dadoscli->CEP ?> </td>
                                                <td> <?= $dadoscli->xLgr ?> </td>
                                                <td> <?= $dadoscli->nro ?> </td>
                                                <td> <?= $dadoscli->xCpl ?> </td>
                                                <td> <?= $dadoscli->xBairro ?> </td>
                                                <td> <?= $dadoscli->xMun ?> </td>
                                                <td> <?= $dadoscli->UF ?> </td>
                                                <td>
                                                    <kbd title="<?= $dadoscli->obs ?>" style="padding: 7px;"> <i class="fa fa-info"  > </i> </kbd>
                                                </td>
                                                <td>
                                                    <a href="javascript::" onclick="EnderecoDel('<?= $dadoscli->id ?>')" class="btn btn-danger"><i class="fa fa-trash"></i></a>
                                                </td>

                                            </tr>
                                            <?php
                                        endforeach;
                                        ?>
                                    </table>
                                    <?php
                                endif;
                                ?>
                            </div>
                        </div>
                        <?php
                    else :
                        ?>
                        <legend>Endereço Principal</legend>
                        <div id="endereco">
                            <div class="row">
                                <div class="col-md-3">
                                    <label>CEP </label>
                                    <input name="CEP" id="CEP" onchange="BuscaCep(this.value, '')" type="text" maxlength="8"  class="form-control" placeholder=""> 
                                    <i style="position: absolute; right: 22px; top: 37px; z-index: 9999" class="fa fa-search"> </i>
                                </div>

                                <div class="col-md-5">
                                    <label>Logradouro </label>
                                    <input name="xLgr" id="xLgr" type="text" minlength="2" maxlength="60"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-2">
                                    <label>Nº </label>
                                    <input name="nro" id="nro" type="text" maxlength="60"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-2">
                                    <label>Com.</label>
                                    <input name="xCpl" id="xCpl" type="text" maxlength="60"  class="form-control" placeholder=""> 
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-md-4">
                                    <label>Bairro </label>
                                    <input name="xBairro" id="xBairro" type="text" maxlength="60" minlength="2"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-4">
                                    <label>Município </label>
                                    <input name="xMun" id="xMun"  type="text" minlength="2" maxlength="60"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-2">
                                    <label>UF </label>
                                    <input name="UF" id="UF"  type="text" maxlength="2"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-2">
                                    <label>IBGE</label>
                                    <input name="cMun" id="cMun" type="text" type="hidden" maxlength="7"  class="form-control" placeholder=""> 
                                </div>



                            </div>
                        </div>

                        <br/>
                        <!--ENDEREÇO Cob-->
                        <legend>Endereço Cobrança</legend>
                        <div id="endereco">
                            <div class="row">
                                <div class="col-md-3">
                                    <label>CEP </label>
                                    <input name="CobCEP" id="CobCEP" onchange="BuscaCep(this.value, 'Cob')" type="text" maxlength="8"  class="form-control" placeholder=""> 
                                    <i style="position: absolute; right: 22px; top: 37px; z-index: 9999" class="fa fa-search"> </i>
                                </div>

                                <div class="col-md-5">
                                    <label>Logradouro </label>
                                    <input name="CobxLgr" id="CobxLgr" type="text" minlength="2" maxlength="60"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-2">
                                    <label>Nº </label>
                                    <input name="Cobnro" id="Cobnro" type="text" maxlength="60"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-2">
                                    <label>Com.</label>
                                    <input name="CobxCpl" id="CobxCpl" type="text" maxlength="60"  class="form-control" placeholder=""> 
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-md-4">
                                    <label>Bairro </label>
                                    <input name="CobxBairro" id="CobxBairro" type="text" maxlength="60" minlength="2"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-4">
                                    <label>Município </label>
                                    <input name="CobxMun" id="CobxMun" type="text" minlength="2" maxlength="60"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-2">
                                    <label>UF </label>
                                    <input name="CobUF" id="CobUF" type="text" maxlength="2"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-2">
                                    <label>IBGE</label>
                                    <input name="CobcMun" id="CobcMun" type="text" type="hidden" maxlength="7"  class="form-control" placeholder=""> 
                                </div>

                            </div>
                        </div>

                        <br/>

                        <!--ENDEREÇO Ent-->
                        <legend>Endereço Entrega</legend>
                        <div id="endereco">
                            <div class="row">
                                <div class="col-md-3">
                                    <label>CEP </label>
                                    <input name="EntCEP" id="EntCEP" onchange="BuscaCep(this.value, 'Ent')" type="text" maxlength="8"  class="form-control" placeholder=""> 
                                    <i style="position: absolute; right: 22px; top: 37px; z-index: 9999" class="fa fa-search"> </i>
                                </div>

                                <div class="col-md-5">
                                    <label>Logradouro </label>
                                    <input name="EntxLgr" id="EntxLgr" type="text" minlength="2" maxlength="60"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-2">
                                    <label>Nº </label>
                                    <input name="Entnro" id="Entnro" type="text" maxlength="60"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-2">
                                    <label>Com.</label>
                                    <input name="EntxCpl" id="EntxCpl" type="text" maxlength="60"  class="form-control" placeholder=""> 
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-md-4">
                                    <label>Bairro </label>
                                    <input name="EntxBairro" id="EntxBairro" type="text" maxlength="60" minlength="2"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-4">
                                    <label>Município </label>
                                    <input name="EntxMun" id="EntxMun"  type="text" minlength="2" maxlength="60"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-2">
                                    <label>UF </label>
                                    <input name="EntUF" id="EntUF"  type="text" maxlength="2"  class="form-control" placeholder=""> 
                                </div>

                                <div class="col-md-2">
                                    <label>IBGE </label>
                                    <input name="EntcMun" id="EntcMun" type="text" type="hidden" maxlength="7"  class="form-control" placeholder=""> 
                                </div>

                            </div>
                        </div>

                    <?php
                    endif;
                    ?>



                </div>

                <div role="tabpanel" class="tab-pane" id="messages">
                    <div class="row">
                        <div class="col-md-6">
                            <label>Pai </label>
                            <input name="pai" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-6">
                            <label>Mãe </label>
                            <input name="mae" type="text" class="form-control" placeholder=""> 
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <label>Estado Civil</label>
                            <select name="estadocivil" onchange="BuscaEc(this.value)" class="form-control">
                                <option value="S"> Solteiro(a)</option>
                                <option value="C"> Casado(a)</option>
                                <option value="D"> Divorciado(a)</option>
                                <option value="O"> Outro(a)</option>
                            </select>
                        </div>
                        <div class="col-md-9" id="ec" style="display: none;">
                            <label>Cônjuge</label>
                            <input name="conjuge" id="conjuge" type="text" class="form-control" placeholder=""> 
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <label>Ref. Comercial Empresa </label>
                            <input name="refempresa1" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-4">
                            <label>Informante </label>
                            <input name="refinformante1" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-4">
                            <label>Telefone </label>
                            <input name="reftelefone1" onkeypress='mascaraTelefone(this, cpfCnpj)' type="text" class="form-control" placeholder=""> 
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <label>Ref. Comercial Empresa </label>
                            <input name="refempresa2" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-4">
                            <label>Informante </label>
                            <input name="refinformante2" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-4">
                            <label>Telefone </label>
                            <input name="reftelefone2" onkeypress='mascaraTelefone(this, cpfCnpj)' type="text" class="form-control" placeholder=""> 
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <label>Ref. Comercial Empresa </label>
                            <input name="refempresa3" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-4">
                            <label>Informante </label>
                            <input name="refinformante3" type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-4">
                            <label>Telefone </label>
                            <input name="reftelefone3" onkeypress='mascaraTelefone(this, cpfCnpj)' type="text" class="form-control" placeholder=""> 
                        </div>
                    </div>



                </div>

                <div role="tabpanel" class="tab-pane" id="settings">
                    <div class="row">
                        <div class="col-md-3">
                            <label>Facebook </label>
                            <div class="input-group input-group-icon">
                                <input name="facebook" type="text" class="form-control" placeholder=""> 
                                <span class="input-group-addon">
                                    <span class="icon icon-lg">
                                        <i class="fa fa-facebook"></i>
                                    </span>
                                </span>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <label>Instagram </label>
                            <div class="input-group input-group-icon">
                                <input name="instagram" type="text" class="form-control" placeholder=""> 
                                <span class="input-group-addon">
                                    <span class="icon icon-lg">
                                        <i class="fa fa-instagram"></i>
                                    </span>
                                </span>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <label>Twitter </label>
                            <div class="input-group input-group-icon">
                                <input name="twitter" type="text" class="form-control" placeholder=""> 
                                <span class="input-group-addon">
                                    <span class="icon icon-lg">
                                        <i class="fa fa-twitter"></i>
                                    </span>
                                </span>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <label>Skype </label>
                            <div class="input-group input-group-icon">
                                <input name="skype" type="text" class="form-control" placeholder=""> 
                                <span class="input-group-addon">
                                    <span class="icon icon-lg">
                                        <i class="fa fa-skype"></i>
                                    </span>
                                </span>
                            </div>
                        </div>


                    </div>

                </div>


                <div role="tabpanel" class="tab-pane" id="obs">
                    <div class="row">
                        <div class="col-md-2">
                            <label>Pendencia Financeira </label>
                            <select name="spc" class="form-control">
                                <option value=""></option>
                                <option value="S">Sim</option>
                                <option value="N">Não</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label>Data Consulta </label>
                            <input name="dataconsulta" onkeypress="mascara(this, mdata);" maxlength="10" type="text" class="form-control" placeholder=""> 
                        </div>
                        <?php
                        if ($nivelacesso->creditocliente == 'S') :
                            ?>
                            <div class="col-md-2">
                                <label>Crédito </label>
                                <input name="credito" onkeypress="mascara(this, mvalor);" type="text" value="0.00" class="form-control" placeholder=""> 
                            </div>
                            <?php
                        else :
                            ?>
                            <div class="col-md-2">
                                <label>Crédito </label>
                                <input name="credito" onkeypress="mascara(this, mvalor);" type="text" readonly="" disabled="" value="0.00" class="form-control" placeholder=""> 
                            </div>
                        <?php
                        endif;
                        ?>

                        <div class="col-md-2">
                            <label>Limite de Crédito </label>
                            <input name="limitecredito" onkeypress="mascara(this, mvalor);" type="text" value="0.00" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-2">
                            <label>Comissão(Desconto) (%)</label>
                            <input name="comissaoav" value="0.00" onkeypress="mascara(this, mvalor);"  type="text" class="form-control" placeholder=""> 
                        </div>
                        <div class="col-md-2">
                            <?php
                            $pdo = Conexao::getInstance();
                            $crud = Crud::getInstance($pdo, 'grupocliente');
                            $sql = "SELECT * from grupocliente ";
                            $arrayParam = '';
                            $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
                            ?>
                            <label>Grupo de Clientes</label>
                            <select id="grupocliente" name="grupocliente" class="form-control">
                                <option value=""></option>
                                <?php
                                foreach ($dados as $value):
                                    echo '<option value="' . $value->id . '"> ' . $value->descricao . ' </option>';

                                endforeach;
                                ?>
                            </select>
                        </div>
                    </div>

                    <div class="row">

                        <div class="col-md-2">
                            <label class="control-label">Plano de Contas</label>
                            <input type="text" onchange="PlanodeContas(this.value)" name="planodecontas" id="planodeconta" class="form-control">
                            <i style="position: absolute; right: 22px; top: 34px; cursor: pointer;" onclick="BuscaPlanodeConta()" class="fa fa-search"> </i>

                        </div>

                        <div class="col-md-10">
                            <label class="control-label">Descricao</label>
                            <input type="text" disabled="" id="planodecontadesc" class="form-control">
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <label> Corretor </label>
                        </div>
                        <div class="col-md-2">
                            <input id="corretor" name="corretor" type="text" onblur="Corretor(this.value)" class="form-control" placeholder="Cod corretor"> 
                            <i onclick="Busca('corretor')" readonly="" style="position: absolute; right: 27px; top: 12px; z-index: 999" class="fa fa-search"> </i>
                        </div>

                        <div class="col-md-10">
                            <input id="nomecorretor" readonly="" type="text"  class="form-control" placeholder="Nome Corretor"> 
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <label> Vendedor </label>
                        </div>
                        <div class="col-md-2">
                            <input id="vendedor" name="vendedor" type="text" onblur="Vendedor(this.value)" class="form-control" placeholder="Cod Vendedor"> 
                            <i onclick="Busca('vendedor')" readonly="" style="position: absolute; right: 27px; top: 12px; z-index: 999" class="fa fa-search"> </i>
                        </div>

                        <div class="col-md-10">
                            <input id="nomevendedor" type="text" readonly="" class="form-control" placeholder="Nome Vendedor"> 
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <label> Representante </label>
                        </div>
                        <div class="col-md-2">
                            <input id="representante" name="representante" onblur="Representante(this.value)" type="text"  class="form-control" placeholder="Cod Rep"> 
                            <i onclick="Busca('representante')"  style="position: absolute; right: 27px; top: 12px; z-index: 999" class="fa fa-search"> </i>
                        </div>

                        <div class="col-md-10">
                            <input id="nomerepresentante" readonly="" type="text"  class="form-control" placeholder="Nome Representante"> 
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <label>Obs </label>
                            <textarea name="obs" rows="5" name="obs" class="form-control"></textarea>
                        </div>
                    </div>
                </div>

                <div role="tabpanel" class="tab-pane" id="otica">
                    <div class="row">
                        <div class="col-md-12">
                            <table class="table table-striped table-condensed table-bordered">
                                <thead>
                                <td colspan="6" class="text-center"><B> LONGE </B></td>
                                </thead>
                                <thead>
                                <td></td>
                                <td>ESF.</td>
                                <td>CIL.</td>
                                <td>EIXO</td>
                                <td>ADIÇÃO</td>
                                <td style="width: 50%">OBS</td>
                                </thead>
                                <tr>
                                    <td>OD</td>
                                    <td><input name="odesf" type="text" class="form-control" placeholder=""></td>
                                    <td><input name="odcil" type="text" class="form-control" placeholder=""></td>
                                    <td><input name="odeixo" type="text" class="form-control" placeholder=""></td>                             
                                    <td><input name="odadicao" type="text" class="form-control" placeholder=""></td>                             
                                    <td><input name="obsod" type="text" class="form-control" placeholder=""></td>        
                                </tr>
                                <tr>
                                    <td>OE</td>
                                    <td><input name="oeesf" type="text" class="form-control" placeholder=""></td>
                                    <td><input name="oecil" type="text" class="form-control" placeholder=""></td>
                                    <td><input name="oeeixo" type="text" class="form-control" placeholder=""></td>   
                                    <td><input name="oeadicao" type="text" class="form-control" placeholder=""></td>                             
                                    <td><input name="obsoe" type="text" class="form-control" placeholder=""></td>                             
                                </tr>
                                <tr>
                                    <td colspan="5" class="text-right">DP</td>
                                    <td ><input name="ldp" type="text" class="form-control" placeholder=""></td>

                                </tr>
                            </table>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <table class="table table-striped table-condensed table-bordered">
                                <thead>
                                <td colspan="6" class="text-center"><B> PERTO </B></td>
                                </thead>
                                <thead>
                                <td></td>
                                <td>ESF.</td>
                                <td>CIL.</td>
                                <td>EIXO</td>
                                <td>ADIÇÃO</td>
                                <td style="width: 50%">OBS</td>
                                </thead>
                                <tr>
                                    <td>OD</td>
                                    <td><input name="podesf" type="text" class="form-control" placeholder=""></td>
                                    <td><input name="podcil" type="text" class="form-control" placeholder=""></td>
                                    <td><input name="podeixo" type="text" class="form-control" placeholder=""></td>                             
                                    <td><input name="podadicao" type="text" class="form-control" placeholder=""></td>                             
                                    <td><input name="pobspod" type="text" class="form-control" placeholder=""></td>      
                                </tr>

                                <tr>
                                    <td>OE</td>
                                    <td><input name="poeesf" type="text" class="form-control" placeholder=""></td>
                                    <td><input name="poecil" type="text" class="form-control" placeholder=""></td>
                                    <td><input name="poeeixo" type="text" class="form-control" placeholder=""></td>   
                                    <td><input name="poeadicao" type="text" class="form-control" placeholder=""></td>                             
                                    <td><input name="pobspoe" type="text" class="form-control" placeholder=""></td>                             
                                </tr>
                                <tr>
                                    <td colspan="5" class="text-right">DP</td>
                                    <td ><input name="pdp" type="text" class="form-control" placeholder=""></td>

                                </tr>
                            </table>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-9">
                            <label> Médico </label>
                            <input name="nomemedico" type="text" class="form-control" placeholder="">
                        </div>

                        <div class="col-md-3">
                            <label> Data Compra </label>
                            <input name="datacompra" type="text" onkeypress="mascara(this, mdata);" maxlength="10" class="form-control" placeholder=""> 
                        </div>
                    </div>
                </div>


                <div role="tabpanel" class="tab-pane" id="veiculo">
                    <div class="row">
                        <input type="hidden" id="idveic" value="0"/>
                        <button class="btn btn-primary" type="button" onclick="AddVeiculo()">Adicionar Veiculo</button>
                    </div>
<HR/>
                    <?php
                    if (isset($_GET['editar'])) :
                        ?>
                        <table class="table table-condensed table-hover table-striped table-responsive">

                            <?php
                            $pdo = Conexao::getInstance();
                            $crud = Crud::getInstance($pdo, 'endereco');
                            $sql = "SELECT * from veiculo where cliente = '" . $_GET['editar'] . "' ";
                            $arrayParam = '';
                            $dadosveic = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

                            foreach ($dadosveic as $dadosveic) :
                                ?>
                                <tr id="eveic<?= $dadosveic->veiculoid ?>">
                                    <td> <?= $dadosveic->placa ?> </td>
                                    <td> <?= $dadosveic->marca ?> </td>
                                    <td> <?= $dadosveic->modelo ?> </td>
                                    <td> <?= $dadosveic->ano ?> </td>
                                    <td> <?= $dadosveic->kmatual ?> </td>
                                    <td>
                                        <a href="javascript::" onclick="VeiculoDel('<?= $dadosveic->veiculoid ?>')" class="btn btn-danger"><i class="fa fa-trash"></i></a>
                                    </td>
                                </tr>
                                <?php
                            endforeach;
                            ?>
                        </table>
                        <?php
                    endif;
                    ?>

                    <div class="row" id="recebeveic">
                    </div>
                </div>

                <div class="panel-footer">
                    <div class="row">
                        <div class="col-md-12 text-right">
                            <a href="#" onclick="Carrega('_grid', 'cliente_grid.php', 'Cliente')" class="btn btn-warning"> <i class="fa fa-close"></i> Cancelar </a>
                            <button type="submit" id="submitButton" class="btn btn-success"> <i class="fa fa-save"></i> Salvar </button>
                        </div>
                    </div>

                </div>

            </div>
        </div>

    </div>
</form>

<script>
    $(document).ready(function () {
        // bind form using ajaxForm 
        $('#cliente').ajaxForm({
            // dataType identifies the expected content type of the server response 
            dataType: 'json',
            // success identifies the function to invoke when the server response 
            // has been received 

            beforeSubmit: function () {
                //Aqui está o que você quer
                // bloqueia o botão submit
                $("#submitButton").prop('disabled', true);
                //btnsubmit.css({backgroundColor: '#e2e2e2'});
                $("#submitButton").html("<i class='fa fa-spinner fa-spin fa-1x fa-fw'></i> Processando...");
                $("#submitButton").addClass("loading");
            },
            success: processJson
        });
    });
    function processJson(data) {
        if (data.retorno == true) {
            Carrega('_grid', 'cliente_grid.php', 'Cliente');
            document.getElementById("alerterro").style.display = "none";
            document.getElementById("alertsucesso").style.display = "block";
            $("#sucesso").html(data.mensagem);
            setTimeout(function () {
                $("#alertsucesso").css("display", "none");
            }, 7000);
        } else {
            document.getElementById("alertsucesso").style.display = "none";
            document.getElementById("alerterro").style.display = "block";
            $("#erro").html(data.mensagem);
            $("#submitButton").prop('disabled', false);
            $("#submitButton").html("<i class='fa fa-save'></i> Salvar");
            setTimeout(function () {
                $("#alerterro").css("display", "none");
            }, 7000);
        }
    }
</script>