<?php
require_once("../../../../functions.php");
require_once("../../_modal/_modal.php");
require_once "../../../../_backend/_class/Conexao_class.php";
require_once "../../../../_backend/_class/Crud_class.php";
require_once "../../../../_backend/_class/nivel_acesso.php";
?>
<script>

    $(document).ready(function () {
        $('#formmaisvendidos').on('submit', function (event) {
            if (!$('input[type="checkbox"]:checked').length) {
                event.preventDefault(); // Impede o envio do formulário
                bootbox.alert('Você deve selecionar pelo menos uma empresa!');
            }
        });
    });


    function Vendedor(valor) {
        if (valor == '') {
            return false;
        }
//        alert(valor);
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/vendedor_select_ajax.php",
            data: {
                vendedor: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#nomevendedor").val(data[0].xNome);
                    $("#vendedor").val(data[0].vendedorid);
                } else {
                    $("#vendedor").val('');
                    $("#nomevendedor").val('');
                    toastr.warning('Vendedor Não Encontrado');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }

    function Usuario(valor) {
        if (valor == '') {
            return false;
        }
//        alert(valor);
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/usuario_select_ajax.php",
            data: {
                usuario: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#nomeusuario").val(data[0].usuarionome);
                    $("#usuario").val(data[0].usuarioid);
                } else {
                    $("#usuario").val('');
                    $("#nomeusuario").val('');
                    toastr.warning('Usuário Não Encontrado');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }

    function Busca(valor) {
//        alert(valor);
        $("#busca").modal('show');
        $("#buscatitle").html('BUSCA ' + valor.toUpperCase());
        $("#carregandobusca").css("display", "block");
        $("#recebegrid").load('_backend/_view/_grid/' + valor + '_grid.php?busca=S', function () {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }


</script>

<form id="formmaisvendidos" target="_blank" action="<?= LINK ?>/_backend/_view/_relatorios/totalvendas_cadastros.php" method="POST">

    <div class="row">

        <div class="col-md-3">
            <label id="tdn">Início</label>
            <input name="datai" type="text" value="<?= date("d/m/Y") ?>" required="" onkeypress="mascara(this, mdata);" maxlength="10" class="form-control" placeholder=""> 
        </div>
        <div class="col-md-3">
            <label id="tdn">Fim</label>
            <input name="dataf" type="text" required="" value="<?= date("d/m/Y") ?>" onkeypress="mascara(this, mdata);" maxlength="10" class="form-control" placeholder=""> 
        </div>

        <div class="col-md-3">
            <label>Formato </label>
            <select name="gerar" class="form-control">
                <option value="PDF">PDF</option>
                <option value="HTML">GRÁFICO</option>
                <option value="EXCEL">EXCEL</option>
            </select>
        </div>

    </div>

    <div class="row">
        <div class="col-md-12">
            <label> Vendedor </label>
        </div>
        <div class="col-md-2">
            <input id="vendedor" name="vendedor" type="text" onblur="Vendedor(this.value)" class="form-control" placeholder=""> 
            <i onclick="Busca('vendedor')" readonly="" style="position: absolute; right: 27px; top: 12px; z-index: 999" class="fa fa-search"> </i>
        </div>

        <div class="col-md-10">
            <input id="nomevendedor" type="text" readonly="" class="form-control"> 
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <label> Usuário </label>
        </div>
        <div class="col-md-2">
            <input id="usuario" name="usuario" type="text" onblur="Usuario(this.value)" class="form-control" placeholder=""> 
            <i onclick="Busca('usuario')" readonly="" style="position: absolute; right: 27px; top: 12px; z-index: 999" class="fa fa-search"> </i>
        </div>

        <div class="col-md-10">
            <input id="nomeusuario" type="text" readonly="" class="form-control"> 
        </div>
    </div>



    <div class="row">
        <div class="col-md-12">
            <label>Empresa</label> <br/>
            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'emitente');
            $sql = "SELECT * from usuarios_empresa where usuario = '" . $_SESSION['UsuarioID'] . "'";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

            $empresas = '';
            $total = count($dados);
            $loop = 1;
            foreach ($dados as $dados) :
                $empresas .= $dados->empresa;
                if ($loop < $total) :
                    $empresas .= ',';
                endif;
                $loop++;
            endforeach;

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'emitente');
            $sql = "SELECT * from emitente where emitenteid IN($empresas)";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//        echo $sql;
            ?>


            <?php
            foreach ($dados as $dados) :
                ?>
                <label class="btn btn-default">
                    <input name="empresa[]" type="checkbox"  <?php
                    if ($_SESSION['Empresa'] === $dados->emitenteid) {
                        echo 'checked';
                    }
                    ?>  value="<?= $dados->emitenteid ?>" autocomplete="off">
                    <?= $dados->xNome ?> - <?= $dados->CNPJ ?>
                </label>	
                <?php
            endforeach;
            ?>
        </div>
    </div>


    <div class="row">
        <div class="col-md-12 text-right"> <br/>
            <button class="btn btn-info" type="submit">Gerar</button>
        </div>
    </div>

</form>