<?php
require_once("../../../../functions.php");
require_once("../../_modal/_modal.php");
require_once "../../../../_backend/_class/Conexao_class.php";
require_once "../../../../_backend/_class/Crud_class.php";
require_once "../../../../_backend/_class/nivel_acesso.php";
?>
<script>

    $(document).ready(function () {
        $('#formmaisvendidos').on('submit', function (event) {
            if (!$('input[type="checkbox"]:checked').length) {
                event.preventDefault(); // Impede o envio do formulário
                bootbox.alert('Você deve selecionar pelo menos uma empresa!');
            }
        });
    });

    function Fornecedor(valor) {
//        alert(valor);
        $("#fornecedor").val(valor);
        if (valor == '') {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/fornecedor_select_ajax.php",
            data: {
                fornecedor: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
//alert(data);
                if (data != '') {
//                    alert(data[0].xNome);
                    $("input[name='fornecedor']").val(data[0].fornecedorid);
                    $("#fornecedornome").val(data[0].xNome);
                } else {
                    toastr.warning('Fornecedor Não Encontrado!');
                    $("input[name='fornecedor']").val('');
                    $("#fornecedornome").val('');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }

    function Produto(valor) {
//        alert(valor);
        $("#produto").val(valor);
        if (valor == '') {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/produtos_select_ajax_geral.php",
            data: {
                produtos: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
//alert(data);
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#produtos").val(data[0].codigo);
                    $("#descricaoprodutos").val(data[0].descricao);
                } else {
                    toastr.warning('Produto Não Encontrado!');
                    $("#produto").val('');
                    $("#descricaoprodutos").val('');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }


    function Fornecedor(valor) {

        $.ajax({
            url: "<?= BACKEND ?>/_controller/_select/_ajax/fornecedor_select_ajax.php?fornecedor=" + valor,
            dataType: "json",
            // função para de sucesso
            success: function (data) {
                //  alert();
                if (data[0] != undefined) {
                    $("#fornecedorid").val(data[0].fornecedorid);
                    $("#nomefornecedor").val(data[0].xNome);
//                    $("#chequesemissor").val(data[0].xNome);
//                    $("#chequesdoc").val(data[0].CNPJ);
                } else {
                    toastr.warning('Nenhum Registo Encontrado!');
                    $("#fornecedorid").val('');
                    $("#nomefornecedor").val('');
//                    $("#chequesemissor").val('');
//                    $("#chequesdoc").val('');
                }
            }
        }); //termina o jquery

        $("#busca").modal('hide');


    }

    function Busca(valor) {
//        alert(valor);
        $("#busca").modal('show');
        $("#buscatitle").html('BUSCA ' + valor.toUpperCase());
        $("#carregandobusca").css("display", "block");
        $("#recebegrid").load('_backend/_view/_grid/' + valor + '_grid.php?busca=S', function () {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }

    function Grupos(valor) {
//        alert(valor);
        $("#grupo").val(valor);
        if (valor == '') {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/grupo_select_ajax.php",
            data: {
                grupos: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#grupo").val(data[0].sequencia);
                    $("#grupodescricao").val(data[0].descricao);
                } else {
                    toastr.warning('Grupo Não Encontrado!');
                    $("#grupo").val('');
                    $("#grupodescricao").val('');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }

    function Categoria(valor) {
//        alert(valor);
        $("#categoria").val(valor);
        if (valor == '') {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/categoria_select_ajax.php",
            data: {
                categorias: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#categoria").val(data[0].sigla);
                    $("#categoriadescricao").val(data[0].descricao);
                } else {
                    toastr.warning('Categoria Não Encontrado!');
                    $("#categoria").val('');
                    $("#categoriadescricao").val('');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }

    function Marca(valor) {
//        alert(valor);
        $("#marca").val(valor);
        if (valor == '') {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/marca_select_ajax.php",
            data: {
                marca: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#marca").val(data[0].id);
                    $("#marcadescricao").val(data[0].descricao);
                } else {
                    toastr.warning('Marca Não Encontrado!');
                    $("#marca").val('');
                    $("#marcadescricao").val('');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }

    function ExibeMin(valor) {
        if (valor === 'S') {
            $("#min1").show();
            $("#max1").show();
        } else {
            $("#min1").hide();
            $("#max1").hide();
        }
    }
    
    
    
</script>

<form id="formmaisvendidos" target="_blank" action="<?= LINK ?>/_backend/_view/_relatorios/sugestao_compras.php" method="POST">

    <div class="row">

        <div class="col-md-3">
            <label id="tdn">Início</label>
            <input name="datai" type="text" value="<?= date("d/m/Y") ?>" required="" onkeypress="mascara(this, mdata);" maxlength="10" class="form-control" placeholder=""> 
        </div>
        <div class="col-md-3">
            <label id="tdn">Fim</label>
            <input name="dataf" type="text" required="" value="<?= date("d/m/Y") ?>" onkeypress="mascara(this, mdata);" maxlength="10" class="form-control" placeholder=""> 
        </div>

        <div class="col-md-3">
            <label>Exibir </label>
            <select name="exibirzero" class="form-control">
                <option value="S">Sugestão com valor 0</option>
                <option value="N">Sugestão sem valor 0</option>
            </select>
        </div>

        <div class="col-md-3">
            <label>Formato </label>
            <select name="gerar" class="form-control">
                <option value="PDF">PDF</option>
                <option value="HTML">HTML</option>
                <option value="EXCEL">EXCEL</option>
            </select>
        </div>


    </div>

    <div class="row">

        <div class="col-md-3">
            <label>Min e Max </label>
            <select name="exibemin" onchange="ExibeMin(this.value)" class="form-control">
                <option value="S">Exibir</option>
                <option value="N">Não Exibir</option>
            </select>
        </div>
        


        <div class="col-md-2" id="min1">
            <label>Estoque Min %</label>                         
            <input name="min" value="30" id="min" onkeypress="mascara(this, mvalor);" type="text" class="form-control" placeholder="">                  
        </div>   
        <div class="col-md-2" id="max1">
            <label>Estoque Max %</label>                         
            <input name="max" value="150" id="max" onkeypress="mascara(this, mvalor);" type="text" class="form-control" placeholder="">                  
        </div>   
        
        <div class="col-md-3">
            <label>Estoque </label>
            <select name="exibeestoque" class="form-control">
                <option value="S">Exibir</option>
                <option value="N">Não Exibir</option>
            </select>
        </div>
        
        <div class="col-md-2">
            <label>Sugestão para (dias)</label>                         
            <input name="dias" id="dias" type="number" minlength="1" required="" class="form-control" placeholder="">                  
        </div>   
    </div>

    <div class="row">
        <div class="col-md-12">
            <label> Fornecedor </label>
        </div>
        <div class="col-md-2">
            <input id="fornecedorid" name="fornecedor" type="text" onblur="Fornecedor(this.value)" class="form-control" placeholder=""> 
            <i onclick="Busca('fornecedor')" readonly="" style="position: absolute; right: 27px; top: 12px; z-index: 999" class="fa fa-search"> </i>
        </div>

        <div class="col-md-10">
            <input id="nomefornecedor" type="text" readonly="" class="form-control" placeholder="Nome Fornecedor"> 
        </div>
    </div>

    <div class="row">
        <div class="col-md-2">
            <label>Produto </label>
            <input name="produtos" id="produtos" onblur="Produto(this.value)" type="text" class="form-control" placeholder=""> 
            <i onclick="Busca('produtos')" style="position: absolute; right: 22px; top: 37px; z-index: 9999" class="fa fa-search"> </i>
        </div>

        <div class="col-md-10">
            <label>Descrição </label>                         
            <input id="descricaoprodutos" type="text" required="" disabled="" class="form-control" placeholder="">                   
        </div>

    </div>

    <div class="row">
        <div class="col-md-12">
            <label>Empresa</label> <br/>
            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'emitente');
            $sql = "SELECT * from usuarios_empresa where usuario = '" . $_SESSION['UsuarioID'] . "'";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

            $empresas = '';
            $total = count($dados);
            $loop = 1;
            foreach ($dados as $dados) :
                $empresas .= $dados->empresa;
                if ($loop < $total) :
                    $empresas .= ',';
                endif;
                $loop++;
            endforeach;

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'emitente');
            $sql = "SELECT * from emitente where emitenteid IN($empresas)";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//        echo $sql;
            ?>


            <?php
            foreach ($dados as $dados) :
                ?>
                <label class="btn btn-default">
                    <input name="empresa[]" type="checkbox"  <?php
                    if ($_SESSION['Empresa'] === $dados->emitenteid) {
                        echo 'checked';
                    }
                    ?>  value="<?= $dados->emitenteid ?>" autocomplete="off">
                    <?= $dados->xNome ?> - <?= $dados->CNPJ ?>
                </label>	
                <?php
            endforeach;
            ?>
        </div>
    </div>


    <div class="row">
        <div class="col-md-12 text-right"> <br/>
            <button class="btn btn-info" type="submit">Gerar</button>
        </div>
    </div>

</form>