<?php
require_once("../../../../functions.php");
require_once("../../_modal/_modal.php");
require_once "../../../_class/cobranca_class.php";
?>
<form id="relatorio" action="#" method="POST">
    <div class="row">
        <div class="col-md-12">
            <div class="portlet box blue-madison">
                <div class="portlet-title">
                    <div class="tools">
                        <a href="javascript:;" class="collapse"> </a>
                        <a href="" class="fullscreen"> </a>
                    </div>

                </div>
                <div class="portlet-body">
                    <div class="scroller" style="min-height:100px" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">

                        <div class="row">

                            <div class="col-md-2">
                                <label class="control-label">Data Inicio <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="datainicio" onkeypress="mascara(this, mdata);" required="" maxlength="10" value="<?= date("d/m/Y") ?>" placeholder="" />
                            </div>

                            <div class="col-md-2">
                                <label class="control-label">Data Fim <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="datafim" onkeypress="mascara(this, mdata);" required="" maxlength="10" value="<?= date("d/m/Y") ?>" placeholder="" />
                            </div>

                            <div class="col-md-2">
                                <label class="control-label">Situação<span class="text-danger">*</span></label>
                                <select name="situacao" class="form-control">
                                    <option value="T"> Todas</option>
                                    <option value="100"> Aprovadas</option>
                                    <option value="101"> Canceladas</option>
                                    <option value="P"> Pendentes</option>
                                </select>
                            </div>

                            <div class="col-md-2">
                                <label class="control-label">Tipo<span class="text-danger">*</span></label>
                                <select name="tpNF" class="form-control">
                                    <option value="1"> Saída</option>
                                    <option value="0"> Entradas</option>
                                    <option value="T"> Todas</option>

                                </select>
                            </div>

                            <div class="col-md-2">
                                <label class="control-label">Modelo <span class="text-danger">*</span></label>
                                <select name="modelo" class="form-control">
                                    <option value="T"> Todos </option>
                                    <option value="55"> NFe </option>
                                    <option value="65"> NFCe </option>
                                    <option value="01"> NF </option>
                                    <option value="57"> CTe </option>
                                    <option value="51"> NFS </option>
                                    <option value="06"> Modelo 06 </option>
                                    <option value="22"> Modelo 22 </option>
                                </select>
                            </div>

                            <div class="col-md-2">
                                <label class="control-label">Finalidade<span class="text-danger">*</span></label>
                                <select name="finNFe" class="form-control">
                                    <option value="T"> Todas</option>
                                    <option value="1"> Normal</option>
                                    <option value="4"> Devolução</option>
                                    <option value="2"> Complementar</option>

                                </select>
                            </div>

                            <div class="col-md-2">
                                <label class="control-label">Exibir Itens<span class="text-danger">*</span></label>
                                <select name="itens" class="form-control">
                                    <option value="S"> SIM</option>
                                    <option value="N"> NÃO</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label>Forma Pag. </label>
                                <select name="indPag" class="form-control" required="">
                                    <option value="T"> Todas</option>
                                    <option value="0"> Pagamento à Vista</option>
                                    <option value="1"> Pagamento a Prazo </option>
                                </select>
                            </div>

                            <div class="col-md-2">
                                <label>Exibir Chave NF. </label>
                                <select name="exibechave" class="form-control" required="">
                                    <option value="N"> Não</option>
                                    <option value="S"> Sim</option>
                                </select>
                            </div>

                            <div class="col-md-2">
                                <label class="control-label">Tipo de Cobrança</label>
                                <select name="tipocobranca" class="form-control">
                                    <option value="">Todas</option>
                                    <?php
                                    foreach ($cobrancas as $tcobrancas) :
                                        ?>
                                        <option value="<?= $tcobrancas->sigla ?>"> <?= $tcobrancas->descricao ?> </option>
                                        <?php
                                    endforeach;
                                    ?>
                                </select>
                            </div>

                            <div class="col-md-2">
                                <label class="control-label">Formato do Relatório<span class="text-danger">*</span></label>
                                <select name="formato" class="form-control">
                                    <option value="pdf"> PDF</option>
                                    <option value="excel"> EXCEL</option>
                                    <option value="html"> HTML</option>
                                </select>
                            </div>

                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <label>CPF/CNPJ </label>
                                <input name="cliente" id="cnpj" type="text" required="" onblur="Cliente(this.value)" class="form-control" placeholder=""> 
                                <i style="position: absolute; right: 22px; top: 34px; cursor: pointer;" onclick="Busca('cliente')" class="fa fa-search"> </i>
                            </div>

                            <div class="col-md-8">
                                <label>Nome/Razao Social</label>
                                <input type="text" id="razaosocial" readonly="" class="form-control" placeholder=""> 
                            </div>

                        </div>

                    </div>
                </div>
            </div>
        </div>  
    </div>
    <hr/>
    <div class="row">
        <div class="col-md-12 text-right">
            <a href="#" onclick="Carrega('_grid', 'nfe_grid.php', 'NF-e')" class="btn btn-warning"> <i class="fa fa-close"></i> Cancelar </a>
            <a href="javascript::" onclick="carregarel()" class="btn btn-success"> <i class="fa fa-save"></i> Gerar </a>
        </div>
    </div>
</form>

<script>

    function Busca(valor) {
        $("#busca").modal('show');
        $("#buscatitle").html('BUSCA ' + valor.toUpperCase());
        $("#carregandobusca").css("display", "block");
        $("#recebegrid").load('_backend/_view/_grid/' + valor + '_grid.php?busca=S', function () {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }

    function Cliente(valor) {
//        alert(valor);
        $("#cnpj").val(valor);
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/cliente_select_ajax.php",
            data: {
                cliente: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data != null) {
//                    alert(data[0].xNome);
                    $("#cnpj").val(data[0].CNPJ);
                    $("#razaosocial").val(data[0].xNome);
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }

    function carregarel() {
        var param = 'relacao_nfe_relatorios.php?';

        var datainicio = $("input[name='datainicio']").val();
        var datafim = $("input[name='datafim']").val();
        var cliente = $("input[name='cliente']").val();
        var situacao = $("select[name='situacao']").val();
        var formato = $("select[name='formato']").val();
        var finNFe = $("select[name='finNFe']").val();
        var tpNF = $("select[name='tpNF']").val();
        var modelo = $("select[name='modelo']").val();
        var itens = $("select[name='itens']").val();
        var indPag = $("select[name='indPag']").val();
        var exibechave = $("select[name='exibechave']").val();
        var tipocobranca = $("select[name='tipocobranca']").val();
        param += 'datainicio=' + datainicio;
        param += '&datafim=' + datafim;
        param += '&cliente=' + cliente;
        param += '&situacao=' + situacao;
        param += '&formato=' + formato;
        param += '&finNFe=' + finNFe;
        param += '&tpNF=' + tpNF;
        param += '&modelo=' + modelo;
        param += '&itens=' + itens;
        param += '&indPag=' + indPag;
        param += '&exibechave=' + exibechave;
        param += '&tipocobranca=' + tipocobranca;

        window.open('_backend/_view/_relatorios/' + param + '', '',
                'height=600,width=800,scrollbars=yes,statusbar=no,resizable=no,toolbar=0');
//        Carrega('_relatorios', param, 'Relatorio')

    }
</script>