<?php
date_default_timezone_set("Brazil/East");

require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";
require_once("../../_controller/_select/nivelusuario.php");

function SomaPagar() {
    $data = date("d/m/Y");

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'lancamento');
    $totald = 0;
    $sqld = "SELECT sum(valor) as totalr from lancamento
         WHERE tipoconta='D' AND datavencimento = '$data'";
    $arrayParam = '';
    $dadosd = $crud->getSQLGeneric($sqld, $arrayParam, false);
//    echo $sqld;
    if ($dadosd->totalr) :
        $total = number_format($dadosd->totalr, 2, ',', '.');

    else :
        $total = '0,00';
    endif;

    echo $total;
}

function SomaReceber() {
    $data = date("d/m/Y");

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'lancamento');
    $totald = 0;
    $sqld = "SELECT sum(valor) as totalr from lancamento
         WHERE tipoconta='R' AND datavencimento = '$data'";
    $arrayParam = '';
    $dadosd = $crud->getSQLGeneric($sqld, $arrayParam, false);
//    echo $sqld;
    if ($dadosd->totalr) :
        $total = number_format($dadosd->totalr, 2, ',', '.');

    else :
        $total = '0,00';
    endif;

    echo $total;
}

function TotalProdutos() {

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'produtos');
    $totald = 0;
    $sqld = "SELECT count(produtoid) as totalr FROM produto";
    $arrayParam = '';
    $dadosd = $crud->getSQLGeneric($sqld, $arrayParam, false);
//    echo $sqld;
    if ($dadosd->totalr) :
        $total = $dadosd->totalr;

    else :
        $total = '0';
    endif;

    echo $total;
}

function TotalVendas() {
    $data = date("d/m/Y");
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'movsai');
    $totald = 0;
    $sqld = "SELECT sum(valortotal) as totalr FROM movsai WHERE data='$data'";
    $arrayParam = '';
    $dadosd = $crud->getSQLGeneric($sqld, $arrayParam, false);
//    echo $sqld;
    if ($dadosd->totalr) :
        $total = number_format($dadosd->totalr, 2, ',', '.');

    else :
        $total = '0';
    endif;

    echo $total;
}

function SomaReceita($valor) {
    $ano = date("Y");

    $datai = '' . $ano . '-' . $valor . '-01';
    $dataf = '' . $ano . '-' . $valor . '-31';

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'lancamento');
    $totald = 0;
    $sqld = "SELECT sum(valor) as totalr from lancamento
         WHERE tipoconta='R' AND STR_TO_DATE(datavencimento, '%d/%m/%Y') >= '{$datai}' AND STR_TO_DATE(datavencimento, '%d/%m/%Y') <= '{$dataf}'";
    $arrayParam = '';
    $dadosd = $crud->getSQLGeneric($sqld, $arrayParam, false);
//    echo $sqld;
    echo $dadosd->totalr;
}

function SomaDespesa($valor) {
    $ano = date("Y");

    $datai = '' . $ano . '-' . $valor . '-01';
    $dataf = '' . $ano . '-' . $valor . '-31';

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'lancamento');
    $totald = 0;
    $sqld = "SELECT sum(valor) as totalr from lancamento
         WHERE tipoconta='D' AND STR_TO_DATE(datavencimento, '%d/%m/%Y') >= '{$datai}' AND STR_TO_DATE(datavencimento, '%d/%m/%Y') <= '{$dataf}'";
    $arrayParam = '';
    $dadosd = $crud->getSQLGeneric($sqld, $arrayParam, false);

//    echo $sqld;
    return $dadosd->totalr;
}
?>
<script src="http://cdnjs.cloudflare.com/ajax/libs/raphael/2.1.0/raphael-min.js"></script>
<script src="http://cdn.oesmith.co.uk/morris-0.4.1.min.js"></script>
<script>

    $(document).ready(function () {

        var lineData = {
            labels: ["Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho"],
            datasets: [
                {
                    label: "Recebimentos R$",
                    backgroundColor: "rgba(26,179,148,0.5)",
                    borderColor: "rgba(26,179,148,0.7)",
                    pointBackgroundColor: "rgba(26,179,148,1)",
                    pointBorderColor: "#fff",
                    data: [<?= SomaReceita('01') ?>, <?= SomaReceita('02') ?>, <?= SomaReceita('03') ?>, <?= SomaReceita('04') ?>, <?= SomaReceita('05') ?>, <?= SomaReceita('06') ?>, <?= SomaReceita('07') ?>]
                },
                {
                    label: "Pagamentos R$",
                    backgroundColor: "rgba(220,220,220,0.5)",
                    borderColor: "rgba(220,220,220,1)",
                    pointBackgroundColor: "rgba(220,220,220,1)",
                    pointBorderColor: "#fff",
                    data: [<?= SomaDespesa('01') ?>,<?= SomaDespesa('02') ?>,<?= SomaDespesa('03') ?>,<?= SomaDespesa('04') ?>,<?= SomaDespesa('05') ?>,<?= SomaDespesa('06') ?>,<?= SomaDespesa('07') ?>]
                }
            ]
        };

        var lineOptions = {
            responsive: true
        };


        var ctx = document.getElementById("barChart").getContext("2d");
        new Chart(ctx, {type: 'bar', data: lineData, options: lineOptions});

    });


</script>


<div class="row">
    <div class="col-lg-3">
        <div class="widget style1 navy-bg">
            <div class="row">
                <div class="col-xs-4 text-center" style="margin-top: 20px;">
                    <i class="fa fa-arrow-circle-down fa-4x"></i>
                </div>
                <div class="col-xs-8 text-right" >
                    <span> Contas à Receber Hoje </span>
                    <h2 class="font-bold" style="font-size:18px">R$ <?= SomaReceber() ?></h2>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3">
        <div class="widget style1 red-bg">
            <div class="row">
                <div class="col-xs-4" style="margin-top: 20px;">
                    <i class="fa fa-arrow-circle-up fa-4x"></i>
                </div>
                <div class="col-xs-8 text-right">
                    <span> Contas à Pagar <br/>Hoje </span>
                    <h2 class="font-bold" style="font-size:18px">R$ <?= SomaPagar() ?></h2>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3">
        <div class="widget style1 lazur-bg">
            <div class="row">
                <div class="col-xs-4" style="margin-top: 20px;">
                    <i class="fa fa-cubes fa-4x"></i>
                </div>
                <div class="col-xs-8 text-right">
                    <span> Produtos cadastrados </span>
                    <h2 class="font-bold" style="font-size:18px"><?= TotalProdutos() ?></h2>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3">
        <div class="widget style1 blue-bg">
            <div class="row">
                <div class="col-xs-4" style="margin-top: 20px;">
                    <i class="fa fa fa-shopping-cart fa-4x"></i>
                </div>
                <div class="col-xs-8 text-right">
                    <span> Total  <br/> de Vendas</span>
                    <h2 class="font-bold" style="font-size:18px">R$ <?= TotalVendas() ?></h2>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="row">

    <div class="col-md-12">
        <!-- BEGIN Portlet PORTLET-->
        <div class="portlet box blue-sharp bordered">
            <div class="portlet-title">
                <div class="caption">
                    Fluxo Mensal    
                </div>
            </div>
            <div class="portlet-body">
                <canvas id="barChart" height="70"></canvas>
                <!-- END Portlet PORTLET-->
            </div>
        </div>
    </div>
</div>


<div class="row">
    <div class="col-md-6 ">
        <!-- BEGIN Portlet PORTLET-->
        <div class="portlet box blue-sharp bordered">
            <div class="portlet-title">
                <div class="caption">
                    Contas à Pagar Hoje </div>
            </div>
            <div class="portlet-body">
                <div class="scroller" style="height:200px; overflow-y: scroll" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">

                    <table class="table table-striped table-hover table-condensed">

                        <?php
                        $data = date("d/m/Y");
                        $pdo = Conexao::getInstance();
                        $crud = Crud::getInstance($pdo, 'lancamento');
                        $total = 0;
                        $sql = "SELECT * from lancamento as lancamento
                    LEFT JOIN fornecedor as fornecedor
                    ON lancamento.fornecedor = fornecedor.CNPJ
                    WHERE datavencimento ='{$data}' and tipoconta='D' and situacao = 'A'";
                        $arrayParam = '';
                        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//                    echo $sql;
                        foreach ($dados as $row) :
                            ?>
                            <tr>
                                <td><?= substr($row->xNome, 0, 25) ?></td>
                                <td><?= substr($row->historico, 0, 25) ?>.</td>
                                <td>R$ <?= number_format($row->valor, 2, ',', '.') ?></td>
                            </tr>
                            <?php
                            $total = $total + $row->valor;
                        endforeach;
                        ?>
                    </table>
                </div>
            </div>
            <div class="footer-blockt caption" style="padding: 15px; color: white;"> TOTAL: R$ <?= number_format($total, 2, ',', '.') ?> </div>
        </div>
        <!-- END Portlet PORTLET-->
    </div>

    <div class="col-md-6 ">
        <!-- BEGIN Portlet PORTLET-->
        <div class="portlet box blue-sharp bordered">
            <div class="portlet-title">
                <div class="caption">
                    Contas à Receber Hoje </div>
            </div>
            <div class="portlet-body">
                <div class="scroller" style="height:200px; overflow-y: scroll" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">

                    <table class="table table-striped table-hover table-condensed">

                        <?php
                        $data = date("d/m/Y");
                        $pdo = Conexao::getInstance();
                        $crud = Crud::getInstance($pdo, 'lancamento');
                        $total = 0;
                        $sql = "SELECT * from lancamento as lancamento
                    LEFT JOIN cliente as cliente
                    ON lancamento.cliente = cliente.CNPJ
                    WHERE datavencimento ='{$data}' and tipoconta='R' and situacao = 'A'";
                        $arrayParam = '';
                        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//                    echo $sql;
                        foreach ($dados as $row) :
                            ?>
                            <tr>
                                <td><?= substr($row->xNome, 0, 25) ?></td>
                                <td><?= substr($row->historico, 0, 25) ?>.</td>
                                <td>R$ <?= number_format($row->valor, 2, ',', '.') ?></td>
                            </tr>
                            <?php
                            $total = $total + $row->valor;
                        endforeach;
                        ?>
                    </table>
                </div>
            </div>
            <div class="footer-blockt caption" style="padding: 15px; color: white;"> TOTAL: R$ <?= number_format($total, 2, ',', '.') ?> </div>
        </div>
        <!-- END Portlet PORTLET-->
    </div>
</div>

<div class="row">

    <div class="col-md-12">
        <!-- BEGIN Portlet PORTLET-->
        <div class="portlet box blue-sharp bordered">
            <div class="portlet-title">
                <div class="caption">
                    Fluxo Mensal    
                </div>
            </div>
            <div class="portlet-body">
                <div class="scroller" style="height:200px; overflow-y: scroll" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">

                    <table class="table table-hover table-condensed">

                        <?php
                        $data = date("m/Y");
                        $pdo = Conexao::getInstance();
                        $crud = Crud::getInstance($pdo, 'lancamento');
                        $totalr = 0;
                        $totald = 0;
                        $sql = "SELECT 
  lancamento.`lancamentoid`,
  lancamento.`titulo`,
  lancamento.`parcela`,
  lancamento.`historico`,
  lancamento.`tipoconta`,
  lancamento.`tipocobranca`,
  lancamento.`dataemissao`,
  lancamento.`datavencimento`,
  lancamento.`valor`,
  lancamento.`fornecedor`,
  lancamento.`cliente`,
  lancamento.`planodecontas`,
  lancamento.`situacao`,
  lancamento.`obs`,
  cliente.CNPJ as clientecnpj, 
  cliente.xNome as clientenome, 
  fornecedor.CNPJ as fornecedorcnpj,
  fornecedor.xNome as fornecedornome
FROM 
lancamento
 LEFT JOIN cliente as cliente ON lancamento.cliente = cliente.CNPJ
 LEFT JOIN fornecedor as fornecedor ON lancamento.fornecedor = fornecedor.CNPJ
                    WHERE lancamento.datavencimento LIKE '%{$data}%' ORDER BY lancamento.datavencimento";
                        $arrayParam = '';
                        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//                    echo $sql;
                        foreach ($dados as $row) :
                            if ($row->tipoconta == 'D') :
                                ?>
                                <tr class="">
                                    <td><?= $row->datavencimento ?></td>
                                    <td><?= substr($row->fornecedornome, 0, 25) ?></td>
                                    <td><?= substr($row->historico, 0, 25) ?>.</td>
                                    <td>R$ -<?= number_format($row->valor, 2, ',', '.') ?></td>
                                    <td><i class="fa fa-money font-red"></i></td>
                                </tr>
                                <?php
                                $totald = $totald + $row->valor;
                            else :
                                ?>
                                <tr class="">
                                    <td><?= $row->datavencimento ?></td>
                                    <td><?= substr($row->clientenome, 0, 25) ?></td>
                                    <td><?= substr($row->historico, 0, 25) ?>.</td>
                                    <td>R$ <?= number_format($row->valor, 2, ',', '.') ?></td>
                                    <td><i class="fa fa-money font-green-jungle"></i></td>

                                </tr>
                                <?php
                                $totalr = $total + $row->valor;
                            endif;
                            ?>

                            <?php
                        endforeach;
                        ?>
                    </table>
                </div>
            </div>
            <div class="footer-blockt caption" style="padding: 15px; color: white;">
                <div class="text-right">
                    <div class="row">
                        <div class="col-md-6 col-lg-6 col-xs-6 col-sm-6">

                        </div>
                        <div class="col-md-3 col-lg-3 col-xs-3 col-sm-3  text-right">

                            Total Despesas: <br/>
                            Total Receitas:  <br/>
                            Total:  

                        </div>
                        <div class="col-md-3  col-lg-3 col-xs-3 col-sm-3 text-left">

                            R$ <?= number_format($totald, 2, ',', '.') ?>  <br/>
                            R$ <?= number_format($totalr, 2, ',', '.') ?>  <br/>
                            R$ <?= number_format($totalr - $totald, 2, ',', '.') ?> 

                        </div>

                    </div>
                </div>
            </div>
            <!-- END Portlet PORTLET-->
        </div>
    </div>