<?php
date_default_timezone_set("Brazil/East");

require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";
require_once("../../_controller/_select/nivelusuario.php");

function SomaReceita($valor) {
    if (strlen($valor) < '2') :
        $valor = "0" . $valor;
    endif;
    $data = date("" . $valor . "/m/Y");

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'lancamento');
    $total = 0;
    $sql = "SELECT sum(valor) as total from lancamento
                       WHERE datavencimento ='{$data}' and tipoconta='R'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    if ($dados->total <= '0') :
        $total = 0;
    else :
        $total = $dados->total;
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'lancamento');
    $totald = 0;
    $sqld = "SELECT sum(valor) as totald from lancamento
                       WHERE datavencimento ='{$data}' and tipoconta='D'";
    $arrayParam = '';
    $dadosd = $crud->getSQLGeneric($sqld, $arrayParam, false);

    if ($dadosd->totald <= '0') :
        $totald = 0;
    else :
        $totald = $dadosd->totald;
    endif;

    if ($valor == '30') :
        echo "{y: '$data ', a: '$total', b: '$totald'}";

    else :
        echo "{y: '$data ', a: '$total', b: '$totald'},";

    endif;
}
?>
<script src="http://cdnjs.cloudflare.com/ajax/libs/raphael/2.1.0/raphael-min.js"></script>
<script src="http://cdn.oesmith.co.uk/morris-0.4.1.min.js"></script>
<script>

    Morris.Bar({
        element: 'bar-example',
        data: [
<?php
for ($i = 1; $i <= 30; $i++) {
    SomaReceita($i);
}
?>
        ],
        barColors: ['#32CD32', '#ED5D5D'],
        xkey: 'y',
        ykeys: ['a', 'b'],
        labels: ['Receitas', 'Despesas']
    });
</script>
<div class="row">

    <div class="col-md-12">


        <section class="panel panel-featured panel-featured-default">
         
            <div class="panel-body">
                <div class="scroller" style="height:350px; overflow-y: scroll" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">
                    <div id="bar-example"></div>

                </div>
            </div>
        </section>


    </div>
</div>


<div class="row">
    <div class="col-md-6 ">
        <section class="panel panel-featured panel-featured-default">
            <header class="panel-heading">              
                <h2 class="panel-title">Contas à Pagar Hoje</h2>
            </header>
            <div class="panel-body">
                <div class="scroller" style="height:200px; overflow-y: scroll" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">

                    <table class="table table-striped table-hover table-condensed">

                        <?php
                        $data = date("d/m/Y");
                        $pdo = Conexao::getInstance();
                        $crud = Crud::getInstance($pdo, 'lancamento');
                        $total = 0;
                        $sql = "SELECT * from lancamento as lancamento
                    LEFT JOIN fornecedor as fornecedor
                    ON lancamento.fornecedor = fornecedor.fornecedorid
                    WHERE datavencimento ='{$data}' and tipoconta='D' and situacao = 'A'";
                        $arrayParam = '';
                        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//                    echo $sql;
                        foreach ($dados as $row) :
                            ?>
                            <tr>
                                <td><?= substr($row->xNome, 0, 25) ?></td>
                                <td><?= substr($row->historico, 0, 25) ?>.</td>
                                <td>R$ <?= number_format($row->valor, 2, ',', '.') ?></td>
                            </tr>
                            <?php
                            $total = $total + $row->valor;
                        endforeach;
                        ?>
                    </table>
                </div>
            </div>

            <div class="panel-footer bg-danger" style="padding: 15px;"> TOTAL: R$ <?= number_format($total, 2, ',', '.') ?> </div>

        </section>


    </div>

    <div class="col-md-6 ">

        <section class="panel panel-featured panel-featured-default">
            <header class="panel-heading">              
                <h2 class="panel-title">Contas à Receber Hoje</h2>
            </header>
            <div class="panel-body">
                <div class="scroller" style="height:200px; overflow-y: scroll" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">

                    <table class="table table-striped table-hover table-condensed">

                        <?php
                        $data = date("d/m/Y");
                        $pdo = Conexao::getInstance();
                        $crud = Crud::getInstance($pdo, 'lancamento');
                        $total = 0;
                        $sql = "SELECT * from lancamento as lancamento
                    LEFT JOIN cliente as cliente
                    ON lancamento.cliente = cliente.clienteid
                    WHERE datavencimento ='{$data}' and tipoconta='R' and situacao = 'A'";
                        $arrayParam = '';
                        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//                    echo $sql;
                        foreach ($dados as $row) :
                            ?>
                            <tr>
                                <td><?= substr($row->xNome, 0, 25) ?></td>
                                <td><?= substr($row->historico, 0, 25) ?>.</td>
                                <td>R$ <?= number_format($row->valor, 2, ',', '.') ?></td>
                            </tr>
                            <?php
                            $total = $total + $row->valor;
                        endforeach;
                        ?>
                    </table>
                </div>
            </div>

            <div class="panel-footer bg-success" style="padding: 15px;"> TOTAL: R$ <?= number_format($total, 2, ',', '.') ?> </div>

        </section>



    </div>
</div>

<div class="row">

    <div class="col-md-12">

        <section class="panel panel-featured panel-featured-default">
            <header class="panel-heading">              
                <h2 class="panel-title">Fluxo Mensal</h2>
            </header>
            <div class="panel-body">
                <div class="scroller" style="height:200px; overflow-y: scroll" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">

                    <table class="table table-hover table-condensed">

                        <?php
                        $data = date("m/Y");
                        $pdo = Conexao::getInstance();
                        $crud = Crud::getInstance($pdo, 'lancamento');
                        $totalr = 0;
                        $totald = 0;
                        $sql = "SELECT 
  lancamento.`lancamentoid`,
  lancamento.`titulo`,
  lancamento.`parcela`,
  lancamento.`historico`,
  lancamento.`tipoconta`,
  lancamento.`tipocobranca`,
  lancamento.`dataemissao`,
  lancamento.`datavencimento`,
  lancamento.`valor`,
  lancamento.`fornecedor`,
  lancamento.`cliente`,
  lancamento.`planodecontas`,
  lancamento.`situacao`,
  lancamento.`obs`,
  cliente.clienteid as clienteid, 
  cliente.xNome as clientenome, 
  fornecedor.fornecedorid as fornecedorid,
  fornecedor.xNome as fornecedornome
FROM 
lancamento
 LEFT JOIN cliente as cliente ON lancamento.cliente = cliente.clienteid
 LEFT JOIN fornecedor as fornecedor ON lancamento.fornecedor = fornecedor.fornecedorid
                    WHERE lancamento.datavencimento LIKE '%{$data}%' ORDER BY lancamento.datavencimento";
                        $arrayParam = '';
                        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//                    echo $sql;
                        foreach ($dados as $row) :
                            if ($row->tipoconta == 'D') :
                                ?>
                                <tr class="">
                                    <td><?= $row->datavencimento ?></td>
                                    <td><?= substr($row->fornecedornome, 0, 25) ?></td>
                                    <td><?= substr($row->historico, 0, 25) ?>.</td>
                                    <td>R$ -<?= number_format($row->valor, 2, ',', '.') ?></td>
                                    <td><i class="fa fa-money" style="color: red"></i></td>
                                </tr>
                                <?php
                                $totald = $totald + $row->valor;
                            else :
                                ?>
                                <tr class="">
                                    <td><?= $row->datavencimento ?></td>
                                    <td><?= substr($row->clientenome, 0, 25) ?></td>
                                    <td><?= substr($row->historico, 0, 25) ?>.</td>
                                    <td>R$ <?= number_format($row->valor, 2, ',', '.') ?></td>
                                    <td><i class="fa fa-money" style="color: green"></i></td>

                                </tr>
                                <?php
                                $totalr = $totalr + $row->valor;
                            endif;
                            ?>

                            <?php
                        endforeach;
                        ?>
                    </table>
                </div>
            </div>

            <div class="panel-footer" style="padding: 15px;">
                <div class="text-right">
                    <div class="row">
                        <div class="col-md-6 col-lg-6 col-xs-6 col-sm-6">

                        </div>
                        <div class="col-md-3 col-lg-3 col-xs-3 col-sm-3  text-right">

                            Total Despesas: <br/>
                            Total Receitas:  <br/>
                            Total:  

                        </div>
                        <div class="col-md-3  col-lg-3 col-xs-3 col-sm-3 text-left">

                            R$ <?= number_format($totald, 2, ',', '.') ?>  <br/>
                            R$ <?= number_format($totalr, 2, ',', '.') ?>  <br/>
                            R$ <?= number_format($totalr - $totald, 2, ',', '.') ?> 

                        </div>

                    </div>
                </div>
            </div>
        </section>


    </div>