<?php

//require_once("../../../functions.php");
require_once("../../../../../_class/Conexao_class.php");
require_once("../../../../../_class/Crud_class.php");

function Situacao($valor) {
    switch ($valor):
        case 'RP':
            return 'REPASSADO';
            break;
        case 'DP':
            return 'Depositado';
            break;
        case 'DC':
            return 'Descontado';
            break;
        case 'DV':
            return 'Devolvido';
            break;
        case 'OT':
            return 'Outros';
            break;
        case 'RB':
            return 'Recebido';
            break;
    endswitch;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cheques');

// storing  request (ie, get/post) global array to a variable  
$requestData = $_REQUEST;

$columns = array(
// datatable column index  => database column name
//    1 => 'cod_cheques',
    0 => 'chequescmc7',
    1 => 'chequescmc7',
    2 => 'chequesdataemissao',
    3 => 'chequesdatavencimento',
    4 => 'chequesrepresentante',
    5 => 'chequesemissor',
    6 => 'chequesbanco',
    7 => 'chequesnumero',
    8 => 'chequesvalor',
    9 => 'id',
    10 => 'situacao'
);

$sql = "SELECT 
  cheques.id,
  cheques.chequescmc7,
  cheques.chequesdataemissao,
  cheques.chequesdatavencimento,
  cheques.chequesemissor,
  cheques.representante,
  cheques.funcionario,
  cheques.cliente,
  cheques.fornecedor,
  cheques.chequesbanco,
  cheques.chequesnumero,
  cheques.chequesvalor,
  cheques.situacao,
  cheques.empresa,
  cliente.clienteid as clienteid, 
  cliente.xNome as clientenome, 
  representante.representanteid as representanteid,
  representante.xNome as representantenome,
  funcionario.xNome as funcionarionome,
  funcionario.funcionarioid as funcionarioid,
  fornecedor.xNome as fornecedornome,
  fornecedor.fornecedorid as fornecedorid
FROM 
cheques
 LEFT JOIN cliente as cliente ON cheques.cliente = cliente.clienteid
 LEFT JOIN representante as representante ON cheques.representante = representante.representanteid
 LEFT JOIN fornecedor as fornecedor ON cheques.fornecedor = representante.representanteid
 LEFT JOIN funcionario as funcionario ON cheques.funcionario = funcionario.funcionarioid";
$arrayParam = '';
$sql .= " WHERE 1=1 ";
if (!empty($requestData['columns'][1]['search']['value'])) {
    $sql .= " AND chequescmc7 LIKE '%" . $requestData['columns'][1]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][2]['search']['value'])) {
    $sql .= " AND chequesdataemissao LIKE '%" . $requestData['columns'][2]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][3]['search']['value'])) {
    $sql .= " AND chequesdatavencimento LIKE '%" . $requestData['columns'][3]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][4]['search']['value'])) {
    $sql .= " AND ((representante.xNome LIKE '%" . $requestData['columns'][4]['search']['value'] . "%') OR (cliente.xNome LIKE '%" . $requestData['columns'][4]['search']['value'] . "%')) ";
}

if (!empty($requestData['columns'][5]['search']['value'])) {
    $sql .= " AND chequesemissor LIKE '%" . $requestData['columns'][5]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][6]['search']['value'])) {
    $sql .= " AND chequesbanco LIKE '%" . $requestData['columns'][6]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][7]['search']['value'])) {
    $sql .= " AND chequesnumero LIKE '%" . $requestData['columns'][7]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][8]['search']['value'])) {
    $sql .= " AND chequesvalor LIKE '%" . $requestData['columns'][8]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][10]['search']['value'])) {
    $sql .= " AND situacao = '" . $requestData['columns'][10]['search']['value'] . "' ";
}


$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$totalData = count($dados);
$totalFiltered = $totalData;

if ($columns[$requestData['order'][0]['column']] == 'chequesdatavencimento') :
    $sql .= ' ORDER BY  str_to_date(chequesdatavencimento, "%d/%m/%Y") ';
    $sql .= "" . $requestData['order'][0]['dir'] . " ";
elseif ($columns[$requestData['order'][0]['column']] == 'chequesdataemissao') :
    $sql .= ' ORDER BY  str_to_date(chequesdataemissao, "%d/%m/%Y") ';
    $sql .= "" . $requestData['order'][0]['dir'] . " ";
else :
    $sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . "   " . $requestData['order'][0]['dir'] . "  ";
endif;

$sql .= " LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";

/* $requestData['order'][1]['column'] contains column index, $requestData['order'][1]['dir'] contains order such as asc/desc  */
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$data = array();
$total = 0;
foreach ($dados as $cheques) {

    $nestedData = array();
    $nestedData[] = "<input type='checkbox' class='DeleteRow' value='" . $cheques->id . "'  />";
    $nestedData[] = $cheques->chequescmc7;
    $nestedData[] = $cheques->chequesdataemissao;
    $nestedData[] = $cheques->chequesdatavencimento;
    if ($cheques->representante != "") :
        $nestedData[] = $cheques->representante . ' - ' . $cheques->representantenome;
    elseif ($cheques->cliente != "") :
        $nestedData[] = $cheques->cliente . ' - ' . $cheques->clientenome;
    elseif ($cheques->funcionario != "") :
        $nestedData[] = $cheques->funcionario . ' - ' . $cheques->funcionarionome;
    elseif ($cheques->fornecedor != "") :
        $nestedData[] = $cheques->fornecedor . ' - ' . $cheques->fornecedornome;
    else :
        $nestedData[] = '';
    endif;
    $nestedData[] = $cheques->chequesemissor;
    $nestedData[] = $cheques->chequesbanco;
    $nestedData[] = $cheques->chequesnumero;
    $nestedData[] = $cheques->chequesvalor;
    $total = $total + $cheques->chequesvalor;
    $nestedData[] = $cheques->id;
    $nestedData[] = Situacao($cheques->situacao);
    $data[] = $nestedData;
}

$json_data = array(
    "draw" => intval($requestData['draw']), // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
    "recordsTotal" => intval($totalData), // total number of records
    "recordsFiltered" => intval($totalFiltered), // total number of records after searching, if there is no searching then totalFiltered = totalData
    "data" => $data,
    "total" => 'R$ ' . number_format($total, '2', ',', '.')
);

//echo '<pre>';
//print_r($json_data);
//echo '</pre>';
echo json_encode($json_data);  // send data as json format
?>
