<?php

require_once("../../../../../../functions.php");
require_once("../../../../../_class/Conexao_class.php");
require_once("../../../../../_class/Crud_class.php");
require_once("../../../../../_class/cobranca_class.php");

function Tipo($valor) {
    switch ($valor) :
        case "R":
            return "Crédito";
            break;
        case "D":
            return "Débito";
            break;
    endswitch;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'caixa');


// storing  request (ie, get/post) global array to a variable  
$requestData = $_REQUEST;

$columns = array(
// datatable column index  => database column name
//    1 => 'cod_caixa',
    0 => 'ID',
    1 => 'data',
    2 => 'tipo',
    3 => 'historico',
    4 => 'conta',
    5 => 'tipocobranca',
    6 => 'valor',
    7 => 'valor',
    8 => 'usuario'
);


$sql = "SELECT 
        caixa.*,
        usuario.usuarionome, usuario.usuarioid
        from caixa
        LEFT JOIN usuario ON caixa.usuario = usuario.usuarioid";
$arrayParam = '';
$sql .= " WHERE 1=1 ";

$sqlCount = "SELECT COUNT(ID) as qtd FROM caixa WHERE 1=1";
// Savar as condições em uma variável só
$condicoesSQL = '';

if (!empty($requestData['columns'][1]['search']['value'])) {
    $condicoesSQL .= " AND data LIKE '%" . $requestData['columns'][1]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][2]['search']['value'])) {
    $condicoesSQL .= " AND tipo = '" . $requestData['columns'][2]['search']['value'] . "' ";
}

if (!empty($requestData['columns'][3]['search']['value'])) {
    $termos = explode(' ', $requestData['columns'][3]['search']['value']); // Divide a busca em palavras
    foreach ($termos as $termo) {
        $condicoesSQL .= " AND historico LIKE '%" . $termo . "%' ";
    }
}

if (!empty($requestData['columns'][6]['search']['value'])) {
    $condicoesSQL .= " AND valor LIKE '%" . $requestData['columns'][6]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][7]['search']['value'])) {
    $condicoesSQL .= " AND valor LIKE '%" . $requestData['columns'][7]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][5]['search']['value'])) {
    $condicoesSQL .= " AND tipocobranca = '" . $requestData['columns'][5]['search']['value'] . "' ";
}

if (!empty($requestData['columns'][4]['search']['value'])) {
    $condicoesSQL .= " AND conta LIKE '%" . $requestData['columns'][4]['search']['value'] . "%' ";
}

$condicoesSQL .= " AND caixa.empresa = '" . $_SESSION['Empresa'] . "'";
$sqlCount .= $condicoesSQL;
$dadosCount = $crud->getSQLGeneric($sqlCount, $arrayParam, TRUE);

$totalData = $dadosCount[0]->qtd;
$totalFiltered = $totalData;

// Adiciona as condições ao SQL
$sql .= $condicoesSQL;

if ($columns[$requestData['order'][0]['column']] == 'data') :
    $sql .= ' ORDER BY  str_to_date(data, "%d/%m/%Y") ';
    $sql .= "" . $requestData['order'][0]['dir'] . " ";
else :
    $sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . " " . $requestData['order'][0]['dir'];
endif;

$sql .= " LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";

//$sql.=" ORDER BY caixaid ASC LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
/* $requestData['order'][1]['column'] contains column index, $requestData['order'][1]['dir'] contains order such as asc/desc  */
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);


$data = array();
$totalc = 0;
$totald = 0;
foreach ($dados as $caixa) {

    $nestedData = array();
    $nestedData[] = "<input type='checkbox' class='DeleteRow' value='" . $caixa->ID . "'  />";
    $nestedData[] = $caixa->data;
    $nestedData[] = Tipo($caixa->tipo);
    $nestedData[] = $caixa->historico;
    $nestedData[] = $caixa->conta;
    $nestedData[] = $cobranca[$caixa->tipocobranca];
    if ($caixa->tipo == 'D') :
        $totald = $totald - $caixa->valor;
        $nestedData[] = '';
        $nestedData[] = 'R$ ' . number_format($caixa->valor, '2', ',', '.');
    else :
        $totalc = $totalc + $caixa->valor;
        $nestedData[] = 'R$ ' . number_format($caixa->valor, '2', ',', '.');
        $nestedData[] = '';
    endif;

    $nestedData[] = $caixa->usuarioid . ' - ' . $caixa->usuarionome;
    $data[] = $nestedData;
}

$json_data = array(
    "draw" => intval($requestData['draw']), // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
    "recordsTotal" => intval($totalData), // total number of records
    "recordsFiltered" => intval($totalFiltered), // total number of records after searching, if there is no searching then totalFiltered = totalData
    "data" => $data, // total data array
    "totalc" => 'R$ ' . number_format($totalc, '2', ',', '.'),
    "totald" => 'R$ ' . number_format($totald, '2', ',', '.'),
    "total" => 'R$ ' . number_format($totalc - abs($totald), '2', ',', '.')
);


//echo '<pre>';
//print_r($json_data);
//echo '</pre>';
echo json_encode($json_data);  // send data as json format
?>
