<?php
require_once "../../../../../_class/Conexao_class.php";
require_once "../../../../../_class/Crud_class.php";
require_once "../../../../../_class/cobranca_class.php";

function BuscaConta($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $sql = 'Select * FROM contas';
    $sql .= " WHERE contasid = '" . $valor . "'";
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
//echo $sql;
    return $dados->contasid . ' - ' . $dados->contasdescricao;
}

function BuscaPConta($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $sql = 'Select * FROM planodecontas';
    $sql .= " WHERE planodecontassequencia = '" . $valor . "'";
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
//echo $sql;
    return $dados->planodecontassequencia . ' - ' . $dados->planodecontasdescricao;
}

function CentroCusto($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $sql = 'Select * FROM centrodecusto';
    $sql .= " WHERE id = '" . $valor . "'";
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
//echo $sql;
    return $dados->id . ' - ' . $dados->descricao;
}

function Cliente($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $sql = 'Select * FROM cliente';
    $sql .= " WHERE clienteid = '" . $valor . "'";
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
//echo $sql;
    return $dados->xNome;
}

function Representante($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $sql = 'Select * FROM representante';
    $sql .= " WHERE representanteid = '" . $valor . "'";
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
//echo $sql;
    return $dados->xNome;
}

function Funcionario($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $sql = 'Select * FROM funcionario';
    $sql .= " WHERE funcionarioid = '" . $valor . "'";
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
//echo $sql;
    return $dados->xNome;
}

function Fornecedor($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $sql = 'Select * FROM fornecedor';
    $sql .= " WHERE fornecedorid = '" . $valor . "'";
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
//echo $sql;
    return $dados->xNome;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'baixalancamento');
$sql = "select * from lancamento where lancamentoid = '" . $_GET['lancamento'] . "'";
$arrayParam = '';
$lancamento = $crud->getSQLGeneric($sql, $arrayParam, false);
?>

<div class="row">
    <div class="col-md-2">
        <b> Nº Titulo: </b>  <?= $lancamento->titulo ?>
    </div>  
    <div class="col-md-2">
        <b> Parcela: </b>  <?= $lancamento->parcela ?>
    </div>  

    <div class="col-md-2">
        <b>Emissão: </b>  <?= $lancamento->dataemissao ?>
    </div>  

    <div class="col-md-2">
        <b>Vencimento: </b>  <?= $lancamento->datavencimento ?>
    </div>  

    <div class="col-md-2">
        <b>Valor: </b> R$ <?= number_format($lancamento->valorlancamento, 2, ',', '') ?>
    </div>  

    <div class="col-md-2">
        <b>Tipo: </b>  <?= $cobranca[$lancamento->tipocobranca] ?>
    </div>  
</div>

<div class="row">
    <div class="col-md-5">
        <?php
        if ($lancamento->para == 'C') :
            echo '<b> Cliente: </b>' . Cliente($lancamento->cliente);
        elseif ($lancamento->para == 'R') :
            echo '<b> Representante: </b>' . Representante($lancamento->representante);
        elseif ($lancamento->para == 'F') :
            if ($lancamento->tipoconta == 'D') :
                echo '<b> Fornecedor: </b>' . Fornecedor($lancamento->fornecedor);
            else :
                echo '<b> Funcionário(a): </b>' . Funcionario($lancamento->funcionario);
            endif;
        endif;
        ?>
    </div>

    <div class="col-md-3">
        <b>C. de Custo: </b> <?= CentroCusto($lancamento->centrodecusto) ?> 
    </div>
    <div class="col-md-4">
        <b>P. de Contas: </b> <?= BuscaPConta($lancamento->planodecontas) ?> 
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <b>Histórico: </b> <?= $lancamento->historico ?> 
    </div>
    <div class="col-md-6">
        <b>obs: </b> <?= $lancamento->obs ?> 
    </div>

</div>

<hr/>
<?php
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'baixalancamento');
$sql = "select lancamento.valor as valorlanc, baixalancamento.databaixa,
    baixalancamento.conta, baixalancamento.historico, baixalancamento.lancamento,
    baixalancamento.desconto, baixalancamento.multa, baixalancamento.juros, 
    baixalancamento.condpagamento, baixalancamento.baixalancamentoid, baixalancamento.valorbaixa, 
    lancamento.lancamentoid, lancamento.planodecontas, recebimento_baixa.baixalancamento,
    recebimento_baixa.descricao, recebimento_baixa.valor, recebimento_baixa.forma 
    FROM baixalancamento 
    INNER JOIN `lancamento` ON `lancamento`.`lancamentoid` = `baixalancamento`.`lancamento` 
    LEFT JOIN recebimento_baixa ON recebimento_baixa.baixalancamento = `baixalancamento`.`baixalancamentoid` 
    where `baixalancamento`.`lancamento`  = " . $_GET['lancamento'] . "";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
//echo $sql;
$totalregistro = count($dados);
$total = 0;




if ($totalregistro > 0) :
    ?>

    <table class="table table-striped table-hover table-condensed">
        <thead>
        <th></th>
        <th>Data Pagamento</th>
        <th>Forma Pag.</th>
        <th>Desconto</th>
        <th>Juros</th>
        <th>Multa</th>
        <th>Valor Pago</th>
        <th>Conta</th>
        <th>Plano De Contas</th>
    </thead>
    <tbody>
        <?php
        $totaljuros = 0;
        $totalmulta = 0;
        $totaldesconto = 0;
        $isoma = 1;
        foreach ($dados as $lancamento) {
            //DIVIDE O DESCONTO PELO NUMERO DE PARCELAS
            $lancamentodesconto = ($lancamento->desconto / $lancamento->condpagamento);
            $lancamentodesconto = number_format($lancamentodesconto, '2','.','');
            $totaldesconto = $totaldesconto + $lancamentodesconto;
            
            //DIVIDE A MULTA PELO NUMERO DE PARCELAS
            $lancamentomulta = ($lancamento->multa / $lancamento->condpagamento);
            $lancamentomulta = number_format($lancamentomulta, '2','.','');
            $totalmulta = $totalmulta + $lancamentomulta;
            
            //DIVIDE OS JUROS E SOMA NO VALOR DAS PARCELAS
            $lancamentojuros = $lancamento->juros / $lancamento->condpagamento;
            $lancamentojuros = number_format($lancamentojuros, '2','.','');
            $totaljuros = $totaljuros + $lancamentojuros;
            
            //ABATE O DESCONTO NO VALOR DO LANCAMENTO
            $valorlancamento = $lancamento->valorlanc - $lancamento->desconto;

             
            if ($isoma == $totalregistro):
                $lancamentojuros = $lancamento->juros - $totaljuros;
                $lancamentodesconto = $lancamento->desconto - $totaldesconto;
                $lancamentomulta = $lancamento->multa - $totalmulta;
            endif;
            ?>
            <tr>
                <th><button class="btn btn-warning btn-sm" title="estornar" onclick="ExtornarLancamentoBaixa('<?= $lancamento->baixalancamentoid ?>')"> <i class="fa fa-arrow-circle-left"> </i> </button></th>
                <th><?= $lancamento->databaixa ?></th>
                <th> <?= $cobranca[$lancamento->forma] ?> </th>
                <th>R$ <?= number_format($lancamentodesconto, '2', ',', '.') ?></th>
                <th>R$ <?= number_format($lancamentojuros, '2',',','.') ?></th>
                <th>R$ <?= number_format($lancamentomulta,'2',',','.') ?></th>
                <?php
                if ($total > 1) :
                    ?>
                    <th>R$ <?= number_format($lancamento->valor, '2', ',', '.') ?></th>

                    <?php
                else :
                    ?>
                    <th>R$ <?= number_format($lancamento->valorbaixa, '2', ',', '.') ?></th>

                <?php
                endif;
                ?>
                <th><?= BuscaConta($lancamento->conta) ?></th>
                <th><?= BuscaPConta($lancamento->planodecontas) ?></th>
            </tr>


            <?php
            $total = $total + $lancamentojuros + $lancamentomulta + $lancamento->valorbaixa;
        }

        $pagar = $valorlancamento - $total - $lancamentodesconto;
        $descontoto = $descontoto + $lancamentodesconto;
        if ($pagar < 0) :
            $pagar = '0,00';
        endif;
        
        $pagar_float = floatval(str_replace(',', '.', str_replace('.', '', $pagar)));


        ?>
    </tbody>

    <tfoot>
        <tr>
            <td colspan="9" class="text-right"><h5>Total do Documento: <span style="font-size: 12px;"> R$</span> <b><?= number_format($lancamento->valorlanc, '2', ',', '.') ?></b></h5></td>
        </tr>
        <Tr>
            <td colspan="9" class="text-right"><h5>Total Desconto: <span style="font-size: 12px;"> R$</span> <b>-<?= number_format($descontoto, '2', ',', '.') ?></b></h5></td>
        </Tr>
        <Tr>
            <td colspan="9" class="text-right"><h5>Total Pago: <span style="font-size: 12px;"> R$</span> <b><?= number_format($total, '2', ',', '.') ?></b></h5></td>
        </Tr>
        <Tr>
            <td colspan="9" class="text-right"><h5>Total à Pagar: <span style="font-size: 12px;"> R$</span> <b><?= number_format($pagar_float, '2', ',', '.') ?></b></h5></td>
        </Tr>

    </tfoot>
    </table>

    <?php
else :
    ?>
    <div class="alert alert-warning">
        <B>Sem informações de baixas para esse lançamento!</b>
    </div>
<?php
endif;
?>

<div class="modal-footer">
    <button type="button" class="btn dark btn-outline" data-dismiss="modal">Fechar</button>
</div>

