<?php

require_once "../../../../../_class/Conexao_class.php";
require_once "../../../../../_class/Crud_class.php";

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'nfe');
$sql = "SELECT * from lancamento WHERE lancamentoid = '" . $_GET['lancamento'] . "'";
$arrayParam = '';
$dadoslancamento = $crud->getSQLGeneric($sql, $arrayParam, false);

// Verifica se a consulta retornou resultados
if (!$dadoslancamento) {
    echo json_encode(["error" => "Lançamento não encontrado"]);
    exit;
}

// Tenta criar o objeto DateTime a partir do formato dd/mm/YYYY
$dataVencimento = DateTime::createFromFormat('d/m/Y', $dadoslancamento->datavencimento);

if(empty($_GET['intervalo'])) {
    $intervalo = 30;
} else {
    $intervalo = $_GET['intervalo'];
}

// Verifica se a conversão foi bem-sucedida
if (!$dataVencimento) {
    echo json_encode(["error" => "Formato de data inválido: " . $dadoslancamento->datavencimento]);
    exit;
}

$parcela = 2;
for ($i = 0; $i < $_GET['quantidade']; $i++) :
    // Cria um novo objeto DateTime para cada parcela, clonando o original
    $dataParcela = clone $dataVencimento;

    // Adiciona o intervalo de dias (30 dias * número da parcela)
    $dataParcela->add(new DateInterval('P' . ($i + 1) * $intervalo . 'D'));

    $reg[] = array(
        "parcela" => $parcela,
        "data" => $dataParcela->format('d/m/Y'), // Formato correto da data
        "valor" => number_format($dadoslancamento->valor, 2, '.', '')
    );
    $parcela++;
endfor;

echo json_encode($reg);
?>