function limpa_formulário_cep(prev) {
    // Limpa valores do formulário de cep.
    $("#" + prev + "xlgr").val("");
    $("#" + prev + "xbairro").val("");
    $("#" + prev + "xmun").val("");
    $("#" + prev + "xcmun").val("");
    $("#" + prev + "uf").val("");
}

//Quando o campo cep perde o foco.
function BuscaCep(valor, prev) {

    //Nova variável "cep" somente com dígitos.
    var cep = valor.replace(/\D/g, '');

    //Verifica se campo cep possui valor informado.
    if (cep != "") {

        //Expressão regular para validar o CEP.
        var validacep = /^[0-9]{8}$/;

        //Valida o formato do CEP.
        if (validacep.test(cep)) {

            //Preenche os campos com "..." enquanto consulta webservice.
            $("#" + prev + "xlgr").val("...")
            $("#" + prev + "xbairro").val("...")
            $("#" + prev + "xmun").val("...")
            $("#" + prev + "xuf").val("...")
            $("#" + prev + "cmun").val("...")

            //Consulta o webservice viacep.com.br/
            $.getJSON("//viacep.com.br/ws/" + cep + "/json/?callback=?", function (dados) {

                if (!("erro" in dados)) {
                    //Atualiza os campos com os valores da consulta.
                    $("#" + prev + "xlgr").val(dados.logradouro);
                    $("#" + prev + "xbairro").val(dados.bairro);
                    $("#" + prev + "xmun").val(dados.localidade);
                    $("#" + prev + "uf").val(dados.uf);
                    $("#" + prev + "cmun").val(dados.ibge);
                } //end if.
                else {
                    //CEP pesquisado não foi encontrado.
                    limpa_formulário_cep();
                    alert("CEP não encontrado.");
                }
            });
        } //end if.
        else {
            //cep é inválido.
            limpa_formulário_cep();
            alert("Formato de CEP inválido.");
        }
    } //end if.
    else {
        //cep sem valor, limpa formulário.
        limpa_formulário_cep(prev);
    }
}

function vicmst(valor) {
    if (valor == '00') {
        document.getElementById("icms").style.display = 'Block';
        document.getElementById("percenticms").style.display = 'none';
        document.getElementById("creditoicms").style.display = 'none';
    } else if (valor == '20') {
        document.getElementById("icms").style.display = 'Block';
        document.getElementById("percenticms").style.display = 'Block';
        document.getElementById("creditoicms").style.display = 'none';
    } else if (valor == '60') {
        document.getElementById("icms").style.display = 'block';
        document.getElementById("percenticms").style.display = 'none';
        document.getElementById("creditoicms").style.display = 'Block';
    } else if (valor == '90') {
        document.getElementById("icms").style.display = 'Block';
        document.getElementById("percenticms").style.display = 'Block';
        document.getElementById("creditoicms").style.display = 'Block';
    } else {
        document.getElementById("icms").style.display = 'none';
    }
}



function ExcluirLacre(valor) {
    $("#lc" + valor + "").remove();
}


function Lacre() {

    var total = $("#vlrlacre").val();
    if (total == '') {
        id = 1;
    } else {
        var id = total + 1;
    }

    var conteudo = "<div id='lc" + id + "'>" +
            "<div class='col-md-10'>" +
            "<label><span class='label label-default'>* Lacre</span> </label>" +
            "<input type='text' name='nlacre[]' class='form-control'>" +
            "</div>" +
            "<div class='col-md-2'> <br/>" +
            " <a href = '#' class='btn btn-danger btn-sm' onclick='ExcluirLacre(" + id + ")'> <i class ='fa fa-trash'></i> </a>  <br> <br>" +
            "</div>" +
            "<hr/>" +
            "</div>";
    $("#lacredoc").append(conteudo);
    $("#vlrlacre").val(id);
}

function Motorista() {

    var total = $("#vlrmotorista").val();
    if (total == '') {
        id = 1;
    } else {
        var id = total + 1;
    }

    var conteudo = "<div id='lc" + id + "'>" +
            "<div class='col-md-12'>" +
            "<label><span class='label label-default'>* Nome</span> </label>" +
            "<input type='text' name='motnome[]' class='form-control'>" +
            "</div>" +
            "<div class='col-md-10'>" +
            "<label><span class='label label-default'>* CPF</span> </label>" +
            "<input type='text' name='motcpf[]' class='form-control'>" +
            "</div>" +
            "<div class='col-md-2'> <br/>" +
            " <a href = '#' class='btn btn-danger btn-sm' onclick='ExcluirLacre(" + id + ")'> <i class ='fa fa-trash'></i> </a>  <br> <br>" +
            "</div>" +
            "<hr/>" +
            "</div>";
    $("#motoristadoc").append(conteudo);
    $("#vlrmotorista").val(id);
}


function ExcluirSeg(valor) {
    $("#seg" + valor + "").remove();
}


function Seg() {

    var total = $("#vlrsegdoc").val();
    if (total == '') {
        id = 1;
    } else {
        var id = total + 1;
    }

    var conteudo = "<div id='seg" + id + "'>" +
            "<div class='col-md-3'>" +
            "<label><span class='label label-default'>* Responsável</span> </label>" +
            "<select name='respseg[]' class='form-control'>" +
            "<option value='0'>Remetente </option>" +
            "<option value='1'>Expedidor </option>" +
            "<option value='2'>Recebedor </option>" +
            "<option value='3'>Destinatário </option>" +
            "<option value='4'>Emitente do Ct-e </option>" +
            "<option value='5'>Tomador de Serviço </option>" +
            "</select>" +
            "</div>" +
            "<div class='col-md-2'>" +
            "<label><span class='label label-default'>* Nome Seguradora</span> </label>" +
            "<input type='text' name='xseg[]' class='form-control'>" +
            "</div>" +
            "<div class='col-md-2'>" +
            "<label><span class='label label-default'>* Nº Apólice</span> </label>" +
            "<input type='text' name='napol[]' class='form-control'>" +
            "</div>" +
            "<div class='col-md-2'>" +
            "<label><span class='label label-default'>* Nº averbação</span> </label>" +
            "<input type='text' name='naver[]' class='form-control'>" +
            "</div>" +
            "<div class='col-md-2'>" +
            "<label><span class='label label-default'>* Valor Merc. Efetivo Averbação</span> </label>" +
            "<input type='text' name='segvmerc' class='form-control dec'>" +
            "</div>" +
            "<div class='col-md-1'> <br/>" +
            " <a href = '#' class='btn btn-danger btn-sm' onclick='ExcluirSeg(" + id + ")'> <i class ='fa fa-trash'></i> </a>  <br> <br>" +
            "</div>" +
            "<hr/>" +
            "</div>";


    $("#segdoc").append(conteudo);
    $("#vlrsegdoc").val(id);
}

function ExcluirNF(valor) {
    $("#nf" + valor + "").remove();
}

function NF() {

    var html = $("#nfdoc").html();
    var total = $("#vlrnfdoc").val();
    if (total == '') {
        id = 1;
    } else {
        var id = total + 1;
    }
    var conteudo = " <div id='nf" + id + "'>" +
            "<div class='row'>" +
            "<div class='col-md-2'>" +
            "<label><span class='label label-default'>* Série</span> </label>" +
            "<input type='text' name='nfserie[]' class='form-control'>" +
            "</div>" +
            "<div class='col-md-3'>" +
            "<label><span class='label label-default'>* Número</span> </label>" +
            "<input type='text' name='nfndoc[]' class='form-control'>" +
            "</div>" +
            "<div class='col-md-2'>" +
            "<label><span class='label label-default'>* Data Emissão</span> </label>" +
            "<input type='text' name='nfdemi[]'  class='form-control datetimepicker3'>" +
            "</div>" +
            "<div class='col-md-2'>" +
            "<label><span class='label label-default'>* CFOP</span> </label>" +
            "<input type='text' name='nfncfop[]' class='form-control'>" +
            "</div>" +
            "<div class='col-md-3'>" +
            "<label><span class='label label-default'>* Modelo</span> </label>" +
            "<select name='nfmod' class='form-control'>" +
            "<option>01- NF Mod 01/1A e Avulsa</option>" +
            "<option>04- NF de Produtor</option>" +
            "</select>" +
            "</div>" +
            "</div>" +
            "<div class='row'>" +
            "<div class='col-md-2'>" +
            "<label><span class='label label-default'>* Base ICMS</span> </label>" +
            "<input type='text' name='nfvbc[]' class='form-control dec'>" +
            "</div>" +
            "<div class='col-md-2'>" +
            "<label><span class='label label-default'>* Valor ICMS</span> </label>" +
            "<input type='text' name='nfvicms[]' class='form-control dec'>" +
            "</div>" +
            "<div class='col-md-2'>" +
            "<label><span class='label label-default'>* Base ICMS ST</span> </label>" +
            "<input type='text' name='nfvbcst[]' class='form-control dec'>" +
            "</div>" +
            "<div class='col-md-2'>" +
            "<label><span class='label label-default'>* Valor ICMS ST</span> </label>" +
            "<input type='text' name='nfvst[]' class='form-control dec'>" +
            "</div>" +
            "<div class='col-md-2'>" +
            "<label><span class='label label-default'>* Valor Produtos</span> </label>" +
            "<input type='text' name='nfvprod[]' class='form-control'>" +
            "</div>" +
            "<div class='col-md-2'>" +
            "<label><span class='label label-default'>* Valor da Nota</span> </label>" +
            "<input type='text' name='nfvnf[]' class='form-control dec'>" +
            "</div>" +
            "<div class='col-md-2'> <br/>" +
            " <a href = '#' class='btn btn-danger btn-sm' onclick='ExcluirNF(" + id + ")'> <i class ='fa fa-trash'></i> </a>  <br> <br>" +
            "</div>" +
            "</div>" +
            "<hr/>" +
            "</div>";
    $("#nfdoc").append(conteudo);
    $("#vlrnfdoc").val(id);
}

function Excluir(valor) {
    $("#" + valor + "").remove();
}

function Adicionar() {

    var total = $("#vlrqtdcarga").val();
    if (total == '') {
        id = 1;
    } else {
        var id = total + 1;
    }
    var conteudo = "<div class='row' id='" + id + "'>" +
            "<div class='col-md-4'> <label class='control-label'><span class='label label-default'>Cod Un Medida </span></label>" +
            "<select name='cunid[]' class='form-control'>" +
            "<option value='00'> M3 </option>" +
            "<option value='01'> KG </option>" +
            "<option value='02'> TON </option>" +
            "<option value='03'> UN </option>" +
            "<option value='04'> LITROS </option>" +
            "<option value='05'> MMBTU </option>" +
            "</select>" +
            "</div>" +
            "<div class='col-md-3' >" +
            "<label class='control-label'><span class='label label-default'>* Tipo da Medida </span></label>" +
            "<input type='text' class='form-control' placeholder='' name='tpmed[]' />" +
            "</div>" +
            "<div class='col-md-4'> <label class='control-label'><span class='label label-default'>* Quantidade</span></label>" +
            "<input type='text' class='form-control' placeholder='' name='qcarga[]' />" +
            "</div>  " +
            "<div class='col-md-1'>" +
            " <label class='control-label'></label>  <br/>  " +
            " <a href = '#' class='btn btn-danger btn-sm' onclick='Excluir(" + id + ")'> <i class ='fa fa-trash'></i> </a>  <br> <br>" +
            " </div> " +
            " </div> ";
    $("#qtdcarga").append(conteudo);
    $("#vlrqtdcarga").val(id);
}


function tomador(valor) {
    if (valor == '4') {
        document.getElementById("identificacao").style.display = 'Block';
    } else {
        document.getElementById("identificacao").style.display = 'none';
    }
}

function remetente(valor) {
    if (valor == '0') {
        document.getElementById("remetente").style.display = 'Block';
    } else {
        document.getElementById("remetente").style.display = 'none';
    }
}


function expedidor(valor) {
    if (valor == '1') {
        document.getElementById("expedidor").style.display = 'Block';
    } else {
        document.getElementById("expedidor").style.display = 'none';
    }
}

function recebedor(valor) {
    if (valor == '1') {
        document.getElementById("recebedor").style.display = 'Block';
    } else {
        document.getElementById("recebedor").style.display = 'none';
    }
}

function destinatario(valor) {
    if (valor == '0') {
        document.getElementById("destinatario").style.display = 'Block';
    } else {
        document.getElementById("destinatario").style.display = 'none';
    }
}

$('#cobicms').click(function () {
    $('#cobicmso').toggle(1000);
});

vicmst('40');