<?php
ob_start();
require_once("../../functions.php");
require_once("../../validacao.php");
require_once("../_class/Conexao_class.php");
require_once("../_class/Crud_class.php");
require_once("../../nfephp-master-06-2018/vendor/mpdf/mpdf/mpdf.php");

function FormaPag($valor) {
    switch ($valor) :
        case 'D':
            return 'Dinheiro';
            break;
        case 'CC':
            return 'Cartão de Crédito';
            break;
        case 'CD':
            return 'Cartão de Débito';
            break;
        case 'C':
            return 'Cheque';
            break;
        case 'B':
            return 'Boleto';
            break;
        case 'NP':
            return 'Nota Promissória';
            break;
    endswitch;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'emitente');
$sql = "SELECT * FROM emitente";
$arrayParam = '';
$emitente = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'movsai');
$sql = "SELECT * FROM movsai where idmovsai = " . $_GET['movsai'] . "";
$arrayParam = '';
$movsai = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');
$sql = "SELECT * FROM cliente where CNPJ = " . $movsai->clientedoc . "";
$arrayParam = '';
$cliente = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'itmovsai');
$sql = "SELECT * FROM itmovsai where movsai = " . $_GET['movsai'] . " ORDER BY itmovsai ASC";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'pagmovsai');
$sql = "SELECT * FROM pagmovsai where movsai = " . $_GET['movsai'] . "";
$arrayParam = '';
$pagmovsai = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

function BuscaUsuario($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'usuario');
    $sql = "SELECT * FROM usuario where usuarioid = " . $valor . "";
    $arrayParam = '';
    $user = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $user->usuarionome;
}

//echo '<pre>';
//print_r($dados);
//echo '</pre>';
?>
<link href="<?= FRONTEND ?>/global/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
<link href="<?= FRONTEND ?>/global/css/bootstrap-print.min.css" rel="stylesheet" type="text/css"/>
<link href="<?= FRONTEND ?>/global/css/bootstrap-print.less" rel="stylesheet" type="text/css"/>
<style>
    body {
        font-size: 14px;
    }
    table {
        font-size: 14px;
    }
    @media print {
        .table {
            font-size: 10px;
        }

        .body {
            margin-left: 1px;
            margin-right: 1px;
        }

        @page :left {
            margin-left: 1px;
            margin-right: 1px;
        }

        @page :right {
            margin-left: 1px;
            margin-right: 1px;
        }
    }
</style>

<?php
if (isset($_GET['pedido'])):
    $titulo = 'ORÇAMENTO DE VENDA';
else :
    $titulo = 'ROMANEIO DE VENDA';

endif;
?>
<div class="container-fluid">
    <table class="table">
        <tr>
            <td>
                <img src="<?= FRONTEND ?>/img/<?= $emitente->CNPJ ?>/<?= $emitente->logo ?>" height="60px;" alt=""/>
            </td>
            <td>
                <h3 class="text-center"><?= $titulo ?> <br/> <small style="font-size: 12px;">Este documento não é valido como documento fiscal.</small></h3>
            </td>
            <td> 
                <h6>
                    <b>Emissão: </b><?= $movsai->data ?> <br/>
                    <b>Documento: </b><?= $movsai->idmovsai ?><br/>
                    <b>Vendedor: </b><?= BuscaUsuario($movsai->usuario) ?>
                </h6>
            </td>
        </tr>
    </table> 

    <table class="table ">
        <tr>
            <td>
                <b>Empresa: </b> <?= $emitente->xNome ?><Br/>
                <b>Endereço: </b> <?= $emitente->xLgr ?>, nº <?= $emitente->nro ?> <?= $emitente->xCpl ?>
                <b>Bairro: </b> <?= $emitente->xBairro ?> <br/>
                <b>Cidade: </b> <?= $emitente->xMun ?> - <?= $emitente->UF ?><br/>
                <b>Telefone: </b> <?= $emitente->fone ?>
            </td>
            <td>
                <?php
                if ($cliente->xNome == '') :
                    ?>
                    <b>Cliente: </b> <?= $movsai->clientenome ?><Br/>
                    <?php
                else :
                    ?>
                    <b>Cliente: </b> <?= $cliente->xNome ?><Br/>
                    <b>Endereço: </b> <?= $cliente->xLgr ?>, nº <?= $cliente->nro ?> <?= $cliente->xCpl ?>
                    <b>Bairro: </b> <?= $cliente->xBairro ?> <br/>
                    <b>Cidade: </b> <?= $cliente->xMun ?> - <?= $cliente->UF ?><br/>
                    <b>Telefone: </b> <?= $cliente->fone ?>
                <?php
                endif;
                ?>
            </td>
        </tr>
    </table>
    <table class='table table-striped table-bordered'>
        <tr>
            <th>Ítem</th>
            <th>Cód.</th>
            <th>Desc.</th>
            <th>Qtd</th>
            <th>Valor (R$)</th>
            <th>Valor Total (R$)</th>
        </tr>
        <tbody>
            <?php
            foreach ($dados as $resultado) {
                echo '<tr>';
                echo '<td> ' . $resultado->nitem . ' </td>';
                echo '<td> ' . $resultado->produto . ' </td>';
                echo '<td> ' . $resultado->xProd . ' </td>';
                echo '<td> ' . $resultado->qtd . ' </td>';
                echo '<td>R$ ' . number_format($resultado->valorproduto, 2, ',', '.') . ' </td>';
                echo '<td>R$ <input class="vtotal" type="hidden" disabled="" value="' . $resultado->valortotal . '"> ' . number_format($resultado->valortotal, 2, ',', '.') . ' </td>';
                echo '</tr>';
            }
            ?>
        </tbody>

    </table>

    <table class='table table-striped'>
        <tfoot>
            <tr>
                <th class="text-right"> <h6> Total............:   R$ <?= number_format($movsai->valortotal, 2, ',', '.') ?></h6></th>
            </tr>
            <tr>
                <th class="text-right"><h6> Desconto......: R$ -<?= number_format($movsai->desconto, 2, ',', '.') ?> </h6></th>
            </tr>
            <tr>
                <th class="text-right"><h6> Total Pago....: R$ <?= number_format($movsai->valorpago, 2, ',', '.') ?> </h6></th>
            </tr>
        </tfoot>

    </table>



    <table class='table table-striped table-bordered'>
        <tr>
            <th>Parcela</th>
            <th>Forma Pag.</th>
            <th>Vencimento</th>
            <th>Valor</th>
        </tr>
        <tbody>
            <?php
            foreach ($pagmovsai as $resultado) :
                echo '<tr>';
                echo '<td> ' . $resultado->parcela . ' </td>';
                echo '<td> ' . FormaPag($resultado->formapag) . ' </td>';
                echo '<td> ' . $resultado->datavencimento . ' </td>';
                echo '<td>R$ ' . number_format($resultado->valor, 2, ',', '.') . ' </td>';
                echo '</tr>';
            endforeach;
            ?>
        </tbody>
    </table>
</div>
<?php
$html = ob_get_clean();
// pega o conteudo do buffer, insere na variavel e limpa a memória
//$html = utf8_encode($html);
// converte o conteudo para uft-8
$mpdf = new mPDF('', 'A4', 10, 'DejaVuSansCondensed');
// cria o objeto
$mpdf->allow_charset_conversion = true;
// permite a conversao (opcional)
//$mpdf->charset_in='UTF-8';
// converte todo o PDF para utf-8
$mpdf->WriteHTML($html);
// escreve definitivamente o conteudo no PDF
$mpdf->Output("romaneio.pdf", 'I');
// imprime

exit();
?>