<?php

//require_once("../../../functions.php");
require_once("../../../_class/Conexao_class.php");
require_once("../../../_class/Crud_class.php");
require_once("../../../../_backend/_class/parametros.php");

function Para($valor) {
    if ($valor == 'R') :
        return 'Representante';
    elseif ($valor == 'F') :
        return 'Funcionário';
    else :
        return 'Cliente';
    endif;
}

function Situacao($valor) {
    if ($valor == 'A') :
        return 'Aberta';
    elseif ($valor == 'C') :
        return 'Cancelada';
    else :
        return 'Fechada';
    endif;
}

function Tipo($valor) {
    if ($valor == 'S') :
        return 'Direta';
    elseif ($valor == 'R') :
        return 'S.Remessa';
    elseif ($valor == 'O') :
        return 'Orçamento';
    else :
        return 'Consignada';
    endif;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'separacao');


// storing  request (ie, get/post) global array to a variable  
$requestData = $_REQUEST;

$columns = array(
// datatable column index  => database column name
//    1 => 'cod_separacao',
    1 => 'documento',
    2 => 'data',
    3 => 'para',
    4 => 'cliente',
    5 => 'valor',
    6 => 'situacao',
    7 => 'tipo',
    9 => 'controle'
);


$sql = "select separacao.`documento`, separacao.data, separacao.hora, separacao.controle, separacao.para,separacao.vendedor, 
separacao.`representante`, separacao.cliente, separacao.funcionario,separacao.troco, separacao.motivocancelado,
separacao.`valorpago`, separacao.`valortotal`,  separacao.`tipo`, separacao.situacao, separacao.empresa, separacao.doc_empresa,
`representante`.`representanteid`, `representante`.`xNome` as xNomeR, representante.`xFant` as xFantR, 
cliente.`clienteid`, cliente.`xNome` as xNomeC, cliente.`xFant` as xFantC, 
funcionario.`funcionarioid`, funcionario.`xNome` as xNomeF, funcionario.`xFant` as xFantF
From `separacao`
LEFT JOIN `representante` ON `representante`.`representanteid` = `separacao`.`representante`
LEFT JOIN cliente ON `cliente`.`clienteid` = `separacao`.`cliente`
LEFT JOIN funcionario on `funcionario`.`funcionarioid` = `separacao`.`funcionario` ";
$arrayParam = '';
$sql .= " WHERE 1=1 AND separacao.empresa = '" . $_SESSION['Empresa'] . "'";

if (!empty($requestData['columns'][1]['search']['value'])) {
    $sql .= " AND doc_empresa LIKE '%" . $requestData['columns'][1]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][2]['search']['value'])) {
    $sql .= " AND data LIKE '%" . $requestData['columns'][2]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][3]['search']['value'])) {
    $sql .= " AND para LIKE '%" . $requestData['columns'][3]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][4]['search']['value'])) {
    $sql .= " AND ((representante.`xNome` LIKE '%" . $requestData['columns'][4]['search']['value'] . "%') OR (cliente.`xNome` LIKE '%" . $requestData['columns'][4]['search']['value'] . "%') OR (funcionario.`xNome` LIKE '%" . $requestData['columns'][4]['search']['value'] . "%')) ";
}

if (!empty($requestData['columns'][5]['search']['value'])) {
    $sql .= " AND valorpago LIKE '%" . $requestData['columns'][5]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][6]['search']['value'])) {
    $sql .= " AND situacao LIKE '%" . $requestData['columns'][6]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][7]['search']['value'])) {
    $sql .= " AND separacao.tipo = '" . $requestData['columns'][7]['search']['value'] . "' ";
}

if (!empty($requestData['columns'][9]['search']['value'])) {
    $sql .= " AND separacao.tipo = '" . $requestData['columns'][9]['search']['value'] . "' ";
}


//echo $sql;
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
$totalData = count($dados);
$totalFiltered = $totalData;

$sql .= " ORDER BY doc_empresa DESC LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
/* $requestData['order'][1]['column'] contains column index, $requestData['order'][1]['dir'] contains order such as asc/desc  */
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$total = 0;
$data = array();
foreach ($dados as $movimentacao) {
    $nestedData = array();
    $nestedData[] = "<input type='checkbox' class='DeleteRow' value='" . $movimentacao->documento . "' onclick=' SetSel(this);' />";
    $nestedData[] = $movimentacao->doc_empresa;
    $nestedData[] = $movimentacao->data;
    $nestedData[] = Para($movimentacao->para);
    if ($movimentacao->situacao == 'C') :
        $nestedData[] = $movimentacao->xNomeR . $movimentacao->xNomeC . $movimentacao->xNomeF . '  <b>(' . $movimentacao->motivocancelado . ') </b>';
    else :
        $nestedData[] = $movimentacao->xNomeR . $movimentacao->xNomeC . $movimentacao->xNomeF;
    endif;
    $total = $total + ($movimentacao->valortotal - $movimentacao->desconto);
    $nestedData[] = 'R$ ' . number_format($movimentacao->valortotal - $movimentacao->desconto, $parametros->casadecimal, ',', '.');
    $nestedData[] = Situacao($movimentacao->situacao);
    $nestedData[] = Tipo($movimentacao->tipo);
//    $nestedData[] = Tipo($movimentacao->tipo);
    $nestedData[] = $movimentacao->documento;
    $nestedData[] = $movimentacao->controle;

    $data[] = $nestedData;
}

$json_data = array(
    "draw" => intval($requestData['draw']), // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
    "recordsTotal" => intval($totalData), // total number of records
    "recordsFiltered" => intval($totalFiltered), // total number of records after searching, if there is no searching then totalFiltered = totalData
    "data" => $data, // total data array
    "total" => 'R$ ' . number_format($total, '2', ',', '.')
);


//echo '<pre>';
//print_r($json_data);
//echo '</pre>';
echo json_encode($json_data);  // send data as json format
?>
