<?php

//require_once("../../../functions.php");
require_once("../../../_class/Conexao_class.php");
require_once("../../../_class/Crud_class.php");
require_once("../../../_class/parametros.php");

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'produtos');

// storing  request (ie, get/post) global array to a variable  
$requestData = $_REQUEST;

$columns = array(
// datatable column index  => database column name
//    1 => 'cod_produto',
    0 => 'codigo',
    1 => 'codigo',
    2 => 'ref',
    3 => 'descricao',
    4 => 'custo',
    5 => 'valor',
    6 => 'estoque',
    7 => 'xFant'
);

function Preco($produto, $tbpadrao) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoque');
    $sql = "SELECT * from precoprodutos where produto = '$produto' and tabela = '$tbpadrao'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->valor;
}

function Barras($produto) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoque');
    $sql = "SELECT * from estoqueprodutos where barras = '$produto'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->produto;
}

function Estoque($cProd) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoque');
    $sql = "SELECT sum(" . $_SESSION['Estoque'] . ") as total from estoqueprodutos WHERE produto = '" . $cProd . "'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    if ($dados->total != '') :
        return $dados->total;
    else :
        return '0';
    endif;
}

//$sql = "SELECT * from produtos ";
$sql = "SELECT produtos.codigo, produtos.ref, produtos.descricao,
    produtos.custo, produtos.classificacao, produtos.fiscal, produtos.fornecedor,
    produtos.promocao, precoprodutos.produto, precoprodutos.tabela, precoprodutos.valor,
    fornecedor.fornecedorid, fornecedor.xFant
    from produtos 
    LEFT JOIN precoprodutos ON produtos.codigo = precoprodutos.produto
    LEFT JOIN fornecedor ON produtos.fornecedor = fornecedor.fornecedorid
    ";
$arrayParam = '';
$sql .= " Where tabela = '$tabela'";
if (!empty($requestData['columns'][1]['search']['value'])) {
    $barras = Barras($requestData['columns'][1]['search']['value']);
    if ($barras != '') :
        $sql .= " AND codigo = '$barras' ";
    else :
        $sql .= " AND codigo LIKE '%" . $requestData['columns'][1]['search']['value'] . "%' ";
    endif;
}

if (!empty($requestData['columns'][2]['search']['value'])) {
    $sql .= " AND ref LIKE '%" . $requestData['columns'][2]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][3]['search']['value'])) {
    $termos = explode(' ', $requestData['columns'][3]['search']['value']); // Divide o texto em palavras
    // Monta a consulta com like em todas as palavras para buscar em qualquer ordem que forem digitadas
    foreach ($termos as $termo) {
        $sql .= " AND descricao LIKE '%" . $termo . "%' ";
    }
}

if (!empty($requestData['columns'][4]['search']['value'])) {
    $custo = str_replace(',', '.', $requestData['columns'][4]['search']['value']);
    $sql .= " AND custo LIKE '%" . $custo . "%' ";
}

if (!empty($requestData['columns'][5]['search']['value'])) {
    $valor = str_replace(',', '.', $requestData['columns'][5]['search']['value']);
    $sql .= " AND valor LIKE '%" . $valor . "%' ";
}

if (!empty($requestData['columns'][6]['search']['value'])) {
    $sql .= " AND estoque LIKE '%" . $requestData['columns'][6]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][7]['search']['value'])) {
    $sql .= " AND xFant LIKE '%" . $requestData['columns'][7]['search']['value'] . "%' ";
}

if ($parametros->pcp == 'S') :
    $sql .= " AND classificacao <> '03' AND classificacao <> '11'";
endif;

if ($parametros->separaprodutos == 'S') :
    $sql .= " AND fiscal = '$parametros->fiscal'";
endif;

$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$totalData = count($dados);
$totalFiltered = $totalData;

if ($requestData['length'] < 0) :
    $sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . " " . $requestData['order'][0]['dir'] . "";
else :
    $sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . " " . $requestData['order'][0]['dir'] . " LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
endif;
//echo $sql;
/* $requestData['order'][1]['column'] contains column index, $requestData['order'][1]['dir'] contains order such as asc/desc  */
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$data = array();
foreach ($dados as $produto) {

    $nestedData = array();
    $nestedData[] = "<input type='checkbox' class='DeleteRow' value='" . $produto->codigo . "'  />";
    $nestedData[] = $produto->codigo;
    $nestedData[] = $produto->ref;
    $nestedData[] = $produto->descricao;
    $nestedData[] = "R$ " . $produto->custo;
    if ($produto->promocao > 0) :
        $nestedData[] = '<label title="Promoção" class="label label-primary" style="font-size: 95%;">R$ ' . number_format($produto->promocao, $parametros->casadecimal, ',', '.') . ' <i class="fa fa-tags"></i></label>';
    else :
        $nestedData[] = "R$ " . number_format(Preco($produto->codigo, $parametros->tbpadrao), $parametros->casadecimal, ',', '.');
    endif;
    $nestedData[] = number_format(Estoque($produto->codigo), $parametros->casadecimal, ',', '.');
    $nestedData[] = $produto->xFant;

    $data[] = $nestedData;
}

$json_data = array(
    "draw" => intval($requestData['draw']), // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
    "recordsTotal" => intval($totalData), // total number of records
    "recordsFiltered" => intval($totalFiltered), // total number of records after searching, if there is no searching then totalFiltered = totalData
    "data" => $data   // total data array
);

//echo '<pre>';
//print_r($json_data);
//echo '</pre>';
echo json_encode($json_data);  // send data as json format
?>
