<?php

//require_once("../../../functions.php");
require_once("../../../_class/Conexao_class.php");
require_once("../../../_class/Crud_class.php");
require_once("../../../_class/parametros.php");

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'produtos');

// storing  request (ie, get/post) global array to a variable  
$requestData = $_REQUEST;

$columns = array(
// datatable column index  => database column name
//    1 => 'cod_produto',
    0 => 'codigo',
    1 => 'codigo',
    2 => 'ref',
    3 => 'descricao',
    4 => 'custo',
    5 => 'estoque'
);

function Total($produto) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT sum(qtd1) as qtd1, sum(qtd2) as qtd2, sum(qtd3) as qtd3, sum(qtd4) as qtd4, sum(qtd5) as qtd5 
        from estoqueprodutos where codproduto = '$produto' ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->qtd1 + $dados->qtd2 + $dados->qtd3 + $dados->qtd4 + $dados->qtd5;
}

function VerificaSolicitacao($produto) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from solicitacao_estoque where produto = '$produto' and empresa = '" . $_SESSION['Empresa'] . "'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->status;
}

function Preco($produto, $tbpadrao) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoque');
    $sql = "SELECT * from precoprodutos where produto = '$produto' and tabela = '$tbpadrao'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->valor;
}

function Estoque($cProd) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoque');
    $sql = "SELECT sum(" . $_SESSION['Estoque'] . ") as total from estoqueprodutos WHERE produto = '" . $cProd . "'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    if ($dados->total != '') :
        return $dados->total;
    else :
        return '0';
    endif;
}

function BuscaVariacaoDesc($prod, $variacao, $sigla, $nivel) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT produtos.variacao, produtos.codigo, 
                    variacao.variacaoid, variacao.var1, variacao.var2, 
                    variacao.var3 ,
                    itensvariacao.variacao, itensvariacao.sigla,
                    itensvariacao.descricao, itensvariacao.nivel
                    FROM produtos 
                    INNER JOIN variacao ON produtos.variacao = variacao.variacaoid 
                    INNER JOIN itensvariacao ON itensvariacao.variacao = variacao.variacaoid                   
                    WHERE codigo = '$prod' 
                    AND itensvariacao.nivel = '$nivel'
                    AND itensvariacao.sigla = '$sigla'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->descricao;
}

//$sql = "SELECT * from produtos ";
$sql = "SELECT produtos.codigo , produtos.ref , produtos.custo , produtos.descricao, 
    estoqueprodutos.produto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
estoqueprodutos.codproduto, estoqueprodutos.estoquemin, estoqueprodutos." . $_SESSION['Estoque'] . " as estoque from produtos
INNER join estoqueprodutos on estoqueprodutos.produto = produtos.codigo where estoqueprodutos.estoquemin >  estoqueprodutos." . $_SESSION['Estoque'] . " ";
$arrayParam = '';
//$sql .= " Where 1=1";
if (!empty($requestData['columns'][1]['search']['value'])) {
    $sql .= " AND codproduto LIKE '%" . $requestData['columns'][1]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][2]['search']['value'])) {
    $sql .= " AND ref LIKE '%" . $requestData['columns'][2]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][3]['search']['value'])) {
    $sql .= " AND descricao LIKE '%" . $requestData['columns'][3]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][4]['search']['value'])) {
    $custo = str_replace(',', '.', $requestData['columns'][4]['search']['value']);
    $sql .= " AND custo LIKE '%" . $custo . "%' ";
}

if (!empty($requestData['columns'][5]['search']['value'])) {
    $sql .= " AND estoque LIKE '%" . $requestData['columns'][5]['search']['value'] . "%' ";
}


$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$totalData = count($dados);
$totalFiltered = $totalData;

if ($requestData['length'] < 0) :
    $sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . " " . $requestData['order'][0]['dir'] . "";
else :
    $sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . " " . $requestData['order'][0]['dir'] . " LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
endif;
/* $requestData['order'][1]['column'] contains column index, $requestData['order'][1]['dir'] contains order such as asc/desc  */
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$data = array();
foreach ($dados as $produto) {
    $nestedData = array();
    $nestedData[] = $produto->codproduto;
    $nestedData[] = $produto->ref;
    $nestedData[] = $produto->descricao;
    $nestedData[] = number_format($produto->estoque, $parametros->casadecimal, ',', '.');
    $nestedData[] = number_format(Total($produto->codproduto) - $produto->estoque, $parametros->casadecimal, ',', '.');
    if (VerificaSolicitacao($produto->codproduto) === 'A') :
        $nestedData[] = '<label class="label label-success"> ACEITO </label>';
    elseif (VerificaSolicitacao($produto->codproduto) === 'C') :
        $nestedData[] = '<label class="label label-danger"> CANCELADO </label>';
    elseif (VerificaSolicitacao($produto->codproduto) === 'P') :
        $nestedData[] = '<label class="label label-warning"> PENDENTE </label>';
    else :
        $nestedData[] = '<button class="btn btn-primary btn-sm" onclick="Solicitar(\'' . $produto->codproduto . '\')"> Solicitar </button>';
    endif;
    $data[] = $nestedData;
}

$json_data = array(
    "draw" => intval($requestData['draw']), // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
    "recordsTotal" => intval($totalData), // total number of records
    "recordsFiltered" => intval($totalFiltered), // total number of records after searching, if there is no searching then totalFiltered = totalData
    "data" => $data   // total data array
);

//echo '<pre>';
//print_r($json_data);
//echo '</pre>';
echo json_encode($json_data);  // send data as json format
?>
