<?php

//require_once("../../../functions.php");
require_once("../../../_class/Conexao_class.php");
require_once("../../../_class/Crud_class.php");

$data = date("Y-m-d");
$data1 = date("Y-m-d", strtotime("-180 days", strtotime($data)));
//echo $data;


//error_reporting(E_ALL);
//ini_set('display_errors', 'On');

function formatarSituacao($situacao) {
    switch($situacao) {
        case 'P':
            return 'Pendente';
        case 'E':
            return 'Em preparo';
        case 'S':
            return 'Saiu para entrega';
        case 'F':
            return 'Finalizado';
        default:
            return 'Desconhecido';
    }
}
   
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'pedido_online');
$requestData = $_REQUEST;
$columns = array(
    0 => 'documento',
    1 => 'documento',
    2 => 'cliente',
    3 => 'valor',
    4 => 'situacao',
    5 => 'tipo',
    6 => 'imprimir'
);

$sql = "SELECT 
        po.documento,
        po.cliente,
        cliente.xNome,
        po.valortotal,
        po.situacao,
        po.tipo_entrega
        from pedido_online po
        JOIN cliente ON cliente.clienteid = po.cliente
        where situacao = 'P' and empresa = '1'";

$arrayParam = '';

if (!empty($requestData['columns'][1]['search']['value'])) {
    $sql .= " AND documento like '%" . $requestData['columns'][1]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][2]['search']['value'])) {
    $sql .= " AND cliente.xNome LIKE '%" . $requestData['columns'][2]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][3]['search']['value'])) {
    $sql .= " AND valortotal LIKE '%" . $requestData['columns'][3]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][4]['search']['value'])) {
    $sql .= " AND situacao LIKE '%" . $requestData['columns'][4]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][5]['search']['value'])) {
    $sql .= " AND tipo_entrega = '" . $requestData['columns'][5]['search']['value'] . "' ";
}

$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
$totalData = count($dados);
$totalFiltered = $totalData;

$sql .= " ORDER BY documento LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
/* $requestData['order'][1]['column'] contains column index, $requestData['order'][1]['dir'] contains order such as asc/desc  */
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

// echo '<pre>';
//     print_r($dados);
// echo '</pre><br>';
// exit();

// echo $sql;
$data = array();
$total = 0;
foreach ($dados as $pedido) {
    
    $nestedData = array();
    $nestedData[] = "<input type='checkbox' class='DeleteRow' value='" . $pedido->documento . "'  />";
    $nestedData[] = $pedido->documento;
    $nestedData[] = $pedido->xNome;
    $nestedData[] = "R$ " . $pedido->valortotal;
    $nestedData[] = formatarSituacao($pedido->situacao);

    if($pedido->tipo_entrega == 'E') {
        $nestedData[] = '<label class="label label-warning" style="font-size: 95%;"> Entrega </label>';
    } else {
        $nestedData[] = '<label class="label label-primary" style="font-size: 95%;"> Retirada </label>';
    }

    $nestedData[] = '<a href="javascript:void(0)" onclick="imprimirPedido(' . $pedido->documento . ')" class="btn btn-default btn-sm"><i class="fa fa-print"></i></a>';

    $total = $total + $pedido->valortotal;

    $data[] = $nestedData;
}

$json_data = array(
    "draw" => intval($requestData['draw']), // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
    "recordsTotal" => intval($totalData), // total number of records
    "recordsFiltered" => intval($totalFiltered), // total number of records after searching, if there is no searching then totalFiltered = totalData
    "data" => $data, // total data array
    "total" => 'R$ ' . number_format($total, 2, ',', '.')
);

//echo '<pre>';
//print_r($json_data);
//echo '</pre>';
echo json_encode($json_data);  // send data as json format
?>
