<?php

//require_once("../../../functions.php");
require_once("../../../_class/Conexao_class.php");
require_once("../../../_class/Crud_class.php");

$data = date("Y-m-d");
$data1 = date("Y-m-d", strtotime("-180 days", strtotime($data)));
//echo $data;


//error_reporting(E_ALL);
//ini_set('display_errors', 'On');

function formatarSituacao($valor) {
    if ($valor == 'A') :
        return '<label class="label label-warning" style="font-size: 95%;"> Aberta </label>';
    elseif ($valor == 'C') :
        return '<label class="label label-danger" style="font-size: 95%;"> Cancelada </label>';
    elseif ($valor == 'E') :
        return '<label class="label label-info" style="font-size: 95%;"> Em preparo </label>';
    elseif ($valor == 'S') :
        return '<label class="label label-primary" style="font-size: 95%;"> Saiu para entrega </label>';
    else :
        return '<label class="label label-success" style="font-size: 95%;"> Fechada </label>';
    endif;
}
   
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'pedido_online');
$requestData = $_REQUEST;
$columns = array(
    0 => 'documento',
    1 => 'documento',
    2 => 'cliente',
    3 => 'valor',
    4 => 'situacao',
    5 => 'tipo',
    6 => 'venda'
);

$sql = "SELECT 
        mo.documento,
        mo.doc_empresa,
        mo.cliente,
        cliente.xNome,
        mo.valortotal,
        mo.situacao,
        po.documento as doc_pedido
        from movimentacao mo
        LEFT JOIN cliente ON cliente.clienteid = mo.cliente
        LEFT JOIN pedido_online po ON mo.pedido_online = po.documento
        where mo.pedido_online is not null and mo.empresa = " . $_SESSION['Empresa'] . " AND po.situacao IN ('E', 'S')";

$arrayParam = '';

if (!empty($requestData['columns'][1]['search']['value'])) {
    $sql .= " AND po.documento like '%" . $requestData['columns'][1]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][2]['search']['value'])) {
    $sql .= " AND cliente.xNome LIKE '%" . $requestData['columns'][2]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][3]['search']['value'])) {
    $sql .= " AND valortotal LIKE '%" . $requestData['columns'][3]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][4]['search']['value'])) {
    $sql .= " AND po.situacao LIKE '%" . $requestData['columns'][4]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][5]['search']['value'])) {
    $sql .= " AND tipo_entrega = '" . $requestData['columns'][5]['search']['value'] . "' ";
}

$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
$totalData = count($dados);
$totalFiltered = $totalData;

$sql .= " ORDER BY po.documento LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
/* $requestData['order'][1]['column'] contains column index, $requestData['order'][1]['dir'] contains order such as asc/desc  */
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

// echo $sql;
$data = array();
foreach ($dados as $pedido) {
    
    $nestedData = array();
    $nestedData[] = "<input type='checkbox' class='DeleteRow' value='" . $pedido->doc_pedido . "'  />";
    $nestedData[] = $pedido->doc_pedido;
    $nestedData[] = $pedido->xNome;
    $nestedData[] = "R$ " . $pedido->valortotal;
    $nestedData[] = formatarSituacao($pedido->situacao);

    $nestedData[] = '';
    $nestedData[] = $pedido->doc_empresa;

    $total = $total + $pedido->valortotal;

    $data[] = $nestedData;
}

$json_data = array(
    "draw" => intval($requestData['draw']), // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
    "recordsTotal" => intval($totalData), // total number of records
    "recordsFiltered" => intval($totalFiltered), // total number of records after searching, if there is no searching then totalFiltered = totalData
    "data" => $data, // total data array
    "total" => 'R$ ' . number_format($total, 2, ',', '.')
);

//echo '<pre>';
//print_r($json_data);
//echo '</pre>';
echo json_encode($json_data);  // send data as json format
?>
