<?php

//require_once("../../../functions.php");
require_once("../../../_class/Conexao_class.php");
require_once("../../../_class/Crud_class.php");
require_once("../../../../_backend/_class/parametros.php");

function Para($valor) {
    return 'Cliente';
}

function VerificaProduto($pedido) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'variacao');
    $sql = "SELECT itpedido.documento, itpedido.produto, 
        estoqueprodutos.codproduto, estoqueprodutos.produto, 
        produtos.codigo, produtos.descricao
        from itpedido 
        inner join estoqueprodutos on estoqueprodutos.codproduto = itpedido.produto
        inner join produtos on estoqueprodutos.produto = produtos.codigo
        WHERE itpedido.documento = '$pedido' LIMIT 1";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

//    echo $sql;
    return $dados->produto.' - '.$dados->descricao;
}

function Situacao($valor) {
    switch ($valor) {
        case 'PE':
            return "<label class='label label-warning' style='font-size: 95%;'>PENDENTE</label>";
            break;
        case 'SE':
            return "<label class='label label-info' style='font-size: 95%;'>SEPARAÇÃO</label>";
            break;
        case 'EX':
            return "<label class='label label-primary' style='font-size: 95%;'>EXPEDIÇÃO</label>";
            break;
        case 'ET':
            return "<label class='label label-primary' style='font-size: 95%;'>ENTREGUE</label>";
            break;
        case 'EP':
            return "<label class='label label-info' style='font-size: 95%;'>ENTREGUE PARCIALMENTE</label>";
            break;
        case 'CO':
            return "<label class='label label-success' style='font-size: 95%;'>CONCLUÍDO</label>";
            break;
        case 'FA':
            return "<label class='label label-success' style='font-size: 95%;'>FATURADO</label>";
            break;
        case 'AF':
            return "<label class='label label-info' style='font-size: 95%;'>AGURADANDO FATURAMENTO</label>";
            break;
        case 'EN':
            return "<label class='label label-primary' style='font-size: 95%;'>ENVIADO</label>";
            break;
        case 'BL':
            return "<label class='label label-danger' style='font-size: 95%;'>BLOQUEADO</label>";
            break;
        case 'SU':
            return "<label class='label label-danger' style='font-size: 95%;'>SUSPENSO</label>";
            break;
        case 'C':
            return "<label class='label label-danger' style='font-size: 95%;'>CANCELADO</label>";
            break;
    }
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'pedidos');

// storing  request (ie, get/post) global array to a variable  
$requestData = $_REQUEST;

$columns = array(
// datatable column index  => database column name
//    1 => 'cod_pedidos',
    1 => 'documento',
    2 => 'data',
    3 => 'previsao',
    4 => 'cliente',
    5 => 'valor',
    6 => 'status',
    7 => 'controle'
);

$sql = "select pedidos.`documento`, pedidos.data, pedidos.previsao, pedidos.controle, pedidos.hora, pedidos.vendedor, 
pedidos.`representante`, pedidos.cliente,  pedidos.motivocancelado,
 pedidos.`valortotal`, pedidos.status, pedidos.empresa, pedidos.doc_empresa,
`representante`.`representanteid`, `representante`.`xNome` as xNomeR, representante.`xFant` as xFantR, 
cliente.`clienteid`, cliente.`xNome` as xNomeC, cliente.`xFant` as xFantC, cliente.`CNPJ` as CNPJ
From `pedidos`
LEFT JOIN `representante` ON `representante`.`representanteid` = `pedidos`.`representante`
LEFT JOIN cliente ON `cliente`.`clienteid` = `pedidos`.`cliente`";
$arrayParam = '';
$sql .= " WHERE 1=1 AND pedidos.empresa = '" . $_SESSION['Empresa'] . "'";

if (!empty($requestData['columns'][1]['search']['value'])) {
    $sql .= " AND doc_empresa LIKE '%" . $requestData['columns'][1]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][2]['search']['value'])) {
    $sql .= " AND data LIKE '%" . $requestData['columns'][2]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][3]['search']['value'])) {
    $sql .= " AND previsao LIKE '%" . $requestData['columns'][3]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][4]['search']['value'])) {
    $sql .= " AND ((cliente.`xNome` LIKE '%" . $requestData['columns'][4]['search']['value'] . "%') OR 
        (cliente.`CNPJ` LIKE '%" . $requestData['columns'][4]['search']['value'] . "%')) ";
}

if (!empty($requestData['columns'][5]['search']['value'])) {
    $sql .= " AND valortotal LIKE '%" . $requestData['columns'][5]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][6]['search']['value'])) {
    $sql .= " AND status LIKE '%" . $requestData['columns'][6]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][7]['search']['value'])) {
    $sql .= " AND controle = '" . $requestData['columns'][7]['search']['value'] . "' ";
}


//echo $sql;
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
$totalData = count($dados);
$totalFiltered = $totalData;

$sql .= " ORDER BY doc_empresa DESC LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
/* $requestData['order'][1]['column'] contains column index, $requestData['order'][1]['dir'] contains order such as asc/desc  */
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//echo $sql;
$total = 0;
$data = array();
foreach ($dados as $pedidos) {

    $nestedData = array();
    $nestedData[] = "<input type='checkbox' class='DeleteRow' value='" . $pedidos->documento . "'  />";
    $nestedData[] = $pedidos->doc_empresa;
    $nestedData[] = $pedidos->data;
    $nestedData[] = $pedidos->previsao;
    if ($pedidos->status == 'C') :
        $nestedData[] = $pedidos->CNPJ . ' - ' . $pedidos->xNomeC . '  <b>(' . $pedidos->motivocancelado . ') </b>';
    else :
        $nestedData[] = $pedidos->CNPJ . ' - ' . $pedidos->xNomeC;
    endif;
    if ($pedidos->valortotal > 0):
        $total = $total + $pedidos->valortotal;
        $nestedData[] = 'R$ ' . number_format($pedidos->valortotal, $parametros->casadecimal, ',', '.');
    else :
        $total = $total + $pedidos->valortotal;
        $nestedData[] = 'R$ ' . number_format($pedidos->valortotal, $parametros->casadecimal, ',', '.');
    endif;
    $nestedData[] = Situacao($pedidos->status);
    $nestedData[] = VerificaProduto($pedidos->documento);
    $nestedData[] = $pedidos->documento;

    $data[] = $nestedData;
}

$json_data = array(
    "draw" => intval($requestData['draw']), // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
    "recordsTotal" => intval($totalData), // total number of records
    "recordsFiltered" => intval($totalFiltered), // total number of records after searching, if there is no searching then totalFiltered = totalData
    "data" => $data, // total data array
    "total" => 'R$ ' . number_format($total, '2', ',', '.')
);

//echo '<pre>';
//print_r($json_data);
//echo '</pre>';
echo json_encode($json_data);  // send data as json format
?>
