<?php

//require_once("../../../functions.php");
require_once("../../../_class/Conexao_class.php");
require_once("../../../_class/Crud_class.php");
require_once("../../../_class/Parametros.php");

function BuscaVariacaoDesc($prod, $variacao, $sigla, $nivel) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT produtos.variacao, produtos.codigo, 
                    variacao.variacaoid, variacao.var1, variacao.var2, 
                    variacao.var3 ,
                    itensvariacao.variacao, itensvariacao.sigla,
                    itensvariacao.descricao, itensvariacao.nivel
                    FROM produtos 
                    INNER JOIN variacao ON produtos.variacao = variacao.variacaoid 
                    INNER JOIN itensvariacao ON itensvariacao.variacao = variacao.variacaoid                                       
                    WHERE codigo = '$prod' 
                    AND itensvariacao.nivel = '$nivel'
                    AND itensvariacao.sigla = '$sigla'";

    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->descricao;
}

function FormataQtd($valor) {
    if (floor($valor) == $valor) :
        return intval($valor);
    else :
        return $valor;
    endif;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'produtos');

// storing  request (ie, get/post) global array to a variable  
$requestData = $_REQUEST;

$columns = array(
// datatable column index  => database column name
//    1 => 'cod_produto',
    0 => 'codproduto',
    1 => 'codproduto',
    2 => 'produto',
    3 => 'ref',
    4 => 'descricao',
    5 => 'var1',
    6 => 'var2',
    7 => 'var3',
    8 => 'qtd',
    9 => 'valor'
);

$sql = "SELECT produtos.codigo , produtos.descricao, produtos.custo,  produtos.ref, estoqueprodutos.produto, 
   produtos.fiscal, produtos.ativo, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
estoqueprodutos.codproduto, estoqueprodutos." . $_SESSION['Estoque'] . " as estoque from produtos
INNER JOIN estoqueprodutos on estoqueprodutos.produto = produtos.codigo
";
$arrayParam = '';
$sql .= " WHERE ativo <> 'N'";

if (!empty($requestData['columns'][1]['search']['value'])) {
    $sql .= " AND codproduto LIKE '%" . $requestData['columns'][1]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][2]['search']['value'])) {
    $sql .= " AND produto LIKE '%" . $requestData['columns'][2]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][3]['search']['value'])) {
    $sql .= " AND produtos.ref LIKE '%" . $requestData['columns'][3]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][4]['search']['value'])) {
    $termos = explode(' ', $requestData['columns'][4]['search']['value']); // Divide a busca em palavras
    foreach ($termos as $termo) {
        $sql .= " AND descricao LIKE '%" . $termo . "%' ";
    }
}

if (!empty($requestData['columns'][5]['search']['value'])) {
    $sql .= " AND var1 LIKE '%" . $requestData['columns'][5]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][6]['search']['value'])) {
    $sql .= " AND var2 LIKE '%" . $requestData['columns'][6]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][7]['search']['value'])) {
    $sql .= " AND var3 LIKE '%" . $requestData['columns'][7]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][8]['search']['value'])) {
    $sql .= " AND " . $_SESSION['Estoque'] . " LIKE '%" . $requestData['columns'][8]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][9]['search']['value'])) {
    $valorv = str_replace(',', '.', $requestData['columns'][9]['search']['value']);
    $sql .= " AND custo LIKE '%" . $valorv . "%' ";
}

if ($parametros->separaprodutos == 'S') :
    $sql .= " AND produtos.fiscal = '$parametros->fiscal'";
endif;

$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$totalData = count($dados);
$totalFiltered = $totalData;

$sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . " " . $requestData['order'][0]['dir'] . " LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";

//$sql.=" ORDER BY codigo ASC LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
/* $requestData['order'][1]['column'] contains column index, $requestData['order'][1]['dir'] contains order such as asc/desc  */
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//echo $sql;

$data = array();
foreach ($dados as $produto) {

    $nestedData = array();
    $nestedData[] = "<input type='checkbox' class='DeleteRow' id='" . $produto->codproduto . "' value='" . $produto->codproduto . "'  onclick=' SetSel(this);' />";
    $nestedData[] = $produto->codproduto;
    $nestedData[] = $produto->produto;
    $nestedData[] = $produto->ref;
    $nestedData[] = $produto->descricao;
    $nestedData[] = $produto->var1 . ' - ' . BuscaVariacaoDesc($produto->produto, '1', $produto->var1, '1');
    $nestedData[] = $produto->var2 . ' - ' . BuscaVariacaoDesc($produto->produto, '2', $produto->var2, '2');
    $nestedData[] = $produto->var3 . ' - ' . BuscaVariacaoDesc($produto->produto, '3', $produto->var3, '3');
    $nestedData[] = FormataQtd($produto->estoque);
    $nestedData[] = 'R$ ' . number_format($produto->custo, $parametros->casadecimal, ',', '.');
    $data[] = $nestedData;
}

$json_data = array(
    "draw" => intval($requestData['draw']), // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
    "recordsTotal" => intval($totalData), // total number of records
    "recordsFiltered" => intval($totalFiltered), // total number of records after searching, if there is no searching then totalFiltered = totalData
    "data" => $data   // total data array
);

//echo '<pre>';
//print_r($json_data);
//echo '</pre>';
echo json_encode($json_data);  // send data as json format
?>
